/**
 * @licstart The following is the entire license notice for the
 * JavaScript code in this page
 *
 * Copyright 2024 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @licend The above is the entire license notice for the
 * JavaScript code in this page
 */

/**
 * pdfjsVersion = 5.3.754
 * pdfjsBuild = b9bd95d13
 */
/******/ var __webpack_modules__ = ({

/***/ 34:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var isCallable = __webpack_require__(4901);

module.exports = function (it) {
  return typeof it == 'object' ? it !== null : isCallable(it);
};


/***/ }),

/***/ 81:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var call = __webpack_require__(9565);
var aCallable = __webpack_require__(9306);
var anObject = __webpack_require__(8551);
var tryToString = __webpack_require__(6823);
var getIteratorMethod = __webpack_require__(851);

var $TypeError = TypeError;

module.exports = function (argument, usingIterator) {
  var iteratorMethod = arguments.length < 2 ? getIteratorMethod(argument) : usingIterator;
  if (aCallable(iteratorMethod)) return anObject(call(iteratorMethod, argument));
  throw new $TypeError(tryToString(argument) + ' is not iterable');
};


/***/ }),

/***/ 116:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {


var $ = __webpack_require__(6518);
var call = __webpack_require__(9565);
var iterate = __webpack_require__(2652);
var aCallable = __webpack_require__(9306);
var anObject = __webpack_require__(8551);
var getIteratorDirect = __webpack_require__(1767);
var iteratorClose = __webpack_require__(9539);
var iteratorHelperWithoutClosingOnEarlyError = __webpack_require__(4549);

var findWithoutClosingOnEarlyError = iteratorHelperWithoutClosingOnEarlyError('find', TypeError);

// `Iterator.prototype.find` method
// https://tc39.es/ecma262/#sec-iterator.prototype.find
$({ target: 'Iterator', proto: true, real: true, forced: findWithoutClosingOnEarlyError }, {
  find: function find(predicate) {
    anObject(this);
    try {
      aCallable(predicate);
    } catch (error) {
      iteratorClose(this, 'throw', error);
    }

    if (findWithoutClosingOnEarlyError) return call(findWithoutClosingOnEarlyError, this, predicate);

    var record = getIteratorDirect(this);
    var counter = 0;
    return iterate(record, function (value, stop) {
      if (predicate(value, counter++)) return stop(value);
    }, { IS_RECORD: true, INTERRUPTED: true }).result;
  }
});


/***/ }),

/***/ 283:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var uncurryThis = __webpack_require__(9504);
var fails = __webpack_require__(9039);
var isCallable = __webpack_require__(4901);
var hasOwn = __webpack_require__(9297);
var DESCRIPTORS = __webpack_require__(3724);
var CONFIGURABLE_FUNCTION_NAME = (__webpack_require__(350).CONFIGURABLE);
var inspectSource = __webpack_require__(3706);
var InternalStateModule = __webpack_require__(1181);

var enforceInternalState = InternalStateModule.enforce;
var getInternalState = InternalStateModule.get;
var $String = String;
// eslint-disable-next-line es/no-object-defineproperty -- safe
var defineProperty = Object.defineProperty;
var stringSlice = uncurryThis(''.slice);
var replace = uncurryThis(''.replace);
var join = uncurryThis([].join);

var CONFIGURABLE_LENGTH = DESCRIPTORS && !fails(function () {
  return defineProperty(function () { /* empty */ }, 'length', { value: 8 }).length !== 8;
});

var TEMPLATE = String(String).split('String');

var makeBuiltIn = module.exports = function (value, name, options) {
  if (stringSlice($String(name), 0, 7) === 'Symbol(') {
    name = '[' + replace($String(name), /^Symbol\(([^)]*)\).*$/, '$1') + ']';
  }
  if (options && options.getter) name = 'get ' + name;
  if (options && options.setter) name = 'set ' + name;
  if (!hasOwn(value, 'name') || (CONFIGURABLE_FUNCTION_NAME && value.name !== name)) {
    if (DESCRIPTORS) defineProperty(value, 'name', { value: name, configurable: true });
    else value.name = name;
  }
  if (CONFIGURABLE_LENGTH && options && hasOwn(options, 'arity') && value.length !== options.arity) {
    defineProperty(value, 'length', { value: options.arity });
  }
  try {
    if (options && hasOwn(options, 'constructor') && options.constructor) {
      if (DESCRIPTORS) defineProperty(value, 'prototype', { writable: false });
    // in V8 ~ Chrome 53, prototypes of some methods, like `Array.prototype.values`, are non-writable
    } else if (value.prototype) value.prototype = undefined;
  } catch (error) { /* empty */ }
  var state = enforceInternalState(value);
  if (!hasOwn(state, 'source')) {
    state.source = join(TEMPLATE, typeof name == 'string' ? name : '');
  } return value;
};

// add fake Function#toString for correct work wrapped methods / constructors with methods like LoDash isNative
// eslint-disable-next-line no-extend-native -- required
Function.prototype.toString = makeBuiltIn(function toString() {
  return isCallable(this) && getInternalState(this).source || inspectSource(this);
}, 'toString');


/***/ }),

/***/ 350:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var DESCRIPTORS = __webpack_require__(3724);
var hasOwn = __webpack_require__(9297);

var FunctionPrototype = Function.prototype;
// eslint-disable-next-line es/no-object-getownpropertydescriptor -- safe
var getDescriptor = DESCRIPTORS && Object.getOwnPropertyDescriptor;

var EXISTS = hasOwn(FunctionPrototype, 'name');
// additional protection from minified / mangled / dropped function names
var PROPER = EXISTS && (function something() { /* empty */ }).name === 'something';
var CONFIGURABLE = EXISTS && (!DESCRIPTORS || (DESCRIPTORS && getDescriptor(FunctionPrototype, 'name').configurable));

module.exports = {
  EXISTS: EXISTS,
  PROPER: PROPER,
  CONFIGURABLE: CONFIGURABLE
};


/***/ }),

/***/ 373:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {


var globalThis = __webpack_require__(4576);
var uncurryThis = __webpack_require__(7476);
var fails = __webpack_require__(9039);
var aCallable = __webpack_require__(9306);
var internalSort = __webpack_require__(4488);
var ArrayBufferViewCore = __webpack_require__(4644);
var FF = __webpack_require__(3709);
var IE_OR_EDGE = __webpack_require__(3763);
var V8 = __webpack_require__(9519);
var WEBKIT = __webpack_require__(3607);

var aTypedArray = ArrayBufferViewCore.aTypedArray;
var exportTypedArrayMethod = ArrayBufferViewCore.exportTypedArrayMethod;
var Uint16Array = globalThis.Uint16Array;
var nativeSort = Uint16Array && uncurryThis(Uint16Array.prototype.sort);

// WebKit
var ACCEPT_INCORRECT_ARGUMENTS = !!nativeSort && !(fails(function () {
  nativeSort(new Uint16Array(2), null);
}) && fails(function () {
  nativeSort(new Uint16Array(2), {});
}));

var STABLE_SORT = !!nativeSort && !fails(function () {
  // feature detection can be too slow, so check engines versions
  if (V8) return V8 < 74;
  if (FF) return FF < 67;
  if (IE_OR_EDGE) return true;
  if (WEBKIT) return WEBKIT < 602;

  var array = new Uint16Array(516);
  var expected = Array(516);
  var index, mod;

  for (index = 0; index < 516; index++) {
    mod = index % 4;
    array[index] = 515 - index;
    expected[index] = index - 2 * mod + 3;
  }

  nativeSort(array, function (a, b) {
    return (a / 4 | 0) - (b / 4 | 0);
  });

  for (index = 0; index < 516; index++) {
    if (array[index] !== expected[index]) return true;
  }
});

var getSortCompare = function (comparefn) {
  return function (x, y) {
    if (comparefn !== undefined) return +comparefn(x, y) || 0;
    // eslint-disable-next-line no-self-compare -- NaN check
    if (y !== y) return -1;
    // eslint-disable-next-line no-self-compare -- NaN check
    if (x !== x) return 1;
    if (x === 0 && y === 0) return 1 / x > 0 && 1 / y < 0 ? 1 : -1;
    return x > y;
  };
};

// `%TypedArray%.prototype.sort` method
// https://tc39.es/ecma262/#sec-%typedarray%.prototype.sort
exportTypedArrayMethod('sort', function sort(comparefn) {
  if (comparefn !== undefined) aCallable(comparefn);
  if (STABLE_SORT) return nativeSort(this, comparefn);

  return internalSort(aTypedArray(this), getSortCompare(comparefn));
}, !STABLE_SORT || ACCEPT_INCORRECT_ARGUMENTS);


/***/ }),

/***/ 397:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var getBuiltIn = __webpack_require__(7751);

module.exports = getBuiltIn('document', 'documentElement');


/***/ }),

/***/ 421:
/***/ ((module) => {


module.exports = {};


/***/ }),

/***/ 507:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var call = __webpack_require__(9565);

module.exports = function (record, fn, ITERATOR_INSTEAD_OF_RECORD) {
  var iterator = ITERATOR_INSTEAD_OF_RECORD ? record : record.iterator;
  var next = record.next;
  var step, result;
  while (!(step = call(next, iterator)).done) {
    result = fn(step.value);
    if (result !== undefined) return result;
  }
};


/***/ }),

/***/ 531:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {


var $ = __webpack_require__(6518);
var call = __webpack_require__(9565);
var aCallable = __webpack_require__(9306);
var anObject = __webpack_require__(8551);
var getIteratorDirect = __webpack_require__(1767);
var getIteratorFlattenable = __webpack_require__(8646);
var createIteratorProxy = __webpack_require__(9462);
var iteratorClose = __webpack_require__(9539);
var IS_PURE = __webpack_require__(6395);
var iteratorHelperThrowsOnInvalidIterator = __webpack_require__(684);
var iteratorHelperWithoutClosingOnEarlyError = __webpack_require__(4549);

var FLAT_MAP_WITHOUT_THROWING_ON_INVALID_ITERATOR = !IS_PURE
  && !iteratorHelperThrowsOnInvalidIterator('flatMap', function () { /* empty */ });
var flatMapWithoutClosingOnEarlyError = !IS_PURE && !FLAT_MAP_WITHOUT_THROWING_ON_INVALID_ITERATOR
  && iteratorHelperWithoutClosingOnEarlyError('flatMap', TypeError);

var FORCED = IS_PURE || FLAT_MAP_WITHOUT_THROWING_ON_INVALID_ITERATOR || flatMapWithoutClosingOnEarlyError;

var IteratorProxy = createIteratorProxy(function () {
  var iterator = this.iterator;
  var mapper = this.mapper;
  var result, inner;

  while (true) {
    if (inner = this.inner) try {
      result = anObject(call(inner.next, inner.iterator));
      if (!result.done) return result.value;
      this.inner = null;
    } catch (error) { iteratorClose(iterator, 'throw', error); }

    result = anObject(call(this.next, iterator));

    if (this.done = !!result.done) return;

    try {
      this.inner = getIteratorFlattenable(mapper(result.value, this.counter++), false);
    } catch (error) { iteratorClose(iterator, 'throw', error); }
  }
});

// `Iterator.prototype.flatMap` method
// https://tc39.es/ecma262/#sec-iterator.prototype.flatmap
$({ target: 'Iterator', proto: true, real: true, forced: FORCED }, {
  flatMap: function flatMap(mapper) {
    anObject(this);
    try {
      aCallable(mapper);
    } catch (error) {
      iteratorClose(this, 'throw', error);
    }

    if (flatMapWithoutClosingOnEarlyError) return call(flatMapWithoutClosingOnEarlyError, this, mapper);

    return new IteratorProxy(getIteratorDirect(this), {
      mapper: mapper,
      inner: null
    });
  }
});


/***/ }),

/***/ 616:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var fails = __webpack_require__(9039);

module.exports = !fails(function () {
  // eslint-disable-next-line es/no-function-prototype-bind -- safe
  var test = (function () { /* empty */ }).bind();
  // eslint-disable-next-line no-prototype-builtins -- safe
  return typeof test != 'function' || test.hasOwnProperty('prototype');
});


/***/ }),

/***/ 655:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var classof = __webpack_require__(6955);

var $String = String;

module.exports = function (argument) {
  if (classof(argument) === 'Symbol') throw new TypeError('Cannot convert a Symbol value to a string');
  return $String(argument);
};


/***/ }),

/***/ 679:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var isPrototypeOf = __webpack_require__(1625);

var $TypeError = TypeError;

module.exports = function (it, Prototype) {
  if (isPrototypeOf(Prototype, it)) return it;
  throw new $TypeError('Incorrect invocation');
};


/***/ }),

/***/ 684:
/***/ ((module) => {


// Should throw an error on invalid iterator
// https://issues.chromium.org/issues/336839115
module.exports = function (methodName, argument) {
  // eslint-disable-next-line es/no-iterator -- required for testing
  var method = typeof Iterator == 'function' && Iterator.prototype[methodName];
  if (method) try {
    method.call({ next: null }, argument).next();
  } catch (error) {
    return true;
  }
};


/***/ }),

/***/ 741:
/***/ ((module) => {


var ceil = Math.ceil;
var floor = Math.floor;

// `Math.trunc` method
// https://tc39.es/ecma262/#sec-math.trunc
// eslint-disable-next-line es/no-math-trunc -- safe
module.exports = Math.trunc || function trunc(x) {
  var n = +x;
  return (n > 0 ? floor : ceil)(n);
};


/***/ }),

/***/ 747:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var createNonEnumerableProperty = __webpack_require__(6699);
var clearErrorStack = __webpack_require__(6193);
var ERROR_STACK_INSTALLABLE = __webpack_require__(4659);

// non-standard V8
// eslint-disable-next-line es/no-nonstandard-error-properties -- safe
var captureStackTrace = Error.captureStackTrace;

module.exports = function (error, C, stack, dropEntries) {
  if (ERROR_STACK_INSTALLABLE) {
    if (captureStackTrace) captureStackTrace(error, C);
    else createNonEnumerableProperty(error, 'stack', clearErrorStack(stack, dropEntries));
  }
};


/***/ }),

/***/ 757:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var getBuiltIn = __webpack_require__(7751);
var isCallable = __webpack_require__(4901);
var isPrototypeOf = __webpack_require__(1625);
var USE_SYMBOL_AS_UID = __webpack_require__(7040);

var $Object = Object;

module.exports = USE_SYMBOL_AS_UID ? function (it) {
  return typeof it == 'symbol';
} : function (it) {
  var $Symbol = getBuiltIn('Symbol');
  return isCallable($Symbol) && isPrototypeOf($Symbol.prototype, $Object(it));
};


/***/ }),

/***/ 851:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var classof = __webpack_require__(6955);
var getMethod = __webpack_require__(5966);
var isNullOrUndefined = __webpack_require__(4117);
var Iterators = __webpack_require__(6269);
var wellKnownSymbol = __webpack_require__(8227);

var ITERATOR = wellKnownSymbol('iterator');

module.exports = function (it) {
  if (!isNullOrUndefined(it)) return getMethod(it, ITERATOR)
    || getMethod(it, '@@iterator')
    || Iterators[classof(it)];
};


/***/ }),

/***/ 944:
/***/ ((module) => {


var $TypeError = TypeError;

module.exports = function (options) {
  var alphabet = options && options.alphabet;
  if (alphabet === undefined || alphabet === 'base64' || alphabet === 'base64url') return alphabet || 'base64';
  throw new $TypeError('Incorrect `alphabet` option');
};


/***/ }),

/***/ 1056:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var defineProperty = (__webpack_require__(4913).f);

module.exports = function (Target, Source, key) {
  key in Target || defineProperty(Target, key, {
    configurable: true,
    get: function () { return Source[key]; },
    set: function (it) { Source[key] = it; }
  });
};


/***/ }),

/***/ 1072:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var internalObjectKeys = __webpack_require__(1828);
var enumBugKeys = __webpack_require__(8727);

// `Object.keys` method
// https://tc39.es/ecma262/#sec-object.keys
// eslint-disable-next-line es/no-object-keys -- safe
module.exports = Object.keys || function keys(O) {
  return internalObjectKeys(O, enumBugKeys);
};


/***/ }),

/***/ 1103:
/***/ ((module) => {


module.exports = function (exec) {
  try {
    return { error: false, value: exec() };
  } catch (error) {
    return { error: true, value: error };
  }
};


/***/ }),

/***/ 1108:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var classof = __webpack_require__(6955);

module.exports = function (it) {
  var klass = classof(it);
  return klass === 'BigInt64Array' || klass === 'BigUint64Array';
};


/***/ }),

/***/ 1134:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {


var ArrayBufferViewCore = __webpack_require__(4644);
var $findLastIndex = (__webpack_require__(3839).findLastIndex);

var aTypedArray = ArrayBufferViewCore.aTypedArray;
var exportTypedArrayMethod = ArrayBufferViewCore.exportTypedArrayMethod;

// `%TypedArray%.prototype.findLastIndex` method
// https://tc39.es/ecma262/#sec-%typedarray%.prototype.findlastindex
exportTypedArrayMethod('findLastIndex', function findLastIndex(predicate /* , thisArg */) {
  return $findLastIndex(aTypedArray(this), predicate, arguments.length > 1 ? arguments[1] : undefined);
});


/***/ }),

/***/ 1148:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {


var $ = __webpack_require__(6518);
var call = __webpack_require__(9565);
var iterate = __webpack_require__(2652);
var aCallable = __webpack_require__(9306);
var anObject = __webpack_require__(8551);
var getIteratorDirect = __webpack_require__(1767);
var iteratorClose = __webpack_require__(9539);
var iteratorHelperWithoutClosingOnEarlyError = __webpack_require__(4549);

var everyWithoutClosingOnEarlyError = iteratorHelperWithoutClosingOnEarlyError('every', TypeError);

// `Iterator.prototype.every` method
// https://tc39.es/ecma262/#sec-iterator.prototype.every
$({ target: 'Iterator', proto: true, real: true, forced: everyWithoutClosingOnEarlyError }, {
  every: function every(predicate) {
    anObject(this);
    try {
      aCallable(predicate);
    } catch (error) {
      iteratorClose(this, 'throw', error);
    }

    if (everyWithoutClosingOnEarlyError) return call(everyWithoutClosingOnEarlyError, this, predicate);

    var record = getIteratorDirect(this);
    var counter = 0;
    return !iterate(record, function (value, stop) {
      if (!predicate(value, counter++)) return stop();
    }, { IS_RECORD: true, INTERRUPTED: true }).stopped;
  }
});


/***/ }),

/***/ 1181:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var NATIVE_WEAK_MAP = __webpack_require__(8622);
var globalThis = __webpack_require__(4576);
var isObject = __webpack_require__(34);
var createNonEnumerableProperty = __webpack_require__(6699);
var hasOwn = __webpack_require__(9297);
var shared = __webpack_require__(7629);
var sharedKey = __webpack_require__(6119);
var hiddenKeys = __webpack_require__(421);

var OBJECT_ALREADY_INITIALIZED = 'Object already initialized';
var TypeError = globalThis.TypeError;
var WeakMap = globalThis.WeakMap;
var set, get, has;

var enforce = function (it) {
  return has(it) ? get(it) : set(it, {});
};

var getterFor = function (TYPE) {
  return function (it) {
    var state;
    if (!isObject(it) || (state = get(it)).type !== TYPE) {
      throw new TypeError('Incompatible receiver, ' + TYPE + ' required');
    } return state;
  };
};

if (NATIVE_WEAK_MAP || shared.state) {
  var store = shared.state || (shared.state = new WeakMap());
  /* eslint-disable no-self-assign -- prototype methods protection */
  store.get = store.get;
  store.has = store.has;
  store.set = store.set;
  /* eslint-enable no-self-assign -- prototype methods protection */
  set = function (it, metadata) {
    if (store.has(it)) throw new TypeError(OBJECT_ALREADY_INITIALIZED);
    metadata.facade = it;
    store.set(it, metadata);
    return metadata;
  };
  get = function (it) {
    return store.get(it) || {};
  };
  has = function (it) {
    return store.has(it);
  };
} else {
  var STATE = sharedKey('state');
  hiddenKeys[STATE] = true;
  set = function (it, metadata) {
    if (hasOwn(it, STATE)) throw new TypeError(OBJECT_ALREADY_INITIALIZED);
    metadata.facade = it;
    createNonEnumerableProperty(it, STATE, metadata);
    return metadata;
  };
  get = function (it) {
    return hasOwn(it, STATE) ? it[STATE] : {};
  };
  has = function (it) {
    return hasOwn(it, STATE);
  };
}

module.exports = {
  set: set,
  get: get,
  has: has,
  enforce: enforce,
  getterFor: getterFor
};


/***/ }),

/***/ 1291:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var trunc = __webpack_require__(741);

// `ToIntegerOrInfinity` abstract operation
// https://tc39.es/ecma262/#sec-tointegerorinfinity
module.exports = function (argument) {
  var number = +argument;
  // eslint-disable-next-line no-self-compare -- NaN check
  return number !== number || number === 0 ? 0 : trunc(number);
};


/***/ }),

/***/ 1385:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var iteratorClose = __webpack_require__(9539);

module.exports = function (iters, kind, value) {
  for (var i = iters.length - 1; i >= 0; i--) {
    if (iters[i] === undefined) continue;
    try {
      value = iteratorClose(iters[i].iterator, kind, value);
    } catch (error) {
      kind = 'throw';
      value = error;
    }
  }
  if (kind === 'throw') throw value;
  return value;
};


/***/ }),

/***/ 1548:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var globalThis = __webpack_require__(4576);
var fails = __webpack_require__(9039);
var V8 = __webpack_require__(9519);
var ENVIRONMENT = __webpack_require__(4215);

var structuredClone = globalThis.structuredClone;

module.exports = !!structuredClone && !fails(function () {
  // prevent V8 ArrayBufferDetaching protector cell invalidation and performance degradation
  // https://github.com/zloirock/core-js/issues/679
  if ((ENVIRONMENT === 'DENO' && V8 > 92) || (ENVIRONMENT === 'NODE' && V8 > 94) || (ENVIRONMENT === 'BROWSER' && V8 > 97)) return false;
  var buffer = new ArrayBuffer(8);
  var clone = structuredClone(buffer, { transfer: [buffer] });
  return buffer.byteLength !== 0 || clone.byteLength !== 8;
});


/***/ }),

/***/ 1549:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {


var $ = __webpack_require__(6518);
var globalThis = __webpack_require__(4576);
var $fromBase64 = __webpack_require__(9143);
var anUint8Array = __webpack_require__(4154);

var Uint8Array = globalThis.Uint8Array;

var INCORRECT_BEHAVIOR_OR_DOESNT_EXISTS = !Uint8Array || !Uint8Array.prototype.setFromBase64 || !(function () {
  var target = new Uint8Array([255, 255, 255, 255, 255]);
  try {
    target.setFromBase64('MjYyZg===');
  } catch (error) {
    return target[0] === 50 && target[1] === 54 && target[2] === 50 && target[3] === 255 && target[4] === 255;
  }
})();

// `Uint8Array.prototype.setFromBase64` method
// https://github.com/tc39/proposal-arraybuffer-base64
if (Uint8Array) $({ target: 'Uint8Array', proto: true, forced: INCORRECT_BEHAVIOR_OR_DOESNT_EXISTS }, {
  setFromBase64: function setFromBase64(string /* , options */) {
    anUint8Array(this);

    var result = $fromBase64(string, arguments.length > 1 ? arguments[1] : undefined, this, this.length);

    return { read: result.read, written: result.written };
  }
});


/***/ }),

/***/ 1625:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var uncurryThis = __webpack_require__(9504);

module.exports = uncurryThis({}.isPrototypeOf);


/***/ }),

/***/ 1689:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {


var $ = __webpack_require__(6518);
var globalThis = __webpack_require__(4576);
var apply = __webpack_require__(8745);
var slice = __webpack_require__(7680);
var newPromiseCapabilityModule = __webpack_require__(6043);
var aCallable = __webpack_require__(9306);
var perform = __webpack_require__(1103);

var Promise = globalThis.Promise;

var ACCEPT_ARGUMENTS = false;
// Avoiding the use of polyfills of the previous iteration of this proposal
// that does not accept arguments of the callback
var FORCED = !Promise || !Promise['try'] || perform(function () {
  Promise['try'](function (argument) {
    ACCEPT_ARGUMENTS = argument === 8;
  }, 8);
}).error || !ACCEPT_ARGUMENTS;

// `Promise.try` method
// https://tc39.es/ecma262/#sec-promise.try
$({ target: 'Promise', stat: true, forced: FORCED }, {
  'try': function (callbackfn /* , ...args */) {
    var args = arguments.length > 1 ? slice(arguments, 1) : [];
    var promiseCapability = newPromiseCapabilityModule.f(this);
    var result = perform(function () {
      return apply(aCallable(callbackfn), undefined, args);
    });
    (result.error ? promiseCapability.reject : promiseCapability.resolve)(result.value);
    return promiseCapability.promise;
  }
});


/***/ }),

/***/ 1698:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {


var $ = __webpack_require__(6518);
var union = __webpack_require__(4204);
var setMethodGetKeysBeforeCloning = __webpack_require__(9835);
var setMethodAcceptSetLike = __webpack_require__(4916);

var FORCED = !setMethodAcceptSetLike('union') || !setMethodGetKeysBeforeCloning('union');

// `Set.prototype.union` method
// https://tc39.es/ecma262/#sec-set.prototype.union
$({ target: 'Set', proto: true, real: true, forced: FORCED }, {
  union: union
});


/***/ }),

/***/ 1701:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {


var $ = __webpack_require__(6518);
var call = __webpack_require__(9565);
var aCallable = __webpack_require__(9306);
var anObject = __webpack_require__(8551);
var getIteratorDirect = __webpack_require__(1767);
var createIteratorProxy = __webpack_require__(9462);
var callWithSafeIterationClosing = __webpack_require__(6319);
var iteratorClose = __webpack_require__(9539);
var iteratorHelperThrowsOnInvalidIterator = __webpack_require__(684);
var iteratorHelperWithoutClosingOnEarlyError = __webpack_require__(4549);
var IS_PURE = __webpack_require__(6395);

var MAP_WITHOUT_THROWING_ON_INVALID_ITERATOR = !IS_PURE && !iteratorHelperThrowsOnInvalidIterator('map', function () { /* empty */ });
var mapWithoutClosingOnEarlyError = !IS_PURE && !MAP_WITHOUT_THROWING_ON_INVALID_ITERATOR
  && iteratorHelperWithoutClosingOnEarlyError('map', TypeError);

var FORCED = IS_PURE || MAP_WITHOUT_THROWING_ON_INVALID_ITERATOR || mapWithoutClosingOnEarlyError;

var IteratorProxy = createIteratorProxy(function () {
  var iterator = this.iterator;
  var result = anObject(call(this.next, iterator));
  var done = this.done = !!result.done;
  if (!done) return callWithSafeIterationClosing(iterator, this.mapper, [result.value, this.counter++], true);
});

// `Iterator.prototype.map` method
// https://tc39.es/ecma262/#sec-iterator.prototype.map
$({ target: 'Iterator', proto: true, real: true, forced: FORCED }, {
  map: function map(mapper) {
    anObject(this);
    try {
      aCallable(mapper);
    } catch (error) {
      iteratorClose(this, 'throw', error);
    }

    if (mapWithoutClosingOnEarlyError) return call(mapWithoutClosingOnEarlyError, this, mapper);

    return new IteratorProxy(getIteratorDirect(this), {
      mapper: mapper
    });
  }
});


/***/ }),

/***/ 1767:
/***/ ((module) => {


// `GetIteratorDirect(obj)` abstract operation
// https://tc39.es/proposal-iterator-helpers/#sec-getiteratordirect
module.exports = function (obj) {
  return {
    iterator: obj,
    next: obj.next,
    done: false
  };
};


/***/ }),

/***/ 1828:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var uncurryThis = __webpack_require__(9504);
var hasOwn = __webpack_require__(9297);
var toIndexedObject = __webpack_require__(5397);
var indexOf = (__webpack_require__(9617).indexOf);
var hiddenKeys = __webpack_require__(421);

var push = uncurryThis([].push);

module.exports = function (object, names) {
  var O = toIndexedObject(object);
  var i = 0;
  var result = [];
  var key;
  for (key in O) !hasOwn(hiddenKeys, key) && hasOwn(O, key) && push(result, key);
  // Don't enum bug & hidden keys
  while (names.length > i) if (hasOwn(O, key = names[i++])) {
    ~indexOf(result, key) || push(result, key);
  }
  return result;
};


/***/ }),

/***/ 1903:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {


var ArrayBufferViewCore = __webpack_require__(4644);
var $findLast = (__webpack_require__(3839).findLast);

var aTypedArray = ArrayBufferViewCore.aTypedArray;
var exportTypedArrayMethod = ArrayBufferViewCore.exportTypedArrayMethod;

// `%TypedArray%.prototype.findLast` method
// https://tc39.es/ecma262/#sec-%typedarray%.prototype.findlast
exportTypedArrayMethod('findLast', function findLast(predicate /* , thisArg */) {
  return $findLast(aTypedArray(this), predicate, arguments.length > 1 ? arguments[1] : undefined);
});


/***/ }),

/***/ 2106:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var makeBuiltIn = __webpack_require__(283);
var defineProperty = __webpack_require__(4913);

module.exports = function (target, name, descriptor) {
  if (descriptor.get) makeBuiltIn(descriptor.get, name, { getter: true });
  if (descriptor.set) makeBuiltIn(descriptor.set, name, { setter: true });
  return defineProperty.f(target, name, descriptor);
};


/***/ }),

/***/ 2140:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var wellKnownSymbol = __webpack_require__(8227);

var TO_STRING_TAG = wellKnownSymbol('toStringTag');
var test = {};

test[TO_STRING_TAG] = 'z';

module.exports = String(test) === '[object z]';


/***/ }),

/***/ 2195:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var uncurryThis = __webpack_require__(9504);

var toString = uncurryThis({}.toString);
var stringSlice = uncurryThis(''.slice);

module.exports = function (it) {
  return stringSlice(toString(it), 8, -1);
};


/***/ }),

/***/ 2211:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var fails = __webpack_require__(9039);

module.exports = !fails(function () {
  function F() { /* empty */ }
  F.prototype.constructor = null;
  // eslint-disable-next-line es/no-object-getprototypeof -- required for testing
  return Object.getPrototypeOf(new F()) !== F.prototype;
});


/***/ }),

/***/ 2222:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {


var $ = __webpack_require__(6518);
var getBuiltIn = __webpack_require__(7751);
var fails = __webpack_require__(9039);
var validateArgumentsLength = __webpack_require__(2812);
var toString = __webpack_require__(655);
var USE_NATIVE_URL = __webpack_require__(7416);

var URL = getBuiltIn('URL');

// https://github.com/nodejs/node/issues/47505
// https://github.com/denoland/deno/issues/18893
var THROWS_WITHOUT_ARGUMENTS = USE_NATIVE_URL && fails(function () {
  URL.canParse();
});

// Bun ~ 1.0.30 bug
// https://github.com/oven-sh/bun/issues/9250
var WRONG_ARITY = fails(function () {
  return URL.canParse.length !== 1;
});

// `URL.canParse` method
// https://url.spec.whatwg.org/#dom-url-canparse
$({ target: 'URL', stat: true, forced: !THROWS_WITHOUT_ARGUMENTS || WRONG_ARITY }, {
  canParse: function canParse(url) {
    var length = validateArgumentsLength(arguments.length, 1);
    var urlString = toString(url);
    var base = length < 2 || arguments[1] === undefined ? undefined : toString(arguments[1]);
    try {
      return !!new URL(urlString, base);
    } catch (error) {
      return false;
    }
  }
});


/***/ }),

/***/ 2278:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var DESCRIPTORS = __webpack_require__(3724);
var definePropertyModule = __webpack_require__(4913);
var createPropertyDescriptor = __webpack_require__(6980);

module.exports = function (object, key, value) {
  if (DESCRIPTORS) definePropertyModule.f(object, key, createPropertyDescriptor(0, value));
  else object[key] = value;
};


/***/ }),

/***/ 2303:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var globalThis = __webpack_require__(4576);
var uncurryThis = __webpack_require__(9504);

var Uint8Array = globalThis.Uint8Array;
var SyntaxError = globalThis.SyntaxError;
var parseInt = globalThis.parseInt;
var min = Math.min;
var NOT_HEX = /[^\da-f]/i;
var exec = uncurryThis(NOT_HEX.exec);
var stringSlice = uncurryThis(''.slice);

module.exports = function (string, into) {
  var stringLength = string.length;
  if (stringLength % 2 !== 0) throw new SyntaxError('String should be an even number of characters');
  var maxLength = into ? min(into.length, stringLength / 2) : stringLength / 2;
  var bytes = into || new Uint8Array(maxLength);
  var read = 0;
  var written = 0;
  while (written < maxLength) {
    var hexits = stringSlice(string, read, read += 2);
    if (exec(NOT_HEX, hexits)) throw new SyntaxError('String should only contain hex characters');
    bytes[written++] = parseInt(hexits, 16);
  }
  return { bytes: bytes, read: read };
};


/***/ }),

/***/ 2360:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


/* global ActiveXObject -- old IE, WSH */
var anObject = __webpack_require__(8551);
var definePropertiesModule = __webpack_require__(6801);
var enumBugKeys = __webpack_require__(8727);
var hiddenKeys = __webpack_require__(421);
var html = __webpack_require__(397);
var documentCreateElement = __webpack_require__(4055);
var sharedKey = __webpack_require__(6119);

var GT = '>';
var LT = '<';
var PROTOTYPE = 'prototype';
var SCRIPT = 'script';
var IE_PROTO = sharedKey('IE_PROTO');

var EmptyConstructor = function () { /* empty */ };

var scriptTag = function (content) {
  return LT + SCRIPT + GT + content + LT + '/' + SCRIPT + GT;
};

// Create object with fake `null` prototype: use ActiveX Object with cleared prototype
var NullProtoObjectViaActiveX = function (activeXDocument) {
  activeXDocument.write(scriptTag(''));
  activeXDocument.close();
  var temp = activeXDocument.parentWindow.Object;
  // eslint-disable-next-line no-useless-assignment -- avoid memory leak
  activeXDocument = null;
  return temp;
};

// Create object with fake `null` prototype: use iframe Object with cleared prototype
var NullProtoObjectViaIFrame = function () {
  // Thrash, waste and sodomy: IE GC bug
  var iframe = documentCreateElement('iframe');
  var JS = 'java' + SCRIPT + ':';
  var iframeDocument;
  iframe.style.display = 'none';
  html.appendChild(iframe);
  // https://github.com/zloirock/core-js/issues/475
  iframe.src = String(JS);
  iframeDocument = iframe.contentWindow.document;
  iframeDocument.open();
  iframeDocument.write(scriptTag('document.F=Object'));
  iframeDocument.close();
  return iframeDocument.F;
};

// Check for document.domain and active x support
// No need to use active x approach when document.domain is not set
// see https://github.com/es-shims/es5-shim/issues/150
// variation of https://github.com/kitcambridge/es5-shim/commit/4f738ac066346
// avoid IE GC bug
var activeXDocument;
var NullProtoObject = function () {
  try {
    activeXDocument = new ActiveXObject('htmlfile');
  } catch (error) { /* ignore */ }
  NullProtoObject = typeof document != 'undefined'
    ? document.domain && activeXDocument
      ? NullProtoObjectViaActiveX(activeXDocument) // old IE
      : NullProtoObjectViaIFrame()
    : NullProtoObjectViaActiveX(activeXDocument); // WSH
  var length = enumBugKeys.length;
  while (length--) delete NullProtoObject[PROTOTYPE][enumBugKeys[length]];
  return NullProtoObject();
};

hiddenKeys[IE_PROTO] = true;

// `Object.create` method
// https://tc39.es/ecma262/#sec-object.create
// eslint-disable-next-line es/no-object-create -- safe
module.exports = Object.create || function create(O, Properties) {
  var result;
  if (O !== null) {
    EmptyConstructor[PROTOTYPE] = anObject(O);
    result = new EmptyConstructor();
    EmptyConstructor[PROTOTYPE] = null;
    // add "__proto__" for Object.getPrototypeOf polyfill
    result[IE_PROTO] = O;
  } else result = NullProtoObject();
  return Properties === undefined ? result : definePropertiesModule.f(result, Properties);
};


/***/ }),

/***/ 2475:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {


var $ = __webpack_require__(6518);
var isSupersetOf = __webpack_require__(8527);
var setMethodAcceptSetLike = __webpack_require__(4916);

var INCORRECT = !setMethodAcceptSetLike('isSupersetOf', function (result) {
  return !result;
});

// `Set.prototype.isSupersetOf` method
// https://tc39.es/ecma262/#sec-set.prototype.issupersetof
$({ target: 'Set', proto: true, real: true, forced: INCORRECT }, {
  isSupersetOf: isSupersetOf
});


/***/ }),

/***/ 2489:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {


var $ = __webpack_require__(6518);
var call = __webpack_require__(9565);
var aCallable = __webpack_require__(9306);
var anObject = __webpack_require__(8551);
var getIteratorDirect = __webpack_require__(1767);
var createIteratorProxy = __webpack_require__(9462);
var callWithSafeIterationClosing = __webpack_require__(6319);
var IS_PURE = __webpack_require__(6395);
var iteratorClose = __webpack_require__(9539);
var iteratorHelperThrowsOnInvalidIterator = __webpack_require__(684);
var iteratorHelperWithoutClosingOnEarlyError = __webpack_require__(4549);

var FILTER_WITHOUT_THROWING_ON_INVALID_ITERATOR = !IS_PURE && !iteratorHelperThrowsOnInvalidIterator('filter', function () { /* empty */ });
var filterWithoutClosingOnEarlyError = !IS_PURE && !FILTER_WITHOUT_THROWING_ON_INVALID_ITERATOR
  && iteratorHelperWithoutClosingOnEarlyError('filter', TypeError);

var FORCED = IS_PURE || FILTER_WITHOUT_THROWING_ON_INVALID_ITERATOR || filterWithoutClosingOnEarlyError;

var IteratorProxy = createIteratorProxy(function () {
  var iterator = this.iterator;
  var predicate = this.predicate;
  var next = this.next;
  var result, done, value;
  while (true) {
    result = anObject(call(next, iterator));
    done = this.done = !!result.done;
    if (done) return;
    value = result.value;
    if (callWithSafeIterationClosing(iterator, predicate, [value, this.counter++], true)) return value;
  }
});

// `Iterator.prototype.filter` method
// https://tc39.es/ecma262/#sec-iterator.prototype.filter
$({ target: 'Iterator', proto: true, real: true, forced: FORCED }, {
  filter: function filter(predicate) {
    anObject(this);
    try {
      aCallable(predicate);
    } catch (error) {
      iteratorClose(this, 'throw', error);
    }

    if (filterWithoutClosingOnEarlyError) return call(filterWithoutClosingOnEarlyError, this, predicate);

    return new IteratorProxy(getIteratorDirect(this), {
      predicate: predicate
    });
  }
});


/***/ }),

/***/ 2529:
/***/ ((module) => {


// `CreateIterResultObject` abstract operation
// https://tc39.es/ecma262/#sec-createiterresultobject
module.exports = function (value, done) {
  return { value: value, done: done };
};


/***/ }),

/***/ 2603:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var toString = __webpack_require__(655);

module.exports = function (argument, $default) {
  return argument === undefined ? arguments.length < 2 ? '' : $default : toString(argument);
};


/***/ }),

/***/ 2652:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var bind = __webpack_require__(6080);
var call = __webpack_require__(9565);
var anObject = __webpack_require__(8551);
var tryToString = __webpack_require__(6823);
var isArrayIteratorMethod = __webpack_require__(4209);
var lengthOfArrayLike = __webpack_require__(6198);
var isPrototypeOf = __webpack_require__(1625);
var getIterator = __webpack_require__(81);
var getIteratorMethod = __webpack_require__(851);
var iteratorClose = __webpack_require__(9539);

var $TypeError = TypeError;

var Result = function (stopped, result) {
  this.stopped = stopped;
  this.result = result;
};

var ResultPrototype = Result.prototype;

module.exports = function (iterable, unboundFunction, options) {
  var that = options && options.that;
  var AS_ENTRIES = !!(options && options.AS_ENTRIES);
  var IS_RECORD = !!(options && options.IS_RECORD);
  var IS_ITERATOR = !!(options && options.IS_ITERATOR);
  var INTERRUPTED = !!(options && options.INTERRUPTED);
  var fn = bind(unboundFunction, that);
  var iterator, iterFn, index, length, result, next, step;

  var stop = function (condition) {
    if (iterator) iteratorClose(iterator, 'normal');
    return new Result(true, condition);
  };

  var callFn = function (value) {
    if (AS_ENTRIES) {
      anObject(value);
      return INTERRUPTED ? fn(value[0], value[1], stop) : fn(value[0], value[1]);
    } return INTERRUPTED ? fn(value, stop) : fn(value);
  };

  if (IS_RECORD) {
    iterator = iterable.iterator;
  } else if (IS_ITERATOR) {
    iterator = iterable;
  } else {
    iterFn = getIteratorMethod(iterable);
    if (!iterFn) throw new $TypeError(tryToString(iterable) + ' is not iterable');
    // optimisation for array iterators
    if (isArrayIteratorMethod(iterFn)) {
      for (index = 0, length = lengthOfArrayLike(iterable); length > index; index++) {
        result = callFn(iterable[index]);
        if (result && isPrototypeOf(ResultPrototype, result)) return result;
      } return new Result(false);
    }
    iterator = getIterator(iterable, iterFn);
  }

  next = IS_RECORD ? iterable.next : iterator.next;
  while (!(step = call(next, iterator)).done) {
    try {
      result = callFn(step.value);
    } catch (error) {
      iteratorClose(iterator, 'throw', error);
    }
    if (typeof result == 'object' && result && isPrototypeOf(ResultPrototype, result)) return result;
  } return new Result(false);
};


/***/ }),

/***/ 2777:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var call = __webpack_require__(9565);
var isObject = __webpack_require__(34);
var isSymbol = __webpack_require__(757);
var getMethod = __webpack_require__(5966);
var ordinaryToPrimitive = __webpack_require__(4270);
var wellKnownSymbol = __webpack_require__(8227);

var $TypeError = TypeError;
var TO_PRIMITIVE = wellKnownSymbol('toPrimitive');

// `ToPrimitive` abstract operation
// https://tc39.es/ecma262/#sec-toprimitive
module.exports = function (input, pref) {
  if (!isObject(input) || isSymbol(input)) return input;
  var exoticToPrim = getMethod(input, TO_PRIMITIVE);
  var result;
  if (exoticToPrim) {
    if (pref === undefined) pref = 'default';
    result = call(exoticToPrim, input, pref);
    if (!isObject(result) || isSymbol(result)) return result;
    throw new $TypeError("Can't convert object to primitive value");
  }
  if (pref === undefined) pref = 'number';
  return ordinaryToPrimitive(input, pref);
};


/***/ }),

/***/ 2787:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var hasOwn = __webpack_require__(9297);
var isCallable = __webpack_require__(4901);
var toObject = __webpack_require__(8981);
var sharedKey = __webpack_require__(6119);
var CORRECT_PROTOTYPE_GETTER = __webpack_require__(2211);

var IE_PROTO = sharedKey('IE_PROTO');
var $Object = Object;
var ObjectPrototype = $Object.prototype;

// `Object.getPrototypeOf` method
// https://tc39.es/ecma262/#sec-object.getprototypeof
// eslint-disable-next-line es/no-object-getprototypeof -- safe
module.exports = CORRECT_PROTOTYPE_GETTER ? $Object.getPrototypeOf : function (O) {
  var object = toObject(O);
  if (hasOwn(object, IE_PROTO)) return object[IE_PROTO];
  var constructor = object.constructor;
  if (isCallable(constructor) && object instanceof constructor) {
    return constructor.prototype;
  } return object instanceof $Object ? ObjectPrototype : null;
};


/***/ }),

/***/ 2796:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var fails = __webpack_require__(9039);
var isCallable = __webpack_require__(4901);

var replacement = /#|\.prototype\./;

var isForced = function (feature, detection) {
  var value = data[normalize(feature)];
  return value === POLYFILL ? true
    : value === NATIVE ? false
    : isCallable(detection) ? fails(detection)
    : !!detection;
};

var normalize = isForced.normalize = function (string) {
  return String(string).replace(replacement, '.').toLowerCase();
};

var data = isForced.data = {};
var NATIVE = isForced.NATIVE = 'N';
var POLYFILL = isForced.POLYFILL = 'P';

module.exports = isForced;


/***/ }),

/***/ 2804:
/***/ ((module) => {


var commonAlphabet = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789';
var base64Alphabet = commonAlphabet + '+/';
var base64UrlAlphabet = commonAlphabet + '-_';

var inverse = function (characters) {
  // TODO: use `Object.create(null)` in `core-js@4`
  var result = {};
  var index = 0;
  for (; index < 64; index++) result[characters.charAt(index)] = index;
  return result;
};

module.exports = {
  i2c: base64Alphabet,
  c2i: inverse(base64Alphabet),
  i2cUrl: base64UrlAlphabet,
  c2iUrl: inverse(base64UrlAlphabet)
};


/***/ }),

/***/ 2812:
/***/ ((module) => {


var $TypeError = TypeError;

module.exports = function (passed, required) {
  if (passed < required) throw new $TypeError('Not enough arguments');
  return passed;
};


/***/ }),

/***/ 2839:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var globalThis = __webpack_require__(4576);

var navigator = globalThis.navigator;
var userAgent = navigator && navigator.userAgent;

module.exports = userAgent ? String(userAgent) : '';


/***/ }),

/***/ 2967:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


/* eslint-disable no-proto -- safe */
var uncurryThisAccessor = __webpack_require__(6706);
var isObject = __webpack_require__(34);
var requireObjectCoercible = __webpack_require__(7750);
var aPossiblePrototype = __webpack_require__(3506);

// `Object.setPrototypeOf` method
// https://tc39.es/ecma262/#sec-object.setprototypeof
// Works with __proto__ only. Old v8 can't work with null proto objects.
// eslint-disable-next-line es/no-object-setprototypeof -- safe
module.exports = Object.setPrototypeOf || ('__proto__' in {} ? function () {
  var CORRECT_SETTER = false;
  var test = {};
  var setter;
  try {
    setter = uncurryThisAccessor(Object.prototype, '__proto__', 'set');
    setter(test, []);
    CORRECT_SETTER = test instanceof Array;
  } catch (error) { /* empty */ }
  return function setPrototypeOf(O, proto) {
    requireObjectCoercible(O);
    aPossiblePrototype(proto);
    if (!isObject(O)) return O;
    if (CORRECT_SETTER) setter(O, proto);
    else O.__proto__ = proto;
    return O;
  };
}() : undefined);


/***/ }),

/***/ 3167:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var isCallable = __webpack_require__(4901);
var isObject = __webpack_require__(34);
var setPrototypeOf = __webpack_require__(2967);

// makes subclassing work correct for wrapped built-ins
module.exports = function ($this, dummy, Wrapper) {
  var NewTarget, NewTargetPrototype;
  if (
    // it can work only with native `setPrototypeOf`
    setPrototypeOf &&
    // we haven't completely correct pre-ES6 way for getting `new.target`, so use this
    isCallable(NewTarget = dummy.constructor) &&
    NewTarget !== Wrapper &&
    isObject(NewTargetPrototype = NewTarget.prototype) &&
    NewTargetPrototype !== Wrapper.prototype
  ) setPrototypeOf($this, NewTargetPrototype);
  return $this;
};


/***/ }),

/***/ 3238:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var globalThis = __webpack_require__(4576);
var NATIVE_ARRAY_BUFFER = __webpack_require__(7811);
var arrayBufferByteLength = __webpack_require__(7394);

var DataView = globalThis.DataView;

module.exports = function (O) {
  if (!NATIVE_ARRAY_BUFFER || arrayBufferByteLength(O) !== 0) return false;
  try {
    // eslint-disable-next-line no-new -- thrower
    new DataView(O);
    return false;
  } catch (error) {
    return true;
  }
};


/***/ }),

/***/ 3392:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var uncurryThis = __webpack_require__(9504);

var id = 0;
var postfix = Math.random();
var toString = uncurryThis(1.1.toString);

module.exports = function (key) {
  return 'Symbol(' + (key === undefined ? '' : key) + ')_' + toString(++id + postfix, 36);
};


/***/ }),

/***/ 3440:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var aSet = __webpack_require__(7080);
var SetHelpers = __webpack_require__(4402);
var clone = __webpack_require__(9286);
var size = __webpack_require__(5170);
var getSetRecord = __webpack_require__(3789);
var iterateSet = __webpack_require__(8469);
var iterateSimple = __webpack_require__(507);

var has = SetHelpers.has;
var remove = SetHelpers.remove;

// `Set.prototype.difference` method
// https://github.com/tc39/proposal-set-methods
module.exports = function difference(other) {
  var O = aSet(this);
  var otherRec = getSetRecord(other);
  var result = clone(O);
  if (size(O) <= otherRec.size) iterateSet(O, function (e) {
    if (otherRec.includes(e)) remove(result, e);
  });
  else iterateSimple(otherRec.getIterator(), function (e) {
    if (has(result, e)) remove(result, e);
  });
  return result;
};


/***/ }),

/***/ 3463:
/***/ ((module) => {


var $TypeError = TypeError;

module.exports = function (argument) {
  if (typeof argument == 'string') return argument;
  throw new $TypeError('Argument is not a string');
};


/***/ }),

/***/ 3506:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var isPossiblePrototype = __webpack_require__(3925);

var $String = String;
var $TypeError = TypeError;

module.exports = function (argument) {
  if (isPossiblePrototype(argument)) return argument;
  throw new $TypeError("Can't set " + $String(argument) + ' as a prototype');
};


/***/ }),

/***/ 3579:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {


var $ = __webpack_require__(6518);
var call = __webpack_require__(9565);
var iterate = __webpack_require__(2652);
var aCallable = __webpack_require__(9306);
var anObject = __webpack_require__(8551);
var getIteratorDirect = __webpack_require__(1767);
var iteratorClose = __webpack_require__(9539);
var iteratorHelperWithoutClosingOnEarlyError = __webpack_require__(4549);

var someWithoutClosingOnEarlyError = iteratorHelperWithoutClosingOnEarlyError('some', TypeError);

// `Iterator.prototype.some` method
// https://tc39.es/ecma262/#sec-iterator.prototype.some
$({ target: 'Iterator', proto: true, real: true, forced: someWithoutClosingOnEarlyError }, {
  some: function some(predicate) {
    anObject(this);
    try {
      aCallable(predicate);
    } catch (error) {
      iteratorClose(this, 'throw', error);
    }

    if (someWithoutClosingOnEarlyError) return call(someWithoutClosingOnEarlyError, this, predicate);

    var record = getIteratorDirect(this);
    var counter = 0;
    return iterate(record, function (value, stop) {
      if (predicate(value, counter++)) return stop();
    }, { IS_RECORD: true, INTERRUPTED: true }).stopped;
  }
});


/***/ }),

/***/ 3607:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var userAgent = __webpack_require__(2839);

var webkit = userAgent.match(/AppleWebKit\/(\d+)\./);

module.exports = !!webkit && +webkit[1];


/***/ }),

/***/ 3611:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {


var $ = __webpack_require__(6518);
var globalThis = __webpack_require__(4576);
var defineBuiltInAccessor = __webpack_require__(2106);
var DESCRIPTORS = __webpack_require__(3724);

var $TypeError = TypeError;
// eslint-disable-next-line es/no-object-defineproperty -- safe
var defineProperty = Object.defineProperty;
var INCORRECT_VALUE = globalThis.self !== globalThis;

// `self` getter
// https://html.spec.whatwg.org/multipage/window-object.html#dom-self
try {
  if (DESCRIPTORS) {
    // eslint-disable-next-line es/no-object-getownpropertydescriptor -- safe
    var descriptor = Object.getOwnPropertyDescriptor(globalThis, 'self');
    // some engines have `self`, but with incorrect descriptor
    // https://github.com/denoland/deno/issues/15765
    if (INCORRECT_VALUE || !descriptor || !descriptor.get || !descriptor.enumerable) {
      defineBuiltInAccessor(globalThis, 'self', {
        get: function self() {
          return globalThis;
        },
        set: function self(value) {
          if (this !== globalThis) throw new $TypeError('Illegal invocation');
          defineProperty(globalThis, 'self', {
            value: value,
            writable: true,
            configurable: true,
            enumerable: true
          });
        },
        configurable: true,
        enumerable: true
      });
    }
  } else $({ global: true, simple: true, forced: INCORRECT_VALUE }, {
    self: globalThis
  });
} catch (error) { /* empty */ }


/***/ }),

/***/ 3650:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var aSet = __webpack_require__(7080);
var SetHelpers = __webpack_require__(4402);
var clone = __webpack_require__(9286);
var getSetRecord = __webpack_require__(3789);
var iterateSimple = __webpack_require__(507);

var add = SetHelpers.add;
var has = SetHelpers.has;
var remove = SetHelpers.remove;

// `Set.prototype.symmetricDifference` method
// https://github.com/tc39/proposal-set-methods
module.exports = function symmetricDifference(other) {
  var O = aSet(this);
  var keysIter = getSetRecord(other).getIterator();
  var result = clone(O);
  iterateSimple(keysIter, function (e) {
    if (has(O, e)) remove(result, e);
    else add(result, e);
  });
  return result;
};


/***/ }),

/***/ 3706:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var uncurryThis = __webpack_require__(9504);
var isCallable = __webpack_require__(4901);
var store = __webpack_require__(7629);

var functionToString = uncurryThis(Function.toString);

// this helper broken in `core-js@3.4.1-3.4.4`, so we can't use `shared` helper
if (!isCallable(store.inspectSource)) {
  store.inspectSource = function (it) {
    return functionToString(it);
  };
}

module.exports = store.inspectSource;


/***/ }),

/***/ 3709:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var userAgent = __webpack_require__(2839);

var firefox = userAgent.match(/firefox\/(\d+)/i);

module.exports = !!firefox && +firefox[1];


/***/ }),

/***/ 3717:
/***/ ((__unused_webpack_module, exports) => {


// eslint-disable-next-line es/no-object-getownpropertysymbols -- safe
exports.f = Object.getOwnPropertySymbols;


/***/ }),

/***/ 3724:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var fails = __webpack_require__(9039);

// Detect IE8's incomplete defineProperty implementation
module.exports = !fails(function () {
  // eslint-disable-next-line es/no-object-defineproperty -- required for testing
  return Object.defineProperty({}, 1, { get: function () { return 7; } })[1] !== 7;
});


/***/ }),

/***/ 3763:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var UA = __webpack_require__(2839);

module.exports = /MSIE|Trident/.test(UA);


/***/ }),

/***/ 3789:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var aCallable = __webpack_require__(9306);
var anObject = __webpack_require__(8551);
var call = __webpack_require__(9565);
var toIntegerOrInfinity = __webpack_require__(1291);
var getIteratorDirect = __webpack_require__(1767);

var INVALID_SIZE = 'Invalid size';
var $RangeError = RangeError;
var $TypeError = TypeError;
var max = Math.max;

var SetRecord = function (set, intSize) {
  this.set = set;
  this.size = max(intSize, 0);
  this.has = aCallable(set.has);
  this.keys = aCallable(set.keys);
};

SetRecord.prototype = {
  getIterator: function () {
    return getIteratorDirect(anObject(call(this.keys, this.set)));
  },
  includes: function (it) {
    return call(this.has, this.set, it);
  }
};

// `GetSetRecord` abstract operation
// https://tc39.es/proposal-set-methods/#sec-getsetrecord
module.exports = function (obj) {
  anObject(obj);
  var numSize = +obj.size;
  // NOTE: If size is undefined, then numSize will be NaN
  // eslint-disable-next-line no-self-compare -- NaN check
  if (numSize !== numSize) throw new $TypeError(INVALID_SIZE);
  var intSize = toIntegerOrInfinity(numSize);
  if (intSize < 0) throw new $RangeError(INVALID_SIZE);
  return new SetRecord(obj, intSize);
};


/***/ }),

/***/ 3838:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var aSet = __webpack_require__(7080);
var size = __webpack_require__(5170);
var iterate = __webpack_require__(8469);
var getSetRecord = __webpack_require__(3789);

// `Set.prototype.isSubsetOf` method
// https://tc39.github.io/proposal-set-methods/#Set.prototype.isSubsetOf
module.exports = function isSubsetOf(other) {
  var O = aSet(this);
  var otherRec = getSetRecord(other);
  if (size(O) > otherRec.size) return false;
  return iterate(O, function (e) {
    if (!otherRec.includes(e)) return false;
  }, true) !== false;
};


/***/ }),

/***/ 3839:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var bind = __webpack_require__(6080);
var IndexedObject = __webpack_require__(7055);
var toObject = __webpack_require__(8981);
var lengthOfArrayLike = __webpack_require__(6198);

// `Array.prototype.{ findLast, findLastIndex }` methods implementation
var createMethod = function (TYPE) {
  var IS_FIND_LAST_INDEX = TYPE === 1;
  return function ($this, callbackfn, that) {
    var O = toObject($this);
    var self = IndexedObject(O);
    var index = lengthOfArrayLike(self);
    var boundFunction = bind(callbackfn, that);
    var value, result;
    while (index-- > 0) {
      value = self[index];
      result = boundFunction(value, index, O);
      if (result) switch (TYPE) {
        case 0: return value; // findLast
        case 1: return index; // findLastIndex
      }
    }
    return IS_FIND_LAST_INDEX ? -1 : undefined;
  };
};

module.exports = {
  // `Array.prototype.findLast` method
  // https://github.com/tc39/proposal-array-find-from-last
  findLast: createMethod(0),
  // `Array.prototype.findLastIndex` method
  // https://github.com/tc39/proposal-array-find-from-last
  findLastIndex: createMethod(1)
};


/***/ }),

/***/ 3853:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {


var $ = __webpack_require__(6518);
var isDisjointFrom = __webpack_require__(4449);
var setMethodAcceptSetLike = __webpack_require__(4916);

var INCORRECT = !setMethodAcceptSetLike('isDisjointFrom', function (result) {
  return !result;
});

// `Set.prototype.isDisjointFrom` method
// https://tc39.es/ecma262/#sec-set.prototype.isdisjointfrom
$({ target: 'Set', proto: true, real: true, forced: INCORRECT }, {
  isDisjointFrom: isDisjointFrom
});


/***/ }),

/***/ 3925:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var isObject = __webpack_require__(34);

module.exports = function (argument) {
  return isObject(argument) || argument === null;
};


/***/ }),

/***/ 3972:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var isObject = __webpack_require__(34);

var $String = String;
var $TypeError = TypeError;

module.exports = function (argument) {
  if (argument === undefined || isObject(argument)) return argument;
  throw new $TypeError($String(argument) + ' is not an object or undefined');
};


/***/ }),

/***/ 4055:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var globalThis = __webpack_require__(4576);
var isObject = __webpack_require__(34);

var document = globalThis.document;
// typeof document.createElement is 'object' in old IE
var EXISTS = isObject(document) && isObject(document.createElement);

module.exports = function (it) {
  return EXISTS ? document.createElement(it) : {};
};


/***/ }),

/***/ 4114:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {


var $ = __webpack_require__(6518);
var toObject = __webpack_require__(8981);
var lengthOfArrayLike = __webpack_require__(6198);
var setArrayLength = __webpack_require__(4527);
var doesNotExceedSafeInteger = __webpack_require__(6837);
var fails = __webpack_require__(9039);

var INCORRECT_TO_LENGTH = fails(function () {
  return [].push.call({ length: 0x100000000 }, 1) !== 4294967297;
});

// V8 <= 121 and Safari <= 15.4; FF < 23 throws InternalError
// https://bugs.chromium.org/p/v8/issues/detail?id=12681
var properErrorOnNonWritableLength = function () {
  try {
    // eslint-disable-next-line es/no-object-defineproperty -- safe
    Object.defineProperty([], 'length', { writable: false }).push();
  } catch (error) {
    return error instanceof TypeError;
  }
};

var FORCED = INCORRECT_TO_LENGTH || !properErrorOnNonWritableLength();

// `Array.prototype.push` method
// https://tc39.es/ecma262/#sec-array.prototype.push
$({ target: 'Array', proto: true, arity: 1, forced: FORCED }, {
  // eslint-disable-next-line no-unused-vars -- required for `.length`
  push: function push(item) {
    var O = toObject(this);
    var len = lengthOfArrayLike(O);
    var argCount = arguments.length;
    doesNotExceedSafeInteger(len + argCount);
    for (var i = 0; i < argCount; i++) {
      O[len] = arguments[i];
      len++;
    }
    setArrayLength(O, len);
    return len;
  }
});


/***/ }),

/***/ 4117:
/***/ ((module) => {


// we can't use just `it == null` since of `document.all` special case
// https://tc39.es/ecma262/#sec-IsHTMLDDA-internal-slot-aec
module.exports = function (it) {
  return it === null || it === undefined;
};


/***/ }),

/***/ 4149:
/***/ ((module) => {


var $RangeError = RangeError;

module.exports = function (it) {
  // eslint-disable-next-line no-self-compare -- NaN check
  if (it === it) return it;
  throw new $RangeError('NaN is not allowed');
};


/***/ }),

/***/ 4154:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var classof = __webpack_require__(6955);

var $TypeError = TypeError;

// Perform ? RequireInternalSlot(argument, [[TypedArrayName]])
// If argument.[[TypedArrayName]] is not "Uint8Array", throw a TypeError exception
module.exports = function (argument) {
  if (classof(argument) === 'Uint8Array') return argument;
  throw new $TypeError('Argument is not an Uint8Array');
};


/***/ }),

/***/ 4204:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var aSet = __webpack_require__(7080);
var add = (__webpack_require__(4402).add);
var clone = __webpack_require__(9286);
var getSetRecord = __webpack_require__(3789);
var iterateSimple = __webpack_require__(507);

// `Set.prototype.union` method
// https://github.com/tc39/proposal-set-methods
module.exports = function union(other) {
  var O = aSet(this);
  var keysIter = getSetRecord(other).getIterator();
  var result = clone(O);
  iterateSimple(keysIter, function (it) {
    add(result, it);
  });
  return result;
};


/***/ }),

/***/ 4209:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var wellKnownSymbol = __webpack_require__(8227);
var Iterators = __webpack_require__(6269);

var ITERATOR = wellKnownSymbol('iterator');
var ArrayPrototype = Array.prototype;

// check on default Array iterator
module.exports = function (it) {
  return it !== undefined && (Iterators.Array === it || ArrayPrototype[ITERATOR] === it);
};


/***/ }),

/***/ 4215:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


/* global Bun, Deno -- detection */
var globalThis = __webpack_require__(4576);
var userAgent = __webpack_require__(2839);
var classof = __webpack_require__(2195);

var userAgentStartsWith = function (string) {
  return userAgent.slice(0, string.length) === string;
};

module.exports = (function () {
  if (userAgentStartsWith('Bun/')) return 'BUN';
  if (userAgentStartsWith('Cloudflare-Workers')) return 'CLOUDFLARE';
  if (userAgentStartsWith('Deno/')) return 'DENO';
  if (userAgentStartsWith('Node.js/')) return 'NODE';
  if (globalThis.Bun && typeof Bun.version == 'string') return 'BUN';
  if (globalThis.Deno && typeof Deno.version == 'object') return 'DENO';
  if (classof(globalThis.process) === 'process') return 'NODE';
  if (globalThis.window && globalThis.document) return 'BROWSER';
  return 'REST';
})();


/***/ }),

/***/ 4270:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var call = __webpack_require__(9565);
var isCallable = __webpack_require__(4901);
var isObject = __webpack_require__(34);

var $TypeError = TypeError;

// `OrdinaryToPrimitive` abstract operation
// https://tc39.es/ecma262/#sec-ordinarytoprimitive
module.exports = function (input, pref) {
  var fn, val;
  if (pref === 'string' && isCallable(fn = input.toString) && !isObject(val = call(fn, input))) return val;
  if (isCallable(fn = input.valueOf) && !isObject(val = call(fn, input))) return val;
  if (pref !== 'string' && isCallable(fn = input.toString) && !isObject(val = call(fn, input))) return val;
  throw new $TypeError("Can't convert object to primitive value");
};


/***/ }),

/***/ 4373:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var toObject = __webpack_require__(8981);
var toAbsoluteIndex = __webpack_require__(5610);
var lengthOfArrayLike = __webpack_require__(6198);

// `Array.prototype.fill` method implementation
// https://tc39.es/ecma262/#sec-array.prototype.fill
module.exports = function fill(value /* , start = 0, end = @length */) {
  var O = toObject(this);
  var length = lengthOfArrayLike(O);
  var argumentsLength = arguments.length;
  var index = toAbsoluteIndex(argumentsLength > 1 ? arguments[1] : undefined, length);
  var end = argumentsLength > 2 ? arguments[2] : undefined;
  var endPos = end === undefined ? length : toAbsoluteIndex(end, length);
  while (endPos > index) O[index++] = value;
  return O;
};


/***/ }),

/***/ 4376:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var classof = __webpack_require__(2195);

// `IsArray` abstract operation
// https://tc39.es/ecma262/#sec-isarray
// eslint-disable-next-line es/no-array-isarray -- safe
module.exports = Array.isArray || function isArray(argument) {
  return classof(argument) === 'Array';
};


/***/ }),

/***/ 4402:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var uncurryThis = __webpack_require__(9504);

// eslint-disable-next-line es/no-set -- safe
var SetPrototype = Set.prototype;

module.exports = {
  // eslint-disable-next-line es/no-set -- safe
  Set: Set,
  add: uncurryThis(SetPrototype.add),
  has: uncurryThis(SetPrototype.has),
  remove: uncurryThis(SetPrototype['delete']),
  proto: SetPrototype
};


/***/ }),

/***/ 4449:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var aSet = __webpack_require__(7080);
var has = (__webpack_require__(4402).has);
var size = __webpack_require__(5170);
var getSetRecord = __webpack_require__(3789);
var iterateSet = __webpack_require__(8469);
var iterateSimple = __webpack_require__(507);
var iteratorClose = __webpack_require__(9539);

// `Set.prototype.isDisjointFrom` method
// https://tc39.github.io/proposal-set-methods/#Set.prototype.isDisjointFrom
module.exports = function isDisjointFrom(other) {
  var O = aSet(this);
  var otherRec = getSetRecord(other);
  if (size(O) <= otherRec.size) return iterateSet(O, function (e) {
    if (otherRec.includes(e)) return false;
  }, true) !== false;
  var iterator = otherRec.getIterator();
  return iterateSimple(iterator, function (e) {
    if (has(O, e)) return iteratorClose(iterator, 'normal', false);
  }) !== false;
};


/***/ }),

/***/ 4483:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var globalThis = __webpack_require__(4576);
var getBuiltInNodeModule = __webpack_require__(9429);
var PROPER_STRUCTURED_CLONE_TRANSFER = __webpack_require__(1548);

var structuredClone = globalThis.structuredClone;
var $ArrayBuffer = globalThis.ArrayBuffer;
var $MessageChannel = globalThis.MessageChannel;
var detach = false;
var WorkerThreads, channel, buffer, $detach;

if (PROPER_STRUCTURED_CLONE_TRANSFER) {
  detach = function (transferable) {
    structuredClone(transferable, { transfer: [transferable] });
  };
} else if ($ArrayBuffer) try {
  if (!$MessageChannel) {
    WorkerThreads = getBuiltInNodeModule('worker_threads');
    if (WorkerThreads) $MessageChannel = WorkerThreads.MessageChannel;
  }

  if ($MessageChannel) {
    channel = new $MessageChannel();
    buffer = new $ArrayBuffer(2);

    $detach = function (transferable) {
      channel.port1.postMessage(null, [transferable]);
    };

    if (buffer.byteLength === 2) {
      $detach(buffer);
      if (buffer.byteLength === 0) detach = $detach;
    }
  }
} catch (error) { /* empty */ }

module.exports = detach;


/***/ }),

/***/ 4488:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var arraySlice = __webpack_require__(7680);

var floor = Math.floor;

var sort = function (array, comparefn) {
  var length = array.length;

  if (length < 8) {
    // insertion sort
    var i = 1;
    var element, j;

    while (i < length) {
      j = i;
      element = array[i];
      while (j && comparefn(array[j - 1], element) > 0) {
        array[j] = array[--j];
      }
      if (j !== i++) array[j] = element;
    }
  } else {
    // merge sort
    var middle = floor(length / 2);
    var left = sort(arraySlice(array, 0, middle), comparefn);
    var right = sort(arraySlice(array, middle), comparefn);
    var llength = left.length;
    var rlength = right.length;
    var lindex = 0;
    var rindex = 0;

    while (lindex < llength || rindex < rlength) {
      array[lindex + rindex] = (lindex < llength && rindex < rlength)
        ? comparefn(left[lindex], right[rindex]) <= 0 ? left[lindex++] : right[rindex++]
        : lindex < llength ? left[lindex++] : right[rindex++];
    }
  }

  return array;
};

module.exports = sort;


/***/ }),

/***/ 4495:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


/* eslint-disable es/no-symbol -- required for testing */
var V8_VERSION = __webpack_require__(9519);
var fails = __webpack_require__(9039);
var globalThis = __webpack_require__(4576);

var $String = globalThis.String;

// eslint-disable-next-line es/no-object-getownpropertysymbols -- required for testing
module.exports = !!Object.getOwnPropertySymbols && !fails(function () {
  var symbol = Symbol('symbol detection');
  // Chrome 38 Symbol has incorrect toString conversion
  // `get-own-property-symbols` polyfill symbols converted to object are not Symbol instances
  // nb: Do not call `String` directly to avoid this being optimized out to `symbol+''` which will,
  // of course, fail.
  return !$String(symbol) || !(Object(symbol) instanceof Symbol) ||
    // Chrome 38-40 symbols are not inherited from DOM collections prototypes to instances
    !Symbol.sham && V8_VERSION && V8_VERSION < 41;
});


/***/ }),

/***/ 4527:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var DESCRIPTORS = __webpack_require__(3724);
var isArray = __webpack_require__(4376);

var $TypeError = TypeError;
// eslint-disable-next-line es/no-object-getownpropertydescriptor -- safe
var getOwnPropertyDescriptor = Object.getOwnPropertyDescriptor;

// Safari < 13 does not throw an error in this case
var SILENT_ON_NON_WRITABLE_LENGTH_SET = DESCRIPTORS && !function () {
  // makes no sense without proper strict mode support
  if (this !== undefined) return true;
  try {
    // eslint-disable-next-line es/no-object-defineproperty -- safe
    Object.defineProperty([], 'length', { writable: false }).length = 1;
  } catch (error) {
    return error instanceof TypeError;
  }
}();

module.exports = SILENT_ON_NON_WRITABLE_LENGTH_SET ? function (O, length) {
  if (isArray(O) && !getOwnPropertyDescriptor(O, 'length').writable) {
    throw new $TypeError('Cannot set read only .length');
  } return O.length = length;
} : function (O, length) {
  return O.length = length;
};


/***/ }),

/***/ 4549:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var globalThis = __webpack_require__(4576);

// https://github.com/tc39/ecma262/pull/3467
module.exports = function (METHOD_NAME, ExpectedError) {
  var Iterator = globalThis.Iterator;
  var IteratorPrototype = Iterator && Iterator.prototype;
  var method = IteratorPrototype && IteratorPrototype[METHOD_NAME];

  var CLOSED = false;

  if (method) try {
    method.call({
      next: function () { return { done: true }; },
      'return': function () { CLOSED = true; }
    }, -1);
  } catch (error) {
    // https://bugs.webkit.org/show_bug.cgi?id=291195
    if (!(error instanceof ExpectedError)) CLOSED = false;
  }

  if (!CLOSED) return method;
};


/***/ }),

/***/ 4576:
/***/ (function(module) {


var check = function (it) {
  return it && it.Math === Math && it;
};

// https://github.com/zloirock/core-js/issues/86#issuecomment-115759028
module.exports =
  // eslint-disable-next-line es/no-global-this -- safe
  check(typeof globalThis == 'object' && globalThis) ||
  check(typeof window == 'object' && window) ||
  // eslint-disable-next-line no-restricted-globals -- safe
  check(typeof self == 'object' && self) ||
  check(typeof global == 'object' && global) ||
  check(typeof this == 'object' && this) ||
  // eslint-disable-next-line no-new-func -- fallback
  (function () { return this; })() || Function('return this')();


/***/ }),

/***/ 4601:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var getBuiltIn = __webpack_require__(7751);
var hasOwn = __webpack_require__(9297);
var createNonEnumerableProperty = __webpack_require__(6699);
var isPrototypeOf = __webpack_require__(1625);
var setPrototypeOf = __webpack_require__(2967);
var copyConstructorProperties = __webpack_require__(7740);
var proxyAccessor = __webpack_require__(1056);
var inheritIfRequired = __webpack_require__(3167);
var normalizeStringArgument = __webpack_require__(2603);
var installErrorCause = __webpack_require__(7584);
var installErrorStack = __webpack_require__(747);
var DESCRIPTORS = __webpack_require__(3724);
var IS_PURE = __webpack_require__(6395);

module.exports = function (FULL_NAME, wrapper, FORCED, IS_AGGREGATE_ERROR) {
  var STACK_TRACE_LIMIT = 'stackTraceLimit';
  var OPTIONS_POSITION = IS_AGGREGATE_ERROR ? 2 : 1;
  var path = FULL_NAME.split('.');
  var ERROR_NAME = path[path.length - 1];
  var OriginalError = getBuiltIn.apply(null, path);

  if (!OriginalError) return;

  var OriginalErrorPrototype = OriginalError.prototype;

  // V8 9.3- bug https://bugs.chromium.org/p/v8/issues/detail?id=12006
  if (!IS_PURE && hasOwn(OriginalErrorPrototype, 'cause')) delete OriginalErrorPrototype.cause;

  if (!FORCED) return OriginalError;

  var BaseError = getBuiltIn('Error');

  var WrappedError = wrapper(function (a, b) {
    var message = normalizeStringArgument(IS_AGGREGATE_ERROR ? b : a, undefined);
    var result = IS_AGGREGATE_ERROR ? new OriginalError(a) : new OriginalError();
    if (message !== undefined) createNonEnumerableProperty(result, 'message', message);
    installErrorStack(result, WrappedError, result.stack, 2);
    if (this && isPrototypeOf(OriginalErrorPrototype, this)) inheritIfRequired(result, this, WrappedError);
    if (arguments.length > OPTIONS_POSITION) installErrorCause(result, arguments[OPTIONS_POSITION]);
    return result;
  });

  WrappedError.prototype = OriginalErrorPrototype;

  if (ERROR_NAME !== 'Error') {
    if (setPrototypeOf) setPrototypeOf(WrappedError, BaseError);
    else copyConstructorProperties(WrappedError, BaseError, { name: true });
  } else if (DESCRIPTORS && STACK_TRACE_LIMIT in OriginalError) {
    proxyAccessor(WrappedError, OriginalError, STACK_TRACE_LIMIT);
    proxyAccessor(WrappedError, OriginalError, 'prepareStackTrace');
  }

  copyConstructorProperties(WrappedError, OriginalError);

  if (!IS_PURE) try {
    // Safari 13- bug: WebAssembly errors does not have a proper `.name`
    if (OriginalErrorPrototype.name !== ERROR_NAME) {
      createNonEnumerableProperty(OriginalErrorPrototype, 'name', ERROR_NAME);
    }
    OriginalErrorPrototype.constructor = WrappedError;
  } catch (error) { /* empty */ }

  return WrappedError;
};


/***/ }),

/***/ 4603:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {


var defineBuiltIn = __webpack_require__(6840);
var uncurryThis = __webpack_require__(9504);
var toString = __webpack_require__(655);
var validateArgumentsLength = __webpack_require__(2812);

var $URLSearchParams = URLSearchParams;
var URLSearchParamsPrototype = $URLSearchParams.prototype;
var append = uncurryThis(URLSearchParamsPrototype.append);
var $delete = uncurryThis(URLSearchParamsPrototype['delete']);
var forEach = uncurryThis(URLSearchParamsPrototype.forEach);
var push = uncurryThis([].push);
var params = new $URLSearchParams('a=1&a=2&b=3');

params['delete']('a', 1);
// `undefined` case is a Chromium 117 bug
// https://bugs.chromium.org/p/v8/issues/detail?id=14222
params['delete']('b', undefined);

if (params + '' !== 'a=2') {
  defineBuiltIn(URLSearchParamsPrototype, 'delete', function (name /* , value */) {
    var length = arguments.length;
    var $value = length < 2 ? undefined : arguments[1];
    if (length && $value === undefined) return $delete(this, name);
    var entries = [];
    forEach(this, function (v, k) { // also validates `this`
      push(entries, { key: k, value: v });
    });
    validateArgumentsLength(length, 1);
    var key = toString(name);
    var value = toString($value);
    var index = 0;
    var dindex = 0;
    var found = false;
    var entriesLength = entries.length;
    var entry;
    while (index < entriesLength) {
      entry = entries[index++];
      if (found || entry.key === key) {
        found = true;
        $delete(this, entry.key);
      } else dindex++;
    }
    while (dindex < entriesLength) {
      entry = entries[dindex++];
      if (!(entry.key === key && entry.value === value)) append(this, entry.key, entry.value);
    }
  }, { enumerable: true, unsafe: true });
}


/***/ }),

/***/ 4628:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {


var $ = __webpack_require__(6518);
var newPromiseCapabilityModule = __webpack_require__(6043);

// `Promise.withResolvers` method
// https://tc39.es/ecma262/#sec-promise.withResolvers
$({ target: 'Promise', stat: true }, {
  withResolvers: function withResolvers() {
    var promiseCapability = newPromiseCapabilityModule.f(this);
    return {
      promise: promiseCapability.promise,
      resolve: promiseCapability.resolve,
      reject: promiseCapability.reject
    };
  }
});


/***/ }),

/***/ 4644:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var NATIVE_ARRAY_BUFFER = __webpack_require__(7811);
var DESCRIPTORS = __webpack_require__(3724);
var globalThis = __webpack_require__(4576);
var isCallable = __webpack_require__(4901);
var isObject = __webpack_require__(34);
var hasOwn = __webpack_require__(9297);
var classof = __webpack_require__(6955);
var tryToString = __webpack_require__(6823);
var createNonEnumerableProperty = __webpack_require__(6699);
var defineBuiltIn = __webpack_require__(6840);
var defineBuiltInAccessor = __webpack_require__(2106);
var isPrototypeOf = __webpack_require__(1625);
var getPrototypeOf = __webpack_require__(2787);
var setPrototypeOf = __webpack_require__(2967);
var wellKnownSymbol = __webpack_require__(8227);
var uid = __webpack_require__(3392);
var InternalStateModule = __webpack_require__(1181);

var enforceInternalState = InternalStateModule.enforce;
var getInternalState = InternalStateModule.get;
var Int8Array = globalThis.Int8Array;
var Int8ArrayPrototype = Int8Array && Int8Array.prototype;
var Uint8ClampedArray = globalThis.Uint8ClampedArray;
var Uint8ClampedArrayPrototype = Uint8ClampedArray && Uint8ClampedArray.prototype;
var TypedArray = Int8Array && getPrototypeOf(Int8Array);
var TypedArrayPrototype = Int8ArrayPrototype && getPrototypeOf(Int8ArrayPrototype);
var ObjectPrototype = Object.prototype;
var TypeError = globalThis.TypeError;

var TO_STRING_TAG = wellKnownSymbol('toStringTag');
var TYPED_ARRAY_TAG = uid('TYPED_ARRAY_TAG');
var TYPED_ARRAY_CONSTRUCTOR = 'TypedArrayConstructor';
// Fixing native typed arrays in Opera Presto crashes the browser, see #595
var NATIVE_ARRAY_BUFFER_VIEWS = NATIVE_ARRAY_BUFFER && !!setPrototypeOf && classof(globalThis.opera) !== 'Opera';
var TYPED_ARRAY_TAG_REQUIRED = false;
var NAME, Constructor, Prototype;

var TypedArrayConstructorsList = {
  Int8Array: 1,
  Uint8Array: 1,
  Uint8ClampedArray: 1,
  Int16Array: 2,
  Uint16Array: 2,
  Int32Array: 4,
  Uint32Array: 4,
  Float32Array: 4,
  Float64Array: 8
};

var BigIntArrayConstructorsList = {
  BigInt64Array: 8,
  BigUint64Array: 8
};

var isView = function isView(it) {
  if (!isObject(it)) return false;
  var klass = classof(it);
  return klass === 'DataView'
    || hasOwn(TypedArrayConstructorsList, klass)
    || hasOwn(BigIntArrayConstructorsList, klass);
};

var getTypedArrayConstructor = function (it) {
  var proto = getPrototypeOf(it);
  if (!isObject(proto)) return;
  var state = getInternalState(proto);
  return (state && hasOwn(state, TYPED_ARRAY_CONSTRUCTOR)) ? state[TYPED_ARRAY_CONSTRUCTOR] : getTypedArrayConstructor(proto);
};

var isTypedArray = function (it) {
  if (!isObject(it)) return false;
  var klass = classof(it);
  return hasOwn(TypedArrayConstructorsList, klass)
    || hasOwn(BigIntArrayConstructorsList, klass);
};

var aTypedArray = function (it) {
  if (isTypedArray(it)) return it;
  throw new TypeError('Target is not a typed array');
};

var aTypedArrayConstructor = function (C) {
  if (isCallable(C) && (!setPrototypeOf || isPrototypeOf(TypedArray, C))) return C;
  throw new TypeError(tryToString(C) + ' is not a typed array constructor');
};

var exportTypedArrayMethod = function (KEY, property, forced, options) {
  if (!DESCRIPTORS) return;
  if (forced) for (var ARRAY in TypedArrayConstructorsList) {
    var TypedArrayConstructor = globalThis[ARRAY];
    if (TypedArrayConstructor && hasOwn(TypedArrayConstructor.prototype, KEY)) try {
      delete TypedArrayConstructor.prototype[KEY];
    } catch (error) {
      // old WebKit bug - some methods are non-configurable
      try {
        TypedArrayConstructor.prototype[KEY] = property;
      } catch (error2) { /* empty */ }
    }
  }
  if (!TypedArrayPrototype[KEY] || forced) {
    defineBuiltIn(TypedArrayPrototype, KEY, forced ? property
      : NATIVE_ARRAY_BUFFER_VIEWS && Int8ArrayPrototype[KEY] || property, options);
  }
};

var exportTypedArrayStaticMethod = function (KEY, property, forced) {
  var ARRAY, TypedArrayConstructor;
  if (!DESCRIPTORS) return;
  if (setPrototypeOf) {
    if (forced) for (ARRAY in TypedArrayConstructorsList) {
      TypedArrayConstructor = globalThis[ARRAY];
      if (TypedArrayConstructor && hasOwn(TypedArrayConstructor, KEY)) try {
        delete TypedArrayConstructor[KEY];
      } catch (error) { /* empty */ }
    }
    if (!TypedArray[KEY] || forced) {
      // V8 ~ Chrome 49-50 `%TypedArray%` methods are non-writable non-configurable
      try {
        return defineBuiltIn(TypedArray, KEY, forced ? property : NATIVE_ARRAY_BUFFER_VIEWS && TypedArray[KEY] || property);
      } catch (error) { /* empty */ }
    } else return;
  }
  for (ARRAY in TypedArrayConstructorsList) {
    TypedArrayConstructor = globalThis[ARRAY];
    if (TypedArrayConstructor && (!TypedArrayConstructor[KEY] || forced)) {
      defineBuiltIn(TypedArrayConstructor, KEY, property);
    }
  }
};

for (NAME in TypedArrayConstructorsList) {
  Constructor = globalThis[NAME];
  Prototype = Constructor && Constructor.prototype;
  if (Prototype) enforceInternalState(Prototype)[TYPED_ARRAY_CONSTRUCTOR] = Constructor;
  else NATIVE_ARRAY_BUFFER_VIEWS = false;
}

for (NAME in BigIntArrayConstructorsList) {
  Constructor = globalThis[NAME];
  Prototype = Constructor && Constructor.prototype;
  if (Prototype) enforceInternalState(Prototype)[TYPED_ARRAY_CONSTRUCTOR] = Constructor;
}

// WebKit bug - typed arrays constructors prototype is Object.prototype
if (!NATIVE_ARRAY_BUFFER_VIEWS || !isCallable(TypedArray) || TypedArray === Function.prototype) {
  // eslint-disable-next-line no-shadow -- safe
  TypedArray = function TypedArray() {
    throw new TypeError('Incorrect invocation');
  };
  if (NATIVE_ARRAY_BUFFER_VIEWS) for (NAME in TypedArrayConstructorsList) {
    if (globalThis[NAME]) setPrototypeOf(globalThis[NAME], TypedArray);
  }
}

if (!NATIVE_ARRAY_BUFFER_VIEWS || !TypedArrayPrototype || TypedArrayPrototype === ObjectPrototype) {
  TypedArrayPrototype = TypedArray.prototype;
  if (NATIVE_ARRAY_BUFFER_VIEWS) for (NAME in TypedArrayConstructorsList) {
    if (globalThis[NAME]) setPrototypeOf(globalThis[NAME].prototype, TypedArrayPrototype);
  }
}

// WebKit bug - one more object in Uint8ClampedArray prototype chain
if (NATIVE_ARRAY_BUFFER_VIEWS && getPrototypeOf(Uint8ClampedArrayPrototype) !== TypedArrayPrototype) {
  setPrototypeOf(Uint8ClampedArrayPrototype, TypedArrayPrototype);
}

if (DESCRIPTORS && !hasOwn(TypedArrayPrototype, TO_STRING_TAG)) {
  TYPED_ARRAY_TAG_REQUIRED = true;
  defineBuiltInAccessor(TypedArrayPrototype, TO_STRING_TAG, {
    configurable: true,
    get: function () {
      return isObject(this) ? this[TYPED_ARRAY_TAG] : undefined;
    }
  });
  for (NAME in TypedArrayConstructorsList) if (globalThis[NAME]) {
    createNonEnumerableProperty(globalThis[NAME], TYPED_ARRAY_TAG, NAME);
  }
}

module.exports = {
  NATIVE_ARRAY_BUFFER_VIEWS: NATIVE_ARRAY_BUFFER_VIEWS,
  TYPED_ARRAY_TAG: TYPED_ARRAY_TAG_REQUIRED && TYPED_ARRAY_TAG,
  aTypedArray: aTypedArray,
  aTypedArrayConstructor: aTypedArrayConstructor,
  exportTypedArrayMethod: exportTypedArrayMethod,
  exportTypedArrayStaticMethod: exportTypedArrayStaticMethod,
  getTypedArrayConstructor: getTypedArrayConstructor,
  isView: isView,
  isTypedArray: isTypedArray,
  TypedArray: TypedArray,
  TypedArrayPrototype: TypedArrayPrototype
};


/***/ }),

/***/ 4659:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var fails = __webpack_require__(9039);
var createPropertyDescriptor = __webpack_require__(6980);

module.exports = !fails(function () {
  var error = new Error('a');
  if (!('stack' in error)) return true;
  // eslint-disable-next-line es/no-object-defineproperty -- safe
  Object.defineProperty(error, 'stack', createPropertyDescriptor(1, 7));
  return error.stack !== 7;
});


/***/ }),

/***/ 4732:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {


var ArrayBufferViewCore = __webpack_require__(4644);
var uncurryThis = __webpack_require__(9504);
var aCallable = __webpack_require__(9306);
var arrayFromConstructorAndList = __webpack_require__(5370);

var aTypedArray = ArrayBufferViewCore.aTypedArray;
var getTypedArrayConstructor = ArrayBufferViewCore.getTypedArrayConstructor;
var exportTypedArrayMethod = ArrayBufferViewCore.exportTypedArrayMethod;
var sort = uncurryThis(ArrayBufferViewCore.TypedArrayPrototype.sort);

// `%TypedArray%.prototype.toSorted` method
// https://tc39.es/ecma262/#sec-%typedarray%.prototype.tosorted
exportTypedArrayMethod('toSorted', function toSorted(compareFn) {
  if (compareFn !== undefined) aCallable(compareFn);
  var O = aTypedArray(this);
  var A = arrayFromConstructorAndList(getTypedArrayConstructor(O), O);
  return sort(A, compareFn);
});


/***/ }),

/***/ 4901:
/***/ ((module) => {


// https://tc39.es/ecma262/#sec-IsHTMLDDA-internal-slot
var documentAll = typeof document == 'object' && document.all;

// `IsCallable` abstract operation
// https://tc39.es/ecma262/#sec-iscallable
// eslint-disable-next-line unicorn/no-typeof-undefined -- required for testing
module.exports = typeof documentAll == 'undefined' && documentAll !== undefined ? function (argument) {
  return typeof argument == 'function' || argument === documentAll;
} : function (argument) {
  return typeof argument == 'function';
};


/***/ }),

/***/ 4913:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


var DESCRIPTORS = __webpack_require__(3724);
var IE8_DOM_DEFINE = __webpack_require__(5917);
var V8_PROTOTYPE_DEFINE_BUG = __webpack_require__(8686);
var anObject = __webpack_require__(8551);
var toPropertyKey = __webpack_require__(6969);

var $TypeError = TypeError;
// eslint-disable-next-line es/no-object-defineproperty -- safe
var $defineProperty = Object.defineProperty;
// eslint-disable-next-line es/no-object-getownpropertydescriptor -- safe
var $getOwnPropertyDescriptor = Object.getOwnPropertyDescriptor;
var ENUMERABLE = 'enumerable';
var CONFIGURABLE = 'configurable';
var WRITABLE = 'writable';

// `Object.defineProperty` method
// https://tc39.es/ecma262/#sec-object.defineproperty
exports.f = DESCRIPTORS ? V8_PROTOTYPE_DEFINE_BUG ? function defineProperty(O, P, Attributes) {
  anObject(O);
  P = toPropertyKey(P);
  anObject(Attributes);
  if (typeof O === 'function' && P === 'prototype' && 'value' in Attributes && WRITABLE in Attributes && !Attributes[WRITABLE]) {
    var current = $getOwnPropertyDescriptor(O, P);
    if (current && current[WRITABLE]) {
      O[P] = Attributes.value;
      Attributes = {
        configurable: CONFIGURABLE in Attributes ? Attributes[CONFIGURABLE] : current[CONFIGURABLE],
        enumerable: ENUMERABLE in Attributes ? Attributes[ENUMERABLE] : current[ENUMERABLE],
        writable: false
      };
    }
  } return $defineProperty(O, P, Attributes);
} : $defineProperty : function defineProperty(O, P, Attributes) {
  anObject(O);
  P = toPropertyKey(P);
  anObject(Attributes);
  if (IE8_DOM_DEFINE) try {
    return $defineProperty(O, P, Attributes);
  } catch (error) { /* empty */ }
  if ('get' in Attributes || 'set' in Attributes) throw new $TypeError('Accessors not supported');
  if ('value' in Attributes) O[P] = Attributes.value;
  return O;
};


/***/ }),

/***/ 4916:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var getBuiltIn = __webpack_require__(7751);

var createSetLike = function (size) {
  return {
    size: size,
    has: function () {
      return false;
    },
    keys: function () {
      return {
        next: function () {
          return { done: true };
        }
      };
    }
  };
};

var createSetLikeWithInfinitySize = function (size) {
  return {
    size: size,
    has: function () {
      return true;
    },
    keys: function () {
      throw new Error('e');
    }
  };
};

module.exports = function (name, callback) {
  var Set = getBuiltIn('Set');
  try {
    new Set()[name](createSetLike(0));
    try {
      // late spec change, early WebKit ~ Safari 17 implementation does not pass it
      // https://github.com/tc39/proposal-set-methods/pull/88
      // also covered engines with
      // https://bugs.webkit.org/show_bug.cgi?id=272679
      new Set()[name](createSetLike(-1));
      return false;
    } catch (error2) {
      if (!callback) return true;
      // early V8 implementation bug
      // https://issues.chromium.org/issues/351332634
      try {
        new Set()[name](createSetLikeWithInfinitySize(-Infinity));
        return false;
      } catch (error) {
        var set = new Set();
        set.add(1);
        set.add(2);
        return callback(set[name](createSetLikeWithInfinitySize(Infinity)));
      }
    }
  } catch (error) {
    return false;
  }
};


/***/ }),

/***/ 4979:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {


var $ = __webpack_require__(6518);
var globalThis = __webpack_require__(4576);
var getBuiltIn = __webpack_require__(7751);
var createPropertyDescriptor = __webpack_require__(6980);
var defineProperty = (__webpack_require__(4913).f);
var hasOwn = __webpack_require__(9297);
var anInstance = __webpack_require__(679);
var inheritIfRequired = __webpack_require__(3167);
var normalizeStringArgument = __webpack_require__(2603);
var DOMExceptionConstants = __webpack_require__(5002);
var clearErrorStack = __webpack_require__(6193);
var DESCRIPTORS = __webpack_require__(3724);
var IS_PURE = __webpack_require__(6395);

var DOM_EXCEPTION = 'DOMException';
var Error = getBuiltIn('Error');
var NativeDOMException = getBuiltIn(DOM_EXCEPTION);

var $DOMException = function DOMException() {
  anInstance(this, DOMExceptionPrototype);
  var argumentsLength = arguments.length;
  var message = normalizeStringArgument(argumentsLength < 1 ? undefined : arguments[0]);
  var name = normalizeStringArgument(argumentsLength < 2 ? undefined : arguments[1], 'Error');
  var that = new NativeDOMException(message, name);
  var error = new Error(message);
  error.name = DOM_EXCEPTION;
  defineProperty(that, 'stack', createPropertyDescriptor(1, clearErrorStack(error.stack, 1)));
  inheritIfRequired(that, this, $DOMException);
  return that;
};

var DOMExceptionPrototype = $DOMException.prototype = NativeDOMException.prototype;

var ERROR_HAS_STACK = 'stack' in new Error(DOM_EXCEPTION);
var DOM_EXCEPTION_HAS_STACK = 'stack' in new NativeDOMException(1, 2);

// eslint-disable-next-line es/no-object-getownpropertydescriptor -- safe
var descriptor = NativeDOMException && DESCRIPTORS && Object.getOwnPropertyDescriptor(globalThis, DOM_EXCEPTION);

// Bun ~ 0.1.1 DOMException have incorrect descriptor and we can't redefine it
// https://github.com/Jarred-Sumner/bun/issues/399
var BUGGY_DESCRIPTOR = !!descriptor && !(descriptor.writable && descriptor.configurable);

var FORCED_CONSTRUCTOR = ERROR_HAS_STACK && !BUGGY_DESCRIPTOR && !DOM_EXCEPTION_HAS_STACK;

// `DOMException` constructor patch for `.stack` where it's required
// https://webidl.spec.whatwg.org/#es-DOMException-specialness
$({ global: true, constructor: true, forced: IS_PURE || FORCED_CONSTRUCTOR }, { // TODO: fix export logic
  DOMException: FORCED_CONSTRUCTOR ? $DOMException : NativeDOMException
});

var PolyfilledDOMException = getBuiltIn(DOM_EXCEPTION);
var PolyfilledDOMExceptionPrototype = PolyfilledDOMException.prototype;

if (PolyfilledDOMExceptionPrototype.constructor !== PolyfilledDOMException) {
  if (!IS_PURE) {
    defineProperty(PolyfilledDOMExceptionPrototype, 'constructor', createPropertyDescriptor(1, PolyfilledDOMException));
  }

  for (var key in DOMExceptionConstants) if (hasOwn(DOMExceptionConstants, key)) {
    var constant = DOMExceptionConstants[key];
    var constantName = constant.s;
    if (!hasOwn(PolyfilledDOMException, constantName)) {
      defineProperty(PolyfilledDOMException, constantName, createPropertyDescriptor(6, constant.c));
    }
  }
}


/***/ }),

/***/ 5002:
/***/ ((module) => {


module.exports = {
  IndexSizeError: { s: 'INDEX_SIZE_ERR', c: 1, m: 1 },
  DOMStringSizeError: { s: 'DOMSTRING_SIZE_ERR', c: 2, m: 0 },
  HierarchyRequestError: { s: 'HIERARCHY_REQUEST_ERR', c: 3, m: 1 },
  WrongDocumentError: { s: 'WRONG_DOCUMENT_ERR', c: 4, m: 1 },
  InvalidCharacterError: { s: 'INVALID_CHARACTER_ERR', c: 5, m: 1 },
  NoDataAllowedError: { s: 'NO_DATA_ALLOWED_ERR', c: 6, m: 0 },
  NoModificationAllowedError: { s: 'NO_MODIFICATION_ALLOWED_ERR', c: 7, m: 1 },
  NotFoundError: { s: 'NOT_FOUND_ERR', c: 8, m: 1 },
  NotSupportedError: { s: 'NOT_SUPPORTED_ERR', c: 9, m: 1 },
  InUseAttributeError: { s: 'INUSE_ATTRIBUTE_ERR', c: 10, m: 1 },
  InvalidStateError: { s: 'INVALID_STATE_ERR', c: 11, m: 1 },
  SyntaxError: { s: 'SYNTAX_ERR', c: 12, m: 1 },
  InvalidModificationError: { s: 'INVALID_MODIFICATION_ERR', c: 13, m: 1 },
  NamespaceError: { s: 'NAMESPACE_ERR', c: 14, m: 1 },
  InvalidAccessError: { s: 'INVALID_ACCESS_ERR', c: 15, m: 1 },
  ValidationError: { s: 'VALIDATION_ERR', c: 16, m: 0 },
  TypeMismatchError: { s: 'TYPE_MISMATCH_ERR', c: 17, m: 1 },
  SecurityError: { s: 'SECURITY_ERR', c: 18, m: 1 },
  NetworkError: { s: 'NETWORK_ERR', c: 19, m: 1 },
  AbortError: { s: 'ABORT_ERR', c: 20, m: 1 },
  URLMismatchError: { s: 'URL_MISMATCH_ERR', c: 21, m: 1 },
  QuotaExceededError: { s: 'QUOTA_EXCEEDED_ERR', c: 22, m: 1 },
  TimeoutError: { s: 'TIMEOUT_ERR', c: 23, m: 1 },
  InvalidNodeTypeError: { s: 'INVALID_NODE_TYPE_ERR', c: 24, m: 1 },
  DataCloneError: { s: 'DATA_CLONE_ERR', c: 25, m: 1 }
};


/***/ }),

/***/ 5024:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {


var $ = __webpack_require__(6518);
var symmetricDifference = __webpack_require__(3650);
var setMethodGetKeysBeforeCloning = __webpack_require__(9835);
var setMethodAcceptSetLike = __webpack_require__(4916);

var FORCED = !setMethodAcceptSetLike('symmetricDifference') || !setMethodGetKeysBeforeCloning('symmetricDifference');

// `Set.prototype.symmetricDifference` method
// https://tc39.es/ecma262/#sec-set.prototype.symmetricdifference
$({ target: 'Set', proto: true, real: true, forced: FORCED }, {
  symmetricDifference: symmetricDifference
});


/***/ }),

/***/ 5031:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var getBuiltIn = __webpack_require__(7751);
var uncurryThis = __webpack_require__(9504);
var getOwnPropertyNamesModule = __webpack_require__(8480);
var getOwnPropertySymbolsModule = __webpack_require__(3717);
var anObject = __webpack_require__(8551);

var concat = uncurryThis([].concat);

// all object keys, includes non-enumerable and symbols
module.exports = getBuiltIn('Reflect', 'ownKeys') || function ownKeys(it) {
  var keys = getOwnPropertyNamesModule.f(anObject(it));
  var getOwnPropertySymbols = getOwnPropertySymbolsModule.f;
  return getOwnPropertySymbols ? concat(keys, getOwnPropertySymbols(it)) : keys;
};


/***/ }),

/***/ 5044:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {


var ArrayBufferViewCore = __webpack_require__(4644);
var $fill = __webpack_require__(4373);
var toBigInt = __webpack_require__(5854);
var classof = __webpack_require__(6955);
var call = __webpack_require__(9565);
var uncurryThis = __webpack_require__(9504);
var fails = __webpack_require__(9039);

var aTypedArray = ArrayBufferViewCore.aTypedArray;
var exportTypedArrayMethod = ArrayBufferViewCore.exportTypedArrayMethod;
var slice = uncurryThis(''.slice);

// V8 ~ Chrome < 59, Safari < 14.1, FF < 55, Edge <=18
var CONVERSION_BUG = fails(function () {
  var count = 0;
  // eslint-disable-next-line es/no-typed-arrays -- safe
  new Int8Array(2).fill({ valueOf: function () { return count++; } });
  return count !== 1;
});

// `%TypedArray%.prototype.fill` method
// https://tc39.es/ecma262/#sec-%typedarray%.prototype.fill
exportTypedArrayMethod('fill', function fill(value /* , start, end */) {
  var length = arguments.length;
  aTypedArray(this);
  var actualValue = slice(classof(this), 0, 3) === 'Big' ? toBigInt(value) : +value;
  return call($fill, this, actualValue, length > 1 ? arguments[1] : undefined, length > 2 ? arguments[2] : undefined);
}, CONVERSION_BUG);


/***/ }),

/***/ 5169:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var isDetached = __webpack_require__(3238);

var $TypeError = TypeError;

module.exports = function (it) {
  if (isDetached(it)) throw new $TypeError('ArrayBuffer is detached');
  return it;
};


/***/ }),

/***/ 5170:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var uncurryThisAccessor = __webpack_require__(6706);
var SetHelpers = __webpack_require__(4402);

module.exports = uncurryThisAccessor(SetHelpers.proto, 'size', 'get') || function (set) {
  return set.size;
};


/***/ }),

/***/ 5370:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var lengthOfArrayLike = __webpack_require__(6198);

module.exports = function (Constructor, list, $length) {
  var index = 0;
  var length = arguments.length > 2 ? $length : lengthOfArrayLike(list);
  var result = new Constructor(length);
  while (length > index) result[index] = list[index++];
  return result;
};


/***/ }),

/***/ 5397:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


// toObject with fallback for non-array-like ES3 strings
var IndexedObject = __webpack_require__(7055);
var requireObjectCoercible = __webpack_require__(7750);

module.exports = function (it) {
  return IndexedObject(requireObjectCoercible(it));
};


/***/ }),

/***/ 5610:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var toIntegerOrInfinity = __webpack_require__(1291);

var max = Math.max;
var min = Math.min;

// Helper for a popular repeating case of the spec:
// Let integer be ? ToInteger(index).
// If integer < 0, let result be max((length + integer), 0); else let result be min(integer, length).
module.exports = function (index, length) {
  var integer = toIntegerOrInfinity(index);
  return integer < 0 ? max(integer + length, 0) : min(integer, length);
};


/***/ }),

/***/ 5623:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {


var $ = __webpack_require__(6518);
var globalThis = __webpack_require__(4576);
var uncurryThis = __webpack_require__(9504);
var anUint8Array = __webpack_require__(4154);
var notDetached = __webpack_require__(5169);

var numberToString = uncurryThis(1.1.toString);

// `Uint8Array.prototype.toHex` method
// https://github.com/tc39/proposal-arraybuffer-base64
if (globalThis.Uint8Array) $({ target: 'Uint8Array', proto: true }, {
  toHex: function toHex() {
    anUint8Array(this);
    notDetached(this.buffer);
    var result = '';
    for (var i = 0, length = this.length; i < length; i++) {
      var hex = numberToString(this[i], 16);
      result += hex.length === 1 ? '0' + hex : hex;
    }
    return result;
  }
});


/***/ }),

/***/ 5636:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var globalThis = __webpack_require__(4576);
var uncurryThis = __webpack_require__(9504);
var uncurryThisAccessor = __webpack_require__(6706);
var toIndex = __webpack_require__(7696);
var notDetached = __webpack_require__(5169);
var arrayBufferByteLength = __webpack_require__(7394);
var detachTransferable = __webpack_require__(4483);
var PROPER_STRUCTURED_CLONE_TRANSFER = __webpack_require__(1548);

var structuredClone = globalThis.structuredClone;
var ArrayBuffer = globalThis.ArrayBuffer;
var DataView = globalThis.DataView;
var min = Math.min;
var ArrayBufferPrototype = ArrayBuffer.prototype;
var DataViewPrototype = DataView.prototype;
var slice = uncurryThis(ArrayBufferPrototype.slice);
var isResizable = uncurryThisAccessor(ArrayBufferPrototype, 'resizable', 'get');
var maxByteLength = uncurryThisAccessor(ArrayBufferPrototype, 'maxByteLength', 'get');
var getInt8 = uncurryThis(DataViewPrototype.getInt8);
var setInt8 = uncurryThis(DataViewPrototype.setInt8);

module.exports = (PROPER_STRUCTURED_CLONE_TRANSFER || detachTransferable) && function (arrayBuffer, newLength, preserveResizability) {
  var byteLength = arrayBufferByteLength(arrayBuffer);
  var newByteLength = newLength === undefined ? byteLength : toIndex(newLength);
  var fixedLength = !isResizable || !isResizable(arrayBuffer);
  var newBuffer;
  notDetached(arrayBuffer);
  if (PROPER_STRUCTURED_CLONE_TRANSFER) {
    arrayBuffer = structuredClone(arrayBuffer, { transfer: [arrayBuffer] });
    if (byteLength === newByteLength && (preserveResizability || fixedLength)) return arrayBuffer;
  }
  if (byteLength >= newByteLength && (!preserveResizability || fixedLength)) {
    newBuffer = slice(arrayBuffer, 0, newByteLength);
  } else {
    var options = preserveResizability && !fixedLength && maxByteLength ? { maxByteLength: maxByteLength(arrayBuffer) } : undefined;
    newBuffer = new ArrayBuffer(newByteLength, options);
    var a = new DataView(arrayBuffer);
    var b = new DataView(newBuffer);
    var copyLength = min(newByteLength, byteLength);
    for (var i = 0; i < copyLength; i++) setInt8(b, i, getInt8(a, i));
  }
  if (!PROPER_STRUCTURED_CLONE_TRANSFER) detachTransferable(arrayBuffer);
  return newBuffer;
};


/***/ }),

/***/ 5745:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var store = __webpack_require__(7629);

module.exports = function (key, value) {
  return store[key] || (store[key] = value || {});
};


/***/ }),

/***/ 5781:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {


var $ = __webpack_require__(6518);
var getBuiltIn = __webpack_require__(7751);
var validateArgumentsLength = __webpack_require__(2812);
var toString = __webpack_require__(655);
var USE_NATIVE_URL = __webpack_require__(7416);

var URL = getBuiltIn('URL');

// `URL.parse` method
// https://url.spec.whatwg.org/#dom-url-canparse
$({ target: 'URL', stat: true, forced: !USE_NATIVE_URL }, {
  parse: function parse(url) {
    var length = validateArgumentsLength(arguments.length, 1);
    var urlString = toString(url);
    var base = length < 2 || arguments[1] === undefined ? undefined : toString(arguments[1]);
    try {
      return new URL(urlString, base);
    } catch (error) {
      return null;
    }
  }
});


/***/ }),

/***/ 5854:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var toPrimitive = __webpack_require__(2777);

var $TypeError = TypeError;

// `ToBigInt` abstract operation
// https://tc39.es/ecma262/#sec-tobigint
module.exports = function (argument) {
  var prim = toPrimitive(argument, 'number');
  if (typeof prim == 'number') throw new $TypeError("Can't convert number to bigint");
  // eslint-disable-next-line es/no-bigint -- safe
  return BigInt(prim);
};


/***/ }),

/***/ 5876:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {


var $ = __webpack_require__(6518);
var isSubsetOf = __webpack_require__(3838);
var setMethodAcceptSetLike = __webpack_require__(4916);

var INCORRECT = !setMethodAcceptSetLike('isSubsetOf', function (result) {
  return result;
});

// `Set.prototype.isSubsetOf` method
// https://tc39.es/ecma262/#sec-set.prototype.issubsetof
$({ target: 'Set', proto: true, real: true, forced: INCORRECT }, {
  isSubsetOf: isSubsetOf
});


/***/ }),

/***/ 5917:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var DESCRIPTORS = __webpack_require__(3724);
var fails = __webpack_require__(9039);
var createElement = __webpack_require__(4055);

// Thanks to IE8 for its funny defineProperty
module.exports = !DESCRIPTORS && !fails(function () {
  // eslint-disable-next-line es/no-object-defineproperty -- required for testing
  return Object.defineProperty(createElement('div'), 'a', {
    get: function () { return 7; }
  }).a !== 7;
});


/***/ }),

/***/ 5966:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var aCallable = __webpack_require__(9306);
var isNullOrUndefined = __webpack_require__(4117);

// `GetMethod` abstract operation
// https://tc39.es/ecma262/#sec-getmethod
module.exports = function (V, P) {
  var func = V[P];
  return isNullOrUndefined(func) ? undefined : aCallable(func);
};


/***/ }),

/***/ 6043:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var aCallable = __webpack_require__(9306);

var $TypeError = TypeError;

var PromiseCapability = function (C) {
  var resolve, reject;
  this.promise = new C(function ($$resolve, $$reject) {
    if (resolve !== undefined || reject !== undefined) throw new $TypeError('Bad Promise constructor');
    resolve = $$resolve;
    reject = $$reject;
  });
  this.resolve = aCallable(resolve);
  this.reject = aCallable(reject);
};

// `NewPromiseCapability` abstract operation
// https://tc39.es/ecma262/#sec-newpromisecapability
module.exports.f = function (C) {
  return new PromiseCapability(C);
};


/***/ }),

/***/ 6080:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var uncurryThis = __webpack_require__(7476);
var aCallable = __webpack_require__(9306);
var NATIVE_BIND = __webpack_require__(616);

var bind = uncurryThis(uncurryThis.bind);

// optional / simple context binding
module.exports = function (fn, that) {
  aCallable(fn);
  return that === undefined ? fn : NATIVE_BIND ? bind(fn, that) : function (/* ...args */) {
    return fn.apply(that, arguments);
  };
};


/***/ }),

/***/ 6119:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var shared = __webpack_require__(5745);
var uid = __webpack_require__(3392);

var keys = shared('keys');

module.exports = function (key) {
  return keys[key] || (keys[key] = uid(key));
};


/***/ }),

/***/ 6193:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var uncurryThis = __webpack_require__(9504);

var $Error = Error;
var replace = uncurryThis(''.replace);

var TEST = (function (arg) { return String(new $Error(arg).stack); })('zxcasd');
// eslint-disable-next-line redos/no-vulnerable, sonarjs/slow-regex -- safe
var V8_OR_CHAKRA_STACK_ENTRY = /\n\s*at [^:]*:[^\n]*/;
var IS_V8_OR_CHAKRA_STACK = V8_OR_CHAKRA_STACK_ENTRY.test(TEST);

module.exports = function (stack, dropEntries) {
  if (IS_V8_OR_CHAKRA_STACK && typeof stack == 'string' && !$Error.prepareStackTrace) {
    while (dropEntries--) stack = replace(stack, V8_OR_CHAKRA_STACK_ENTRY, '');
  } return stack;
};


/***/ }),

/***/ 6198:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var toLength = __webpack_require__(8014);

// `LengthOfArrayLike` abstract operation
// https://tc39.es/ecma262/#sec-lengthofarraylike
module.exports = function (obj) {
  return toLength(obj.length);
};


/***/ }),

/***/ 6269:
/***/ ((module) => {


module.exports = {};


/***/ }),

/***/ 6279:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var defineBuiltIn = __webpack_require__(6840);

module.exports = function (target, src, options) {
  for (var key in src) defineBuiltIn(target, key, src[key], options);
  return target;
};


/***/ }),

/***/ 6280:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {


/* eslint-disable no-unused-vars -- required for functions `.length` */
var $ = __webpack_require__(6518);
var globalThis = __webpack_require__(4576);
var apply = __webpack_require__(8745);
var wrapErrorConstructorWithCause = __webpack_require__(4601);

var WEB_ASSEMBLY = 'WebAssembly';
var WebAssembly = globalThis[WEB_ASSEMBLY];

// eslint-disable-next-line es/no-error-cause -- feature detection
var FORCED = new Error('e', { cause: 7 }).cause !== 7;

var exportGlobalErrorCauseWrapper = function (ERROR_NAME, wrapper) {
  var O = {};
  O[ERROR_NAME] = wrapErrorConstructorWithCause(ERROR_NAME, wrapper, FORCED);
  $({ global: true, constructor: true, arity: 1, forced: FORCED }, O);
};

var exportWebAssemblyErrorCauseWrapper = function (ERROR_NAME, wrapper) {
  if (WebAssembly && WebAssembly[ERROR_NAME]) {
    var O = {};
    O[ERROR_NAME] = wrapErrorConstructorWithCause(WEB_ASSEMBLY + '.' + ERROR_NAME, wrapper, FORCED);
    $({ target: WEB_ASSEMBLY, stat: true, constructor: true, arity: 1, forced: FORCED }, O);
  }
};

// https://tc39.es/ecma262/#sec-nativeerror
exportGlobalErrorCauseWrapper('Error', function (init) {
  return function Error(message) { return apply(init, this, arguments); };
});
exportGlobalErrorCauseWrapper('EvalError', function (init) {
  return function EvalError(message) { return apply(init, this, arguments); };
});
exportGlobalErrorCauseWrapper('RangeError', function (init) {
  return function RangeError(message) { return apply(init, this, arguments); };
});
exportGlobalErrorCauseWrapper('ReferenceError', function (init) {
  return function ReferenceError(message) { return apply(init, this, arguments); };
});
exportGlobalErrorCauseWrapper('SyntaxError', function (init) {
  return function SyntaxError(message) { return apply(init, this, arguments); };
});
exportGlobalErrorCauseWrapper('TypeError', function (init) {
  return function TypeError(message) { return apply(init, this, arguments); };
});
exportGlobalErrorCauseWrapper('URIError', function (init) {
  return function URIError(message) { return apply(init, this, arguments); };
});
exportWebAssemblyErrorCauseWrapper('CompileError', function (init) {
  return function CompileError(message) { return apply(init, this, arguments); };
});
exportWebAssemblyErrorCauseWrapper('LinkError', function (init) {
  return function LinkError(message) { return apply(init, this, arguments); };
});
exportWebAssemblyErrorCauseWrapper('RuntimeError', function (init) {
  return function RuntimeError(message) { return apply(init, this, arguments); };
});


/***/ }),

/***/ 6319:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var anObject = __webpack_require__(8551);
var iteratorClose = __webpack_require__(9539);

// call something on iterator step with safe closing on error
module.exports = function (iterator, fn, value, ENTRIES) {
  try {
    return ENTRIES ? fn(anObject(value)[0], value[1]) : fn(value);
  } catch (error) {
    iteratorClose(iterator, 'throw', error);
  }
};


/***/ }),

/***/ 6395:
/***/ ((module) => {


module.exports = false;


/***/ }),

/***/ 6469:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var wellKnownSymbol = __webpack_require__(8227);
var create = __webpack_require__(2360);
var defineProperty = (__webpack_require__(4913).f);

var UNSCOPABLES = wellKnownSymbol('unscopables');
var ArrayPrototype = Array.prototype;

// Array.prototype[@@unscopables]
// https://tc39.es/ecma262/#sec-array.prototype-@@unscopables
if (ArrayPrototype[UNSCOPABLES] === undefined) {
  defineProperty(ArrayPrototype, UNSCOPABLES, {
    configurable: true,
    value: create(null)
  });
}

// add a key to Array.prototype[@@unscopables]
module.exports = function (key) {
  ArrayPrototype[UNSCOPABLES][key] = true;
};


/***/ }),

/***/ 6518:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var globalThis = __webpack_require__(4576);
var getOwnPropertyDescriptor = (__webpack_require__(7347).f);
var createNonEnumerableProperty = __webpack_require__(6699);
var defineBuiltIn = __webpack_require__(6840);
var defineGlobalProperty = __webpack_require__(9433);
var copyConstructorProperties = __webpack_require__(7740);
var isForced = __webpack_require__(2796);

/*
  options.target         - name of the target object
  options.global         - target is the global object
  options.stat           - export as static methods of target
  options.proto          - export as prototype methods of target
  options.real           - real prototype method for the `pure` version
  options.forced         - export even if the native feature is available
  options.bind           - bind methods to the target, required for the `pure` version
  options.wrap           - wrap constructors to preventing global pollution, required for the `pure` version
  options.unsafe         - use the simple assignment of property instead of delete + defineProperty
  options.sham           - add a flag to not completely full polyfills
  options.enumerable     - export as enumerable property
  options.dontCallGetSet - prevent calling a getter on target
  options.name           - the .name of the function if it does not match the key
*/
module.exports = function (options, source) {
  var TARGET = options.target;
  var GLOBAL = options.global;
  var STATIC = options.stat;
  var FORCED, target, key, targetProperty, sourceProperty, descriptor;
  if (GLOBAL) {
    target = globalThis;
  } else if (STATIC) {
    target = globalThis[TARGET] || defineGlobalProperty(TARGET, {});
  } else {
    target = globalThis[TARGET] && globalThis[TARGET].prototype;
  }
  if (target) for (key in source) {
    sourceProperty = source[key];
    if (options.dontCallGetSet) {
      descriptor = getOwnPropertyDescriptor(target, key);
      targetProperty = descriptor && descriptor.value;
    } else targetProperty = target[key];
    FORCED = isForced(GLOBAL ? key : TARGET + (STATIC ? '.' : '#') + key, options.forced);
    // contained in target
    if (!FORCED && targetProperty !== undefined) {
      if (typeof sourceProperty == typeof targetProperty) continue;
      copyConstructorProperties(sourceProperty, targetProperty);
    }
    // add a flag to not completely full polyfills
    if (options.sham || (targetProperty && targetProperty.sham)) {
      createNonEnumerableProperty(sourceProperty, 'sham', true);
    }
    defineBuiltIn(target, key, sourceProperty, options);
  }
};


/***/ }),

/***/ 6573:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {


var DESCRIPTORS = __webpack_require__(3724);
var defineBuiltInAccessor = __webpack_require__(2106);
var isDetached = __webpack_require__(3238);

var ArrayBufferPrototype = ArrayBuffer.prototype;

// `ArrayBuffer.prototype.detached` getter
// https://tc39.es/ecma262/#sec-get-arraybuffer.prototype.detached
if (DESCRIPTORS && !('detached' in ArrayBufferPrototype)) {
  defineBuiltInAccessor(ArrayBufferPrototype, 'detached', {
    configurable: true,
    get: function detached() {
      return isDetached(this);
    }
  });
}


/***/ }),

/***/ 6699:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var DESCRIPTORS = __webpack_require__(3724);
var definePropertyModule = __webpack_require__(4913);
var createPropertyDescriptor = __webpack_require__(6980);

module.exports = DESCRIPTORS ? function (object, key, value) {
  return definePropertyModule.f(object, key, createPropertyDescriptor(1, value));
} : function (object, key, value) {
  object[key] = value;
  return object;
};


/***/ }),

/***/ 6706:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var uncurryThis = __webpack_require__(9504);
var aCallable = __webpack_require__(9306);

module.exports = function (object, key, method) {
  try {
    // eslint-disable-next-line es/no-object-getownpropertydescriptor -- safe
    return uncurryThis(aCallable(Object.getOwnPropertyDescriptor(object, key)[method]));
  } catch (error) { /* empty */ }
};


/***/ }),

/***/ 6801:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


var DESCRIPTORS = __webpack_require__(3724);
var V8_PROTOTYPE_DEFINE_BUG = __webpack_require__(8686);
var definePropertyModule = __webpack_require__(4913);
var anObject = __webpack_require__(8551);
var toIndexedObject = __webpack_require__(5397);
var objectKeys = __webpack_require__(1072);

// `Object.defineProperties` method
// https://tc39.es/ecma262/#sec-object.defineproperties
// eslint-disable-next-line es/no-object-defineproperties -- safe
exports.f = DESCRIPTORS && !V8_PROTOTYPE_DEFINE_BUG ? Object.defineProperties : function defineProperties(O, Properties) {
  anObject(O);
  var props = toIndexedObject(Properties);
  var keys = objectKeys(Properties);
  var length = keys.length;
  var index = 0;
  var key;
  while (length > index) definePropertyModule.f(O, key = keys[index++], props[key]);
  return O;
};


/***/ }),

/***/ 6823:
/***/ ((module) => {


var $String = String;

module.exports = function (argument) {
  try {
    return $String(argument);
  } catch (error) {
    return 'Object';
  }
};


/***/ }),

/***/ 6837:
/***/ ((module) => {


var $TypeError = TypeError;
var MAX_SAFE_INTEGER = 0x1FFFFFFFFFFFFF; // 2 ** 53 - 1 == 9007199254740991

module.exports = function (it) {
  if (it > MAX_SAFE_INTEGER) throw $TypeError('Maximum allowed index exceeded');
  return it;
};


/***/ }),

/***/ 6840:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var isCallable = __webpack_require__(4901);
var definePropertyModule = __webpack_require__(4913);
var makeBuiltIn = __webpack_require__(283);
var defineGlobalProperty = __webpack_require__(9433);

module.exports = function (O, key, value, options) {
  if (!options) options = {};
  var simple = options.enumerable;
  var name = options.name !== undefined ? options.name : key;
  if (isCallable(value)) makeBuiltIn(value, name, options);
  if (options.global) {
    if (simple) O[key] = value;
    else defineGlobalProperty(key, value);
  } else {
    try {
      if (!options.unsafe) delete O[key];
      else if (O[key]) simple = true;
    } catch (error) { /* empty */ }
    if (simple) O[key] = value;
    else definePropertyModule.f(O, key, {
      value: value,
      enumerable: false,
      configurable: !options.nonConfigurable,
      writable: !options.nonWritable
    });
  } return O;
};


/***/ }),

/***/ 6955:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var TO_STRING_TAG_SUPPORT = __webpack_require__(2140);
var isCallable = __webpack_require__(4901);
var classofRaw = __webpack_require__(2195);
var wellKnownSymbol = __webpack_require__(8227);

var TO_STRING_TAG = wellKnownSymbol('toStringTag');
var $Object = Object;

// ES3 wrong here
var CORRECT_ARGUMENTS = classofRaw(function () { return arguments; }()) === 'Arguments';

// fallback for IE11 Script Access Denied error
var tryGet = function (it, key) {
  try {
    return it[key];
  } catch (error) { /* empty */ }
};

// getting tag from ES6+ `Object.prototype.toString`
module.exports = TO_STRING_TAG_SUPPORT ? classofRaw : function (it) {
  var O, tag, result;
  return it === undefined ? 'Undefined' : it === null ? 'Null'
    // @@toStringTag case
    : typeof (tag = tryGet(O = $Object(it), TO_STRING_TAG)) == 'string' ? tag
    // builtinTag case
    : CORRECT_ARGUMENTS ? classofRaw(O)
    // ES3 arguments fallback
    : (result = classofRaw(O)) === 'Object' && isCallable(O.callee) ? 'Arguments' : result;
};


/***/ }),

/***/ 6969:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var toPrimitive = __webpack_require__(2777);
var isSymbol = __webpack_require__(757);

// `ToPropertyKey` abstract operation
// https://tc39.es/ecma262/#sec-topropertykey
module.exports = function (argument) {
  var key = toPrimitive(argument, 'string');
  return isSymbol(key) ? key : key + '';
};


/***/ }),

/***/ 6980:
/***/ ((module) => {


module.exports = function (bitmap, value) {
  return {
    enumerable: !(bitmap & 1),
    configurable: !(bitmap & 2),
    writable: !(bitmap & 4),
    value: value
  };
};


/***/ }),

/***/ 7040:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


/* eslint-disable es/no-symbol -- required for testing */
var NATIVE_SYMBOL = __webpack_require__(4495);

module.exports = NATIVE_SYMBOL &&
  !Symbol.sham &&
  typeof Symbol.iterator == 'symbol';


/***/ }),

/***/ 7055:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var uncurryThis = __webpack_require__(9504);
var fails = __webpack_require__(9039);
var classof = __webpack_require__(2195);

var $Object = Object;
var split = uncurryThis(''.split);

// fallback for non-array-like ES3 and non-enumerable old V8 strings
module.exports = fails(function () {
  // throws an error in rhino, see https://github.com/mozilla/rhino/issues/346
  // eslint-disable-next-line no-prototype-builtins -- safe
  return !$Object('z').propertyIsEnumerable(0);
}) ? function (it) {
  return classof(it) === 'String' ? split(it, '') : $Object(it);
} : $Object;


/***/ }),

/***/ 7080:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var has = (__webpack_require__(4402).has);

// Perform ? RequireInternalSlot(M, [[SetData]])
module.exports = function (it) {
  has(it);
  return it;
};


/***/ }),

/***/ 7347:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


var DESCRIPTORS = __webpack_require__(3724);
var call = __webpack_require__(9565);
var propertyIsEnumerableModule = __webpack_require__(8773);
var createPropertyDescriptor = __webpack_require__(6980);
var toIndexedObject = __webpack_require__(5397);
var toPropertyKey = __webpack_require__(6969);
var hasOwn = __webpack_require__(9297);
var IE8_DOM_DEFINE = __webpack_require__(5917);

// eslint-disable-next-line es/no-object-getownpropertydescriptor -- safe
var $getOwnPropertyDescriptor = Object.getOwnPropertyDescriptor;

// `Object.getOwnPropertyDescriptor` method
// https://tc39.es/ecma262/#sec-object.getownpropertydescriptor
exports.f = DESCRIPTORS ? $getOwnPropertyDescriptor : function getOwnPropertyDescriptor(O, P) {
  O = toIndexedObject(O);
  P = toPropertyKey(P);
  if (IE8_DOM_DEFINE) try {
    return $getOwnPropertyDescriptor(O, P);
  } catch (error) { /* empty */ }
  if (hasOwn(O, P)) return createPropertyDescriptor(!call(propertyIsEnumerableModule.f, O, P), O[P]);
};


/***/ }),

/***/ 7357:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {


var $ = __webpack_require__(6518);
var uncurryThis = __webpack_require__(9504);
var requireObjectCoercible = __webpack_require__(7750);
var toIntegerOrInfinity = __webpack_require__(1291);
var toString = __webpack_require__(655);
var fails = __webpack_require__(9039);

var charAt = uncurryThis(''.charAt);

var FORCED = fails(function () {
  // eslint-disable-next-line es/no-string-prototype-at -- safe
  return '𠮷'.at(-2) !== '\uD842';
});

// `String.prototype.at` method
// https://tc39.es/ecma262/#sec-string.prototype.at
$({ target: 'String', proto: true, forced: FORCED }, {
  at: function at(index) {
    var S = toString(requireObjectCoercible(this));
    var len = S.length;
    var relativeIndex = toIntegerOrInfinity(index);
    var k = relativeIndex >= 0 ? relativeIndex : len + relativeIndex;
    return (k < 0 || k >= len) ? undefined : charAt(S, k);
  }
});


/***/ }),

/***/ 7394:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var globalThis = __webpack_require__(4576);
var uncurryThisAccessor = __webpack_require__(6706);
var classof = __webpack_require__(2195);

var ArrayBuffer = globalThis.ArrayBuffer;
var TypeError = globalThis.TypeError;

// Includes
// - Perform ? RequireInternalSlot(O, [[ArrayBufferData]]).
// - If IsSharedArrayBuffer(O) is true, throw a TypeError exception.
module.exports = ArrayBuffer && uncurryThisAccessor(ArrayBuffer.prototype, 'byteLength', 'get') || function (O) {
  if (classof(O) !== 'ArrayBuffer') throw new TypeError('ArrayBuffer expected');
  return O.byteLength;
};


/***/ }),

/***/ 7416:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var fails = __webpack_require__(9039);
var wellKnownSymbol = __webpack_require__(8227);
var DESCRIPTORS = __webpack_require__(3724);
var IS_PURE = __webpack_require__(6395);

var ITERATOR = wellKnownSymbol('iterator');

module.exports = !fails(function () {
  // eslint-disable-next-line unicorn/relative-url-style -- required for testing
  var url = new URL('b?a=1&b=2&c=3', 'https://a');
  var params = url.searchParams;
  var params2 = new URLSearchParams('a=1&a=2&b=3');
  var result = '';
  url.pathname = 'c%20d';
  params.forEach(function (value, key) {
    params['delete']('b');
    result += key + value;
  });
  params2['delete']('a', 2);
  // `undefined` case is a Chromium 117 bug
  // https://bugs.chromium.org/p/v8/issues/detail?id=14222
  params2['delete']('b', undefined);
  return (IS_PURE && (!url.toJSON || !params2.has('a', 1) || params2.has('a', 2) || !params2.has('a', undefined) || params2.has('b')))
    || (!params.size && (IS_PURE || !DESCRIPTORS))
    || !params.sort
    || url.href !== 'https://a/c%20d?a=1&c=3'
    || params.get('c') !== '3'
    || String(new URLSearchParams('?a=1')) !== 'a=1'
    || !params[ITERATOR]
    // throws in Edge
    || new URL('https://a@b').username !== 'a'
    || new URLSearchParams(new URLSearchParams('a=b')).get('a') !== 'b'
    // not punycoded in Edge
    || new URL('https://тест').host !== 'xn--e1aybc'
    // not escaped in Chrome 62-
    || new URL('https://a#б').hash !== '#%D0%B1'
    // fails in Chrome 66-
    || result !== 'a1c3'
    // throws in Safari
    || new URL('https://x', undefined).host !== 'x';
});


/***/ }),

/***/ 7467:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {


var arrayToReversed = __webpack_require__(7628);
var ArrayBufferViewCore = __webpack_require__(4644);

var aTypedArray = ArrayBufferViewCore.aTypedArray;
var exportTypedArrayMethod = ArrayBufferViewCore.exportTypedArrayMethod;
var getTypedArrayConstructor = ArrayBufferViewCore.getTypedArrayConstructor;

// `%TypedArray%.prototype.toReversed` method
// https://tc39.es/ecma262/#sec-%typedarray%.prototype.toreversed
exportTypedArrayMethod('toReversed', function toReversed() {
  return arrayToReversed(aTypedArray(this), getTypedArrayConstructor(this));
});


/***/ }),

/***/ 7476:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var classofRaw = __webpack_require__(2195);
var uncurryThis = __webpack_require__(9504);

module.exports = function (fn) {
  // Nashorn bug:
  //   https://github.com/zloirock/core-js/issues/1128
  //   https://github.com/zloirock/core-js/issues/1130
  if (classofRaw(fn) === 'Function') return uncurryThis(fn);
};


/***/ }),

/***/ 7566:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {


var defineBuiltIn = __webpack_require__(6840);
var uncurryThis = __webpack_require__(9504);
var toString = __webpack_require__(655);
var validateArgumentsLength = __webpack_require__(2812);

var $URLSearchParams = URLSearchParams;
var URLSearchParamsPrototype = $URLSearchParams.prototype;
var getAll = uncurryThis(URLSearchParamsPrototype.getAll);
var $has = uncurryThis(URLSearchParamsPrototype.has);
var params = new $URLSearchParams('a=1');

// `undefined` case is a Chromium 117 bug
// https://bugs.chromium.org/p/v8/issues/detail?id=14222
if (params.has('a', 2) || !params.has('a', undefined)) {
  defineBuiltIn(URLSearchParamsPrototype, 'has', function has(name /* , value */) {
    var length = arguments.length;
    var $value = length < 2 ? undefined : arguments[1];
    if (length && $value === undefined) return $has(this, name);
    var values = getAll(this, name); // also validates `this`
    validateArgumentsLength(length, 1);
    var value = toString($value);
    var index = 0;
    while (index < values.length) {
      if (values[index++] === value) return true;
    } return false;
  }, { enumerable: true, unsafe: true });
}


/***/ }),

/***/ 7584:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var isObject = __webpack_require__(34);
var createNonEnumerableProperty = __webpack_require__(6699);

// `InstallErrorCause` abstract operation
// https://tc39.es/proposal-error-cause/#sec-errorobjects-install-error-cause
module.exports = function (O, options) {
  if (isObject(options) && 'cause' in options) {
    createNonEnumerableProperty(O, 'cause', options.cause);
  }
};


/***/ }),

/***/ 7588:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {


var $ = __webpack_require__(6518);
var call = __webpack_require__(9565);
var iterate = __webpack_require__(2652);
var aCallable = __webpack_require__(9306);
var anObject = __webpack_require__(8551);
var getIteratorDirect = __webpack_require__(1767);
var iteratorClose = __webpack_require__(9539);
var iteratorHelperWithoutClosingOnEarlyError = __webpack_require__(4549);

var forEachWithoutClosingOnEarlyError = iteratorHelperWithoutClosingOnEarlyError('forEach', TypeError);

// `Iterator.prototype.forEach` method
// https://tc39.es/ecma262/#sec-iterator.prototype.foreach
$({ target: 'Iterator', proto: true, real: true, forced: forEachWithoutClosingOnEarlyError }, {
  forEach: function forEach(fn) {
    anObject(this);
    try {
      aCallable(fn);
    } catch (error) {
      iteratorClose(this, 'throw', error);
    }

    if (forEachWithoutClosingOnEarlyError) return call(forEachWithoutClosingOnEarlyError, this, fn);

    var record = getIteratorDirect(this);
    var counter = 0;
    iterate(record, function (value) {
      fn(value, counter++);
    }, { IS_RECORD: true });
  }
});


/***/ }),

/***/ 7628:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var lengthOfArrayLike = __webpack_require__(6198);

// https://tc39.es/proposal-change-array-by-copy/#sec-array.prototype.toReversed
// https://tc39.es/proposal-change-array-by-copy/#sec-%typedarray%.prototype.toReversed
module.exports = function (O, C) {
  var len = lengthOfArrayLike(O);
  var A = new C(len);
  var k = 0;
  for (; k < len; k++) A[k] = O[len - k - 1];
  return A;
};


/***/ }),

/***/ 7629:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var IS_PURE = __webpack_require__(6395);
var globalThis = __webpack_require__(4576);
var defineGlobalProperty = __webpack_require__(9433);

var SHARED = '__core-js_shared__';
var store = module.exports = globalThis[SHARED] || defineGlobalProperty(SHARED, {});

(store.versions || (store.versions = [])).push({
  version: '3.43.0',
  mode: IS_PURE ? 'pure' : 'global',
  copyright: '© 2014-2025 Denis Pushkarev (zloirock.ru)',
  license: 'https://github.com/zloirock/core-js/blob/v3.43.0/LICENSE',
  source: 'https://github.com/zloirock/core-js'
});


/***/ }),

/***/ 7642:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {


var $ = __webpack_require__(6518);
var difference = __webpack_require__(3440);
var fails = __webpack_require__(9039);
var setMethodAcceptSetLike = __webpack_require__(4916);

var SET_LIKE_INCORRECT_BEHAVIOR = !setMethodAcceptSetLike('difference', function (result) {
  return result.size === 0;
});

var FORCED = SET_LIKE_INCORRECT_BEHAVIOR || fails(function () {
  // https://bugs.webkit.org/show_bug.cgi?id=288595
  var setLike = {
    size: 1,
    has: function () { return true; },
    keys: function () {
      var index = 0;
      return {
        next: function () {
          var done = index++ > 1;
          if (baseSet.has(1)) baseSet.clear();
          return { done: done, value: 2 };
        }
      };
    }
  };
  // eslint-disable-next-line es/no-set -- testing
  var baseSet = new Set([1, 2, 3, 4]);
  // eslint-disable-next-line es/no-set-prototype-difference -- testing
  return baseSet.difference(setLike).size !== 3;
});

// `Set.prototype.difference` method
// https://tc39.es/ecma262/#sec-set.prototype.difference
$({ target: 'Set', proto: true, real: true, forced: FORCED }, {
  difference: difference
});


/***/ }),

/***/ 7657:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var fails = __webpack_require__(9039);
var isCallable = __webpack_require__(4901);
var isObject = __webpack_require__(34);
var create = __webpack_require__(2360);
var getPrototypeOf = __webpack_require__(2787);
var defineBuiltIn = __webpack_require__(6840);
var wellKnownSymbol = __webpack_require__(8227);
var IS_PURE = __webpack_require__(6395);

var ITERATOR = wellKnownSymbol('iterator');
var BUGGY_SAFARI_ITERATORS = false;

// `%IteratorPrototype%` object
// https://tc39.es/ecma262/#sec-%iteratorprototype%-object
var IteratorPrototype, PrototypeOfArrayIteratorPrototype, arrayIterator;

/* eslint-disable es/no-array-prototype-keys -- safe */
if ([].keys) {
  arrayIterator = [].keys();
  // Safari 8 has buggy iterators w/o `next`
  if (!('next' in arrayIterator)) BUGGY_SAFARI_ITERATORS = true;
  else {
    PrototypeOfArrayIteratorPrototype = getPrototypeOf(getPrototypeOf(arrayIterator));
    if (PrototypeOfArrayIteratorPrototype !== Object.prototype) IteratorPrototype = PrototypeOfArrayIteratorPrototype;
  }
}

var NEW_ITERATOR_PROTOTYPE = !isObject(IteratorPrototype) || fails(function () {
  var test = {};
  // FF44- legacy iterators case
  return IteratorPrototype[ITERATOR].call(test) !== test;
});

if (NEW_ITERATOR_PROTOTYPE) IteratorPrototype = {};
else if (IS_PURE) IteratorPrototype = create(IteratorPrototype);

// `%IteratorPrototype%[@@iterator]()` method
// https://tc39.es/ecma262/#sec-%iteratorprototype%-@@iterator
if (!isCallable(IteratorPrototype[ITERATOR])) {
  defineBuiltIn(IteratorPrototype, ITERATOR, function () {
    return this;
  });
}

module.exports = {
  IteratorPrototype: IteratorPrototype,
  BUGGY_SAFARI_ITERATORS: BUGGY_SAFARI_ITERATORS
};


/***/ }),

/***/ 7680:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var uncurryThis = __webpack_require__(9504);

module.exports = uncurryThis([].slice);


/***/ }),

/***/ 7696:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var toIntegerOrInfinity = __webpack_require__(1291);
var toLength = __webpack_require__(8014);

var $RangeError = RangeError;

// `ToIndex` abstract operation
// https://tc39.es/ecma262/#sec-toindex
module.exports = function (it) {
  if (it === undefined) return 0;
  var number = toIntegerOrInfinity(it);
  var length = toLength(number);
  if (number !== length) throw new $RangeError('Wrong length or index');
  return length;
};


/***/ }),

/***/ 7740:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var hasOwn = __webpack_require__(9297);
var ownKeys = __webpack_require__(5031);
var getOwnPropertyDescriptorModule = __webpack_require__(7347);
var definePropertyModule = __webpack_require__(4913);

module.exports = function (target, source, exceptions) {
  var keys = ownKeys(source);
  var defineProperty = definePropertyModule.f;
  var getOwnPropertyDescriptor = getOwnPropertyDescriptorModule.f;
  for (var i = 0; i < keys.length; i++) {
    var key = keys[i];
    if (!hasOwn(target, key) && !(exceptions && hasOwn(exceptions, key))) {
      defineProperty(target, key, getOwnPropertyDescriptor(source, key));
    }
  }
};


/***/ }),

/***/ 7750:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var isNullOrUndefined = __webpack_require__(4117);

var $TypeError = TypeError;

// `RequireObjectCoercible` abstract operation
// https://tc39.es/ecma262/#sec-requireobjectcoercible
module.exports = function (it) {
  if (isNullOrUndefined(it)) throw new $TypeError("Can't call method on " + it);
  return it;
};


/***/ }),

/***/ 7751:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var globalThis = __webpack_require__(4576);
var isCallable = __webpack_require__(4901);

var aFunction = function (argument) {
  return isCallable(argument) ? argument : undefined;
};

module.exports = function (namespace, method) {
  return arguments.length < 2 ? aFunction(globalThis[namespace]) : globalThis[namespace] && globalThis[namespace][method];
};


/***/ }),

/***/ 7811:
/***/ ((module) => {


// eslint-disable-next-line es/no-typed-arrays -- safe
module.exports = typeof ArrayBuffer != 'undefined' && typeof DataView != 'undefined';


/***/ }),

/***/ 7936:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {


var $ = __webpack_require__(6518);
var $transfer = __webpack_require__(5636);

// `ArrayBuffer.prototype.transferToFixedLength` method
// https://tc39.es/proposal-arraybuffer-transfer/#sec-arraybuffer.prototype.transfertofixedlength
if ($transfer) $({ target: 'ArrayBuffer', proto: true }, {
  transferToFixedLength: function transferToFixedLength() {
    return $transfer(this, arguments.length ? arguments[0] : undefined, false);
  }
});


/***/ }),

/***/ 8004:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {


var $ = __webpack_require__(6518);
var fails = __webpack_require__(9039);
var intersection = __webpack_require__(8750);
var setMethodAcceptSetLike = __webpack_require__(4916);

var INCORRECT = !setMethodAcceptSetLike('intersection', function (result) {
  return result.size === 2 && result.has(1) && result.has(2);
}) || fails(function () {
  // eslint-disable-next-line es/no-array-from, es/no-set, es/no-set-prototype-intersection -- testing
  return String(Array.from(new Set([1, 2, 3]).intersection(new Set([3, 2])))) !== '3,2';
});

// `Set.prototype.intersection` method
// https://tc39.es/ecma262/#sec-set.prototype.intersection
$({ target: 'Set', proto: true, real: true, forced: INCORRECT }, {
  intersection: intersection
});


/***/ }),

/***/ 8014:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var toIntegerOrInfinity = __webpack_require__(1291);

var min = Math.min;

// `ToLength` abstract operation
// https://tc39.es/ecma262/#sec-tolength
module.exports = function (argument) {
  var len = toIntegerOrInfinity(argument);
  return len > 0 ? min(len, 0x1FFFFFFFFFFFFF) : 0; // 2 ** 53 - 1 == 9007199254740991
};


/***/ }),

/***/ 8100:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {


var $ = __webpack_require__(6518);
var $transfer = __webpack_require__(5636);

// `ArrayBuffer.prototype.transfer` method
// https://tc39.es/proposal-arraybuffer-transfer/#sec-arraybuffer.prototype.transfer
if ($transfer) $({ target: 'ArrayBuffer', proto: true }, {
  transfer: function transfer() {
    return $transfer(this, arguments.length ? arguments[0] : undefined, true);
  }
});


/***/ }),

/***/ 8107:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {


var $ = __webpack_require__(6518);
var toObject = __webpack_require__(8981);
var lengthOfArrayLike = __webpack_require__(6198);
var toIntegerOrInfinity = __webpack_require__(1291);
var addToUnscopables = __webpack_require__(6469);

// `Array.prototype.at` method
// https://tc39.es/ecma262/#sec-array.prototype.at
$({ target: 'Array', proto: true }, {
  at: function at(index) {
    var O = toObject(this);
    var len = lengthOfArrayLike(O);
    var relativeIndex = toIntegerOrInfinity(index);
    var k = relativeIndex >= 0 ? relativeIndex : len + relativeIndex;
    return (k < 0 || k >= len) ? undefined : O[k];
  }
});

addToUnscopables('at');


/***/ }),

/***/ 8111:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {


var $ = __webpack_require__(6518);
var globalThis = __webpack_require__(4576);
var anInstance = __webpack_require__(679);
var anObject = __webpack_require__(8551);
var isCallable = __webpack_require__(4901);
var getPrototypeOf = __webpack_require__(2787);
var defineBuiltInAccessor = __webpack_require__(2106);
var createProperty = __webpack_require__(2278);
var fails = __webpack_require__(9039);
var hasOwn = __webpack_require__(9297);
var wellKnownSymbol = __webpack_require__(8227);
var IteratorPrototype = (__webpack_require__(7657).IteratorPrototype);
var DESCRIPTORS = __webpack_require__(3724);
var IS_PURE = __webpack_require__(6395);

var CONSTRUCTOR = 'constructor';
var ITERATOR = 'Iterator';
var TO_STRING_TAG = wellKnownSymbol('toStringTag');

var $TypeError = TypeError;
var NativeIterator = globalThis[ITERATOR];

// FF56- have non-standard global helper `Iterator`
var FORCED = IS_PURE
  || !isCallable(NativeIterator)
  || NativeIterator.prototype !== IteratorPrototype
  // FF44- non-standard `Iterator` passes previous tests
  || !fails(function () { NativeIterator({}); });

var IteratorConstructor = function Iterator() {
  anInstance(this, IteratorPrototype);
  if (getPrototypeOf(this) === IteratorPrototype) throw new $TypeError('Abstract class Iterator not directly constructable');
};

var defineIteratorPrototypeAccessor = function (key, value) {
  if (DESCRIPTORS) {
    defineBuiltInAccessor(IteratorPrototype, key, {
      configurable: true,
      get: function () {
        return value;
      },
      set: function (replacement) {
        anObject(this);
        if (this === IteratorPrototype) throw new $TypeError("You can't redefine this property");
        if (hasOwn(this, key)) this[key] = replacement;
        else createProperty(this, key, replacement);
      }
    });
  } else IteratorPrototype[key] = value;
};

if (!hasOwn(IteratorPrototype, TO_STRING_TAG)) defineIteratorPrototypeAccessor(TO_STRING_TAG, ITERATOR);

if (FORCED || !hasOwn(IteratorPrototype, CONSTRUCTOR) || IteratorPrototype[CONSTRUCTOR] === Object) {
  defineIteratorPrototypeAccessor(CONSTRUCTOR, IteratorConstructor);
}

IteratorConstructor.prototype = IteratorPrototype;

// `Iterator` constructor
// https://tc39.es/ecma262/#sec-iterator
$({ global: true, constructor: true, forced: FORCED }, {
  Iterator: IteratorConstructor
});


/***/ }),

/***/ 8140:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {


var ArrayBufferViewCore = __webpack_require__(4644);
var lengthOfArrayLike = __webpack_require__(6198);
var toIntegerOrInfinity = __webpack_require__(1291);

var aTypedArray = ArrayBufferViewCore.aTypedArray;
var exportTypedArrayMethod = ArrayBufferViewCore.exportTypedArrayMethod;

// `%TypedArray%.prototype.at` method
// https://tc39.es/ecma262/#sec-%typedarray%.prototype.at
exportTypedArrayMethod('at', function at(index) {
  var O = aTypedArray(this);
  var len = lengthOfArrayLike(O);
  var relativeIndex = toIntegerOrInfinity(index);
  var k = relativeIndex >= 0 ? relativeIndex : len + relativeIndex;
  return (k < 0 || k >= len) ? undefined : O[k];
});


/***/ }),

/***/ 8227:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var globalThis = __webpack_require__(4576);
var shared = __webpack_require__(5745);
var hasOwn = __webpack_require__(9297);
var uid = __webpack_require__(3392);
var NATIVE_SYMBOL = __webpack_require__(4495);
var USE_SYMBOL_AS_UID = __webpack_require__(7040);

var Symbol = globalThis.Symbol;
var WellKnownSymbolsStore = shared('wks');
var createWellKnownSymbol = USE_SYMBOL_AS_UID ? Symbol['for'] || Symbol : Symbol && Symbol.withoutSetter || uid;

module.exports = function (name) {
  if (!hasOwn(WellKnownSymbolsStore, name)) {
    WellKnownSymbolsStore[name] = NATIVE_SYMBOL && hasOwn(Symbol, name)
      ? Symbol[name]
      : createWellKnownSymbol('Symbol.' + name);
  } return WellKnownSymbolsStore[name];
};


/***/ }),

/***/ 8229:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var toPositiveInteger = __webpack_require__(9590);

var $RangeError = RangeError;

module.exports = function (it, BYTES) {
  var offset = toPositiveInteger(it);
  if (offset % BYTES) throw new $RangeError('Wrong offset');
  return offset;
};


/***/ }),

/***/ 8235:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var uncurryThis = __webpack_require__(9504);
var hasOwn = __webpack_require__(9297);

var $SyntaxError = SyntaxError;
var $parseInt = parseInt;
var fromCharCode = String.fromCharCode;
var at = uncurryThis(''.charAt);
var slice = uncurryThis(''.slice);
var exec = uncurryThis(/./.exec);

var codePoints = {
  '\\"': '"',
  '\\\\': '\\',
  '\\/': '/',
  '\\b': '\b',
  '\\f': '\f',
  '\\n': '\n',
  '\\r': '\r',
  '\\t': '\t'
};

var IS_4_HEX_DIGITS = /^[\da-f]{4}$/i;
// eslint-disable-next-line regexp/no-control-character -- safe
var IS_C0_CONTROL_CODE = /^[\u0000-\u001F]$/;

module.exports = function (source, i) {
  var unterminated = true;
  var value = '';
  while (i < source.length) {
    var chr = at(source, i);
    if (chr === '\\') {
      var twoChars = slice(source, i, i + 2);
      if (hasOwn(codePoints, twoChars)) {
        value += codePoints[twoChars];
        i += 2;
      } else if (twoChars === '\\u') {
        i += 2;
        var fourHexDigits = slice(source, i, i + 4);
        if (!exec(IS_4_HEX_DIGITS, fourHexDigits)) throw new $SyntaxError('Bad Unicode escape at: ' + i);
        value += fromCharCode($parseInt(fourHexDigits, 16));
        i += 4;
      } else throw new $SyntaxError('Unknown escape sequence: "' + twoChars + '"');
    } else if (chr === '"') {
      unterminated = false;
      i++;
      break;
    } else {
      if (exec(IS_C0_CONTROL_CODE, chr)) throw new $SyntaxError('Bad control character in string literal at: ' + i);
      value += chr;
      i++;
    }
  }
  if (unterminated) throw new $SyntaxError('Unterminated string at: ' + i);
  return { value: value, end: i };
};


/***/ }),

/***/ 8237:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {


var $ = __webpack_require__(6518);
var iterate = __webpack_require__(2652);
var aCallable = __webpack_require__(9306);
var anObject = __webpack_require__(8551);
var getIteratorDirect = __webpack_require__(1767);
var iteratorClose = __webpack_require__(9539);
var iteratorHelperWithoutClosingOnEarlyError = __webpack_require__(4549);
var apply = __webpack_require__(8745);
var fails = __webpack_require__(9039);

var $TypeError = TypeError;

// https://bugs.webkit.org/show_bug.cgi?id=291651
var FAILS_ON_INITIAL_UNDEFINED = fails(function () {
  // eslint-disable-next-line es/no-iterator-prototype-reduce, es/no-array-prototype-keys, array-callback-return -- required for testing
  [].keys().reduce(function () { /* empty */ }, undefined);
});

var reduceWithoutClosingOnEarlyError = !FAILS_ON_INITIAL_UNDEFINED && iteratorHelperWithoutClosingOnEarlyError('reduce', $TypeError);

// `Iterator.prototype.reduce` method
// https://tc39.es/ecma262/#sec-iterator.prototype.reduce
$({ target: 'Iterator', proto: true, real: true, forced: FAILS_ON_INITIAL_UNDEFINED || reduceWithoutClosingOnEarlyError }, {
  reduce: function reduce(reducer /* , initialValue */) {
    anObject(this);
    try {
      aCallable(reducer);
    } catch (error) {
      iteratorClose(this, 'throw', error);
    }

    var noInitial = arguments.length < 2;
    var accumulator = noInitial ? undefined : arguments[1];
    if (reduceWithoutClosingOnEarlyError) {
      return apply(reduceWithoutClosingOnEarlyError, this, noInitial ? [reducer] : [reducer, accumulator]);
    }
    var record = getIteratorDirect(this);
    var counter = 0;
    iterate(record, function (value) {
      if (noInitial) {
        noInitial = false;
        accumulator = value;
      } else {
        accumulator = reducer(accumulator, value, counter);
      }
      counter++;
    }, { IS_RECORD: true });
    if (noInitial) throw new $TypeError('Reduce of empty iterator with no initial value');
    return accumulator;
  }
});


/***/ }),

/***/ 8335:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {


var $ = __webpack_require__(6518);
var DESCRIPTORS = __webpack_require__(3724);
var globalThis = __webpack_require__(4576);
var getBuiltIn = __webpack_require__(7751);
var uncurryThis = __webpack_require__(9504);
var call = __webpack_require__(9565);
var isCallable = __webpack_require__(4901);
var isObject = __webpack_require__(34);
var isArray = __webpack_require__(4376);
var hasOwn = __webpack_require__(9297);
var toString = __webpack_require__(655);
var lengthOfArrayLike = __webpack_require__(6198);
var createProperty = __webpack_require__(2278);
var fails = __webpack_require__(9039);
var parseJSONString = __webpack_require__(8235);
var NATIVE_SYMBOL = __webpack_require__(4495);

var JSON = globalThis.JSON;
var Number = globalThis.Number;
var SyntaxError = globalThis.SyntaxError;
var nativeParse = JSON && JSON.parse;
var enumerableOwnProperties = getBuiltIn('Object', 'keys');
// eslint-disable-next-line es/no-object-getownpropertydescriptor -- safe
var getOwnPropertyDescriptor = Object.getOwnPropertyDescriptor;
var at = uncurryThis(''.charAt);
var slice = uncurryThis(''.slice);
var exec = uncurryThis(/./.exec);
var push = uncurryThis([].push);

var IS_DIGIT = /^\d$/;
var IS_NON_ZERO_DIGIT = /^[1-9]$/;
var IS_NUMBER_START = /^[\d-]$/;
var IS_WHITESPACE = /^[\t\n\r ]$/;

var PRIMITIVE = 0;
var OBJECT = 1;

var $parse = function (source, reviver) {
  source = toString(source);
  var context = new Context(source, 0, '');
  var root = context.parse();
  var value = root.value;
  var endIndex = context.skip(IS_WHITESPACE, root.end);
  if (endIndex < source.length) {
    throw new SyntaxError('Unexpected extra character: "' + at(source, endIndex) + '" after the parsed data at: ' + endIndex);
  }
  return isCallable(reviver) ? internalize({ '': value }, '', reviver, root) : value;
};

var internalize = function (holder, name, reviver, node) {
  var val = holder[name];
  var unmodified = node && val === node.value;
  var context = unmodified && typeof node.source == 'string' ? { source: node.source } : {};
  var elementRecordsLen, keys, len, i, P;
  if (isObject(val)) {
    var nodeIsArray = isArray(val);
    var nodes = unmodified ? node.nodes : nodeIsArray ? [] : {};
    if (nodeIsArray) {
      elementRecordsLen = nodes.length;
      len = lengthOfArrayLike(val);
      for (i = 0; i < len; i++) {
        internalizeProperty(val, i, internalize(val, '' + i, reviver, i < elementRecordsLen ? nodes[i] : undefined));
      }
    } else {
      keys = enumerableOwnProperties(val);
      len = lengthOfArrayLike(keys);
      for (i = 0; i < len; i++) {
        P = keys[i];
        internalizeProperty(val, P, internalize(val, P, reviver, hasOwn(nodes, P) ? nodes[P] : undefined));
      }
    }
  }
  return call(reviver, holder, name, val, context);
};

var internalizeProperty = function (object, key, value) {
  if (DESCRIPTORS) {
    var descriptor = getOwnPropertyDescriptor(object, key);
    if (descriptor && !descriptor.configurable) return;
  }
  if (value === undefined) delete object[key];
  else createProperty(object, key, value);
};

var Node = function (value, end, source, nodes) {
  this.value = value;
  this.end = end;
  this.source = source;
  this.nodes = nodes;
};

var Context = function (source, index) {
  this.source = source;
  this.index = index;
};

// https://www.json.org/json-en.html
Context.prototype = {
  fork: function (nextIndex) {
    return new Context(this.source, nextIndex);
  },
  parse: function () {
    var source = this.source;
    var i = this.skip(IS_WHITESPACE, this.index);
    var fork = this.fork(i);
    var chr = at(source, i);
    if (exec(IS_NUMBER_START, chr)) return fork.number();
    switch (chr) {
      case '{':
        return fork.object();
      case '[':
        return fork.array();
      case '"':
        return fork.string();
      case 't':
        return fork.keyword(true);
      case 'f':
        return fork.keyword(false);
      case 'n':
        return fork.keyword(null);
    } throw new SyntaxError('Unexpected character: "' + chr + '" at: ' + i);
  },
  node: function (type, value, start, end, nodes) {
    return new Node(value, end, type ? null : slice(this.source, start, end), nodes);
  },
  object: function () {
    var source = this.source;
    var i = this.index + 1;
    var expectKeypair = false;
    var object = {};
    var nodes = {};
    while (i < source.length) {
      i = this.until(['"', '}'], i);
      if (at(source, i) === '}' && !expectKeypair) {
        i++;
        break;
      }
      // Parsing the key
      var result = this.fork(i).string();
      var key = result.value;
      i = result.end;
      i = this.until([':'], i) + 1;
      // Parsing value
      i = this.skip(IS_WHITESPACE, i);
      result = this.fork(i).parse();
      createProperty(nodes, key, result);
      createProperty(object, key, result.value);
      i = this.until([',', '}'], result.end);
      var chr = at(source, i);
      if (chr === ',') {
        expectKeypair = true;
        i++;
      } else if (chr === '}') {
        i++;
        break;
      }
    }
    return this.node(OBJECT, object, this.index, i, nodes);
  },
  array: function () {
    var source = this.source;
    var i = this.index + 1;
    var expectElement = false;
    var array = [];
    var nodes = [];
    while (i < source.length) {
      i = this.skip(IS_WHITESPACE, i);
      if (at(source, i) === ']' && !expectElement) {
        i++;
        break;
      }
      var result = this.fork(i).parse();
      push(nodes, result);
      push(array, result.value);
      i = this.until([',', ']'], result.end);
      if (at(source, i) === ',') {
        expectElement = true;
        i++;
      } else if (at(source, i) === ']') {
        i++;
        break;
      }
    }
    return this.node(OBJECT, array, this.index, i, nodes);
  },
  string: function () {
    var index = this.index;
    var parsed = parseJSONString(this.source, this.index + 1);
    return this.node(PRIMITIVE, parsed.value, index, parsed.end);
  },
  number: function () {
    var source = this.source;
    var startIndex = this.index;
    var i = startIndex;
    if (at(source, i) === '-') i++;
    if (at(source, i) === '0') i++;
    else if (exec(IS_NON_ZERO_DIGIT, at(source, i))) i = this.skip(IS_DIGIT, i + 1);
    else throw new SyntaxError('Failed to parse number at: ' + i);
    if (at(source, i) === '.') i = this.skip(IS_DIGIT, i + 1);
    if (at(source, i) === 'e' || at(source, i) === 'E') {
      i++;
      if (at(source, i) === '+' || at(source, i) === '-') i++;
      var exponentStartIndex = i;
      i = this.skip(IS_DIGIT, i);
      if (exponentStartIndex === i) throw new SyntaxError("Failed to parse number's exponent value at: " + i);
    }
    return this.node(PRIMITIVE, Number(slice(source, startIndex, i)), startIndex, i);
  },
  keyword: function (value) {
    var keyword = '' + value;
    var index = this.index;
    var endIndex = index + keyword.length;
    if (slice(this.source, index, endIndex) !== keyword) throw new SyntaxError('Failed to parse value at: ' + index);
    return this.node(PRIMITIVE, value, index, endIndex);
  },
  skip: function (regex, i) {
    var source = this.source;
    for (; i < source.length; i++) if (!exec(regex, at(source, i))) break;
    return i;
  },
  until: function (array, i) {
    i = this.skip(IS_WHITESPACE, i);
    var chr = at(this.source, i);
    for (var j = 0; j < array.length; j++) if (array[j] === chr) return i;
    throw new SyntaxError('Unexpected character: "' + chr + '" at: ' + i);
  }
};

var NO_SOURCE_SUPPORT = fails(function () {
  var unsafeInt = '9007199254740993';
  var source;
  nativeParse(unsafeInt, function (key, value, context) {
    source = context.source;
  });
  return source !== unsafeInt;
});

var PROPER_BASE_PARSE = NATIVE_SYMBOL && !fails(function () {
  // Safari 9 bug
  return 1 / nativeParse('-0 \t') !== -Infinity;
});

// `JSON.parse` method
// https://tc39.es/ecma262/#sec-json.parse
// https://github.com/tc39/proposal-json-parse-with-source
$({ target: 'JSON', stat: true, forced: NO_SOURCE_SUPPORT }, {
  parse: function parse(text, reviver) {
    return PROPER_BASE_PARSE && !isCallable(reviver) ? nativeParse(text) : $parse(text, reviver);
  }
});


/***/ }),

/***/ 8469:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var uncurryThis = __webpack_require__(9504);
var iterateSimple = __webpack_require__(507);
var SetHelpers = __webpack_require__(4402);

var Set = SetHelpers.Set;
var SetPrototype = SetHelpers.proto;
var forEach = uncurryThis(SetPrototype.forEach);
var keys = uncurryThis(SetPrototype.keys);
var next = keys(new Set()).next;

module.exports = function (set, fn, interruptible) {
  return interruptible ? iterateSimple({ iterator: keys(set), next: next }, fn) : forEach(set, fn);
};


/***/ }),

/***/ 8480:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


var internalObjectKeys = __webpack_require__(1828);
var enumBugKeys = __webpack_require__(8727);

var hiddenKeys = enumBugKeys.concat('length', 'prototype');

// `Object.getOwnPropertyNames` method
// https://tc39.es/ecma262/#sec-object.getownpropertynames
// eslint-disable-next-line es/no-object-getownpropertynames -- safe
exports.f = Object.getOwnPropertyNames || function getOwnPropertyNames(O) {
  return internalObjectKeys(O, hiddenKeys);
};


/***/ }),

/***/ 8527:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var aSet = __webpack_require__(7080);
var has = (__webpack_require__(4402).has);
var size = __webpack_require__(5170);
var getSetRecord = __webpack_require__(3789);
var iterateSimple = __webpack_require__(507);
var iteratorClose = __webpack_require__(9539);

// `Set.prototype.isSupersetOf` method
// https://tc39.github.io/proposal-set-methods/#Set.prototype.isSupersetOf
module.exports = function isSupersetOf(other) {
  var O = aSet(this);
  var otherRec = getSetRecord(other);
  if (size(O) < otherRec.size) return false;
  var iterator = otherRec.getIterator();
  return iterateSimple(iterator, function (e) {
    if (!has(O, e)) return iteratorClose(iterator, 'normal', false);
  }) !== false;
};


/***/ }),

/***/ 8551:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var isObject = __webpack_require__(34);

var $String = String;
var $TypeError = TypeError;

// `Assert: Type(argument) is Object`
module.exports = function (argument) {
  if (isObject(argument)) return argument;
  throw new $TypeError($String(argument) + ' is not an object');
};


/***/ }),

/***/ 8574:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var ENVIRONMENT = __webpack_require__(4215);

module.exports = ENVIRONMENT === 'NODE';


/***/ }),

/***/ 8622:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var globalThis = __webpack_require__(4576);
var isCallable = __webpack_require__(4901);

var WeakMap = globalThis.WeakMap;

module.exports = isCallable(WeakMap) && /native code/.test(String(WeakMap));


/***/ }),

/***/ 8646:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var call = __webpack_require__(9565);
var anObject = __webpack_require__(8551);
var getIteratorDirect = __webpack_require__(1767);
var getIteratorMethod = __webpack_require__(851);

module.exports = function (obj, stringHandling) {
  if (!stringHandling || typeof obj !== 'string') anObject(obj);
  var method = getIteratorMethod(obj);
  return getIteratorDirect(anObject(method !== undefined ? call(method, obj) : obj));
};


/***/ }),

/***/ 8686:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var DESCRIPTORS = __webpack_require__(3724);
var fails = __webpack_require__(9039);

// V8 ~ Chrome 36-
// https://bugs.chromium.org/p/v8/issues/detail?id=3334
module.exports = DESCRIPTORS && fails(function () {
  // eslint-disable-next-line es/no-object-defineproperty -- required for testing
  return Object.defineProperty(function () { /* empty */ }, 'prototype', {
    value: 42,
    writable: false
  }).prototype !== 42;
});


/***/ }),

/***/ 8721:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {


var DESCRIPTORS = __webpack_require__(3724);
var uncurryThis = __webpack_require__(9504);
var defineBuiltInAccessor = __webpack_require__(2106);

var URLSearchParamsPrototype = URLSearchParams.prototype;
var forEach = uncurryThis(URLSearchParamsPrototype.forEach);

// `URLSearchParams.prototype.size` getter
// https://github.com/whatwg/url/pull/734
if (DESCRIPTORS && !('size' in URLSearchParamsPrototype)) {
  defineBuiltInAccessor(URLSearchParamsPrototype, 'size', {
    get: function size() {
      var count = 0;
      forEach(this, function () { count++; });
      return count;
    },
    configurable: true,
    enumerable: true
  });
}


/***/ }),

/***/ 8727:
/***/ ((module) => {


// IE8- don't enum bug keys
module.exports = [
  'constructor',
  'hasOwnProperty',
  'isPrototypeOf',
  'propertyIsEnumerable',
  'toLocaleString',
  'toString',
  'valueOf'
];


/***/ }),

/***/ 8745:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var NATIVE_BIND = __webpack_require__(616);

var FunctionPrototype = Function.prototype;
var apply = FunctionPrototype.apply;
var call = FunctionPrototype.call;

// eslint-disable-next-line es/no-function-prototype-bind, es/no-reflect -- safe
module.exports = typeof Reflect == 'object' && Reflect.apply || (NATIVE_BIND ? call.bind(apply) : function () {
  return call.apply(apply, arguments);
});


/***/ }),

/***/ 8750:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var aSet = __webpack_require__(7080);
var SetHelpers = __webpack_require__(4402);
var size = __webpack_require__(5170);
var getSetRecord = __webpack_require__(3789);
var iterateSet = __webpack_require__(8469);
var iterateSimple = __webpack_require__(507);

var Set = SetHelpers.Set;
var add = SetHelpers.add;
var has = SetHelpers.has;

// `Set.prototype.intersection` method
// https://github.com/tc39/proposal-set-methods
module.exports = function intersection(other) {
  var O = aSet(this);
  var otherRec = getSetRecord(other);
  var result = new Set();

  if (size(O) > otherRec.size) {
    iterateSimple(otherRec.getIterator(), function (e) {
      if (has(O, e)) add(result, e);
    });
  } else {
    iterateSet(O, function (e) {
      if (otherRec.includes(e)) add(result, e);
    });
  }

  return result;
};


/***/ }),

/***/ 8773:
/***/ ((__unused_webpack_module, exports) => {


var $propertyIsEnumerable = {}.propertyIsEnumerable;
// eslint-disable-next-line es/no-object-getownpropertydescriptor -- safe
var getOwnPropertyDescriptor = Object.getOwnPropertyDescriptor;

// Nashorn ~ JDK8 bug
var NASHORN_BUG = getOwnPropertyDescriptor && !$propertyIsEnumerable.call({ 1: 2 }, 1);

// `Object.prototype.propertyIsEnumerable` method implementation
// https://tc39.es/ecma262/#sec-object.prototype.propertyisenumerable
exports.f = NASHORN_BUG ? function propertyIsEnumerable(V) {
  var descriptor = getOwnPropertyDescriptor(this, V);
  return !!descriptor && descriptor.enumerable;
} : $propertyIsEnumerable;


/***/ }),

/***/ 8845:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {


var globalThis = __webpack_require__(4576);
var call = __webpack_require__(9565);
var ArrayBufferViewCore = __webpack_require__(4644);
var lengthOfArrayLike = __webpack_require__(6198);
var toOffset = __webpack_require__(8229);
var toIndexedObject = __webpack_require__(8981);
var fails = __webpack_require__(9039);

var RangeError = globalThis.RangeError;
var Int8Array = globalThis.Int8Array;
var Int8ArrayPrototype = Int8Array && Int8Array.prototype;
var $set = Int8ArrayPrototype && Int8ArrayPrototype.set;
var aTypedArray = ArrayBufferViewCore.aTypedArray;
var exportTypedArrayMethod = ArrayBufferViewCore.exportTypedArrayMethod;

var WORKS_WITH_OBJECTS_AND_GENERIC_ON_TYPED_ARRAYS = !fails(function () {
  // eslint-disable-next-line es/no-typed-arrays -- required for testing
  var array = new Uint8ClampedArray(2);
  call($set, array, { length: 1, 0: 3 }, 1);
  return array[1] !== 3;
});

// https://bugs.chromium.org/p/v8/issues/detail?id=11294 and other
var TO_OBJECT_BUG = WORKS_WITH_OBJECTS_AND_GENERIC_ON_TYPED_ARRAYS && ArrayBufferViewCore.NATIVE_ARRAY_BUFFER_VIEWS && fails(function () {
  var array = new Int8Array(2);
  array.set(1);
  array.set('2', 1);
  return array[0] !== 0 || array[1] !== 2;
});

// `%TypedArray%.prototype.set` method
// https://tc39.es/ecma262/#sec-%typedarray%.prototype.set
exportTypedArrayMethod('set', function set(arrayLike /* , offset */) {
  aTypedArray(this);
  var offset = toOffset(arguments.length > 1 ? arguments[1] : undefined, 1);
  var src = toIndexedObject(arrayLike);
  if (WORKS_WITH_OBJECTS_AND_GENERIC_ON_TYPED_ARRAYS) return call($set, this, src, offset);
  var length = this.length;
  var len = lengthOfArrayLike(src);
  var index = 0;
  if (len + offset > length) throw new RangeError('Wrong length');
  while (index < len) this[offset + index] = src[index++];
}, !WORKS_WITH_OBJECTS_AND_GENERIC_ON_TYPED_ARRAYS || TO_OBJECT_BUG);


/***/ }),

/***/ 8981:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var requireObjectCoercible = __webpack_require__(7750);

var $Object = Object;

// `ToObject` abstract operation
// https://tc39.es/ecma262/#sec-toobject
module.exports = function (argument) {
  return $Object(requireObjectCoercible(argument));
};


/***/ }),

/***/ 9039:
/***/ ((module) => {


module.exports = function (exec) {
  try {
    return !!exec();
  } catch (error) {
    return true;
  }
};


/***/ }),

/***/ 9143:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var globalThis = __webpack_require__(4576);
var uncurryThis = __webpack_require__(9504);
var anObjectOrUndefined = __webpack_require__(3972);
var aString = __webpack_require__(3463);
var hasOwn = __webpack_require__(9297);
var base64Map = __webpack_require__(2804);
var getAlphabetOption = __webpack_require__(944);
var notDetached = __webpack_require__(5169);

var base64Alphabet = base64Map.c2i;
var base64UrlAlphabet = base64Map.c2iUrl;

var SyntaxError = globalThis.SyntaxError;
var TypeError = globalThis.TypeError;
var at = uncurryThis(''.charAt);

var skipAsciiWhitespace = function (string, index) {
  var length = string.length;
  for (;index < length; index++) {
    var chr = at(string, index);
    if (chr !== ' ' && chr !== '\t' && chr !== '\n' && chr !== '\f' && chr !== '\r') break;
  } return index;
};

var decodeBase64Chunk = function (chunk, alphabet, throwOnExtraBits) {
  var chunkLength = chunk.length;

  if (chunkLength < 4) {
    chunk += chunkLength === 2 ? 'AA' : 'A';
  }

  var triplet = (alphabet[at(chunk, 0)] << 18)
    + (alphabet[at(chunk, 1)] << 12)
    + (alphabet[at(chunk, 2)] << 6)
    + alphabet[at(chunk, 3)];

  var chunkBytes = [
    (triplet >> 16) & 255,
    (triplet >> 8) & 255,
    triplet & 255
  ];

  if (chunkLength === 2) {
    if (throwOnExtraBits && chunkBytes[1] !== 0) {
      throw new SyntaxError('Extra bits');
    }
    return [chunkBytes[0]];
  }

  if (chunkLength === 3) {
    if (throwOnExtraBits && chunkBytes[2] !== 0) {
      throw new SyntaxError('Extra bits');
    }
    return [chunkBytes[0], chunkBytes[1]];
  }

  return chunkBytes;
};

var writeBytes = function (bytes, elements, written) {
  var elementsLength = elements.length;
  for (var index = 0; index < elementsLength; index++) {
    bytes[written + index] = elements[index];
  }
  return written + elementsLength;
};

/* eslint-disable max-statements, max-depth -- TODO */
module.exports = function (string, options, into, maxLength) {
  aString(string);
  anObjectOrUndefined(options);
  var alphabet = getAlphabetOption(options) === 'base64' ? base64Alphabet : base64UrlAlphabet;
  var lastChunkHandling = options ? options.lastChunkHandling : undefined;

  if (lastChunkHandling === undefined) lastChunkHandling = 'loose';

  if (lastChunkHandling !== 'loose' && lastChunkHandling !== 'strict' && lastChunkHandling !== 'stop-before-partial') {
    throw new TypeError('Incorrect `lastChunkHandling` option');
  }

  if (into) notDetached(into.buffer);

  var bytes = into || [];
  var written = 0;
  var read = 0;
  var chunk = '';
  var index = 0;

  if (maxLength) while (true) {
    index = skipAsciiWhitespace(string, index);
    if (index === string.length) {
      if (chunk.length > 0) {
        if (lastChunkHandling === 'stop-before-partial') {
          break;
        }
        if (lastChunkHandling === 'loose') {
          if (chunk.length === 1) {
            throw new SyntaxError('Malformed padding: exactly one additional character');
          }
          written = writeBytes(bytes, decodeBase64Chunk(chunk, alphabet, false), written);
        } else {
          throw new SyntaxError('Missing padding');
        }
      }
      read = string.length;
      break;
    }
    var chr = at(string, index);
    ++index;
    if (chr === '=') {
      if (chunk.length < 2) {
        throw new SyntaxError('Padding is too early');
      }
      index = skipAsciiWhitespace(string, index);
      if (chunk.length === 2) {
        if (index === string.length) {
          if (lastChunkHandling === 'stop-before-partial') {
            break;
          }
          throw new SyntaxError('Malformed padding: only one =');
        }
        if (at(string, index) === '=') {
          ++index;
          index = skipAsciiWhitespace(string, index);
        }
      }
      if (index < string.length) {
        throw new SyntaxError('Unexpected character after padding');
      }
      written = writeBytes(bytes, decodeBase64Chunk(chunk, alphabet, lastChunkHandling === 'strict'), written);
      read = string.length;
      break;
    }
    if (!hasOwn(alphabet, chr)) {
      throw new SyntaxError('Unexpected character');
    }
    var remainingBytes = maxLength - written;
    if (remainingBytes === 1 && chunk.length === 2 || remainingBytes === 2 && chunk.length === 3) {
      // special case: we can fit exactly the number of bytes currently represented by chunk, so we were just checking for `=`
      break;
    }

    chunk += chr;
    if (chunk.length === 4) {
      written = writeBytes(bytes, decodeBase64Chunk(chunk, alphabet, false), written);
      chunk = '';
      read = index;
      if (written === maxLength) {
        break;
      }
    }
  }

  return { bytes: bytes, read: read, written: written };
};


/***/ }),

/***/ 9286:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var SetHelpers = __webpack_require__(4402);
var iterate = __webpack_require__(8469);

var Set = SetHelpers.Set;
var add = SetHelpers.add;

module.exports = function (set) {
  var result = new Set();
  iterate(set, function (it) {
    add(result, it);
  });
  return result;
};


/***/ }),

/***/ 9297:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var uncurryThis = __webpack_require__(9504);
var toObject = __webpack_require__(8981);

var hasOwnProperty = uncurryThis({}.hasOwnProperty);

// `HasOwnProperty` abstract operation
// https://tc39.es/ecma262/#sec-hasownproperty
// eslint-disable-next-line es/no-object-hasown -- safe
module.exports = Object.hasOwn || function hasOwn(it, key) {
  return hasOwnProperty(toObject(it), key);
};


/***/ }),

/***/ 9306:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var isCallable = __webpack_require__(4901);
var tryToString = __webpack_require__(6823);

var $TypeError = TypeError;

// `Assert: IsCallable(argument) is true`
module.exports = function (argument) {
  if (isCallable(argument)) return argument;
  throw new $TypeError(tryToString(argument) + ' is not a function');
};


/***/ }),

/***/ 9314:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {


var $ = __webpack_require__(6518);
var call = __webpack_require__(9565);
var anObject = __webpack_require__(8551);
var getIteratorDirect = __webpack_require__(1767);
var notANaN = __webpack_require__(4149);
var toPositiveInteger = __webpack_require__(9590);
var iteratorClose = __webpack_require__(9539);
var createIteratorProxy = __webpack_require__(9462);
var iteratorHelperThrowsOnInvalidIterator = __webpack_require__(684);
var iteratorHelperWithoutClosingOnEarlyError = __webpack_require__(4549);
var IS_PURE = __webpack_require__(6395);

var DROP_WITHOUT_THROWING_ON_INVALID_ITERATOR = !IS_PURE && !iteratorHelperThrowsOnInvalidIterator('drop', 0);
var dropWithoutClosingOnEarlyError = !IS_PURE && !DROP_WITHOUT_THROWING_ON_INVALID_ITERATOR
  && iteratorHelperWithoutClosingOnEarlyError('drop', RangeError);

var FORCED = IS_PURE || DROP_WITHOUT_THROWING_ON_INVALID_ITERATOR || dropWithoutClosingOnEarlyError;

var IteratorProxy = createIteratorProxy(function () {
  var iterator = this.iterator;
  var next = this.next;
  var result, done;
  while (this.remaining) {
    this.remaining--;
    result = anObject(call(next, iterator));
    done = this.done = !!result.done;
    if (done) return;
  }
  result = anObject(call(next, iterator));
  done = this.done = !!result.done;
  if (!done) return result.value;
});

// `Iterator.prototype.drop` method
// https://tc39.es/ecma262/#sec-iterator.prototype.drop
$({ target: 'Iterator', proto: true, real: true, forced: FORCED }, {
  drop: function drop(limit) {
    anObject(this);
    var remaining;
    try {
      remaining = toPositiveInteger(notANaN(+limit));
    } catch (error) {
      iteratorClose(this, 'throw', error);
    }

    if (dropWithoutClosingOnEarlyError) return call(dropWithoutClosingOnEarlyError, this, remaining);

    return new IteratorProxy(getIteratorDirect(this), {
      remaining: remaining
    });
  }
});


/***/ }),

/***/ 9429:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var globalThis = __webpack_require__(4576);
var IS_NODE = __webpack_require__(8574);

module.exports = function (name) {
  if (IS_NODE) {
    try {
      return globalThis.process.getBuiltinModule(name);
    } catch (error) { /* empty */ }
    try {
      // eslint-disable-next-line no-new-func -- safe
      return Function('return require("' + name + '")')();
    } catch (error) { /* empty */ }
  }
};


/***/ }),

/***/ 9432:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {


var $ = __webpack_require__(6518);
var globalThis = __webpack_require__(4576);
var arrayFromConstructorAndList = __webpack_require__(5370);
var $fromBase64 = __webpack_require__(9143);

var Uint8Array = globalThis.Uint8Array;

// `Uint8Array.fromBase64` method
// https://github.com/tc39/proposal-arraybuffer-base64
if (Uint8Array) $({ target: 'Uint8Array', stat: true }, {
  fromBase64: function fromBase64(string /* , options */) {
    var result = $fromBase64(string, arguments.length > 1 ? arguments[1] : undefined, null, 0x1FFFFFFFFFFFFF);
    return arrayFromConstructorAndList(Uint8Array, result.bytes);
  }
});


/***/ }),

/***/ 9433:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var globalThis = __webpack_require__(4576);

// eslint-disable-next-line es/no-object-defineproperty -- safe
var defineProperty = Object.defineProperty;

module.exports = function (key, value) {
  try {
    defineProperty(globalThis, key, { value: value, configurable: true, writable: true });
  } catch (error) {
    globalThis[key] = value;
  } return value;
};


/***/ }),

/***/ 9462:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var call = __webpack_require__(9565);
var create = __webpack_require__(2360);
var createNonEnumerableProperty = __webpack_require__(6699);
var defineBuiltIns = __webpack_require__(6279);
var wellKnownSymbol = __webpack_require__(8227);
var InternalStateModule = __webpack_require__(1181);
var getMethod = __webpack_require__(5966);
var IteratorPrototype = (__webpack_require__(7657).IteratorPrototype);
var createIterResultObject = __webpack_require__(2529);
var iteratorClose = __webpack_require__(9539);
var iteratorCloseAll = __webpack_require__(1385);

var TO_STRING_TAG = wellKnownSymbol('toStringTag');
var ITERATOR_HELPER = 'IteratorHelper';
var WRAP_FOR_VALID_ITERATOR = 'WrapForValidIterator';
var NORMAL = 'normal';
var THROW = 'throw';
var setInternalState = InternalStateModule.set;

var createIteratorProxyPrototype = function (IS_ITERATOR) {
  var getInternalState = InternalStateModule.getterFor(IS_ITERATOR ? WRAP_FOR_VALID_ITERATOR : ITERATOR_HELPER);

  return defineBuiltIns(create(IteratorPrototype), {
    next: function next() {
      var state = getInternalState(this);
      // for simplification:
      //   for `%WrapForValidIteratorPrototype%.next` or with `state.returnHandlerResult` our `nextHandler` returns `IterResultObject`
      //   for `%IteratorHelperPrototype%.next` - just a value
      if (IS_ITERATOR) return state.nextHandler();
      if (state.done) return createIterResultObject(undefined, true);
      try {
        var result = state.nextHandler();
        return state.returnHandlerResult ? result : createIterResultObject(result, state.done);
      } catch (error) {
        state.done = true;
        throw error;
      }
    },
    'return': function () {
      var state = getInternalState(this);
      var iterator = state.iterator;
      state.done = true;
      if (IS_ITERATOR) {
        var returnMethod = getMethod(iterator, 'return');
        return returnMethod ? call(returnMethod, iterator) : createIterResultObject(undefined, true);
      }
      if (state.inner) try {
        iteratorClose(state.inner.iterator, NORMAL);
      } catch (error) {
        return iteratorClose(iterator, THROW, error);
      }
      if (state.openIters) try {
        iteratorCloseAll(state.openIters, NORMAL);
      } catch (error) {
        return iteratorClose(iterator, THROW, error);
      }
      if (iterator) iteratorClose(iterator, NORMAL);
      return createIterResultObject(undefined, true);
    }
  });
};

var WrapForValidIteratorPrototype = createIteratorProxyPrototype(true);
var IteratorHelperPrototype = createIteratorProxyPrototype(false);

createNonEnumerableProperty(IteratorHelperPrototype, TO_STRING_TAG, 'Iterator Helper');

module.exports = function (nextHandler, IS_ITERATOR, RETURN_HANDLER_RESULT) {
  var IteratorProxy = function Iterator(record, state) {
    if (state) {
      state.iterator = record.iterator;
      state.next = record.next;
    } else state = record;
    state.type = IS_ITERATOR ? WRAP_FOR_VALID_ITERATOR : ITERATOR_HELPER;
    state.returnHandlerResult = !!RETURN_HANDLER_RESULT;
    state.nextHandler = nextHandler;
    state.counter = 0;
    state.done = false;
    setInternalState(this, state);
  };

  IteratorProxy.prototype = IS_ITERATOR ? WrapForValidIteratorPrototype : IteratorHelperPrototype;

  return IteratorProxy;
};


/***/ }),

/***/ 9504:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var NATIVE_BIND = __webpack_require__(616);

var FunctionPrototype = Function.prototype;
var call = FunctionPrototype.call;
// eslint-disable-next-line es/no-function-prototype-bind -- safe
var uncurryThisWithBind = NATIVE_BIND && FunctionPrototype.bind.bind(call, call);

module.exports = NATIVE_BIND ? uncurryThisWithBind : function (fn) {
  return function () {
    return call.apply(fn, arguments);
  };
};


/***/ }),

/***/ 9519:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var globalThis = __webpack_require__(4576);
var userAgent = __webpack_require__(2839);

var process = globalThis.process;
var Deno = globalThis.Deno;
var versions = process && process.versions || Deno && Deno.version;
var v8 = versions && versions.v8;
var match, version;

if (v8) {
  match = v8.split('.');
  // in old Chrome, versions of V8 isn't V8 = Chrome / 10
  // but their correct versions are not interesting for us
  version = match[0] > 0 && match[0] < 4 ? 1 : +(match[0] + match[1]);
}

// BrowserFS NodeJS `process` polyfill incorrectly set `.v8` to `0.0`
// so check `userAgent` even if `.v8` exists, but 0
if (!version && userAgent) {
  match = userAgent.match(/Edge\/(\d+)/);
  if (!match || match[1] >= 74) {
    match = userAgent.match(/Chrome\/(\d+)/);
    if (match) version = +match[1];
  }
}

module.exports = version;


/***/ }),

/***/ 9539:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var call = __webpack_require__(9565);
var anObject = __webpack_require__(8551);
var getMethod = __webpack_require__(5966);

module.exports = function (iterator, kind, value) {
  var innerResult, innerError;
  anObject(iterator);
  try {
    innerResult = getMethod(iterator, 'return');
    if (!innerResult) {
      if (kind === 'throw') throw value;
      return value;
    }
    innerResult = call(innerResult, iterator);
  } catch (error) {
    innerError = true;
    innerResult = error;
  }
  if (kind === 'throw') throw value;
  if (innerError) throw innerResult;
  anObject(innerResult);
  return value;
};


/***/ }),

/***/ 9565:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var NATIVE_BIND = __webpack_require__(616);

var call = Function.prototype.call;
// eslint-disable-next-line es/no-function-prototype-bind -- safe
module.exports = NATIVE_BIND ? call.bind(call) : function () {
  return call.apply(call, arguments);
};


/***/ }),

/***/ 9577:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {


var arrayWith = __webpack_require__(9928);
var ArrayBufferViewCore = __webpack_require__(4644);
var isBigIntArray = __webpack_require__(1108);
var toIntegerOrInfinity = __webpack_require__(1291);
var toBigInt = __webpack_require__(5854);

var aTypedArray = ArrayBufferViewCore.aTypedArray;
var getTypedArrayConstructor = ArrayBufferViewCore.getTypedArrayConstructor;
var exportTypedArrayMethod = ArrayBufferViewCore.exportTypedArrayMethod;

var PROPER_ORDER = function () {
  try {
    // eslint-disable-next-line no-throw-literal, es/no-typed-arrays, es/no-array-prototype-with -- required for testing
    new Int8Array(1)['with'](2, { valueOf: function () { throw 8; } });
  } catch (error) {
    // some early implementations, like WebKit, does not follow the final semantic
    // https://github.com/tc39/proposal-change-array-by-copy/pull/86
    return error === 8;
  }
}();

// Bug in WebKit. It should truncate a negative fractional index to zero, but instead throws an error
var THROW_ON_NEGATIVE_FRACTIONAL_INDEX = PROPER_ORDER && function () {
  try {
    // eslint-disable-next-line es/no-typed-arrays, es/no-array-prototype-with -- required for testing
    new Int8Array(1)['with'](-0.5, 1);
  } catch (error) {
    return true;
  }
}();

// `%TypedArray%.prototype.with` method
// https://tc39.es/ecma262/#sec-%typedarray%.prototype.with
exportTypedArrayMethod('with', { 'with': function (index, value) {
  var O = aTypedArray(this);
  var relativeIndex = toIntegerOrInfinity(index);
  var actualValue = isBigIntArray(O) ? toBigInt(value) : +value;
  return arrayWith(O, getTypedArrayConstructor(O), relativeIndex, actualValue);
} }['with'], !PROPER_ORDER || THROW_ON_NEGATIVE_FRACTIONAL_INDEX);


/***/ }),

/***/ 9590:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var toIntegerOrInfinity = __webpack_require__(1291);

var $RangeError = RangeError;

module.exports = function (it) {
  var result = toIntegerOrInfinity(it);
  if (result < 0) throw new $RangeError("The argument can't be less than 0");
  return result;
};


/***/ }),

/***/ 9617:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var toIndexedObject = __webpack_require__(5397);
var toAbsoluteIndex = __webpack_require__(5610);
var lengthOfArrayLike = __webpack_require__(6198);

// `Array.prototype.{ indexOf, includes }` methods implementation
var createMethod = function (IS_INCLUDES) {
  return function ($this, el, fromIndex) {
    var O = toIndexedObject($this);
    var length = lengthOfArrayLike(O);
    if (length === 0) return !IS_INCLUDES && -1;
    var index = toAbsoluteIndex(fromIndex, length);
    var value;
    // Array#includes uses SameValueZero equality algorithm
    // eslint-disable-next-line no-self-compare -- NaN check
    if (IS_INCLUDES && el !== el) while (length > index) {
      value = O[index++];
      // eslint-disable-next-line no-self-compare -- NaN check
      if (value !== value) return true;
    // Array#indexOf ignores holes, Array#includes - not
    } else for (;length > index; index++) {
      if ((IS_INCLUDES || index in O) && O[index] === el) return IS_INCLUDES || index || 0;
    } return !IS_INCLUDES && -1;
  };
};

module.exports = {
  // `Array.prototype.includes` method
  // https://tc39.es/ecma262/#sec-array.prototype.includes
  includes: createMethod(true),
  // `Array.prototype.indexOf` method
  // https://tc39.es/ecma262/#sec-array.prototype.indexof
  indexOf: createMethod(false)
};


/***/ }),

/***/ 9631:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {


var $ = __webpack_require__(6518);
var globalThis = __webpack_require__(4576);
var uncurryThis = __webpack_require__(9504);
var anObjectOrUndefined = __webpack_require__(3972);
var anUint8Array = __webpack_require__(4154);
var notDetached = __webpack_require__(5169);
var base64Map = __webpack_require__(2804);
var getAlphabetOption = __webpack_require__(944);

var base64Alphabet = base64Map.i2c;
var base64UrlAlphabet = base64Map.i2cUrl;

var charAt = uncurryThis(''.charAt);

// `Uint8Array.prototype.toBase64` method
// https://github.com/tc39/proposal-arraybuffer-base64
if (globalThis.Uint8Array) $({ target: 'Uint8Array', proto: true }, {
  toBase64: function toBase64(/* options */) {
    var array = anUint8Array(this);
    var options = arguments.length ? anObjectOrUndefined(arguments[0]) : undefined;
    var alphabet = getAlphabetOption(options) === 'base64' ? base64Alphabet : base64UrlAlphabet;
    var omitPadding = !!options && !!options.omitPadding;
    notDetached(this.buffer);

    var result = '';
    var i = 0;
    var length = array.length;
    var triplet;

    var at = function (shift) {
      return charAt(alphabet, (triplet >> (6 * shift)) & 63);
    };

    for (; i + 2 < length; i += 3) {
      triplet = (array[i] << 16) + (array[i + 1] << 8) + array[i + 2];
      result += at(3) + at(2) + at(1) + at(0);
    }
    if (i + 2 === length) {
      triplet = (array[i] << 16) + (array[i + 1] << 8);
      result += at(3) + at(2) + at(1) + (omitPadding ? '' : '=');
    } else if (i + 1 === length) {
      triplet = array[i] << 16;
      result += at(3) + at(2) + (omitPadding ? '' : '==');
    }

    return result;
  }
});


/***/ }),

/***/ 9797:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {


var $ = __webpack_require__(6518);
var globalThis = __webpack_require__(4576);
var aString = __webpack_require__(3463);
var anUint8Array = __webpack_require__(4154);
var notDetached = __webpack_require__(5169);
var $fromHex = __webpack_require__(2303);

// `Uint8Array.prototype.setFromHex` method
// https://github.com/tc39/proposal-arraybuffer-base64
if (globalThis.Uint8Array) $({ target: 'Uint8Array', proto: true }, {
  setFromHex: function setFromHex(string) {
    anUint8Array(this);
    aString(string);
    notDetached(this.buffer);
    var read = $fromHex(string, this).read;
    return { read: read, written: read / 2 };
  }
});


/***/ }),

/***/ 9835:
/***/ ((module) => {


// Should get iterator record of a set-like object before cloning this
// https://bugs.webkit.org/show_bug.cgi?id=289430
module.exports = function (METHOD_NAME) {
  try {
    // eslint-disable-next-line es/no-set -- needed for test
    var baseSet = new Set();
    var setLike = {
      size: 0,
      has: function () { return true; },
      keys: function () {
        // eslint-disable-next-line es/no-object-defineproperty -- needed for test
        return Object.defineProperty({}, 'next', {
          get: function () {
            baseSet.clear();
            baseSet.add(4);
            return function () {
              return { done: true };
            };
          }
        });
      }
    };
    var result = baseSet[METHOD_NAME](setLike);

    return result.size !== 1 || result.values().next().value !== 4;
  } catch (error) {
    return false;
  }
};


/***/ }),

/***/ 9928:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


var lengthOfArrayLike = __webpack_require__(6198);
var toIntegerOrInfinity = __webpack_require__(1291);

var $RangeError = RangeError;

// https://tc39.es/proposal-change-array-by-copy/#sec-array.prototype.with
// https://tc39.es/proposal-change-array-by-copy/#sec-%typedarray%.prototype.with
module.exports = function (O, C, index, value) {
  var len = lengthOfArrayLike(O);
  var relativeIndex = toIntegerOrInfinity(index);
  var actualIndex = relativeIndex < 0 ? len + relativeIndex : relativeIndex;
  if (actualIndex >= len || actualIndex < 0) throw new $RangeError('Incorrect index');
  var A = new C(len);
  var k = 0;
  for (; k < len; k++) A[k] = k === actualIndex ? value : O[k];
  return A;
};


/***/ })

/******/ });
/************************************************************************/
/******/ // The module cache
/******/ var __webpack_module_cache__ = {};
/******/ 
/******/ // The require function
/******/ function __webpack_require__(moduleId) {
/******/ 	// Check if module is in cache
/******/ 	var cachedModule = __webpack_module_cache__[moduleId];
/******/ 	if (cachedModule !== undefined) {
/******/ 		return cachedModule.exports;
/******/ 	}
/******/ 	// Create a new module (and put it into the cache)
/******/ 	var module = __webpack_module_cache__[moduleId] = {
/******/ 		// no module.id needed
/******/ 		// no module.loaded needed
/******/ 		exports: {}
/******/ 	};
/******/ 
/******/ 	// Execute the module function
/******/ 	__webpack_modules__[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/ 
/******/ 	// Return the exports of the module
/******/ 	return module.exports;
/******/ }
/******/ 
/************************************************************************/
var __webpack_exports__ = {};

// EXTERNAL MODULE: ./node_modules/core-js/modules/es.error.cause.js
var es_error_cause = __webpack_require__(6280);
// EXTERNAL MODULE: ./node_modules/core-js/modules/es.array.push.js
var es_array_push = __webpack_require__(4114);
// EXTERNAL MODULE: ./node_modules/core-js/modules/es.array-buffer.detached.js
var es_array_buffer_detached = __webpack_require__(6573);
// EXTERNAL MODULE: ./node_modules/core-js/modules/es.array-buffer.transfer.js
var es_array_buffer_transfer = __webpack_require__(8100);
// EXTERNAL MODULE: ./node_modules/core-js/modules/es.array-buffer.transfer-to-fixed-length.js
var es_array_buffer_transfer_to_fixed_length = __webpack_require__(7936);
// EXTERNAL MODULE: ./node_modules/core-js/modules/es.iterator.constructor.js
var es_iterator_constructor = __webpack_require__(8111);
// EXTERNAL MODULE: ./node_modules/core-js/modules/es.iterator.reduce.js
var es_iterator_reduce = __webpack_require__(8237);
// EXTERNAL MODULE: ./node_modules/core-js/modules/es.promise.try.js
var es_promise_try = __webpack_require__(1689);
// EXTERNAL MODULE: ./node_modules/core-js/modules/es.typed-array.at.js
var es_typed_array_at = __webpack_require__(8140);
// EXTERNAL MODULE: ./node_modules/core-js/modules/es.typed-array.fill.js
var es_typed_array_fill = __webpack_require__(5044);
// EXTERNAL MODULE: ./node_modules/core-js/modules/es.typed-array.find-last.js
var es_typed_array_find_last = __webpack_require__(1903);
// EXTERNAL MODULE: ./node_modules/core-js/modules/es.typed-array.find-last-index.js
var es_typed_array_find_last_index = __webpack_require__(1134);
// EXTERNAL MODULE: ./node_modules/core-js/modules/es.typed-array.set.js
var es_typed_array_set = __webpack_require__(8845);
// EXTERNAL MODULE: ./node_modules/core-js/modules/es.typed-array.sort.js
var es_typed_array_sort = __webpack_require__(373);
// EXTERNAL MODULE: ./node_modules/core-js/modules/es.typed-array.to-reversed.js
var es_typed_array_to_reversed = __webpack_require__(7467);
// EXTERNAL MODULE: ./node_modules/core-js/modules/es.typed-array.to-sorted.js
var es_typed_array_to_sorted = __webpack_require__(4732);
// EXTERNAL MODULE: ./node_modules/core-js/modules/es.typed-array.with.js
var es_typed_array_with = __webpack_require__(9577);
// EXTERNAL MODULE: ./node_modules/core-js/modules/esnext.uint8-array.from-base64.js
var esnext_uint8_array_from_base64 = __webpack_require__(9432);
// EXTERNAL MODULE: ./node_modules/core-js/modules/esnext.uint8-array.set-from-base64.js
var esnext_uint8_array_set_from_base64 = __webpack_require__(1549);
// EXTERNAL MODULE: ./node_modules/core-js/modules/esnext.uint8-array.set-from-hex.js
var esnext_uint8_array_set_from_hex = __webpack_require__(9797);
// EXTERNAL MODULE: ./node_modules/core-js/modules/esnext.uint8-array.to-base64.js
var esnext_uint8_array_to_base64 = __webpack_require__(9631);
// EXTERNAL MODULE: ./node_modules/core-js/modules/esnext.uint8-array.to-hex.js
var esnext_uint8_array_to_hex = __webpack_require__(5623);
// EXTERNAL MODULE: ./node_modules/core-js/modules/web.dom-exception.stack.js
var web_dom_exception_stack = __webpack_require__(4979);
// EXTERNAL MODULE: ./node_modules/core-js/modules/web.self.js
var web_self = __webpack_require__(3611);
// EXTERNAL MODULE: ./node_modules/core-js/modules/web.url.parse.js
var web_url_parse = __webpack_require__(5781);
;// ./external/ngx-logger/ngx-console.js

function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
class NgxConsole {
  static log(message, reason) {
    if (NgxConsole.ngxConsoleFilter("log", message)) {
      if (reason !== undefined) {
        console.log("%s", message, reason);
      } else {
        console.log(message);
      }
    }
  }
  static error(message, reason) {
    if (NgxConsole.ngxConsoleFilter("error", message)) {
      if (reason !== undefined) {
        console.error("%s", message, reason);
      } else {
        console.error(message);
      }
    }
  }
  static warn(message, reason) {
    if (NgxConsole.ngxConsoleFilter("warn", message)) {
      if (reason !== undefined) {
        console.warn("%s", message, reason);
      } else {
        console.warn(message);
      }
    }
  }
  static debug(message, reason) {
    if (NgxConsole.ngxConsoleFilter("debug", message)) {
      if (reason !== undefined) {
        console.warn("%s", message, reason);
      } else {
        console.warn(message);
      }
    }
  }
  get ngxConsoleFilter() {
    return NgxConsole.ngxConsoleFilter;
  }
  set ngxConsoleFilter(filter) {
    NgxConsole.ngxConsoleFilter = filter;
  }
  reset() {
    NgxConsole.ngxConsoleFilter = (_level, _message) => true;
  }
}
_defineProperty(NgxConsole, "ngxConsoleFilter", (_level, _message) => true);
;// ./src/shared/util.js
var _Util;
function _assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); }


























const isNodeJS = typeof process === "object" && process + "" === "[object process]" && !process.versions.nw && !(process.versions.electron && process.type && process.type !== "browser");
const FONT_IDENTITY_MATRIX = [0.001, 0, 0, 0.001, 0, 0];
const LINE_FACTOR = 1.35;
const LINE_DESCENT_FACTOR = 0.35;
const BASELINE_FACTOR = LINE_DESCENT_FACTOR / LINE_FACTOR;
const RenderingIntentFlag = {
  ANY: 0x01,
  DISPLAY: 0x02,
  PRINT: 0x04,
  SAVE: 0x08,
  ANNOTATIONS_FORMS: 0x10,
  ANNOTATIONS_STORAGE: 0x20,
  ANNOTATIONS_DISABLE: 0x40,
  IS_EDITING: 0x80,
  OPLIST: 0x100
};
const AnnotationMode = {
  DISABLE: 0,
  ENABLE: 1,
  ENABLE_FORMS: 2,
  ENABLE_STORAGE: 3
};
const AnnotationEditorPrefix = "pdfjs_internal_editor_";
const AnnotationEditorType = {
  DISABLE: -1,
  NONE: 0,
  FREETEXT: 3,
  HIGHLIGHT: 9,
  STAMP: 13,
  INK: 15,
  SIGNATURE: 101
};
const AnnotationEditorParamsType = {
  RESIZE: 1,
  CREATE: 2,
  FREETEXT_SIZE: 11,
  FREETEXT_COLOR: 12,
  FREETEXT_OPACITY: 13,
  INK_COLOR: 21,
  INK_THICKNESS: 22,
  INK_OPACITY: 23,
  HIGHLIGHT_COLOR: 31,
  HIGHLIGHT_DEFAULT_COLOR: 32,
  HIGHLIGHT_THICKNESS: 33,
  HIGHLIGHT_FREE: 34,
  HIGHLIGHT_SHOW_ALL: 35,
  DRAW_STEP: 41
};
const PermissionFlag = {
  PRINT: 0x04,
  MODIFY_CONTENTS: 0x08,
  COPY: 0x10,
  MODIFY_ANNOTATIONS: 0x20,
  FILL_INTERACTIVE_FORMS: 0x100,
  COPY_FOR_ACCESSIBILITY: 0x200,
  ASSEMBLE: 0x400,
  PRINT_HIGH_QUALITY: 0x800
};
const TextRenderingMode = {
  FILL: 0,
  STROKE: 1,
  FILL_STROKE: 2,
  INVISIBLE: 3,
  FILL_ADD_TO_PATH: 4,
  STROKE_ADD_TO_PATH: 5,
  FILL_STROKE_ADD_TO_PATH: 6,
  ADD_TO_PATH: 7,
  FILL_STROKE_MASK: 3,
  ADD_TO_PATH_FLAG: 4
};
const util_ImageKind = {
  GRAYSCALE_1BPP: 1,
  RGB_24BPP: 2,
  RGBA_32BPP: 3
};
const AnnotationType = {
  TEXT: 1,
  LINK: 2,
  FREETEXT: 3,
  LINE: 4,
  SQUARE: 5,
  CIRCLE: 6,
  POLYGON: 7,
  POLYLINE: 8,
  HIGHLIGHT: 9,
  UNDERLINE: 10,
  SQUIGGLY: 11,
  STRIKEOUT: 12,
  STAMP: 13,
  CARET: 14,
  INK: 15,
  POPUP: 16,
  FILEATTACHMENT: 17,
  SOUND: 18,
  MOVIE: 19,
  WIDGET: 20,
  SCREEN: 21,
  PRINTERMARK: 22,
  TRAPNET: 23,
  WATERMARK: 24,
  THREED: 25,
  REDACT: 26
};
const AnnotationReplyType = {
  GROUP: "Group",
  REPLY: "R"
};
const AnnotationFlag = {
  INVISIBLE: 0x01,
  HIDDEN: 0x02,
  PRINT: 0x04,
  NOZOOM: 0x08,
  NOROTATE: 0x10,
  NOVIEW: 0x20,
  READONLY: 0x40,
  LOCKED: 0x80,
  TOGGLENOVIEW: 0x100,
  LOCKEDCONTENTS: 0x200
};
const AnnotationFieldFlag = {
  READONLY: 0x0000001,
  REQUIRED: 0x0000002,
  NOEXPORT: 0x0000004,
  MULTILINE: 0x0001000,
  PASSWORD: 0x0002000,
  NOTOGGLETOOFF: 0x0004000,
  RADIO: 0x0008000,
  PUSHBUTTON: 0x0010000,
  COMBO: 0x0020000,
  EDIT: 0x0040000,
  SORT: 0x0080000,
  FILESELECT: 0x0100000,
  MULTISELECT: 0x0200000,
  DONOTSPELLCHECK: 0x0400000,
  DONOTSCROLL: 0x0800000,
  COMB: 0x1000000,
  RICHTEXT: 0x2000000,
  RADIOSINUNISON: 0x2000000,
  COMMITONSELCHANGE: 0x4000000
};
const AnnotationBorderStyleType = {
  SOLID: 1,
  DASHED: 2,
  BEVELED: 3,
  INSET: 4,
  UNDERLINE: 5
};
const AnnotationActionEventType = {
  E: "Mouse Enter",
  X: "Mouse Exit",
  D: "Mouse Down",
  U: "Mouse Up",
  Fo: "Focus",
  Bl: "Blur",
  PO: "PageOpen",
  PC: "PageClose",
  PV: "PageVisible",
  PI: "PageInvisible",
  K: "Keystroke",
  F: "Format",
  V: "Validate",
  C: "Calculate"
};
const DocumentActionEventType = {
  WC: "WillClose",
  WS: "WillSave",
  DS: "DidSave",
  WP: "WillPrint",
  DP: "DidPrint"
};
const PageActionEventType = {
  O: "PageOpen",
  C: "PageClose"
};
const VerbosityLevel = {
  ERRORS: 0,
  WARNINGS: 1,
  INFOS: 5
};
const OPS = {
  dependency: 1,
  setLineWidth: 2,
  setLineCap: 3,
  setLineJoin: 4,
  setMiterLimit: 5,
  setDash: 6,
  setRenderingIntent: 7,
  setFlatness: 8,
  setGState: 9,
  save: 10,
  restore: 11,
  transform: 12,
  moveTo: 13,
  lineTo: 14,
  curveTo: 15,
  curveTo2: 16,
  curveTo3: 17,
  closePath: 18,
  rectangle: 19,
  stroke: 20,
  closeStroke: 21,
  fill: 22,
  eoFill: 23,
  fillStroke: 24,
  eoFillStroke: 25,
  closeFillStroke: 26,
  closeEOFillStroke: 27,
  endPath: 28,
  clip: 29,
  eoClip: 30,
  beginText: 31,
  endText: 32,
  setCharSpacing: 33,
  setWordSpacing: 34,
  setHScale: 35,
  setLeading: 36,
  setFont: 37,
  setTextRenderingMode: 38,
  setTextRise: 39,
  moveText: 40,
  setLeadingMoveText: 41,
  setTextMatrix: 42,
  nextLine: 43,
  showText: 44,
  showSpacedText: 45,
  nextLineShowText: 46,
  nextLineSetSpacingShowText: 47,
  setCharWidth: 48,
  setCharWidthAndBounds: 49,
  setStrokeColorSpace: 50,
  setFillColorSpace: 51,
  setStrokeColor: 52,
  setStrokeColorN: 53,
  setFillColor: 54,
  setFillColorN: 55,
  setStrokeGray: 56,
  setFillGray: 57,
  setStrokeRGBColor: 58,
  setFillRGBColor: 59,
  setStrokeCMYKColor: 60,
  setFillCMYKColor: 61,
  shadingFill: 62,
  beginInlineImage: 63,
  beginImageData: 64,
  endInlineImage: 65,
  paintXObject: 66,
  markPoint: 67,
  markPointProps: 68,
  beginMarkedContent: 69,
  beginMarkedContentProps: 70,
  endMarkedContent: 71,
  beginCompat: 72,
  endCompat: 73,
  paintFormXObjectBegin: 74,
  paintFormXObjectEnd: 75,
  beginGroup: 76,
  endGroup: 77,
  beginAnnotation: 80,
  endAnnotation: 81,
  paintImageMaskXObject: 83,
  paintImageMaskXObjectGroup: 84,
  paintImageXObject: 85,
  paintInlineImageXObject: 86,
  paintInlineImageXObjectGroup: 87,
  paintImageXObjectRepeat: 88,
  paintImageMaskXObjectRepeat: 89,
  paintSolidColorImageMask: 90,
  constructPath: 91,
  setStrokeTransparent: 92,
  setFillTransparent: 93,
  rawFillPath: 94
};
const DrawOPS = {
  moveTo: 0,
  lineTo: 1,
  curveTo: 2,
  closePath: 3
};
const PasswordResponses = {
  NEED_PASSWORD: 1,
  INCORRECT_PASSWORD: 2
};
let verbosity = VerbosityLevel.WARNINGS;
function setVerbosityLevel(level) {
  if (Number.isInteger(level)) {
    verbosity = level;
  }
}
function getVerbosityLevel() {
  return verbosity;
}
function info(msg) {
  if (verbosity >= VerbosityLevel.INFOS) {
    if (typeof WorkerGlobalScope !== "undefined" && self instanceof WorkerGlobalScope) {
      console.log(`Info: ${msg}`);
    } else if (Window && NgxConsole) {
      NgxConsole.log(`Info: ${msg}`);
    } else {
      console.log(`Info: ${msg}`);
    }
  }
}
function warn(msg) {
  if (verbosity >= VerbosityLevel.WARNINGS) {
    if (typeof WorkerGlobalScope !== "undefined" && self instanceof WorkerGlobalScope) {
      NgxConsole.log(`Warning: ${msg}`);
    } else if (Window && NgxConsole) {
      NgxConsole.log(`Warning: ${msg}`);
    } else {
      console.log(`Warning: ${msg}`);
    }
  }
}
function unreachable(msg) {
  throw new Error(msg);
}
function assert(cond, msg) {
  if (!cond) {
    unreachable(msg);
  }
}
function _isValidProtocol(url) {
  switch (url?.protocol) {
    case "http:":
    case "https:":
    case "ftp:":
    case "mailto:":
    case "tel:":
    case "capacitor":
      return true;
    default:
      return false;
  }
}
function createValidAbsoluteUrl(url) {
  let baseUrl = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
  let options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
  if (!url) {
    return null;
  }
  if (options && typeof url === "string") {
    if (options.addDefaultProtocol && url.startsWith("www.")) {
      const dots = url.match(/\./g);
      if (dots?.length >= 2) {
        url = `http://${url}`;
      }
    }
    if (options.tryConvertEncoding) {
      try {
        url = stringToUTF8String(url);
      } catch {}
    }
  }
  const absoluteUrl = baseUrl ? URL.parse(url, baseUrl) : URL.parse(url);
  return _isValidProtocol(absoluteUrl) ? absoluteUrl : null;
}
function updateUrlHash(url, hash) {
  let allowRel = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
  const res = URL.parse(url);
  if (res) {
    res.hash = hash;
    return res.href;
  }
  if (allowRel && createValidAbsoluteUrl(url, "http://example.com")) {
    return url.split("#", 1)[0] + `${hash ? `#${hash}` : ""}`;
  }
  return "";
}
function shadow(obj, prop, value) {
  let nonSerializable = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : false;
  Object.defineProperty(obj, prop, {
    value,
    enumerable: !nonSerializable,
    configurable: true,
    writable: false
  });
  return value;
}
const BaseException = function BaseExceptionClosure() {
  function BaseException(message, name) {
    this.message = message;
    this.name = name;
  }
  BaseException.prototype = new Error();
  BaseException.constructor = BaseException;
  return BaseException;
}();
class PasswordException extends BaseException {
  constructor(msg, code) {
    super(msg, "PasswordException");
    this.code = code;
  }
}
class UnknownErrorException extends BaseException {
  constructor(msg, details) {
    super(msg, "UnknownErrorException");
    this.details = details;
  }
}
class InvalidPDFException extends BaseException {
  constructor(msg) {
    super(msg, "InvalidPDFException");
  }
}
class ResponseException extends BaseException {
  constructor(msg, status, missing) {
    super(msg, "ResponseException");
    this.status = status;
    this.missing = missing;
  }
}
class FormatError extends BaseException {
  constructor(msg) {
    super(msg, "FormatError");
  }
}
class AbortException extends BaseException {
  constructor(msg) {
    super(msg, "AbortException");
  }
}
function bytesToString(bytes) {
  if (typeof bytes !== "object" || bytes?.length === undefined) {
    unreachable("Invalid argument for bytesToString");
  }
  const length = bytes.length;
  const MAX_ARGUMENT_COUNT = 8192;
  if (length < MAX_ARGUMENT_COUNT) {
    return String.fromCharCode.apply(null, bytes);
  }
  const strBuf = [];
  for (let i = 0; i < length; i += MAX_ARGUMENT_COUNT) {
    const chunkEnd = Math.min(i + MAX_ARGUMENT_COUNT, length);
    const chunk = bytes.subarray(i, chunkEnd);
    strBuf.push(String.fromCharCode.apply(null, chunk));
  }
  return strBuf.join("");
}
function stringToBytes(str) {
  if (typeof str !== "string") {
    unreachable("Invalid argument for stringToBytes");
  }
  const length = str.length;
  const bytes = new Uint8Array(length);
  for (let i = 0; i < length; ++i) {
    bytes[i] = str.charCodeAt(i) & 0xff;
  }
  return bytes;
}
function string32(value) {
  return String.fromCharCode(value >> 24 & 0xff, value >> 16 & 0xff, value >> 8 & 0xff, value & 0xff);
}
function objectSize(obj) {
  return Object.keys(obj).length;
}
function isLittleEndian() {
  const buffer8 = new Uint8Array(4);
  buffer8[0] = 1;
  const view32 = new Uint32Array(buffer8.buffer, 0, 1);
  return view32[0] === 1;
}
function isEvalSupported() {
  try {
    new Function("");
    return true;
  } catch {
    return false;
  }
}
class util_FeatureTest {
  static get isLittleEndian() {
    return shadow(this, "isLittleEndian", isLittleEndian());
  }
  static get isEvalSupported() {
    return shadow(this, "isEvalSupported", isEvalSupported());
  }
  static get isOffscreenCanvasSupported() {
    return shadow(this, "isOffscreenCanvasSupported", typeof OffscreenCanvas !== "undefined");
  }
  static get isImageDecoderSupported() {
    return shadow(this, "isImageDecoderSupported", typeof ImageDecoder !== "undefined");
  }
  static get platform() {
    const {
      platform,
      userAgent
    } = navigator;
    return shadow(this, "platform", {
      isAndroid: userAgent.includes("Android"),
      isLinux: platform.includes("Linux"),
      isMac: platform.includes("Mac"),
      isWindows: platform.includes("Win"),
      isFirefox: userAgent.includes("Firefox")
    });
  }
  static get isCSSRoundSupported() {
    return shadow(this, "isCSSRoundSupported", globalThis.CSS?.supports?.("width: round(1.5px, 1px)"));
  }
}
const hexNumbers = Array.from(Array(256).keys(), n => n.toString(16).padStart(2, "0"));
class Util {
  static makeHexColor(r, g, b) {
    return `#${hexNumbers[r]}${hexNumbers[g]}${hexNumbers[b]}`;
  }
  static scaleMinMax(transform, minMax) {
    let temp;
    if (transform[0]) {
      if (transform[0] < 0) {
        temp = minMax[0];
        minMax[0] = minMax[2];
        minMax[2] = temp;
      }
      minMax[0] *= transform[0];
      minMax[2] *= transform[0];
      if (transform[3] < 0) {
        temp = minMax[1];
        minMax[1] = minMax[3];
        minMax[3] = temp;
      }
      minMax[1] *= transform[3];
      minMax[3] *= transform[3];
    } else {
      temp = minMax[0];
      minMax[0] = minMax[1];
      minMax[1] = temp;
      temp = minMax[2];
      minMax[2] = minMax[3];
      minMax[3] = temp;
      if (transform[1] < 0) {
        temp = minMax[1];
        minMax[1] = minMax[3];
        minMax[3] = temp;
      }
      minMax[1] *= transform[1];
      minMax[3] *= transform[1];
      if (transform[2] < 0) {
        temp = minMax[0];
        minMax[0] = minMax[2];
        minMax[2] = temp;
      }
      minMax[0] *= transform[2];
      minMax[2] *= transform[2];
    }
    minMax[0] += transform[4];
    minMax[1] += transform[5];
    minMax[2] += transform[4];
    minMax[3] += transform[5];
  }
  static transform(m1, m2) {
    return [m1[0] * m2[0] + m1[2] * m2[1], m1[1] * m2[0] + m1[3] * m2[1], m1[0] * m2[2] + m1[2] * m2[3], m1[1] * m2[2] + m1[3] * m2[3], m1[0] * m2[4] + m1[2] * m2[5] + m1[4], m1[1] * m2[4] + m1[3] * m2[5] + m1[5]];
  }
  static applyTransform(p, m) {
    let pos = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;
    const p0 = p[pos];
    const p1 = p[pos + 1];
    p[pos] = p0 * m[0] + p1 * m[2] + m[4];
    p[pos + 1] = p0 * m[1] + p1 * m[3] + m[5];
  }
  static applyTransformToBezier(p, transform) {
    let pos = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;
    const m0 = transform[0];
    const m1 = transform[1];
    const m2 = transform[2];
    const m3 = transform[3];
    const m4 = transform[4];
    const m5 = transform[5];
    for (let i = 0; i < 6; i += 2) {
      const pI = p[pos + i];
      const pI1 = p[pos + i + 1];
      p[pos + i] = pI * m0 + pI1 * m2 + m4;
      p[pos + i + 1] = pI * m1 + pI1 * m3 + m5;
    }
  }
  static applyInverseTransform(p, m) {
    const p0 = p[0];
    const p1 = p[1];
    const d = m[0] * m[3] - m[1] * m[2];
    p[0] = (p0 * m[3] - p1 * m[2] + m[2] * m[5] - m[4] * m[3]) / d;
    p[1] = (-p0 * m[1] + p1 * m[0] + m[4] * m[1] - m[5] * m[0]) / d;
  }
  static axialAlignedBoundingBox(rect, transform, output) {
    const m0 = transform[0];
    const m1 = transform[1];
    const m2 = transform[2];
    const m3 = transform[3];
    const m4 = transform[4];
    const m5 = transform[5];
    const r0 = rect[0];
    const r1 = rect[1];
    const r2 = rect[2];
    const r3 = rect[3];
    let a0 = m0 * r0 + m4;
    let a2 = a0;
    let a1 = m0 * r2 + m4;
    let a3 = a1;
    let b0 = m3 * r1 + m5;
    let b2 = b0;
    let b1 = m3 * r3 + m5;
    let b3 = b1;
    if (m1 !== 0 || m2 !== 0) {
      const m1r0 = m1 * r0;
      const m1r2 = m1 * r2;
      const m2r1 = m2 * r1;
      const m2r3 = m2 * r3;
      a0 += m2r1;
      a3 += m2r1;
      a1 += m2r3;
      a2 += m2r3;
      b0 += m1r0;
      b3 += m1r0;
      b1 += m1r2;
      b2 += m1r2;
    }
    output[0] = Math.min(output[0], a0, a1, a2, a3);
    output[1] = Math.min(output[1], b0, b1, b2, b3);
    output[2] = Math.max(output[2], a0, a1, a2, a3);
    output[3] = Math.max(output[3], b0, b1, b2, b3);
  }
  static inverseTransform(m) {
    const d = m[0] * m[3] - m[1] * m[2];
    return [m[3] / d, -m[1] / d, -m[2] / d, m[0] / d, (m[2] * m[5] - m[4] * m[3]) / d, (m[4] * m[1] - m[5] * m[0]) / d];
  }
  static singularValueDecompose2dScale(matrix, output) {
    const m0 = matrix[0];
    const m1 = matrix[1];
    const m2 = matrix[2];
    const m3 = matrix[3];
    const a = m0 ** 2 + m1 ** 2;
    const b = m0 * m2 + m1 * m3;
    const c = m2 ** 2 + m3 ** 2;
    const first = (a + c) / 2;
    const second = Math.sqrt(first ** 2 - (a * c - b ** 2));
    output[0] = Math.sqrt(first + second || 1);
    output[1] = Math.sqrt(first - second || 1);
  }
  static normalizeRect(rect) {
    const r = rect.slice(0);
    if (rect[0] > rect[2]) {
      r[0] = rect[2];
      r[2] = rect[0];
    }
    if (rect[1] > rect[3]) {
      r[1] = rect[3];
      r[3] = rect[1];
    }
    return r;
  }
  static intersect(rect1, rect2) {
    const xLow = Math.max(Math.min(rect1[0], rect1[2]), Math.min(rect2[0], rect2[2]));
    const xHigh = Math.min(Math.max(rect1[0], rect1[2]), Math.max(rect2[0], rect2[2]));
    if (xLow > xHigh) {
      return null;
    }
    const yLow = Math.max(Math.min(rect1[1], rect1[3]), Math.min(rect2[1], rect2[3]));
    const yHigh = Math.min(Math.max(rect1[1], rect1[3]), Math.max(rect2[1], rect2[3]));
    if (yLow > yHigh) {
      return null;
    }
    return [xLow, yLow, xHigh, yHigh];
  }
  static pointBoundingBox(x, y, minMax) {
    minMax[0] = Math.min(minMax[0], x);
    minMax[1] = Math.min(minMax[1], y);
    minMax[2] = Math.max(minMax[2], x);
    minMax[3] = Math.max(minMax[3], y);
  }
  static rectBoundingBox(x0, y0, x1, y1, minMax) {
    minMax[0] = Math.min(minMax[0], x0, x1);
    minMax[1] = Math.min(minMax[1], y0, y1);
    minMax[2] = Math.max(minMax[2], x0, x1);
    minMax[3] = Math.max(minMax[3], y0, y1);
  }
  static bezierBoundingBox(x0, y0, x1, y1, x2, y2, x3, y3, minMax) {
    minMax[0] = Math.min(minMax[0], x0, x3);
    minMax[1] = Math.min(minMax[1], y0, y3);
    minMax[2] = Math.max(minMax[2], x0, x3);
    minMax[3] = Math.max(minMax[3], y0, y3);
    _assertClassBrand(Util, this, _getExtremum).call(this, x0, x1, x2, x3, y0, y1, y2, y3, 3 * (-x0 + 3 * (x1 - x2) + x3), 6 * (x0 - 2 * x1 + x2), 3 * (x1 - x0), minMax);
    _assertClassBrand(Util, this, _getExtremum).call(this, x0, x1, x2, x3, y0, y1, y2, y3, 3 * (-y0 + 3 * (y1 - y2) + y3), 6 * (y0 - 2 * y1 + y2), 3 * (y1 - y0), minMax);
  }
}
_Util = Util;
function _getExtremumOnCurve(x0, x1, x2, x3, y0, y1, y2, y3, t, minMax) {
  if (t <= 0 || t >= 1) {
    return;
  }
  const mt = 1 - t;
  const tt = t * t;
  const ttt = tt * t;
  const x = mt * (mt * (mt * x0 + 3 * t * x1) + 3 * tt * x2) + ttt * x3;
  const y = mt * (mt * (mt * y0 + 3 * t * y1) + 3 * tt * y2) + ttt * y3;
  minMax[0] = Math.min(minMax[0], x);
  minMax[1] = Math.min(minMax[1], y);
  minMax[2] = Math.max(minMax[2], x);
  minMax[3] = Math.max(minMax[3], y);
}
function _getExtremum(x0, x1, x2, x3, y0, y1, y2, y3, a, b, c, minMax) {
  if (Math.abs(a) < 1e-12) {
    if (Math.abs(b) >= 1e-12) {
      _assertClassBrand(_Util, this, _getExtremumOnCurve).call(this, x0, x1, x2, x3, y0, y1, y2, y3, -c / b, minMax);
    }
    return;
  }
  const delta = b ** 2 - 4 * c * a;
  if (delta < 0) {
    return;
  }
  const sqrtDelta = Math.sqrt(delta);
  const a2 = 2 * a;
  _assertClassBrand(_Util, this, _getExtremumOnCurve).call(this, x0, x1, x2, x3, y0, y1, y2, y3, (-b + sqrtDelta) / a2, minMax);
  _assertClassBrand(_Util, this, _getExtremumOnCurve).call(this, x0, x1, x2, x3, y0, y1, y2, y3, (-b - sqrtDelta) / a2, minMax);
}
const PDFStringTranslateTable = (/* unused pure expression or super */ null && ([0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x2d8, 0x2c7, 0x2c6, 0x2d9, 0x2dd, 0x2db, 0x2da, 0x2dc, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x2022, 0x2020, 0x2021, 0x2026, 0x2014, 0x2013, 0x192, 0x2044, 0x2039, 0x203a, 0x2212, 0x2030, 0x201e, 0x201c, 0x201d, 0x2018, 0x2019, 0x201a, 0x2122, 0xfb01, 0xfb02, 0x141, 0x152, 0x160, 0x178, 0x17d, 0x131, 0x142, 0x153, 0x161, 0x17e, 0, 0x20ac]));
function stringToPDFString(str) {
  let keepEscapeSequence = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
  if (str[0] >= "\xEF") {
    let encoding;
    if (str[0] === "\xFE" && str[1] === "\xFF") {
      encoding = "utf-16be";
      if (str.length % 2 === 1) {
        str = str.slice(0, -1);
      }
    } else if (str[0] === "\xFF" && str[1] === "\xFE") {
      encoding = "utf-16le";
      if (str.length % 2 === 1) {
        str = str.slice(0, -1);
      }
    } else if (str[0] === "\xEF" && str[1] === "\xBB" && str[2] === "\xBF") {
      encoding = "utf-8";
    }
    if (encoding) {
      try {
        const decoder = new TextDecoder(encoding, {
          fatal: true
        });
        const buffer = stringToBytes(str);
        const decoded = decoder.decode(buffer);
        if (keepEscapeSequence || !decoded.includes("\x1b")) {
          return decoded;
        }
        return decoded.replaceAll(/\x1b[^\x1b]*(?:\x1b|$)/g, "");
      } catch (ex) {
        warn(`stringToPDFString: "${ex}".`);
      }
    }
  }
  const strBuf = [];
  for (let i = 0, ii = str.length; i < ii; i++) {
    const charCode = str.charCodeAt(i);
    if (!keepEscapeSequence && charCode === 0x1b) {
      while (++i < ii && str.charCodeAt(i) !== 0x1b) {}
      continue;
    }
    const code = PDFStringTranslateTable[charCode];
    strBuf.push(code ? String.fromCharCode(code) : str.charAt(i));
  }
  return strBuf.join("");
}
function stringToUTF8String(str) {
  return decodeURIComponent(escape(str));
}
function utf8StringToString(str) {
  return unescape(encodeURIComponent(str));
}
function isArrayEqual(arr1, arr2) {
  if (arr1.length !== arr2.length) {
    return false;
  }
  for (let i = 0, ii = arr1.length; i < ii; i++) {
    if (arr1[i] !== arr2[i]) {
      return false;
    }
  }
  return true;
}
function getModificationDate() {
  let date = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : new Date();
  const buffer = [date.getUTCFullYear().toString(), (date.getUTCMonth() + 1).toString().padStart(2, "0"), date.getUTCDate().toString().padStart(2, "0"), date.getUTCHours().toString().padStart(2, "0"), date.getUTCMinutes().toString().padStart(2, "0"), date.getUTCSeconds().toString().padStart(2, "0")];
  return buffer.join("");
}
let NormalizeRegex = null;
let NormalizationMap = null;
function normalizeUnicode(str) {
  if (!NormalizeRegex) {
    NormalizeRegex = /([\u00a0\u00b5\u037e\u0eb3\u2000-\u200a\u202f\u2126\ufb00-\ufb04\ufb06\ufb20-\ufb36\ufb38-\ufb3c\ufb3e\ufb40-\ufb41\ufb43-\ufb44\ufb46-\ufba1\ufba4-\ufba9\ufbae-\ufbb1\ufbd3-\ufbdc\ufbde-\ufbe7\ufbea-\ufbf8\ufbfc-\ufbfd\ufc00-\ufc5d\ufc64-\ufcf1\ufcf5-\ufd3d\ufd88\ufdf4\ufdfa-\ufdfb\ufe71\ufe77\ufe79\ufe7b\ufe7d]+)|(\ufb05+)/gu;
    NormalizationMap = new Map([["ﬅ", "ſt"]]);
  }
  return str.replaceAll(NormalizeRegex, (_, p1, p2) => p1 ? p1.normalize("NFKC") : NormalizationMap.get(p2));
}
function getUuid() {
  if (typeof crypto.randomUUID === "function") {
    return crypto.randomUUID();
  }
  const buf = new Uint8Array(32);
  crypto.getRandomValues(buf);
  return bytesToString(buf);
}
const AnnotationPrefix = "pdfjs_internal_id_";
function _isValidExplicitDest(validRef, validName, dest) {
  if (!Array.isArray(dest) || dest.length < 2) {
    return false;
  }
  const [page, zoom, ...args] = dest;
  if (!validRef(page) && !Number.isInteger(page)) {
    return false;
  }
  if (!validName(zoom)) {
    return false;
  }
  const argsLen = args.length;
  let allowNull = true;
  switch (zoom.name) {
    case "XYZ":
      if (argsLen < 2 || argsLen > 3) {
        return false;
      }
      break;
    case "Fit":
    case "FitB":
      return argsLen === 0;
    case "FitH":
    case "FitBH":
    case "FitV":
    case "FitBV":
      if (argsLen > 1) {
        return false;
      }
      break;
    case "FitR":
      if (argsLen !== 4) {
        return false;
      }
      allowNull = false;
      break;
    default:
      return false;
  }
  for (const arg of args) {
    if (typeof arg === "number" || allowNull && arg === null) {
      continue;
    }
    return false;
  }
  return true;
}
function MathClamp(v, min, max) {
  return Math.min(Math.max(v, min), max);
}
function toHexUtil(arr) {
  if (Uint8Array.prototype.toHex) {
    return arr.toHex();
  }
  return Array.from(arr, num => hexNumbers[num]).join("");
}
function toBase64Util(arr) {
  if (Uint8Array.prototype.toBase64) {
    return arr.toBase64();
  }
  return btoa(bytesToString(arr));
}
function fromBase64Util(str) {
  if (Uint8Array.fromBase64) {
    return Uint8Array.fromBase64(str);
  }
  return stringToBytes(atob(str));
}
if (typeof Promise.try !== "function") {
  Promise.try = function (fn) {
    for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
      args[_key - 1] = arguments[_key];
    }
    return new Promise(resolve => {
      resolve(fn(...args));
    });
  };
}
if (typeof Math.sumPrecise !== "function") {
  Math.sumPrecise = function (numbers) {
    return numbers.reduce((a, b) => a + b, 0);
  };
}

// EXTERNAL MODULE: ./node_modules/core-js/modules/es.iterator.map.js
var es_iterator_map = __webpack_require__(1701);
// EXTERNAL MODULE: ./node_modules/core-js/modules/es.promise.with-resolvers.js
var es_promise_with_resolvers = __webpack_require__(4628);
// EXTERNAL MODULE: ./node_modules/core-js/modules/es.set.difference.v2.js
var es_set_difference_v2 = __webpack_require__(7642);
// EXTERNAL MODULE: ./node_modules/core-js/modules/es.set.intersection.v2.js
var es_set_intersection_v2 = __webpack_require__(8004);
// EXTERNAL MODULE: ./node_modules/core-js/modules/es.set.is-disjoint-from.v2.js
var es_set_is_disjoint_from_v2 = __webpack_require__(3853);
// EXTERNAL MODULE: ./node_modules/core-js/modules/es.set.is-subset-of.v2.js
var es_set_is_subset_of_v2 = __webpack_require__(5876);
// EXTERNAL MODULE: ./node_modules/core-js/modules/es.set.is-superset-of.v2.js
var es_set_is_superset_of_v2 = __webpack_require__(2475);
// EXTERNAL MODULE: ./node_modules/core-js/modules/es.set.symmetric-difference.v2.js
var es_set_symmetric_difference_v2 = __webpack_require__(5024);
// EXTERNAL MODULE: ./node_modules/core-js/modules/es.set.union.v2.js
var es_set_union_v2 = __webpack_require__(1698);
// EXTERNAL MODULE: ./node_modules/core-js/modules/web.url-search-params.delete.js
var web_url_search_params_delete = __webpack_require__(4603);
// EXTERNAL MODULE: ./node_modules/core-js/modules/web.url-search-params.has.js
var web_url_search_params_has = __webpack_require__(7566);
// EXTERNAL MODULE: ./node_modules/core-js/modules/web.url-search-params.size.js
var web_url_search_params_size = __webpack_require__(8721);
// EXTERNAL MODULE: ./node_modules/core-js/modules/es.array.at.js
var es_array_at = __webpack_require__(8107);
// EXTERNAL MODULE: ./node_modules/core-js/modules/es.iterator.drop.js
var es_iterator_drop = __webpack_require__(9314);
// EXTERNAL MODULE: ./node_modules/core-js/modules/es.iterator.every.js
var es_iterator_every = __webpack_require__(1148);
// EXTERNAL MODULE: ./node_modules/core-js/modules/es.iterator.for-each.js
var es_iterator_for_each = __webpack_require__(7588);
// EXTERNAL MODULE: ./node_modules/core-js/modules/es.iterator.some.js
var es_iterator_some = __webpack_require__(3579);
// EXTERNAL MODULE: ./node_modules/core-js/modules/es.string.at-alternative.js
var es_string_at_alternative = __webpack_require__(7357);
// EXTERNAL MODULE: ./node_modules/core-js/modules/esnext.json.parse.js
var esnext_json_parse = __webpack_require__(8335);
;// ./src/display/display_utils.js
var _PixelsPerInch;
function display_utils_assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); }





function display_utils_defineProperty(e, r, t) { return (r = display_utils_toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function display_utils_toPropertyKey(t) { var i = display_utils_toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function display_utils_toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }


const SVG_NS = "http://www.w3.org/2000/svg";
class PixelsPerInch {}
_PixelsPerInch = PixelsPerInch;
display_utils_defineProperty(PixelsPerInch, "CSS", 96.0);
display_utils_defineProperty(PixelsPerInch, "PDF", 72.0);
display_utils_defineProperty(PixelsPerInch, "PDF_TO_CSS_UNITS", _PixelsPerInch.CSS / _PixelsPerInch.PDF);
async function fetchData(url) {
  let type = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : "text";
  if (isValidFetchUrl(url, document.baseURI)) {
    const response = await fetch(url);
    if (!response.ok) {
      throw new Error(response.statusText);
    }
    switch (type) {
      case "arraybuffer":
        return response.arrayBuffer();
      case "blob":
        return response.blob();
      case "json":
        return response.json();
    }
    return response.text();
  }
  return new Promise((resolve, reject) => {
    const request = new XMLHttpRequest();
    request.open("GET", url, true);
    request.responseType = type;
    request.onreadystatechange = () => {
      if (request.readyState !== XMLHttpRequest.DONE) {
        return;
      }
      if (request.status === 200 || request.status === 0) {
        switch (type) {
          case "arraybuffer":
          case "blob":
          case "json":
            resolve(request.response);
            return;
        }
        resolve(request.responseText);
        return;
      }
      reject(new Error(request.statusText));
    };
    request.send(null);
  });
}
class PageViewport {
  constructor(_ref) {
    let {
      viewBox,
      userUnit,
      scale,
      rotation,
      offsetX = 0,
      offsetY = 0,
      dontFlip = false
    } = _ref;
    this.viewBox = viewBox;
    this.userUnit = userUnit;
    this.scale = scale;
    this.rotation = rotation;
    this.offsetX = offsetX;
    this.offsetY = offsetY;
    scale *= userUnit;
    const centerX = (viewBox[2] + viewBox[0]) / 2;
    const centerY = (viewBox[3] + viewBox[1]) / 2;
    let rotateA, rotateB, rotateC, rotateD;
    rotation %= 360;
    if (rotation < 0) {
      rotation += 360;
    }
    switch (rotation) {
      case 180:
        rotateA = -1;
        rotateB = 0;
        rotateC = 0;
        rotateD = 1;
        break;
      case 90:
        rotateA = 0;
        rotateB = 1;
        rotateC = 1;
        rotateD = 0;
        break;
      case 270:
        rotateA = 0;
        rotateB = -1;
        rotateC = -1;
        rotateD = 0;
        break;
      case 0:
        rotateA = 1;
        rotateB = 0;
        rotateC = 0;
        rotateD = -1;
        break;
      default:
        throw new Error("PageViewport: Invalid rotation, must be a multiple of 90 degrees.");
    }
    if (dontFlip) {
      rotateC = -rotateC;
      rotateD = -rotateD;
    }
    let offsetCanvasX, offsetCanvasY;
    let width, height;
    if (rotateA === 0) {
      offsetCanvasX = Math.abs(centerY - viewBox[1]) * scale + offsetX;
      offsetCanvasY = Math.abs(centerX - viewBox[0]) * scale + offsetY;
      width = (viewBox[3] - viewBox[1]) * scale;
      height = (viewBox[2] - viewBox[0]) * scale;
    } else {
      offsetCanvasX = Math.abs(centerX - viewBox[0]) * scale + offsetX;
      offsetCanvasY = Math.abs(centerY - viewBox[1]) * scale + offsetY;
      width = (viewBox[2] - viewBox[0]) * scale;
      height = (viewBox[3] - viewBox[1]) * scale;
    }
    this.transform = [rotateA * scale, rotateB * scale, rotateC * scale, rotateD * scale, offsetCanvasX - rotateA * scale * centerX - rotateC * scale * centerY, offsetCanvasY - rotateB * scale * centerX - rotateD * scale * centerY];
    this.width = width;
    this.height = height;
  }
  get rawDims() {
    const dims = this.viewBox;
    return shadow(this, "rawDims", {
      pageWidth: dims[2] - dims[0],
      pageHeight: dims[3] - dims[1],
      pageX: dims[0],
      pageY: dims[1]
    });
  }
  clone() {
    let {
      scale = this.scale,
      rotation = this.rotation,
      offsetX = this.offsetX,
      offsetY = this.offsetY,
      dontFlip = false
    } = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    return new PageViewport({
      viewBox: this.viewBox.slice(),
      userUnit: this.userUnit,
      scale,
      rotation,
      offsetX,
      offsetY,
      dontFlip
    });
  }
  convertToViewportPoint(x, y) {
    const p = [x, y];
    Util.applyTransform(p, this.transform);
    return p;
  }
  convertToViewportRectangle(rect) {
    const topLeft = [rect[0], rect[1]];
    Util.applyTransform(topLeft, this.transform);
    const bottomRight = [rect[2], rect[3]];
    Util.applyTransform(bottomRight, this.transform);
    return [topLeft[0], topLeft[1], bottomRight[0], bottomRight[1]];
  }
  convertToPdfPoint(x, y) {
    const p = [x, y];
    Util.applyInverseTransform(p, this.transform);
    return p;
  }
}
class RenderingCancelledException extends BaseException {
  constructor(msg) {
    let extraDelay = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
    super(msg, "RenderingCancelledException");
    this.extraDelay = extraDelay;
  }
}
function isDataScheme(url) {
  const ii = url.length;
  let i = 0;
  while (i < ii && url[i].trim() === "") {
    i++;
  }
  return url.substring(i, i + 5).toLowerCase() === "data:";
}
function isPdfFile(filename) {
  return typeof filename === "string" && /\.pdf$/i.test(filename);
}
function getFilenameFromUrl(url) {
  [url] = url.split(/[#?]/, 1);
  return url.substring(url.lastIndexOf("/") + 1);
}
function display_utils_getPdfFilenameFromUrl(url) {
  let defaultFilename = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : "document.pdf";
  if (defaultFilename && defaultFilename !== "document.pdf") {
    return defaultFilename;
  }
  if (typeof url !== "string") {
    return defaultFilename;
  }
  if (isDataScheme(url)) {
    warn('getPdfFilenameFromUrl: ignore "data:"-URL for performance reasons.');
    return defaultFilename;
  }
  const reURI = /^(?:(?:[^:]+:)?\/\/[^/]+)?([^?#]*)(\?[^#]*)?(#.*)?$/;
  const reFilename = /[^/?#=]+\.pdf\b(?!.*\.pdf\b)/i;
  const splitURI = reURI.exec(url);
  let suggestedFilename = reFilename.exec(splitURI[1]) || reFilename.exec(splitURI[2]) || reFilename.exec(splitURI[3]);
  if (suggestedFilename) {
    suggestedFilename = suggestedFilename[0];
    if (suggestedFilename.includes("%")) {
      try {
        suggestedFilename = reFilename.exec(decodeURIComponent(suggestedFilename))[0];
      } catch {}
    }
  }
  return suggestedFilename || defaultFilename;
}
class StatTimer {
  constructor() {
    display_utils_defineProperty(this, "started", Object.create(null));
    display_utils_defineProperty(this, "times", []);
  }
  time(name) {
    if (name in this.started) {
      warn(`Timer is already running for ${name}`);
    }
    this.started[name] = Date.now();
  }
  timeEnd(name) {
    if (!(name in this.started)) {
      warn(`Timer has not been started for ${name}`);
    }
    this.times.push({
      name,
      start: this.started[name],
      end: Date.now()
    });
    delete this.started[name];
  }
  toString() {
    const outBuf = [];
    let longest = 0;
    for (const {
      name
    } of this.times) {
      longest = Math.max(name.length, longest);
    }
    for (const {
      name,
      start,
      end
    } of this.times) {
      outBuf.push(`${name.padEnd(longest)} ${end - start}ms\n`);
    }
    return outBuf.join("");
  }
}
function isValidFetchUrl(url, baseUrl) {
  const res = baseUrl ? URL.parse(url, baseUrl) : URL.parse(url);
  return res?.protocol === "http:" || res?.protocol === "https:" || res?.protocol === "capacitor:";
}
function noContextMenu(e) {
  e.preventDefault();
}
function stopEvent(e) {
  e.preventDefault();
  e.stopPropagation();
}
function deprecated(details) {
  NgxConsole.log("Deprecated API usage: " + details);
}
class PDFDateString {
  static toDateObject(input) {
    if (!input || typeof input !== "string") {
      return null;
    }
    display_utils_assertClassBrand(PDFDateString, this, _regex)._ || (_regex._ = display_utils_assertClassBrand(PDFDateString, this, new RegExp("^D:" + "(\\d{4})" + "(\\d{2})?" + "(\\d{2})?" + "(\\d{2})?" + "(\\d{2})?" + "(\\d{2})?" + "([Z|+|-])?" + "(\\d{2})?" + "'?" + "(\\d{2})?" + "'?")));
    const matches = display_utils_assertClassBrand(PDFDateString, this, _regex)._.exec(input);
    if (!matches) {
      return null;
    }
    const year = parseInt(matches[1], 10);
    let month = parseInt(matches[2], 10);
    month = month >= 1 && month <= 12 ? month - 1 : 0;
    let day = parseInt(matches[3], 10);
    day = day >= 1 && day <= 31 ? day : 1;
    let hour = parseInt(matches[4], 10);
    hour = hour >= 0 && hour <= 23 ? hour : 0;
    let minute = parseInt(matches[5], 10);
    minute = minute >= 0 && minute <= 59 ? minute : 0;
    let second = parseInt(matches[6], 10);
    second = second >= 0 && second <= 59 ? second : 0;
    const universalTimeRelation = matches[7] || "Z";
    let offsetHour = parseInt(matches[8], 10);
    offsetHour = offsetHour >= 0 && offsetHour <= 23 ? offsetHour : 0;
    let offsetMinute = parseInt(matches[9], 10) || 0;
    offsetMinute = offsetMinute >= 0 && offsetMinute <= 59 ? offsetMinute : 0;
    if (universalTimeRelation === "-") {
      hour += offsetHour;
      minute += offsetMinute;
    } else if (universalTimeRelation === "+") {
      hour -= offsetHour;
      minute -= offsetMinute;
    }
    return new Date(Date.UTC(year, month, day, hour, minute, second));
  }
}
var _regex = {
  _: void 0
};
function getXfaPageViewport(xfaPage, _ref2) {
  let {
    scale = 1,
    rotation = 0
  } = _ref2;
  const {
    width,
    height
  } = xfaPage.attributes.style;
  const viewBox = [0, 0, parseInt(width), parseInt(height)];
  return new PageViewport({
    viewBox,
    userUnit: 1,
    scale,
    rotation
  });
}
function getRGB(color) {
  if (color.startsWith("#")) {
    const colorRGB = parseInt(color.slice(1), 16);
    return [(colorRGB & 0xff0000) >> 16, (colorRGB & 0x00ff00) >> 8, colorRGB & 0x0000ff];
  }
  if (color.startsWith("rgb(")) {
    return color.slice(4, -1).split(",").map(x => parseInt(x));
  }
  if (color.startsWith("rgba(")) {
    return color.slice(5, -1).split(",").map(x => parseInt(x)).slice(0, 3);
  }
  warn(`Not a valid color format: "${color}"`);
  return [0, 0, 0];
}
function getColorValues(colors) {
  const span = document.createElement("span");
  span.style.visibility = "hidden";
  span.style.colorScheme = "only light";
  document.body.append(span);
  for (const name of colors.keys()) {
    span.style.color = name;
    const computedColor = window.getComputedStyle(span).color;
    colors.set(name, getRGB(computedColor));
  }
  span.remove();
}
function getCurrentTransform(ctx) {
  const {
    a,
    b,
    c,
    d,
    e,
    f
  } = ctx.getTransform();
  return [a, b, c, d, e, f];
}
function getCurrentTransformInverse(ctx) {
  const {
    a,
    b,
    c,
    d,
    e,
    f
  } = ctx.getTransform().invertSelf();
  return [a, b, c, d, e, f];
}
function setLayerDimensions(div, viewport) {
  let mustFlip = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
  let mustRotate = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : true;
  if (viewport instanceof PageViewport) {
    const {
      pageWidth,
      pageHeight
    } = viewport.rawDims;
    const {
      style
    } = div;
    const useRound = util_FeatureTest.isCSSRoundSupported;
    const w = `var(--total-scale-factor) * ${pageWidth}px`,
      h = `var(--total-scale-factor) * ${pageHeight}px`;
    const widthStr = useRound ? `round(down, ${w}, var(--scale-round-x))` : `calc(${w})`,
      heightStr = useRound ? `round(down, ${h}, var(--scale-round-y))` : `calc(${h})`;
    if (!mustFlip || viewport.rotation % 180 === 0) {
      style.width = widthStr;
      style.height = heightStr;
    } else {
      style.width = heightStr;
      style.height = widthStr;
    }
  }
  if (mustRotate) {
    div.setAttribute("data-main-rotation", viewport.rotation);
  }
}
class OutputScale {
  constructor() {
    const {
      pixelRatio
    } = OutputScale;
    this.sx = pixelRatio;
    this.sy = pixelRatio;
  }
  get scaled() {
    return this.sx !== 1 || this.sy !== 1;
  }
  get symmetric() {
    return this.sx === this.sy;
  }
  limitCanvas(width, height, maxPixels, maxDim) {
    let capAreaFactor = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : -1;
    let maxAreaScale = Infinity,
      maxWidthScale = Infinity,
      maxHeightScale = Infinity;
    maxPixels = OutputScale.capPixels(maxPixels, capAreaFactor);
    if (maxPixels > 0) {
      maxAreaScale = Math.sqrt(maxPixels / (width * height));
    }
    if (maxDim !== -1) {
      maxWidthScale = maxDim / width;
      maxHeightScale = maxDim / height;
    }
    const maxScale = Math.min(maxAreaScale, maxWidthScale, maxHeightScale);
    if (this.sx > maxScale || this.sy > maxScale) {
      this.sx = maxScale;
      this.sy = maxScale;
      return true;
    }
    return false;
  }
  static get pixelRatio() {
    return globalThis.devicePixelRatio || 1;
  }
  static capPixels(maxPixels, capAreaFactor) {
    if (capAreaFactor >= 0) {
      const winPixels = Math.ceil(window.screen.availWidth * window.screen.availHeight * this.pixelRatio ** 2 * (1 + capAreaFactor / 100));
      return maxPixels > 0 ? Math.min(maxPixels, winPixels) : winPixels;
    }
    return maxPixels;
  }
}
const SupportedImageMimeTypes = ["image/apng", "image/avif", "image/bmp", "image/gif", "image/jpeg", "image/png", "image/svg+xml", "image/webp", "image/x-icon"];

;// ./src/display/editor/toolbar.js

function _classPrivateMethodInitSpec(e, a) { _checkPrivateRedeclaration(e, a), a.add(e); }
function _classPrivateFieldInitSpec(e, t, a) { _checkPrivateRedeclaration(e, t), t.set(e, a); }
function _checkPrivateRedeclaration(e, t) { if (t.has(e)) throw new TypeError("Cannot initialize the same private elements twice on an object"); }
function _classPrivateGetter(s, r, a) { return a(toolbar_assertClassBrand(s, r)); }
function _classPrivateFieldGet(s, a) { return s.get(toolbar_assertClassBrand(s, a)); }
function _classPrivateFieldSet(s, a, r) { return s.set(toolbar_assertClassBrand(s, a), r), r; }
function toolbar_assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); }

var _toolbar = /*#__PURE__*/new WeakMap();
var _colorPicker = /*#__PURE__*/new WeakMap();
var _editor = /*#__PURE__*/new WeakMap();
var _buttons = /*#__PURE__*/new WeakMap();
var _altText = /*#__PURE__*/new WeakMap();
var _signatureDescriptionButton = /*#__PURE__*/new WeakMap();
var _EditorToolbar_brand = /*#__PURE__*/new WeakSet();
class EditorToolbar {
  constructor(editor) {
    _classPrivateMethodInitSpec(this, _EditorToolbar_brand);
    _classPrivateFieldInitSpec(this, _toolbar, null);
    _classPrivateFieldInitSpec(this, _colorPicker, null);
    _classPrivateFieldInitSpec(this, _editor, void 0);
    _classPrivateFieldInitSpec(this, _buttons, null);
    _classPrivateFieldInitSpec(this, _altText, null);
    _classPrivateFieldInitSpec(this, _signatureDescriptionButton, null);
    _classPrivateFieldSet(_editor, this, editor);
    _l10nRemove._ || (_l10nRemove._ = Object.freeze({
      freetext: "pdfjs-editor-remove-freetext-button",
      highlight: "pdfjs-editor-remove-highlight-button",
      ink: "pdfjs-editor-remove-ink-button",
      stamp: "pdfjs-editor-remove-stamp-button",
      signature: "pdfjs-editor-remove-signature-button"
    }));
  }
  render() {
    const editToolbar = _classPrivateFieldSet(_toolbar, this, document.createElement("div"));
    editToolbar.classList.add("editToolbar", "hidden");
    editToolbar.setAttribute("role", "toolbar");
    const signal = _classPrivateFieldGet(_editor, this)._uiManager._signal;
    editToolbar.addEventListener("contextmenu", noContextMenu, {
      signal
    });
    editToolbar.addEventListener("pointerdown", _pointerDown, {
      signal
    });
    const buttons = _classPrivateFieldSet(_buttons, this, document.createElement("div"));
    buttons.className = "buttons";
    editToolbar.append(buttons);
    const position = _classPrivateFieldGet(_editor, this).toolbarPosition;
    if (position) {
      const {
        style
      } = editToolbar;
      const x = _classPrivateFieldGet(_editor, this)._uiManager.direction === "ltr" ? 1 - position[0] : position[0];
      style.insetInlineEnd = `${100 * x}%`;
      style.top = `calc(${100 * position[1]}% + var(--editor-toolbar-vert-offset))`;
    }
    toolbar_assertClassBrand(_EditorToolbar_brand, this, _addDeleteButton).call(this);
    return editToolbar;
  }
  get div() {
    return _classPrivateFieldGet(_toolbar, this);
  }
  hide() {
    _classPrivateFieldGet(_toolbar, this).classList.add("hidden");
    _classPrivateFieldGet(_colorPicker, this)?.hideDropdown();
  }
  show() {
    _classPrivateFieldGet(_toolbar, this).classList.remove("hidden");
    _classPrivateFieldGet(_altText, this)?.shown();
  }
  async addAltText(altText) {
    const button = await altText.render();
    toolbar_assertClassBrand(_EditorToolbar_brand, this, _addListenersToElement).call(this, button);
    _classPrivateFieldGet(_buttons, this).prepend(button, _classPrivateGetter(_EditorToolbar_brand, this, _get_divider));
    _classPrivateFieldSet(_altText, this, altText);
  }
  addColorPicker(colorPicker) {
    _classPrivateFieldSet(_colorPicker, this, colorPicker);
    const button = colorPicker.renderButton();
    toolbar_assertClassBrand(_EditorToolbar_brand, this, _addListenersToElement).call(this, button);
    _classPrivateFieldGet(_buttons, this).prepend(button, _classPrivateGetter(_EditorToolbar_brand, this, _get_divider));
  }
  async addEditSignatureButton(signatureManager) {
    const button = _classPrivateFieldSet(_signatureDescriptionButton, this, await signatureManager.renderEditButton(_classPrivateFieldGet(_editor, this)));
    toolbar_assertClassBrand(_EditorToolbar_brand, this, _addListenersToElement).call(this, button);
    _classPrivateFieldGet(_buttons, this).prepend(button, _classPrivateGetter(_EditorToolbar_brand, this, _get_divider));
  }
  updateEditSignatureButton(description) {
    if (_classPrivateFieldGet(_signatureDescriptionButton, this)) {
      _classPrivateFieldGet(_signatureDescriptionButton, this).title = description;
    }
  }
  remove() {
    _classPrivateFieldGet(_toolbar, this).remove();
    _classPrivateFieldGet(_colorPicker, this)?.destroy();
    _classPrivateFieldSet(_colorPicker, this, null);
  }
}
function _pointerDown(e) {
  e.stopPropagation();
}
function _focusIn(e) {
  _classPrivateFieldGet(_editor, this)._focusEventsAllowed = false;
  stopEvent(e);
}
function _focusOut(e) {
  _classPrivateFieldGet(_editor, this)._focusEventsAllowed = true;
  stopEvent(e);
}
function _addListenersToElement(element) {
  const signal = _classPrivateFieldGet(_editor, this)._uiManager._signal;
  element.addEventListener("focusin", toolbar_assertClassBrand(_EditorToolbar_brand, this, _focusIn).bind(this), {
    capture: true,
    signal
  });
  element.addEventListener("focusout", toolbar_assertClassBrand(_EditorToolbar_brand, this, _focusOut).bind(this), {
    capture: true,
    signal
  });
  element.addEventListener("contextmenu", noContextMenu, {
    signal
  });
}
function _addDeleteButton() {
  const {
    editorType,
    _uiManager
  } = _classPrivateFieldGet(_editor, this);
  const button = document.createElement("button");
  button.className = "delete";
  button.tabIndex = 0;
  button.setAttribute("data-l10n-id", _l10nRemove._[editorType]);
  toolbar_assertClassBrand(_EditorToolbar_brand, this, _addListenersToElement).call(this, button);
  button.addEventListener("click", e => {
    _uiManager.delete();
  }, {
    signal: _uiManager._signal
  });
  _classPrivateFieldGet(_buttons, this).append(button);
}
function _get_divider(_this) {
  const divider = document.createElement("div");
  divider.className = "divider";
  return divider;
}
var _l10nRemove = {
  _: null
};
var _buttons2 = /*#__PURE__*/new WeakMap();
var _toolbar2 = /*#__PURE__*/new WeakMap();
var _uiManager2 = /*#__PURE__*/new WeakMap();
var _HighlightToolbar_brand = /*#__PURE__*/new WeakSet();
class HighlightToolbar {
  constructor(uiManager) {
    _classPrivateMethodInitSpec(this, _HighlightToolbar_brand);
    _classPrivateFieldInitSpec(this, _buttons2, null);
    _classPrivateFieldInitSpec(this, _toolbar2, null);
    _classPrivateFieldInitSpec(this, _uiManager2, void 0);
    _classPrivateFieldSet(_uiManager2, this, uiManager);
  }
  show(parent, boxes, isLTR) {
    const [x, y] = toolbar_assertClassBrand(_HighlightToolbar_brand, this, _getLastPoint).call(this, boxes, isLTR);
    const {
      style
    } = _classPrivateFieldGet(_toolbar2, this) || _classPrivateFieldSet(_toolbar2, this, toolbar_assertClassBrand(_HighlightToolbar_brand, this, _render).call(this));
    parent.append(_classPrivateFieldGet(_toolbar2, this));
    style.insetInlineEnd = `${100 * x}%`;
    style.top = `calc(${100 * y}% + var(--editor-toolbar-vert-offset))`;
  }
  hide() {
    _classPrivateFieldGet(_toolbar2, this).remove();
  }
}
function _render() {
  const editToolbar = _classPrivateFieldSet(_toolbar2, this, document.createElement("div"));
  editToolbar.className = "editToolbar";
  editToolbar.setAttribute("role", "toolbar");
  editToolbar.addEventListener("contextmenu", noContextMenu, {
    signal: _classPrivateFieldGet(_uiManager2, this)._signal
  });
  const buttons = _classPrivateFieldSet(_buttons2, this, document.createElement("div"));
  buttons.className = "buttons";
  editToolbar.append(buttons);
  toolbar_assertClassBrand(_HighlightToolbar_brand, this, _addHighlightButton).call(this);
  return editToolbar;
}
function _getLastPoint(boxes, isLTR) {
  let lastY = 0;
  let lastX = 0;
  for (const box of boxes) {
    const y = box.y + box.height;
    if (y < lastY) {
      continue;
    }
    const x = box.x + (isLTR ? box.width : 0);
    if (y > lastY) {
      lastX = x;
      lastY = y;
      continue;
    }
    if (isLTR) {
      if (x > lastX) {
        lastX = x;
      }
    } else if (x < lastX) {
      lastX = x;
    }
  }
  return [isLTR ? 1 - lastX : lastX, lastY];
}
function _addHighlightButton() {
  const button = document.createElement("button");
  button.className = "highlightButton";
  button.tabIndex = 0;
  button.setAttribute("data-l10n-id", `pdfjs-highlight-floating-button1`);
  const span = document.createElement("span");
  button.append(span);
  span.className = "visuallyHidden";
  span.setAttribute("data-l10n-id", "pdfjs-highlight-floating-button-label");
  const signal = _classPrivateFieldGet(_uiManager2, this)._signal;
  button.addEventListener("contextmenu", noContextMenu, {
    signal
  });
  button.addEventListener("click", () => {
    _classPrivateFieldGet(_uiManager2, this).highlightSelection("floating_button");
  }, {
    signal
  });
  _classPrivateFieldGet(_buttons2, this).append(button);
}

;// ./src/display/editor/tools.js
var _ImageManager;
function tools_classPrivateGetter(s, r, a) { return a(tools_assertClassBrand(s, r)); }
function tools_defineProperty(e, r, t) { return (r = tools_toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function tools_toPropertyKey(t) { var i = tools_toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function tools_toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }































function tools_classPrivateMethodInitSpec(e, a) { tools_checkPrivateRedeclaration(e, a), a.add(e); }
function tools_classPrivateFieldInitSpec(e, t, a) { tools_checkPrivateRedeclaration(e, t), t.set(e, a); }
function tools_checkPrivateRedeclaration(e, t) { if (t.has(e)) throw new TypeError("Cannot initialize the same private elements twice on an object"); }
function tools_classPrivateFieldGet(s, a) { return s.get(tools_assertClassBrand(s, a)); }
function tools_classPrivateFieldSet(s, a, r) { return s.set(tools_assertClassBrand(s, a), r), r; }
function tools_assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); }



function bindEvents(obj, element, names) {
  for (const name of names) {
    element.addEventListener(name, obj[name].bind(obj));
  }
}
var _id = /*#__PURE__*/new WeakMap();
class IdManager {
  constructor() {
    tools_classPrivateFieldInitSpec(this, _id, 0);
  }
  get id() {
    var _this$id, _this$id2;
    return `${AnnotationEditorPrefix}${tools_classPrivateFieldSet(_id, this, (_this$id = tools_classPrivateFieldGet(_id, this), _this$id2 = _this$id++, _this$id)), _this$id2}`;
  }
}
var _baseId = /*#__PURE__*/new WeakMap();
var _id2 = /*#__PURE__*/new WeakMap();
var _cache = /*#__PURE__*/new WeakMap();
var _ImageManager_brand = /*#__PURE__*/new WeakSet();
class ImageManager {
  constructor() {
    tools_classPrivateMethodInitSpec(this, _ImageManager_brand);
    tools_classPrivateFieldInitSpec(this, _baseId, getUuid());
    tools_classPrivateFieldInitSpec(this, _id2, 0);
    tools_classPrivateFieldInitSpec(this, _cache, null);
  }
  static get _isSVGFittingCanvas() {
    const svg = `data:image/svg+xml;charset=UTF-8,<svg viewBox="0 0 1 1" width="1" height="1" xmlns="http://www.w3.org/2000/svg"><rect width="1" height="1" style="fill:red;"/></svg>`;
    const canvas = new OffscreenCanvas(1, 3);
    const ctx = canvas.getContext("2d", {
      willReadFrequently: true
    });
    const image = new Image();
    image.src = svg;
    const promise = image.decode().then(() => {
      ctx.drawImage(image, 0, 0, 1, 1, 0, 0, 1, 3);
      return new Uint32Array(ctx.getImageData(0, 0, 1, 1).data.buffer)[0] === 0;
    });
    return shadow(this, "_isSVGFittingCanvas", promise);
  }
  async getFromFile(file) {
    const {
      lastModified,
      name,
      size,
      type
    } = file;
    return tools_assertClassBrand(_ImageManager_brand, this, _get).call(this, `${lastModified}_${name}_${size}_${type}`, file);
  }
  async getFromUrl(url) {
    return tools_assertClassBrand(_ImageManager_brand, this, _get).call(this, url, url);
  }
  async getFromBlob(id, blobPromise) {
    const blob = await blobPromise;
    return tools_assertClassBrand(_ImageManager_brand, this, _get).call(this, id, blob);
  }
  async getFromId(id) {
    tools_classPrivateFieldGet(_cache, this) || tools_classPrivateFieldSet(_cache, this, new Map());
    const data = tools_classPrivateFieldGet(_cache, this).get(id);
    if (!data) {
      return null;
    }
    if (data.bitmap) {
      data.refCounter += 1;
      return data;
    }
    if (data.file) {
      return this.getFromFile(data.file);
    }
    if (data.blobPromise) {
      const {
        blobPromise
      } = data;
      delete data.blobPromise;
      return this.getFromBlob(data.id, blobPromise);
    }
    return this.getFromUrl(data.url);
  }
  getFromCanvas(id, canvas) {
    var _this$id5, _this$id6;
    tools_classPrivateFieldGet(_cache, this) || tools_classPrivateFieldSet(_cache, this, new Map());
    let data = tools_classPrivateFieldGet(_cache, this).get(id);
    if (data?.bitmap) {
      data.refCounter += 1;
      return data;
    }
    const offscreen = new OffscreenCanvas(canvas.width, canvas.height);
    const ctx = offscreen.getContext("2d");
    ctx.drawImage(canvas, 0, 0);
    data = {
      bitmap: offscreen.transferToImageBitmap(),
      id: `image_${tools_classPrivateFieldGet(_baseId, this)}_${tools_classPrivateFieldSet(_id2, this, (_this$id5 = tools_classPrivateFieldGet(_id2, this), _this$id6 = _this$id5++, _this$id5)), _this$id6}`,
      refCounter: 1,
      isSvg: false
    };
    tools_classPrivateFieldGet(_cache, this).set(id, data);
    tools_classPrivateFieldGet(_cache, this).set(data.id, data);
    return data;
  }
  getSvgUrl(id) {
    const data = tools_classPrivateFieldGet(_cache, this).get(id);
    if (!data?.isSvg) {
      return null;
    }
    return data.svgUrl;
  }
  deleteId(id) {
    tools_classPrivateFieldGet(_cache, this) || tools_classPrivateFieldSet(_cache, this, new Map());
    const data = tools_classPrivateFieldGet(_cache, this).get(id);
    if (!data) {
      return;
    }
    data.refCounter -= 1;
    if (data.refCounter !== 0) {
      return;
    }
    const {
      bitmap
    } = data;
    if (!data.url && !data.file) {
      const canvas = new OffscreenCanvas(bitmap.width, bitmap.height);
      const ctx = canvas.getContext("bitmaprenderer");
      ctx.transferFromImageBitmap(bitmap);
      data.blobPromise = canvas.convertToBlob();
    }
    bitmap.close?.();
    data.bitmap = null;
  }
  isValidId(id) {
    return id.startsWith(`image_${tools_classPrivateFieldGet(_baseId, this)}_`);
  }
}
_ImageManager = ImageManager;
async function _get(key, rawData) {
  tools_classPrivateFieldGet(_cache, this) || tools_classPrivateFieldSet(_cache, this, new Map());
  let data = tools_classPrivateFieldGet(_cache, this).get(key);
  if (data === null) {
    return null;
  }
  if (data?.bitmap) {
    data.refCounter += 1;
    return data;
  }
  try {
    var _this$id3, _this$id4;
    data ||= {
      bitmap: null,
      id: `image_${tools_classPrivateFieldGet(_baseId, this)}_${tools_classPrivateFieldSet(_id2, this, (_this$id3 = tools_classPrivateFieldGet(_id2, this), _this$id4 = _this$id3++, _this$id3)), _this$id4}`,
      refCounter: 0,
      isSvg: false
    };
    let image;
    if (typeof rawData === "string") {
      data.url = rawData;
      image = await fetchData(rawData, "blob");
    } else if (rawData instanceof File) {
      image = data.file = rawData;
    } else if (rawData instanceof Blob) {
      image = rawData;
    }
    if (image.type === "image/svg+xml") {
      const mustRemoveAspectRatioPromise = _ImageManager._isSVGFittingCanvas;
      const fileReader = new FileReader();
      const imageElement = new Image();
      const imagePromise = new Promise((resolve, reject) => {
        imageElement.onload = () => {
          data.bitmap = imageElement;
          data.isSvg = true;
          resolve();
        };
        fileReader.onload = async () => {
          const url = data.svgUrl = fileReader.result;
          imageElement.src = (await mustRemoveAspectRatioPromise) ? `${url}#svgView(preserveAspectRatio(none))` : url;
        };
        imageElement.onerror = fileReader.onerror = reject;
      });
      fileReader.readAsDataURL(image);
      await imagePromise;
    } else {
      data.bitmap = await createImageBitmap(image);
    }
    data.refCounter = 1;
  } catch (e) {
    warn(e);
    data = null;
  }
  tools_classPrivateFieldGet(_cache, this).set(key, data);
  if (data) {
    tools_classPrivateFieldGet(_cache, this).set(data.id, data);
  }
  return data;
}
var _commands = /*#__PURE__*/new WeakMap();
var _locked = /*#__PURE__*/new WeakMap();
var _maxSize = /*#__PURE__*/new WeakMap();
var _position = /*#__PURE__*/new WeakMap();
class CommandManager {
  constructor() {
    let maxSize = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 128;
    tools_classPrivateFieldInitSpec(this, _commands, []);
    tools_classPrivateFieldInitSpec(this, _locked, false);
    tools_classPrivateFieldInitSpec(this, _maxSize, void 0);
    tools_classPrivateFieldInitSpec(this, _position, -1);
    tools_classPrivateFieldSet(_maxSize, this, maxSize);
  }
  add(_ref) {
    let {
      cmd,
      undo,
      post,
      mustExec,
      type = NaN,
      overwriteIfSameType = false,
      keepUndo = false
    } = _ref;
    if (mustExec) {
      cmd();
    }
    if (tools_classPrivateFieldGet(_locked, this)) {
      return;
    }
    const save = {
      cmd,
      undo,
      post,
      type
    };
    if (tools_classPrivateFieldGet(_position, this) === -1) {
      if (tools_classPrivateFieldGet(_commands, this).length > 0) {
        tools_classPrivateFieldGet(_commands, this).length = 0;
      }
      tools_classPrivateFieldSet(_position, this, 0);
      tools_classPrivateFieldGet(_commands, this).push(save);
      return;
    }
    if (overwriteIfSameType && tools_classPrivateFieldGet(_commands, this)[tools_classPrivateFieldGet(_position, this)].type === type) {
      if (keepUndo) {
        save.undo = tools_classPrivateFieldGet(_commands, this)[tools_classPrivateFieldGet(_position, this)].undo;
      }
      tools_classPrivateFieldGet(_commands, this)[tools_classPrivateFieldGet(_position, this)] = save;
      return;
    }
    const next = tools_classPrivateFieldGet(_position, this) + 1;
    if (next === tools_classPrivateFieldGet(_maxSize, this)) {
      tools_classPrivateFieldGet(_commands, this).splice(0, 1);
    } else {
      tools_classPrivateFieldSet(_position, this, next);
      if (next < tools_classPrivateFieldGet(_commands, this).length) {
        tools_classPrivateFieldGet(_commands, this).splice(next);
      }
    }
    tools_classPrivateFieldGet(_commands, this).push(save);
  }
  undo() {
    if (tools_classPrivateFieldGet(_position, this) === -1) {
      return;
    }
    tools_classPrivateFieldSet(_locked, this, true);
    const {
      undo,
      post
    } = tools_classPrivateFieldGet(_commands, this)[tools_classPrivateFieldGet(_position, this)];
    undo();
    post?.();
    tools_classPrivateFieldSet(_locked, this, false);
    tools_classPrivateFieldSet(_position, this, tools_classPrivateFieldGet(_position, this) - 1);
  }
  redo() {
    if (tools_classPrivateFieldGet(_position, this) < tools_classPrivateFieldGet(_commands, this).length - 1) {
      tools_classPrivateFieldSet(_position, this, tools_classPrivateFieldGet(_position, this) + 1);
      tools_classPrivateFieldSet(_locked, this, true);
      const {
        cmd,
        post
      } = tools_classPrivateFieldGet(_commands, this)[tools_classPrivateFieldGet(_position, this)];
      cmd();
      post?.();
      tools_classPrivateFieldSet(_locked, this, false);
    }
  }
  hasSomethingToUndo() {
    return tools_classPrivateFieldGet(_position, this) !== -1;
  }
  hasSomethingToRedo() {
    return tools_classPrivateFieldGet(_position, this) < tools_classPrivateFieldGet(_commands, this).length - 1;
  }
  cleanType(type) {
    if (tools_classPrivateFieldGet(_position, this) === -1) {
      return;
    }
    for (let i = tools_classPrivateFieldGet(_position, this); i >= 0; i--) {
      if (tools_classPrivateFieldGet(_commands, this)[i].type !== type) {
        tools_classPrivateFieldGet(_commands, this).splice(i + 1, tools_classPrivateFieldGet(_position, this) - i);
        tools_classPrivateFieldSet(_position, this, i);
        return;
      }
    }
    tools_classPrivateFieldGet(_commands, this).length = 0;
    tools_classPrivateFieldSet(_position, this, -1);
  }
  destroy() {
    tools_classPrivateFieldSet(_commands, this, null);
  }
  reset() {
    tools_classPrivateFieldSet(_commands, this, []);
    tools_classPrivateFieldSet(_position, this, -1);
    tools_classPrivateFieldSet(_locked, this, false);
  }
}
var _KeyboardManager_brand = /*#__PURE__*/new WeakSet();
class KeyboardManager {
  constructor(callbacks) {
    tools_classPrivateMethodInitSpec(this, _KeyboardManager_brand);
    this.buffer = [];
    this.callbacks = new Map();
    this.allKeys = new Set();
    const {
      isMac
    } = util_FeatureTest.platform;
    for (const [keys, callback, options = {}] of callbacks) {
      for (const key of keys) {
        const isMacKey = key.startsWith("mac+");
        if (isMac && isMacKey) {
          this.callbacks.set(key.slice(4), {
            callback,
            options
          });
          this.allKeys.add(key.split("+").at(-1));
        } else if (!isMac && !isMacKey) {
          this.callbacks.set(key, {
            callback,
            options
          });
          this.allKeys.add(key.split("+").at(-1));
        }
      }
    }
  }
  exec(self, event) {
    if (!this.allKeys.has(event.key)) {
      return;
    }
    const info = this.callbacks.get(tools_assertClassBrand(_KeyboardManager_brand, this, _serialize).call(this, event));
    if (!info) {
      return;
    }
    const {
      callback,
      options: {
        bubbles = false,
        args = [],
        checker = null
      }
    } = info;
    if (checker && !checker(self, event)) {
      return;
    }
    callback.bind(self, ...args, event)();
    if (!bubbles) {
      stopEvent(event);
    }
  }
}
function _serialize(event) {
  if (event.altKey) {
    this.buffer.push("alt");
  }
  if (event.ctrlKey) {
    this.buffer.push("ctrl");
  }
  if (event.metaKey) {
    this.buffer.push("meta");
  }
  if (event.shiftKey) {
    this.buffer.push("shift");
  }
  this.buffer.push(event.key);
  const str = this.buffer.join("+");
  this.buffer.length = 0;
  return str;
}
class ColorManager {
  get _colors() {
    const colors = new Map([["CanvasText", null], ["Canvas", null]]);
    getColorValues(colors);
    return shadow(this, "_colors", colors);
  }
  convert(color) {
    const rgb = getRGB(color);
    if (!window.matchMedia("(forced-colors: active)").matches) {
      return rgb;
    }
    for (const [name, RGB] of this._colors) {
      if (RGB.every((x, i) => x === rgb[i])) {
        return ColorManager._colorsMapping.get(name);
      }
    }
    return rgb;
  }
  getHexCode(name) {
    const rgb = this._colors.get(name);
    if (!rgb) {
      return name;
    }
    return Util.makeHexColor(...rgb);
  }
}
tools_defineProperty(ColorManager, "_colorsMapping", new Map([["CanvasText", [0, 0, 0]], ["Canvas", [255, 255, 255]]]));
var _abortController = /*#__PURE__*/new WeakMap();
var _activeEditor = /*#__PURE__*/new WeakMap();
var _allEditors = /*#__PURE__*/new WeakMap();
var _allLayers = /*#__PURE__*/new WeakMap();
var _altTextManager = /*#__PURE__*/new WeakMap();
var _annotationStorage = /*#__PURE__*/new WeakMap();
var _changedExistingAnnotations = /*#__PURE__*/new WeakMap();
var _commandManager = /*#__PURE__*/new WeakMap();
var _copyPasteAC = /*#__PURE__*/new WeakMap();
var _currentDrawingSession = /*#__PURE__*/new WeakMap();
var _currentPageIndex = /*#__PURE__*/new WeakMap();
var _deletedAnnotationsElementIds = /*#__PURE__*/new WeakMap();
var _draggingEditors = /*#__PURE__*/new WeakMap();
var _editorTypes = /*#__PURE__*/new WeakMap();
var _editorsToRescale = /*#__PURE__*/new WeakMap();
var _enableHighlightFloatingButton = /*#__PURE__*/new WeakMap();
var _enableUpdatedAddImage = /*#__PURE__*/new WeakMap();
var _enableNewAltTextWhenAddingImage = /*#__PURE__*/new WeakMap();
var _filterFactory = /*#__PURE__*/new WeakMap();
var _focusMainContainerTimeoutId = /*#__PURE__*/new WeakMap();
var _focusManagerAC = /*#__PURE__*/new WeakMap();
var _highlightColors = /*#__PURE__*/new WeakMap();
var _highlightWhenShiftUp = /*#__PURE__*/new WeakMap();
var _highlightToolbar = /*#__PURE__*/new WeakMap();
var _idManager = /*#__PURE__*/new WeakMap();
var _isEnabled = /*#__PURE__*/new WeakMap();
var _isWaiting = /*#__PURE__*/new WeakMap();
var _keyboardManagerAC = /*#__PURE__*/new WeakMap();
var _lastActiveElement = /*#__PURE__*/new WeakMap();
var _mainHighlightColorPicker = /*#__PURE__*/new WeakMap();
var _missingCanvases = /*#__PURE__*/new WeakMap();
var _mlManager = /*#__PURE__*/new WeakMap();
var _mode = /*#__PURE__*/new WeakMap();
var _selectedEditors = /*#__PURE__*/new WeakMap();
var _selectedTextNode = /*#__PURE__*/new WeakMap();
var _signatureManager = /*#__PURE__*/new WeakMap();
var _pageColors = /*#__PURE__*/new WeakMap();
var _showAllStates = /*#__PURE__*/new WeakMap();
var _previousStates = /*#__PURE__*/new WeakMap();
var _translation = /*#__PURE__*/new WeakMap();
var _translationTimeoutId = /*#__PURE__*/new WeakMap();
var _container = /*#__PURE__*/new WeakMap();
var _viewer = /*#__PURE__*/new WeakMap();
var _updateModeCapability = /*#__PURE__*/new WeakMap();
var _AnnotationEditorUIManager_brand = /*#__PURE__*/new WeakSet();
class AnnotationEditorUIManager {
  static get _keyboardManager() {
    const proto = AnnotationEditorUIManager.prototype;
    const arrowChecker = self => tools_classPrivateFieldGet(_container, self).contains(document.activeElement) && document.activeElement.tagName !== "BUTTON" && self.hasSomethingToControl();
    const textInputChecker = (_self, _ref2) => {
      let {
        target: el
      } = _ref2;
      if (el instanceof HTMLInputElement) {
        const {
          type
        } = el;
        return type !== "text" && type !== "number";
      }
      return true;
    };
    const small = this.TRANSLATE_SMALL;
    const big = this.TRANSLATE_BIG;
    return shadow(this, "_keyboardManager", new KeyboardManager([[["ctrl+a", "mac+meta+a"], proto.selectAll, {
      checker: textInputChecker
    }], [["ctrl+z", "mac+meta+z"], proto.undo, {
      checker: textInputChecker
    }], [["ctrl+y", "ctrl+shift+z", "mac+meta+shift+z", "ctrl+shift+Z", "mac+meta+shift+Z"], proto.redo, {
      checker: textInputChecker
    }], [["Backspace", "alt+Backspace", "ctrl+Backspace", "shift+Backspace", "mac+Backspace", "mac+alt+Backspace", "mac+ctrl+Backspace", "Delete", "ctrl+Delete", "shift+Delete", "mac+Delete"], proto.delete, {
      checker: textInputChecker
    }], [["Enter", "mac+Enter"], proto.addNewEditorFromKeyboard, {
      checker: (self, _ref3) => {
        let {
          target: el
        } = _ref3;
        return !(el instanceof HTMLButtonElement) && tools_classPrivateFieldGet(_container, self).contains(el) && !self.isEnterHandled;
      }
    }], [[" ", "mac+ "], proto.addNewEditorFromKeyboard, {
      checker: (self, _ref4) => {
        let {
          target: el
        } = _ref4;
        return !(el instanceof HTMLButtonElement) && tools_classPrivateFieldGet(_container, self).contains(document.activeElement);
      }
    }], [["Escape", "mac+Escape"], proto.unselectAll], [["ArrowLeft", "mac+ArrowLeft"], proto.translateSelectedEditors, {
      args: [-small, 0],
      checker: arrowChecker
    }], [["ctrl+ArrowLeft", "mac+shift+ArrowLeft"], proto.translateSelectedEditors, {
      args: [-big, 0],
      checker: arrowChecker
    }], [["ArrowRight", "mac+ArrowRight"], proto.translateSelectedEditors, {
      args: [small, 0],
      checker: arrowChecker
    }], [["ctrl+ArrowRight", "mac+shift+ArrowRight"], proto.translateSelectedEditors, {
      args: [big, 0],
      checker: arrowChecker
    }], [["ArrowUp", "mac+ArrowUp"], proto.translateSelectedEditors, {
      args: [0, -small],
      checker: arrowChecker
    }], [["ctrl+ArrowUp", "mac+shift+ArrowUp"], proto.translateSelectedEditors, {
      args: [0, -big],
      checker: arrowChecker
    }], [["ArrowDown", "mac+ArrowDown"], proto.translateSelectedEditors, {
      args: [0, small],
      checker: arrowChecker
    }], [["ctrl+ArrowDown", "mac+shift+ArrowDown"], proto.translateSelectedEditors, {
      args: [0, big],
      checker: arrowChecker
    }]]));
  }
  constructor(container, viewer, altTextManager, signatureManager, eventBus, pdfDocument, pageColors, highlightColors, enableHighlightFloatingButton, enableUpdatedAddImage, enableNewAltTextWhenAddingImage, mlManager, editorUndoBar, supportsPinchToZoom) {
    tools_classPrivateMethodInitSpec(this, _AnnotationEditorUIManager_brand);
    tools_classPrivateFieldInitSpec(this, _abortController, new AbortController());
    tools_classPrivateFieldInitSpec(this, _activeEditor, null);
    tools_classPrivateFieldInitSpec(this, _allEditors, new Map());
    tools_classPrivateFieldInitSpec(this, _allLayers, new Map());
    tools_classPrivateFieldInitSpec(this, _altTextManager, null);
    tools_classPrivateFieldInitSpec(this, _annotationStorage, null);
    tools_classPrivateFieldInitSpec(this, _changedExistingAnnotations, null);
    tools_classPrivateFieldInitSpec(this, _commandManager, new CommandManager());
    tools_classPrivateFieldInitSpec(this, _copyPasteAC, null);
    tools_classPrivateFieldInitSpec(this, _currentDrawingSession, null);
    tools_classPrivateFieldInitSpec(this, _currentPageIndex, 0);
    tools_classPrivateFieldInitSpec(this, _deletedAnnotationsElementIds, new Set());
    tools_classPrivateFieldInitSpec(this, _draggingEditors, null);
    tools_classPrivateFieldInitSpec(this, _editorTypes, null);
    tools_classPrivateFieldInitSpec(this, _editorsToRescale, new Set());
    tools_defineProperty(this, "_editorUndoBar", null);
    tools_classPrivateFieldInitSpec(this, _enableHighlightFloatingButton, false);
    tools_classPrivateFieldInitSpec(this, _enableUpdatedAddImage, false);
    tools_classPrivateFieldInitSpec(this, _enableNewAltTextWhenAddingImage, false);
    tools_classPrivateFieldInitSpec(this, _filterFactory, null);
    tools_classPrivateFieldInitSpec(this, _focusMainContainerTimeoutId, null);
    tools_classPrivateFieldInitSpec(this, _focusManagerAC, null);
    tools_classPrivateFieldInitSpec(this, _highlightColors, null);
    tools_classPrivateFieldInitSpec(this, _highlightWhenShiftUp, false);
    tools_classPrivateFieldInitSpec(this, _highlightToolbar, null);
    tools_classPrivateFieldInitSpec(this, _idManager, new IdManager());
    tools_classPrivateFieldInitSpec(this, _isEnabled, false);
    tools_classPrivateFieldInitSpec(this, _isWaiting, false);
    tools_classPrivateFieldInitSpec(this, _keyboardManagerAC, null);
    tools_classPrivateFieldInitSpec(this, _lastActiveElement, null);
    tools_classPrivateFieldInitSpec(this, _mainHighlightColorPicker, null);
    tools_classPrivateFieldInitSpec(this, _missingCanvases, null);
    tools_classPrivateFieldInitSpec(this, _mlManager, null);
    tools_classPrivateFieldInitSpec(this, _mode, AnnotationEditorType.NONE);
    tools_classPrivateFieldInitSpec(this, _selectedEditors, new Set());
    tools_classPrivateFieldInitSpec(this, _selectedTextNode, null);
    tools_classPrivateFieldInitSpec(this, _signatureManager, null);
    tools_classPrivateFieldInitSpec(this, _pageColors, null);
    tools_classPrivateFieldInitSpec(this, _showAllStates, null);
    tools_classPrivateFieldInitSpec(this, _previousStates, {
      isEditing: false,
      isEmpty: true,
      hasSomethingToUndo: false,
      hasSomethingToRedo: false,
      hasSelectedEditor: false,
      hasSelectedText: false
    });
    tools_classPrivateFieldInitSpec(this, _translation, [0, 0]);
    tools_classPrivateFieldInitSpec(this, _translationTimeoutId, null);
    tools_classPrivateFieldInitSpec(this, _container, null);
    tools_classPrivateFieldInitSpec(this, _viewer, null);
    tools_classPrivateFieldInitSpec(this, _updateModeCapability, null);
    const _signal = this._signal = tools_classPrivateFieldGet(_abortController, this).signal;
    tools_classPrivateFieldSet(_container, this, container);
    tools_classPrivateFieldSet(_viewer, this, viewer);
    tools_classPrivateFieldSet(_altTextManager, this, altTextManager);
    tools_classPrivateFieldSet(_signatureManager, this, signatureManager);
    this._eventBus = eventBus;
    eventBus._on("editingaction", this.onEditingAction.bind(this), {
      signal: _signal
    });
    eventBus._on("pagechanging", this.onPageChanging.bind(this), {
      signal: _signal
    });
    eventBus._on("scalechanging", this.onScaleChanging.bind(this), {
      signal: _signal
    });
    eventBus._on("rotationchanging", this.onRotationChanging.bind(this), {
      signal: _signal
    });
    eventBus._on("setpreference", this.onSetPreference.bind(this), {
      signal: _signal
    });
    eventBus._on("switchannotationeditorparams", evt => this.updateParams(evt.type, evt.value), {
      signal: _signal
    });
    tools_assertClassBrand(_AnnotationEditorUIManager_brand, this, _addSelectionListener).call(this);
    tools_assertClassBrand(_AnnotationEditorUIManager_brand, this, _addDragAndDropListeners).call(this);
    tools_assertClassBrand(_AnnotationEditorUIManager_brand, this, _addKeyboardManager).call(this);
    tools_classPrivateFieldSet(_annotationStorage, this, pdfDocument.annotationStorage);
    tools_classPrivateFieldSet(_filterFactory, this, pdfDocument.filterFactory);
    tools_classPrivateFieldSet(_pageColors, this, pageColors);
    tools_classPrivateFieldSet(_highlightColors, this, highlightColors || null);
    tools_classPrivateFieldSet(_enableHighlightFloatingButton, this, enableHighlightFloatingButton);
    tools_classPrivateFieldSet(_enableUpdatedAddImage, this, enableUpdatedAddImage);
    tools_classPrivateFieldSet(_enableNewAltTextWhenAddingImage, this, enableNewAltTextWhenAddingImage);
    tools_classPrivateFieldSet(_mlManager, this, mlManager || null);
    this.viewParameters = {
      realScale: PixelsPerInch.PDF_TO_CSS_UNITS,
      rotation: 0
    };
    this.isShiftKeyDown = false;
    this._editorUndoBar = editorUndoBar || null;
    this._supportsPinchToZoom = supportsPinchToZoom !== false;
  }
  destroy() {
    tools_classPrivateFieldGet(_updateModeCapability, this)?.resolve();
    tools_classPrivateFieldSet(_updateModeCapability, this, null);
    tools_classPrivateFieldGet(_abortController, this)?.abort();
    tools_classPrivateFieldSet(_abortController, this, null);
    this._signal = null;
    for (const layer of tools_classPrivateFieldGet(_allLayers, this).values()) {
      layer.destroy();
    }
    tools_classPrivateFieldGet(_allLayers, this).clear();
    tools_classPrivateFieldGet(_allEditors, this).clear();
    tools_classPrivateFieldGet(_editorsToRescale, this).clear();
    tools_classPrivateFieldGet(_missingCanvases, this)?.clear();
    tools_classPrivateFieldSet(_activeEditor, this, null);
    tools_classPrivateFieldGet(_selectedEditors, this).clear();
    tools_classPrivateFieldGet(_commandManager, this).destroy();
    tools_classPrivateFieldGet(_altTextManager, this)?.destroy();
    tools_classPrivateFieldGet(_signatureManager, this)?.destroy();
    tools_classPrivateFieldGet(_highlightToolbar, this)?.hide();
    tools_classPrivateFieldSet(_highlightToolbar, this, null);
    tools_classPrivateFieldGet(_mainHighlightColorPicker, this)?.destroy();
    tools_classPrivateFieldSet(_mainHighlightColorPicker, this, null);
    if (tools_classPrivateFieldGet(_focusMainContainerTimeoutId, this)) {
      clearTimeout(tools_classPrivateFieldGet(_focusMainContainerTimeoutId, this));
      tools_classPrivateFieldSet(_focusMainContainerTimeoutId, this, null);
    }
    if (tools_classPrivateFieldGet(_translationTimeoutId, this)) {
      clearTimeout(tools_classPrivateFieldGet(_translationTimeoutId, this));
      tools_classPrivateFieldSet(_translationTimeoutId, this, null);
    }
    this._editorUndoBar?.destroy();
  }
  combinedSignal(ac) {
    return AbortSignal.any([this._signal, ac.signal]);
  }
  get mlManager() {
    return tools_classPrivateFieldGet(_mlManager, this);
  }
  get useNewAltTextFlow() {
    return tools_classPrivateFieldGet(_enableUpdatedAddImage, this);
  }
  get useNewAltTextWhenAddingImage() {
    return tools_classPrivateFieldGet(_enableNewAltTextWhenAddingImage, this);
  }
  get hcmFilter() {
    return shadow(this, "hcmFilter", tools_classPrivateFieldGet(_pageColors, this) ? tools_classPrivateFieldGet(_filterFactory, this).addHCMFilter(tools_classPrivateFieldGet(_pageColors, this).foreground, tools_classPrivateFieldGet(_pageColors, this).background) : "none");
  }
  get direction() {
    return shadow(this, "direction", getComputedStyle(tools_classPrivateFieldGet(_container, this)).direction);
  }
  get highlightColors() {
    return shadow(this, "highlightColors", tools_classPrivateFieldGet(_highlightColors, this) ? new Map(tools_classPrivateFieldGet(_highlightColors, this).split(",").map(pair => pair.split("=").map(x => x.trim()))) : null);
  }
  get highlightColorNames() {
    return shadow(this, "highlightColorNames", this.highlightColors ? new Map(Array.from(this.highlightColors, e => e.reverse())) : null);
  }
  setCurrentDrawingSession(layer) {
    if (layer) {
      this.unselectAll();
      this.disableUserSelect(true);
    } else {
      this.disableUserSelect(false);
    }
    tools_classPrivateFieldSet(_currentDrawingSession, this, layer);
  }
  setMainHighlightColorPicker(colorPicker) {
    tools_classPrivateFieldSet(_mainHighlightColorPicker, this, colorPicker);
  }
  editAltText(editor) {
    let firstTime = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
    tools_classPrivateFieldGet(_altTextManager, this)?.editAltText(this, editor, firstTime);
  }
  getSignature(editor) {
    tools_classPrivateFieldGet(_signatureManager, this)?.getSignature({
      uiManager: this,
      editor
    });
  }
  get signatureManager() {
    return tools_classPrivateFieldGet(_signatureManager, this);
  }
  switchToMode(mode, callback) {
    this._eventBus.on("annotationeditormodechanged", callback, {
      once: true,
      signal: this._signal
    });
    this._eventBus.dispatch("showannotationeditorui", {
      source: this,
      mode
    });
  }
  setPreference(name, value) {
    this._eventBus.dispatch("setpreference", {
      source: this,
      name,
      value
    });
  }
  onSetPreference(_ref5) {
    let {
      name,
      value
    } = _ref5;
    switch (name) {
      case "enableNewAltTextWhenAddingImage":
        tools_classPrivateFieldSet(_enableNewAltTextWhenAddingImage, this, value);
        break;
    }
  }
  onPageChanging(_ref6) {
    let {
      pageNumber
    } = _ref6;
    tools_classPrivateFieldSet(_currentPageIndex, this, pageNumber - 1);
  }
  focusMainContainer() {
    tools_classPrivateFieldGet(_container, this).focus();
  }
  findParent(x, y) {
    for (const layer of tools_classPrivateFieldGet(_allLayers, this).values()) {
      const {
        x: layerX,
        y: layerY,
        width,
        height
      } = layer.div.getBoundingClientRect();
      if (x >= layerX && x <= layerX + width && y >= layerY && y <= layerY + height) {
        return layer;
      }
    }
    return null;
  }
  disableUserSelect() {
    let value = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
    tools_classPrivateFieldGet(_viewer, this).classList.toggle("noUserSelect", value);
  }
  addShouldRescale(editor) {
    tools_classPrivateFieldGet(_editorsToRescale, this).add(editor);
  }
  removeShouldRescale(editor) {
    tools_classPrivateFieldGet(_editorsToRescale, this).delete(editor);
  }
  onScaleChanging(_ref7) {
    let {
      scale
    } = _ref7;
    this.commitOrRemove();
    this.viewParameters.realScale = scale * PixelsPerInch.PDF_TO_CSS_UNITS;
    for (const editor of tools_classPrivateFieldGet(_editorsToRescale, this)) {
      editor.onScaleChanging();
    }
    tools_classPrivateFieldGet(_currentDrawingSession, this)?.onScaleChanging();
  }
  onRotationChanging(_ref8) {
    let {
      pagesRotation
    } = _ref8;
    this.commitOrRemove();
    this.viewParameters.rotation = pagesRotation;
  }
  highlightSelection() {
    let methodOfCreation = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : "";
    const selection = document.getSelection();
    if (!selection || selection.isCollapsed) {
      return;
    }
    const {
      anchorNode,
      anchorOffset,
      focusNode,
      focusOffset
    } = selection;
    const text = selection.toString();
    const anchorElement = tools_assertClassBrand(_AnnotationEditorUIManager_brand, this, _getAnchorElementForSelection).call(this, selection);
    const textLayer = anchorElement.closest(".textLayer");
    const boxes = this.getSelectionBoxes(textLayer);
    if (!boxes) {
      return;
    }
    selection.empty();
    const layer = tools_assertClassBrand(_AnnotationEditorUIManager_brand, this, _getLayerForTextLayer).call(this, textLayer);
    const isNoneMode = tools_classPrivateFieldGet(_mode, this) === AnnotationEditorType.NONE;
    const callback = () => {
      layer?.createAndAddNewEditor({
        x: 0,
        y: 0
      }, false, {
        methodOfCreation,
        boxes,
        anchorNode,
        anchorOffset,
        focusNode,
        focusOffset,
        text
      });
      if (isNoneMode) {
        this.showAllEditors("highlight", true, true);
      }
    };
    if (isNoneMode) {
      this.switchToMode(AnnotationEditorType.HIGHLIGHT, callback);
      return;
    }
    callback();
  }
  addToAnnotationStorage(editor) {
    if (!editor.isEmpty() && tools_classPrivateFieldGet(_annotationStorage, this) && !tools_classPrivateFieldGet(_annotationStorage, this).has(editor.id)) {
      tools_classPrivateFieldGet(_annotationStorage, this).setValue(editor.id, editor);
    }
  }
  blur() {
    this.isShiftKeyDown = false;
    if (tools_classPrivateFieldGet(_highlightWhenShiftUp, this)) {
      tools_classPrivateFieldSet(_highlightWhenShiftUp, this, false);
      tools_assertClassBrand(_AnnotationEditorUIManager_brand, this, _onSelectEnd).call(this, "main_toolbar");
    }
    if (!this.hasSelection) {
      return;
    }
    const {
      activeElement
    } = document;
    for (const editor of tools_classPrivateFieldGet(_selectedEditors, this)) {
      if (editor.div.contains(activeElement)) {
        tools_classPrivateFieldSet(_lastActiveElement, this, [editor, activeElement]);
        editor._focusEventsAllowed = false;
        break;
      }
    }
  }
  focus() {
    if (!tools_classPrivateFieldGet(_lastActiveElement, this)) {
      return;
    }
    const [lastEditor, lastActiveElement] = tools_classPrivateFieldGet(_lastActiveElement, this);
    tools_classPrivateFieldSet(_lastActiveElement, this, null);
    lastActiveElement.addEventListener("focusin", () => {
      lastEditor._focusEventsAllowed = true;
    }, {
      once: true,
      signal: this._signal
    });
    lastActiveElement.focus();
  }
  addEditListeners() {
    tools_assertClassBrand(_AnnotationEditorUIManager_brand, this, _addKeyboardManager).call(this);
    tools_assertClassBrand(_AnnotationEditorUIManager_brand, this, _addCopyPasteListeners).call(this);
  }
  removeEditListeners() {
    tools_assertClassBrand(_AnnotationEditorUIManager_brand, this, _removeKeyboardManager).call(this);
    tools_assertClassBrand(_AnnotationEditorUIManager_brand, this, _removeCopyPasteListeners).call(this);
  }
  dragOver(event) {
    for (const {
      type
    } of event.dataTransfer.items) {
      for (const editorType of tools_classPrivateFieldGet(_editorTypes, this)) {
        if (editorType.isHandlingMimeForPasting(type)) {
          event.dataTransfer.dropEffect = "copy";
          event.preventDefault();
          return;
        }
      }
    }
  }
  drop(event) {
    for (const item of event.dataTransfer.items) {
      for (const editorType of tools_classPrivateFieldGet(_editorTypes, this)) {
        if (editorType.isHandlingMimeForPasting(item.type)) {
          editorType.paste(item, this.currentLayer);
          event.preventDefault();
          return;
        }
      }
    }
  }
  copy(event) {
    event.preventDefault();
    tools_classPrivateFieldGet(_activeEditor, this)?.commitOrRemove();
    if (!this.hasSelection) {
      return;
    }
    const editors = [];
    for (const editor of tools_classPrivateFieldGet(_selectedEditors, this)) {
      const serialized = editor.serialize(true);
      if (serialized) {
        editors.push(serialized);
      }
    }
    if (editors.length === 0) {
      return;
    }
    event.clipboardData.setData("application/pdfjs", JSON.stringify(editors));
  }
  cut(event) {
    this.copy(event);
    this.delete();
  }
  async paste(event) {
    event.preventDefault();
    const {
      clipboardData
    } = event;
    for (const item of clipboardData.items) {
      for (const editorType of tools_classPrivateFieldGet(_editorTypes, this)) {
        if (editorType.isHandlingMimeForPasting(item.type)) {
          editorType.paste(item, this.currentLayer);
          return;
        }
      }
    }
    const data = clipboardData.getData("application/pdfjs");
    await this.addSerializedEditor(data);
  }
  async addSerializedEditor(data) {
    let activateEditorIfNecessary = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
    let doNotMove = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
    let ignorePageNumber = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : true;
    if (!data) {
      return;
    }
    try {
      if (typeof data === "string") {
        data = JSON.parse(data);
      }
    } catch (ex) {
      warn(`paste: "${ex.message}".`);
      return;
    }
    if (!Array.isArray(data)) {
      return;
    }
    const previousMode = tools_classPrivateFieldGet(_mode, this);
    if (activateEditorIfNecessary && previousMode === AnnotationEditorType.NONE) {
      this.updateMode(AnnotationEditorType.FREETEXT);
    }
    this.unselectAll();
    try {
      const newEditors = [];
      for (const editor of data) {
        const pageNumberMissing = editor.pageIndex === undefined;
        const useCurrentPage = ignorePageNumber || pageNumberMissing;
        const layer = useCurrentPage ? this.currentLayer : this.getLayer(editor.pageIndex);
        const deserializedEditor = await layer.deserialize(editor);
        if (!deserializedEditor) {
          return;
        }
        deserializedEditor.doNotMove = doNotMove;
        newEditors.push(deserializedEditor);
      }
      const cmd = () => {
        for (const editor of newEditors) {
          tools_assertClassBrand(_AnnotationEditorUIManager_brand, this, _addEditorToLayer).call(this, editor);
        }
        tools_assertClassBrand(_AnnotationEditorUIManager_brand, this, _selectEditors).call(this, newEditors);
      };
      const undo = () => {
        for (const editor of newEditors) {
          editor.remove();
        }
      };
      this.addCommands({
        cmd,
        undo,
        mustExec: true
      });
    } catch (ex) {
      warn(`paste: "${ex.message}".`);
    }
    if (activateEditorIfNecessary && previousMode !== tools_classPrivateFieldGet(_mode, this)) {
      this.updateMode(previousMode);
    }
  }
  keydown(event) {
    if (!this.isShiftKeyDown && event.key === "Shift") {
      this.isShiftKeyDown = true;
    }
    if (tools_classPrivateFieldGet(_mode, this) !== AnnotationEditorType.NONE && !this.isEditorHandlingKeyboard) {
      AnnotationEditorUIManager._keyboardManager.exec(this, event);
    }
  }
  keyup(event) {
    if (this.isShiftKeyDown && event.key === "Shift") {
      this.isShiftKeyDown = false;
      if (tools_classPrivateFieldGet(_highlightWhenShiftUp, this)) {
        tools_classPrivateFieldSet(_highlightWhenShiftUp, this, false);
        tools_assertClassBrand(_AnnotationEditorUIManager_brand, this, _onSelectEnd).call(this, "main_toolbar");
      }
    }
  }
  onEditingAction(_ref9) {
    let {
      name
    } = _ref9;
    switch (name) {
      case "undo":
      case "redo":
      case "delete":
      case "selectAll":
        this[name]();
        break;
      case "highlightSelection":
        this.highlightSelection("context_menu");
        break;
    }
  }
  setEditingState(isEditing) {
    if (isEditing) {
      tools_assertClassBrand(_AnnotationEditorUIManager_brand, this, _addFocusManager).call(this);
      tools_assertClassBrand(_AnnotationEditorUIManager_brand, this, _addCopyPasteListeners).call(this);
      tools_assertClassBrand(_AnnotationEditorUIManager_brand, this, _dispatchUpdateStates).call(this, {
        isEditing: tools_classPrivateFieldGet(_mode, this) !== AnnotationEditorType.NONE,
        isEmpty: tools_assertClassBrand(_AnnotationEditorUIManager_brand, this, _isEmpty).call(this),
        hasSomethingToUndo: tools_classPrivateFieldGet(_commandManager, this).hasSomethingToUndo(),
        hasSomethingToRedo: tools_classPrivateFieldGet(_commandManager, this).hasSomethingToRedo(),
        hasSelectedEditor: false
      });
    } else {
      tools_assertClassBrand(_AnnotationEditorUIManager_brand, this, _removeFocusManager).call(this);
      tools_assertClassBrand(_AnnotationEditorUIManager_brand, this, _removeCopyPasteListeners).call(this);
      tools_assertClassBrand(_AnnotationEditorUIManager_brand, this, _dispatchUpdateStates).call(this, {
        isEditing: false
      });
      this.disableUserSelect(false);
    }
  }
  registerEditorTypes(types) {
    if (tools_classPrivateFieldGet(_editorTypes, this)) {
      return;
    }
    tools_classPrivateFieldSet(_editorTypes, this, types);
    for (const editorType of tools_classPrivateFieldGet(_editorTypes, this)) {
      tools_assertClassBrand(_AnnotationEditorUIManager_brand, this, _dispatchUpdateUI).call(this, editorType.defaultPropertiesToUpdate);
    }
  }
  getId() {
    return tools_classPrivateFieldGet(_idManager, this).id;
  }
  get currentLayer() {
    return tools_classPrivateFieldGet(_allLayers, this).get(tools_classPrivateFieldGet(_currentPageIndex, this));
  }
  getLayer(pageIndex) {
    return tools_classPrivateFieldGet(_allLayers, this).get(pageIndex);
  }
  get currentPageIndex() {
    return tools_classPrivateFieldGet(_currentPageIndex, this);
  }
  addLayer(layer) {
    tools_classPrivateFieldGet(_allLayers, this).set(layer.pageIndex, layer);
    if (tools_classPrivateFieldGet(_isEnabled, this)) {
      layer.enable();
    } else {
      layer.disable();
    }
  }
  removeLayer(layer) {
    tools_classPrivateFieldGet(_allLayers, this).delete(layer.pageIndex);
  }
  async updateMode(mode) {
    let editId = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
    let isFromKeyboard = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
    if (tools_classPrivateFieldGet(_mode, this) === mode) {
      return;
    }
    if (tools_classPrivateFieldGet(_updateModeCapability, this)) {
      await tools_classPrivateFieldGet(_updateModeCapability, this).promise;
      if (!tools_classPrivateFieldGet(_updateModeCapability, this)) {
        return;
      }
    }
    tools_classPrivateFieldSet(_updateModeCapability, this, Promise.withResolvers());
    tools_classPrivateFieldGet(_currentDrawingSession, this)?.commitOrRemove();
    tools_classPrivateFieldSet(_mode, this, mode);
    if (mode === AnnotationEditorType.NONE) {
      this.setEditingState(false);
      tools_assertClassBrand(_AnnotationEditorUIManager_brand, this, _disableAll).call(this);
      this._editorUndoBar?.hide();
      tools_classPrivateFieldGet(_updateModeCapability, this).resolve();
      return;
    }
    if (mode === AnnotationEditorType.SIGNATURE) {
      await tools_classPrivateFieldGet(_signatureManager, this)?.loadSignatures();
    }
    this.setEditingState(true);
    await tools_assertClassBrand(_AnnotationEditorUIManager_brand, this, _enableAll).call(this);
    this.unselectAll();
    for (const layer of tools_classPrivateFieldGet(_allLayers, this).values()) {
      layer.updateMode(mode);
    }
    if (!editId) {
      if (isFromKeyboard) {
        this.addNewEditorFromKeyboard();
      }
      tools_classPrivateFieldGet(_updateModeCapability, this).resolve();
      return;
    }
    for (const editor of tools_classPrivateFieldGet(_allEditors, this).values()) {
      if (editor.annotationElementId === editId || editor.id === editId) {
        this.setSelected(editor);
        editor.enterInEditMode();
      } else {
        editor.unselect();
      }
    }
    tools_classPrivateFieldGet(_updateModeCapability, this).resolve();
  }
  addNewEditorFromKeyboard() {
    if (this.currentLayer.canCreateNewEmptyEditor()) {
      this.currentLayer.addNewEditor();
    }
  }
  updateToolbar(options) {
    if (options.mode === tools_classPrivateFieldGet(_mode, this)) {
      return;
    }
    this._eventBus.dispatch("switchannotationeditormode", {
      source: this,
      ...options
    });
  }
  updateParams(type, value) {
    if (!tools_classPrivateFieldGet(_editorTypes, this)) {
      return;
    }
    switch (type) {
      case AnnotationEditorParamsType.CREATE:
        this.currentLayer.addNewEditor(value);
        return;
      case AnnotationEditorParamsType.HIGHLIGHT_DEFAULT_COLOR:
        tools_classPrivateFieldGet(_mainHighlightColorPicker, this)?.updateColor(value);
        break;
      case AnnotationEditorParamsType.HIGHLIGHT_SHOW_ALL:
        this._eventBus.dispatch("reporttelemetry", {
          source: this,
          details: {
            type: "editing",
            data: {
              type: "highlight",
              action: "toggle_visibility"
            }
          }
        });
        (tools_classPrivateFieldGet(_showAllStates, this) || tools_classPrivateFieldSet(_showAllStates, this, new Map())).set(type, value);
        this.showAllEditors("highlight", value);
        break;
    }
    for (const editor of tools_classPrivateFieldGet(_selectedEditors, this)) {
      editor.updateParams(type, value);
    }
    for (const editorType of tools_classPrivateFieldGet(_editorTypes, this)) {
      editorType.updateDefaultParams(type, value);
    }
  }
  showAllEditors(type, visible) {
    let updateButton = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
    for (const editor of tools_classPrivateFieldGet(_allEditors, this).values()) {
      if (editor.editorType === type) {
        editor.show(visible);
      }
    }
    const state = tools_classPrivateFieldGet(_showAllStates, this)?.get(AnnotationEditorParamsType.HIGHLIGHT_SHOW_ALL) ?? true;
    if (state !== visible) {
      tools_assertClassBrand(_AnnotationEditorUIManager_brand, this, _dispatchUpdateUI).call(this, [[AnnotationEditorParamsType.HIGHLIGHT_SHOW_ALL, visible]]);
    }
  }
  enableWaiting() {
    let mustWait = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
    if (tools_classPrivateFieldGet(_isWaiting, this) === mustWait) {
      return;
    }
    tools_classPrivateFieldSet(_isWaiting, this, mustWait);
    for (const layer of tools_classPrivateFieldGet(_allLayers, this).values()) {
      if (mustWait) {
        layer.disableClick();
      } else {
        layer.enableClick();
      }
      layer.div.classList.toggle("waiting", mustWait);
    }
  }
  getEditors(pageIndex) {
    const editors = [];
    for (const editor of tools_classPrivateFieldGet(_allEditors, this).values()) {
      if (editor.pageIndex === pageIndex) {
        editors.push(editor);
      }
    }
    return editors;
  }
  getEditor(id) {
    return tools_classPrivateFieldGet(_allEditors, this).get(id);
  }
  addEditor(editor) {
    tools_classPrivateFieldGet(_allEditors, this).set(editor.id, editor);
  }
  removeEditor(editor) {
    if (editor.div.contains(document.activeElement)) {
      if (tools_classPrivateFieldGet(_focusMainContainerTimeoutId, this)) {
        clearTimeout(tools_classPrivateFieldGet(_focusMainContainerTimeoutId, this));
      }
      tools_classPrivateFieldSet(_focusMainContainerTimeoutId, this, setTimeout(() => {
        this.focusMainContainer();
        tools_classPrivateFieldSet(_focusMainContainerTimeoutId, this, null);
      }, 0));
    }
    tools_classPrivateFieldGet(_allEditors, this).delete(editor.id);
    if (editor.annotationElementId) {
      tools_classPrivateFieldGet(_missingCanvases, this)?.delete(editor.annotationElementId);
    }
    this.unselect(editor);
    if (!editor.annotationElementId || !tools_classPrivateFieldGet(_deletedAnnotationsElementIds, this).has(editor.annotationElementId)) {
      tools_classPrivateFieldGet(_annotationStorage, this)?.remove(editor.id);
    }
  }
  addDeletedAnnotationElement(editor) {
    tools_classPrivateFieldGet(_deletedAnnotationsElementIds, this).add(editor.annotationElementId);
    this.addChangedExistingAnnotation(editor);
    editor.deleted = true;
  }
  isDeletedAnnotationElement(annotationElementId) {
    return tools_classPrivateFieldGet(_deletedAnnotationsElementIds, this).has(annotationElementId);
  }
  removeDeletedAnnotationElement(editor) {
    tools_classPrivateFieldGet(_deletedAnnotationsElementIds, this).delete(editor.annotationElementId);
    this.removeChangedExistingAnnotation(editor);
    editor.deleted = false;
  }
  setActiveEditor(editor) {
    if (tools_classPrivateFieldGet(_activeEditor, this) === editor) {
      return;
    }
    tools_classPrivateFieldSet(_activeEditor, this, editor);
    if (editor) {
      tools_assertClassBrand(_AnnotationEditorUIManager_brand, this, _dispatchUpdateUI).call(this, editor.propertiesToUpdate);
    }
  }
  updateUI(editor) {
    if (tools_classPrivateGetter(_AnnotationEditorUIManager_brand, this, _get_lastSelectedEditor) === editor) {
      tools_assertClassBrand(_AnnotationEditorUIManager_brand, this, _dispatchUpdateUI).call(this, editor.propertiesToUpdate);
    }
  }
  updateUIForDefaultProperties(editorType) {
    tools_assertClassBrand(_AnnotationEditorUIManager_brand, this, _dispatchUpdateUI).call(this, editorType.defaultPropertiesToUpdate);
  }
  toggleSelected(editor) {
    if (tools_classPrivateFieldGet(_selectedEditors, this).has(editor)) {
      tools_classPrivateFieldGet(_selectedEditors, this).delete(editor);
      editor.unselect();
      tools_assertClassBrand(_AnnotationEditorUIManager_brand, this, _dispatchUpdateStates).call(this, {
        hasSelectedEditor: this.hasSelection
      });
      return;
    }
    tools_classPrivateFieldGet(_selectedEditors, this).add(editor);
    editor.select();
    tools_assertClassBrand(_AnnotationEditorUIManager_brand, this, _dispatchUpdateUI).call(this, editor.propertiesToUpdate);
    tools_assertClassBrand(_AnnotationEditorUIManager_brand, this, _dispatchUpdateStates).call(this, {
      hasSelectedEditor: true
    });
  }
  setSelected(editor) {
    tools_classPrivateFieldGet(_currentDrawingSession, this)?.commitOrRemove();
    for (const ed of tools_classPrivateFieldGet(_selectedEditors, this)) {
      if (ed !== editor) {
        ed.unselect();
      }
    }
    tools_classPrivateFieldGet(_selectedEditors, this).clear();
    tools_classPrivateFieldGet(_selectedEditors, this).add(editor);
    editor.select();
    tools_assertClassBrand(_AnnotationEditorUIManager_brand, this, _dispatchUpdateUI).call(this, editor.propertiesToUpdate);
    tools_assertClassBrand(_AnnotationEditorUIManager_brand, this, _dispatchUpdateStates).call(this, {
      hasSelectedEditor: true
    });
  }
  isSelected(editor) {
    return tools_classPrivateFieldGet(_selectedEditors, this).has(editor);
  }
  get firstSelectedEditor() {
    return tools_classPrivateFieldGet(_selectedEditors, this).values().next().value;
  }
  unselect(editor) {
    editor.unselect();
    tools_classPrivateFieldGet(_selectedEditors, this).delete(editor);
    tools_assertClassBrand(_AnnotationEditorUIManager_brand, this, _dispatchUpdateStates).call(this, {
      hasSelectedEditor: this.hasSelection
    });
  }
  get hasSelection() {
    return tools_classPrivateFieldGet(_selectedEditors, this).size !== 0;
  }
  get isEnterHandled() {
    return tools_classPrivateFieldGet(_selectedEditors, this).size === 1 && this.firstSelectedEditor.isEnterHandled;
  }
  undo() {
    tools_classPrivateFieldGet(_commandManager, this).undo();
    tools_assertClassBrand(_AnnotationEditorUIManager_brand, this, _dispatchUpdateStates).call(this, {
      hasSomethingToUndo: tools_classPrivateFieldGet(_commandManager, this).hasSomethingToUndo(),
      hasSomethingToRedo: true,
      isEmpty: tools_assertClassBrand(_AnnotationEditorUIManager_brand, this, _isEmpty).call(this)
    });
    this._editorUndoBar?.hide();
  }
  redo() {
    tools_classPrivateFieldGet(_commandManager, this).redo();
    tools_assertClassBrand(_AnnotationEditorUIManager_brand, this, _dispatchUpdateStates).call(this, {
      hasSomethingToUndo: true,
      hasSomethingToRedo: tools_classPrivateFieldGet(_commandManager, this).hasSomethingToRedo(),
      isEmpty: tools_assertClassBrand(_AnnotationEditorUIManager_brand, this, _isEmpty).call(this)
    });
  }
  addCommands(params) {
    tools_classPrivateFieldGet(_commandManager, this).add(params);
    tools_assertClassBrand(_AnnotationEditorUIManager_brand, this, _dispatchUpdateStates).call(this, {
      hasSomethingToUndo: true,
      hasSomethingToRedo: false,
      isEmpty: tools_assertClassBrand(_AnnotationEditorUIManager_brand, this, _isEmpty).call(this)
    });
  }
  cleanUndoStack(type) {
    tools_classPrivateFieldGet(_commandManager, this).cleanType(type);
  }
  delete() {
    this.commitOrRemove();
    const drawingEditor = this.currentLayer?.endDrawingSession(true);
    if (!this.hasSelection && !drawingEditor) {
      return;
    }
    const editors = drawingEditor ? [drawingEditor] : [...tools_classPrivateFieldGet(_selectedEditors, this)];
    const cmd = () => {
      this._editorUndoBar?.show(undo, editors.length === 1 ? editors[0].editorType : editors.length);
      for (const editor of editors) {
        editor.remove();
      }
    };
    const undo = () => {
      for (const editor of editors) {
        tools_assertClassBrand(_AnnotationEditorUIManager_brand, this, _addEditorToLayer).call(this, editor);
      }
    };
    this.addCommands({
      cmd,
      undo,
      mustExec: true
    });
  }
  commitOrRemove() {
    tools_classPrivateFieldGet(_activeEditor, this)?.commitOrRemove();
  }
  hasSomethingToControl() {
    return tools_classPrivateFieldGet(_activeEditor, this) || this.hasSelection;
  }
  selectAll() {
    for (const editor of tools_classPrivateFieldGet(_selectedEditors, this)) {
      editor.commit();
    }
    tools_assertClassBrand(_AnnotationEditorUIManager_brand, this, _selectEditors).call(this, tools_classPrivateFieldGet(_allEditors, this).values());
  }
  unselectAll() {
    if (tools_classPrivateFieldGet(_activeEditor, this)) {
      tools_classPrivateFieldGet(_activeEditor, this).commitOrRemove();
      if (tools_classPrivateFieldGet(_mode, this) !== AnnotationEditorType.NONE) {
        return;
      }
    }
    if (tools_classPrivateFieldGet(_currentDrawingSession, this)?.commitOrRemove()) {
      return;
    }
    if (!this.hasSelection) {
      return;
    }
    for (const editor of tools_classPrivateFieldGet(_selectedEditors, this)) {
      editor.unselect();
    }
    tools_classPrivateFieldGet(_selectedEditors, this).clear();
    tools_assertClassBrand(_AnnotationEditorUIManager_brand, this, _dispatchUpdateStates).call(this, {
      hasSelectedEditor: false
    });
  }
  translateSelectedEditors(x, y) {
    let noCommit = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
    if (!noCommit) {
      this.commitOrRemove();
    }
    if (!this.hasSelection) {
      return;
    }
    tools_classPrivateFieldGet(_translation, this)[0] += x;
    tools_classPrivateFieldGet(_translation, this)[1] += y;
    const [totalX, totalY] = tools_classPrivateFieldGet(_translation, this);
    const editors = [...tools_classPrivateFieldGet(_selectedEditors, this)];
    const TIME_TO_WAIT = 1000;
    if (tools_classPrivateFieldGet(_translationTimeoutId, this)) {
      clearTimeout(tools_classPrivateFieldGet(_translationTimeoutId, this));
    }
    tools_classPrivateFieldSet(_translationTimeoutId, this, setTimeout(() => {
      tools_classPrivateFieldSet(_translationTimeoutId, this, null);
      tools_classPrivateFieldGet(_translation, this)[0] = tools_classPrivateFieldGet(_translation, this)[1] = 0;
      this.addCommands({
        cmd: () => {
          for (const editor of editors) {
            if (tools_classPrivateFieldGet(_allEditors, this).has(editor.id)) {
              editor.translateInPage(totalX, totalY);
              editor.translationDone();
            }
          }
        },
        undo: () => {
          for (const editor of editors) {
            if (tools_classPrivateFieldGet(_allEditors, this).has(editor.id)) {
              editor.translateInPage(-totalX, -totalY);
              editor.translationDone();
            }
          }
        },
        mustExec: false
      });
    }, TIME_TO_WAIT));
    for (const editor of editors) {
      editor.translateInPage(x, y);
      editor.translationDone();
    }
  }
  setUpDragSession() {
    if (!this.hasSelection) {
      return;
    }
    this.disableUserSelect(true);
    tools_classPrivateFieldSet(_draggingEditors, this, new Map());
    for (const editor of tools_classPrivateFieldGet(_selectedEditors, this)) {
      tools_classPrivateFieldGet(_draggingEditors, this).set(editor, {
        savedX: editor.x,
        savedY: editor.y,
        savedPageIndex: editor.pageIndex,
        newX: 0,
        newY: 0,
        newPageIndex: -1
      });
    }
  }
  endDragSession() {
    if (!tools_classPrivateFieldGet(_draggingEditors, this)) {
      return false;
    }
    this.disableUserSelect(false);
    const map = tools_classPrivateFieldGet(_draggingEditors, this);
    tools_classPrivateFieldSet(_draggingEditors, this, null);
    let mustBeAddedInUndoStack = false;
    for (const [{
      x,
      y,
      pageIndex
    }, value] of map) {
      value.newX = x;
      value.newY = y;
      value.newPageIndex = pageIndex;
      mustBeAddedInUndoStack ||= x !== value.savedX || y !== value.savedY || pageIndex !== value.savedPageIndex;
    }
    if (!mustBeAddedInUndoStack) {
      return false;
    }
    const move = (editor, x, y, pageIndex) => {
      if (tools_classPrivateFieldGet(_allEditors, this).has(editor.id)) {
        const parent = tools_classPrivateFieldGet(_allLayers, this).get(pageIndex);
        if (parent) {
          editor._setParentAndPosition(parent, x, y);
        } else {
          editor.pageIndex = pageIndex;
          editor.x = x;
          editor.y = y;
        }
      }
    };
    this.addCommands({
      cmd: () => {
        for (const [editor, {
          newX,
          newY,
          newPageIndex,
          savedX,
          savedY,
          savedPageIndex
        }] of map) {
          move(editor, newX, newY, newPageIndex);
          this._eventBus?.dispatch("annotation-editor-event", {
            source: editor,
            type: "moved",
            page: newPageIndex + 1,
            editorType: editor.constructor.name,
            previousValue: {
              x: savedX,
              y: savedY,
              page: savedPageIndex + 1
            },
            value: {
              x: newX,
              y: newY,
              page: newPageIndex + 1
            }
          });
        }
      },
      undo: () => {
        for (const [editor, {
          savedX,
          savedY,
          savedPageIndex
        }] of map) {
          move(editor, savedX, savedY, savedPageIndex);
        }
      },
      mustExec: true
    });
    return true;
  }
  dragSelectedEditors(tx, ty) {
    if (!tools_classPrivateFieldGet(_draggingEditors, this)) {
      return;
    }
    for (const editor of tools_classPrivateFieldGet(_draggingEditors, this).keys()) {
      editor.drag(tx, ty);
    }
  }
  rebuild(editor) {
    if (editor.parent === null) {
      const parent = this.getLayer(editor.pageIndex);
      if (parent) {
        parent.changeParent(editor);
        parent.addOrRebuild(editor);
      } else {
        this.addEditor(editor);
        this.addToAnnotationStorage(editor);
        editor.rebuild();
      }
    } else {
      editor.parent.addOrRebuild(editor);
    }
  }
  get isEditorHandlingKeyboard() {
    return this.getActive()?.shouldGetKeyboardEvents() || tools_classPrivateFieldGet(_selectedEditors, this).size === 1 && this.firstSelectedEditor.shouldGetKeyboardEvents();
  }
  isActive(editor) {
    return tools_classPrivateFieldGet(_activeEditor, this) === editor;
  }
  getActive() {
    return tools_classPrivateFieldGet(_activeEditor, this);
  }
  getMode() {
    return tools_classPrivateFieldGet(_mode, this);
  }
  get imageManager() {
    return shadow(this, "imageManager", new ImageManager());
  }
  removeEditors() {
    let filterFunction = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : () => true;
    let hasChanged = false;
    tools_classPrivateFieldGet(_allEditors, this).forEach(editor => {
      if (editor?.serialize()) {
        if (filterFunction(editor.serialize())) {
          editor.remove();
          hasChanged = true;
        }
      }
    });
    if (hasChanged) {
      tools_assertClassBrand(_AnnotationEditorUIManager_brand, this, _dispatchUpdateStates).call(this, {
        hasSomethingToUndo: false,
        hasSomethingToRedo: false,
        isEmpty: tools_assertClassBrand(_AnnotationEditorUIManager_brand, this, _isEmpty).call(this)
      });
      tools_classPrivateFieldGet(_commandManager, this).reset();
    }
  }
  getSelectionBoxes(textLayer) {
    if (!textLayer) {
      return null;
    }
    const selection = document.getSelection();
    for (let i = 0, ii = selection.rangeCount; i < ii; i++) {
      if (!textLayer.contains(selection.getRangeAt(i).commonAncestorContainer)) {
        return null;
      }
    }
    const {
      x: layerX,
      y: layerY,
      width: parentWidth,
      height: parentHeight
    } = textLayer.getBoundingClientRect();
    let rotator;
    switch (textLayer.getAttribute("data-main-rotation")) {
      case "90":
        rotator = (x, y, w, h) => ({
          x: (y - layerY) / parentHeight,
          y: 1 - (x + w - layerX) / parentWidth,
          width: h / parentHeight,
          height: w / parentWidth
        });
        break;
      case "180":
        rotator = (x, y, w, h) => ({
          x: 1 - (x + w - layerX) / parentWidth,
          y: 1 - (y + h - layerY) / parentHeight,
          width: w / parentWidth,
          height: h / parentHeight
        });
        break;
      case "270":
        rotator = (x, y, w, h) => ({
          x: 1 - (y + h - layerY) / parentHeight,
          y: (x - layerX) / parentWidth,
          width: h / parentHeight,
          height: w / parentWidth
        });
        break;
      default:
        rotator = (x, y, w, h) => ({
          x: (x - layerX) / parentWidth,
          y: (y - layerY) / parentHeight,
          width: w / parentWidth,
          height: h / parentHeight
        });
        break;
    }
    const boxes = [];
    for (let i = 0, ii = selection.rangeCount; i < ii; i++) {
      const range = selection.getRangeAt(i);
      if (range.collapsed) {
        continue;
      }
      for (const {
        x,
        y,
        width,
        height
      } of range.getClientRects()) {
        if (width === 0 || height === 0) {
          continue;
        }
        boxes.push(rotator(x, y, width, height));
      }
    }
    return boxes.length === 0 ? null : boxes;
  }
  addChangedExistingAnnotation(_ref0) {
    let {
      annotationElementId,
      id
    } = _ref0;
    (tools_classPrivateFieldGet(_changedExistingAnnotations, this) || tools_classPrivateFieldSet(_changedExistingAnnotations, this, new Map())).set(annotationElementId, id);
  }
  removeChangedExistingAnnotation(_ref1) {
    let {
      annotationElementId
    } = _ref1;
    tools_classPrivateFieldGet(_changedExistingAnnotations, this)?.delete(annotationElementId);
  }
  renderAnnotationElement(annotation) {
    const editorId = tools_classPrivateFieldGet(_changedExistingAnnotations, this)?.get(annotation.data.id);
    if (!editorId) {
      return;
    }
    const editor = tools_classPrivateFieldGet(_annotationStorage, this).getRawValue(editorId);
    if (!editor) {
      return;
    }
    if (tools_classPrivateFieldGet(_mode, this) === AnnotationEditorType.NONE && !editor.hasBeenModified) {
      return;
    }
    editor.renderAnnotationElement(annotation);
  }
  setMissingCanvas(annotationId, annotationElementId, canvas) {
    const editor = tools_classPrivateFieldGet(_missingCanvases, this)?.get(annotationId);
    if (!editor) {
      return;
    }
    editor.setCanvas(annotationElementId, canvas);
    tools_classPrivateFieldGet(_missingCanvases, this).delete(annotationId);
  }
  addMissingCanvas(annotationId, editor) {
    (tools_classPrivateFieldGet(_missingCanvases, this) || tools_classPrivateFieldSet(_missingCanvases, this, new Map())).set(annotationId, editor);
  }
}
function _getAnchorElementForSelection(_ref10) {
  let {
    anchorNode
  } = _ref10;
  return anchorNode.nodeType === Node.TEXT_NODE ? anchorNode.parentElement : anchorNode;
}
function _getLayerForTextLayer(textLayer) {
  const {
    currentLayer
  } = this;
  if (currentLayer.hasTextLayer(textLayer)) {
    return currentLayer;
  }
  for (const layer of tools_classPrivateFieldGet(_allLayers, this).values()) {
    if (layer.hasTextLayer(textLayer)) {
      return layer;
    }
  }
  return null;
}
function _displayHighlightToolbar() {
  const selection = document.getSelection();
  if (!selection || selection.isCollapsed) {
    return;
  }
  const anchorElement = tools_assertClassBrand(_AnnotationEditorUIManager_brand, this, _getAnchorElementForSelection).call(this, selection);
  const textLayer = anchorElement.closest(".textLayer");
  const boxes = this.getSelectionBoxes(textLayer);
  if (!boxes) {
    return;
  }
  tools_classPrivateFieldGet(_highlightToolbar, this) || tools_classPrivateFieldSet(_highlightToolbar, this, new HighlightToolbar(this));
  tools_classPrivateFieldGet(_highlightToolbar, this).show(textLayer, boxes, this.direction === "ltr");
}
function _selectionChange() {
  const selection = document.getSelection();
  if (!selection || selection.isCollapsed) {
    if (tools_classPrivateFieldGet(_selectedTextNode, this)) {
      tools_classPrivateFieldGet(_highlightToolbar, this)?.hide();
      tools_classPrivateFieldSet(_selectedTextNode, this, null);
      tools_assertClassBrand(_AnnotationEditorUIManager_brand, this, _dispatchUpdateStates).call(this, {
        hasSelectedText: false
      });
    }
    return;
  }
  const {
    anchorNode
  } = selection;
  if (anchorNode === tools_classPrivateFieldGet(_selectedTextNode, this)) {
    return;
  }
  const anchorElement = tools_assertClassBrand(_AnnotationEditorUIManager_brand, this, _getAnchorElementForSelection).call(this, selection);
  const textLayer = anchorElement.closest(".textLayer");
  if (!textLayer) {
    if (tools_classPrivateFieldGet(_selectedTextNode, this)) {
      tools_classPrivateFieldGet(_highlightToolbar, this)?.hide();
      tools_classPrivateFieldSet(_selectedTextNode, this, null);
      tools_assertClassBrand(_AnnotationEditorUIManager_brand, this, _dispatchUpdateStates).call(this, {
        hasSelectedText: false
      });
    }
    return;
  }
  tools_classPrivateFieldGet(_highlightToolbar, this)?.hide();
  tools_classPrivateFieldSet(_selectedTextNode, this, anchorNode);
  tools_assertClassBrand(_AnnotationEditorUIManager_brand, this, _dispatchUpdateStates).call(this, {
    hasSelectedText: true
  });
  if (tools_classPrivateFieldGet(_mode, this) !== AnnotationEditorType.HIGHLIGHT && tools_classPrivateFieldGet(_mode, this) !== AnnotationEditorType.NONE) {
    return;
  }
  if (tools_classPrivateFieldGet(_mode, this) === AnnotationEditorType.HIGHLIGHT) {
    this.showAllEditors("highlight", true, true);
  }
  tools_classPrivateFieldSet(_highlightWhenShiftUp, this, this.isShiftKeyDown);
  if (!this.isShiftKeyDown) {
    const activeLayer = tools_classPrivateFieldGet(_mode, this) === AnnotationEditorType.HIGHLIGHT ? tools_assertClassBrand(_AnnotationEditorUIManager_brand, this, _getLayerForTextLayer).call(this, textLayer) : null;
    activeLayer?.toggleDrawing();
    const ac = new AbortController();
    const signal = this.combinedSignal(ac);
    const pointerup = e => {
      if (e.type === "pointerup" && e.button !== 0) {
        return;
      }
      ac.abort();
      activeLayer?.toggleDrawing(true);
      if (e.type === "pointerup") {
        tools_assertClassBrand(_AnnotationEditorUIManager_brand, this, _onSelectEnd).call(this, "main_toolbar");
      }
    };
    window.addEventListener("pointerup", pointerup, {
      signal
    });
    window.addEventListener("blur", pointerup, {
      signal
    });
  }
}
function _onSelectEnd() {
  let methodOfCreation = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : "";
  if (tools_classPrivateFieldGet(_mode, this) === AnnotationEditorType.HIGHLIGHT) {
    this.highlightSelection(methodOfCreation);
  } else if (tools_classPrivateFieldGet(_enableHighlightFloatingButton, this)) {
    tools_assertClassBrand(_AnnotationEditorUIManager_brand, this, _displayHighlightToolbar).call(this);
  }
}
function _addSelectionListener() {
  document.addEventListener("selectionchange", tools_assertClassBrand(_AnnotationEditorUIManager_brand, this, _selectionChange).bind(this), {
    signal: this._signal
  });
}
function _addFocusManager() {
  if (tools_classPrivateFieldGet(_focusManagerAC, this)) {
    return;
  }
  tools_classPrivateFieldSet(_focusManagerAC, this, new AbortController());
  const signal = this.combinedSignal(tools_classPrivateFieldGet(_focusManagerAC, this));
  window.addEventListener("focus", this.focus.bind(this), {
    signal
  });
  window.addEventListener("blur", this.blur.bind(this), {
    signal
  });
}
function _removeFocusManager() {
  tools_classPrivateFieldGet(_focusManagerAC, this)?.abort();
  tools_classPrivateFieldSet(_focusManagerAC, this, null);
}
function _addKeyboardManager() {
  if (tools_classPrivateFieldGet(_keyboardManagerAC, this)) {
    return;
  }
  tools_classPrivateFieldSet(_keyboardManagerAC, this, new AbortController());
  const signal = this.combinedSignal(tools_classPrivateFieldGet(_keyboardManagerAC, this));
  window.addEventListener("keydown", this.keydown.bind(this), {
    signal
  });
  window.addEventListener("keyup", this.keyup.bind(this), {
    signal
  });
}
function _removeKeyboardManager() {
  tools_classPrivateFieldGet(_keyboardManagerAC, this)?.abort();
  tools_classPrivateFieldSet(_keyboardManagerAC, this, null);
}
function _addCopyPasteListeners() {
  if (tools_classPrivateFieldGet(_copyPasteAC, this)) {
    return;
  }
  tools_classPrivateFieldSet(_copyPasteAC, this, new AbortController());
  const signal = this.combinedSignal(tools_classPrivateFieldGet(_copyPasteAC, this));
  document.addEventListener("copy", this.copy.bind(this), {
    signal
  });
  document.addEventListener("cut", this.cut.bind(this), {
    signal
  });
  document.addEventListener("paste", this.paste.bind(this), {
    signal
  });
}
function _removeCopyPasteListeners() {
  tools_classPrivateFieldGet(_copyPasteAC, this)?.abort();
  tools_classPrivateFieldSet(_copyPasteAC, this, null);
}
function _addDragAndDropListeners() {
  const signal = this._signal;
  document.addEventListener("dragover", this.dragOver.bind(this), {
    signal
  });
  document.addEventListener("drop", this.drop.bind(this), {
    signal
  });
}
function _dispatchUpdateStates(details) {
  const hasChanged = Object.entries(details).some(_ref11 => {
    let [key, value] = _ref11;
    return tools_classPrivateFieldGet(_previousStates, this)[key] !== value;
  });
  if (hasChanged) {
    this._eventBus.dispatch("annotationeditorstateschanged", {
      source: this,
      details: Object.assign(tools_classPrivateFieldGet(_previousStates, this), details)
    });
    if (tools_classPrivateFieldGet(_mode, this) === AnnotationEditorType.HIGHLIGHT && details.hasSelectedEditor === false) {
      tools_assertClassBrand(_AnnotationEditorUIManager_brand, this, _dispatchUpdateUI).call(this, [[AnnotationEditorParamsType.HIGHLIGHT_FREE, true]]);
    }
  }
}
function _dispatchUpdateUI(details) {
  this._eventBus.dispatch("annotationeditorparamschanged", {
    source: this,
    details
  });
}
async function _enableAll() {
  if (!tools_classPrivateFieldGet(_isEnabled, this)) {
    tools_classPrivateFieldSet(_isEnabled, this, true);
    const promises = [];
    for (const layer of tools_classPrivateFieldGet(_allLayers, this).values()) {
      promises.push(layer.enable());
    }
    await Promise.all(promises);
    for (const editor of tools_classPrivateFieldGet(_allEditors, this).values()) {
      editor.enable();
    }
  }
}
function _disableAll() {
  this.unselectAll();
  if (tools_classPrivateFieldGet(_isEnabled, this)) {
    tools_classPrivateFieldSet(_isEnabled, this, false);
    for (const layer of tools_classPrivateFieldGet(_allLayers, this).values()) {
      layer.disable();
    }
    for (const editor of tools_classPrivateFieldGet(_allEditors, this).values()) {
      editor.disable();
    }
  }
}
function _addEditorToLayer(editor) {
  const layer = tools_classPrivateFieldGet(_allLayers, this).get(editor.pageIndex);
  if (layer) {
    layer.addOrRebuild(editor);
  } else {
    this.addEditor(editor);
    this.addToAnnotationStorage(editor);
  }
}
function _get_lastSelectedEditor(_this) {
  let ed = null;
  for (ed of tools_classPrivateFieldGet(_selectedEditors, _this)) {}
  return ed;
}
function _isEmpty() {
  if (tools_classPrivateFieldGet(_allEditors, this).size === 0) {
    return true;
  }
  if (tools_classPrivateFieldGet(_allEditors, this).size === 1) {
    for (const editor of tools_classPrivateFieldGet(_allEditors, this).values()) {
      return editor.isEmpty();
    }
  }
  return false;
}
function _selectEditors(editors) {
  for (const editor of tools_classPrivateFieldGet(_selectedEditors, this)) {
    editor.unselect();
  }
  tools_classPrivateFieldGet(_selectedEditors, this).clear();
  for (const editor of editors) {
    if (editor.isEmpty()) {
      continue;
    }
    tools_classPrivateFieldGet(_selectedEditors, this).add(editor);
    editor.select();
  }
  tools_assertClassBrand(_AnnotationEditorUIManager_brand, this, _dispatchUpdateStates).call(this, {
    hasSelectedEditor: this.hasSelection
  });
}
tools_defineProperty(AnnotationEditorUIManager, "TRANSLATE_SMALL", 1);
tools_defineProperty(AnnotationEditorUIManager, "TRANSLATE_BIG", 10);

;// ./src/display/editor/alt_text.js

function alt_text_classPrivateMethodInitSpec(e, a) { alt_text_checkPrivateRedeclaration(e, a), a.add(e); }
function alt_text_defineProperty(e, r, t) { return (r = alt_text_toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function alt_text_toPropertyKey(t) { var i = alt_text_toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function alt_text_toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function alt_text_classPrivateFieldInitSpec(e, t, a) { alt_text_checkPrivateRedeclaration(e, t), t.set(e, a); }
function alt_text_checkPrivateRedeclaration(e, t) { if (t.has(e)) throw new TypeError("Cannot initialize the same private elements twice on an object"); }
function alt_text_classPrivateGetter(s, r, a) { return a(alt_text_assertClassBrand(s, r)); }
function alt_text_classPrivateFieldGet(s, a) { return s.get(alt_text_assertClassBrand(s, a)); }
function alt_text_classPrivateFieldSet(s, a, r) { return s.set(alt_text_assertClassBrand(s, a), r), r; }
function alt_text_assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); }

var alt_text_altText = /*#__PURE__*/new WeakMap();
var _altTextDecorative = /*#__PURE__*/new WeakMap();
var _altTextButton = /*#__PURE__*/new WeakMap();
var _altTextButtonLabel = /*#__PURE__*/new WeakMap();
var _altTextTooltip = /*#__PURE__*/new WeakMap();
var _altTextTooltipTimeout = /*#__PURE__*/new WeakMap();
var _altTextWasFromKeyBoard = /*#__PURE__*/new WeakMap();
var _badge = /*#__PURE__*/new WeakMap();
var alt_text_editor = /*#__PURE__*/new WeakMap();
var _guessedText = /*#__PURE__*/new WeakMap();
var _textWithDisclaimer = /*#__PURE__*/new WeakMap();
var _useNewAltTextFlow = /*#__PURE__*/new WeakMap();
var _AltText_brand = /*#__PURE__*/new WeakSet();
class AltText {
  constructor(editor) {
    alt_text_classPrivateMethodInitSpec(this, _AltText_brand);
    alt_text_classPrivateFieldInitSpec(this, alt_text_altText, null);
    alt_text_classPrivateFieldInitSpec(this, _altTextDecorative, false);
    alt_text_classPrivateFieldInitSpec(this, _altTextButton, null);
    alt_text_classPrivateFieldInitSpec(this, _altTextButtonLabel, null);
    alt_text_classPrivateFieldInitSpec(this, _altTextTooltip, null);
    alt_text_classPrivateFieldInitSpec(this, _altTextTooltipTimeout, null);
    alt_text_classPrivateFieldInitSpec(this, _altTextWasFromKeyBoard, false);
    alt_text_classPrivateFieldInitSpec(this, _badge, null);
    alt_text_classPrivateFieldInitSpec(this, alt_text_editor, null);
    alt_text_classPrivateFieldInitSpec(this, _guessedText, null);
    alt_text_classPrivateFieldInitSpec(this, _textWithDisclaimer, null);
    alt_text_classPrivateFieldInitSpec(this, _useNewAltTextFlow, false);
    alt_text_classPrivateFieldSet(alt_text_editor, this, editor);
    alt_text_classPrivateFieldSet(_useNewAltTextFlow, this, editor._uiManager.useNewAltTextFlow);
    _l10nNewButton._ || (_l10nNewButton._ = Object.freeze({
      added: "pdfjs-editor-new-alt-text-added-button",
      "added-label": "pdfjs-editor-new-alt-text-added-button-label",
      missing: "pdfjs-editor-new-alt-text-missing-button",
      "missing-label": "pdfjs-editor-new-alt-text-missing-button-label",
      review: "pdfjs-editor-new-alt-text-to-review-button",
      "review-label": "pdfjs-editor-new-alt-text-to-review-button-label"
    }));
  }
  static initialize(l10n) {
    AltText._l10n ??= l10n;
  }
  async render() {
    const altText = alt_text_classPrivateFieldSet(_altTextButton, this, document.createElement("button"));
    altText.className = "altText";
    altText.tabIndex = "0";
    const label = alt_text_classPrivateFieldSet(_altTextButtonLabel, this, document.createElement("span"));
    altText.append(label);
    if (alt_text_classPrivateFieldGet(_useNewAltTextFlow, this)) {
      altText.classList.add("new");
      altText.setAttribute("data-l10n-id", _l10nNewButton._.missing);
      label.setAttribute("data-l10n-id", _l10nNewButton._["missing-label"]);
    } else {
      altText.setAttribute("data-l10n-id", "pdfjs-editor-alt-text-button");
      label.setAttribute("data-l10n-id", "pdfjs-editor-alt-text-button-label");
    }
    const signal = alt_text_classPrivateFieldGet(alt_text_editor, this)._uiManager._signal;
    altText.addEventListener("contextmenu", noContextMenu, {
      signal
    });
    altText.addEventListener("pointerdown", event => event.stopPropagation(), {
      signal
    });
    const onClick = event => {
      event.preventDefault();
      alt_text_classPrivateFieldGet(alt_text_editor, this)._uiManager.editAltText(alt_text_classPrivateFieldGet(alt_text_editor, this));
      if (alt_text_classPrivateFieldGet(_useNewAltTextFlow, this)) {
        alt_text_classPrivateFieldGet(alt_text_editor, this)._reportTelemetry({
          action: "pdfjs.image.alt_text.image_status_label_clicked",
          data: {
            label: alt_text_classPrivateGetter(_AltText_brand, this, _get_label)
          }
        });
      }
    };
    altText.addEventListener("click", onClick, {
      capture: true,
      signal
    });
    altText.addEventListener("keydown", event => {
      if (event.target === altText && event.key === "Enter") {
        alt_text_classPrivateFieldSet(_altTextWasFromKeyBoard, this, true);
        onClick(event);
      }
    }, {
      signal
    });
    await alt_text_assertClassBrand(_AltText_brand, this, _setState).call(this);
    return altText;
  }
  finish() {
    if (!alt_text_classPrivateFieldGet(_altTextButton, this)) {
      return;
    }
    alt_text_classPrivateFieldGet(_altTextButton, this).focus({
      focusVisible: alt_text_classPrivateFieldGet(_altTextWasFromKeyBoard, this)
    });
    alt_text_classPrivateFieldSet(_altTextWasFromKeyBoard, this, false);
  }
  isEmpty() {
    if (alt_text_classPrivateFieldGet(_useNewAltTextFlow, this)) {
      return alt_text_classPrivateFieldGet(alt_text_altText, this) === null;
    }
    return !alt_text_classPrivateFieldGet(alt_text_altText, this) && !alt_text_classPrivateFieldGet(_altTextDecorative, this);
  }
  hasData() {
    if (alt_text_classPrivateFieldGet(_useNewAltTextFlow, this)) {
      return alt_text_classPrivateFieldGet(alt_text_altText, this) !== null || !!alt_text_classPrivateFieldGet(_guessedText, this);
    }
    return this.isEmpty();
  }
  get guessedText() {
    return alt_text_classPrivateFieldGet(_guessedText, this);
  }
  async setGuessedText(guessedText) {
    if (alt_text_classPrivateFieldGet(alt_text_altText, this) !== null) {
      return;
    }
    alt_text_classPrivateFieldSet(_guessedText, this, guessedText);
    alt_text_classPrivateFieldSet(_textWithDisclaimer, this, await AltText._l10n.get("pdfjs-editor-new-alt-text-generated-alt-text-with-disclaimer", {
      generatedAltText: guessedText
    }));
    alt_text_assertClassBrand(_AltText_brand, this, _setState).call(this);
  }
  toggleAltTextBadge() {
    let visibility = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
    if (!alt_text_classPrivateFieldGet(_useNewAltTextFlow, this) || alt_text_classPrivateFieldGet(alt_text_altText, this)) {
      alt_text_classPrivateFieldGet(_badge, this)?.remove();
      alt_text_classPrivateFieldSet(_badge, this, null);
      return;
    }
    if (!alt_text_classPrivateFieldGet(_badge, this)) {
      const badge = alt_text_classPrivateFieldSet(_badge, this, document.createElement("div"));
      badge.className = "noAltTextBadge";
      alt_text_classPrivateFieldGet(alt_text_editor, this).div.append(badge);
    }
    alt_text_classPrivateFieldGet(_badge, this).classList.toggle("hidden", !visibility);
  }
  serialize(isForCopying) {
    let altText = alt_text_classPrivateFieldGet(alt_text_altText, this);
    if (!isForCopying && alt_text_classPrivateFieldGet(_guessedText, this) === altText) {
      altText = alt_text_classPrivateFieldGet(_textWithDisclaimer, this);
    }
    return {
      altText,
      decorative: alt_text_classPrivateFieldGet(_altTextDecorative, this),
      guessedText: alt_text_classPrivateFieldGet(_guessedText, this),
      textWithDisclaimer: alt_text_classPrivateFieldGet(_textWithDisclaimer, this)
    };
  }
  get data() {
    return {
      altText: alt_text_classPrivateFieldGet(alt_text_altText, this),
      decorative: alt_text_classPrivateFieldGet(_altTextDecorative, this)
    };
  }
  set data(_ref) {
    let {
      altText,
      decorative,
      guessedText,
      textWithDisclaimer,
      cancel = false
    } = _ref;
    if (guessedText) {
      alt_text_classPrivateFieldSet(_guessedText, this, guessedText);
      alt_text_classPrivateFieldSet(_textWithDisclaimer, this, textWithDisclaimer);
    }
    if (alt_text_classPrivateFieldGet(alt_text_altText, this) === altText && alt_text_classPrivateFieldGet(_altTextDecorative, this) === decorative) {
      return;
    }
    if (!cancel) {
      alt_text_classPrivateFieldSet(alt_text_altText, this, altText);
      alt_text_classPrivateFieldSet(_altTextDecorative, this, decorative);
    }
    alt_text_assertClassBrand(_AltText_brand, this, _setState).call(this);
  }
  toggle() {
    let enabled = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
    if (!alt_text_classPrivateFieldGet(_altTextButton, this)) {
      return;
    }
    if (!enabled && alt_text_classPrivateFieldGet(_altTextTooltipTimeout, this)) {
      clearTimeout(alt_text_classPrivateFieldGet(_altTextTooltipTimeout, this));
      alt_text_classPrivateFieldSet(_altTextTooltipTimeout, this, null);
    }
    alt_text_classPrivateFieldGet(_altTextButton, this).disabled = !enabled;
  }
  shown() {
    alt_text_classPrivateFieldGet(alt_text_editor, this)._reportTelemetry({
      action: "pdfjs.image.alt_text.image_status_label_displayed",
      data: {
        label: alt_text_classPrivateGetter(_AltText_brand, this, _get_label)
      }
    });
  }
  destroy() {
    alt_text_classPrivateFieldGet(_altTextButton, this)?.remove();
    alt_text_classPrivateFieldSet(_altTextButton, this, null);
    alt_text_classPrivateFieldSet(_altTextButtonLabel, this, null);
    alt_text_classPrivateFieldSet(_altTextTooltip, this, null);
    alt_text_classPrivateFieldGet(_badge, this)?.remove();
    alt_text_classPrivateFieldSet(_badge, this, null);
  }
}
function _get_label(_this) {
  return alt_text_classPrivateFieldGet(alt_text_altText, _this) && "added" || alt_text_classPrivateFieldGet(alt_text_altText, _this) === null && _this.guessedText && "review" || "missing";
}
async function _setState() {
  const button = alt_text_classPrivateFieldGet(_altTextButton, this);
  if (!button) {
    return;
  }
  if (alt_text_classPrivateFieldGet(_useNewAltTextFlow, this)) {
    button.classList.toggle("done", !!alt_text_classPrivateFieldGet(alt_text_altText, this));
    button.setAttribute("data-l10n-id", _l10nNewButton._[alt_text_classPrivateGetter(_AltText_brand, this, _get_label)]);
    alt_text_classPrivateFieldGet(_altTextButtonLabel, this)?.setAttribute("data-l10n-id", _l10nNewButton._[`${alt_text_classPrivateGetter(_AltText_brand, this, _get_label)}-label`]);
    if (!alt_text_classPrivateFieldGet(alt_text_altText, this)) {
      alt_text_classPrivateFieldGet(_altTextTooltip, this)?.remove();
      return;
    }
  } else {
    if (!alt_text_classPrivateFieldGet(alt_text_altText, this) && !alt_text_classPrivateFieldGet(_altTextDecorative, this)) {
      button.classList.remove("done");
      alt_text_classPrivateFieldGet(_altTextTooltip, this)?.remove();
      return;
    }
    button.classList.add("done");
    button.setAttribute("data-l10n-id", "pdfjs-editor-alt-text-edit-button");
  }
  let tooltip = alt_text_classPrivateFieldGet(_altTextTooltip, this);
  if (!tooltip) {
    alt_text_classPrivateFieldSet(_altTextTooltip, this, tooltip = document.createElement("span"));
    tooltip.className = "tooltip";
    tooltip.setAttribute("role", "tooltip");
    tooltip.id = `alt-text-tooltip-${alt_text_classPrivateFieldGet(alt_text_editor, this).id}`;
    const DELAY_TO_SHOW_TOOLTIP = 100;
    const signal = alt_text_classPrivateFieldGet(alt_text_editor, this)._uiManager._signal;
    signal.addEventListener("abort", () => {
      clearTimeout(alt_text_classPrivateFieldGet(_altTextTooltipTimeout, this));
      alt_text_classPrivateFieldSet(_altTextTooltipTimeout, this, null);
    }, {
      once: true
    });
    button.addEventListener("mouseenter", () => {
      alt_text_classPrivateFieldSet(_altTextTooltipTimeout, this, setTimeout(() => {
        alt_text_classPrivateFieldSet(_altTextTooltipTimeout, this, null);
        alt_text_classPrivateFieldGet(_altTextTooltip, this).classList.add("show");
        alt_text_classPrivateFieldGet(alt_text_editor, this)._reportTelemetry({
          action: "alt_text_tooltip"
        });
      }, DELAY_TO_SHOW_TOOLTIP));
    }, {
      signal
    });
    button.addEventListener("mouseleave", () => {
      if (alt_text_classPrivateFieldGet(_altTextTooltipTimeout, this)) {
        clearTimeout(alt_text_classPrivateFieldGet(_altTextTooltipTimeout, this));
        alt_text_classPrivateFieldSet(_altTextTooltipTimeout, this, null);
      }
      alt_text_classPrivateFieldGet(_altTextTooltip, this)?.classList.remove("show");
    }, {
      signal
    });
  }
  if (alt_text_classPrivateFieldGet(_altTextDecorative, this)) {
    tooltip.setAttribute("data-l10n-id", "pdfjs-editor-alt-text-decorative-tooltip");
  } else {
    tooltip.removeAttribute("data-l10n-id");
    tooltip.textContent = alt_text_classPrivateFieldGet(alt_text_altText, this);
  }
  if (!tooltip.parentNode) {
    button.append(tooltip);
  }
  const element = alt_text_classPrivateFieldGet(alt_text_editor, this).getElementForAltText();
  element?.setAttribute("aria-describedby", tooltip.id);
}
var _l10nNewButton = {
  _: null
};
alt_text_defineProperty(AltText, "_l10n", null);

;// ./src/display/touch_manager.js
var _TouchManager;

function touch_manager_classPrivateMethodInitSpec(e, a) { touch_manager_checkPrivateRedeclaration(e, a), a.add(e); }
function touch_manager_classPrivateFieldInitSpec(e, t, a) { touch_manager_checkPrivateRedeclaration(e, t), t.set(e, a); }
function touch_manager_checkPrivateRedeclaration(e, t) { if (t.has(e)) throw new TypeError("Cannot initialize the same private elements twice on an object"); }
function touch_manager_classPrivateFieldGet(s, a) { return s.get(touch_manager_assertClassBrand(s, a)); }
function touch_manager_classPrivateFieldSet(s, a, r) { return s.set(touch_manager_assertClassBrand(s, a), r), r; }
function touch_manager_assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); }

var touch_manager_container = /*#__PURE__*/new WeakMap();
var _isPinching = /*#__PURE__*/new WeakMap();
var _isPinchingStopped = /*#__PURE__*/new WeakMap();
var _isPinchingDisabled = /*#__PURE__*/new WeakMap();
var _onPinchStart = /*#__PURE__*/new WeakMap();
var _onPinching = /*#__PURE__*/new WeakMap();
var _onPinchEnd = /*#__PURE__*/new WeakMap();
var _pointerDownAC = /*#__PURE__*/new WeakMap();
var _signal = /*#__PURE__*/new WeakMap();
var _touchInfo = /*#__PURE__*/new WeakMap();
var _touchManagerAC = /*#__PURE__*/new WeakMap();
var _touchMoveAC = /*#__PURE__*/new WeakMap();
var _TouchManager_brand = /*#__PURE__*/new WeakSet();
class TouchManager {
  constructor(_ref) {
    let {
      container: _container2,
      isPinchingDisabled = null,
      isPinchingStopped = null,
      onPinchStart = null,
      onPinching = null,
      onPinchEnd = null,
      signal: _signal2
    } = _ref;
    touch_manager_classPrivateMethodInitSpec(this, _TouchManager_brand);
    touch_manager_classPrivateFieldInitSpec(this, touch_manager_container, void 0);
    touch_manager_classPrivateFieldInitSpec(this, _isPinching, false);
    touch_manager_classPrivateFieldInitSpec(this, _isPinchingStopped, null);
    touch_manager_classPrivateFieldInitSpec(this, _isPinchingDisabled, void 0);
    touch_manager_classPrivateFieldInitSpec(this, _onPinchStart, void 0);
    touch_manager_classPrivateFieldInitSpec(this, _onPinching, void 0);
    touch_manager_classPrivateFieldInitSpec(this, _onPinchEnd, void 0);
    touch_manager_classPrivateFieldInitSpec(this, _pointerDownAC, null);
    touch_manager_classPrivateFieldInitSpec(this, _signal, void 0);
    touch_manager_classPrivateFieldInitSpec(this, _touchInfo, null);
    touch_manager_classPrivateFieldInitSpec(this, _touchManagerAC, void 0);
    touch_manager_classPrivateFieldInitSpec(this, _touchMoveAC, null);
    touch_manager_classPrivateFieldSet(touch_manager_container, this, _container2);
    touch_manager_classPrivateFieldSet(_isPinchingStopped, this, isPinchingStopped);
    touch_manager_classPrivateFieldSet(_isPinchingDisabled, this, isPinchingDisabled);
    touch_manager_classPrivateFieldSet(_onPinchStart, this, onPinchStart);
    touch_manager_classPrivateFieldSet(_onPinching, this, onPinching);
    touch_manager_classPrivateFieldSet(_onPinchEnd, this, onPinchEnd);
    touch_manager_classPrivateFieldSet(_touchManagerAC, this, new AbortController());
    touch_manager_classPrivateFieldSet(_signal, this, AbortSignal.any([_signal2, touch_manager_classPrivateFieldGet(_touchManagerAC, this).signal]));
    _container2.addEventListener("touchstart", touch_manager_assertClassBrand(_TouchManager_brand, this, _onTouchStart).bind(this), {
      passive: false,
      signal: touch_manager_classPrivateFieldGet(_signal, this)
    });
  }
  get MIN_TOUCH_DISTANCE_TO_PINCH() {
    return 35 / OutputScale.pixelRatio;
  }
  destroy() {
    touch_manager_classPrivateFieldGet(_touchManagerAC, this)?.abort();
    touch_manager_classPrivateFieldSet(_touchManagerAC, this, null);
    touch_manager_classPrivateFieldGet(_pointerDownAC, this)?.abort();
    touch_manager_classPrivateFieldSet(_pointerDownAC, this, null);
  }
}
_TouchManager = TouchManager;
function _onTouchStart(evt) {
  if (touch_manager_classPrivateFieldGet(_isPinchingDisabled, this)?.call(this)) {
    return;
  }
  if (evt.touches.length === 1) {
    if (touch_manager_classPrivateFieldGet(_pointerDownAC, this)) {
      return;
    }
    const pointerDownAC = touch_manager_classPrivateFieldSet(_pointerDownAC, this, new AbortController());
    const signal = AbortSignal.any([touch_manager_classPrivateFieldGet(_signal, this), pointerDownAC.signal]);
    const container = touch_manager_classPrivateFieldGet(touch_manager_container, this);
    const opts = {
      capture: true,
      signal,
      passive: false
    };
    const cancelPointerDown = e => {
      if (e.pointerType === "touch") {
        touch_manager_classPrivateFieldGet(_pointerDownAC, this)?.abort();
        touch_manager_classPrivateFieldSet(_pointerDownAC, this, null);
      }
    };
    container.addEventListener("pointerdown", e => {
      if (e.pointerType === "touch") {
        stopEvent(e);
        cancelPointerDown(e);
      }
    }, opts);
    container.addEventListener("pointerup", cancelPointerDown, opts);
    container.addEventListener("pointercancel", cancelPointerDown, opts);
    return;
  }
  if (!touch_manager_classPrivateFieldGet(_touchMoveAC, this)) {
    touch_manager_classPrivateFieldSet(_touchMoveAC, this, new AbortController());
    const signal = AbortSignal.any([touch_manager_classPrivateFieldGet(_signal, this), touch_manager_classPrivateFieldGet(_touchMoveAC, this).signal]);
    const container = touch_manager_classPrivateFieldGet(touch_manager_container, this);
    const opt = {
      signal,
      capture: false,
      passive: false
    };
    container.addEventListener("touchmove", touch_manager_assertClassBrand(_TouchManager_brand, this, _onTouchMove).bind(this), opt);
    const onTouchEnd = touch_manager_assertClassBrand(_TouchManager_brand, this, _onTouchEnd).bind(this);
    container.addEventListener("touchend", onTouchEnd, opt);
    container.addEventListener("touchcancel", onTouchEnd, opt);
    opt.capture = true;
    container.addEventListener("pointerdown", stopEvent, opt);
    container.addEventListener("pointermove", stopEvent, opt);
    container.addEventListener("pointercancel", stopEvent, opt);
    container.addEventListener("pointerup", stopEvent, opt);
    touch_manager_classPrivateFieldGet(_onPinchStart, this)?.call(this);
  }
  stopEvent(evt);
  if (evt.touches.length !== 2 || touch_manager_classPrivateFieldGet(_isPinchingStopped, this)?.call(this)) {
    touch_manager_classPrivateFieldSet(_touchInfo, this, null);
    return;
  }
  let [touch0, touch1] = evt.touches;
  if (touch0.identifier > touch1.identifier) {
    [touch0, touch1] = [touch1, touch0];
  }
  touch_manager_classPrivateFieldSet(_touchInfo, this, {
    touch0X: touch0.screenX,
    touch0Y: touch0.screenY,
    touch1X: touch1.screenX,
    touch1Y: touch1.screenY
  });
}
function _onTouchMove(evt) {
  if (!touch_manager_classPrivateFieldGet(_touchInfo, this) || evt.touches.length !== 2) {
    return;
  }
  stopEvent(evt);
  let [touch0, touch1] = evt.touches;
  if (touch0.identifier > touch1.identifier) {
    [touch0, touch1] = [touch1, touch0];
  }
  const {
    screenX: screen0X,
    screenY: screen0Y
  } = touch0;
  const {
    screenX: screen1X,
    screenY: screen1Y
  } = touch1;
  const touchInfo = touch_manager_classPrivateFieldGet(_touchInfo, this);
  const {
    touch0X: pTouch0X,
    touch0Y: pTouch0Y,
    touch1X: pTouch1X,
    touch1Y: pTouch1Y
  } = touchInfo;
  const prevGapX = pTouch1X - pTouch0X;
  const prevGapY = pTouch1Y - pTouch0Y;
  const currGapX = screen1X - screen0X;
  const currGapY = screen1Y - screen0Y;
  const distance = Math.hypot(currGapX, currGapY) || 1;
  const pDistance = Math.hypot(prevGapX, prevGapY) || 1;
  if (!touch_manager_classPrivateFieldGet(_isPinching, this) && Math.abs(pDistance - distance) <= _TouchManager.MIN_TOUCH_DISTANCE_TO_PINCH) {
    return;
  }
  touchInfo.touch0X = screen0X;
  touchInfo.touch0Y = screen0Y;
  touchInfo.touch1X = screen1X;
  touchInfo.touch1Y = screen1Y;
  if (!touch_manager_classPrivateFieldGet(_isPinching, this)) {
    touch_manager_classPrivateFieldSet(_isPinching, this, true);
    return;
  }
  const origin = [(screen0X + screen1X) / 2, (screen0Y + screen1Y) / 2];
  touch_manager_classPrivateFieldGet(_onPinching, this)?.call(this, origin, pDistance, distance);
}
function _onTouchEnd(evt) {
  if (evt.touches.length >= 2) {
    return;
  }
  if (touch_manager_classPrivateFieldGet(_touchMoveAC, this)) {
    touch_manager_classPrivateFieldGet(_touchMoveAC, this).abort();
    touch_manager_classPrivateFieldSet(_touchMoveAC, this, null);
    touch_manager_classPrivateFieldGet(_onPinchEnd, this)?.call(this);
  }
  if (!touch_manager_classPrivateFieldGet(_touchInfo, this)) {
    return;
  }
  stopEvent(evt);
  touch_manager_classPrivateFieldSet(_touchInfo, this, null);
  touch_manager_classPrivateFieldSet(_isPinching, this, false);
}

;// ./src/display/editor/editor.js
var _AnnotationEditor;

function editor_classPrivateMethodInitSpec(e, a) { editor_checkPrivateRedeclaration(e, a), a.add(e); }
function editor_defineProperty(e, r, t) { return (r = editor_toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function editor_toPropertyKey(t) { var i = editor_toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function editor_toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function editor_classPrivateFieldInitSpec(e, t, a) { editor_checkPrivateRedeclaration(e, t), t.set(e, a); }
function editor_checkPrivateRedeclaration(e, t) { if (t.has(e)) throw new TypeError("Cannot initialize the same private elements twice on an object"); }
function editor_classPrivateFieldSet(s, a, r) { return s.set(editor_assertClassBrand(s, a), r), r; }
function editor_classPrivateFieldGet(s, a) { return s.get(editor_assertClassBrand(s, a)); }
function editor_assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); }






var _accessibilityData = /*#__PURE__*/new WeakMap();
var _allResizerDivs = /*#__PURE__*/new WeakMap();
var editor_altText = /*#__PURE__*/new WeakMap();
var _disabled = /*#__PURE__*/new WeakMap();
var _dragPointerId = /*#__PURE__*/new WeakMap();
var _dragPointerType = /*#__PURE__*/new WeakMap();
var _keepAspectRatio = /*#__PURE__*/new WeakMap();
var _resizersDiv = /*#__PURE__*/new WeakMap();
var _lastPointerCoords = /*#__PURE__*/new WeakMap();
var _savedDimensions = /*#__PURE__*/new WeakMap();
var _focusAC = /*#__PURE__*/new WeakMap();
var _focusedResizerName = /*#__PURE__*/new WeakMap();
var _hasBeenClicked = /*#__PURE__*/new WeakMap();
var _initialRect = /*#__PURE__*/new WeakMap();
var _isEditing = /*#__PURE__*/new WeakMap();
var _isInEditMode = /*#__PURE__*/new WeakMap();
var _isResizerEnabledForKeyboard = /*#__PURE__*/new WeakMap();
var _moveInDOMTimeout = /*#__PURE__*/new WeakMap();
var _prevDragX = /*#__PURE__*/new WeakMap();
var _prevDragY = /*#__PURE__*/new WeakMap();
var _telemetryTimeouts = /*#__PURE__*/new WeakMap();
var _touchManager = /*#__PURE__*/new WeakMap();
var _isDraggable = /*#__PURE__*/new WeakMap();
var _zIndex = /*#__PURE__*/new WeakMap();
var _AnnotationEditor_brand = /*#__PURE__*/new WeakSet();
class AnnotationEditor {
  static get _resizerKeyboardManager() {
    const resize = AnnotationEditor.prototype._resizeWithKeyboard;
    const small = AnnotationEditorUIManager.TRANSLATE_SMALL;
    const big = AnnotationEditorUIManager.TRANSLATE_BIG;
    return shadow(this, "_resizerKeyboardManager", new KeyboardManager([[["ArrowLeft", "mac+ArrowLeft"], resize, {
      args: [-small, 0]
    }], [["ctrl+ArrowLeft", "mac+shift+ArrowLeft"], resize, {
      args: [-big, 0]
    }], [["ArrowRight", "mac+ArrowRight"], resize, {
      args: [small, 0]
    }], [["ctrl+ArrowRight", "mac+shift+ArrowRight"], resize, {
      args: [big, 0]
    }], [["ArrowUp", "mac+ArrowUp"], resize, {
      args: [0, -small]
    }], [["ctrl+ArrowUp", "mac+shift+ArrowUp"], resize, {
      args: [0, -big]
    }], [["ArrowDown", "mac+ArrowDown"], resize, {
      args: [0, small]
    }], [["ctrl+ArrowDown", "mac+shift+ArrowDown"], resize, {
      args: [0, big]
    }], [["Escape", "mac+Escape"], AnnotationEditor.prototype._stopResizingWithKeyboard]]));
  }
  constructor(parameters) {
    editor_classPrivateMethodInitSpec(this, _AnnotationEditor_brand);
    editor_classPrivateFieldInitSpec(this, _accessibilityData, null);
    editor_classPrivateFieldInitSpec(this, _allResizerDivs, null);
    editor_classPrivateFieldInitSpec(this, editor_altText, null);
    editor_classPrivateFieldInitSpec(this, _disabled, false);
    editor_classPrivateFieldInitSpec(this, _dragPointerId, null);
    editor_classPrivateFieldInitSpec(this, _dragPointerType, "");
    editor_classPrivateFieldInitSpec(this, _keepAspectRatio, false);
    editor_classPrivateFieldInitSpec(this, _resizersDiv, null);
    editor_classPrivateFieldInitSpec(this, _lastPointerCoords, null);
    editor_classPrivateFieldInitSpec(this, _savedDimensions, null);
    editor_classPrivateFieldInitSpec(this, _focusAC, null);
    editor_classPrivateFieldInitSpec(this, _focusedResizerName, "");
    editor_classPrivateFieldInitSpec(this, _hasBeenClicked, false);
    editor_classPrivateFieldInitSpec(this, _initialRect, null);
    editor_classPrivateFieldInitSpec(this, _isEditing, false);
    editor_classPrivateFieldInitSpec(this, _isInEditMode, false);
    editor_classPrivateFieldInitSpec(this, _isResizerEnabledForKeyboard, false);
    editor_classPrivateFieldInitSpec(this, _moveInDOMTimeout, null);
    editor_classPrivateFieldInitSpec(this, _prevDragX, 0);
    editor_classPrivateFieldInitSpec(this, _prevDragY, 0);
    editor_classPrivateFieldInitSpec(this, _telemetryTimeouts, null);
    editor_classPrivateFieldInitSpec(this, _touchManager, null);
    editor_defineProperty(this, "isSelected", false);
    editor_defineProperty(this, "_isCopy", false);
    editor_defineProperty(this, "_editToolbar", null);
    editor_defineProperty(this, "_initialOptions", Object.create(null));
    editor_defineProperty(this, "_initialData", null);
    editor_defineProperty(this, "_isVisible", true);
    editor_defineProperty(this, "_uiManager", null);
    editor_defineProperty(this, "_focusEventsAllowed", true);
    editor_classPrivateFieldInitSpec(this, _isDraggable, false);
    editor_classPrivateFieldInitSpec(this, _zIndex, AnnotationEditor._zIndex++);
    editor_defineProperty(this, "doNotMove", false);
    this.parent = parameters.parent;
    this.id = parameters.id;
    this.width = this.height = null;
    this.pageIndex = parameters.parent.pageIndex;
    this.name = parameters.name;
    this.div = null;
    this._uiManager = parameters.uiManager;
    this.annotationElementId = null;
    this._willKeepAspectRatio = false;
    this._initialOptions.isCentered = parameters.isCentered;
    this._structTreeParentId = null;
    const {
      rotation: _rotation,
      rawDims: {
        pageWidth: _pageWidth,
        pageHeight: _pageHeight,
        pageX,
        pageY
      }
    } = this.parent.viewport;
    this.rotation = _rotation;
    this.pageRotation = (360 + _rotation - this._uiManager.viewParameters.rotation) % 360;
    this.pageDimensions = [_pageWidth, _pageHeight];
    this.pageTranslation = [pageX, pageY];
    const [_width, _height] = this.parentDimensions;
    this.x = parameters.x / _width;
    this.y = parameters.y / _height;
    this.isAttachedToDOM = false;
    this.deleted = false;
    this.eventBus = parameters.eventBus;
  }
  get editorType() {
    return Object.getPrototypeOf(this).constructor._type;
  }
  static get isDrawer() {
    return false;
  }
  static get _defaultLineColor() {
    return shadow(this, "_defaultLineColor", this._colorManager.getHexCode("CanvasText"));
  }
  static deleteAnnotationElement(editor) {
    const fakeEditor = new FakeEditor({
      id: editor.parent.getNextId(),
      parent: editor.parent,
      uiManager: editor._uiManager
    });
    fakeEditor.annotationElementId = editor.annotationElementId;
    fakeEditor.deleted = true;
    fakeEditor._uiManager.addToAnnotationStorage(fakeEditor);
  }
  static initialize(l10n, _uiManager) {
    AnnotationEditor._l10n ??= l10n;
    AnnotationEditor._l10nResizer ||= Object.freeze({
      topLeft: "pdfjs-editor-resizer-top-left",
      topMiddle: "pdfjs-editor-resizer-top-middle",
      topRight: "pdfjs-editor-resizer-top-right",
      middleRight: "pdfjs-editor-resizer-middle-right",
      bottomRight: "pdfjs-editor-resizer-bottom-right",
      bottomMiddle: "pdfjs-editor-resizer-bottom-middle",
      bottomLeft: "pdfjs-editor-resizer-bottom-left",
      middleLeft: "pdfjs-editor-resizer-middle-left"
    });
    if (AnnotationEditor._borderLineWidth !== -1) {
      return;
    }
    const style = getComputedStyle(document.documentElement);
    AnnotationEditor._borderLineWidth = parseFloat(style.getPropertyValue("--outline-width")) || 0;
  }
  static updateDefaultParams(_type, _value) {}
  static get defaultPropertiesToUpdate() {
    return [];
  }
  static isHandlingMimeForPasting(mime) {
    return false;
  }
  static paste(item, parent) {
    unreachable("Not implemented");
  }
  get propertiesToUpdate() {
    return [];
  }
  get _isDraggable() {
    return editor_classPrivateFieldGet(_isDraggable, this);
  }
  set _isDraggable(value) {
    editor_classPrivateFieldSet(_isDraggable, this, value);
    this.div?.classList.toggle("draggable", value);
  }
  get isEnterHandled() {
    return true;
  }
  center() {
    const [pageWidth, pageHeight] = this.pageDimensions;
    switch (this.parentRotation) {
      case 90:
        this.x -= this.height * pageHeight / (pageWidth * 2);
        this.y += this.width * pageWidth / (pageHeight * 2);
        break;
      case 180:
        this.x += this.width / 2;
        this.y += this.height / 2;
        break;
      case 270:
        this.x += this.height * pageHeight / (pageWidth * 2);
        this.y -= this.width * pageWidth / (pageHeight * 2);
        break;
      default:
        this.x -= this.width / 2;
        this.y -= this.height / 2;
        break;
    }
    this.fixAndSetPosition();
  }
  addCommands(params) {
    this._uiManager.addCommands(params);
  }
  get currentLayer() {
    return this._uiManager.currentLayer;
  }
  setInBackground() {
    this.div.style.zIndex = 0;
  }
  setInForeground() {
    this.div.style.zIndex = editor_classPrivateFieldGet(_zIndex, this);
  }
  setParent(parent) {
    if (parent !== null) {
      this.pageIndex = parent.pageIndex;
      this.pageDimensions = parent.pageDimensions;
    } else {
      editor_assertClassBrand(_AnnotationEditor_brand, this, _stopResizing).call(this);
    }
    this.parent = parent;
  }
  focusin(event) {
    if (!this._focusEventsAllowed) {
      return;
    }
    if (!editor_classPrivateFieldGet(_hasBeenClicked, this)) {
      this.parent.setSelected(this);
    } else {
      editor_classPrivateFieldSet(_hasBeenClicked, this, false);
    }
  }
  focusout(event) {
    if (!this._focusEventsAllowed) {
      return;
    }
    if (!this.isAttachedToDOM) {
      return;
    }
    const target = event.relatedTarget;
    if (target?.closest(`#${this.id}`)) {
      return;
    }
    event.preventDefault();
    if (!this.parent?.isMultipleSelection) {
      this.commitOrRemove();
    }
  }
  commitOrRemove() {
    if (this.isEmpty()) {
      this.remove();
    } else {
      this.commit();
    }
  }
  commit() {
    this.addToAnnotationStorage();
    this.eventBus?.dispatch("annotation-editor-event", {
      source: this,
      type: "commit",
      page: this.pageIndex + 1,
      editorType: this.constructor.name,
      value: this
    });
  }
  addToAnnotationStorage() {
    this._uiManager.addToAnnotationStorage(this);
  }
  setAt(x, y, tx, ty) {
    const [width, height] = this.parentDimensions;
    [tx, ty] = this.screenToPageTranslation(tx, ty);
    if (this.doNotMove) {
      [tx, ty] = [0, 0];
    }
    this.x = (x + tx) / width;
    this.y = (y + ty) / height;
    this.fixAndSetPosition();
  }
  _moveAfterPaste(baseX, baseY) {
    const [parentWidth, parentHeight] = this.parentDimensions;
    this.setAt(baseX * parentWidth, baseY * parentHeight, this.width * parentWidth, this.height * parentHeight);
    this._onTranslated();
  }
  translate(x, y) {
    editor_assertClassBrand(_AnnotationEditor_brand, this, _translate).call(this, this.parentDimensions, x, y);
  }
  translateInPage(x, y) {
    editor_classPrivateFieldGet(_initialRect, this) || editor_classPrivateFieldSet(_initialRect, this, [this.x, this.y, this.width, this.height]);
    editor_assertClassBrand(_AnnotationEditor_brand, this, _translate).call(this, this.pageDimensions, x, y);
    this.div.scrollIntoView({
      block: "nearest"
    });
  }
  translationDone() {
    this._onTranslated(this.x, this.y);
  }
  drag(tx, ty) {
    editor_classPrivateFieldGet(_initialRect, this) || editor_classPrivateFieldSet(_initialRect, this, [this.x, this.y, this.width, this.height]);
    const {
      div,
      parentDimensions: [parentWidth, parentHeight]
    } = this;
    this.x += tx / parentWidth;
    this.y += ty / parentHeight;
    if (this.parent && (this.x < 0 || this.x > 1 || this.y < 0 || this.y > 1)) {
      const {
        x,
        y
      } = this.div.getBoundingClientRect();
      if (this.parent.findNewParent(this, x, y)) {
        this.x -= Math.floor(this.x);
        this.y -= Math.floor(this.y);
      }
    }
    let {
      x,
      y
    } = this;
    const [bx, by] = this.getBaseTranslation();
    x += bx;
    y += by;
    const {
      style
    } = div;
    style.left = `${(100 * x).toFixed(2)}%`;
    style.top = `${(100 * y).toFixed(2)}%`;
    this._onTranslating(x, y);
    div.scrollIntoView({
      block: "nearest"
    });
  }
  _onTranslating(x, y) {}
  _onTranslated(x, y) {
    this.eventBus?.dispatch("annotation-editor-event", {
      source: this,
      type: "moved",
      page: this.pageIndex + 1,
      editorType: this.constructor.name,
      value: {
        x,
        y
      }
    });
  }
  get _hasBeenMoved() {
    return !!editor_classPrivateFieldGet(_initialRect, this) && (editor_classPrivateFieldGet(_initialRect, this)[0] !== this.x || editor_classPrivateFieldGet(_initialRect, this)[1] !== this.y);
  }
  get _hasBeenResized() {
    return !!editor_classPrivateFieldGet(_initialRect, this) && (editor_classPrivateFieldGet(_initialRect, this)[2] !== this.width || editor_classPrivateFieldGet(_initialRect, this)[3] !== this.height);
  }
  getBaseTranslation() {
    const [parentWidth, parentHeight] = this.parentDimensions;
    const {
      _borderLineWidth
    } = AnnotationEditor;
    const x = _borderLineWidth / parentWidth;
    const y = _borderLineWidth / parentHeight;
    switch (this.rotation) {
      case 90:
        return [-x, y];
      case 180:
        return [x, y];
      case 270:
        return [x, -y];
      default:
        return [-x, -y];
    }
  }
  get _mustFixPosition() {
    return true;
  }
  fixAndSetPosition() {
    let rotation = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : this.rotation;
    const {
      div: {
        style
      },
      pageDimensions: [pageWidth, pageHeight]
    } = this;
    let {
      x,
      y,
      width,
      height
    } = this;
    width *= pageWidth;
    height *= pageHeight;
    x *= pageWidth;
    y *= pageHeight;
    if (this._mustFixPosition) {
      switch (rotation) {
        case 0:
          x = MathClamp(x, 0, pageWidth - width);
          y = MathClamp(y, 0, pageHeight - height);
          break;
        case 90:
          x = MathClamp(x, 0, pageWidth - height);
          y = MathClamp(y, width, pageHeight);
          break;
        case 180:
          x = MathClamp(x, width, pageWidth);
          y = MathClamp(y, height, pageHeight);
          break;
        case 270:
          x = MathClamp(x, height, pageWidth);
          y = MathClamp(y, 0, pageHeight - width);
          break;
      }
    }
    this.x = x /= pageWidth;
    this.y = y /= pageHeight;
    const [bx, by] = this.getBaseTranslation();
    x += bx;
    y += by;
    style.left = `${(100 * x).toFixed(2)}%`;
    style.top = `${(100 * y).toFixed(2)}%`;
    this.moveInDOM();
  }
  screenToPageTranslation(x, y) {
    return _rotatePoint.call(AnnotationEditor, x, y, this.parentRotation);
  }
  pageTranslationToScreen(x, y) {
    return _rotatePoint.call(AnnotationEditor, x, y, 360 - this.parentRotation);
  }
  get parentScale() {
    return this._uiManager.viewParameters.realScale;
  }
  get parentRotation() {
    return (this._uiManager.viewParameters.rotation + this.pageRotation) % 360;
  }
  get parentDimensions() {
    const {
      parentScale,
      pageDimensions: [pageWidth, pageHeight]
    } = this;
    return [pageWidth * parentScale, pageHeight * parentScale];
  }
  setDims(width, height) {
    const [parentWidth, parentHeight] = this.parentDimensions;
    const {
      style
    } = this.div;
    style.width = `${(100 * width / parentWidth).toFixed(2)}%`;
    if (!editor_classPrivateFieldGet(_keepAspectRatio, this)) {
      style.height = `${(100 * height / parentHeight).toFixed(2)}%`;
    }
  }
  fixDims() {
    const {
      style
    } = this.div;
    const {
      height,
      width
    } = style;
    const widthPercent = width.endsWith("%");
    const heightPercent = !editor_classPrivateFieldGet(_keepAspectRatio, this) && height.endsWith("%");
    if (widthPercent && heightPercent) {
      return;
    }
    const [parentWidth, parentHeight] = this.parentDimensions;
    if (!widthPercent) {
      style.width = `${(100 * parseFloat(width) / parentWidth).toFixed(2)}%`;
    }
    if (!editor_classPrivateFieldGet(_keepAspectRatio, this) && !heightPercent) {
      style.height = `${(100 * parseFloat(height) / parentHeight).toFixed(2)}%`;
    }
  }
  getInitialTranslation() {
    return [0, 0];
  }
  _onResized() {}
  static _round(x) {
    return Math.round(x * 10000) / 10000;
  }
  _onResizing() {}
  altTextFinish() {
    editor_classPrivateFieldGet(editor_altText, this)?.finish();
    this.eventBus?.dispatch("annotation-editor-event", {
      source: this,
      type: "altTextChanged",
      page: this.pageIndex + 1,
      editorType: this.constructor.name,
      value: editor_classPrivateFieldGet(editor_altText, this)
    });
  }
  async addEditToolbar() {
    if (this._editToolbar || editor_classPrivateFieldGet(_isInEditMode, this)) {
      return this._editToolbar;
    }
    this._editToolbar = new EditorToolbar(this);
    this.div.append(this._editToolbar.render());
    if (editor_classPrivateFieldGet(editor_altText, this)) {
      await this._editToolbar.addAltText(editor_classPrivateFieldGet(editor_altText, this));
    }
    return this._editToolbar;
  }
  removeEditToolbar() {
    if (!this._editToolbar) {
      return;
    }
    this._editToolbar.remove();
    this._editToolbar = null;
    editor_classPrivateFieldGet(editor_altText, this)?.destroy();
  }
  addContainer(container) {
    const editToolbarDiv = this._editToolbar?.div;
    if (editToolbarDiv) {
      editToolbarDiv.before(container);
    } else {
      this.div.append(container);
    }
  }
  getClientDimensions() {
    return this.div.getBoundingClientRect();
  }
  async addAltTextButton() {
    if (editor_classPrivateFieldGet(editor_altText, this)) {
      return;
    }
    AltText.initialize(AnnotationEditor._l10n);
    editor_classPrivateFieldSet(editor_altText, this, new AltText(this));
    if (editor_classPrivateFieldGet(_accessibilityData, this)) {
      editor_classPrivateFieldGet(editor_altText, this).data = editor_classPrivateFieldGet(_accessibilityData, this);
      editor_classPrivateFieldSet(_accessibilityData, this, null);
    }
    await this.addEditToolbar();
  }
  get altTextData() {
    return editor_classPrivateFieldGet(editor_altText, this)?.data;
  }
  set altTextData(data) {
    if (!editor_classPrivateFieldGet(editor_altText, this)) {
      return;
    }
    editor_classPrivateFieldGet(editor_altText, this).data = data;
  }
  get guessedAltText() {
    return editor_classPrivateFieldGet(editor_altText, this)?.guessedText;
  }
  async setGuessedAltText(text) {
    await editor_classPrivateFieldGet(editor_altText, this)?.setGuessedText(text);
  }
  serializeAltText(isForCopying) {
    return editor_classPrivateFieldGet(editor_altText, this)?.serialize(isForCopying);
  }
  hasAltText() {
    return !!editor_classPrivateFieldGet(editor_altText, this) && !editor_classPrivateFieldGet(editor_altText, this).isEmpty();
  }
  hasAltTextData() {
    return editor_classPrivateFieldGet(editor_altText, this)?.hasData() ?? false;
  }
  render() {
    const div = this.div = document.createElement("div");
    div.setAttribute("data-editor-rotation", (360 - this.rotation) % 360);
    div.className = this.name;
    div.setAttribute("id", this.id);
    div.tabIndex = editor_classPrivateFieldGet(_disabled, this) ? -1 : 0;
    div.setAttribute("role", "application");
    if (this.defaultL10nId) {
      div.setAttribute("data-l10n-id", this.defaultL10nId);
    }
    if (!this._isVisible) {
      div.classList.add("hidden");
    }
    this.setInForeground();
    editor_assertClassBrand(_AnnotationEditor_brand, this, _addFocusListeners).call(this);
    const [parentWidth, parentHeight] = this.parentDimensions;
    if (this.parentRotation % 180 !== 0) {
      div.style.maxWidth = `${(100 * parentHeight / parentWidth).toFixed(2)}%`;
      div.style.maxHeight = `${(100 * parentWidth / parentHeight).toFixed(2)}%`;
    }
    const [tx, ty] = this.getInitialTranslation();
    this.translate(tx, ty);
    bindEvents(this, div, ["keydown", "pointerdown", "dblclick"]);
    if (this.isResizable && this._uiManager._supportsPinchToZoom) {
      editor_classPrivateFieldGet(_touchManager, this) || editor_classPrivateFieldSet(_touchManager, this, new TouchManager({
        container: div,
        isPinchingDisabled: () => !this.isSelected,
        onPinchStart: editor_assertClassBrand(_AnnotationEditor_brand, this, _touchPinchStartCallback).bind(this),
        onPinching: editor_assertClassBrand(_AnnotationEditor_brand, this, _touchPinchCallback).bind(this),
        onPinchEnd: editor_assertClassBrand(_AnnotationEditor_brand, this, _touchPinchEndCallback).bind(this),
        signal: this._uiManager._signal
      }));
    }
    this._uiManager._editorUndoBar?.hide();
    return div;
  }
  pointerdown(event) {
    const {
      isMac
    } = util_FeatureTest.platform;
    if (event.button !== 0 || event.ctrlKey && isMac) {
      event.preventDefault();
      return;
    }
    editor_classPrivateFieldSet(_hasBeenClicked, this, true);
    if (this._isDraggable) {
      editor_assertClassBrand(_AnnotationEditor_brand, this, _setUpDragSession).call(this, event);
      return;
    }
    editor_assertClassBrand(_AnnotationEditor_brand, this, _selectOnPointerEvent).call(this, event);
  }
  _onStartDragging() {}
  _onStopDragging() {}
  moveInDOM() {
    if (editor_classPrivateFieldGet(_moveInDOMTimeout, this)) {
      clearTimeout(editor_classPrivateFieldGet(_moveInDOMTimeout, this));
    }
    editor_classPrivateFieldSet(_moveInDOMTimeout, this, setTimeout(() => {
      editor_classPrivateFieldSet(_moveInDOMTimeout, this, null);
      this.parent?.moveEditorInDOM(this);
    }, 0));
  }
  _setParentAndPosition(parent, x, y) {
    parent.changeParent(this);
    this.x = x;
    this.y = y;
    this.fixAndSetPosition();
    this._onTranslated();
  }
  getRect(tx, ty) {
    let rotation = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : this.rotation;
    const scale = this.parentScale;
    const [pageWidth, pageHeight] = this.pageDimensions;
    const [pageX, pageY] = this.pageTranslation;
    const shiftX = tx / scale;
    const shiftY = ty / scale;
    const x = this.x * pageWidth;
    const y = this.y * pageHeight;
    const width = this.width * pageWidth;
    const height = this.height * pageHeight;
    switch (rotation) {
      case 0:
        return [x + shiftX + pageX, pageHeight - y - shiftY - height + pageY, x + shiftX + width + pageX, pageHeight - y - shiftY + pageY];
      case 90:
        return [x + shiftY + pageX, pageHeight - y + shiftX + pageY, x + shiftY + height + pageX, pageHeight - y + shiftX + width + pageY];
      case 180:
        return [x - shiftX - width + pageX, pageHeight - y + shiftY + pageY, x - shiftX + pageX, pageHeight - y + shiftY + height + pageY];
      case 270:
        return [x - shiftY - height + pageX, pageHeight - y - shiftX - width + pageY, x - shiftY + pageX, pageHeight - y - shiftX + pageY];
      default:
        throw new Error("Invalid rotation");
    }
  }
  getRectInCurrentCoords(rect, pageHeight) {
    const [x1, y1, x2, y2] = rect;
    const width = x2 - x1;
    const height = y2 - y1;
    switch (this.rotation) {
      case 0:
        return [x1, pageHeight - y2, width, height];
      case 90:
        return [x1, pageHeight - y1, height, width];
      case 180:
        return [x2, pageHeight - y1, width, height];
      case 270:
        return [x2, pageHeight - y2, height, width];
      default:
        throw new Error("Invalid rotation");
    }
  }
  onceAdded(focus) {}
  isEmpty() {
    return false;
  }
  enableEditMode() {
    if (this.isInEditMode()) {
      return false;
    }
    this.parent.setEditingState(false);
    editor_classPrivateFieldSet(_isInEditMode, this, true);
    return true;
  }
  disableEditMode() {
    if (!this.isInEditMode()) {
      return false;
    }
    this.parent.setEditingState(true);
    editor_classPrivateFieldSet(_isInEditMode, this, false);
    return true;
  }
  isInEditMode() {
    return editor_classPrivateFieldGet(_isInEditMode, this);
  }
  shouldGetKeyboardEvents() {
    return editor_classPrivateFieldGet(_isResizerEnabledForKeyboard, this);
  }
  needsToBeRebuilt() {
    return this.div && !this.isAttachedToDOM;
  }
  get isOnScreen() {
    const {
      top,
      left,
      bottom,
      right
    } = this.getClientDimensions();
    const {
      innerHeight,
      innerWidth
    } = window;
    return left < innerWidth && right > 0 && top < innerHeight && bottom > 0;
  }
  rebuild() {
    editor_assertClassBrand(_AnnotationEditor_brand, this, _addFocusListeners).call(this);
  }
  rotate(_angle) {}
  resize() {}
  serializeDeleted() {
    return {
      id: this.annotationElementId,
      deleted: true,
      pageIndex: this.pageIndex,
      popupRef: this._initialData?.popupRef || ""
    };
  }
  serialize() {
    let isForCopying = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
    let context = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
    unreachable("An editor must be serializable");
  }
  static async deserialize(data, parent, uiManager) {
    const editor = new this.prototype.constructor({
      parent,
      id: parent.getNextId(),
      uiManager,
      eventBus: parent.eventBus
    });
    editor.rotation = data.rotation;
    editor_classPrivateFieldSet(_accessibilityData, editor, data.accessibilityData);
    editor._isCopy = data.isCopy || false;
    const [pageWidth, pageHeight] = editor.pageDimensions;
    const [x, y, width, height] = editor.getRectInCurrentCoords(data.rect, pageHeight);
    editor.x = x / pageWidth;
    editor.y = y / pageHeight;
    editor.width = width / pageWidth;
    editor.height = height / pageHeight;
    return editor;
  }
  get hasBeenModified() {
    return !!this.annotationElementId && (this.deleted || this.serialize() !== null);
  }
  remove() {
    editor_classPrivateFieldGet(_focusAC, this)?.abort();
    editor_classPrivateFieldSet(_focusAC, this, null);
    if (!this.isEmpty()) {
      this.commit();
    }
    if (this.parent) {
      this.parent.remove(this);
    } else {
      this._uiManager.removeEditor(this);
    }
    if (editor_classPrivateFieldGet(_moveInDOMTimeout, this)) {
      clearTimeout(editor_classPrivateFieldGet(_moveInDOMTimeout, this));
      editor_classPrivateFieldSet(_moveInDOMTimeout, this, null);
    }
    editor_assertClassBrand(_AnnotationEditor_brand, this, _stopResizing).call(this);
    this.removeEditToolbar();
    if (editor_classPrivateFieldGet(_telemetryTimeouts, this)) {
      for (const timeout of editor_classPrivateFieldGet(_telemetryTimeouts, this).values()) {
        clearTimeout(timeout);
      }
      editor_classPrivateFieldSet(_telemetryTimeouts, this, null);
    }
    this.parent = null;
    this.eventBus?.dispatch("annotation-editor-event", {
      source: this,
      type: "removed",
      page: this.pageIndex + 1,
      editorType: this.constructor.name,
      value: this
    });
    editor_classPrivateFieldGet(_touchManager, this)?.destroy();
    editor_classPrivateFieldSet(_touchManager, this, null);
  }
  get isResizable() {
    return false;
  }
  makeResizable() {
    if (this.isResizable) {
      editor_assertClassBrand(_AnnotationEditor_brand, this, _createResizers).call(this);
      editor_classPrivateFieldGet(_resizersDiv, this).classList.remove("hidden");
    }
  }
  get toolbarPosition() {
    return null;
  }
  keydown(event) {
    if (!this.isResizable || event.target !== this.div || event.key !== "Enter") {
      return;
    }
    this._uiManager.setSelected(this);
    editor_classPrivateFieldSet(_savedDimensions, this, {
      savedX: this.x,
      savedY: this.y,
      savedWidth: this.width,
      savedHeight: this.height
    });
    const children = editor_classPrivateFieldGet(_resizersDiv, this).children;
    if (!editor_classPrivateFieldGet(_allResizerDivs, this)) {
      editor_classPrivateFieldSet(_allResizerDivs, this, Array.from(children));
      const boundResizerKeydown = editor_assertClassBrand(_AnnotationEditor_brand, this, _resizerKeydown).bind(this);
      const boundResizerBlur = editor_assertClassBrand(_AnnotationEditor_brand, this, _resizerBlur).bind(this);
      const signal = this._uiManager._signal;
      for (const div of editor_classPrivateFieldGet(_allResizerDivs, this)) {
        const name = div.getAttribute("data-resizer-name");
        div.setAttribute("role", "spinbutton");
        div.addEventListener("keydown", boundResizerKeydown, {
          signal
        });
        div.addEventListener("blur", boundResizerBlur, {
          signal
        });
        div.addEventListener("focus", editor_assertClassBrand(_AnnotationEditor_brand, this, _resizerFocus).bind(this, name), {
          signal
        });
        div.setAttribute("data-l10n-id", AnnotationEditor._l10nResizer[name]);
      }
    }
    const first = editor_classPrivateFieldGet(_allResizerDivs, this)[0];
    let firstPosition = 0;
    for (const div of children) {
      if (div === first) {
        break;
      }
      firstPosition++;
    }
    const nextFirstPosition = (360 - this.rotation + this.parentRotation) % 360 / 90 * (editor_classPrivateFieldGet(_allResizerDivs, this).length / 4);
    if (nextFirstPosition !== firstPosition) {
      if (nextFirstPosition < firstPosition) {
        for (let i = 0; i < firstPosition - nextFirstPosition; i++) {
          editor_classPrivateFieldGet(_resizersDiv, this).append(editor_classPrivateFieldGet(_resizersDiv, this).firstChild);
        }
      } else if (nextFirstPosition > firstPosition) {
        for (let i = 0; i < nextFirstPosition - firstPosition; i++) {
          editor_classPrivateFieldGet(_resizersDiv, this).firstChild.before(editor_classPrivateFieldGet(_resizersDiv, this).lastChild);
        }
      }
      let i = 0;
      for (const child of children) {
        const div = editor_classPrivateFieldGet(_allResizerDivs, this)[i++];
        const name = div.getAttribute("data-resizer-name");
        child.setAttribute("data-l10n-id", AnnotationEditor._l10nResizer[name]);
      }
    }
    editor_assertClassBrand(_AnnotationEditor_brand, this, _setResizerTabIndex).call(this, 0);
    editor_classPrivateFieldSet(_isResizerEnabledForKeyboard, this, true);
    editor_classPrivateFieldGet(_resizersDiv, this).firstChild.focus({
      focusVisible: true
    });
    event.preventDefault();
    event.stopImmediatePropagation();
  }
  _resizeWithKeyboard(x, y) {
    if (!editor_classPrivateFieldGet(_isResizerEnabledForKeyboard, this)) {
      return;
    }
    editor_assertClassBrand(_AnnotationEditor_brand, this, _resizerPointermove).call(this, editor_classPrivateFieldGet(_focusedResizerName, this), {
      deltaX: x,
      deltaY: y,
      fromKeyboard: true
    });
  }
  _stopResizingWithKeyboard() {
    editor_assertClassBrand(_AnnotationEditor_brand, this, _stopResizing).call(this);
    this.div.focus();
  }
  select() {
    if (this.isSelected && this._editToolbar) {
      return;
    }
    this.isSelected = true;
    this.makeResizable();
    this.div?.classList.add("selectedEditor");
    if (!this._editToolbar) {
      this.addEditToolbar().then(() => {
        if (this.div?.classList.contains("selectedEditor")) {
          this._editToolbar?.show();
        }
      });
      return;
    }
    this._editToolbar?.show();
    editor_classPrivateFieldGet(editor_altText, this)?.toggleAltTextBadge(false);
  }
  unselect() {
    if (!this.isSelected) {
      return;
    }
    this.isSelected = false;
    editor_classPrivateFieldGet(_resizersDiv, this)?.classList.add("hidden");
    this.div?.classList.remove("selectedEditor");
    if (this.div?.contains(document.activeElement)) {
      this._uiManager.currentLayer.div.focus({
        preventScroll: true
      });
    }
    this._editToolbar?.hide();
    editor_classPrivateFieldGet(editor_altText, this)?.toggleAltTextBadge(true);
  }
  updateParams(type, value) {}
  disableEditing() {}
  enableEditing() {}
  get canChangeContent() {
    return false;
  }
  enterInEditMode() {
    if (!this.canChangeContent) {
      return;
    }
    this.enableEditMode();
    this.div.focus();
  }
  dblclick(event) {
    this.enterInEditMode();
    this.parent.updateToolbar({
      mode: this.constructor._editorType,
      editId: this.id
    });
  }
  getElementForAltText() {
    return this.div;
  }
  get contentDiv() {
    return this.div;
  }
  get isEditing() {
    return editor_classPrivateFieldGet(_isEditing, this);
  }
  set isEditing(value) {
    editor_classPrivateFieldSet(_isEditing, this, value);
    if (!this.parent) {
      return;
    }
    if (value) {
      this.parent.setSelected(this);
      this.parent.setActiveEditor(this);
    } else {
      this.parent.setActiveEditor(null);
    }
  }
  setAspectRatio(width, height) {
    editor_classPrivateFieldSet(_keepAspectRatio, this, true);
    const aspectRatio = width / height;
    const {
      style
    } = this.div;
    style.aspectRatio = aspectRatio;
    style.height = "auto";
  }
  static get MIN_SIZE() {
    return 16;
  }
  static canCreateNewEmptyEditor() {
    return true;
  }
  get telemetryInitialData() {
    return {
      action: "added"
    };
  }
  get telemetryFinalData() {
    return null;
  }
  _reportTelemetry(data) {
    let mustWait = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
    if (mustWait) {
      editor_classPrivateFieldGet(_telemetryTimeouts, this) || editor_classPrivateFieldSet(_telemetryTimeouts, this, new Map());
      const {
        action
      } = data;
      let timeout = editor_classPrivateFieldGet(_telemetryTimeouts, this).get(action);
      if (timeout) {
        clearTimeout(timeout);
      }
      timeout = setTimeout(() => {
        this._reportTelemetry(data);
        editor_classPrivateFieldGet(_telemetryTimeouts, this).delete(action);
        if (editor_classPrivateFieldGet(_telemetryTimeouts, this).size === 0) {
          editor_classPrivateFieldSet(_telemetryTimeouts, this, null);
        }
      }, AnnotationEditor._telemetryTimeout);
      editor_classPrivateFieldGet(_telemetryTimeouts, this).set(action, timeout);
      return;
    }
    data.type ||= this.editorType;
    this._uiManager._eventBus.dispatch("reporttelemetry", {
      source: this,
      details: {
        type: "editing",
        data
      }
    });
  }
  show() {
    let visible = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : this._isVisible;
    this.div.classList.toggle("hidden", !visible);
    this._isVisible = visible;
  }
  enable() {
    if (this.div) {
      this.div.tabIndex = 0;
    }
    editor_classPrivateFieldSet(_disabled, this, false);
  }
  disable() {
    if (this.div) {
      this.div.tabIndex = -1;
    }
    editor_classPrivateFieldSet(_disabled, this, true);
  }
  renderAnnotationElement(annotation) {
    let content = annotation.container.querySelector(".annotationContent");
    if (!content) {
      content = document.createElement("div");
      content.classList.add("annotationContent", this.editorType);
      annotation.container.prepend(content);
    } else if (content.nodeName === "CANVAS") {
      const canvas = content;
      content = document.createElement("div");
      content.classList.add("annotationContent", this.editorType);
      canvas.before(content);
    }
    return content;
  }
  resetAnnotationElement(annotation) {
    const {
      firstChild
    } = annotation.container;
    if (firstChild?.nodeName === "DIV" && firstChild.classList.contains("annotationContent")) {
      firstChild.remove();
    }
  }
}
_AnnotationEditor = AnnotationEditor;
function _translate(_ref, x, y) {
  let [width, height] = _ref;
  [x, y] = this.screenToPageTranslation(x, y);
  this.x += x / width;
  this.y += y / height;
  this._onTranslating(this.x, this.y);
  this.fixAndSetPosition();
}
function _rotatePoint(x, y, angle) {
  switch (angle) {
    case 90:
      return [y, -x];
    case 180:
      return [-x, -y];
    case 270:
      return [-y, x];
    default:
      return [x, y];
  }
}
function _getRotationMatrix(rotation) {
  switch (rotation) {
    case 90:
      {
        const [pageWidth, pageHeight] = this.pageDimensions;
        return [0, -pageWidth / pageHeight, pageHeight / pageWidth, 0];
      }
    case 180:
      return [-1, 0, 0, -1];
    case 270:
      {
        const [pageWidth, pageHeight] = this.pageDimensions;
        return [0, pageWidth / pageHeight, -pageHeight / pageWidth, 0];
      }
    default:
      return [1, 0, 0, 1];
  }
}
function _createResizers() {
  if (editor_classPrivateFieldGet(_resizersDiv, this)) {
    return;
  }
  editor_classPrivateFieldSet(_resizersDiv, this, document.createElement("div"));
  editor_classPrivateFieldGet(_resizersDiv, this).classList.add("resizers");
  const classes = this._willKeepAspectRatio ? ["topLeft", "topRight", "bottomRight", "bottomLeft"] : ["topLeft", "topMiddle", "topRight", "middleRight", "bottomRight", "bottomMiddle", "bottomLeft", "middleLeft"];
  const signal = this._uiManager._signal;
  for (const name of classes) {
    const div = document.createElement("div");
    editor_classPrivateFieldGet(_resizersDiv, this).append(div);
    div.classList.add("resizer", name);
    div.setAttribute("data-resizer-name", name);
    div.addEventListener("pointerdown", editor_assertClassBrand(_AnnotationEditor_brand, this, _resizerPointerdown).bind(this, name), {
      signal
    });
    div.addEventListener("contextmenu", noContextMenu, {
      signal
    });
    div.tabIndex = -1;
  }
  this.div.prepend(editor_classPrivateFieldGet(_resizersDiv, this));
}
function _resizerPointerdown(name, event) {
  event.preventDefault();
  const {
    isMac
  } = util_FeatureTest.platform;
  if (event.button !== 0 || event.ctrlKey && isMac) {
    return;
  }
  editor_classPrivateFieldGet(editor_altText, this)?.toggle(false);
  const savedDraggable = this._isDraggable;
  this._isDraggable = false;
  editor_classPrivateFieldSet(_lastPointerCoords, this, [event.screenX, event.screenY]);
  const ac = new AbortController();
  const signal = this._uiManager.combinedSignal(ac);
  this.parent.togglePointerEvents(false);
  window.addEventListener("pointermove", editor_assertClassBrand(_AnnotationEditor_brand, this, _resizerPointermove).bind(this, name), {
    passive: true,
    capture: true,
    signal
  });
  window.addEventListener("touchmove", stopEvent, {
    passive: false,
    signal
  });
  window.addEventListener("contextmenu", noContextMenu, {
    signal
  });
  editor_classPrivateFieldSet(_savedDimensions, this, {
    savedX: this.x,
    savedY: this.y,
    savedWidth: this.width,
    savedHeight: this.height
  });
  const savedParentCursor = this.parent.div.style.cursor;
  const savedCursor = this.div.style.cursor;
  this.div.style.cursor = this.parent.div.style.cursor = window.getComputedStyle(event.target).cursor;
  const pointerUpCallback = () => {
    ac.abort();
    this.parent.togglePointerEvents(true);
    editor_classPrivateFieldGet(editor_altText, this)?.toggle(true);
    this._isDraggable = savedDraggable;
    this.parent.div.style.cursor = savedParentCursor;
    this.div.style.cursor = savedCursor;
    editor_assertClassBrand(_AnnotationEditor_brand, this, _addResizeToUndoStack).call(this);
  };
  window.addEventListener("pointerup", pointerUpCallback, {
    signal
  });
  window.addEventListener("blur", pointerUpCallback, {
    signal
  });
}
function _resize(x, y, width, height) {
  this.width = width;
  this.height = height;
  this.x = x;
  this.y = y;
  const [parentWidth, parentHeight] = this.parentDimensions;
  this.setDims(parentWidth * width, parentHeight * height);
  this.fixAndSetPosition();
  this._onResized();
}
function _addResizeToUndoStack() {
  if (!editor_classPrivateFieldGet(_savedDimensions, this)) {
    return;
  }
  const {
    savedX,
    savedY,
    savedWidth,
    savedHeight
  } = editor_classPrivateFieldGet(_savedDimensions, this);
  editor_classPrivateFieldSet(_savedDimensions, this, null);
  const newX = this.x;
  const newY = this.y;
  const newWidth = this.width;
  const newHeight = this.height;
  if (newX === savedX && newY === savedY && newWidth === savedWidth && newHeight === savedHeight) {
    return;
  }
  this.eventBus?.dispatch("annotation-editor-event", {
    source: this,
    type: "sizeChanged",
    editorType: this.constructor.name,
    page: this.pageIndex + 1,
    value: {
      x: savedX,
      y: savedY,
      width: savedWidth,
      height: savedHeight
    }
  });
  this.addCommands({
    cmd: editor_assertClassBrand(_AnnotationEditor_brand, this, _resize).bind(this, newX, newY, newWidth, newHeight),
    undo: editor_assertClassBrand(_AnnotationEditor_brand, this, _resize).bind(this, savedX, savedY, savedWidth, savedHeight),
    mustExec: true
  });
}
function _resizerPointermove(name, event) {
  const [parentWidth, parentHeight] = this.parentDimensions;
  const savedX = this.x;
  const savedY = this.y;
  const savedWidth = this.width;
  const savedHeight = this.height;
  const minWidth = _AnnotationEditor.MIN_SIZE / parentWidth;
  const minHeight = _AnnotationEditor.MIN_SIZE / parentHeight;
  const rotationMatrix = editor_assertClassBrand(_AnnotationEditor_brand, this, _getRotationMatrix).call(this, this.rotation);
  const transf = (x, y) => [rotationMatrix[0] * x + rotationMatrix[2] * y, rotationMatrix[1] * x + rotationMatrix[3] * y];
  const invRotationMatrix = editor_assertClassBrand(_AnnotationEditor_brand, this, _getRotationMatrix).call(this, 360 - this.rotation);
  const invTransf = (x, y) => [invRotationMatrix[0] * x + invRotationMatrix[2] * y, invRotationMatrix[1] * x + invRotationMatrix[3] * y];
  let getPoint;
  let getOpposite;
  let isDiagonal = false;
  let isHorizontal = false;
  switch (name) {
    case "topLeft":
      isDiagonal = true;
      getPoint = (w, h) => [0, 0];
      getOpposite = (w, h) => [w, h];
      break;
    case "topMiddle":
      getPoint = (w, h) => [w / 2, 0];
      getOpposite = (w, h) => [w / 2, h];
      break;
    case "topRight":
      isDiagonal = true;
      getPoint = (w, h) => [w, 0];
      getOpposite = (w, h) => [0, h];
      break;
    case "middleRight":
      isHorizontal = true;
      getPoint = (w, h) => [w, h / 2];
      getOpposite = (w, h) => [0, h / 2];
      break;
    case "bottomRight":
      isDiagonal = true;
      getPoint = (w, h) => [w, h];
      getOpposite = (w, h) => [0, 0];
      break;
    case "bottomMiddle":
      getPoint = (w, h) => [w / 2, h];
      getOpposite = (w, h) => [w / 2, 0];
      break;
    case "bottomLeft":
      isDiagonal = true;
      getPoint = (w, h) => [0, h];
      getOpposite = (w, h) => [w, 0];
      break;
    case "middleLeft":
      isHorizontal = true;
      getPoint = (w, h) => [0, h / 2];
      getOpposite = (w, h) => [w, h / 2];
      break;
  }
  const point = getPoint(savedWidth, savedHeight);
  const oppositePoint = getOpposite(savedWidth, savedHeight);
  let transfOppositePoint = transf(...oppositePoint);
  const oppositeX = _AnnotationEditor._round(savedX + transfOppositePoint[0]);
  const oppositeY = _AnnotationEditor._round(savedY + transfOppositePoint[1]);
  let ratioX = 1;
  let ratioY = 1;
  let deltaX, deltaY;
  if (!event.fromKeyboard) {
    const {
      screenX,
      screenY
    } = event;
    const [lastScreenX, lastScreenY] = editor_classPrivateFieldGet(_lastPointerCoords, this);
    [deltaX, deltaY] = this.screenToPageTranslation(screenX - lastScreenX, screenY - lastScreenY);
    editor_classPrivateFieldGet(_lastPointerCoords, this)[0] = screenX;
    editor_classPrivateFieldGet(_lastPointerCoords, this)[1] = screenY;
  } else {
    ({
      deltaX,
      deltaY
    } = event);
  }
  [deltaX, deltaY] = invTransf(deltaX / parentWidth, deltaY / parentHeight);
  if (isDiagonal) {
    const oldDiag = Math.hypot(savedWidth, savedHeight);
    ratioX = ratioY = Math.max(Math.min(Math.hypot(oppositePoint[0] - point[0] - deltaX, oppositePoint[1] - point[1] - deltaY) / oldDiag, 1 / savedWidth, 1 / savedHeight), minWidth / savedWidth, minHeight / savedHeight);
  } else if (isHorizontal) {
    ratioX = MathClamp(Math.abs(oppositePoint[0] - point[0] - deltaX), minWidth, 1) / savedWidth;
  } else {
    ratioY = MathClamp(Math.abs(oppositePoint[1] - point[1] - deltaY), minHeight, 1) / savedHeight;
  }
  const newWidth = _AnnotationEditor._round(savedWidth * ratioX);
  const newHeight = _AnnotationEditor._round(savedHeight * ratioY);
  transfOppositePoint = transf(...getOpposite(newWidth, newHeight));
  const newX = oppositeX - transfOppositePoint[0];
  const newY = oppositeY - transfOppositePoint[1];
  editor_classPrivateFieldGet(_initialRect, this) || editor_classPrivateFieldSet(_initialRect, this, [this.x, this.y, this.width, this.height]);
  this.width = newWidth;
  this.height = newHeight;
  this.x = newX;
  this.y = newY;
  this.setDims(parentWidth * newWidth, parentHeight * newHeight);
  this.fixAndSetPosition();
  this._onResizing();
}
function _touchPinchStartCallback() {
  editor_classPrivateFieldSet(_savedDimensions, this, {
    savedX: this.x,
    savedY: this.y,
    savedWidth: this.width,
    savedHeight: this.height
  });
  editor_classPrivateFieldGet(editor_altText, this)?.toggle(false);
  this.parent.togglePointerEvents(false);
}
function _touchPinchCallback(_origin, prevDistance, distance) {
  const slowDownFactor = 0.7;
  let factor = slowDownFactor * (distance / prevDistance) + 1 - slowDownFactor;
  if (factor === 1) {
    return;
  }
  const rotationMatrix = editor_assertClassBrand(_AnnotationEditor_brand, this, _getRotationMatrix).call(this, this.rotation);
  const transf = (x, y) => [rotationMatrix[0] * x + rotationMatrix[2] * y, rotationMatrix[1] * x + rotationMatrix[3] * y];
  const [parentWidth, parentHeight] = this.parentDimensions;
  const savedX = this.x;
  const savedY = this.y;
  const savedWidth = this.width;
  const savedHeight = this.height;
  const minWidth = _AnnotationEditor.MIN_SIZE / parentWidth;
  const minHeight = _AnnotationEditor.MIN_SIZE / parentHeight;
  factor = Math.max(Math.min(factor, 1 / savedWidth, 1 / savedHeight), minWidth / savedWidth, minHeight / savedHeight);
  const newWidth = _AnnotationEditor._round(savedWidth * factor);
  const newHeight = _AnnotationEditor._round(savedHeight * factor);
  if (newWidth === savedWidth && newHeight === savedHeight) {
    return;
  }
  editor_classPrivateFieldGet(_initialRect, this) || editor_classPrivateFieldSet(_initialRect, this, [savedX, savedY, savedWidth, savedHeight]);
  const transfCenterPoint = transf(savedWidth / 2, savedHeight / 2);
  const centerX = _AnnotationEditor._round(savedX + transfCenterPoint[0]);
  const centerY = _AnnotationEditor._round(savedY + transfCenterPoint[1]);
  const newTransfCenterPoint = transf(newWidth / 2, newHeight / 2);
  this.x = centerX - newTransfCenterPoint[0];
  this.y = centerY - newTransfCenterPoint[1];
  this.width = newWidth;
  this.height = newHeight;
  this.setDims(parentWidth * newWidth, parentHeight * newHeight);
  this.fixAndSetPosition();
  this._onResizing();
}
function _touchPinchEndCallback() {
  editor_classPrivateFieldGet(editor_altText, this)?.toggle(true);
  this.parent.togglePointerEvents(true);
  editor_assertClassBrand(_AnnotationEditor_brand, this, _addResizeToUndoStack).call(this);
}
function _selectOnPointerEvent(event) {
  const {
    isMac
  } = util_FeatureTest.platform;
  if (event.ctrlKey && !isMac || event.shiftKey || event.metaKey && isMac) {
    this.parent.toggleSelected(this);
  } else {
    this.parent.setSelected(this);
  }
}
function _setUpDragSession(event) {
  const {
    isSelected
  } = this;
  this._uiManager.setUpDragSession();
  let hasDraggingStarted = false;
  const ac = new AbortController();
  const signal = this._uiManager.combinedSignal(ac);
  const opts = {
    capture: true,
    passive: false,
    signal
  };
  const cancelDrag = e => {
    ac.abort();
    editor_classPrivateFieldSet(_dragPointerId, this, null);
    editor_classPrivateFieldSet(_hasBeenClicked, this, false);
    if (!this._uiManager.endDragSession()) {
      editor_assertClassBrand(_AnnotationEditor_brand, this, _selectOnPointerEvent).call(this, e);
    }
    if (hasDraggingStarted) {
      this._onStopDragging();
    }
  };
  if (isSelected) {
    editor_classPrivateFieldSet(_prevDragX, this, event.clientX);
    editor_classPrivateFieldSet(_prevDragY, this, event.clientY);
    editor_classPrivateFieldSet(_dragPointerId, this, event.pointerId);
    editor_classPrivateFieldSet(_dragPointerType, this, event.pointerType);
    window.addEventListener("pointermove", e => {
      if (!hasDraggingStarted) {
        hasDraggingStarted = true;
        this._onStartDragging();
      }
      const {
        clientX: x,
        clientY: y,
        pointerId
      } = e;
      if (pointerId !== editor_classPrivateFieldGet(_dragPointerId, this)) {
        stopEvent(e);
        return;
      }
      const [tx, ty] = this.screenToPageTranslation(x - editor_classPrivateFieldGet(_prevDragX, this), y - editor_classPrivateFieldGet(_prevDragY, this));
      editor_classPrivateFieldSet(_prevDragX, this, x);
      editor_classPrivateFieldSet(_prevDragY, this, y);
      this._uiManager.dragSelectedEditors(tx, ty);
    }, opts);
    window.addEventListener("touchmove", stopEvent, opts);
    window.addEventListener("pointerdown", e => {
      if (e.pointerType === editor_classPrivateFieldGet(_dragPointerType, this)) {
        if (editor_classPrivateFieldGet(_touchManager, this) || e.isPrimary) {
          cancelDrag(e);
        }
      }
      stopEvent(e);
    }, opts);
  }
  const pointerUpCallback = e => {
    if (!editor_classPrivateFieldGet(_dragPointerId, this) || editor_classPrivateFieldGet(_dragPointerId, this) === e.pointerId) {
      cancelDrag(e);
      return;
    }
    stopEvent(e);
  };
  window.addEventListener("pointerup", pointerUpCallback, {
    signal
  });
  window.addEventListener("blur", pointerUpCallback, {
    signal
  });
}
function _addFocusListeners() {
  if (editor_classPrivateFieldGet(_focusAC, this) || !this.div) {
    return;
  }
  editor_classPrivateFieldSet(_focusAC, this, new AbortController());
  const signal = this._uiManager.combinedSignal(editor_classPrivateFieldGet(_focusAC, this));
  this.div.addEventListener("focusin", this.focusin.bind(this), {
    signal
  });
  this.div.addEventListener("focusout", this.focusout.bind(this), {
    signal
  });
}
function _resizerKeydown(event) {
  _AnnotationEditor._resizerKeyboardManager.exec(this, event);
}
function _resizerBlur(event) {
  if (editor_classPrivateFieldGet(_isResizerEnabledForKeyboard, this) && event.relatedTarget?.parentNode !== editor_classPrivateFieldGet(_resizersDiv, this)) {
    editor_assertClassBrand(_AnnotationEditor_brand, this, _stopResizing).call(this);
  }
}
function _resizerFocus(name) {
  editor_classPrivateFieldSet(_focusedResizerName, this, editor_classPrivateFieldGet(_isResizerEnabledForKeyboard, this) ? name : "");
}
function _setResizerTabIndex(value) {
  if (!editor_classPrivateFieldGet(_allResizerDivs, this)) {
    return;
  }
  for (const div of editor_classPrivateFieldGet(_allResizerDivs, this)) {
    div.tabIndex = value;
  }
}
function _stopResizing() {
  editor_classPrivateFieldSet(_isResizerEnabledForKeyboard, this, false);
  editor_assertClassBrand(_AnnotationEditor_brand, this, _setResizerTabIndex).call(this, -1);
  editor_assertClassBrand(_AnnotationEditor_brand, this, _addResizeToUndoStack).call(this);
}
editor_defineProperty(AnnotationEditor, "_l10n", null);
editor_defineProperty(AnnotationEditor, "_l10nResizer", null);
editor_defineProperty(AnnotationEditor, "_borderLineWidth", -1);
editor_defineProperty(AnnotationEditor, "_colorManager", new ColorManager());
editor_defineProperty(AnnotationEditor, "_zIndex", 1);
editor_defineProperty(AnnotationEditor, "_telemetryTimeout", 1000);
class FakeEditor extends AnnotationEditor {
  constructor(params) {
    super(params);
    this.annotationElementId = params.annotationElementId;
    this.deleted = true;
  }
  serialize() {
    return this.serializeDeleted();
  }
}

;// ./src/shared/murmurhash3.js

















const SEED = 0xc3d2e1f0;
const MASK_HIGH = 0xffff0000;
const MASK_LOW = 0xffff;
class MurmurHash3_64 {
  constructor(seed) {
    this.h1 = seed ? seed & 0xffffffff : SEED;
    this.h2 = seed ? seed & 0xffffffff : SEED;
  }
  update(input) {
    let data, length;
    if (typeof input === "string") {
      data = new Uint8Array(input.length * 2);
      length = 0;
      for (let i = 0, ii = input.length; i < ii; i++) {
        const code = input.charCodeAt(i);
        if (code <= 0xff) {
          data[length++] = code;
        } else {
          data[length++] = code >>> 8;
          data[length++] = code & 0xff;
        }
      }
    } else if (ArrayBuffer.isView(input)) {
      data = input.slice();
      length = data.byteLength;
    } else {
      throw new Error("Invalid data format, must be a string or TypedArray.");
    }
    const blockCounts = length >> 2;
    const tailLength = length - blockCounts * 4;
    const dataUint32 = new Uint32Array(data.buffer, 0, blockCounts);
    let k1 = 0,
      k2 = 0;
    let h1 = this.h1,
      h2 = this.h2;
    const C1 = 0xcc9e2d51,
      C2 = 0x1b873593;
    const C1_LOW = C1 & MASK_LOW,
      C2_LOW = C2 & MASK_LOW;
    for (let i = 0; i < blockCounts; i++) {
      if (i & 1) {
        k1 = dataUint32[i];
        k1 = k1 * C1 & MASK_HIGH | k1 * C1_LOW & MASK_LOW;
        k1 = k1 << 15 | k1 >>> 17;
        k1 = k1 * C2 & MASK_HIGH | k1 * C2_LOW & MASK_LOW;
        h1 ^= k1;
        h1 = h1 << 13 | h1 >>> 19;
        h1 = h1 * 5 + 0xe6546b64;
      } else {
        k2 = dataUint32[i];
        k2 = k2 * C1 & MASK_HIGH | k2 * C1_LOW & MASK_LOW;
        k2 = k2 << 15 | k2 >>> 17;
        k2 = k2 * C2 & MASK_HIGH | k2 * C2_LOW & MASK_LOW;
        h2 ^= k2;
        h2 = h2 << 13 | h2 >>> 19;
        h2 = h2 * 5 + 0xe6546b64;
      }
    }
    k1 = 0;
    switch (tailLength) {
      case 3:
        k1 ^= data[blockCounts * 4 + 2] << 16;
      case 2:
        k1 ^= data[blockCounts * 4 + 1] << 8;
      case 1:
        k1 ^= data[blockCounts * 4];
        k1 = k1 * C1 & MASK_HIGH | k1 * C1_LOW & MASK_LOW;
        k1 = k1 << 15 | k1 >>> 17;
        k1 = k1 * C2 & MASK_HIGH | k1 * C2_LOW & MASK_LOW;
        if (blockCounts & 1) {
          h1 ^= k1;
        } else {
          h2 ^= k1;
        }
    }
    this.h1 = h1;
    this.h2 = h2;
  }
  hexdigest() {
    let h1 = this.h1,
      h2 = this.h2;
    h1 ^= h2 >>> 1;
    h1 = h1 * 0xed558ccd & MASK_HIGH | h1 * 0x8ccd & MASK_LOW;
    h2 = h2 * 0xff51afd7 & MASK_HIGH | ((h2 << 16 | h1 >>> 16) * 0xafd7ed55 & MASK_HIGH) >>> 16;
    h1 ^= h2 >>> 1;
    h1 = h1 * 0x1a85ec53 & MASK_HIGH | h1 * 0xec53 & MASK_LOW;
    h2 = h2 * 0xc4ceb9fe & MASK_HIGH | ((h2 << 16 | h1 >>> 16) * 0xb9fe1a85 & MASK_HIGH) >>> 16;
    h1 ^= h2 >>> 1;
    return (h1 >>> 0).toString(16).padStart(8, "0") + (h2 >>> 0).toString(16).padStart(8, "0");
  }
}

;// ./src/display/annotation_storage.js












function annotation_storage_classPrivateMethodInitSpec(e, a) { annotation_storage_checkPrivateRedeclaration(e, a), a.add(e); }
function annotation_storage_classPrivateFieldInitSpec(e, t, a) { annotation_storage_checkPrivateRedeclaration(e, t), t.set(e, a); }
function annotation_storage_checkPrivateRedeclaration(e, t) { if (t.has(e)) throw new TypeError("Cannot initialize the same private elements twice on an object"); }
function annotation_storage_classPrivateFieldSet(s, a, r) { return s.set(annotation_storage_assertClassBrand(s, a), r), r; }
function annotation_storage_classPrivateFieldGet(s, a) { return s.get(annotation_storage_assertClassBrand(s, a)); }
function annotation_storage_assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); }



const SerializableEmpty = Object.freeze({
  map: null,
  hash: "",
  transfer: undefined
});
var _modified = /*#__PURE__*/new WeakMap();
var _modifiedIds = /*#__PURE__*/new WeakMap();
var _storage = /*#__PURE__*/new WeakMap();
var _AnnotationStorage_brand = /*#__PURE__*/new WeakSet();
class AnnotationStorage {
  constructor() {
    annotation_storage_classPrivateMethodInitSpec(this, _AnnotationStorage_brand);
    annotation_storage_classPrivateFieldInitSpec(this, _modified, false);
    annotation_storage_classPrivateFieldInitSpec(this, _modifiedIds, null);
    annotation_storage_classPrivateFieldInitSpec(this, _storage, new Map());
    this.onSetModified = null;
    this.onResetModified = null;
    this.onAnnotationEditor = null;
  }
  getValue(key, defaultValue) {
    const value = annotation_storage_classPrivateFieldGet(_storage, this).get(key);
    if (value === undefined) {
      return defaultValue;
    }
    return Object.assign(defaultValue, value);
  }
  getRawValue(key) {
    return annotation_storage_classPrivateFieldGet(_storage, this).get(key);
  }
  remove(key) {
    annotation_storage_classPrivateFieldGet(_storage, this).delete(key);
    if (annotation_storage_classPrivateFieldGet(_storage, this).size === 0) {
      this.resetModified();
    }
    if (typeof this.onAnnotationEditor === "function") {
      for (const value of annotation_storage_classPrivateFieldGet(_storage, this).values()) {
        if (value instanceof AnnotationEditor) {
          return;
        }
      }
      this.onAnnotationEditor(null);
    }
  }
  setValue(key, value) {
    const obj = annotation_storage_classPrivateFieldGet(_storage, this).get(key);
    let modified = false;
    if (obj !== undefined) {
      for (const [entry, val] of Object.entries(value)) {
        if (obj[entry] !== val) {
          modified = true;
          obj[entry] = val;
        }
      }
    } else {
      modified = true;
      annotation_storage_classPrivateFieldGet(_storage, this).set(key, value);
    }
    if (modified) {
      annotation_storage_assertClassBrand(_AnnotationStorage_brand, this, _setModified).call(this);
    }
    if (value instanceof AnnotationEditor && typeof this.onAnnotationEditor === "function") {
      this.onAnnotationEditor(value.constructor._type);
    }
  }
  has(key) {
    return annotation_storage_classPrivateFieldGet(_storage, this).has(key);
  }
  get size() {
    return annotation_storage_classPrivateFieldGet(_storage, this).size;
  }
  resetModified() {
    if (annotation_storage_classPrivateFieldGet(_modified, this)) {
      annotation_storage_classPrivateFieldSet(_modified, this, false);
      if (typeof this.onResetModified === "function") {
        this.onResetModified();
      }
    }
  }
  get print() {
    return new PrintAnnotationStorage(this);
  }
  get serializable() {
    if (annotation_storage_classPrivateFieldGet(_storage, this).size === 0) {
      return SerializableEmpty;
    }
    const map = new Map(),
      hash = new MurmurHash3_64(),
      transfer = [];
    const context = Object.create(null);
    let hasBitmap = false;
    for (const [key, val] of annotation_storage_classPrivateFieldGet(_storage, this)) {
      const serialized = val instanceof AnnotationEditor ? val.serialize(false, context) : val;
      if (serialized) {
        map.set(key, serialized);
        hash.update(`${key}:${JSON.stringify(serialized)}`);
        hasBitmap ||= !!serialized.bitmap;
      }
    }
    if (hasBitmap) {
      for (const value of map.values()) {
        if (value.bitmap) {
          transfer.push(value.bitmap);
        }
      }
    }
    return map.size > 0 ? {
      map,
      hash: hash.hexdigest(),
      transfer
    } : SerializableEmpty;
  }
  get editorStats() {
    let stats = null;
    const typeToEditor = new Map();
    for (const value of annotation_storage_classPrivateFieldGet(_storage, this).values()) {
      if (!(value instanceof AnnotationEditor)) {
        continue;
      }
      const editorStats = value.telemetryFinalData;
      if (!editorStats) {
        continue;
      }
      const {
        type
      } = editorStats;
      if (!typeToEditor.has(type)) {
        typeToEditor.set(type, Object.getPrototypeOf(value).constructor);
      }
      stats ||= Object.create(null);
      const map = stats[type] ||= new Map();
      for (const [key, val] of Object.entries(editorStats)) {
        if (key === "type") {
          continue;
        }
        let counters = map.get(key);
        if (!counters) {
          counters = new Map();
          map.set(key, counters);
        }
        const count = counters.get(val) ?? 0;
        counters.set(val, count + 1);
      }
    }
    for (const [type, editor] of typeToEditor) {
      stats[type] = editor.computeTelemetryFinalData(stats[type]);
    }
    return stats;
  }
  resetModifiedIds() {
    annotation_storage_classPrivateFieldSet(_modifiedIds, this, null);
  }
  get modifiedIds() {
    if (annotation_storage_classPrivateFieldGet(_modifiedIds, this)) {
      return annotation_storage_classPrivateFieldGet(_modifiedIds, this);
    }
    const ids = [];
    for (const value of annotation_storage_classPrivateFieldGet(_storage, this).values()) {
      if (!(value instanceof AnnotationEditor) || !value.annotationElementId || !value.serialize()) {
        continue;
      }
      ids.push(value.annotationElementId);
    }
    return annotation_storage_classPrivateFieldSet(_modifiedIds, this, {
      ids: new Set(ids),
      hash: ids.join(",")
    });
  }
  [Symbol.iterator]() {
    return annotation_storage_classPrivateFieldGet(_storage, this).entries();
  }
}
function _setModified() {
  if (!annotation_storage_classPrivateFieldGet(_modified, this)) {
    annotation_storage_classPrivateFieldSet(_modified, this, true);
    if (typeof this.onSetModified === "function") {
      this.onSetModified();
    }
  }
}
var _serializable = /*#__PURE__*/new WeakMap();
class PrintAnnotationStorage extends AnnotationStorage {
  constructor(parent) {
    super();
    annotation_storage_classPrivateFieldInitSpec(this, _serializable, void 0);
    const {
      map,
      hash,
      transfer
    } = parent.serializable;
    const clone = structuredClone(map, transfer ? {
      transfer
    } : null);
    annotation_storage_classPrivateFieldSet(_serializable, this, {
      map: clone,
      hash,
      transfer
    });
  }
  get print() {
    unreachable("Should not call PrintAnnotationStorage.print");
  }
  get serializable() {
    return annotation_storage_classPrivateFieldGet(_serializable, this);
  }
  get modifiedIds() {
    return shadow(this, "modifiedIds", {
      ids: new Set(),
      hash: ""
    });
  }
}

;// ./src/display/font_loader.js










function font_loader_classPrivateFieldInitSpec(e, t, a) { font_loader_checkPrivateRedeclaration(e, t), t.set(e, a); }
function font_loader_checkPrivateRedeclaration(e, t) { if (t.has(e)) throw new TypeError("Cannot initialize the same private elements twice on an object"); }
function font_loader_classPrivateFieldGet(s, a) { return s.get(font_loader_assertClassBrand(s, a)); }
function font_loader_assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); }

var _systemFonts = /*#__PURE__*/new WeakMap();
class FontLoader {
  constructor(_ref) {
    let {
      ownerDocument = globalThis.document,
      styleElement = null
    } = _ref;
    font_loader_classPrivateFieldInitSpec(this, _systemFonts, new Set());
    this._document = ownerDocument;
    this.nativeFontFaces = new Set();
    this.styleElement = null;
    this.loadingRequests = [];
    this.loadTestFontId = 0;
  }
  addNativeFontFace(nativeFontFace) {
    this.nativeFontFaces.add(nativeFontFace);
    this._document.fonts.add(nativeFontFace);
  }
  removeNativeFontFace(nativeFontFace) {
    this.nativeFontFaces.delete(nativeFontFace);
    this._document.fonts.delete(nativeFontFace);
  }
  insertRule(rule) {
    if (!this.styleElement) {
      this.styleElement = this._document.createElement("style");
      this._document.documentElement.getElementsByTagName("head")[0].append(this.styleElement);
    }
    const styleSheet = this.styleElement.sheet;
    styleSheet.insertRule(rule, styleSheet.cssRules.length);
  }
  clear() {
    for (const nativeFontFace of this.nativeFontFaces) {
      this._document.fonts.delete(nativeFontFace);
    }
    this.nativeFontFaces.clear();
    font_loader_classPrivateFieldGet(_systemFonts, this).clear();
    if (this.styleElement) {
      this.styleElement.remove();
      this.styleElement = null;
    }
  }
  async loadSystemFont(_ref2) {
    let {
      systemFontInfo: info,
      disableFontFace,
      _inspectFont
    } = _ref2;
    if (!info || font_loader_classPrivateFieldGet(_systemFonts, this).has(info.loadedName)) {
      return;
    }
    assert(!disableFontFace, "loadSystemFont shouldn't be called when `disableFontFace` is set.");
    if (this.isFontLoadingAPISupported) {
      const {
        loadedName,
        src,
        style
      } = info;
      const fontFace = new FontFace(loadedName, src, style);
      this.addNativeFontFace(fontFace);
      try {
        await fontFace.load();
        font_loader_classPrivateFieldGet(_systemFonts, this).add(loadedName);
        _inspectFont?.(info);
      } catch {
        warn(`Cannot load system font: ${info.baseFontName}, installing it could help to improve PDF rendering.`);
        this.removeNativeFontFace(fontFace);
      }
      return;
    }
    unreachable("Not implemented: loadSystemFont without the Font Loading API.");
  }
  async bind(font) {
    if (font.attached || font.missingFile && !font.systemFontInfo) {
      return;
    }
    font.attached = true;
    if (font.systemFontInfo) {
      await this.loadSystemFont(font);
      return;
    }
    if (this.isFontLoadingAPISupported) {
      const nativeFontFace = font.createNativeFontFace();
      if (nativeFontFace) {
        this.addNativeFontFace(nativeFontFace);
        try {
          await nativeFontFace.loaded;
        } catch (ex) {
          warn(`Failed to load font '${nativeFontFace.family}': '${ex}'.`);
          font.disableFontFace = true;
          throw ex;
        }
      }
      return;
    }
    const rule = font.createFontFaceRule();
    if (rule) {
      this.insertRule(rule);
      if (this.isSyncFontLoadingSupported) {
        return;
      }
      await new Promise(resolve => {
        const request = this._queueLoadingCallback(resolve);
        this._prepareFontLoadEvent(font, request);
      });
    }
  }
  get isFontLoadingAPISupported() {
    const hasFonts = !!this._document?.fonts;
    return shadow(this, "isFontLoadingAPISupported", hasFonts);
  }
  get isSyncFontLoadingSupported() {
    return shadow(this, "isSyncFontLoadingSupported", isNodeJS || util_FeatureTest.platform.isFirefox);
  }
  _queueLoadingCallback(callback) {
    function completeRequest() {
      assert(!request.done, "completeRequest() cannot be called twice.");
      request.done = true;
      while (loadingRequests.length > 0 && loadingRequests[0].done) {
        const otherRequest = loadingRequests.shift();
        setTimeout(otherRequest.callback, 0);
      }
    }
    const {
      loadingRequests
    } = this;
    const request = {
      done: false,
      complete: completeRequest,
      callback
    };
    loadingRequests.push(request);
    return request;
  }
  get _loadTestFont() {
    const testFont = atob("T1RUTwALAIAAAwAwQ0ZGIDHtZg4AAAOYAAAAgUZGVE1lkzZwAAAEHAAAABxHREVGABQA" + "FQAABDgAAAAeT1MvMlYNYwkAAAEgAAAAYGNtYXABDQLUAAACNAAAAUJoZWFk/xVFDQAA" + "ALwAAAA2aGhlYQdkA+oAAAD0AAAAJGhtdHgD6AAAAAAEWAAAAAZtYXhwAAJQAAAAARgA" + "AAAGbmFtZVjmdH4AAAGAAAAAsXBvc3T/hgAzAAADeAAAACAAAQAAAAEAALZRFsRfDzz1" + "AAsD6AAAAADOBOTLAAAAAM4KHDwAAAAAA+gDIQAAAAgAAgAAAAAAAAABAAADIQAAAFoD" + "6AAAAAAD6AABAAAAAAAAAAAAAAAAAAAAAQAAUAAAAgAAAAQD6AH0AAUAAAKKArwAAACM" + "AooCvAAAAeAAMQECAAACAAYJAAAAAAAAAAAAAQAAAAAAAAAAAAAAAFBmRWQAwAAuAC4D" + "IP84AFoDIQAAAAAAAQAAAAAAAAAAACAAIAABAAAADgCuAAEAAAAAAAAAAQAAAAEAAAAA" + "AAEAAQAAAAEAAAAAAAIAAQAAAAEAAAAAAAMAAQAAAAEAAAAAAAQAAQAAAAEAAAAAAAUA" + "AQAAAAEAAAAAAAYAAQAAAAMAAQQJAAAAAgABAAMAAQQJAAEAAgABAAMAAQQJAAIAAgAB" + "AAMAAQQJAAMAAgABAAMAAQQJAAQAAgABAAMAAQQJAAUAAgABAAMAAQQJAAYAAgABWABY" + "AAAAAAAAAwAAAAMAAAAcAAEAAAAAADwAAwABAAAAHAAEACAAAAAEAAQAAQAAAC7//wAA" + "AC7////TAAEAAAAAAAABBgAAAQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" + "AAAAAAAAAAAAAAAAAAEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" + "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" + "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" + "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA" + "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAMAAAAAAAD/gwAyAAAAAQAAAAAAAAAAAAAAAAAA" + "AAABAAQEAAEBAQJYAAEBASH4DwD4GwHEAvgcA/gXBIwMAYuL+nz5tQXkD5j3CBLnEQAC" + "AQEBIVhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYAAABAQAADwACAQEEE/t3" + "Dov6fAH6fAT+fPp8+nwHDosMCvm1Cvm1DAz6fBQAAAAAAAABAAAAAMmJbzEAAAAAzgTj" + "FQAAAADOBOQpAAEAAAAAAAAADAAUAAQAAAABAAAAAgABAAAAAAAAAAAD6AAAAAAAAA==");
    return shadow(this, "_loadTestFont", testFont);
  }
  _prepareFontLoadEvent(font, request) {
    function int32(data, offset) {
      return data.charCodeAt(offset) << 24 | data.charCodeAt(offset + 1) << 16 | data.charCodeAt(offset + 2) << 8 | data.charCodeAt(offset + 3) & 0xff;
    }
    function spliceString(s, offset, remove, insert) {
      const chunk1 = s.substring(0, offset);
      const chunk2 = s.substring(offset + remove);
      return chunk1 + insert + chunk2;
    }
    let i, ii;
    const canvas = this._document.createElement("canvas");
    canvas.width = 1;
    canvas.height = 1;
    const ctx = canvas.getContext("2d");
    let called = 0;
    function isFontReady(name, callback) {
      if (++called > 30) {
        warn("Load test font never loaded.");
        callback();
        return;
      }
      ctx.font = "30px " + name;
      ctx.fillText(".", 0, 20);
      const imageData = ctx.getImageData(0, 0, 1, 1);
      if (imageData.data[3] > 0) {
        callback();
        return;
      }
      setTimeout(isFontReady.bind(null, name, callback));
    }
    const loadTestFontId = `lt${Date.now()}${this.loadTestFontId++}`;
    let data = this._loadTestFont;
    const COMMENT_OFFSET = 976;
    data = spliceString(data, COMMENT_OFFSET, loadTestFontId.length, loadTestFontId);
    const CFF_CHECKSUM_OFFSET = 16;
    const XXXX_VALUE = 0x58585858;
    let checksum = int32(data, CFF_CHECKSUM_OFFSET);
    for (i = 0, ii = loadTestFontId.length - 3; i < ii; i += 4) {
      checksum = checksum - XXXX_VALUE + int32(loadTestFontId, i) | 0;
    }
    if (i < loadTestFontId.length) {
      checksum = checksum - XXXX_VALUE + int32(loadTestFontId + "XXX", i) | 0;
    }
    data = spliceString(data, CFF_CHECKSUM_OFFSET, 4, string32(checksum));
    const url = `url(data:font/opentype;base64,${btoa(data)});`;
    const rule = `@font-face {font-family:"${loadTestFontId}";src:${url}}`;
    this.insertRule(rule);
    const div = this._document.createElement("div");
    div.style.visibility = "hidden";
    div.style.width = div.style.height = "10px";
    div.style.position = "absolute";
    div.style.top = div.style.left = "0px";
    for (const name of [font.loadedName, loadTestFontId]) {
      const span = this._document.createElement("span");
      span.textContent = "Hi";
      span.style.fontFamily = name;
      div.append(span);
    }
    this._document.body.append(div);
    isFontReady(loadTestFontId, () => {
      div.remove();
      request.complete();
    });
  }
}
class FontFaceObject {
  constructor(translatedData) {
    let inspectFont = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
    this.compiledGlyphs = Object.create(null);
    for (const i in translatedData) {
      this[i] = translatedData[i];
    }
    this._inspectFont = inspectFont;
  }
  createNativeFontFace() {
    if (!this.data || this.disableFontFace) {
      return null;
    }
    let nativeFontFace;
    if (!this.cssFontInfo) {
      nativeFontFace = new FontFace(this.loadedName, this.data, {});
    } else {
      const css = {
        weight: this.cssFontInfo.fontWeight
      };
      if (this.cssFontInfo.italicAngle) {
        css.style = `oblique ${this.cssFontInfo.italicAngle}deg`;
      }
      nativeFontFace = new FontFace(this.cssFontInfo.fontFamily, this.data, css);
    }
    this._inspectFont?.(this);
    return nativeFontFace;
  }
  createFontFaceRule() {
    if (!this.data || this.disableFontFace) {
      return null;
    }
    const url = `url(data:${this.mimetype};base64,${toBase64Util(this.data)});`;
    let rule;
    if (!this.cssFontInfo) {
      rule = `@font-face {font-family:"${this.loadedName}";src:${url}}`;
    } else {
      let css = `font-weight: ${this.cssFontInfo.fontWeight};`;
      if (this.cssFontInfo.italicAngle) {
        css += `font-style: oblique ${this.cssFontInfo.italicAngle}deg;`;
      }
      rule = `@font-face {font-family:"${this.cssFontInfo.fontFamily}";${css}src:${url}}`;
    }
    this._inspectFont?.(this, url);
    return rule;
  }
  getPathGenerator(objs, character) {
    if (this.compiledGlyphs[character] !== undefined) {
      return this.compiledGlyphs[character];
    }
    const objId = this.loadedName + "_path_" + character;
    let cmds;
    try {
      cmds = objs.get(objId);
    } catch (ex) {
      warn(`getPathGenerator - ignoring character: "${ex}".`);
    }
    const path = new Path2D(cmds || "");
    if (!this.fontExtraProperties) {
      objs.delete(objId);
    }
    return this.compiledGlyphs[character] = path;
  }
}

;// ./src/display/api_utils.js
function api_utils_classPrivateFieldInitSpec(e, t, a) { api_utils_checkPrivateRedeclaration(e, t), t.set(e, a); }
function api_utils_checkPrivateRedeclaration(e, t) { if (t.has(e)) throw new TypeError("Cannot initialize the same private elements twice on an object"); }
function api_utils_classPrivateFieldGet(s, a) { return s.get(api_utils_assertClassBrand(s, a)); }
function api_utils_assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); }























function getUrlProp(val, baseHref) {
  if (val instanceof URL) {
    return val.href;
  }
  if (typeof val === "string") {
    if (isNodeJS) {
      return val;
    }
    if (baseHref) {
      return new URL(val, window.location.origin + baseHref).href;
    }
    const url = URL.parse(val, window.location);
    if (url) {
      return url.href;
    }
  }
  throw new Error("Invalid PDF url data: " + "either string or URL-object is expected in the url property.");
}
function getDataProp(val) {
  if (isNodeJS && typeof Buffer !== "undefined" && val instanceof Buffer) {
    throw new Error("Please provide binary data as `Uint8Array`, rather than `Buffer`.");
  }
  if (val instanceof Uint8Array && val.byteLength === val.buffer.byteLength) {
    return val;
  }
  if (typeof val === "string") {
    return stringToBytes(val);
  }
  if (val instanceof ArrayBuffer || ArrayBuffer.isView(val) || typeof val === "object" && !isNaN(val?.length)) {
    return new Uint8Array(val);
  }
  throw new Error("Invalid PDF binary data: either TypedArray, " + "string, or array-like object is expected in the data property.");
}
function getFactoryUrlProp(val) {
  if (typeof val !== "string") {
    return null;
  }
  if (val.endsWith("/")) {
    return val;
  }
  throw new Error(`Invalid factory url: "${val}" must include trailing slash.`);
}
const isRefProxy = v => typeof v === "object" && Number.isInteger(v?.num) && v.num >= 0 && Number.isInteger(v?.gen) && v.gen >= 0;
const isNameProxy = v => typeof v === "object" && typeof v?.name === "string";
const isValidExplicitDest = _isValidExplicitDest.bind(null, isRefProxy, isNameProxy);
var _listeners = /*#__PURE__*/new WeakMap();
var _deferred = /*#__PURE__*/new WeakMap();
class LoopbackPort {
  constructor() {
    api_utils_classPrivateFieldInitSpec(this, _listeners, new Map());
    api_utils_classPrivateFieldInitSpec(this, _deferred, Promise.resolve());
  }
  postMessage(obj, transfer) {
    const event = {
      data: structuredClone(obj, transfer ? {
        transfer
      } : null)
    };
    api_utils_classPrivateFieldGet(_deferred, this).then(() => {
      for (const [listener] of api_utils_classPrivateFieldGet(_listeners, this)) {
        listener.call(this, event);
      }
    });
  }
  addEventListener(name, listener) {
    let options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
    let rmAbort = null;
    if (options?.signal instanceof AbortSignal) {
      const {
        signal
      } = options;
      if (signal.aborted) {
        warn("LoopbackPort - cannot use an `aborted` signal.");
        return;
      }
      const onAbort = () => this.removeEventListener(name, listener);
      rmAbort = () => signal.removeEventListener("abort", onAbort);
      signal.addEventListener("abort", onAbort);
    }
    api_utils_classPrivateFieldGet(_listeners, this).set(listener, rmAbort);
  }
  removeEventListener(name, listener) {
    const rmAbort = api_utils_classPrivateFieldGet(_listeners, this).get(listener);
    rmAbort?.();
    api_utils_classPrivateFieldGet(_listeners, this).delete(listener);
  }
  terminate() {
    for (const [, rmAbort] of api_utils_classPrivateFieldGet(_listeners, this)) {
      rmAbort?.();
    }
    api_utils_classPrivateFieldGet(_listeners, this).clear();
  }
}

;// ./src/shared/message_handler.js
function message_handler_classPrivateMethodInitSpec(e, a) { message_handler_checkPrivateRedeclaration(e, a), a.add(e); }
function message_handler_classPrivateFieldInitSpec(e, t, a) { message_handler_checkPrivateRedeclaration(e, t), t.set(e, a); }
function message_handler_checkPrivateRedeclaration(e, t) { if (t.has(e)) throw new TypeError("Cannot initialize the same private elements twice on an object"); }
function message_handler_classPrivateFieldSet(s, a, r) { return s.set(message_handler_assertClassBrand(s, a), r), r; }
function message_handler_classPrivateFieldGet(s, a) { return s.get(message_handler_assertClassBrand(s, a)); }
function message_handler_assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); }




const CallbackKind = {
  DATA: 1,
  ERROR: 2
};
const StreamKind = {
  CANCEL: 1,
  CANCEL_COMPLETE: 2,
  CLOSE: 3,
  ENQUEUE: 4,
  ERROR: 5,
  PULL: 6,
  PULL_COMPLETE: 7,
  START_COMPLETE: 8
};
function onFn() {}
function wrapReason(ex) {
  if (ex instanceof AbortException || ex instanceof InvalidPDFException || ex instanceof PasswordException || ex instanceof ResponseException || ex instanceof UnknownErrorException) {
    return ex;
  }
  if (!(ex instanceof Error || typeof ex === "object" && ex !== null)) {
    unreachable('wrapReason: Expected "reason" to be a (possibly cloned) Error.');
  }
  switch (ex.name) {
    case "AbortException":
      return new AbortException(ex.message);
    case "InvalidPDFException":
      return new InvalidPDFException(ex.message);
    case "PasswordException":
      return new PasswordException(ex.message, ex.code);
    case "ResponseException":
      return new ResponseException(ex.message, ex.status, ex.missing);
    case "UnknownErrorException":
      return new UnknownErrorException(ex.message, ex.details);
  }
  return new UnknownErrorException(ex.message, ex.toString());
}
var _messageAC = /*#__PURE__*/new WeakMap();
var _MessageHandler_brand = /*#__PURE__*/new WeakSet();
class MessageHandler {
  constructor(_sourceName, _targetName, _comObj) {
    message_handler_classPrivateMethodInitSpec(this, _MessageHandler_brand);
    message_handler_classPrivateFieldInitSpec(this, _messageAC, new AbortController());
    this.sourceName = _sourceName;
    this.targetName = _targetName;
    this.comObj = _comObj;
    this.callbackId = 1;
    this.streamId = 1;
    this.streamSinks = Object.create(null);
    this.streamControllers = Object.create(null);
    this.callbackCapabilities = Object.create(null);
    this.actionHandler = Object.create(null);
    _comObj.addEventListener("message", message_handler_assertClassBrand(_MessageHandler_brand, this, _onMessage).bind(this), {
      signal: message_handler_classPrivateFieldGet(_messageAC, this).signal
    });
  }
  on(actionName, handler) {
    const ah = this.actionHandler;
    if (ah[actionName]) {
      throw new Error(`There is already an actionName called "${actionName}"`);
    }
    ah[actionName] = handler;
  }
  send(actionName, data, transfers) {
    this.comObj.postMessage({
      sourceName: this.sourceName,
      targetName: this.targetName,
      action: actionName,
      data
    }, transfers);
  }
  sendWithPromise(actionName, data, transfers) {
    const callbackId = this.callbackId++;
    const capability = Promise.withResolvers();
    this.callbackCapabilities[callbackId] = capability;
    try {
      this.comObj.postMessage({
        sourceName: this.sourceName,
        targetName: this.targetName,
        action: actionName,
        callbackId,
        data
      }, transfers);
    } catch (ex) {
      capability.reject(ex);
    }
    return capability.promise;
  }
  sendWithStream(actionName, data, queueingStrategy, transfers) {
    const streamId = this.streamId++,
      sourceName = this.sourceName,
      targetName = this.targetName,
      comObj = this.comObj;
    return new ReadableStream({
      start: controller => {
        const startCapability = Promise.withResolvers();
        this.streamControllers[streamId] = {
          controller,
          startCall: startCapability,
          pullCall: null,
          cancelCall: null,
          isClosed: false
        };
        comObj.postMessage({
          sourceName,
          targetName,
          action: actionName,
          streamId,
          data,
          desiredSize: controller.desiredSize
        }, transfers);
        return startCapability.promise;
      },
      pull: controller => {
        const pullCapability = Promise.withResolvers();
        this.streamControllers[streamId].pullCall = pullCapability;
        comObj.postMessage({
          sourceName,
          targetName,
          stream: StreamKind.PULL,
          streamId,
          desiredSize: controller.desiredSize
        });
        return pullCapability.promise;
      },
      cancel: reason => {
        assert(reason instanceof Error, "cancel must have a valid reason");
        const cancelCapability = Promise.withResolvers();
        this.streamControllers[streamId].cancelCall = cancelCapability;
        this.streamControllers[streamId].isClosed = true;
        comObj.postMessage({
          sourceName,
          targetName,
          stream: StreamKind.CANCEL,
          streamId,
          reason: wrapReason(reason)
        });
        return cancelCapability.promise;
      }
    }, queueingStrategy);
  }
  destroy() {
    message_handler_classPrivateFieldGet(_messageAC, this)?.abort();
    message_handler_classPrivateFieldSet(_messageAC, this, null);
  }
}
function _onMessage(_ref) {
  let {
    data
  } = _ref;
  if (data.targetName !== this.sourceName) {
    return;
  }
  if (data.stream) {
    message_handler_assertClassBrand(_MessageHandler_brand, this, _processStreamMessage).call(this, data);
    return;
  }
  if (data.callback) {
    const callbackId = data.callbackId;
    const capability = this.callbackCapabilities[callbackId];
    if (!capability) {
      throw new Error(`Cannot resolve callback ${callbackId}`);
    }
    delete this.callbackCapabilities[callbackId];
    if (data.callback === CallbackKind.DATA) {
      capability.resolve(data.data);
    } else if (data.callback === CallbackKind.ERROR) {
      capability.reject(wrapReason(data.reason));
    } else {
      throw new Error("Unexpected callback case");
    }
    return;
  }
  const action = this.actionHandler[data.action];
  if (!action) {
    throw new Error(`Unknown action from worker: ${data.action}`);
  }
  if (data.callbackId) {
    const sourceName = this.sourceName,
      targetName = data.sourceName,
      comObj = this.comObj;
    Promise.try(action, data.data).then(function (result) {
      comObj.postMessage({
        sourceName,
        targetName,
        callback: CallbackKind.DATA,
        callbackId: data.callbackId,
        data: result
      });
    }, function (reason) {
      comObj.postMessage({
        sourceName,
        targetName,
        callback: CallbackKind.ERROR,
        callbackId: data.callbackId,
        reason: wrapReason(reason)
      });
    });
    return;
  }
  if (data.streamId) {
    message_handler_assertClassBrand(_MessageHandler_brand, this, _createStreamSink).call(this, data);
    return;
  }
  action(data.data);
}
function _createStreamSink(data) {
  const streamId = data.streamId,
    sourceName = this.sourceName,
    targetName = data.sourceName,
    comObj = this.comObj;
  const self = this,
    action = this.actionHandler[data.action];
  const streamSink = {
    enqueue(chunk) {
      let size = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 1;
      let transfers = arguments.length > 2 ? arguments[2] : undefined;
      if (this.isCancelled) {
        return;
      }
      const lastDesiredSize = this.desiredSize;
      this.desiredSize -= size;
      if (lastDesiredSize > 0 && this.desiredSize <= 0) {
        this.sinkCapability = Promise.withResolvers();
        this.ready = this.sinkCapability.promise;
      }
      comObj.postMessage({
        sourceName,
        targetName,
        stream: StreamKind.ENQUEUE,
        streamId,
        chunk
      }, transfers);
    },
    close() {
      if (this.isCancelled) {
        return;
      }
      this.isCancelled = true;
      comObj.postMessage({
        sourceName,
        targetName,
        stream: StreamKind.CLOSE,
        streamId
      });
      delete self.streamSinks[streamId];
    },
    error(reason) {
      assert(reason instanceof Error, "error must have a valid reason");
      if (this.isCancelled) {
        return;
      }
      this.isCancelled = true;
      comObj.postMessage({
        sourceName,
        targetName,
        stream: StreamKind.ERROR,
        streamId,
        reason: wrapReason(reason)
      });
    },
    sinkCapability: Promise.withResolvers(),
    onPull: null,
    onCancel: null,
    isCancelled: false,
    desiredSize: data.desiredSize,
    ready: null
  };
  streamSink.sinkCapability.resolve();
  streamSink.ready = streamSink.sinkCapability.promise;
  this.streamSinks[streamId] = streamSink;
  Promise.try(action, data.data, streamSink).then(function () {
    comObj.postMessage({
      sourceName,
      targetName,
      stream: StreamKind.START_COMPLETE,
      streamId,
      success: true
    });
  }, function (reason) {
    comObj.postMessage({
      sourceName,
      targetName,
      stream: StreamKind.START_COMPLETE,
      streamId,
      reason: wrapReason(reason)
    });
  });
}
function _processStreamMessage(data) {
  const streamId = data.streamId,
    sourceName = this.sourceName,
    targetName = data.sourceName,
    comObj = this.comObj;
  const streamController = this.streamControllers[streamId],
    streamSink = this.streamSinks[streamId];
  switch (data.stream) {
    case StreamKind.START_COMPLETE:
      if (data.success) {
        streamController.startCall.resolve();
      } else {
        streamController.startCall.reject(wrapReason(data.reason));
      }
      break;
    case StreamKind.PULL_COMPLETE:
      if (data.success) {
        streamController.pullCall.resolve();
      } else {
        streamController.pullCall.reject(wrapReason(data.reason));
      }
      break;
    case StreamKind.PULL:
      if (!streamSink) {
        comObj.postMessage({
          sourceName,
          targetName,
          stream: StreamKind.PULL_COMPLETE,
          streamId,
          success: true
        });
        break;
      }
      if (streamSink.desiredSize <= 0 && data.desiredSize > 0) {
        streamSink.sinkCapability.resolve();
      }
      streamSink.desiredSize = data.desiredSize;
      Promise.try(streamSink.onPull || onFn).then(function () {
        comObj.postMessage({
          sourceName,
          targetName,
          stream: StreamKind.PULL_COMPLETE,
          streamId,
          success: true
        });
      }, function (reason) {
        comObj.postMessage({
          sourceName,
          targetName,
          stream: StreamKind.PULL_COMPLETE,
          streamId,
          reason: wrapReason(reason)
        });
      });
      break;
    case StreamKind.ENQUEUE:
      assert(streamController, "enqueue should have stream controller");
      if (streamController.isClosed) {
        break;
      }
      streamController.controller.enqueue(data.chunk);
      break;
    case StreamKind.CLOSE:
      assert(streamController, "close should have stream controller");
      if (streamController.isClosed) {
        break;
      }
      streamController.isClosed = true;
      streamController.controller.close();
      message_handler_assertClassBrand(_MessageHandler_brand, this, _deleteStreamController).call(this, streamController, streamId);
      break;
    case StreamKind.ERROR:
      assert(streamController, "error should have stream controller");
      streamController.controller.error(wrapReason(data.reason));
      message_handler_assertClassBrand(_MessageHandler_brand, this, _deleteStreamController).call(this, streamController, streamId);
      break;
    case StreamKind.CANCEL_COMPLETE:
      if (data.success) {
        streamController.cancelCall.resolve();
      } else {
        streamController.cancelCall.reject(wrapReason(data.reason));
      }
      message_handler_assertClassBrand(_MessageHandler_brand, this, _deleteStreamController).call(this, streamController, streamId);
      break;
    case StreamKind.CANCEL:
      if (!streamSink) {
        break;
      }
      const dataReason = wrapReason(data.reason);
      Promise.try(streamSink.onCancel || onFn, dataReason).then(function () {
        comObj.postMessage({
          sourceName,
          targetName,
          stream: StreamKind.CANCEL_COMPLETE,
          streamId,
          success: true
        });
      }, function (reason) {
        comObj.postMessage({
          sourceName,
          targetName,
          stream: StreamKind.CANCEL_COMPLETE,
          streamId,
          reason: wrapReason(reason)
        });
      });
      streamSink.sinkCapability.reject(dataReason);
      streamSink.isCancelled = true;
      delete this.streamSinks[streamId];
      break;
    default:
      throw new Error("Unexpected stream case");
  }
}
async function _deleteStreamController(streamController, streamId) {
  await Promise.allSettled([streamController.startCall?.promise, streamController.pullCall?.promise, streamController.cancelCall?.promise]);
  delete this.streamControllers[streamId];
}

;// ./src/display/canvas_factory.js

function canvas_factory_classPrivateFieldInitSpec(e, t, a) { canvas_factory_checkPrivateRedeclaration(e, t), t.set(e, a); }
function canvas_factory_checkPrivateRedeclaration(e, t) { if (t.has(e)) throw new TypeError("Cannot initialize the same private elements twice on an object"); }
function canvas_factory_classPrivateFieldGet(s, a) { return s.get(canvas_factory_assertClassBrand(s, a)); }
function canvas_factory_classPrivateFieldSet(s, a, r) { return s.set(canvas_factory_assertClassBrand(s, a), r), r; }
function canvas_factory_assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); }

var _enableHWA = /*#__PURE__*/new WeakMap();
class BaseCanvasFactory {
  constructor(_ref) {
    let {
      enableHWA = false
    } = _ref;
    canvas_factory_classPrivateFieldInitSpec(this, _enableHWA, false);
    canvas_factory_classPrivateFieldSet(_enableHWA, this, enableHWA);
  }
  create(width, height) {
    if (width <= 0 || height <= 0) {
      throw new Error("Invalid canvas size");
    }
    const canvas = this._createCanvas(width, height);
    return {
      canvas,
      context: canvas.getContext("2d", {
        willReadFrequently: !canvas_factory_classPrivateFieldGet(_enableHWA, this)
      })
    };
  }
  reset(canvasAndContext, width, height) {
    if (!canvasAndContext.canvas) {
      throw new Error("Canvas is not specified");
    }
    if (width <= 0 || height <= 0) {
      throw new Error("Invalid canvas size");
    }
    canvasAndContext.canvas.width = width;
    canvasAndContext.canvas.height = height;
  }
  destroy(canvasAndContext) {
    if (!canvasAndContext.canvas) {
      throw new Error("Canvas is not specified");
    }
    canvasAndContext.canvas.width = 0;
    canvasAndContext.canvas.height = 0;
    canvasAndContext.canvas = null;
    canvasAndContext.context = null;
  }
  _createCanvas(width, height) {
    unreachable("Abstract method `_createCanvas` called.");
  }
}
class DOMCanvasFactory extends BaseCanvasFactory {
  constructor(_ref2) {
    let {
      ownerDocument = globalThis.document,
      enableHWA = false
    } = _ref2;
    super({
      enableHWA
    });
    this._document = ownerDocument;
  }
  _createCanvas(width, height) {
    const canvas = this._document.createElement("canvas");
    canvas.width = width;
    canvas.height = height;
    return canvas;
  }
}

;// ./src/display/cmap_reader_factory.js



















class BaseCMapReaderFactory {
  constructor(_ref) {
    let {
      baseUrl = null,
      isCompressed = true
    } = _ref;
    this.baseUrl = baseUrl;
    this.isCompressed = isCompressed;
  }
  async fetch(_ref2) {
    let {
      name
    } = _ref2;
    if (!this.baseUrl) {
      throw new Error("Ensure that the `cMapUrl` and `cMapPacked` API parameters are provided.");
    }
    if (!name) {
      throw new Error("CMap name must be specified.");
    }
    const url = this.baseUrl + name + (this.isCompressed ? ".bcmap" : "");
    return this._fetch(url).then(cMapData => ({
      cMapData,
      isCompressed: this.isCompressed
    })).catch(reason => {
      throw new Error(`Unable to load ${this.isCompressed ? "binary " : ""}CMap at: ${url}`);
    });
  }
  async _fetch(url) {
    unreachable("Abstract method `_fetch` called.");
  }
}
class DOMCMapReaderFactory extends BaseCMapReaderFactory {
  async _fetch(url) {
    const data = await fetchData(url, this.isCompressed ? "arraybuffer" : "text");
    return data instanceof ArrayBuffer ? new Uint8Array(data) : stringToBytes(data);
  }
}

// EXTERNAL MODULE: ./node_modules/core-js/modules/es.iterator.filter.js
var es_iterator_filter = __webpack_require__(2489);
;// ./src/display/filter_factory.js



function filter_factory_classPrivateMethodInitSpec(e, a) { filter_factory_checkPrivateRedeclaration(e, a), a.add(e); }
function filter_factory_classPrivateFieldInitSpec(e, t, a) { filter_factory_checkPrivateRedeclaration(e, t), t.set(e, a); }
function filter_factory_checkPrivateRedeclaration(e, t) { if (t.has(e)) throw new TypeError("Cannot initialize the same private elements twice on an object"); }
function filter_factory_classPrivateGetter(s, r, a) { return a(filter_factory_assertClassBrand(s, r)); }
function filter_factory_classPrivateFieldGet(s, a) { return s.get(filter_factory_assertClassBrand(s, a)); }
function filter_factory_classPrivateFieldSet(s, a, r) { return s.set(filter_factory_assertClassBrand(s, a), r), r; }
function filter_factory_assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); }


class BaseFilterFactory {
  addFilter(maps) {
    return "none";
  }
  addHCMFilter(fgColor, bgColor) {
    return "none";
  }
  addAlphaFilter(map) {
    return "none";
  }
  addLuminosityFilter(map) {
    return "none";
  }
  addHighlightHCMFilter(filterName, fgColor, bgColor, newFgColor, newBgColor) {
    return "none";
  }
  destroy() {
    let keepHCM = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
  }
}
var _baseUrl = /*#__PURE__*/new WeakMap();
var filter_factory_cache = /*#__PURE__*/new WeakMap();
var _defs = /*#__PURE__*/new WeakMap();
var _docId = /*#__PURE__*/new WeakMap();
var _document = /*#__PURE__*/new WeakMap();
var _hcmCache = /*#__PURE__*/new WeakMap();
var filter_factory_id = /*#__PURE__*/new WeakMap();
var _DOMFilterFactory_brand = /*#__PURE__*/new WeakSet();
class DOMFilterFactory extends BaseFilterFactory {
  constructor(_ref) {
    let {
      docId,
      ownerDocument = globalThis.document
    } = _ref;
    super();
    filter_factory_classPrivateMethodInitSpec(this, _DOMFilterFactory_brand);
    filter_factory_classPrivateFieldInitSpec(this, _baseUrl, void 0);
    filter_factory_classPrivateFieldInitSpec(this, filter_factory_cache, void 0);
    filter_factory_classPrivateFieldInitSpec(this, _defs, void 0);
    filter_factory_classPrivateFieldInitSpec(this, _docId, void 0);
    filter_factory_classPrivateFieldInitSpec(this, _document, void 0);
    filter_factory_classPrivateFieldInitSpec(this, _hcmCache, void 0);
    filter_factory_classPrivateFieldInitSpec(this, filter_factory_id, 0);
    filter_factory_classPrivateFieldSet(_docId, this, docId);
    filter_factory_classPrivateFieldSet(_document, this, ownerDocument);
  }
  addFilter(maps) {
    var _this$id, _this$id2;
    if (!maps) {
      return "none";
    }
    let value = filter_factory_classPrivateGetter(_DOMFilterFactory_brand, this, _get_cache).get(maps);
    if (value) {
      return value;
    }
    const [tableR, tableG, tableB] = filter_factory_assertClassBrand(_DOMFilterFactory_brand, this, _createTables).call(this, maps);
    const key = maps.length === 1 ? tableR : `${tableR}${tableG}${tableB}`;
    value = filter_factory_classPrivateGetter(_DOMFilterFactory_brand, this, _get_cache).get(key);
    if (value) {
      filter_factory_classPrivateGetter(_DOMFilterFactory_brand, this, _get_cache).set(maps, value);
      return value;
    }
    const id = `g_${filter_factory_classPrivateFieldGet(_docId, this)}_transfer_map_${filter_factory_classPrivateFieldSet(filter_factory_id, this, (_this$id = filter_factory_classPrivateFieldGet(filter_factory_id, this), _this$id2 = _this$id++, _this$id)), _this$id2}`;
    const url = filter_factory_assertClassBrand(_DOMFilterFactory_brand, this, _createUrl).call(this, id);
    filter_factory_classPrivateGetter(_DOMFilterFactory_brand, this, _get_cache).set(maps, url);
    filter_factory_classPrivateGetter(_DOMFilterFactory_brand, this, _get_cache).set(key, url);
    const filter = filter_factory_assertClassBrand(_DOMFilterFactory_brand, this, _createFilter).call(this, id);
    filter_factory_assertClassBrand(_DOMFilterFactory_brand, this, _addTransferMapConversion).call(this, tableR, tableG, tableB, filter);
    return url;
  }
  addHCMFilter(fgColor, bgColor) {
    const key = `${fgColor}-${bgColor}`;
    const filterName = "base";
    let info = filter_factory_classPrivateGetter(_DOMFilterFactory_brand, this, _get_hcmCache).get(filterName);
    if (info?.key === key) {
      return info.url;
    }
    if (info) {
      info.filter?.remove();
      info.key = key;
      info.url = "none";
      info.filter = null;
    } else {
      info = {
        key,
        url: "none",
        filter: null
      };
      filter_factory_classPrivateGetter(_DOMFilterFactory_brand, this, _get_hcmCache).set(filterName, info);
    }
    if (!fgColor || !bgColor) {
      return info.url;
    }
    const fgRGB = filter_factory_assertClassBrand(_DOMFilterFactory_brand, this, _getRGB).call(this, fgColor);
    fgColor = Util.makeHexColor(...fgRGB);
    const bgRGB = filter_factory_assertClassBrand(_DOMFilterFactory_brand, this, _getRGB).call(this, bgColor);
    bgColor = Util.makeHexColor(...bgRGB);
    filter_factory_classPrivateGetter(_DOMFilterFactory_brand, this, _get_defs).style.color = "";
    if (fgColor === "#000000" && bgColor === "#ffffff" || fgColor === bgColor) {
      return info.url;
    }
    const map = new Array(256);
    for (let i = 0; i <= 255; i++) {
      const x = i / 255;
      map[i] = x <= 0.03928 ? x / 12.92 : ((x + 0.055) / 1.055) ** 2.4;
    }
    const table = map.join(",");
    const id = `g_${filter_factory_classPrivateFieldGet(_docId, this)}_hcm_filter`;
    const filter = info.filter = filter_factory_assertClassBrand(_DOMFilterFactory_brand, this, _createFilter).call(this, id);
    filter_factory_assertClassBrand(_DOMFilterFactory_brand, this, _addTransferMapConversion).call(this, table, table, table, filter);
    filter_factory_assertClassBrand(_DOMFilterFactory_brand, this, _addGrayConversion).call(this, filter);
    const getSteps = (c, n) => {
      const start = fgRGB[c] / 255;
      const end = bgRGB[c] / 255;
      const arr = new Array(n + 1);
      for (let i = 0; i <= n; i++) {
        arr[i] = start + i / n * (end - start);
      }
      return arr.join(",");
    };
    filter_factory_assertClassBrand(_DOMFilterFactory_brand, this, _addTransferMapConversion).call(this, getSteps(0, 5), getSteps(1, 5), getSteps(2, 5), filter);
    info.url = filter_factory_assertClassBrand(_DOMFilterFactory_brand, this, _createUrl).call(this, id);
    return info.url;
  }
  addAlphaFilter(map) {
    var _this$id3, _this$id4;
    let value = filter_factory_classPrivateGetter(_DOMFilterFactory_brand, this, _get_cache).get(map);
    if (value) {
      return value;
    }
    const [tableA] = filter_factory_assertClassBrand(_DOMFilterFactory_brand, this, _createTables).call(this, [map]);
    const key = `alpha_${tableA}`;
    value = filter_factory_classPrivateGetter(_DOMFilterFactory_brand, this, _get_cache).get(key);
    if (value) {
      filter_factory_classPrivateGetter(_DOMFilterFactory_brand, this, _get_cache).set(map, value);
      return value;
    }
    const id = `g_${filter_factory_classPrivateFieldGet(_docId, this)}_alpha_map_${filter_factory_classPrivateFieldSet(filter_factory_id, this, (_this$id3 = filter_factory_classPrivateFieldGet(filter_factory_id, this), _this$id4 = _this$id3++, _this$id3)), _this$id4}`;
    const url = filter_factory_assertClassBrand(_DOMFilterFactory_brand, this, _createUrl).call(this, id);
    filter_factory_classPrivateGetter(_DOMFilterFactory_brand, this, _get_cache).set(map, url);
    filter_factory_classPrivateGetter(_DOMFilterFactory_brand, this, _get_cache).set(key, url);
    const filter = filter_factory_assertClassBrand(_DOMFilterFactory_brand, this, _createFilter).call(this, id);
    filter_factory_assertClassBrand(_DOMFilterFactory_brand, this, _addTransferMapAlphaConversion).call(this, tableA, filter);
    return url;
  }
  addLuminosityFilter(map) {
    var _this$id5, _this$id6;
    let value = filter_factory_classPrivateGetter(_DOMFilterFactory_brand, this, _get_cache).get(map || "luminosity");
    if (value) {
      return value;
    }
    let tableA, key;
    if (map) {
      [tableA] = filter_factory_assertClassBrand(_DOMFilterFactory_brand, this, _createTables).call(this, [map]);
      key = `luminosity_${tableA}`;
    } else {
      key = "luminosity";
    }
    value = filter_factory_classPrivateGetter(_DOMFilterFactory_brand, this, _get_cache).get(key);
    if (value) {
      filter_factory_classPrivateGetter(_DOMFilterFactory_brand, this, _get_cache).set(map, value);
      return value;
    }
    const id = `g_${filter_factory_classPrivateFieldGet(_docId, this)}_luminosity_map_${filter_factory_classPrivateFieldSet(filter_factory_id, this, (_this$id5 = filter_factory_classPrivateFieldGet(filter_factory_id, this), _this$id6 = _this$id5++, _this$id5)), _this$id6}`;
    const url = filter_factory_assertClassBrand(_DOMFilterFactory_brand, this, _createUrl).call(this, id);
    filter_factory_classPrivateGetter(_DOMFilterFactory_brand, this, _get_cache).set(map, url);
    filter_factory_classPrivateGetter(_DOMFilterFactory_brand, this, _get_cache).set(key, url);
    const filter = filter_factory_assertClassBrand(_DOMFilterFactory_brand, this, _createFilter).call(this, id);
    filter_factory_assertClassBrand(_DOMFilterFactory_brand, this, _addLuminosityConversion).call(this, filter);
    if (map) {
      filter_factory_assertClassBrand(_DOMFilterFactory_brand, this, _addTransferMapAlphaConversion).call(this, tableA, filter);
    }
    return url;
  }
  addHighlightHCMFilter(filterName, fgColor, bgColor, newFgColor, newBgColor) {
    const key = `${fgColor}-${bgColor}-${newFgColor}-${newBgColor}`;
    let info = filter_factory_classPrivateGetter(_DOMFilterFactory_brand, this, _get_hcmCache).get(filterName);
    if (info?.key === key) {
      return info.url;
    }
    if (info) {
      info.filter?.remove();
      info.key = key;
      info.url = "none";
      info.filter = null;
    } else {
      info = {
        key,
        url: "none",
        filter: null
      };
      filter_factory_classPrivateGetter(_DOMFilterFactory_brand, this, _get_hcmCache).set(filterName, info);
    }
    if (!fgColor || !bgColor) {
      return info.url;
    }
    const [fgRGB, bgRGB] = [fgColor, bgColor].map(filter_factory_assertClassBrand(_DOMFilterFactory_brand, this, _getRGB).bind(this));
    let fgGray = Math.round(0.2126 * fgRGB[0] + 0.7152 * fgRGB[1] + 0.0722 * fgRGB[2]);
    let bgGray = Math.round(0.2126 * bgRGB[0] + 0.7152 * bgRGB[1] + 0.0722 * bgRGB[2]);
    let [newFgRGB, newBgRGB] = [newFgColor, newBgColor].map(filter_factory_assertClassBrand(_DOMFilterFactory_brand, this, _getRGB).bind(this));
    if (bgGray < fgGray) {
      [fgGray, bgGray, newFgRGB, newBgRGB] = [bgGray, fgGray, newBgRGB, newFgRGB];
    }
    filter_factory_classPrivateGetter(_DOMFilterFactory_brand, this, _get_defs).style.color = "";
    const getSteps = (fg, bg, n) => {
      const arr = new Array(256);
      const step = (bgGray - fgGray) / n;
      const newStart = fg / 255;
      const newStep = (bg - fg) / (255 * n);
      let prev = 0;
      for (let i = 0; i <= n; i++) {
        const k = Math.round(fgGray + i * step);
        const value = newStart + i * newStep;
        for (let j = prev; j <= k; j++) {
          arr[j] = value;
        }
        prev = k + 1;
      }
      for (let i = prev; i < 256; i++) {
        arr[i] = arr[prev - 1];
      }
      return arr.join(",");
    };
    const id = `g_${filter_factory_classPrivateFieldGet(_docId, this)}_hcm_${filterName}_filter`;
    const filter = info.filter = filter_factory_assertClassBrand(_DOMFilterFactory_brand, this, _createFilter).call(this, id);
    filter_factory_assertClassBrand(_DOMFilterFactory_brand, this, _addGrayConversion).call(this, filter);
    filter_factory_assertClassBrand(_DOMFilterFactory_brand, this, _addTransferMapConversion).call(this, getSteps(newFgRGB[0], newBgRGB[0], 5), getSteps(newFgRGB[1], newBgRGB[1], 5), getSteps(newFgRGB[2], newBgRGB[2], 5), filter);
    info.url = filter_factory_assertClassBrand(_DOMFilterFactory_brand, this, _createUrl).call(this, id);
    return info.url;
  }
  destroy() {
    let keepHCM = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
    if (keepHCM && filter_factory_classPrivateFieldGet(_hcmCache, this)?.size) {
      return;
    }
    filter_factory_classPrivateFieldGet(_defs, this)?.parentNode.parentNode.remove();
    filter_factory_classPrivateFieldSet(_defs, this, null);
    filter_factory_classPrivateFieldGet(filter_factory_cache, this)?.clear();
    filter_factory_classPrivateFieldSet(filter_factory_cache, this, null);
    filter_factory_classPrivateFieldGet(_hcmCache, this)?.clear();
    filter_factory_classPrivateFieldSet(_hcmCache, this, null);
    filter_factory_classPrivateFieldSet(filter_factory_id, this, 0);
  }
}
function _get_cache(_this) {
  return filter_factory_classPrivateFieldGet(filter_factory_cache, _this) || filter_factory_classPrivateFieldSet(filter_factory_cache, _this, new Map());
}
function _get_hcmCache(_this2) {
  return filter_factory_classPrivateFieldGet(_hcmCache, _this2) || filter_factory_classPrivateFieldSet(_hcmCache, _this2, new Map());
}
function _get_defs(_this3) {
  if (!filter_factory_classPrivateFieldGet(_defs, _this3)) {
    const div = filter_factory_classPrivateFieldGet(_document, _this3).createElement("div");
    const {
      style
    } = div;
    style.visibility = "hidden";
    style.contain = "strict";
    style.width = style.height = 0;
    style.position = "absolute";
    style.top = style.left = 0;
    style.zIndex = -1;
    const svg = filter_factory_classPrivateFieldGet(_document, _this3).createElementNS(SVG_NS, "svg");
    svg.setAttribute("width", 0);
    svg.setAttribute("height", 0);
    filter_factory_classPrivateFieldSet(_defs, _this3, filter_factory_classPrivateFieldGet(_document, _this3).createElementNS(SVG_NS, "defs"));
    div.append(svg);
    svg.append(filter_factory_classPrivateFieldGet(_defs, _this3));
    filter_factory_classPrivateFieldGet(_document, _this3).body.append(div);
  }
  return filter_factory_classPrivateFieldGet(_defs, _this3);
}
function _createTables(maps) {
  if (maps.length === 1) {
    const mapR = maps[0];
    const buffer = new Array(256);
    for (let i = 0; i < 256; i++) {
      buffer[i] = mapR[i] / 255;
    }
    const table = buffer.join(",");
    return [table, table, table];
  }
  const [mapR, mapG, mapB] = maps;
  const bufferR = new Array(256);
  const bufferG = new Array(256);
  const bufferB = new Array(256);
  for (let i = 0; i < 256; i++) {
    bufferR[i] = mapR[i] / 255;
    bufferG[i] = mapG[i] / 255;
    bufferB[i] = mapB[i] / 255;
  }
  return [bufferR.join(","), bufferG.join(","), bufferB.join(",")];
}
function _createUrl(id) {
  if (filter_factory_classPrivateFieldGet(_baseUrl, this) === undefined) {
    filter_factory_classPrivateFieldSet(_baseUrl, this, "");
    const url = filter_factory_classPrivateFieldGet(_document, this).URL;
    if (url !== filter_factory_classPrivateFieldGet(_document, this).baseURI) {
      if (isDataScheme(url)) {
        warn('#createUrl: ignore "data:"-URL for performance reasons.');
      } else {
        filter_factory_classPrivateFieldSet(_baseUrl, this, updateUrlHash(url, ""));
      }
    }
  }
  return `url(${filter_factory_classPrivateFieldGet(_baseUrl, this)}#${id})`;
}
function _addLuminosityConversion(filter) {
  const feColorMatrix = filter_factory_classPrivateFieldGet(_document, this).createElementNS(SVG_NS, "feColorMatrix");
  feColorMatrix.setAttribute("type", "matrix");
  feColorMatrix.setAttribute("values", "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.3 0.59 0.11 0 0");
  filter.append(feColorMatrix);
}
function _addGrayConversion(filter) {
  const feColorMatrix = filter_factory_classPrivateFieldGet(_document, this).createElementNS(SVG_NS, "feColorMatrix");
  feColorMatrix.setAttribute("type", "matrix");
  feColorMatrix.setAttribute("values", "0.2126 0.7152 0.0722 0 0 0.2126 0.7152 0.0722 0 0 0.2126 0.7152 0.0722 0 0 0 0 0 1 0");
  filter.append(feColorMatrix);
}
function _createFilter(id) {
  const filter = filter_factory_classPrivateFieldGet(_document, this).createElementNS(SVG_NS, "filter");
  filter.setAttribute("color-interpolation-filters", "sRGB");
  filter.setAttribute("id", id);
  filter_factory_classPrivateGetter(_DOMFilterFactory_brand, this, _get_defs).append(filter);
  return filter;
}
function _appendFeFunc(feComponentTransfer, func, table) {
  const feFunc = filter_factory_classPrivateFieldGet(_document, this).createElementNS(SVG_NS, func);
  feFunc.setAttribute("type", "discrete");
  feFunc.setAttribute("tableValues", table);
  feComponentTransfer.append(feFunc);
}
function _addTransferMapConversion(rTable, gTable, bTable, filter) {
  const feComponentTransfer = filter_factory_classPrivateFieldGet(_document, this).createElementNS(SVG_NS, "feComponentTransfer");
  filter.append(feComponentTransfer);
  filter_factory_assertClassBrand(_DOMFilterFactory_brand, this, _appendFeFunc).call(this, feComponentTransfer, "feFuncR", rTable);
  filter_factory_assertClassBrand(_DOMFilterFactory_brand, this, _appendFeFunc).call(this, feComponentTransfer, "feFuncG", gTable);
  filter_factory_assertClassBrand(_DOMFilterFactory_brand, this, _appendFeFunc).call(this, feComponentTransfer, "feFuncB", bTable);
}
function _addTransferMapAlphaConversion(aTable, filter) {
  const feComponentTransfer = filter_factory_classPrivateFieldGet(_document, this).createElementNS(SVG_NS, "feComponentTransfer");
  filter.append(feComponentTransfer);
  filter_factory_assertClassBrand(_DOMFilterFactory_brand, this, _appendFeFunc).call(this, feComponentTransfer, "feFuncA", aTable);
}
function _getRGB(color) {
  filter_factory_classPrivateGetter(_DOMFilterFactory_brand, this, _get_defs).style.color = color;
  return getRGB(getComputedStyle(filter_factory_classPrivateGetter(_DOMFilterFactory_brand, this, _get_defs)).getPropertyValue("color"));
}

;// ./src/display/standard_fontdata_factory.js



















class BaseStandardFontDataFactory {
  constructor(_ref) {
    let {
      baseUrl = null
    } = _ref;
    this.baseUrl = baseUrl;
  }
  async fetch(_ref2) {
    let {
      filename
    } = _ref2;
    if (!this.baseUrl) {
      throw new Error("Ensure that the `standardFontDataUrl` API parameter is provided.");
    }
    if (!filename) {
      throw new Error("Font filename must be specified.");
    }
    const url = `${this.baseUrl}${filename}`;
    return this._fetch(url).catch(reason => {
      throw new Error(`Unable to load font data at: ${url}`);
    });
  }
  async _fetch(url) {
    unreachable("Abstract method `_fetch` called.");
  }
}
class DOMStandardFontDataFactory extends BaseStandardFontDataFactory {
  async _fetch(url) {
    const data = await fetchData(url, "arraybuffer");
    return new Uint8Array(data);
  }
}

;// ./src/display/wasm_factory.js



















class BaseWasmFactory {
  constructor(_ref) {
    let {
      baseUrl = null
    } = _ref;
    this.baseUrl = baseUrl;
  }
  async fetch(_ref2) {
    let {
      filename
    } = _ref2;
    if (!this.baseUrl) {
      throw new Error("Ensure that the `wasmUrl` API parameter is provided.");
    }
    if (!filename) {
      throw new Error("Wasm filename must be specified.");
    }
    const url = `${this.baseUrl}${filename}`;
    return this._fetch(url).catch(reason => {
      throw new Error(`Unable to load wasm data at: ${url}`);
    });
  }
  async _fetch(url) {
    unreachable("Abstract method `_fetch` called.");
  }
}
class DOMWasmFactory extends BaseWasmFactory {
  async _fetch(url) {
    const data = await fetchData(url, "arraybuffer");
    return new Uint8Array(data);
  }
}

;// ./src/display/node_utils.js























async function node_utils_fetchData(url) {
  const fs = process.getBuiltinModule("fs");
  const data = await fs.promises.readFile(url);
  return new Uint8Array(data);
}
class NodeFilterFactory extends BaseFilterFactory {}
class NodeCanvasFactory extends BaseCanvasFactory {
  _createCanvas(width, height) {
    const require = process.getBuiltinModule("module").createRequire(import.meta.url);
    const canvas = require("@napi-rs/canvas");
    return canvas.createCanvas(width, height);
  }
}
class NodeCMapReaderFactory extends BaseCMapReaderFactory {
  async _fetch(url) {
    return node_utils_fetchData(url);
  }
}
class NodeStandardFontDataFactory extends BaseStandardFontDataFactory {
  async _fetch(url) {
    return node_utils_fetchData(url);
  }
}
class NodeWasmFactory extends BaseWasmFactory {
  async _fetch(url) {
    return node_utils_fetchData(url);
  }
}

;// ./src/display/pattern_helper.js
function pattern_helper_defineProperty(e, r, t) { return (r = pattern_helper_toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function pattern_helper_toPropertyKey(t) { var i = pattern_helper_toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function pattern_helper_toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }















const PathType = {
  FILL: "Fill",
  STROKE: "Stroke",
  SHADING: "Shading"
};
function applyBoundingBox(ctx, bbox) {
  if (!bbox) {
    return;
  }
  const width = bbox[2] - bbox[0];
  const height = bbox[3] - bbox[1];
  const region = new Path2D();
  region.rect(bbox[0], bbox[1], width, height);
  ctx.clip(region);
}
class BaseShadingPattern {
  isModifyingCurrentTransform() {
    return false;
  }
  getPattern() {
    unreachable("Abstract method `getPattern` called.");
  }
}
class RadialAxialShadingPattern extends BaseShadingPattern {
  constructor(IR) {
    super();
    this._type = IR[1];
    this._bbox = IR[2];
    this._colorStops = IR[3];
    this._p0 = IR[4];
    this._p1 = IR[5];
    this._r0 = IR[6];
    this._r1 = IR[7];
    this.matrix = null;
  }
  _createGradient(ctx) {
    let grad;
    if (this._type === "axial") {
      grad = ctx.createLinearGradient(this._p0[0], this._p0[1], this._p1[0], this._p1[1]);
    } else if (this._type === "radial") {
      grad = ctx.createRadialGradient(this._p0[0], this._p0[1], this._r0, this._p1[0], this._p1[1], this._r1);
    }
    for (const colorStop of this._colorStops) {
      grad.addColorStop(colorStop[0], colorStop[1]);
    }
    return grad;
  }
  getPattern(ctx, owner, inverse, pathType) {
    let pattern;
    if (pathType === PathType.STROKE || pathType === PathType.FILL) {
      const ownerBBox = owner.current.getClippedPathBoundingBox(pathType, getCurrentTransform(ctx)) || [0, 0, 0, 0];
      const width = Math.ceil(ownerBBox[2] - ownerBBox[0]) || 1;
      const height = Math.ceil(ownerBBox[3] - ownerBBox[1]) || 1;
      const tmpCanvas = owner.cachedCanvases.getCanvas("pattern", width, height);
      const tmpCtx = tmpCanvas.context;
      tmpCtx.clearRect(0, 0, tmpCtx.canvas.width, tmpCtx.canvas.height);
      tmpCtx.beginPath();
      tmpCtx.rect(0, 0, tmpCtx.canvas.width, tmpCtx.canvas.height);
      tmpCtx.translate(-ownerBBox[0], -ownerBBox[1]);
      inverse = Util.transform(inverse, [1, 0, 0, 1, ownerBBox[0], ownerBBox[1]]);
      tmpCtx.transform(...owner.baseTransform);
      if (this.matrix) {
        tmpCtx.transform(...this.matrix);
      }
      applyBoundingBox(tmpCtx, this._bbox);
      tmpCtx.fillStyle = this._createGradient(tmpCtx);
      tmpCtx.fill();
      pattern = ctx.createPattern(tmpCanvas.canvas, "no-repeat");
      const domMatrix = new DOMMatrix(inverse);
      pattern.setTransform(domMatrix);
    } else {
      applyBoundingBox(ctx, this._bbox);
      pattern = this._createGradient(ctx);
    }
    return pattern;
  }
}
function drawTriangle(data, context, p1, p2, p3, c1, c2, c3) {
  const coords = context.coords,
    colors = context.colors;
  const bytes = data.data,
    rowSize = data.width * 4;
  let tmp;
  if (coords[p1 + 1] > coords[p2 + 1]) {
    tmp = p1;
    p1 = p2;
    p2 = tmp;
    tmp = c1;
    c1 = c2;
    c2 = tmp;
  }
  if (coords[p2 + 1] > coords[p3 + 1]) {
    tmp = p2;
    p2 = p3;
    p3 = tmp;
    tmp = c2;
    c2 = c3;
    c3 = tmp;
  }
  if (coords[p1 + 1] > coords[p2 + 1]) {
    tmp = p1;
    p1 = p2;
    p2 = tmp;
    tmp = c1;
    c1 = c2;
    c2 = tmp;
  }
  const x1 = (coords[p1] + context.offsetX) * context.scaleX;
  const y1 = (coords[p1 + 1] + context.offsetY) * context.scaleY;
  const x2 = (coords[p2] + context.offsetX) * context.scaleX;
  const y2 = (coords[p2 + 1] + context.offsetY) * context.scaleY;
  const x3 = (coords[p3] + context.offsetX) * context.scaleX;
  const y3 = (coords[p3 + 1] + context.offsetY) * context.scaleY;
  if (y1 >= y3) {
    return;
  }
  const c1r = colors[c1],
    c1g = colors[c1 + 1],
    c1b = colors[c1 + 2];
  const c2r = colors[c2],
    c2g = colors[c2 + 1],
    c2b = colors[c2 + 2];
  const c3r = colors[c3],
    c3g = colors[c3 + 1],
    c3b = colors[c3 + 2];
  const minY = Math.round(y1),
    maxY = Math.round(y3);
  let xa, car, cag, cab;
  let xb, cbr, cbg, cbb;
  for (let y = minY; y <= maxY; y++) {
    if (y < y2) {
      const k = y < y1 ? 0 : (y1 - y) / (y1 - y2);
      xa = x1 - (x1 - x2) * k;
      car = c1r - (c1r - c2r) * k;
      cag = c1g - (c1g - c2g) * k;
      cab = c1b - (c1b - c2b) * k;
    } else {
      let k;
      if (y > y3) {
        k = 1;
      } else if (y2 === y3) {
        k = 0;
      } else {
        k = (y2 - y) / (y2 - y3);
      }
      xa = x2 - (x2 - x3) * k;
      car = c2r - (c2r - c3r) * k;
      cag = c2g - (c2g - c3g) * k;
      cab = c2b - (c2b - c3b) * k;
    }
    let k;
    if (y < y1) {
      k = 0;
    } else if (y > y3) {
      k = 1;
    } else {
      k = (y1 - y) / (y1 - y3);
    }
    xb = x1 - (x1 - x3) * k;
    cbr = c1r - (c1r - c3r) * k;
    cbg = c1g - (c1g - c3g) * k;
    cbb = c1b - (c1b - c3b) * k;
    const x1_ = Math.round(Math.min(xa, xb));
    const x2_ = Math.round(Math.max(xa, xb));
    let j = rowSize * y + x1_ * 4;
    for (let x = x1_; x <= x2_; x++) {
      k = (xa - x) / (xa - xb);
      if (k < 0) {
        k = 0;
      } else if (k > 1) {
        k = 1;
      }
      bytes[j++] = car - (car - cbr) * k | 0;
      bytes[j++] = cag - (cag - cbg) * k | 0;
      bytes[j++] = cab - (cab - cbb) * k | 0;
      bytes[j++] = 255;
    }
  }
}
function drawFigure(data, figure, context) {
  const ps = figure.coords;
  const cs = figure.colors;
  let i, ii;
  switch (figure.type) {
    case "lattice":
      const verticesPerRow = figure.verticesPerRow;
      const rows = Math.floor(ps.length / verticesPerRow) - 1;
      const cols = verticesPerRow - 1;
      for (i = 0; i < rows; i++) {
        let q = i * verticesPerRow;
        for (let j = 0; j < cols; j++, q++) {
          drawTriangle(data, context, ps[q], ps[q + 1], ps[q + verticesPerRow], cs[q], cs[q + 1], cs[q + verticesPerRow]);
          drawTriangle(data, context, ps[q + verticesPerRow + 1], ps[q + 1], ps[q + verticesPerRow], cs[q + verticesPerRow + 1], cs[q + 1], cs[q + verticesPerRow]);
        }
      }
      break;
    case "triangles":
      for (i = 0, ii = ps.length; i < ii; i += 3) {
        drawTriangle(data, context, ps[i], ps[i + 1], ps[i + 2], cs[i], cs[i + 1], cs[i + 2]);
      }
      break;
    default:
      throw new Error("illegal figure");
  }
}
class MeshShadingPattern extends BaseShadingPattern {
  constructor(IR) {
    super();
    this._coords = IR[2];
    this._colors = IR[3];
    this._figures = IR[4];
    this._bounds = IR[5];
    this._bbox = IR[6];
    this._background = IR[7];
    this.matrix = null;
  }
  _createMeshCanvas(combinedScale, backgroundColor, cachedCanvases) {
    const EXPECTED_SCALE = 1.1;
    const MAX_PATTERN_SIZE = 3000;
    const BORDER_SIZE = 2;
    const offsetX = Math.floor(this._bounds[0]);
    const offsetY = Math.floor(this._bounds[1]);
    const boundsWidth = Math.ceil(this._bounds[2]) - offsetX;
    const boundsHeight = Math.ceil(this._bounds[3]) - offsetY;
    const width = Math.min(Math.ceil(Math.abs(boundsWidth * combinedScale[0] * EXPECTED_SCALE)), MAX_PATTERN_SIZE);
    const height = Math.min(Math.ceil(Math.abs(boundsHeight * combinedScale[1] * EXPECTED_SCALE)), MAX_PATTERN_SIZE);
    const scaleX = boundsWidth / width;
    const scaleY = boundsHeight / height;
    const context = {
      coords: this._coords,
      colors: this._colors,
      offsetX: -offsetX,
      offsetY: -offsetY,
      scaleX: 1 / scaleX,
      scaleY: 1 / scaleY
    };
    const paddedWidth = width + BORDER_SIZE * 2;
    const paddedHeight = height + BORDER_SIZE * 2;
    const tmpCanvas = cachedCanvases.getCanvas("mesh", paddedWidth, paddedHeight);
    const tmpCtx = tmpCanvas.context;
    const data = tmpCtx.createImageData(width, height);
    if (backgroundColor) {
      const bytes = data.data;
      for (let i = 0, ii = bytes.length; i < ii; i += 4) {
        bytes[i] = backgroundColor[0];
        bytes[i + 1] = backgroundColor[1];
        bytes[i + 2] = backgroundColor[2];
        bytes[i + 3] = 255;
      }
    }
    for (const figure of this._figures) {
      drawFigure(data, figure, context);
    }
    tmpCtx.putImageData(data, BORDER_SIZE, BORDER_SIZE);
    const canvas = tmpCanvas.canvas;
    return {
      canvas,
      offsetX: offsetX - BORDER_SIZE * scaleX,
      offsetY: offsetY - BORDER_SIZE * scaleY,
      scaleX,
      scaleY
    };
  }
  isModifyingCurrentTransform() {
    return true;
  }
  getPattern(ctx, owner, inverse, pathType) {
    applyBoundingBox(ctx, this._bbox);
    const scale = new Float32Array(2);
    if (pathType === PathType.SHADING) {
      Util.singularValueDecompose2dScale(getCurrentTransform(ctx), scale);
    } else if (this.matrix) {
      Util.singularValueDecompose2dScale(this.matrix, scale);
      const [matrixScaleX, matrixScaleY] = scale;
      Util.singularValueDecompose2dScale(owner.baseTransform, scale);
      scale[0] *= matrixScaleX;
      scale[1] *= matrixScaleY;
    } else {
      Util.singularValueDecompose2dScale(owner.baseTransform, scale);
    }
    const temporaryPatternCanvas = this._createMeshCanvas(scale, pathType === PathType.SHADING ? null : this._background, owner.cachedCanvases);
    if (pathType !== PathType.SHADING) {
      ctx.setTransform(...owner.baseTransform);
      if (this.matrix) {
        ctx.transform(...this.matrix);
      }
    }
    ctx.translate(temporaryPatternCanvas.offsetX, temporaryPatternCanvas.offsetY);
    ctx.scale(temporaryPatternCanvas.scaleX, temporaryPatternCanvas.scaleY);
    return ctx.createPattern(temporaryPatternCanvas.canvas, "no-repeat");
  }
}
class DummyShadingPattern extends BaseShadingPattern {
  getPattern() {
    return "hotpink";
  }
}
function getShadingPattern(IR) {
  switch (IR[0]) {
    case "RadialAxial":
      return new RadialAxialShadingPattern(IR);
    case "Mesh":
      return new MeshShadingPattern(IR);
    case "Dummy":
      return new DummyShadingPattern();
  }
  throw new Error(`Unknown IR type: ${IR[0]}`);
}
const PaintType = {
  COLORED: 1,
  UNCOLORED: 2
};
class TilingPattern {
  constructor(IR, ctx, canvasGraphicsFactory, baseTransform) {
    this.color = IR[1];
    this.operatorList = IR[2];
    this.matrix = IR[3];
    this.bbox = IR[4];
    this.xstep = IR[5];
    this.ystep = IR[6];
    this.paintType = IR[7];
    this.tilingType = IR[8];
    this.ctx = ctx;
    this.canvasGraphicsFactory = canvasGraphicsFactory;
    this.baseTransform = baseTransform;
  }
  createPatternCanvas(owner) {
    const {
      bbox,
      operatorList,
      paintType,
      tilingType,
      color,
      canvasGraphicsFactory
    } = this;
    let {
      xstep,
      ystep
    } = this;
    xstep = Math.abs(xstep);
    ystep = Math.abs(ystep);
    info("TilingType: " + tilingType);
    const x0 = bbox[0],
      y0 = bbox[1],
      x1 = bbox[2],
      y1 = bbox[3];
    const width = x1 - x0;
    const height = y1 - y0;
    const scale = new Float32Array(2);
    Util.singularValueDecompose2dScale(this.matrix, scale);
    const [matrixScaleX, matrixScaleY] = scale;
    Util.singularValueDecompose2dScale(this.baseTransform, scale);
    const combinedScaleX = matrixScaleX * scale[0];
    const combinedScaleY = matrixScaleY * scale[1];
    let canvasWidth = width,
      canvasHeight = height,
      redrawHorizontally = false,
      redrawVertically = false;
    const xScaledStep = Math.ceil(xstep * combinedScaleX);
    const yScaledStep = Math.ceil(ystep * combinedScaleY);
    const xScaledWidth = Math.ceil(width * combinedScaleX);
    const yScaledHeight = Math.ceil(height * combinedScaleY);
    if (xScaledStep >= xScaledWidth) {
      canvasWidth = xstep;
    } else {
      redrawHorizontally = true;
    }
    if (yScaledStep >= yScaledHeight) {
      canvasHeight = ystep;
    } else {
      redrawVertically = true;
    }
    const dimx = this.getSizeAndScale(canvasWidth, this.ctx.canvas.width, combinedScaleX);
    const dimy = this.getSizeAndScale(canvasHeight, this.ctx.canvas.height, combinedScaleY);
    const tmpCanvas = owner.cachedCanvases.getCanvas("pattern", dimx.size, dimy.size);
    const tmpCtx = tmpCanvas.context;
    const graphics = canvasGraphicsFactory.createCanvasGraphics(tmpCtx);
    graphics.groupLevel = owner.groupLevel;
    this.setFillAndStrokeStyleToContext(graphics, paintType, color);
    tmpCtx.translate(-dimx.scale * x0, -dimy.scale * y0);
    graphics.transform(dimx.scale, 0, 0, dimy.scale, 0, 0);
    tmpCtx.save();
    this.clipBbox(graphics, x0, y0, x1, y1);
    graphics.baseTransform = getCurrentTransform(graphics.ctx);
    graphics.executeOperatorList(operatorList);
    graphics.endDrawing();
    tmpCtx.restore();
    if (redrawHorizontally || redrawVertically) {
      const image = tmpCanvas.canvas;
      if (redrawHorizontally) {
        canvasWidth = xstep;
      }
      if (redrawVertically) {
        canvasHeight = ystep;
      }
      const dimx2 = this.getSizeAndScale(canvasWidth, this.ctx.canvas.width, combinedScaleX);
      const dimy2 = this.getSizeAndScale(canvasHeight, this.ctx.canvas.height, combinedScaleY);
      const xSize = dimx2.size;
      const ySize = dimy2.size;
      const tmpCanvas2 = owner.cachedCanvases.getCanvas("pattern-workaround", xSize, ySize);
      const tmpCtx2 = tmpCanvas2.context;
      const ii = redrawHorizontally ? Math.floor(width / xstep) : 0;
      const jj = redrawVertically ? Math.floor(height / ystep) : 0;
      for (let i = 0; i <= ii; i++) {
        for (let j = 0; j <= jj; j++) {
          tmpCtx2.drawImage(image, xSize * i, ySize * j, xSize, ySize, 0, 0, xSize, ySize);
        }
      }
      return {
        canvas: tmpCanvas2.canvas,
        scaleX: dimx2.scale,
        scaleY: dimy2.scale,
        offsetX: x0,
        offsetY: y0
      };
    }
    return {
      canvas: tmpCanvas.canvas,
      scaleX: dimx.scale,
      scaleY: dimy.scale,
      offsetX: x0,
      offsetY: y0
    };
  }
  getSizeAndScale(step, realOutputSize, scale) {
    const maxSize = Math.max(TilingPattern.MAX_PATTERN_SIZE, realOutputSize);
    let size = Math.ceil(step * scale);
    if (size >= maxSize) {
      size = maxSize;
    } else {
      scale = size / step;
    }
    return {
      scale,
      size
    };
  }
  clipBbox(graphics, x0, y0, x1, y1) {
    const bboxWidth = x1 - x0;
    const bboxHeight = y1 - y0;
    graphics.ctx.rect(x0, y0, bboxWidth, bboxHeight);
    Util.axialAlignedBoundingBox([x0, y0, x1, y1], getCurrentTransform(graphics.ctx), graphics.current.minMax);
    graphics.clip();
    graphics.endPath();
  }
  setFillAndStrokeStyleToContext(graphics, paintType, color) {
    const context = graphics.ctx,
      current = graphics.current;
    switch (paintType) {
      case PaintType.COLORED:
        const {
          fillStyle,
          strokeStyle
        } = this.ctx;
        context.fillStyle = current.fillColor = fillStyle;
        context.strokeStyle = current.strokeColor = strokeStyle;
        break;
      case PaintType.UNCOLORED:
        context.fillStyle = context.strokeStyle = color;
        current.fillColor = current.strokeColor = color;
        break;
      default:
        throw new FormatError(`Unsupported paint type: ${paintType}`);
    }
  }
  isModifyingCurrentTransform() {
    return false;
  }
  getPattern(ctx, owner, inverse, pathType) {
    let matrix = inverse;
    if (pathType !== PathType.SHADING) {
      matrix = Util.transform(matrix, owner.baseTransform);
      if (this.matrix) {
        matrix = Util.transform(matrix, this.matrix);
      }
    }
    const temporaryPatternCanvas = this.createPatternCanvas(owner);
    let domMatrix = new DOMMatrix(matrix);
    domMatrix = domMatrix.translate(temporaryPatternCanvas.offsetX, temporaryPatternCanvas.offsetY);
    domMatrix = domMatrix.scale(1 / temporaryPatternCanvas.scaleX, 1 / temporaryPatternCanvas.scaleY);
    const pattern = ctx.createPattern(temporaryPatternCanvas.canvas, "repeat");
    pattern.setTransform(domMatrix);
    return pattern;
  }
}
pattern_helper_defineProperty(TilingPattern, "MAX_PATTERN_SIZE", 3000);

;// ./src/shared/image_utils.js













function convertToRGBA(params) {
  switch (params.kind) {
    case ImageKind.GRAYSCALE_1BPP:
      return convertBlackAndWhiteToRGBA(params);
    case ImageKind.RGB_24BPP:
      return convertRGBToRGBA(params);
  }
  return null;
}
function convertBlackAndWhiteToRGBA(_ref) {
  let {
    src,
    srcPos = 0,
    dest,
    width,
    height,
    nonBlackColor = 0xffffffff,
    inverseDecode = false
  } = _ref;
  const black = util_FeatureTest.isLittleEndian ? 0xff000000 : 0x000000ff;
  const [zeroMapping, oneMapping] = inverseDecode ? [nonBlackColor, black] : [black, nonBlackColor];
  const widthInSource = width >> 3;
  const widthRemainder = width & 7;
  const srcLength = src.length;
  dest = new Uint32Array(dest.buffer);
  let destPos = 0;
  for (let i = 0; i < height; i++) {
    for (const max = srcPos + widthInSource; srcPos < max; srcPos++) {
      const elem = srcPos < srcLength ? src[srcPos] : 255;
      dest[destPos++] = elem & 0b10000000 ? oneMapping : zeroMapping;
      dest[destPos++] = elem & 0b1000000 ? oneMapping : zeroMapping;
      dest[destPos++] = elem & 0b100000 ? oneMapping : zeroMapping;
      dest[destPos++] = elem & 0b10000 ? oneMapping : zeroMapping;
      dest[destPos++] = elem & 0b1000 ? oneMapping : zeroMapping;
      dest[destPos++] = elem & 0b100 ? oneMapping : zeroMapping;
      dest[destPos++] = elem & 0b10 ? oneMapping : zeroMapping;
      dest[destPos++] = elem & 0b1 ? oneMapping : zeroMapping;
    }
    if (widthRemainder === 0) {
      continue;
    }
    const elem = srcPos < srcLength ? src[srcPos++] : 255;
    for (let j = 0; j < widthRemainder; j++) {
      dest[destPos++] = elem & 1 << 7 - j ? oneMapping : zeroMapping;
    }
  }
  return {
    srcPos,
    destPos
  };
}
function convertRGBToRGBA(_ref2) {
  let {
    src,
    srcPos = 0,
    dest,
    destPos = 0,
    width,
    height
  } = _ref2;
  let i = 0;
  const len = width * height * 3;
  const len32 = len >> 2;
  const src32 = new Uint32Array(src.buffer, srcPos, len32);
  if (FeatureTest.isLittleEndian) {
    for (; i < len32 - 2; i += 3, destPos += 4) {
      const s1 = src32[i];
      const s2 = src32[i + 1];
      const s3 = src32[i + 2];
      dest[destPos] = s1 | 0xff000000;
      dest[destPos + 1] = s1 >>> 24 | s2 << 8 | 0xff000000;
      dest[destPos + 2] = s2 >>> 16 | s3 << 16 | 0xff000000;
      dest[destPos + 3] = s3 >>> 8 | 0xff000000;
    }
    for (let j = i * 4, jj = srcPos + len; j < jj; j += 3) {
      dest[destPos++] = src[j] | src[j + 1] << 8 | src[j + 2] << 16 | 0xff000000;
    }
  } else {
    for (; i < len32 - 2; i += 3, destPos += 4) {
      const s1 = src32[i];
      const s2 = src32[i + 1];
      const s3 = src32[i + 2];
      dest[destPos] = s1 | 0xff;
      dest[destPos + 1] = s1 << 24 | s2 >>> 8 | 0xff;
      dest[destPos + 2] = s2 << 16 | s3 >>> 16 | 0xff;
      dest[destPos + 3] = s3 << 8 | 0xff;
    }
    for (let j = i * 4, jj = srcPos + len; j < jj; j += 3) {
      dest[destPos++] = src[j] << 24 | src[j + 1] << 16 | src[j + 2] << 8 | 0xff;
    }
  }
  return {
    srcPos: srcPos + len,
    destPos
  };
}
function grayToRGBA(src, dest) {
  if (FeatureTest.isLittleEndian) {
    for (let i = 0, ii = src.length; i < ii; i++) {
      dest[i] = src[i] * 0x10101 | 0xff000000;
    }
  } else {
    for (let i = 0, ii = src.length; i < ii; i++) {
      dest[i] = src[i] * 0x1010100 | 0x000000ff;
    }
  }
}

;// ./src/display/canvas.js
function canvas_classPrivateMethodInitSpec(e, a) { canvas_checkPrivateRedeclaration(e, a), a.add(e); }
function canvas_checkPrivateRedeclaration(e, t) { if (t.has(e)) throw new TypeError("Cannot initialize the same private elements twice on an object"); }
function canvas_assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); }
function canvas_defineProperty(e, r, t) { return (r = canvas_toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function canvas_toPropertyKey(t) { var i = canvas_toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function canvas_toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }





















const MIN_FONT_SIZE = 16;
const MAX_FONT_SIZE = 100;
const EXECUTION_TIME = 15;
const EXECUTION_STEPS = 10;
const FULL_CHUNK_HEIGHT = 16;
const SCALE_MATRIX = new DOMMatrix();
const XY = new Float32Array(2);
const MIN_MAX_INIT = new Float32Array([Infinity, Infinity, -Infinity, -Infinity]);
function mirrorContextOperations(ctx, destCtx) {
  if (ctx._removeMirroring) {
    throw new Error("Context is already forwarding operations.");
  }
  ctx.__originalSave = ctx.save;
  ctx.__originalRestore = ctx.restore;
  ctx.__originalRotate = ctx.rotate;
  ctx.__originalScale = ctx.scale;
  ctx.__originalTranslate = ctx.translate;
  ctx.__originalTransform = ctx.transform;
  ctx.__originalSetTransform = ctx.setTransform;
  ctx.__originalResetTransform = ctx.resetTransform;
  ctx.__originalClip = ctx.clip;
  ctx.__originalMoveTo = ctx.moveTo;
  ctx.__originalLineTo = ctx.lineTo;
  ctx.__originalBezierCurveTo = ctx.bezierCurveTo;
  ctx.__originalRect = ctx.rect;
  ctx.__originalClosePath = ctx.closePath;
  ctx.__originalBeginPath = ctx.beginPath;
  ctx._removeMirroring = () => {
    ctx.save = ctx.__originalSave;
    ctx.restore = ctx.__originalRestore;
    ctx.rotate = ctx.__originalRotate;
    ctx.scale = ctx.__originalScale;
    ctx.translate = ctx.__originalTranslate;
    ctx.transform = ctx.__originalTransform;
    ctx.setTransform = ctx.__originalSetTransform;
    ctx.resetTransform = ctx.__originalResetTransform;
    ctx.clip = ctx.__originalClip;
    ctx.moveTo = ctx.__originalMoveTo;
    ctx.lineTo = ctx.__originalLineTo;
    ctx.bezierCurveTo = ctx.__originalBezierCurveTo;
    ctx.rect = ctx.__originalRect;
    ctx.closePath = ctx.__originalClosePath;
    ctx.beginPath = ctx.__originalBeginPath;
    delete ctx._removeMirroring;
  };
  ctx.save = function () {
    destCtx.save();
    this.__originalSave();
  };
  ctx.restore = function () {
    destCtx.restore();
    this.__originalRestore();
  };
  ctx.translate = function (x, y) {
    destCtx.translate(x, y);
    this.__originalTranslate(x, y);
  };
  ctx.scale = function (x, y) {
    destCtx.scale(x, y);
    this.__originalScale(x, y);
  };
  ctx.transform = function (a, b, c, d, e, f) {
    destCtx.transform(a, b, c, d, e, f);
    this.__originalTransform(a, b, c, d, e, f);
  };
  ctx.setTransform = function (a, b, c, d, e, f) {
    destCtx.setTransform(a, b, c, d, e, f);
    this.__originalSetTransform(a, b, c, d, e, f);
  };
  ctx.resetTransform = function () {
    destCtx.resetTransform();
    this.__originalResetTransform();
  };
  ctx.rotate = function (angle) {
    destCtx.rotate(angle);
    this.__originalRotate(angle);
  };
  ctx.clip = function (rule) {
    destCtx.clip(rule);
    this.__originalClip(rule);
  };
  ctx.moveTo = function (x, y) {
    destCtx.moveTo(x, y);
    this.__originalMoveTo(x, y);
  };
  ctx.lineTo = function (x, y) {
    destCtx.lineTo(x, y);
    this.__originalLineTo(x, y);
  };
  ctx.bezierCurveTo = function (cp1x, cp1y, cp2x, cp2y, x, y) {
    destCtx.bezierCurveTo(cp1x, cp1y, cp2x, cp2y, x, y);
    this.__originalBezierCurveTo(cp1x, cp1y, cp2x, cp2y, x, y);
  };
  ctx.rect = function (x, y, width, height) {
    destCtx.rect(x, y, width, height);
    this.__originalRect(x, y, width, height);
  };
  ctx.closePath = function () {
    destCtx.closePath();
    this.__originalClosePath();
  };
  ctx.beginPath = function () {
    destCtx.beginPath();
    this.__originalBeginPath();
  };
}
class CachedCanvases {
  constructor(canvasFactory) {
    this.canvasFactory = canvasFactory;
    this.cache = Object.create(null);
  }
  getCanvas(id, width, height) {
    let canvasEntry;
    if (this.cache[id] !== undefined) {
      canvasEntry = this.cache[id];
      this.canvasFactory.reset(canvasEntry, width, height);
    } else {
      canvasEntry = this.canvasFactory.create(width, height);
      this.cache[id] = canvasEntry;
    }
    return canvasEntry;
  }
  delete(id) {
    delete this.cache[id];
  }
  clear() {
    for (const id in this.cache) {
      const canvasEntry = this.cache[id];
      this.canvasFactory.destroy(canvasEntry);
      delete this.cache[id];
    }
  }
}
function drawImageAtIntegerCoords(ctx, srcImg, srcX, srcY, srcW, srcH, destX, destY, destW, destH) {
  const [a, b, c, d, tx, ty] = getCurrentTransform(ctx);
  if (b === 0 && c === 0) {
    const tlX = destX * a + tx;
    const rTlX = Math.round(tlX);
    const tlY = destY * d + ty;
    const rTlY = Math.round(tlY);
    const brX = (destX + destW) * a + tx;
    const rWidth = Math.abs(Math.round(brX) - rTlX) || 1;
    const brY = (destY + destH) * d + ty;
    const rHeight = Math.abs(Math.round(brY) - rTlY) || 1;
    ctx.setTransform(Math.sign(a), 0, 0, Math.sign(d), rTlX, rTlY);
    ctx.drawImage(srcImg, srcX, srcY, srcW, srcH, 0, 0, rWidth, rHeight);
    ctx.setTransform(a, b, c, d, tx, ty);
    return [rWidth, rHeight];
  }
  if (a === 0 && d === 0) {
    const tlX = destY * c + tx;
    const rTlX = Math.round(tlX);
    const tlY = destX * b + ty;
    const rTlY = Math.round(tlY);
    const brX = (destY + destH) * c + tx;
    const rWidth = Math.abs(Math.round(brX) - rTlX) || 1;
    const brY = (destX + destW) * b + ty;
    const rHeight = Math.abs(Math.round(brY) - rTlY) || 1;
    ctx.setTransform(0, Math.sign(b), Math.sign(c), 0, rTlX, rTlY);
    ctx.drawImage(srcImg, srcX, srcY, srcW, srcH, 0, 0, rHeight, rWidth);
    ctx.setTransform(a, b, c, d, tx, ty);
    return [rHeight, rWidth];
  }
  ctx.drawImage(srcImg, srcX, srcY, srcW, srcH, destX, destY, destW, destH);
  const scaleX = Math.hypot(a, b);
  const scaleY = Math.hypot(c, d);
  return [scaleX * destW, scaleY * destH];
}
class CanvasExtraState {
  constructor(width, height) {
    canvas_defineProperty(this, "alphaIsShape", false);
    canvas_defineProperty(this, "fontSize", 0);
    canvas_defineProperty(this, "fontSizeScale", 1);
    canvas_defineProperty(this, "textMatrix", null);
    canvas_defineProperty(this, "textMatrixScale", 1);
    canvas_defineProperty(this, "fontMatrix", FONT_IDENTITY_MATRIX);
    canvas_defineProperty(this, "leading", 0);
    canvas_defineProperty(this, "x", 0);
    canvas_defineProperty(this, "y", 0);
    canvas_defineProperty(this, "lineX", 0);
    canvas_defineProperty(this, "lineY", 0);
    canvas_defineProperty(this, "charSpacing", 0);
    canvas_defineProperty(this, "wordSpacing", 0);
    canvas_defineProperty(this, "textHScale", 1);
    canvas_defineProperty(this, "textRenderingMode", TextRenderingMode.FILL);
    canvas_defineProperty(this, "textRise", 0);
    canvas_defineProperty(this, "fillColor", "#000000");
    canvas_defineProperty(this, "strokeColor", "#000000");
    canvas_defineProperty(this, "patternFill", false);
    canvas_defineProperty(this, "patternStroke", false);
    canvas_defineProperty(this, "fillAlpha", 1);
    canvas_defineProperty(this, "strokeAlpha", 1);
    canvas_defineProperty(this, "lineWidth", 1);
    canvas_defineProperty(this, "activeSMask", null);
    canvas_defineProperty(this, "transferMaps", "none");
    this.clipBox = new Float32Array([0, 0, width, height]);
    this.minMax = MIN_MAX_INIT.slice();
  }
  clone() {
    const clone = Object.create(this);
    clone.clipBox = this.clipBox.slice();
    clone.minMax = this.minMax.slice();
    return clone;
  }
  getPathBoundingBox() {
    let pathType = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : PathType.FILL;
    let transform = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
    const box = this.minMax.slice();
    if (pathType === PathType.STROKE) {
      if (!transform) {
        unreachable("Stroke bounding box must include transform.");
      }
      Util.singularValueDecompose2dScale(transform, XY);
      const xStrokePad = XY[0] * this.lineWidth / 2;
      const yStrokePad = XY[1] * this.lineWidth / 2;
      box[0] -= xStrokePad;
      box[1] -= yStrokePad;
      box[2] += xStrokePad;
      box[3] += yStrokePad;
    }
    return box;
  }
  updateClipFromPath() {
    const intersect = Util.intersect(this.clipBox, this.getPathBoundingBox());
    this.startNewPathAndClipBox(intersect || [0, 0, 0, 0]);
  }
  isEmptyClip() {
    return this.minMax[0] === Infinity;
  }
  startNewPathAndClipBox(box) {
    this.clipBox.set(box, 0);
    this.minMax.set(MIN_MAX_INIT, 0);
  }
  getClippedPathBoundingBox() {
    let pathType = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : PathType.FILL;
    let transform = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
    return Util.intersect(this.clipBox, this.getPathBoundingBox(pathType, transform));
  }
}
function putBinaryImageData(ctx, imgData) {
  if (imgData instanceof ImageData) {
    ctx.putImageData(imgData, 0, 0);
    return;
  }
  const height = imgData.height,
    width = imgData.width;
  const partialChunkHeight = height % FULL_CHUNK_HEIGHT;
  const fullChunks = (height - partialChunkHeight) / FULL_CHUNK_HEIGHT;
  const totalChunks = partialChunkHeight === 0 ? fullChunks : fullChunks + 1;
  const chunkImgData = ctx.createImageData(width, FULL_CHUNK_HEIGHT);
  let srcPos = 0,
    destPos;
  const src = imgData.data;
  const dest = chunkImgData.data;
  let i, j, thisChunkHeight, elemsInThisChunk;
  if (imgData.kind === util_ImageKind.GRAYSCALE_1BPP) {
    const srcLength = src.byteLength;
    const dest32 = new Uint32Array(dest.buffer, 0, dest.byteLength >> 2);
    const dest32DataLength = dest32.length;
    const fullSrcDiff = width + 7 >> 3;
    const white = 0xffffffff;
    const black = util_FeatureTest.isLittleEndian ? 0xff000000 : 0x000000ff;
    for (i = 0; i < totalChunks; i++) {
      thisChunkHeight = i < fullChunks ? FULL_CHUNK_HEIGHT : partialChunkHeight;
      destPos = 0;
      for (j = 0; j < thisChunkHeight; j++) {
        const srcDiff = srcLength - srcPos;
        let k = 0;
        const kEnd = srcDiff > fullSrcDiff ? width : srcDiff * 8 - 7;
        const kEndUnrolled = kEnd & ~7;
        let mask = 0;
        let srcByte = 0;
        for (; k < kEndUnrolled; k += 8) {
          srcByte = src[srcPos++];
          dest32[destPos++] = srcByte & 128 ? white : black;
          dest32[destPos++] = srcByte & 64 ? white : black;
          dest32[destPos++] = srcByte & 32 ? white : black;
          dest32[destPos++] = srcByte & 16 ? white : black;
          dest32[destPos++] = srcByte & 8 ? white : black;
          dest32[destPos++] = srcByte & 4 ? white : black;
          dest32[destPos++] = srcByte & 2 ? white : black;
          dest32[destPos++] = srcByte & 1 ? white : black;
        }
        for (; k < kEnd; k++) {
          if (mask === 0) {
            srcByte = src[srcPos++];
            mask = 128;
          }
          dest32[destPos++] = srcByte & mask ? white : black;
          mask >>= 1;
        }
      }
      while (destPos < dest32DataLength) {
        dest32[destPos++] = 0;
      }
      ctx.putImageData(chunkImgData, 0, i * FULL_CHUNK_HEIGHT);
    }
  } else if (imgData.kind === util_ImageKind.RGBA_32BPP) {
    j = 0;
    elemsInThisChunk = width * FULL_CHUNK_HEIGHT * 4;
    for (i = 0; i < fullChunks; i++) {
      dest.set(src.subarray(srcPos, srcPos + elemsInThisChunk));
      srcPos += elemsInThisChunk;
      ctx.putImageData(chunkImgData, 0, j);
      j += FULL_CHUNK_HEIGHT;
    }
    if (i < totalChunks) {
      elemsInThisChunk = width * partialChunkHeight * 4;
      dest.set(src.subarray(srcPos, srcPos + elemsInThisChunk));
      ctx.putImageData(chunkImgData, 0, j);
    }
  } else if (imgData.kind === util_ImageKind.RGB_24BPP) {
    thisChunkHeight = FULL_CHUNK_HEIGHT;
    elemsInThisChunk = width * thisChunkHeight;
    for (i = 0; i < totalChunks; i++) {
      if (i >= fullChunks) {
        thisChunkHeight = partialChunkHeight;
        elemsInThisChunk = width * thisChunkHeight;
      }
      destPos = 0;
      for (j = elemsInThisChunk; j--;) {
        dest[destPos++] = src[srcPos++];
        dest[destPos++] = src[srcPos++];
        dest[destPos++] = src[srcPos++];
        dest[destPos++] = 255;
      }
      ctx.putImageData(chunkImgData, 0, i * FULL_CHUNK_HEIGHT);
    }
  } else {
    throw new Error(`bad image kind: ${imgData.kind}`);
  }
}
function putBinaryImageMask(ctx, imgData) {
  if (imgData.bitmap) {
    ctx.drawImage(imgData.bitmap, 0, 0);
    return;
  }
  const height = imgData.height,
    width = imgData.width;
  const partialChunkHeight = height % FULL_CHUNK_HEIGHT;
  const fullChunks = (height - partialChunkHeight) / FULL_CHUNK_HEIGHT;
  const totalChunks = partialChunkHeight === 0 ? fullChunks : fullChunks + 1;
  const chunkImgData = ctx.createImageData(width, FULL_CHUNK_HEIGHT);
  let srcPos = 0;
  const src = imgData.data;
  const dest = chunkImgData.data;
  for (let i = 0; i < totalChunks; i++) {
    const thisChunkHeight = i < fullChunks ? FULL_CHUNK_HEIGHT : partialChunkHeight;
    ({
      srcPos
    } = convertBlackAndWhiteToRGBA({
      src,
      srcPos,
      dest,
      width,
      height: thisChunkHeight,
      nonBlackColor: 0
    }));
    ctx.putImageData(chunkImgData, 0, i * FULL_CHUNK_HEIGHT);
  }
}
function copyCtxState(sourceCtx, destCtx) {
  const properties = ["strokeStyle", "fillStyle", "fillRule", "globalAlpha", "lineWidth", "lineCap", "lineJoin", "miterLimit", "globalCompositeOperation", "font", "filter"];
  for (const property of properties) {
    if (sourceCtx[property] !== undefined) {
      destCtx[property] = sourceCtx[property];
    }
  }
  if (sourceCtx.setLineDash !== undefined) {
    destCtx.setLineDash(sourceCtx.getLineDash());
    destCtx.lineDashOffset = sourceCtx.lineDashOffset;
  }
}
function resetCtxToDefault(ctx) {
  ctx.strokeStyle = ctx.fillStyle = "#000000";
  ctx.fillRule = "nonzero";
  ctx.globalAlpha = 1;
  ctx.lineWidth = 1;
  ctx.lineCap = "butt";
  ctx.lineJoin = "miter";
  ctx.miterLimit = 10;
  ctx.globalCompositeOperation = "source-over";
  ctx.font = "10px sans-serif";
  if (ctx.setLineDash !== undefined) {
    ctx.setLineDash([]);
    ctx.lineDashOffset = 0;
  }
  const {
    filter
  } = ctx;
  if (filter !== "none" && filter !== "") {
    ctx.filter = "none";
  }
}
function getImageSmoothingEnabled(transform, interpolate) {
  if (interpolate) {
    return true;
  }
  Util.singularValueDecompose2dScale(transform, XY);
  const actualScale = Math.fround(OutputScale.pixelRatio * PixelsPerInch.PDF_TO_CSS_UNITS);
  return XY[0] <= actualScale && XY[1] <= actualScale;
}
const LINE_CAP_STYLES = ["butt", "round", "square"];
const LINE_JOIN_STYLES = ["miter", "round", "bevel"];
const NORMAL_CLIP = {};
const EO_CLIP = {};
var _CanvasGraphics_brand = /*#__PURE__*/new WeakSet();
class CanvasGraphics {
  constructor(canvasCtx, commonObjs, objs, canvasFactory, filterFactory, _ref, annotationCanvasMap, pageColors) {
    let {
      optionalContentConfig,
      markedContentStack = null
    } = _ref;
    canvas_classPrivateMethodInitSpec(this, _CanvasGraphics_brand);
    this.ctx = canvasCtx;
    this.current = new CanvasExtraState(this.ctx.canvas.width, this.ctx.canvas.height);
    this.stateStack = [];
    this.pendingClip = null;
    this.pendingEOFill = false;
    this.res = null;
    this.xobjs = null;
    this.commonObjs = commonObjs;
    this.objs = objs;
    this.canvasFactory = canvasFactory;
    this.filterFactory = filterFactory;
    this.groupStack = [];
    this.baseTransform = null;
    this.baseTransformStack = [];
    this.groupLevel = 0;
    this.smaskStack = [];
    this.smaskCounter = 0;
    this.tempSMask = null;
    this.suspendedCtx = null;
    this.contentVisible = true;
    this.markedContentStack = markedContentStack || [];
    this.optionalContentConfig = optionalContentConfig;
    this.cachedCanvases = new CachedCanvases(this.canvasFactory);
    this.cachedPatterns = new Map();
    this.annotationCanvasMap = annotationCanvasMap;
    this.viewportScale = 1;
    this.outputScaleX = 1;
    this.outputScaleY = 1;
    this.pageColors = pageColors;
    this._cachedScaleForStroking = [-1, 0];
    this._cachedGetSinglePixelWidth = null;
    this._cachedBitmapsMap = new Map();
  }
  getObject(data) {
    let fallback = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
    if (typeof data === "string") {
      return data.startsWith("g_") ? this.commonObjs.get(data) : this.objs.get(data);
    }
    return fallback;
  }
  beginDrawing(_ref2) {
    let {
      transform,
      viewport,
      transparency = false,
      background = null
    } = _ref2;
    const width = this.ctx.canvas.width;
    const height = this.ctx.canvas.height;
    const savedFillStyle = this.ctx.fillStyle;
    this.ctx.fillStyle = background || "#ffffff";
    this.ctx.fillRect(0, 0, width, height);
    this.ctx.fillStyle = savedFillStyle;
    if (transparency) {
      const transparentCanvas = this.cachedCanvases.getCanvas("transparent", width, height);
      this.compositeCtx = this.ctx;
      this.transparentCanvas = transparentCanvas.canvas;
      this.ctx = transparentCanvas.context;
      this.ctx.save();
      this.ctx.transform(...getCurrentTransform(this.compositeCtx));
    }
    this.ctx.save();
    resetCtxToDefault(this.ctx);
    if (transform) {
      this.ctx.transform(...transform);
      this.outputScaleX = transform[0];
      this.outputScaleY = transform[0];
    }
    this.ctx.transform(...viewport.transform);
    this.viewportScale = viewport.scale;
    this.baseTransform = getCurrentTransform(this.ctx);
  }
  executeOperatorList(operatorList, executionStartIdx, continueCallback, stepper) {
    const argsArray = operatorList.argsArray;
    const fnArray = operatorList.fnArray;
    let i = executionStartIdx || 0;
    const argsArrayLen = argsArray.length;
    if (argsArrayLen === i) {
      return i;
    }
    const chunkOperations = argsArrayLen - i > EXECUTION_STEPS && typeof continueCallback === "function";
    const endTime = chunkOperations ? Date.now() + EXECUTION_TIME : 0;
    let steps = 0;
    const commonObjs = this.commonObjs;
    const objs = this.objs;
    let fnId;
    while (true) {
      if (stepper !== undefined && i === stepper.nextBreakPoint) {
        stepper.breakIt(i, continueCallback);
        return i;
      }
      fnId = fnArray[i];
      if (fnId !== OPS.dependency) {
        this[fnId].apply(this, argsArray[i]);
      } else {
        for (const depObjId of argsArray[i]) {
          const objsPool = depObjId.startsWith("g_") ? commonObjs : objs;
          if (!objsPool.has(depObjId)) {
            objsPool.get(depObjId, continueCallback);
            return i;
          }
        }
      }
      i++;
      if (i === argsArrayLen) {
        return i;
      }
      if (chunkOperations && ++steps > EXECUTION_STEPS) {
        if (Date.now() > endTime) {
          continueCallback();
          return i;
        }
        steps = 0;
      }
    }
  }
  endDrawing() {
    canvas_assertClassBrand(_CanvasGraphics_brand, this, _restoreInitialState).call(this);
    this.cachedCanvases.clear();
    this.cachedPatterns.clear();
    for (const cache of this._cachedBitmapsMap.values()) {
      for (const canvas of cache.values()) {
        if (typeof HTMLCanvasElement !== "undefined" && canvas instanceof HTMLCanvasElement) {
          canvas.width = canvas.height = 0;
        }
      }
      cache.clear();
    }
    this._cachedBitmapsMap.clear();
    canvas_assertClassBrand(_CanvasGraphics_brand, this, _drawFilter).call(this);
  }
  _scaleImage(img, inverseTransform) {
    const width = img.width ?? img.displayWidth;
    const height = img.height ?? img.displayHeight;
    let widthScale = Math.max(Math.hypot(inverseTransform[0], inverseTransform[1]), 1);
    let heightScale = Math.max(Math.hypot(inverseTransform[2], inverseTransform[3]), 1);
    let paintWidth = width,
      paintHeight = height;
    let tmpCanvasId = "prescale1";
    let tmpCanvas, tmpCtx;
    while (widthScale > 2 && paintWidth > 1 || heightScale > 2 && paintHeight > 1) {
      let newWidth = paintWidth,
        newHeight = paintHeight;
      if (widthScale > 2 && paintWidth > 1) {
        newWidth = paintWidth >= 16384 ? Math.floor(paintWidth / 2) - 1 || 1 : Math.ceil(paintWidth / 2);
        widthScale /= paintWidth / newWidth;
      }
      if (heightScale > 2 && paintHeight > 1) {
        newHeight = paintHeight >= 16384 ? Math.floor(paintHeight / 2) - 1 || 1 : Math.ceil(paintHeight) / 2;
        heightScale /= paintHeight / newHeight;
      }
      tmpCanvas = this.cachedCanvases.getCanvas(tmpCanvasId, newWidth, newHeight);
      tmpCtx = tmpCanvas.context;
      tmpCtx.clearRect(0, 0, newWidth, newHeight);
      tmpCtx.drawImage(img, 0, 0, paintWidth, paintHeight, 0, 0, newWidth, newHeight);
      img = tmpCanvas.canvas;
      paintWidth = newWidth;
      paintHeight = newHeight;
      tmpCanvasId = tmpCanvasId === "prescale1" ? "prescale2" : "prescale1";
    }
    return {
      img,
      paintWidth,
      paintHeight
    };
  }
  _createMaskCanvas(img) {
    const ctx = this.ctx;
    const {
      width,
      height
    } = img;
    const fillColor = this.current.fillColor;
    const isPatternFill = this.current.patternFill;
    const currentTransform = getCurrentTransform(ctx);
    let cache, cacheKey, scaled, maskCanvas;
    if ((img.bitmap || img.data) && img.count > 1) {
      const mainKey = img.bitmap || img.data.buffer;
      cacheKey = JSON.stringify(isPatternFill ? currentTransform : [currentTransform.slice(0, 4), fillColor]);
      cache = this._cachedBitmapsMap.get(mainKey);
      if (!cache) {
        cache = new Map();
        this._cachedBitmapsMap.set(mainKey, cache);
      }
      const cachedImage = cache.get(cacheKey);
      if (cachedImage && !isPatternFill) {
        const offsetX = Math.round(Math.min(currentTransform[0], currentTransform[2]) + currentTransform[4]);
        const offsetY = Math.round(Math.min(currentTransform[1], currentTransform[3]) + currentTransform[5]);
        return {
          canvas: cachedImage,
          offsetX,
          offsetY
        };
      }
      scaled = cachedImage;
    }
    if (!scaled) {
      maskCanvas = this.cachedCanvases.getCanvas("maskCanvas", width, height);
      putBinaryImageMask(maskCanvas.context, img);
    }
    let maskToCanvas = Util.transform(currentTransform, [1 / width, 0, 0, -1 / height, 0, 0]);
    maskToCanvas = Util.transform(maskToCanvas, [1, 0, 0, 1, 0, -height]);
    const minMax = MIN_MAX_INIT.slice();
    Util.axialAlignedBoundingBox([0, 0, width, height], maskToCanvas, minMax);
    const [minX, minY, maxX, maxY] = minMax;
    const drawnWidth = Math.round(maxX - minX) || 1;
    const drawnHeight = Math.round(maxY - minY) || 1;
    const fillCanvas = this.cachedCanvases.getCanvas("fillCanvas", drawnWidth, drawnHeight);
    const fillCtx = fillCanvas.context;
    const offsetX = minX;
    const offsetY = minY;
    fillCtx.translate(-offsetX, -offsetY);
    fillCtx.transform(...maskToCanvas);
    if (!scaled) {
      scaled = this._scaleImage(maskCanvas.canvas, getCurrentTransformInverse(fillCtx));
      scaled = scaled.img;
      if (cache && isPatternFill) {
        cache.set(cacheKey, scaled);
      }
    }
    fillCtx.imageSmoothingEnabled = getImageSmoothingEnabled(getCurrentTransform(fillCtx), img.interpolate);
    drawImageAtIntegerCoords(fillCtx, scaled, 0, 0, scaled.width, scaled.height, 0, 0, width, height);
    fillCtx.globalCompositeOperation = "source-in";
    const inverse = Util.transform(getCurrentTransformInverse(fillCtx), [1, 0, 0, 1, -offsetX, -offsetY]);
    fillCtx.fillStyle = isPatternFill ? fillColor.getPattern(ctx, this, inverse, PathType.FILL) : fillColor;
    fillCtx.fillRect(0, 0, width, height);
    if (cache && !isPatternFill) {
      this.cachedCanvases.delete("fillCanvas");
      cache.set(cacheKey, fillCanvas.canvas);
    }
    return {
      canvas: fillCanvas.canvas,
      offsetX: Math.round(offsetX),
      offsetY: Math.round(offsetY)
    };
  }
  setLineWidth(width) {
    if (width !== this.current.lineWidth) {
      this._cachedScaleForStroking[0] = -1;
    }
    this.current.lineWidth = width;
    this.ctx.lineWidth = width;
  }
  setLineCap(style) {
    this.ctx.lineCap = LINE_CAP_STYLES[style];
  }
  setLineJoin(style) {
    this.ctx.lineJoin = LINE_JOIN_STYLES[style];
  }
  setMiterLimit(limit) {
    this.ctx.miterLimit = limit;
  }
  setDash(dashArray, dashPhase) {
    const ctx = this.ctx;
    if (ctx.setLineDash !== undefined) {
      ctx.setLineDash(dashArray);
      ctx.lineDashOffset = dashPhase;
    }
  }
  setRenderingIntent(intent) {}
  setFlatness(flatness) {}
  setGState(states) {
    for (const [key, value] of states) {
      switch (key) {
        case "LW":
          this.setLineWidth(value);
          break;
        case "LC":
          this.setLineCap(value);
          break;
        case "LJ":
          this.setLineJoin(value);
          break;
        case "ML":
          this.setMiterLimit(value);
          break;
        case "D":
          this.setDash(value[0], value[1]);
          break;
        case "RI":
          this.setRenderingIntent(value);
          break;
        case "FL":
          this.setFlatness(value);
          break;
        case "Font":
          this.setFont(value[0], value[1]);
          break;
        case "CA":
          this.current.strokeAlpha = value;
          break;
        case "ca":
          this.ctx.globalAlpha = this.current.fillAlpha = value;
          break;
        case "BM":
          this.ctx.globalCompositeOperation = value;
          break;
        case "SMask":
          this.current.activeSMask = value ? this.tempSMask : null;
          this.tempSMask = null;
          this.checkSMaskState();
          break;
        case "TR":
          this.ctx.filter = this.current.transferMaps = this.filterFactory.addFilter(value);
          break;
      }
    }
  }
  get inSMaskMode() {
    return !!this.suspendedCtx;
  }
  checkSMaskState() {
    const inSMaskMode = this.inSMaskMode;
    if (this.current.activeSMask && !inSMaskMode) {
      this.beginSMaskMode();
    } else if (!this.current.activeSMask && inSMaskMode) {
      this.endSMaskMode();
    }
  }
  beginSMaskMode() {
    if (this.inSMaskMode) {
      throw new Error("beginSMaskMode called while already in smask mode");
    }
    const drawnWidth = this.ctx.canvas.width;
    const drawnHeight = this.ctx.canvas.height;
    const cacheId = "smaskGroupAt" + this.groupLevel;
    const scratchCanvas = this.cachedCanvases.getCanvas(cacheId, drawnWidth, drawnHeight);
    this.suspendedCtx = this.ctx;
    const ctx = this.ctx = scratchCanvas.context;
    ctx.setTransform(this.suspendedCtx.getTransform());
    copyCtxState(this.suspendedCtx, ctx);
    mirrorContextOperations(ctx, this.suspendedCtx);
    this.setGState([["BM", "source-over"]]);
  }
  endSMaskMode() {
    if (!this.inSMaskMode) {
      throw new Error("endSMaskMode called while not in smask mode");
    }
    this.ctx._removeMirroring();
    copyCtxState(this.ctx, this.suspendedCtx);
    this.ctx = this.suspendedCtx;
    this.suspendedCtx = null;
  }
  compose(dirtyBox) {
    if (!this.current.activeSMask) {
      return;
    }
    if (!dirtyBox) {
      dirtyBox = [0, 0, this.ctx.canvas.width, this.ctx.canvas.height];
    } else {
      dirtyBox[0] = Math.floor(dirtyBox[0]);
      dirtyBox[1] = Math.floor(dirtyBox[1]);
      dirtyBox[2] = Math.ceil(dirtyBox[2]);
      dirtyBox[3] = Math.ceil(dirtyBox[3]);
    }
    const smask = this.current.activeSMask;
    const suspendedCtx = this.suspendedCtx;
    this.composeSMask(suspendedCtx, smask, this.ctx, dirtyBox);
    this.ctx.save();
    this.ctx.setTransform(1, 0, 0, 1, 0, 0);
    this.ctx.clearRect(0, 0, this.ctx.canvas.width, this.ctx.canvas.height);
    this.ctx.restore();
  }
  composeSMask(ctx, smask, layerCtx, layerBox) {
    const layerOffsetX = layerBox[0];
    const layerOffsetY = layerBox[1];
    const layerWidth = layerBox[2] - layerOffsetX;
    const layerHeight = layerBox[3] - layerOffsetY;
    if (layerWidth === 0 || layerHeight === 0) {
      return;
    }
    this.genericComposeSMask(smask.context, layerCtx, layerWidth, layerHeight, smask.subtype, smask.backdrop, smask.transferMap, layerOffsetX, layerOffsetY, smask.offsetX, smask.offsetY);
    ctx.save();
    ctx.globalAlpha = 1;
    ctx.globalCompositeOperation = "source-over";
    ctx.setTransform(1, 0, 0, 1, 0, 0);
    ctx.drawImage(layerCtx.canvas, 0, 0);
    ctx.restore();
  }
  genericComposeSMask(maskCtx, layerCtx, width, height, subtype, backdrop, transferMap, layerOffsetX, layerOffsetY, maskOffsetX, maskOffsetY) {
    let maskCanvas = maskCtx.canvas;
    let maskX = layerOffsetX - maskOffsetX;
    let maskY = layerOffsetY - maskOffsetY;
    if (backdrop) {
      if (maskX < 0 || maskY < 0 || maskX + width > maskCanvas.width || maskY + height > maskCanvas.height) {
        const canvas = this.cachedCanvases.getCanvas("maskExtension", width, height);
        const ctx = canvas.context;
        ctx.drawImage(maskCanvas, -maskX, -maskY);
        ctx.globalCompositeOperation = "destination-atop";
        ctx.fillStyle = backdrop;
        ctx.fillRect(0, 0, width, height);
        ctx.globalCompositeOperation = "source-over";
        maskCanvas = canvas.canvas;
        maskX = maskY = 0;
      } else {
        maskCtx.save();
        maskCtx.globalAlpha = 1;
        maskCtx.setTransform(1, 0, 0, 1, 0, 0);
        const clip = new Path2D();
        clip.rect(maskX, maskY, width, height);
        maskCtx.clip(clip);
        maskCtx.globalCompositeOperation = "destination-atop";
        maskCtx.fillStyle = backdrop;
        maskCtx.fillRect(maskX, maskY, width, height);
        maskCtx.restore();
      }
    }
    layerCtx.save();
    layerCtx.globalAlpha = 1;
    layerCtx.setTransform(1, 0, 0, 1, 0, 0);
    if (subtype === "Alpha" && transferMap) {
      layerCtx.filter = this.filterFactory.addAlphaFilter(transferMap);
    } else if (subtype === "Luminosity") {
      layerCtx.filter = this.filterFactory.addLuminosityFilter(transferMap);
    }
    const clip = new Path2D();
    clip.rect(layerOffsetX, layerOffsetY, width, height);
    layerCtx.clip(clip);
    layerCtx.globalCompositeOperation = "destination-in";
    layerCtx.drawImage(maskCanvas, maskX, maskY, width, height, layerOffsetX, layerOffsetY, width, height);
    layerCtx.restore();
  }
  save() {
    if (this.inSMaskMode) {
      copyCtxState(this.ctx, this.suspendedCtx);
    }
    this.ctx.save();
    const old = this.current;
    this.stateStack.push(old);
    this.current = old.clone();
  }
  restore() {
    if (this.stateStack.length === 0) {
      if (this.inSMaskMode) {
        this.endSMaskMode();
      }
      return;
    }
    this.current = this.stateStack.pop();
    this.ctx.restore();
    if (this.inSMaskMode) {
      copyCtxState(this.suspendedCtx, this.ctx);
    }
    this.checkSMaskState();
    this.pendingClip = null;
    this._cachedScaleForStroking[0] = -1;
    this._cachedGetSinglePixelWidth = null;
  }
  transform(a, b, c, d, e, f) {
    this.ctx.transform(a, b, c, d, e, f);
    this._cachedScaleForStroking[0] = -1;
    this._cachedGetSinglePixelWidth = null;
  }
  constructPath(op, data, minMax) {
    let [path] = data;
    if (!minMax) {
      path ||= data[0] = new Path2D();
      this[op](path);
      return;
    }
    if (!(path instanceof Path2D)) {
      const path2d = data[0] = new Path2D();
      for (let i = 0, ii = path.length; i < ii;) {
        switch (path[i++]) {
          case DrawOPS.moveTo:
            path2d.moveTo(path[i++], path[i++]);
            break;
          case DrawOPS.lineTo:
            path2d.lineTo(path[i++], path[i++]);
            break;
          case DrawOPS.curveTo:
            path2d.bezierCurveTo(path[i++], path[i++], path[i++], path[i++], path[i++], path[i++]);
            break;
          case DrawOPS.closePath:
            path2d.closePath();
            break;
          default:
            warn(`Unrecognized drawing path operator: ${path[i - 1]}`);
            break;
        }
      }
      path = path2d;
    }
    Util.axialAlignedBoundingBox(minMax, getCurrentTransform(this.ctx), this.current.minMax);
    this[op](path);
  }
  closePath() {
    this.ctx.closePath();
  }
  stroke(path) {
    let consumePath = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;
    const ctx = this.ctx;
    const strokeColor = this.current.strokeColor;
    ctx.globalAlpha = this.current.strokeAlpha;
    if (this.contentVisible) {
      if (typeof strokeColor === "object" && strokeColor?.getPattern) {
        const baseTransform = strokeColor.isModifyingCurrentTransform() ? ctx.getTransform() : null;
        ctx.save();
        ctx.strokeStyle = strokeColor.getPattern(ctx, this, getCurrentTransformInverse(ctx), PathType.STROKE);
        if (baseTransform) {
          const newPath = new Path2D();
          newPath.addPath(path, ctx.getTransform().invertSelf().multiplySelf(baseTransform));
          path = newPath;
        }
        this.rescaleAndStroke(path, false);
        ctx.restore();
      } else {
        this.rescaleAndStroke(path, true);
      }
    }
    if (consumePath) {
      this.consumePath(path, this.current.getClippedPathBoundingBox(PathType.STROKE, getCurrentTransform(this.ctx)));
    }
    ctx.globalAlpha = this.current.fillAlpha;
  }
  closeStroke(path) {
    this.stroke(path);
  }
  fill(path) {
    let consumePath = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;
    const ctx = this.ctx;
    const fillColor = this.current.fillColor;
    const isPatternFill = this.current.patternFill;
    let needRestore = false;
    if (isPatternFill) {
      const baseTransform = fillColor.isModifyingCurrentTransform() ? ctx.getTransform() : null;
      ctx.save();
      ctx.fillStyle = fillColor.getPattern(ctx, this, getCurrentTransformInverse(ctx), PathType.FILL);
      if (baseTransform) {
        const newPath = new Path2D();
        newPath.addPath(path, ctx.getTransform().invertSelf().multiplySelf(baseTransform));
        path = newPath;
      }
      needRestore = true;
    }
    const intersect = this.current.getClippedPathBoundingBox();
    if (this.contentVisible && intersect !== null) {
      if (this.pendingEOFill) {
        ctx.fill(path, "evenodd");
        this.pendingEOFill = false;
      } else {
        ctx.fill(path);
      }
    }
    if (needRestore) {
      ctx.restore();
    }
    if (consumePath) {
      this.consumePath(path, intersect);
    }
  }
  eoFill(path) {
    this.pendingEOFill = true;
    this.fill(path);
  }
  fillStroke(path) {
    this.fill(path, false);
    this.stroke(path, false);
    this.consumePath(path);
  }
  eoFillStroke(path) {
    this.pendingEOFill = true;
    this.fillStroke(path);
  }
  closeFillStroke(path) {
    this.fillStroke(path);
  }
  closeEOFillStroke(path) {
    this.pendingEOFill = true;
    this.fillStroke(path);
  }
  endPath(path) {
    this.consumePath(path);
  }
  rawFillPath(path) {
    this.ctx.fill(path);
  }
  clip() {
    this.pendingClip = NORMAL_CLIP;
  }
  eoClip() {
    this.pendingClip = EO_CLIP;
  }
  beginText() {
    this.current.textMatrix = null;
    this.current.textMatrixScale = 1;
    this.current.x = this.current.lineX = 0;
    this.current.y = this.current.lineY = 0;
  }
  endText() {
    const paths = this.pendingTextPaths;
    const ctx = this.ctx;
    if (paths === undefined) {
      return;
    }
    const newPath = new Path2D();
    const invTransf = ctx.getTransform().invertSelf();
    for (const {
      transform,
      x,
      y,
      fontSize,
      path
    } of paths) {
      newPath.addPath(path, new DOMMatrix(transform).preMultiplySelf(invTransf).translate(x, y).scale(fontSize, -fontSize));
    }
    ctx.clip(newPath);
    delete this.pendingTextPaths;
  }
  setCharSpacing(spacing) {
    this.current.charSpacing = spacing;
  }
  setWordSpacing(spacing) {
    this.current.wordSpacing = spacing;
  }
  setHScale(scale) {
    this.current.textHScale = scale / 100;
  }
  setLeading(leading) {
    this.current.leading = -leading;
  }
  setFont(fontRefName, size) {
    const fontObj = this.commonObjs.get(fontRefName);
    const current = this.current;
    if (!fontObj) {
      throw new Error(`Can't find font for ${fontRefName}`);
    }
    current.fontMatrix = fontObj.fontMatrix || FONT_IDENTITY_MATRIX;
    if (current.fontMatrix[0] === 0 || current.fontMatrix[3] === 0) {
      warn("Invalid font matrix for font " + fontRefName);
    }
    if (size < 0) {
      size = -size;
      current.fontDirection = -1;
    } else {
      current.fontDirection = 1;
    }
    this.current.font = fontObj;
    this.current.fontSize = size;
    if (fontObj.isType3Font) {
      return;
    }
    const name = fontObj.loadedName || "sans-serif";
    const typeface = fontObj.systemFontInfo?.css || `"${name}", ${fontObj.fallbackName}`;
    let bold = "normal";
    if (fontObj.black) {
      bold = "900";
    } else if (fontObj.bold) {
      bold = "bold";
    }
    const italic = fontObj.italic ? "italic" : "normal";
    let browserFontSize = size;
    if (size < MIN_FONT_SIZE) {
      browserFontSize = MIN_FONT_SIZE;
    } else if (size > MAX_FONT_SIZE) {
      browserFontSize = MAX_FONT_SIZE;
    }
    this.current.fontSizeScale = size / browserFontSize;
    this.ctx.font = `${italic} ${bold} ${browserFontSize}px ${typeface}`;
  }
  setTextRenderingMode(mode) {
    this.current.textRenderingMode = mode;
  }
  setTextRise(rise) {
    this.current.textRise = rise;
  }
  moveText(x, y) {
    this.current.x = this.current.lineX += x;
    this.current.y = this.current.lineY += y;
  }
  setLeadingMoveText(x, y) {
    this.setLeading(-y);
    this.moveText(x, y);
  }
  setTextMatrix(matrix) {
    const {
      current
    } = this;
    current.textMatrix = matrix;
    current.textMatrixScale = Math.hypot(matrix[0], matrix[1]);
    current.x = current.lineX = 0;
    current.y = current.lineY = 0;
  }
  nextLine() {
    this.moveText(0, this.current.leading);
  }
  paintChar(character, x, y, patternFillTransform, patternStrokeTransform) {
    const ctx = this.ctx;
    const current = this.current;
    const font = current.font;
    const textRenderingMode = current.textRenderingMode;
    const fontSize = current.fontSize / current.fontSizeScale;
    const fillStrokeMode = textRenderingMode & TextRenderingMode.FILL_STROKE_MASK;
    const isAddToPathSet = !!(textRenderingMode & TextRenderingMode.ADD_TO_PATH_FLAG);
    const patternFill = current.patternFill && !font.missingFile;
    const patternStroke = current.patternStroke && !font.missingFile;
    let path;
    if (font.disableFontFace || isAddToPathSet || patternFill || patternStroke) {
      path = font.getPathGenerator(this.commonObjs, character);
    }
    if (font.disableFontFace || patternFill || patternStroke) {
      ctx.save();
      ctx.translate(x, y);
      ctx.scale(fontSize, -fontSize);
      let currentTransform;
      if (fillStrokeMode === TextRenderingMode.FILL || fillStrokeMode === TextRenderingMode.FILL_STROKE) {
        if (patternFillTransform) {
          currentTransform = ctx.getTransform();
          ctx.setTransform(...patternFillTransform);
          ctx.fill(canvas_assertClassBrand(_CanvasGraphics_brand, this, _getScaledPath).call(this, path, currentTransform, patternFillTransform));
        } else {
          ctx.fill(path);
        }
      }
      if (fillStrokeMode === TextRenderingMode.STROKE || fillStrokeMode === TextRenderingMode.FILL_STROKE) {
        if (patternStrokeTransform) {
          currentTransform ||= ctx.getTransform();
          ctx.setTransform(...patternStrokeTransform);
          const {
            a,
            b,
            c,
            d
          } = currentTransform;
          const invPatternTransform = Util.inverseTransform(patternStrokeTransform);
          const transf = Util.transform([a, b, c, d, 0, 0], invPatternTransform);
          Util.singularValueDecompose2dScale(transf, XY);
          ctx.lineWidth *= Math.max(XY[0], XY[1]) / fontSize;
          ctx.stroke(canvas_assertClassBrand(_CanvasGraphics_brand, this, _getScaledPath).call(this, path, currentTransform, patternStrokeTransform));
        } else {
          ctx.lineWidth /= fontSize;
          ctx.stroke(path);
        }
      }
      ctx.restore();
    } else {
      if (fillStrokeMode === TextRenderingMode.FILL || fillStrokeMode === TextRenderingMode.FILL_STROKE) {
        ctx.fillText(character, x, y);
      }
      if (fillStrokeMode === TextRenderingMode.STROKE || fillStrokeMode === TextRenderingMode.FILL_STROKE) {
        ctx.strokeText(character, x, y);
      }
    }
    if (isAddToPathSet) {
      const paths = this.pendingTextPaths ||= [];
      paths.push({
        transform: getCurrentTransform(ctx),
        x,
        y,
        fontSize,
        path
      });
    }
  }
  get isFontSubpixelAAEnabled() {
    const {
      context: ctx
    } = this.cachedCanvases.getCanvas("isFontSubpixelAAEnabled", 10, 10);
    ctx.scale(1.5, 1);
    ctx.fillText("I", 0, 10);
    const data = ctx.getImageData(0, 0, 10, 10).data;
    let enabled = false;
    for (let i = 3; i < data.length; i += 4) {
      if (data[i] > 0 && data[i] < 255) {
        enabled = true;
        break;
      }
    }
    return shadow(this, "isFontSubpixelAAEnabled", enabled);
  }
  showText(glyphs) {
    const current = this.current;
    const font = current.font;
    if (font.isType3Font) {
      return this.showType3Text(glyphs);
    }
    const fontSize = current.fontSize;
    if (fontSize === 0) {
      return undefined;
    }
    const ctx = this.ctx;
    const fontSizeScale = current.fontSizeScale;
    const charSpacing = current.charSpacing;
    const wordSpacing = current.wordSpacing;
    const fontDirection = current.fontDirection;
    const textHScale = current.textHScale * fontDirection;
    const glyphsLength = glyphs.length;
    const vertical = font.vertical;
    const spacingDir = vertical ? 1 : -1;
    const defaultVMetrics = font.defaultVMetrics;
    const widthAdvanceScale = fontSize * current.fontMatrix[0];
    const simpleFillText = current.textRenderingMode === TextRenderingMode.FILL && !font.disableFontFace && !current.patternFill;
    ctx.save();
    if (current.textMatrix) {
      ctx.transform(...current.textMatrix);
    }
    ctx.translate(current.x, current.y + current.textRise);
    if (fontDirection > 0) {
      ctx.scale(textHScale, -1);
    } else {
      ctx.scale(textHScale, 1);
    }
    let patternFillTransform, patternStrokeTransform;
    if (current.patternFill) {
      ctx.save();
      const pattern = current.fillColor.getPattern(ctx, this, getCurrentTransformInverse(ctx), PathType.FILL);
      patternFillTransform = getCurrentTransform(ctx);
      ctx.restore();
      ctx.fillStyle = pattern;
    }
    if (current.patternStroke) {
      ctx.save();
      const pattern = current.strokeColor.getPattern(ctx, this, getCurrentTransformInverse(ctx), PathType.STROKE);
      patternStrokeTransform = getCurrentTransform(ctx);
      ctx.restore();
      ctx.strokeStyle = pattern;
    }
    let lineWidth = current.lineWidth;
    const scale = current.textMatrixScale;
    if (scale === 0 || lineWidth === 0) {
      const fillStrokeMode = current.textRenderingMode & TextRenderingMode.FILL_STROKE_MASK;
      if (fillStrokeMode === TextRenderingMode.STROKE || fillStrokeMode === TextRenderingMode.FILL_STROKE) {
        lineWidth = this.getSinglePixelWidth();
      }
    } else {
      lineWidth /= scale;
    }
    if (fontSizeScale !== 1.0) {
      ctx.scale(fontSizeScale, fontSizeScale);
      lineWidth /= fontSizeScale;
    }
    ctx.lineWidth = lineWidth;
    if (font.isInvalidPDFjsFont) {
      const chars = [];
      let width = 0;
      for (const glyph of glyphs) {
        chars.push(glyph.unicode);
        width += glyph.width;
      }
      ctx.fillText(chars.join(""), 0, 0);
      current.x += width * widthAdvanceScale * textHScale;
      ctx.restore();
      this.compose();
      return undefined;
    }
    let x = 0,
      i;
    for (i = 0; i < glyphsLength; ++i) {
      const glyph = glyphs[i];
      if (typeof glyph === "number") {
        x += spacingDir * glyph * fontSize / 1000;
        continue;
      }
      let restoreNeeded = false;
      const spacing = (glyph.isSpace ? wordSpacing : 0) + charSpacing;
      const character = glyph.fontChar;
      const accent = glyph.accent;
      let scaledX, scaledY;
      let width = glyph.width;
      if (vertical) {
        const vmetric = glyph.vmetric || defaultVMetrics;
        const vx = -(glyph.vmetric ? vmetric[1] : width * 0.5) * widthAdvanceScale;
        const vy = vmetric[2] * widthAdvanceScale;
        width = vmetric ? -vmetric[0] : width;
        scaledX = vx / fontSizeScale;
        scaledY = (x + vy) / fontSizeScale;
      } else {
        scaledX = x / fontSizeScale;
        scaledY = 0;
      }
      if (font.remeasure && width > 0) {
        const measuredWidth = ctx.measureText(character).width * 1000 / fontSize * fontSizeScale;
        if (width < measuredWidth && this.isFontSubpixelAAEnabled) {
          const characterScaleX = width / measuredWidth;
          restoreNeeded = true;
          ctx.save();
          ctx.scale(characterScaleX, 1);
          scaledX /= characterScaleX;
        } else if (width !== measuredWidth) {
          scaledX += (width - measuredWidth) / 2000 * fontSize / fontSizeScale;
        }
      }
      if (this.contentVisible && (glyph.isInFont || font.missingFile)) {
        if (simpleFillText && !accent) {
          ctx.fillText(character, scaledX, scaledY);
        } else {
          this.paintChar(character, scaledX, scaledY, patternFillTransform, patternStrokeTransform);
          if (accent) {
            const scaledAccentX = scaledX + fontSize * accent.offset.x / fontSizeScale;
            const scaledAccentY = scaledY - fontSize * accent.offset.y / fontSizeScale;
            this.paintChar(accent.fontChar, scaledAccentX, scaledAccentY, patternFillTransform, patternStrokeTransform);
          }
        }
      }
      const charWidth = vertical ? width * widthAdvanceScale - spacing * fontDirection : width * widthAdvanceScale + spacing * fontDirection;
      x += charWidth;
      if (restoreNeeded) {
        ctx.restore();
      }
    }
    if (vertical) {
      current.y -= x;
    } else {
      current.x += x * textHScale;
    }
    ctx.restore();
    this.compose();
    return undefined;
  }
  showType3Text(glyphs) {
    const ctx = this.ctx;
    const current = this.current;
    const font = current.font;
    const fontSize = current.fontSize;
    const fontDirection = current.fontDirection;
    const spacingDir = font.vertical ? 1 : -1;
    const charSpacing = current.charSpacing;
    const wordSpacing = current.wordSpacing;
    const textHScale = current.textHScale * fontDirection;
    const fontMatrix = current.fontMatrix || FONT_IDENTITY_MATRIX;
    const glyphsLength = glyphs.length;
    const isTextInvisible = current.textRenderingMode === TextRenderingMode.INVISIBLE;
    let i, glyph, width, spacingLength;
    if (isTextInvisible || fontSize === 0) {
      return;
    }
    this._cachedScaleForStroking[0] = -1;
    this._cachedGetSinglePixelWidth = null;
    ctx.save();
    if (current.textMatrix) {
      ctx.transform(...current.textMatrix);
    }
    ctx.translate(current.x, current.y + current.textRise);
    ctx.scale(textHScale, fontDirection);
    for (i = 0; i < glyphsLength; ++i) {
      glyph = glyphs[i];
      if (typeof glyph === "number") {
        spacingLength = spacingDir * glyph * fontSize / 1000;
        this.ctx.translate(spacingLength, 0);
        current.x += spacingLength * textHScale;
        continue;
      }
      const spacing = (glyph.isSpace ? wordSpacing : 0) + charSpacing;
      const operatorList = font.charProcOperatorList[glyph.operatorListId];
      if (!operatorList) {
        warn(`Type3 character "${glyph.operatorListId}" is not available.`);
      } else if (this.contentVisible) {
        this.save();
        ctx.scale(fontSize, fontSize);
        ctx.transform(...fontMatrix);
        this.executeOperatorList(operatorList);
        this.restore();
      }
      const p = [glyph.width, 0];
      Util.applyTransform(p, fontMatrix);
      width = p[0] * fontSize + spacing;
      ctx.translate(width, 0);
      current.x += width * textHScale;
    }
    ctx.restore();
  }
  setCharWidth(xWidth, yWidth) {}
  setCharWidthAndBounds(xWidth, yWidth, llx, lly, urx, ury) {
    const clip = new Path2D();
    clip.rect(llx, lly, urx - llx, ury - lly);
    this.ctx.clip(clip);
    this.endPath();
  }
  getColorN_Pattern(IR) {
    let pattern;
    if (IR[0] === "TilingPattern") {
      const baseTransform = this.baseTransform || getCurrentTransform(this.ctx);
      const canvasGraphicsFactory = {
        createCanvasGraphics: ctx => new CanvasGraphics(ctx, this.commonObjs, this.objs, this.canvasFactory, this.filterFactory, {
          optionalContentConfig: this.optionalContentConfig,
          markedContentStack: this.markedContentStack
        })
      };
      pattern = new TilingPattern(IR, this.ctx, canvasGraphicsFactory, baseTransform);
    } else {
      pattern = this._getPattern(IR[1], IR[2]);
    }
    return pattern;
  }
  setStrokeColorN() {
    this.current.strokeColor = this.getColorN_Pattern(arguments);
    this.current.patternStroke = true;
  }
  setFillColorN() {
    this.current.fillColor = this.getColorN_Pattern(arguments);
    this.current.patternFill = true;
  }
  setStrokeRGBColor(color) {
    this.ctx.strokeStyle = this.current.strokeColor = color;
    this.current.patternStroke = false;
  }
  setStrokeTransparent() {
    this.ctx.strokeStyle = this.current.strokeColor = "transparent";
    this.current.patternStroke = false;
  }
  setFillRGBColor(color) {
    this.ctx.fillStyle = this.current.fillColor = color;
    this.current.patternFill = false;
  }
  setFillTransparent() {
    this.ctx.fillStyle = this.current.fillColor = "transparent";
    this.current.patternFill = false;
  }
  _getPattern(objId) {
    let matrix = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
    let pattern;
    if (this.cachedPatterns.has(objId)) {
      pattern = this.cachedPatterns.get(objId);
    } else {
      pattern = getShadingPattern(this.getObject(objId));
      this.cachedPatterns.set(objId, pattern);
    }
    if (matrix) {
      pattern.matrix = matrix;
    }
    return pattern;
  }
  shadingFill(objId) {
    if (!this.contentVisible) {
      return;
    }
    const ctx = this.ctx;
    this.save();
    const pattern = this._getPattern(objId);
    ctx.fillStyle = pattern.getPattern(ctx, this, getCurrentTransformInverse(ctx), PathType.SHADING);
    const inv = getCurrentTransformInverse(ctx);
    if (inv) {
      const {
        width,
        height
      } = ctx.canvas;
      const minMax = MIN_MAX_INIT.slice();
      Util.axialAlignedBoundingBox([0, 0, width, height], inv, minMax);
      const [x0, y0, x1, y1] = minMax;
      this.ctx.fillRect(x0, y0, x1 - x0, y1 - y0);
    } else {
      this.ctx.fillRect(-1e10, -1e10, 2e10, 2e10);
    }
    this.compose(this.current.getClippedPathBoundingBox());
    this.restore();
  }
  beginInlineImage() {
    unreachable("Should not call beginInlineImage");
  }
  beginImageData() {
    unreachable("Should not call beginImageData");
  }
  paintFormXObjectBegin(matrix, bbox) {
    if (!this.contentVisible) {
      return;
    }
    this.save();
    this.baseTransformStack.push(this.baseTransform);
    if (matrix) {
      this.transform(...matrix);
    }
    this.baseTransform = getCurrentTransform(this.ctx);
    if (bbox) {
      Util.axialAlignedBoundingBox(bbox, this.baseTransform, this.current.minMax);
      const [x0, y0, x1, y1] = bbox;
      const clip = new Path2D();
      clip.rect(x0, y0, x1 - x0, y1 - y0);
      this.ctx.clip(clip);
      this.endPath();
    }
  }
  paintFormXObjectEnd() {
    if (!this.contentVisible) {
      return;
    }
    this.restore();
    this.baseTransform = this.baseTransformStack.pop();
  }
  beginGroup(group) {
    if (!this.contentVisible) {
      return;
    }
    this.save();
    if (this.inSMaskMode) {
      this.endSMaskMode();
      this.current.activeSMask = null;
    }
    const currentCtx = this.ctx;
    if (!group.isolated) {
      info("TODO: Support non-isolated groups.");
    }
    if (group.knockout) {
      warn("Knockout groups not supported.");
    }
    const currentTransform = getCurrentTransform(currentCtx);
    if (group.matrix) {
      currentCtx.transform(...group.matrix);
    }
    if (!group.bbox) {
      throw new Error("Bounding box is required.");
    }
    let bounds = MIN_MAX_INIT.slice();
    Util.axialAlignedBoundingBox(group.bbox, getCurrentTransform(currentCtx), bounds);
    const canvasBounds = [0, 0, currentCtx.canvas.width, currentCtx.canvas.height];
    bounds = Util.intersect(bounds, canvasBounds) || [0, 0, 0, 0];
    const offsetX = Math.floor(bounds[0]);
    const offsetY = Math.floor(bounds[1]);
    const drawnWidth = Math.max(Math.ceil(bounds[2]) - offsetX, 1);
    const drawnHeight = Math.max(Math.ceil(bounds[3]) - offsetY, 1);
    this.current.startNewPathAndClipBox([0, 0, drawnWidth, drawnHeight]);
    let cacheId = "groupAt" + this.groupLevel;
    if (group.smask) {
      cacheId += "_smask_" + this.smaskCounter++ % 2;
    }
    const scratchCanvas = this.cachedCanvases.getCanvas(cacheId, drawnWidth, drawnHeight);
    const groupCtx = scratchCanvas.context;
    groupCtx.translate(-offsetX, -offsetY);
    groupCtx.transform(...currentTransform);
    let clip = new Path2D();
    const [x0, y0, x1, y1] = group.bbox;
    clip.rect(x0, y0, x1 - x0, y1 - y0);
    if (group.matrix) {
      const path = new Path2D();
      path.addPath(clip, new DOMMatrix(group.matrix));
      clip = path;
    }
    groupCtx.clip(clip);
    if (group.smask) {
      this.smaskStack.push({
        canvas: scratchCanvas.canvas,
        context: groupCtx,
        offsetX,
        offsetY,
        subtype: group.smask.subtype,
        backdrop: group.smask.backdrop,
        transferMap: group.smask.transferMap || null,
        startTransformInverse: null
      });
    } else {
      currentCtx.setTransform(1, 0, 0, 1, 0, 0);
      currentCtx.translate(offsetX, offsetY);
      currentCtx.save();
    }
    copyCtxState(currentCtx, groupCtx);
    this.ctx = groupCtx;
    this.setGState([["BM", "source-over"], ["ca", 1], ["CA", 1]]);
    this.groupStack.push(currentCtx);
    this.groupLevel++;
  }
  endGroup(group) {
    if (!this.contentVisible) {
      return;
    }
    this.groupLevel--;
    const groupCtx = this.ctx;
    const ctx = this.groupStack.pop();
    this.ctx = ctx;
    this.ctx.imageSmoothingEnabled = false;
    if (group.smask) {
      this.tempSMask = this.smaskStack.pop();
      this.restore();
    } else {
      this.ctx.restore();
      const currentMtx = getCurrentTransform(this.ctx);
      this.restore();
      this.ctx.save();
      this.ctx.setTransform(...currentMtx);
      const dirtyBox = MIN_MAX_INIT.slice();
      Util.axialAlignedBoundingBox([0, 0, groupCtx.canvas.width, groupCtx.canvas.height], currentMtx, dirtyBox);
      this.ctx.drawImage(groupCtx.canvas, 0, 0);
      this.ctx.restore();
      this.compose(dirtyBox);
    }
  }
  beginAnnotation(id, rect, transform, matrix, hasOwnCanvas) {
    canvas_assertClassBrand(_CanvasGraphics_brand, this, _restoreInitialState).call(this);
    resetCtxToDefault(this.ctx);
    this.ctx.save();
    this.save();
    if (this.baseTransform) {
      this.ctx.setTransform(...this.baseTransform);
    }
    if (rect) {
      const width = rect[2] - rect[0];
      const height = rect[3] - rect[1];
      if (hasOwnCanvas && this.annotationCanvasMap) {
        transform = transform.slice();
        transform[4] -= rect[0];
        transform[5] -= rect[1];
        rect = rect.slice();
        rect[0] = rect[1] = 0;
        rect[2] = width;
        rect[3] = height;
        Util.singularValueDecompose2dScale(getCurrentTransform(this.ctx), XY);
        const {
          viewportScale
        } = this;
        const canvasWidth = Math.ceil(width * this.outputScaleX * viewportScale);
        const canvasHeight = Math.ceil(height * this.outputScaleY * viewportScale);
        this.annotationCanvas = this.canvasFactory.create(canvasWidth, canvasHeight);
        const {
          canvas,
          context
        } = this.annotationCanvas;
        this.annotationCanvasMap.set(id, canvas);
        this.annotationCanvas.savedCtx = this.ctx;
        this.ctx = context;
        this.ctx.save();
        this.ctx.setTransform(XY[0], 0, 0, -XY[1], 0, height * XY[1]);
        resetCtxToDefault(this.ctx);
      } else {
        resetCtxToDefault(this.ctx);
        this.endPath();
        const clip = new Path2D();
        clip.rect(rect[0], rect[1], width, height);
        this.ctx.clip(clip);
      }
    }
    this.current = new CanvasExtraState(this.ctx.canvas.width, this.ctx.canvas.height);
    this.transform(...transform);
    this.transform(...matrix);
  }
  endAnnotation() {
    if (this.annotationCanvas) {
      this.ctx.restore();
      canvas_assertClassBrand(_CanvasGraphics_brand, this, _drawFilter).call(this);
      this.ctx = this.annotationCanvas.savedCtx;
      delete this.annotationCanvas.savedCtx;
      delete this.annotationCanvas;
    }
  }
  paintImageMaskXObject(img) {
    if (!this.contentVisible) {
      return;
    }
    const count = img.count;
    img = this.getObject(img.data, img);
    img.count = count;
    const ctx = this.ctx;
    const mask = this._createMaskCanvas(img);
    const maskCanvas = mask.canvas;
    ctx.save();
    ctx.setTransform(1, 0, 0, 1, 0, 0);
    ctx.drawImage(maskCanvas, mask.offsetX, mask.offsetY);
    ctx.restore();
    this.compose();
  }
  paintImageMaskXObjectRepeat(img, scaleX) {
    let skewX = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;
    let skewY = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 0;
    let scaleY = arguments.length > 4 ? arguments[4] : undefined;
    let positions = arguments.length > 5 ? arguments[5] : undefined;
    if (!this.contentVisible) {
      return;
    }
    img = this.getObject(img.data, img);
    const ctx = this.ctx;
    ctx.save();
    const currentTransform = getCurrentTransform(ctx);
    ctx.transform(scaleX, skewX, skewY, scaleY, 0, 0);
    const mask = this._createMaskCanvas(img);
    ctx.setTransform(1, 0, 0, 1, mask.offsetX - currentTransform[4], mask.offsetY - currentTransform[5]);
    for (let i = 0, ii = positions.length; i < ii; i += 2) {
      const trans = Util.transform(currentTransform, [scaleX, skewX, skewY, scaleY, positions[i], positions[i + 1]]);
      ctx.drawImage(mask.canvas, trans[4], trans[5]);
    }
    ctx.restore();
    this.compose();
  }
  paintImageMaskXObjectGroup(images) {
    if (!this.contentVisible) {
      return;
    }
    const ctx = this.ctx;
    const fillColor = this.current.fillColor;
    const isPatternFill = this.current.patternFill;
    for (const image of images) {
      const {
        data,
        width,
        height,
        transform
      } = image;
      const maskCanvas = this.cachedCanvases.getCanvas("maskCanvas", width, height);
      const maskCtx = maskCanvas.context;
      maskCtx.save();
      const img = this.getObject(data, image);
      putBinaryImageMask(maskCtx, img);
      maskCtx.globalCompositeOperation = "source-in";
      maskCtx.fillStyle = isPatternFill ? fillColor.getPattern(maskCtx, this, getCurrentTransformInverse(ctx), PathType.FILL) : fillColor;
      maskCtx.fillRect(0, 0, width, height);
      maskCtx.restore();
      ctx.save();
      ctx.transform(...transform);
      ctx.scale(1, -1);
      drawImageAtIntegerCoords(ctx, maskCanvas.canvas, 0, 0, width, height, 0, -1, 1, 1);
      ctx.restore();
    }
    this.compose();
  }
  paintImageXObject(objId) {
    if (!this.contentVisible) {
      return;
    }
    const imgData = this.getObject(objId);
    if (!imgData) {
      warn("Dependent image isn't ready yet");
      return;
    }
    this.paintInlineImageXObject(imgData);
  }
  paintImageXObjectRepeat(objId, scaleX, scaleY, positions) {
    if (!this.contentVisible) {
      return;
    }
    const imgData = this.getObject(objId);
    if (!imgData) {
      warn("Dependent image isn't ready yet");
      return;
    }
    const width = imgData.width;
    const height = imgData.height;
    const map = [];
    for (let i = 0, ii = positions.length; i < ii; i += 2) {
      map.push({
        transform: [scaleX, 0, 0, scaleY, positions[i], positions[i + 1]],
        x: 0,
        y: 0,
        w: width,
        h: height
      });
    }
    this.paintInlineImageXObjectGroup(imgData, map);
  }
  applyTransferMapsToCanvas(ctx) {
    if (this.current.transferMaps !== "none") {
      ctx.filter = this.current.transferMaps;
      ctx.drawImage(ctx.canvas, 0, 0);
      ctx.filter = "none";
    }
    return ctx.canvas;
  }
  applyTransferMapsToBitmap(imgData) {
    if (this.current.transferMaps === "none") {
      return imgData.bitmap;
    }
    const {
      bitmap,
      width,
      height
    } = imgData;
    const tmpCanvas = this.cachedCanvases.getCanvas("inlineImage", width, height);
    const tmpCtx = tmpCanvas.context;
    tmpCtx.filter = this.current.transferMaps;
    tmpCtx.drawImage(bitmap, 0, 0);
    tmpCtx.filter = "none";
    return tmpCanvas.canvas;
  }
  paintInlineImageXObject(imgData) {
    if (!this.contentVisible) {
      return;
    }
    const width = imgData.width;
    const height = imgData.height;
    const ctx = this.ctx;
    this.save();
    const {
      filter
    } = ctx;
    if (filter !== "none" && filter !== "") {
      ctx.filter = "none";
    }
    ctx.scale(1 / width, -1 / height);
    let imgToPaint;
    if (imgData.bitmap) {
      imgToPaint = this.applyTransferMapsToBitmap(imgData);
    } else if (typeof HTMLElement === "function" && imgData instanceof HTMLElement || !imgData.data) {
      imgToPaint = imgData;
    } else {
      const tmpCanvas = this.cachedCanvases.getCanvas("inlineImage", width, height);
      const tmpCtx = tmpCanvas.context;
      putBinaryImageData(tmpCtx, imgData);
      imgToPaint = this.applyTransferMapsToCanvas(tmpCtx);
    }
    const scaled = this._scaleImage(imgToPaint, getCurrentTransformInverse(ctx));
    ctx.imageSmoothingEnabled = getImageSmoothingEnabled(getCurrentTransform(ctx), imgData.interpolate);
    drawImageAtIntegerCoords(ctx, scaled.img, 0, 0, scaled.paintWidth, scaled.paintHeight, 0, -height, width, height);
    this.compose();
    this.restore();
  }
  paintInlineImageXObjectGroup(imgData, map) {
    if (!this.contentVisible) {
      return;
    }
    const ctx = this.ctx;
    let imgToPaint;
    if (imgData.bitmap) {
      imgToPaint = imgData.bitmap;
    } else {
      const w = imgData.width;
      const h = imgData.height;
      const tmpCanvas = this.cachedCanvases.getCanvas("inlineImage", w, h);
      const tmpCtx = tmpCanvas.context;
      putBinaryImageData(tmpCtx, imgData);
      imgToPaint = this.applyTransferMapsToCanvas(tmpCtx);
    }
    for (const entry of map) {
      ctx.save();
      ctx.transform(...entry.transform);
      ctx.scale(1, -1);
      drawImageAtIntegerCoords(ctx, imgToPaint, entry.x, entry.y, entry.w, entry.h, 0, -1, 1, 1);
      ctx.restore();
    }
    this.compose();
  }
  paintSolidColorImageMask() {
    if (!this.contentVisible) {
      return;
    }
    this.ctx.fillRect(0, 0, 1, 1);
    this.compose();
  }
  markPoint(tag) {}
  markPointProps(tag, properties) {}
  beginMarkedContent(tag) {
    this.markedContentStack.push({
      visible: true
    });
  }
  beginMarkedContentProps(tag, properties) {
    if (tag === "OC") {
      this.markedContentStack.push({
        visible: this.optionalContentConfig.isVisible(properties)
      });
    } else {
      this.markedContentStack.push({
        visible: true
      });
    }
    this.contentVisible = this.isContentVisible();
  }
  endMarkedContent() {
    this.markedContentStack.pop();
    this.contentVisible = this.isContentVisible();
  }
  beginCompat() {}
  endCompat() {}
  consumePath(path, clipBox) {
    const isEmpty = this.current.isEmptyClip();
    if (this.pendingClip) {
      this.current.updateClipFromPath();
    }
    if (!this.pendingClip) {
      this.compose(clipBox);
    }
    const ctx = this.ctx;
    if (this.pendingClip) {
      if (!isEmpty) {
        if (this.pendingClip === EO_CLIP) {
          ctx.clip(path, "evenodd");
        } else {
          ctx.clip(path);
        }
      }
      this.pendingClip = null;
    }
    this.current.startNewPathAndClipBox(this.current.clipBox);
  }
  getSinglePixelWidth() {
    if (!this._cachedGetSinglePixelWidth) {
      const m = getCurrentTransform(this.ctx);
      if (m[1] === 0 && m[2] === 0) {
        this._cachedGetSinglePixelWidth = 1 / Math.min(Math.abs(m[0]), Math.abs(m[3]));
      } else {
        const absDet = Math.abs(m[0] * m[3] - m[2] * m[1]);
        const normX = Math.hypot(m[0], m[2]);
        const normY = Math.hypot(m[1], m[3]);
        this._cachedGetSinglePixelWidth = Math.max(normX, normY) / absDet;
      }
    }
    return this._cachedGetSinglePixelWidth;
  }
  getScaleForStroking() {
    if (this._cachedScaleForStroking[0] === -1) {
      const {
        lineWidth
      } = this.current;
      const {
        a,
        b,
        c,
        d
      } = this.ctx.getTransform();
      let scaleX, scaleY;
      if (b === 0 && c === 0) {
        const normX = Math.abs(a);
        const normY = Math.abs(d);
        if (normX === normY) {
          if (lineWidth === 0) {
            scaleX = scaleY = 1 / normX;
          } else {
            const scaledLineWidth = normX * lineWidth;
            scaleX = scaleY = scaledLineWidth < 1 ? 1 / scaledLineWidth : 1;
          }
        } else if (lineWidth === 0) {
          scaleX = 1 / normX;
          scaleY = 1 / normY;
        } else {
          const scaledXLineWidth = normX * lineWidth;
          const scaledYLineWidth = normY * lineWidth;
          scaleX = scaledXLineWidth < 1 ? 1 / scaledXLineWidth : 1;
          scaleY = scaledYLineWidth < 1 ? 1 / scaledYLineWidth : 1;
        }
      } else {
        const absDet = Math.abs(a * d - b * c);
        const normX = Math.hypot(a, b);
        const normY = Math.hypot(c, d);
        if (lineWidth === 0) {
          scaleX = normY / absDet;
          scaleY = normX / absDet;
        } else {
          const baseArea = lineWidth * absDet;
          scaleX = normY > baseArea ? normY / baseArea : 1;
          scaleY = normX > baseArea ? normX / baseArea : 1;
        }
      }
      this._cachedScaleForStroking[0] = scaleX;
      this._cachedScaleForStroking[1] = scaleY;
    }
    return this._cachedScaleForStroking;
  }
  rescaleAndStroke(path, saveRestore) {
    const {
      ctx,
      current: {
        lineWidth
      }
    } = this;
    const [scaleX, scaleY] = this.getScaleForStroking();
    if (scaleX === scaleY) {
      ctx.lineWidth = (lineWidth || 1) * scaleX;
      ctx.stroke(path);
      return;
    }
    const dashes = ctx.getLineDash();
    if (saveRestore) {
      ctx.save();
    }
    ctx.scale(scaleX, scaleY);
    SCALE_MATRIX.a = 1 / scaleX;
    SCALE_MATRIX.d = 1 / scaleY;
    const newPath = new Path2D();
    newPath.addPath(path, SCALE_MATRIX);
    if (dashes.length > 0) {
      const scale = Math.max(scaleX, scaleY);
      ctx.setLineDash(dashes.map(x => x / scale));
      ctx.lineDashOffset /= scale;
    }
    ctx.lineWidth = lineWidth || 1;
    ctx.stroke(newPath);
    if (saveRestore) {
      ctx.restore();
    }
  }
  isContentVisible() {
    for (let i = this.markedContentStack.length - 1; i >= 0; i--) {
      if (!this.markedContentStack[i].visible) {
        return false;
      }
    }
    return true;
  }
}
function _restoreInitialState() {
  while (this.stateStack.length || this.inSMaskMode) {
    this.restore();
  }
  this.current.activeSMask = null;
  this.ctx.restore();
  if (this.transparentCanvas) {
    this.ctx = this.compositeCtx;
    this.ctx.save();
    this.ctx.setTransform(1, 0, 0, 1, 0, 0);
    this.ctx.drawImage(this.transparentCanvas, 0, 0);
    this.ctx.restore();
    this.transparentCanvas = null;
  }
}
function _drawFilter() {
  if (this.pageColors) {
    const hcmFilterId = this.filterFactory.addHCMFilter(this.pageColors.foreground, this.pageColors.background);
    if (hcmFilterId !== "none") {
      const savedFilter = this.ctx.filter;
      this.ctx.filter = hcmFilterId;
      this.ctx.drawImage(this.ctx.canvas, 0, 0);
      this.ctx.filter = savedFilter;
    }
  }
}
function _getScaledPath(path, currentTransform, transform) {
  const newPath = new Path2D();
  newPath.addPath(path, new DOMMatrix(transform).invertSelf().multiplySelf(currentTransform));
  return newPath;
}
for (const op in OPS) {
  if (CanvasGraphics.prototype[op] !== undefined) {
    CanvasGraphics.prototype[OPS[op]] = CanvasGraphics.prototype[op];
  }
}

;// ./src/display/worker_options.js

function worker_options_assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); }
class GlobalWorkerOptions {
  static get workerPort() {
    return worker_options_assertClassBrand(GlobalWorkerOptions, this, _port)._;
  }
  static set workerPort(val) {
    if (!(typeof Worker !== "undefined" && val instanceof Worker) && val !== null) {
      throw new Error("Invalid `workerPort` type.");
    }
    _port._ = worker_options_assertClassBrand(GlobalWorkerOptions, this, val);
  }
  static get workerSrc() {
    return worker_options_assertClassBrand(GlobalWorkerOptions, this, _src)._;
  }
  static set workerSrc(val) {
    if (typeof val !== "string") {
      throw new Error("Invalid `workerSrc` type.");
    }
    _src._ = worker_options_assertClassBrand(GlobalWorkerOptions, this, val);
  }
}
var _port = {
  _: null
};
var _src = {
  _: ""
};

;// ./src/display/metadata.js

function metadata_classPrivateFieldInitSpec(e, t, a) { metadata_checkPrivateRedeclaration(e, t), t.set(e, a); }
function metadata_checkPrivateRedeclaration(e, t) { if (t.has(e)) throw new TypeError("Cannot initialize the same private elements twice on an object"); }
function metadata_classPrivateFieldGet(s, a) { return s.get(metadata_assertClassBrand(s, a)); }
function metadata_classPrivateFieldSet(s, a, r) { return s.set(metadata_assertClassBrand(s, a), r), r; }
function metadata_assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); }
var _map = /*#__PURE__*/new WeakMap();
var _data = /*#__PURE__*/new WeakMap();
class Metadata {
  constructor(_ref) {
    let {
      parsedData,
      rawData
    } = _ref;
    metadata_classPrivateFieldInitSpec(this, _map, void 0);
    metadata_classPrivateFieldInitSpec(this, _data, void 0);
    metadata_classPrivateFieldSet(_map, this, parsedData);
    metadata_classPrivateFieldSet(_data, this, rawData);
  }
  getRaw() {
    return metadata_classPrivateFieldGet(_data, this);
  }
  get(name) {
    return metadata_classPrivateFieldGet(_map, this).get(name) ?? null;
  }
  [Symbol.iterator]() {
    return metadata_classPrivateFieldGet(_map, this).entries();
  }
}

;// ./src/display/optional_content_config.js

function optional_content_config_classPrivateMethodInitSpec(e, a) { optional_content_config_checkPrivateRedeclaration(e, a), a.add(e); }
function optional_content_config_classPrivateFieldInitSpec(e, t, a) { optional_content_config_checkPrivateRedeclaration(e, t), t.set(e, a); }
function optional_content_config_checkPrivateRedeclaration(e, t) { if (t.has(e)) throw new TypeError("Cannot initialize the same private elements twice on an object"); }
function optional_content_config_classPrivateFieldGet(s, a) { return s.get(optional_content_config_assertClassBrand(s, a)); }
function optional_content_config_classPrivateFieldSet(s, a, r) { return s.set(optional_content_config_assertClassBrand(s, a), r), r; }
function optional_content_config_assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); }


const INTERNAL = Symbol("INTERNAL");
var _isDisplay = /*#__PURE__*/new WeakMap();
var _isPrint = /*#__PURE__*/new WeakMap();
var _userSet = /*#__PURE__*/new WeakMap();
var _visible = /*#__PURE__*/new WeakMap();
class OptionalContentGroup {
  constructor(renderingIntent, _ref) {
    let {
      name,
      intent,
      usage,
      rbGroups
    } = _ref;
    optional_content_config_classPrivateFieldInitSpec(this, _isDisplay, false);
    optional_content_config_classPrivateFieldInitSpec(this, _isPrint, false);
    optional_content_config_classPrivateFieldInitSpec(this, _userSet, false);
    optional_content_config_classPrivateFieldInitSpec(this, _visible, true);
    optional_content_config_classPrivateFieldSet(_isDisplay, this, !!(renderingIntent & RenderingIntentFlag.DISPLAY));
    optional_content_config_classPrivateFieldSet(_isPrint, this, !!(renderingIntent & RenderingIntentFlag.PRINT));
    this.name = name;
    this.intent = intent;
    this.usage = usage;
    this.rbGroups = rbGroups;
  }
  get visible() {
    if (optional_content_config_classPrivateFieldGet(_userSet, this)) {
      return optional_content_config_classPrivateFieldGet(_visible, this);
    }
    if (!optional_content_config_classPrivateFieldGet(_visible, this)) {
      return false;
    }
    const {
      print,
      view
    } = this.usage;
    if (optional_content_config_classPrivateFieldGet(_isDisplay, this)) {
      return view?.viewState !== "OFF";
    } else if (optional_content_config_classPrivateFieldGet(_isPrint, this)) {
      return print?.printState !== "OFF";
    }
    return true;
  }
  _setVisible(internal, visible) {
    let userSet = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
    if (internal !== INTERNAL) {
      unreachable("Internal method `_setVisible` called.");
    }
    optional_content_config_classPrivateFieldSet(_userSet, this, userSet);
    optional_content_config_classPrivateFieldSet(_visible, this, visible);
  }
}
var _cachedGetHash = /*#__PURE__*/new WeakMap();
var _groups = /*#__PURE__*/new WeakMap();
var _initialHash = /*#__PURE__*/new WeakMap();
var _order = /*#__PURE__*/new WeakMap();
var _OptionalContentConfig_brand = /*#__PURE__*/new WeakSet();
class OptionalContentConfig {
  constructor(data) {
    let renderingIntent = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : RenderingIntentFlag.DISPLAY;
    optional_content_config_classPrivateMethodInitSpec(this, _OptionalContentConfig_brand);
    optional_content_config_classPrivateFieldInitSpec(this, _cachedGetHash, null);
    optional_content_config_classPrivateFieldInitSpec(this, _groups, new Map());
    optional_content_config_classPrivateFieldInitSpec(this, _initialHash, null);
    optional_content_config_classPrivateFieldInitSpec(this, _order, null);
    this.renderingIntent = renderingIntent;
    this.name = null;
    this.creator = null;
    if (data === null) {
      return;
    }
    this.name = data.name;
    this.creator = data.creator;
    optional_content_config_classPrivateFieldSet(_order, this, data.order);
    for (const group of data.groups) {
      optional_content_config_classPrivateFieldGet(_groups, this).set(group.id, new OptionalContentGroup(renderingIntent, group));
    }
    if (data.baseState === "OFF") {
      for (const group of optional_content_config_classPrivateFieldGet(_groups, this).values()) {
        group._setVisible(INTERNAL, false);
      }
    }
    for (const on of data.on) {
      optional_content_config_classPrivateFieldGet(_groups, this).get(on)._setVisible(INTERNAL, true);
    }
    for (const off of data.off) {
      optional_content_config_classPrivateFieldGet(_groups, this).get(off)._setVisible(INTERNAL, false);
    }
    optional_content_config_classPrivateFieldSet(_initialHash, this, this.getHash());
  }
  isVisible(group) {
    if (optional_content_config_classPrivateFieldGet(_groups, this).size === 0) {
      return true;
    }
    if (!group) {
      info("Optional content group not defined.");
      return true;
    }
    if (group.type === "OCG") {
      if (!optional_content_config_classPrivateFieldGet(_groups, this).has(group.id)) {
        warn(`Optional content group not found: ${group.id}`);
        return true;
      }
      return optional_content_config_classPrivateFieldGet(_groups, this).get(group.id).visible;
    } else if (group.type === "OCMD") {
      if (group.expression) {
        return optional_content_config_assertClassBrand(_OptionalContentConfig_brand, this, _evaluateVisibilityExpression).call(this, group.expression);
      }
      if (!group.policy || group.policy === "AnyOn") {
        for (const id of group.ids) {
          if (!optional_content_config_classPrivateFieldGet(_groups, this).has(id)) {
            warn(`Optional content group not found: ${id}`);
            return true;
          }
          if (optional_content_config_classPrivateFieldGet(_groups, this).get(id).visible) {
            return true;
          }
        }
        return false;
      } else if (group.policy === "AllOn") {
        for (const id of group.ids) {
          if (!optional_content_config_classPrivateFieldGet(_groups, this).has(id)) {
            warn(`Optional content group not found: ${id}`);
            return true;
          }
          if (!optional_content_config_classPrivateFieldGet(_groups, this).get(id).visible) {
            return false;
          }
        }
        return true;
      } else if (group.policy === "AnyOff") {
        for (const id of group.ids) {
          if (!optional_content_config_classPrivateFieldGet(_groups, this).has(id)) {
            warn(`Optional content group not found: ${id}`);
            return true;
          }
          if (!optional_content_config_classPrivateFieldGet(_groups, this).get(id).visible) {
            return true;
          }
        }
        return false;
      } else if (group.policy === "AllOff") {
        for (const id of group.ids) {
          if (!optional_content_config_classPrivateFieldGet(_groups, this).has(id)) {
            warn(`Optional content group not found: ${id}`);
            return true;
          }
          if (optional_content_config_classPrivateFieldGet(_groups, this).get(id).visible) {
            return false;
          }
        }
        return true;
      }
      warn(`Unknown optional content policy ${group.policy}.`);
      return true;
    }
    warn(`Unknown group type ${group.type}.`);
    return true;
  }
  setVisibility(id) {
    let visible = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;
    let preserveRB = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;
    const group = optional_content_config_classPrivateFieldGet(_groups, this).get(id);
    if (!group) {
      warn(`Optional content group not found: ${id}`);
      return;
    }
    if (preserveRB && visible && group.rbGroups.length) {
      for (const rbGroup of group.rbGroups) {
        for (const otherId of rbGroup) {
          if (otherId !== id) {
            optional_content_config_classPrivateFieldGet(_groups, this).get(otherId)?._setVisible(INTERNAL, false, true);
          }
        }
      }
    }
    group._setVisible(INTERNAL, !!visible, true);
    optional_content_config_classPrivateFieldSet(_cachedGetHash, this, null);
  }
  setOCGState(_ref2) {
    let {
      state,
      preserveRB
    } = _ref2;
    let operator;
    for (const elem of state) {
      switch (elem) {
        case "ON":
        case "OFF":
        case "Toggle":
          operator = elem;
          continue;
      }
      const group = optional_content_config_classPrivateFieldGet(_groups, this).get(elem);
      if (!group) {
        continue;
      }
      switch (operator) {
        case "ON":
          this.setVisibility(elem, true, preserveRB);
          break;
        case "OFF":
          this.setVisibility(elem, false, preserveRB);
          break;
        case "Toggle":
          this.setVisibility(elem, !group.visible, preserveRB);
          break;
      }
    }
    optional_content_config_classPrivateFieldSet(_cachedGetHash, this, null);
  }
  get hasInitialVisibility() {
    return optional_content_config_classPrivateFieldGet(_initialHash, this) === null || this.getHash() === optional_content_config_classPrivateFieldGet(_initialHash, this);
  }
  getOrder() {
    if (!optional_content_config_classPrivateFieldGet(_groups, this).size) {
      return null;
    }
    if (optional_content_config_classPrivateFieldGet(_order, this)) {
      return optional_content_config_classPrivateFieldGet(_order, this).slice();
    }
    return [...optional_content_config_classPrivateFieldGet(_groups, this).keys()];
  }
  getGroup(id) {
    return optional_content_config_classPrivateFieldGet(_groups, this).get(id) || null;
  }
  getHash() {
    if (optional_content_config_classPrivateFieldGet(_cachedGetHash, this) !== null) {
      return optional_content_config_classPrivateFieldGet(_cachedGetHash, this);
    }
    const hash = new MurmurHash3_64();
    for (const [id, group] of optional_content_config_classPrivateFieldGet(_groups, this)) {
      hash.update(`${id}:${group.visible}`);
    }
    return optional_content_config_classPrivateFieldSet(_cachedGetHash, this, hash.hexdigest());
  }
  [Symbol.iterator]() {
    return optional_content_config_classPrivateFieldGet(_groups, this).entries();
  }
}
function _evaluateVisibilityExpression(array) {
  const length = array.length;
  if (length < 2) {
    return true;
  }
  const operator = array[0];
  for (let i = 1; i < length; i++) {
    const element = array[i];
    let state;
    if (Array.isArray(element)) {
      state = optional_content_config_assertClassBrand(_OptionalContentConfig_brand, this, _evaluateVisibilityExpression).call(this, element);
    } else if (optional_content_config_classPrivateFieldGet(_groups, this).has(element)) {
      state = optional_content_config_classPrivateFieldGet(_groups, this).get(element).visible;
    } else {
      warn(`Optional content group not found: ${element}`);
      return true;
    }
    switch (operator) {
      case "And":
        if (!state) {
          return false;
        }
        break;
      case "Or":
        if (state) {
          return true;
        }
        break;
      case "Not":
        return !state;
      default:
        return true;
    }
  }
  return operator === "And";
}

;// ./src/display/transport_stream.js






















class PDFDataTransportStream {
  constructor(pdfDataRangeTransport, _ref) {
    let {
      disableRange = false,
      disableStream = false
    } = _ref;
    assert(pdfDataRangeTransport, 'PDFDataTransportStream - missing required "pdfDataRangeTransport" argument.');
    const {
      length,
      initialData,
      progressiveDone,
      contentDispositionFilename
    } = pdfDataRangeTransport;
    this._queuedChunks = [];
    this._progressiveDone = progressiveDone;
    this._contentDispositionFilename = contentDispositionFilename;
    if (initialData?.length > 0) {
      const buffer = initialData instanceof Uint8Array && initialData.byteLength === initialData.buffer.byteLength ? initialData.buffer : new Uint8Array(initialData).buffer;
      this._queuedChunks.push(buffer);
    }
    this._pdfDataRangeTransport = pdfDataRangeTransport;
    this._isStreamingSupported = !disableStream;
    this._isRangeSupported = !disableRange;
    this._contentLength = length;
    this._fullRequestReader = null;
    this._rangeReaders = [];
    pdfDataRangeTransport.addRangeListener((begin, chunk) => {
      this._onReceiveData({
        begin,
        chunk
      });
    });
    pdfDataRangeTransport.addProgressListener((loaded, total) => {
      this._onProgress({
        loaded,
        total
      });
    });
    pdfDataRangeTransport.addProgressiveReadListener(chunk => {
      this._onReceiveData({
        chunk
      });
    });
    pdfDataRangeTransport.addProgressiveDoneListener(() => {
      this._onProgressiveDone();
    });
    pdfDataRangeTransport.transportReady();
  }
  _onReceiveData(_ref2) {
    let {
      begin,
      chunk
    } = _ref2;
    const buffer = chunk instanceof Uint8Array && chunk.byteLength === chunk.buffer.byteLength ? chunk.buffer : new Uint8Array(chunk).buffer;
    if (begin === undefined) {
      if (this._fullRequestReader) {
        this._fullRequestReader._enqueue(buffer);
      } else {
        this._queuedChunks.push(buffer);
      }
    } else {
      const found = this._rangeReaders.some(function (rangeReader) {
        if (rangeReader._begin !== begin) {
          return false;
        }
        rangeReader._enqueue(buffer);
        return true;
      });
      assert(found, "_onReceiveData - no `PDFDataTransportStreamRangeReader` instance found.");
    }
  }
  get _progressiveDataLength() {
    return this._fullRequestReader?._loaded ?? 0;
  }
  _onProgress(evt) {
    if (evt.total === undefined) {
      this._rangeReaders[0]?.onProgress?.({
        loaded: evt.loaded
      });
    } else {
      this._fullRequestReader?.onProgress?.({
        loaded: evt.loaded,
        total: evt.total
      });
    }
  }
  _onProgressiveDone() {
    this._fullRequestReader?.progressiveDone();
    this._progressiveDone = true;
  }
  _removeRangeReader(reader) {
    const i = this._rangeReaders.indexOf(reader);
    if (i >= 0) {
      this._rangeReaders.splice(i, 1);
    }
  }
  getFullReader() {
    assert(!this._fullRequestReader, "PDFDataTransportStream.getFullReader can only be called once.");
    const queuedChunks = this._queuedChunks;
    this._queuedChunks = null;
    return new PDFDataTransportStreamReader(this, queuedChunks, this._progressiveDone, this._contentDispositionFilename);
  }
  getRangeReader(begin, end) {
    if (end <= this._progressiveDataLength) {
      return null;
    }
    const reader = new PDFDataTransportStreamRangeReader(this, begin, end);
    this._pdfDataRangeTransport.requestDataRange(begin, end);
    this._rangeReaders.push(reader);
    return reader;
  }
  cancelAllRequests(reason) {
    this._fullRequestReader?.cancel(reason);
    for (const reader of this._rangeReaders.slice(0)) {
      reader.cancel(reason);
    }
    this._pdfDataRangeTransport.abort();
  }
}
class PDFDataTransportStreamReader {
  constructor(stream, queuedChunks) {
    let progressiveDone = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
    let contentDispositionFilename = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : null;
    this._stream = stream;
    this._done = progressiveDone || false;
    this._filename = isPdfFile(contentDispositionFilename) ? contentDispositionFilename : null;
    this._queuedChunks = queuedChunks || [];
    this._loaded = 0;
    for (const chunk of this._queuedChunks) {
      this._loaded += chunk.byteLength;
    }
    this._requests = [];
    this._headersReady = Promise.resolve();
    stream._fullRequestReader = this;
    this.onProgress = null;
  }
  _enqueue(chunk) {
    if (this._done) {
      return;
    }
    if (this._requests.length > 0) {
      const requestCapability = this._requests.shift();
      requestCapability.resolve({
        value: chunk,
        done: false
      });
    } else {
      this._queuedChunks.push(chunk);
    }
    this._loaded += chunk.byteLength;
  }
  get headersReady() {
    return this._headersReady;
  }
  get filename() {
    return this._filename;
  }
  get isRangeSupported() {
    return this._stream._isRangeSupported;
  }
  get isStreamingSupported() {
    return this._stream._isStreamingSupported;
  }
  get contentLength() {
    return this._stream._contentLength;
  }
  async read() {
    if (this._queuedChunks.length > 0) {
      const chunk = this._queuedChunks.shift();
      return {
        value: chunk,
        done: false
      };
    }
    if (this._done) {
      return {
        value: undefined,
        done: true
      };
    }
    const requestCapability = Promise.withResolvers();
    this._requests.push(requestCapability);
    return requestCapability.promise;
  }
  cancel(reason) {
    this._done = true;
    for (const requestCapability of this._requests) {
      requestCapability.resolve({
        value: undefined,
        done: true
      });
    }
    this._requests.length = 0;
  }
  progressiveDone() {
    if (this._done) {
      return;
    }
    this._done = true;
  }
}
class PDFDataTransportStreamRangeReader {
  constructor(stream, begin, end) {
    this._stream = stream;
    this._begin = begin;
    this._end = end;
    this._queuedChunk = null;
    this._requests = [];
    this._done = false;
    this.onProgress = null;
  }
  _enqueue(chunk) {
    if (this._done) {
      return;
    }
    if (this._requests.length === 0) {
      this._queuedChunk = chunk;
    } else {
      const requestsCapability = this._requests.shift();
      requestsCapability.resolve({
        value: chunk,
        done: false
      });
      for (const requestCapability of this._requests) {
        requestCapability.resolve({
          value: undefined,
          done: true
        });
      }
      this._requests.length = 0;
    }
    this._done = true;
    this._stream._removeRangeReader(this);
  }
  get isStreamingSupported() {
    return false;
  }
  async read() {
    if (this._queuedChunk) {
      const chunk = this._queuedChunk;
      this._queuedChunk = null;
      return {
        value: chunk,
        done: false
      };
    }
    if (this._done) {
      return {
        value: undefined,
        done: true
      };
    }
    const requestCapability = Promise.withResolvers();
    this._requests.push(requestCapability);
    return requestCapability.promise;
  }
  cancel(reason) {
    this._done = true;
    for (const requestCapability of this._requests) {
      requestCapability.resolve({
        value: undefined,
        done: true
      });
    }
    this._requests.length = 0;
    this._stream._removeRangeReader(this);
  }
}

;// ./src/display/content_disposition.js



function getFilenameFromContentDispositionHeader(contentDisposition) {
  let needsEncodingFixup = true;
  let tmp = toParamRegExp("filename\\*", "i").exec(contentDisposition);
  if (tmp) {
    tmp = tmp[1];
    let filename = rfc2616unquote(tmp);
    filename = unescape(filename);
    filename = rfc5987decode(filename);
    filename = rfc2047decode(filename);
    return fixupEncoding(filename);
  }
  tmp = rfc2231getparam(contentDisposition);
  if (tmp) {
    const filename = rfc2047decode(tmp);
    return fixupEncoding(filename);
  }
  tmp = toParamRegExp("filename", "i").exec(contentDisposition);
  if (tmp) {
    tmp = tmp[1];
    let filename = rfc2616unquote(tmp);
    filename = rfc2047decode(filename);
    return fixupEncoding(filename);
  }
  function toParamRegExp(attributePattern, flags) {
    return new RegExp("(?:^|;)\\s*" + attributePattern + "\\s*=\\s*" + "(" + '[^";\\s][^;\\s]*' + "|" + '"(?:[^"\\\\]|\\\\"?)+"?' + ")", flags);
  }
  function textdecode(encoding, value) {
    if (encoding) {
      if (!/^[\x00-\xFF]+$/.test(value)) {
        return value;
      }
      try {
        const decoder = new TextDecoder(encoding, {
          fatal: true
        });
        const buffer = stringToBytes(value);
        value = decoder.decode(buffer);
        needsEncodingFixup = false;
      } catch {}
    }
    return value;
  }
  function fixupEncoding(value) {
    if (needsEncodingFixup && /[\x80-\xff]/.test(value)) {
      value = textdecode("utf-8", value);
      if (needsEncodingFixup) {
        value = textdecode("iso-8859-1", value);
      }
    }
    return value;
  }
  function rfc2231getparam(contentDispositionStr) {
    const matches = [];
    let match;
    const iter = toParamRegExp("filename\\*((?!0\\d)\\d+)(\\*?)", "ig");
    while ((match = iter.exec(contentDispositionStr)) !== null) {
      let [, n, quot, part] = match;
      n = parseInt(n, 10);
      if (n in matches) {
        if (n === 0) {
          break;
        }
        continue;
      }
      matches[n] = [quot, part];
    }
    const parts = [];
    for (let n = 0; n < matches.length; ++n) {
      if (!(n in matches)) {
        break;
      }
      let [quot, part] = matches[n];
      part = rfc2616unquote(part);
      if (quot) {
        part = unescape(part);
        if (n === 0) {
          part = rfc5987decode(part);
        }
      }
      parts.push(part);
    }
    return parts.join("");
  }
  function rfc2616unquote(value) {
    if (value.startsWith('"')) {
      const parts = value.slice(1).split('\\"');
      for (let i = 0; i < parts.length; ++i) {
        const quotindex = parts[i].indexOf('"');
        if (quotindex !== -1) {
          parts[i] = parts[i].slice(0, quotindex);
          parts.length = i + 1;
        }
        parts[i] = parts[i].replaceAll(/\\(.)/g, "$1");
      }
      value = parts.join('"');
    }
    return value;
  }
  function rfc5987decode(extvalue) {
    const encodingend = extvalue.indexOf("'");
    if (encodingend === -1) {
      return extvalue;
    }
    const encoding = extvalue.slice(0, encodingend);
    const langvalue = extvalue.slice(encodingend + 1);
    const value = langvalue.replace(/^[^']*'/, "");
    return textdecode(encoding, value);
  }
  function rfc2047decode(value) {
    if (!value.startsWith("=?") || /[\x00-\x19\x80-\xff]/.test(value)) {
      return value;
    }
    return value.replaceAll(/=\?([\w-]*)\?([QqBb])\?((?:[^?]|\?(?!=))*)\?=/g, function (matches, charset, encoding, text) {
      if (encoding === "q" || encoding === "Q") {
        text = text.replaceAll("_", " ");
        text = text.replaceAll(/=([0-9a-fA-F]{2})/g, function (match, hex) {
          return String.fromCharCode(parseInt(hex, 16));
        });
        return textdecode(charset, text);
      }
      try {
        text = atob(text);
      } catch {}
      return textdecode(charset, text);
    });
  }
  return "";
}

;// ./src/display/network_utils.js




function createHeaders(isHttp, httpHeaders) {
  const headers = new Headers();
  if (!isHttp || !httpHeaders || typeof httpHeaders !== "object") {
    return headers;
  }
  for (const key in httpHeaders) {
    const val = httpHeaders[key];
    if (val !== undefined) {
      headers.append(key, val);
    }
  }
  return headers;
}
function getResponseOrigin(url) {
  return URL.parse(url)?.origin ?? null;
}
function validateRangeRequestCapabilities(_ref) {
  let {
    responseHeaders,
    isHttp,
    rangeChunkSize,
    disableRange
  } = _ref;
  const returnValues = {
    allowRangeRequests: false,
    suggestedLength: undefined
  };
  const length = parseInt(responseHeaders.get("Content-Length"), 10);
  if (!Number.isInteger(length)) {
    return returnValues;
  }
  returnValues.suggestedLength = length;
  if (length <= 2 * rangeChunkSize) {
    return returnValues;
  }
  if (disableRange || !isHttp) {
    return returnValues;
  }
  if (responseHeaders.get("Accept-Ranges") !== "bytes") {
    return returnValues;
  }
  const contentEncoding = responseHeaders.get("Content-Encoding") || "identity";
  if (contentEncoding !== "identity") {
    return returnValues;
  }
  returnValues.allowRangeRequests = true;
  return returnValues;
}
function extractFilenameFromHeader(responseHeaders) {
  const contentDisposition = responseHeaders.get("Content-Disposition");
  if (contentDisposition) {
    let filename = getFilenameFromContentDispositionHeader(contentDisposition);
    if (filename.includes("%")) {
      try {
        filename = decodeURIComponent(filename);
      } catch {}
    }
    if (isPdfFile(filename)) {
      return filename;
    }
  }
  return null;
}
function createResponseError(status, url) {
  return new ResponseException(`Unexpected server response (${status}) while retrieving PDF "${url}".`, status, status === 404 || status === 0 && url.startsWith("file:"));
}
function validateResponseStatus(status) {
  return status === 200 || status === 206;
}

;// ./src/display/fetch_stream.js
function fetch_stream_defineProperty(e, r, t) { return (r = fetch_stream_toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function fetch_stream_toPropertyKey(t) { var i = fetch_stream_toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function fetch_stream_toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }





















function createFetchOptions(headers, withCredentials, abortController) {
  return {
    method: "GET",
    headers,
    signal: abortController.signal,
    mode: "cors",
    credentials: withCredentials ? "include" : "same-origin",
    redirect: "follow"
  };
}
function getArrayBuffer(val) {
  if (val instanceof Uint8Array) {
    return val.buffer;
  }
  if (val instanceof ArrayBuffer) {
    return val;
  }
  warn(`getArrayBuffer - unexpected data format: ${val}`);
  return new Uint8Array(val).buffer;
}
class PDFFetchStream {
  constructor(source) {
    fetch_stream_defineProperty(this, "_responseOrigin", null);
    this.source = source;
    this.isHttp = /^https?:/i.test(source.url);
    this.headers = createHeaders(this.isHttp, source.httpHeaders);
    this._fullRequestReader = null;
    this._rangeRequestReaders = [];
  }
  get _progressiveDataLength() {
    return this._fullRequestReader?._loaded ?? 0;
  }
  getFullReader() {
    assert(!this._fullRequestReader, "PDFFetchStream.getFullReader can only be called once.");
    this._fullRequestReader = new PDFFetchStreamReader(this);
    return this._fullRequestReader;
  }
  getRangeReader(begin, end) {
    if (end <= this._progressiveDataLength) {
      return null;
    }
    const reader = new PDFFetchStreamRangeReader(this, begin, end);
    this._rangeRequestReaders.push(reader);
    return reader;
  }
  cancelAllRequests(reason) {
    this._fullRequestReader?.cancel(reason);
    for (const reader of this._rangeRequestReaders.slice(0)) {
      reader.cancel(reason);
    }
  }
}
class PDFFetchStreamReader {
  constructor(stream) {
    this._stream = stream;
    this._reader = null;
    this._loaded = 0;
    this._filename = null;
    const source = stream.source;
    this._withCredentials = source.withCredentials || false;
    this._contentLength = source.length;
    this._headersCapability = Promise.withResolvers();
    this._disableRange = source.disableRange || false;
    this._rangeChunkSize = source.rangeChunkSize;
    if (!this._rangeChunkSize && !this._disableRange) {
      this._disableRange = true;
    }
    this._abortController = new AbortController();
    this._isStreamingSupported = !source.disableStream;
    this._isRangeSupported = !source.disableRange;
    const headers = new Headers(stream.headers);
    const url = source.url;
    fetch(url, createFetchOptions(headers, this._withCredentials, this._abortController)).then(response => {
      stream._responseOrigin = getResponseOrigin(response.url);
      if (!validateResponseStatus(response.status)) {
        throw createResponseError(response.status, url);
      }
      this._reader = response.body.getReader();
      this._headersCapability.resolve();
      const responseHeaders = response.headers;
      const {
        allowRangeRequests,
        suggestedLength
      } = validateRangeRequestCapabilities({
        responseHeaders,
        isHttp: stream.isHttp,
        rangeChunkSize: this._rangeChunkSize,
        disableRange: this._disableRange
      });
      this._isRangeSupported = allowRangeRequests;
      this._contentLength = suggestedLength || this._contentLength;
      this._filename = extractFilenameFromHeader(responseHeaders);
      if (!this._isStreamingSupported && this._isRangeSupported) {
        this.cancel(new AbortException("Streaming is disabled."));
      }
    }).catch(this._headersCapability.reject);
    this.onProgress = null;
  }
  get headersReady() {
    return this._headersCapability.promise;
  }
  get filename() {
    return this._filename;
  }
  get contentLength() {
    return this._contentLength;
  }
  get isRangeSupported() {
    return this._isRangeSupported;
  }
  get isStreamingSupported() {
    return this._isStreamingSupported;
  }
  async read() {
    await this._headersCapability.promise;
    const {
      value,
      done
    } = await this._reader.read();
    if (done) {
      return {
        value,
        done
      };
    }
    this._loaded += value.byteLength;
    this.onProgress?.({
      loaded: this._loaded,
      total: this._contentLength
    });
    return {
      value: getArrayBuffer(value),
      done: false
    };
  }
  cancel(reason) {
    this._reader?.cancel(reason);
    this._abortController.abort();
  }
}
class PDFFetchStreamRangeReader {
  constructor(stream, begin, end) {
    this._stream = stream;
    this._reader = null;
    this._loaded = 0;
    const source = stream.source;
    this._withCredentials = source.withCredentials || false;
    this._readCapability = Promise.withResolvers();
    this._isStreamingSupported = !source.disableStream;
    this._abortController = new AbortController();
    const headers = new Headers(stream.headers);
    headers.append("Range", `bytes=${begin}-${end - 1}`);
    const url = source.url;
    fetch(url, createFetchOptions(headers, this._withCredentials, this._abortController)).then(response => {
      const responseOrigin = getResponseOrigin(response.url);
      if (responseOrigin !== stream._responseOrigin) {
        throw new Error(`Expected range response-origin "${responseOrigin}" to match "${stream._responseOrigin}".`);
      }
      if (!validateResponseStatus(response.status)) {
        throw createResponseError(response.status, url);
      }
      this._readCapability.resolve();
      this._reader = response.body.getReader();
    }).catch(this._readCapability.reject);
    this.onProgress = null;
  }
  get isStreamingSupported() {
    return this._isStreamingSupported;
  }
  async read() {
    await this._readCapability.promise;
    const {
      value,
      done
    } = await this._reader.read();
    if (done) {
      return {
        value,
        done
      };
    }
    this._loaded += value.byteLength;
    this.onProgress?.({
      loaded: this._loaded
    });
    return {
      value: getArrayBuffer(value),
      done: false
    };
  }
  cancel(reason) {
    this._reader?.cancel(reason);
    this._abortController.abort();
  }
}

;// ./src/display/network.js
function network_defineProperty(e, r, t) { return (r = network_toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function network_toPropertyKey(t) { var i = network_toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function network_toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }







const OK_RESPONSE = 200;
const PARTIAL_CONTENT_RESPONSE = 206;
function network_getArrayBuffer(xhr) {
  const data = xhr.response;
  if (typeof data !== "string") {
    return data;
  }
  return stringToBytes(data).buffer;
}
class NetworkManager {
  constructor(_ref) {
    let {
      url,
      httpHeaders,
      withCredentials
    } = _ref;
    network_defineProperty(this, "_responseOrigin", null);
    this.url = url;
    this.isHttp = /^https?:/i.test(url);
    this.headers = createHeaders(this.isHttp, httpHeaders);
    this.withCredentials = withCredentials || false;
    this.currXhrId = 0;
    this.pendingRequests = Object.create(null);
  }
  request(args) {
    const xhr = new XMLHttpRequest();
    const xhrId = this.currXhrId++;
    const pendingRequest = this.pendingRequests[xhrId] = {
      xhr
    };
    xhr.open("GET", this.url);
    xhr.withCredentials = this.withCredentials;
    for (const [key, val] of this.headers) {
      xhr.setRequestHeader(key, val);
    }
    if (this.isHttp && "begin" in args && "end" in args) {
      xhr.setRequestHeader("Range", `bytes=${args.begin}-${args.end - 1}`);
      pendingRequest.expectedStatus = PARTIAL_CONTENT_RESPONSE;
    } else {
      pendingRequest.expectedStatus = OK_RESPONSE;
    }
    xhr.responseType = "arraybuffer";
    assert(args.onError, "Expected `onError` callback to be provided.");
    xhr.onerror = () => {
      args.onError(xhr.status);
    };
    xhr.onreadystatechange = this.onStateChange.bind(this, xhrId);
    xhr.onprogress = this.onProgress.bind(this, xhrId);
    pendingRequest.onHeadersReceived = args.onHeadersReceived;
    pendingRequest.onDone = args.onDone;
    pendingRequest.onError = args.onError;
    pendingRequest.onProgress = args.onProgress;
    xhr.send(null);
    return xhrId;
  }
  onProgress(xhrId, evt) {
    const pendingRequest = this.pendingRequests[xhrId];
    if (!pendingRequest) {
      return;
    }
    pendingRequest.onProgress?.(evt);
  }
  onStateChange(xhrId, evt) {
    const pendingRequest = this.pendingRequests[xhrId];
    if (!pendingRequest) {
      return;
    }
    const xhr = pendingRequest.xhr;
    if (xhr.readyState >= 2 && pendingRequest.onHeadersReceived) {
      pendingRequest.onHeadersReceived();
      delete pendingRequest.onHeadersReceived;
    }
    if (xhr.readyState !== 4) {
      return;
    }
    if (!(xhrId in this.pendingRequests)) {
      return;
    }
    delete this.pendingRequests[xhrId];
    if (xhr.status === 0 && this.isHttp) {
      pendingRequest.onError(xhr.status);
      return;
    }
    const xhrStatus = xhr.status || OK_RESPONSE;
    const ok_response_on_range_request = xhrStatus === OK_RESPONSE && pendingRequest.expectedStatus === PARTIAL_CONTENT_RESPONSE;
    if (!ok_response_on_range_request && xhrStatus !== pendingRequest.expectedStatus) {
      pendingRequest.onError(xhr.status);
      return;
    }
    const chunk = network_getArrayBuffer(xhr);
    if (xhrStatus === PARTIAL_CONTENT_RESPONSE) {
      const rangeHeader = xhr.getResponseHeader("Content-Range");
      const matches = /bytes (\d+)-(\d+)\/(\d+)/.exec(rangeHeader);
      if (matches) {
        pendingRequest.onDone({
          begin: parseInt(matches[1], 10),
          chunk
        });
      } else {
        warn(`Missing or invalid "Content-Range" header.`);
        pendingRequest.onError(0);
      }
    } else if (chunk) {
      pendingRequest.onDone({
        begin: 0,
        chunk
      });
    } else {
      pendingRequest.onError(xhr.status);
    }
  }
  getRequestXhr(xhrId) {
    return this.pendingRequests[xhrId].xhr;
  }
  isPendingRequest(xhrId) {
    return xhrId in this.pendingRequests;
  }
  abortRequest(xhrId) {
    const xhr = this.pendingRequests[xhrId].xhr;
    delete this.pendingRequests[xhrId];
    xhr.abort();
  }
}
class PDFNetworkStream {
  constructor(source) {
    this._source = source;
    this._manager = new NetworkManager(source);
    this._rangeChunkSize = source.rangeChunkSize;
    this._fullRequestReader = null;
    this._rangeRequestReaders = [];
  }
  _onRangeRequestReaderClosed(reader) {
    const i = this._rangeRequestReaders.indexOf(reader);
    if (i >= 0) {
      this._rangeRequestReaders.splice(i, 1);
    }
  }
  getFullReader() {
    assert(!this._fullRequestReader, "PDFNetworkStream.getFullReader can only be called once.");
    this._fullRequestReader = new PDFNetworkStreamFullRequestReader(this._manager, this._source);
    return this._fullRequestReader;
  }
  getRangeReader(begin, end) {
    const reader = new PDFNetworkStreamRangeRequestReader(this._manager, begin, end);
    reader.onClosed = this._onRangeRequestReaderClosed.bind(this);
    this._rangeRequestReaders.push(reader);
    return reader;
  }
  cancelAllRequests(reason) {
    this._fullRequestReader?.cancel(reason);
    for (const reader of this._rangeRequestReaders.slice(0)) {
      reader.cancel(reason);
    }
  }
}
class PDFNetworkStreamFullRequestReader {
  constructor(manager, source) {
    this._manager = manager;
    this._url = source.url;
    this._fullRequestId = manager.request({
      onHeadersReceived: this._onHeadersReceived.bind(this),
      onDone: this._onDone.bind(this),
      onError: this._onError.bind(this),
      onProgress: this._onProgress.bind(this)
    });
    this._headersCapability = Promise.withResolvers();
    this._disableRange = source.disableRange || false;
    this._contentLength = source.length;
    this._rangeChunkSize = source.rangeChunkSize;
    if (!this._rangeChunkSize && !this._disableRange) {
      this._disableRange = true;
    }
    this._isStreamingSupported = false;
    this._isRangeSupported = false;
    this._cachedChunks = [];
    this._requests = [];
    this._done = false;
    this._storedError = undefined;
    this._filename = null;
    this.onProgress = null;
  }
  _onHeadersReceived() {
    const fullRequestXhrId = this._fullRequestId;
    const fullRequestXhr = this._manager.getRequestXhr(fullRequestXhrId);
    this._manager._responseOrigin = getResponseOrigin(fullRequestXhr.responseURL);
    const rawResponseHeaders = fullRequestXhr.getAllResponseHeaders();
    const responseHeaders = new Headers(rawResponseHeaders ? rawResponseHeaders.trimStart().replace(/[^\S ]+$/, "").split(/[\r\n]+/).map(x => {
      const [key, ...val] = x.split(": ");
      return [key, val.join(": ")];
    }) : []);
    const {
      allowRangeRequests,
      suggestedLength
    } = validateRangeRequestCapabilities({
      responseHeaders,
      isHttp: this._manager.isHttp,
      rangeChunkSize: this._rangeChunkSize,
      disableRange: this._disableRange
    });
    if (allowRangeRequests) {
      this._isRangeSupported = true;
    }
    this._contentLength = suggestedLength || this._contentLength;
    this._filename = extractFilenameFromHeader(responseHeaders);
    if (this._isRangeSupported) {
      this._manager.abortRequest(fullRequestXhrId);
    }
    this._headersCapability.resolve();
  }
  _onDone(data) {
    if (data) {
      if (this._requests.length > 0) {
        const requestCapability = this._requests.shift();
        requestCapability.resolve({
          value: data.chunk,
          done: false
        });
      } else {
        this._cachedChunks.push(data.chunk);
      }
    }
    this._done = true;
    if (this._cachedChunks.length > 0) {
      return;
    }
    for (const requestCapability of this._requests) {
      requestCapability.resolve({
        value: undefined,
        done: true
      });
    }
    this._requests.length = 0;
  }
  _onError(status) {
    this._storedError = createResponseError(status, this._url);
    this._headersCapability.reject(this._storedError);
    for (const requestCapability of this._requests) {
      requestCapability.reject(this._storedError);
    }
    this._requests.length = 0;
    this._cachedChunks.length = 0;
  }
  _onProgress(evt) {
    this.onProgress?.({
      loaded: evt.loaded,
      total: evt.lengthComputable ? evt.total : this._contentLength
    });
  }
  get filename() {
    return this._filename;
  }
  get isRangeSupported() {
    return this._isRangeSupported;
  }
  get isStreamingSupported() {
    return this._isStreamingSupported;
  }
  get contentLength() {
    return this._contentLength;
  }
  get headersReady() {
    return this._headersCapability.promise;
  }
  async read() {
    await this._headersCapability.promise;
    if (this._storedError) {
      throw this._storedError;
    }
    if (this._cachedChunks.length > 0) {
      const chunk = this._cachedChunks.shift();
      return {
        value: chunk,
        done: false
      };
    }
    if (this._done) {
      return {
        value: undefined,
        done: true
      };
    }
    const requestCapability = Promise.withResolvers();
    this._requests.push(requestCapability);
    return requestCapability.promise;
  }
  cancel(reason) {
    this._done = true;
    this._headersCapability.reject(reason);
    for (const requestCapability of this._requests) {
      requestCapability.resolve({
        value: undefined,
        done: true
      });
    }
    this._requests.length = 0;
    if (this._manager.isPendingRequest(this._fullRequestId)) {
      this._manager.abortRequest(this._fullRequestId);
    }
    this._fullRequestReader = null;
  }
}
class PDFNetworkStreamRangeRequestReader {
  constructor(manager, begin, end) {
    this._manager = manager;
    this._url = manager.url;
    this._requestId = manager.request({
      begin,
      end,
      onHeadersReceived: this._onHeadersReceived.bind(this),
      onDone: this._onDone.bind(this),
      onError: this._onError.bind(this),
      onProgress: this._onProgress.bind(this)
    });
    this._requests = [];
    this._queuedChunk = null;
    this._done = false;
    this._storedError = undefined;
    this.onProgress = null;
    this.onClosed = null;
  }
  _onHeadersReceived() {
    const responseOrigin = getResponseOrigin(this._manager.getRequestXhr(this._requestId)?.responseURL);
    if (responseOrigin !== this._manager._responseOrigin) {
      this._storedError = new Error(`Expected range response-origin "${responseOrigin}" to match "${this._manager._responseOrigin}".`);
      this._onError(0);
    }
  }
  _close() {
    this.onClosed?.(this);
  }
  _onDone(data) {
    const chunk = data.chunk;
    if (this._requests.length > 0) {
      const requestCapability = this._requests.shift();
      requestCapability.resolve({
        value: chunk,
        done: false
      });
    } else {
      this._queuedChunk = chunk;
    }
    this._done = true;
    for (const requestCapability of this._requests) {
      requestCapability.resolve({
        value: undefined,
        done: true
      });
    }
    this._requests.length = 0;
    this._close();
  }
  _onError(status) {
    this._storedError ??= createResponseError(status, this._url);
    for (const requestCapability of this._requests) {
      requestCapability.reject(this._storedError);
    }
    this._requests.length = 0;
    this._queuedChunk = null;
  }
  _onProgress(evt) {
    if (!this.isStreamingSupported) {
      this.onProgress?.({
        loaded: evt.loaded
      });
    }
  }
  get isStreamingSupported() {
    return false;
  }
  async read() {
    if (this._storedError) {
      throw this._storedError;
    }
    if (this._queuedChunk !== null) {
      const chunk = this._queuedChunk;
      this._queuedChunk = null;
      return {
        value: chunk,
        done: false
      };
    }
    if (this._done) {
      return {
        value: undefined,
        done: true
      };
    }
    const requestCapability = Promise.withResolvers();
    this._requests.push(requestCapability);
    return requestCapability.promise;
  }
  cancel(reason) {
    this._done = true;
    for (const requestCapability of this._requests) {
      requestCapability.resolve({
        value: undefined,
        done: true
      });
    }
    this._requests.length = 0;
    if (this._manager.isPendingRequest(this._requestId)) {
      this._manager.abortRequest(this._requestId);
    }
    this._close();
  }
}

;// ./src/display/node_stream.js
























const urlRegex = /^[a-z][a-z0-9\-+.]+:/i;
function parseUrlOrPath(sourceUrl) {
  if (urlRegex.test(sourceUrl)) {
    return new URL(sourceUrl);
  }
  const url = process.getBuiltinModule("url");
  return new URL(url.pathToFileURL(sourceUrl));
}
class PDFNodeStream {
  constructor(source) {
    this.source = source;
    this.url = parseUrlOrPath(source.url);
    assert(this.url.protocol === "file:", "PDFNodeStream only supports file:// URLs.");
    this._fullRequestReader = null;
    this._rangeRequestReaders = [];
  }
  get _progressiveDataLength() {
    return this._fullRequestReader?._loaded ?? 0;
  }
  getFullReader() {
    assert(!this._fullRequestReader, "PDFNodeStream.getFullReader can only be called once.");
    this._fullRequestReader = new PDFNodeStreamFsFullReader(this);
    return this._fullRequestReader;
  }
  getRangeReader(start, end) {
    if (end <= this._progressiveDataLength) {
      return null;
    }
    const rangeReader = new PDFNodeStreamFsRangeReader(this, start, end);
    this._rangeRequestReaders.push(rangeReader);
    return rangeReader;
  }
  cancelAllRequests(reason) {
    this._fullRequestReader?.cancel(reason);
    for (const reader of this._rangeRequestReaders.slice(0)) {
      reader.cancel(reason);
    }
  }
}
class PDFNodeStreamFsFullReader {
  constructor(stream) {
    this._url = stream.url;
    this._done = false;
    this._storedError = null;
    this.onProgress = null;
    const source = stream.source;
    this._contentLength = source.length;
    this._loaded = 0;
    this._filename = null;
    this._disableRange = source.disableRange || false;
    this._rangeChunkSize = source.rangeChunkSize;
    if (!this._rangeChunkSize && !this._disableRange) {
      this._disableRange = true;
    }
    this._isStreamingSupported = !source.disableStream;
    this._isRangeSupported = !source.disableRange;
    this._readableStream = null;
    this._readCapability = Promise.withResolvers();
    this._headersCapability = Promise.withResolvers();
    const fs = process.getBuiltinModule("fs");
    fs.promises.lstat(this._url).then(stat => {
      this._contentLength = stat.size;
      this._setReadableStream(fs.createReadStream(this._url));
      this._headersCapability.resolve();
    }, error => {
      if (error.code === "ENOENT") {
        error = createResponseError(0, this._url.href);
      }
      this._storedError = error;
      this._headersCapability.reject(error);
    });
  }
  get headersReady() {
    return this._headersCapability.promise;
  }
  get filename() {
    return this._filename;
  }
  get contentLength() {
    return this._contentLength;
  }
  get isRangeSupported() {
    return this._isRangeSupported;
  }
  get isStreamingSupported() {
    return this._isStreamingSupported;
  }
  async read() {
    await this._readCapability.promise;
    if (this._done) {
      return {
        value: undefined,
        done: true
      };
    }
    if (this._storedError) {
      throw this._storedError;
    }
    const chunk = this._readableStream.read();
    if (chunk === null) {
      this._readCapability = Promise.withResolvers();
      return this.read();
    }
    this._loaded += chunk.length;
    this.onProgress?.({
      loaded: this._loaded,
      total: this._contentLength
    });
    const buffer = new Uint8Array(chunk).buffer;
    return {
      value: buffer,
      done: false
    };
  }
  cancel(reason) {
    if (!this._readableStream) {
      this._error(reason);
      return;
    }
    this._readableStream.destroy(reason);
  }
  _error(reason) {
    this._storedError = reason;
    this._readCapability.resolve();
  }
  _setReadableStream(readableStream) {
    this._readableStream = readableStream;
    readableStream.on("readable", () => {
      this._readCapability.resolve();
    });
    readableStream.on("end", () => {
      readableStream.destroy();
      this._done = true;
      this._readCapability.resolve();
    });
    readableStream.on("error", reason => {
      this._error(reason);
    });
    if (!this._isStreamingSupported && this._isRangeSupported) {
      this._error(new AbortException("streaming is disabled"));
    }
    if (this._storedError) {
      this._readableStream.destroy(this._storedError);
    }
  }
}
class PDFNodeStreamFsRangeReader {
  constructor(stream, start, end) {
    this._url = stream.url;
    this._done = false;
    this._storedError = null;
    this.onProgress = null;
    this._loaded = 0;
    this._readableStream = null;
    this._readCapability = Promise.withResolvers();
    const source = stream.source;
    this._isStreamingSupported = !source.disableStream;
    const fs = process.getBuiltinModule("fs");
    this._setReadableStream(fs.createReadStream(this._url, {
      start,
      end: end - 1
    }));
  }
  get isStreamingSupported() {
    return this._isStreamingSupported;
  }
  async read() {
    await this._readCapability.promise;
    if (this._done) {
      return {
        value: undefined,
        done: true
      };
    }
    if (this._storedError) {
      throw this._storedError;
    }
    const chunk = this._readableStream.read();
    if (chunk === null) {
      this._readCapability = Promise.withResolvers();
      return this.read();
    }
    this._loaded += chunk.length;
    this.onProgress?.({
      loaded: this._loaded
    });
    const buffer = new Uint8Array(chunk).buffer;
    return {
      value: buffer,
      done: false
    };
  }
  cancel(reason) {
    if (!this._readableStream) {
      this._error(reason);
      return;
    }
    this._readableStream.destroy(reason);
  }
  _error(reason) {
    this._storedError = reason;
    this._readCapability.resolve();
  }
  _setReadableStream(readableStream) {
    this._readableStream = readableStream;
    readableStream.on("readable", () => {
      this._readCapability.resolve();
    });
    readableStream.on("end", () => {
      readableStream.destroy();
      this._done = true;
      this._readCapability.resolve();
    });
    readableStream.on("error", reason => {
      this._error(reason);
    });
    if (this._storedError) {
      this._readableStream.destroy(this._storedError);
    }
  }
}

;// ./src/display/pdf_objects.js


function pdf_objects_classPrivateMethodInitSpec(e, a) { pdf_objects_checkPrivateRedeclaration(e, a), a.add(e); }
function pdf_objects_classPrivateFieldInitSpec(e, t, a) { pdf_objects_checkPrivateRedeclaration(e, t), t.set(e, a); }
function pdf_objects_checkPrivateRedeclaration(e, t) { if (t.has(e)) throw new TypeError("Cannot initialize the same private elements twice on an object"); }
function pdf_objects_classPrivateFieldSet(s, a, r) { return s.set(pdf_objects_assertClassBrand(s, a), r), r; }
function pdf_objects_classPrivateFieldGet(s, a) { return s.get(pdf_objects_assertClassBrand(s, a)); }
function pdf_objects_assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); }
const INITIAL_DATA = Symbol("INITIAL_DATA");
var _objs = /*#__PURE__*/new WeakMap();
var _PDFObjects_brand = /*#__PURE__*/new WeakSet();
class PDFObjects {
  constructor() {
    pdf_objects_classPrivateMethodInitSpec(this, _PDFObjects_brand);
    pdf_objects_classPrivateFieldInitSpec(this, _objs, Object.create(null));
  }
  get(objId) {
    let callback = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
    if (callback) {
      const obj = pdf_objects_assertClassBrand(_PDFObjects_brand, this, _ensureObj).call(this, objId);
      obj.promise.then(() => callback(obj.data));
      return null;
    }
    const obj = pdf_objects_classPrivateFieldGet(_objs, this)[objId];
    if (!obj || obj.data === INITIAL_DATA) {
      throw new Error(`Requesting object that isn't resolved yet ${objId}.`);
    }
    return obj.data;
  }
  has(objId) {
    const obj = pdf_objects_classPrivateFieldGet(_objs, this)[objId];
    return !!obj && obj.data !== INITIAL_DATA;
  }
  delete(objId) {
    const obj = pdf_objects_classPrivateFieldGet(_objs, this)[objId];
    if (!obj || obj.data === INITIAL_DATA) {
      return false;
    }
    delete pdf_objects_classPrivateFieldGet(_objs, this)[objId];
    return true;
  }
  resolve(objId) {
    let data = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
    const obj = pdf_objects_assertClassBrand(_PDFObjects_brand, this, _ensureObj).call(this, objId);
    obj.data = data;
    obj.resolve();
  }
  clear() {
    for (const objId in pdf_objects_classPrivateFieldGet(_objs, this)) {
      const {
        data
      } = pdf_objects_classPrivateFieldGet(_objs, this)[objId];
      data?.bitmap?.close();
    }
    pdf_objects_classPrivateFieldSet(_objs, this, Object.create(null));
  }
  *[Symbol.iterator]() {
    for (const objId in pdf_objects_classPrivateFieldGet(_objs, this)) {
      const {
        data
      } = pdf_objects_classPrivateFieldGet(_objs, this)[objId];
      if (data === INITIAL_DATA) {
        continue;
      }
      yield [objId, data];
    }
  }
}
function _ensureObj(objId) {
  return pdf_objects_classPrivateFieldGet(_objs, this)[objId] ||= {
    ...Promise.withResolvers(),
    data: INITIAL_DATA
  };
}

;// ./src/display/text_layer.js
var _TextLayer;










function text_layer_classPrivateMethodInitSpec(e, a) { text_layer_checkPrivateRedeclaration(e, a), a.add(e); }
function text_layer_classPrivateFieldInitSpec(e, t, a) { text_layer_checkPrivateRedeclaration(e, t), t.set(e, a); }
function text_layer_checkPrivateRedeclaration(e, t) { if (t.has(e)) throw new TypeError("Cannot initialize the same private elements twice on an object"); }
function text_layer_classPrivateFieldGet(s, a) { return s.get(text_layer_assertClassBrand(s, a)); }
function text_layer_classPrivateFieldSet(s, a, r) { return s.set(text_layer_assertClassBrand(s, a), r), r; }
function text_layer_assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); }


const MAX_TEXT_DIVS_TO_RENDER = 100000;
const DEFAULT_FONT_SIZE = 30;
var _capability = /*#__PURE__*/new WeakMap();
var text_layer_container = /*#__PURE__*/new WeakMap();
var _disableProcessItems = /*#__PURE__*/new WeakMap();
var _fontInspectorEnabled = /*#__PURE__*/new WeakMap();
var _lang = /*#__PURE__*/new WeakMap();
var _layoutTextParams = /*#__PURE__*/new WeakMap();
var _pageHeight = /*#__PURE__*/new WeakMap();
var _pageWidth = /*#__PURE__*/new WeakMap();
var _reader = /*#__PURE__*/new WeakMap();
var _rootContainer = /*#__PURE__*/new WeakMap();
var _rotation = /*#__PURE__*/new WeakMap();
var _scale = /*#__PURE__*/new WeakMap();
var _styleCache = /*#__PURE__*/new WeakMap();
var _textContentItemsStr = /*#__PURE__*/new WeakMap();
var _textContentSource = /*#__PURE__*/new WeakMap();
var _textDivs = /*#__PURE__*/new WeakMap();
var _textDivProperties = /*#__PURE__*/new WeakMap();
var _transform = /*#__PURE__*/new WeakMap();
var _TextLayer_brand = /*#__PURE__*/new WeakSet();
class TextLayer {
  constructor(_ref) {
    let {
      textContentSource,
      container,
      viewport
    } = _ref;
    text_layer_classPrivateMethodInitSpec(this, _TextLayer_brand);
    text_layer_classPrivateFieldInitSpec(this, _capability, Promise.withResolvers());
    text_layer_classPrivateFieldInitSpec(this, text_layer_container, null);
    text_layer_classPrivateFieldInitSpec(this, _disableProcessItems, false);
    text_layer_classPrivateFieldInitSpec(this, _fontInspectorEnabled, !!globalThis.FontInspector?.enabled);
    text_layer_classPrivateFieldInitSpec(this, _lang, null);
    text_layer_classPrivateFieldInitSpec(this, _layoutTextParams, null);
    text_layer_classPrivateFieldInitSpec(this, _pageHeight, 0);
    text_layer_classPrivateFieldInitSpec(this, _pageWidth, 0);
    text_layer_classPrivateFieldInitSpec(this, _reader, null);
    text_layer_classPrivateFieldInitSpec(this, _rootContainer, null);
    text_layer_classPrivateFieldInitSpec(this, _rotation, 0);
    text_layer_classPrivateFieldInitSpec(this, _scale, 0);
    text_layer_classPrivateFieldInitSpec(this, _styleCache, Object.create(null));
    text_layer_classPrivateFieldInitSpec(this, _textContentItemsStr, []);
    text_layer_classPrivateFieldInitSpec(this, _textContentSource, null);
    text_layer_classPrivateFieldInitSpec(this, _textDivs, []);
    text_layer_classPrivateFieldInitSpec(this, _textDivProperties, new WeakMap());
    text_layer_classPrivateFieldInitSpec(this, _transform, null);
    if (textContentSource instanceof ReadableStream) {
      text_layer_classPrivateFieldSet(_textContentSource, this, textContentSource);
    } else if (typeof textContentSource === "object") {
      text_layer_classPrivateFieldSet(_textContentSource, this, new ReadableStream({
        start(controller) {
          controller.enqueue(textContentSource);
          controller.close();
        }
      }));
    } else {
      throw new Error('No "textContentSource" parameter specified.');
    }
    text_layer_classPrivateFieldSet(text_layer_container, this, text_layer_classPrivateFieldSet(_rootContainer, this, container));
    text_layer_classPrivateFieldSet(_scale, this, viewport.scale * OutputScale.pixelRatio);
    text_layer_classPrivateFieldSet(_rotation, this, viewport.rotation);
    text_layer_classPrivateFieldSet(_layoutTextParams, this, {
      div: null,
      properties: null,
      ctx: null
    });
    const {
      pageWidth,
      pageHeight,
      pageX,
      pageY
    } = viewport.rawDims;
    text_layer_classPrivateFieldSet(_transform, this, [1, 0, 0, -1, -pageX, pageY + pageHeight]);
    text_layer_classPrivateFieldSet(_pageWidth, this, pageWidth);
    text_layer_classPrivateFieldSet(_pageHeight, this, pageHeight);
    _ensureMinFontSizeComputed.call(TextLayer);
    setLayerDimensions(container, viewport);
    text_layer_classPrivateFieldGet(_capability, this).promise.finally(() => {
      _pendingTextLayers._.delete(this);
      text_layer_classPrivateFieldSet(_layoutTextParams, this, null);
      text_layer_classPrivateFieldSet(_styleCache, this, null);
    }).catch(() => {});
  }
  static get fontFamilyMap() {
    const {
      isWindows,
      isFirefox
    } = util_FeatureTest.platform;
    return shadow(this, "fontFamilyMap", new Map([["sans-serif", `${isWindows && isFirefox ? "Calibri, " : ""}sans-serif`], ["monospace", `${isWindows && isFirefox ? "Lucida Console, " : ""}monospace`]]));
  }
  render() {
    const pump = () => {
      text_layer_classPrivateFieldGet(_reader, this).read().then(_ref2 => {
        let {
          value,
          done
        } = _ref2;
        if (done) {
          text_layer_classPrivateFieldGet(_capability, this).resolve();
          return;
        }
        text_layer_classPrivateFieldGet(_lang, this) ?? text_layer_classPrivateFieldSet(_lang, this, value.lang);
        Object.assign(text_layer_classPrivateFieldGet(_styleCache, this), value.styles);
        text_layer_assertClassBrand(_TextLayer_brand, this, _processItems).call(this, value.items);
        pump();
      }, text_layer_classPrivateFieldGet(_capability, this).reject);
    };
    text_layer_classPrivateFieldSet(_reader, this, text_layer_classPrivateFieldGet(_textContentSource, this).getReader());
    _pendingTextLayers._.add(this);
    pump();
    return text_layer_classPrivateFieldGet(_capability, this).promise;
  }
  update(_ref3) {
    let {
      viewport,
      onBefore = null
    } = _ref3;
    const scale = viewport.scale * OutputScale.pixelRatio;
    const rotation = viewport.rotation;
    if (rotation !== text_layer_classPrivateFieldGet(_rotation, this)) {
      onBefore?.();
      text_layer_classPrivateFieldSet(_rotation, this, rotation);
      setLayerDimensions(text_layer_classPrivateFieldGet(_rootContainer, this), {
        rotation
      });
    }
    if (scale !== text_layer_classPrivateFieldGet(_scale, this)) {
      onBefore?.();
      text_layer_classPrivateFieldSet(_scale, this, scale);
      const params = {
        div: null,
        properties: null,
        ctx: _getCtx.call(TextLayer, text_layer_classPrivateFieldGet(_lang, this))
      };
      for (const div of text_layer_classPrivateFieldGet(_textDivs, this)) {
        params.properties = text_layer_classPrivateFieldGet(_textDivProperties, this).get(div);
        params.div = div;
        text_layer_assertClassBrand(_TextLayer_brand, this, _layout).call(this, params);
      }
    }
  }
  cancel() {
    const abortEx = new AbortException("TextLayer task cancelled.");
    text_layer_classPrivateFieldGet(_reader, this)?.cancel(abortEx).catch(() => {});
    text_layer_classPrivateFieldSet(_reader, this, null);
    text_layer_classPrivateFieldGet(_capability, this).reject(abortEx);
  }
  get textDivs() {
    return text_layer_classPrivateFieldGet(_textDivs, this);
  }
  get textContentItemsStr() {
    return text_layer_classPrivateFieldGet(_textContentItemsStr, this);
  }
  static cleanup() {
    if (text_layer_assertClassBrand(TextLayer, this, _pendingTextLayers)._.size > 0) {
      return;
    }
    text_layer_assertClassBrand(TextLayer, this, _ascentCache)._.clear();
    for (const {
      canvas
    } of text_layer_assertClassBrand(TextLayer, this, _canvasContexts)._.values()) {
      canvas.remove();
    }
    text_layer_assertClassBrand(TextLayer, this, _canvasContexts)._.clear();
  }
}
_TextLayer = TextLayer;
function _processItems(items) {
  if (text_layer_classPrivateFieldGet(_disableProcessItems, this)) {
    return;
  }
  text_layer_classPrivateFieldGet(_layoutTextParams, this).ctx ??= _getCtx.call(_TextLayer, text_layer_classPrivateFieldGet(_lang, this));
  const textDivs = text_layer_classPrivateFieldGet(_textDivs, this),
    textContentItemsStr = text_layer_classPrivateFieldGet(_textContentItemsStr, this);
  for (const item of items) {
    if (textDivs.length > MAX_TEXT_DIVS_TO_RENDER) {
      warn("Ignoring additional textDivs for performance reasons.");
      text_layer_classPrivateFieldSet(_disableProcessItems, this, true);
      return;
    }
    if (item.str === undefined) {
      if (item.type === "beginMarkedContentProps" || item.type === "beginMarkedContent") {
        const parent = text_layer_classPrivateFieldGet(text_layer_container, this);
        text_layer_classPrivateFieldSet(text_layer_container, this, document.createElement("span"));
        text_layer_classPrivateFieldGet(text_layer_container, this).classList.add("markedContent");
        if (item.id !== null) {
          text_layer_classPrivateFieldGet(text_layer_container, this).setAttribute("id", `${item.id}`);
        }
        parent.append(text_layer_classPrivateFieldGet(text_layer_container, this));
      } else if (item.type === "endMarkedContent") {
        text_layer_classPrivateFieldSet(text_layer_container, this, text_layer_classPrivateFieldGet(text_layer_container, this).parentNode);
      }
      continue;
    }
    textContentItemsStr.push(item.str);
    text_layer_assertClassBrand(_TextLayer_brand, this, _appendText).call(this, item);
  }
}
function _appendText(geom) {
  const textDiv = document.createElement("span");
  const textDivProperties = {
    angle: 0,
    canvasWidth: 0,
    hasText: geom.str !== "",
    hasEOL: geom.hasEOL,
    fontSize: 0
  };
  text_layer_classPrivateFieldGet(_textDivs, this).push(textDiv);
  const tx = Util.transform(text_layer_classPrivateFieldGet(_transform, this), geom.transform);
  let angle = Math.atan2(tx[1], tx[0]);
  const style = text_layer_classPrivateFieldGet(_styleCache, this)[geom.fontName];
  if (style.vertical) {
    angle += Math.PI / 2;
  }
  let fontFamily = text_layer_classPrivateFieldGet(_fontInspectorEnabled, this) && style.fontSubstitution || style.fontFamily;
  fontFamily = _TextLayer.fontFamilyMap.get(fontFamily) || fontFamily;
  const fontHeight = Math.hypot(tx[2], tx[3]);
  const fontAscent = fontHeight * _getAscent.call(_TextLayer, fontFamily, style, text_layer_classPrivateFieldGet(_lang, this));
  let left, top;
  if (angle === 0) {
    left = tx[4];
    top = tx[5] - fontAscent;
  } else {
    left = tx[4] + fontAscent * Math.sin(angle);
    top = tx[5] - fontAscent * Math.cos(angle);
  }
  const scaleFactorStr = "calc(var(--total-scale-factor) *";
  const divStyle = textDiv.style;
  if (text_layer_classPrivateFieldGet(text_layer_container, this) === text_layer_classPrivateFieldGet(_rootContainer, this)) {
    divStyle.left = `${(100 * left / text_layer_classPrivateFieldGet(_pageWidth, this)).toFixed(2)}%`;
    divStyle.top = `${(100 * top / text_layer_classPrivateFieldGet(_pageHeight, this)).toFixed(2)}%`;
  } else {
    divStyle.left = `${scaleFactorStr}${left.toFixed(2)}px)`;
    divStyle.top = `${scaleFactorStr}${top.toFixed(2)}px)`;
  }
  divStyle.fontSize = `${scaleFactorStr}${(_minFontSize._ * fontHeight).toFixed(2)}px)`;
  divStyle.fontFamily = fontFamily;
  textDivProperties.fontSize = fontHeight;
  textDiv.setAttribute("role", "presentation");
  textDiv.textContent = geom.str;
  textDiv.dir = geom.dir;
  if (text_layer_classPrivateFieldGet(_fontInspectorEnabled, this)) {
    textDiv.dataset.fontName = style.fontSubstitutionLoadedName || geom.fontName;
  }
  if (angle !== 0) {
    textDivProperties.angle = angle * (180 / Math.PI);
  }
  let shouldScaleText = false;
  if (geom.str.length > 1) {
    shouldScaleText = true;
  } else if (geom.str !== " " && geom.transform[0] !== geom.transform[3]) {
    const absScaleX = Math.abs(geom.transform[0]),
      absScaleY = Math.abs(geom.transform[3]);
    if (absScaleX !== absScaleY && Math.max(absScaleX, absScaleY) / Math.min(absScaleX, absScaleY) > 1.5) {
      shouldScaleText = true;
    }
  }
  if (shouldScaleText) {
    textDivProperties.canvasWidth = style.vertical ? geom.height : geom.width;
  }
  text_layer_classPrivateFieldGet(_textDivProperties, this).set(textDiv, textDivProperties);
  text_layer_classPrivateFieldGet(_layoutTextParams, this).div = textDiv;
  text_layer_classPrivateFieldGet(_layoutTextParams, this).properties = textDivProperties;
  text_layer_assertClassBrand(_TextLayer_brand, this, _layout).call(this, text_layer_classPrivateFieldGet(_layoutTextParams, this));
  if (textDivProperties.hasText) {
    text_layer_classPrivateFieldGet(text_layer_container, this).append(textDiv);
  }
  if (textDivProperties.hasEOL) {
    const br = document.createElement("br");
    br.setAttribute("role", "presentation");
    text_layer_classPrivateFieldGet(text_layer_container, this).append(br);
  }
}
function _layout(params) {
  const {
    div,
    properties,
    ctx
  } = params;
  const {
    style
  } = div;
  let transform = "";
  if (_minFontSize._ > 1) {
    transform = `scale(${1 / _minFontSize._})`;
  }
  if (properties.canvasWidth !== 0 && properties.hasText) {
    const {
      fontFamily
    } = style;
    const {
      canvasWidth,
      fontSize
    } = properties;
    _ensureCtxFont.call(_TextLayer, ctx, fontSize * text_layer_classPrivateFieldGet(_scale, this), fontFamily);
    try {
      const {
        width
      } = ctx.measureText(div.textContent);
      if (width > 0) {
        transform = `scaleX(${canvasWidth * text_layer_classPrivateFieldGet(_scale, this) / width}) ${transform}`;
      }
    } catch (fingerprintIsBlockedException) {}
  }
  if (properties.angle !== 0) {
    transform = `rotate(${properties.angle}deg) ${transform}`;
  }
  if (transform.length > 0) {
    style.transform = transform;
  }
}
function _getCtx() {
  let lang = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
  let ctx = text_layer_assertClassBrand(_TextLayer, this, _canvasContexts)._.get(lang ||= "");
  if (!ctx) {
    const canvas = document.createElement("canvas");
    canvas.className = "hiddenCanvasElement";
    canvas.lang = lang;
    canvas.width = canvas.height = 0;
    document.body.append(canvas);
    ctx = canvas.getContext("2d", {
      alpha: false,
      willReadFrequently: true
    });
    text_layer_assertClassBrand(_TextLayer, this, _canvasContexts)._.set(lang, ctx);
    text_layer_assertClassBrand(_TextLayer, this, _canvasCtxFonts)._.set(ctx, {
      size: 0,
      family: ""
    });
  }
  return ctx;
}
function _ensureCtxFont(ctx, size, family) {
  const cached = text_layer_assertClassBrand(_TextLayer, this, _canvasCtxFonts)._.get(ctx);
  if (size === cached.size && family === cached.family) {
    return;
  }
  ctx.font = `${size}px ${family}`;
  cached.size = size;
  cached.family = family;
}
function _ensureMinFontSizeComputed() {
  if (text_layer_assertClassBrand(_TextLayer, this, _minFontSize)._ !== null) {
    return;
  }
  const div = document.createElement("div");
  div.style.opacity = 0;
  div.style.lineHeight = 1;
  div.style.fontSize = "1px";
  div.style.position = "absolute";
  div.textContent = "X";
  document.body.append(div);
  _minFontSize._ = text_layer_assertClassBrand(_TextLayer, this, div.getBoundingClientRect().height);
  div.remove();
}
function _getAscent(fontFamily, style, lang) {
  const cachedAscent = text_layer_assertClassBrand(_TextLayer, this, _ascentCache)._.get(fontFamily);
  if (cachedAscent) {
    return cachedAscent;
  }
  const ctx = text_layer_assertClassBrand(_TextLayer, this, _getCtx).call(this, lang);
  ctx.canvas.width = ctx.canvas.height = DEFAULT_FONT_SIZE;
  text_layer_assertClassBrand(_TextLayer, this, _ensureCtxFont).call(this, ctx, DEFAULT_FONT_SIZE, fontFamily);
  const metrics = ctx.measureText("");
  const ascent = metrics?.fontBoundingBoxAscent;
  const descent = Math.abs(metrics?.fontBoundingBoxDescent);
  ctx.canvas.width = ctx.canvas.height = 0;
  let ratio = 0.8;
  if (ascent) {
    ratio = ascent / (ascent + descent);
  } else {
    if (util_FeatureTest.platform.isFirefox) {
      warn("Enable the `dom.textMetrics.fontBoundingBox.enabled` preference " + "in `about:config` to improve TextLayer rendering.");
    }
    if (style.ascent) {
      ratio = style.ascent;
    } else if (style.descent) {
      ratio = 1 + style.descent;
    }
  }
  text_layer_assertClassBrand(_TextLayer, this, _ascentCache)._.set(fontFamily, ratio);
  return ratio;
}
var _ascentCache = {
  _: new Map()
};
var _canvasContexts = {
  _: new Map()
};
var _canvasCtxFonts = {
  _: new WeakMap()
};
var _minFontSize = {
  _: null
};
var _pendingTextLayers = {
  _: new Set()
};

;// ./src/display/xfa_text.js

class XfaText {
  static textContent(xfa) {
    const items = [];
    const output = {
      items,
      styles: Object.create(null)
    };
    function walk(node) {
      if (!node) {
        return;
      }
      let str = null;
      const name = node.name;
      if (name === "#text") {
        str = node.value;
      } else if (!XfaText.shouldBuildText(name)) {
        return;
      } else if (node?.attributes?.textContent) {
        str = node.attributes.textContent;
      } else if (node.value) {
        str = node.value;
      }
      if (str !== null) {
        items.push({
          str
        });
      }
      if (!node.children) {
        return;
      }
      for (const child of node.children) {
        walk(child);
      }
    }
    walk(xfa);
    return output;
  }
  static shouldBuildText(name) {
    return !(name === "textarea" || name === "input" || name === "option" || name === "select");
  }
}

;// ./src/display/api.js
var _PDFDocumentLoadingTa, _PDFDocumentLoadingTa2, _PDFWorker;
function api_classPrivateGetter(s, r, a) { return a(api_assertClassBrand(s, r)); }
function api_classPrivateMethodInitSpec(e, a) { api_checkPrivateRedeclaration(e, a), a.add(e); }
function api_classPrivateFieldSet(s, a, r) { return s.set(api_assertClassBrand(s, a), r), r; }
function api_classPrivateFieldInitSpec(e, t, a) { api_checkPrivateRedeclaration(e, t), t.set(e, a); }
function api_checkPrivateRedeclaration(e, t) { if (t.has(e)) throw new TypeError("Cannot initialize the same private elements twice on an object"); }
function api_classPrivateFieldGet(s, a) { return s.get(api_assertClassBrand(s, a)); }
function api_assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); }
function api_defineProperty(e, r, t) { return (r = api_toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function api_toPropertyKey(t) { var i = api_toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function api_toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
























































const RENDERING_CANCELLED_TIMEOUT = 100;
function getDocument() {
  let src = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  if (typeof src === "string" || src instanceof URL) {
    src = {
      url: src
    };
  } else if (src instanceof ArrayBuffer || ArrayBuffer.isView(src)) {
    src = {
      data: src
    };
  }
  const task = new PDFDocumentLoadingTask();
  const {
    docId
  } = task;
  const url = src.url ? getUrlProp(src.url, src.baseHref) : null;
  const data = src.data ? getDataProp(src.data) : null;
  const httpHeaders = src.httpHeaders || null;
  const withCredentials = src.withCredentials === true;
  const password = src.password ?? null;
  const rangeTransport = src.range instanceof PDFDataRangeTransport ? src.range : null;
  const rangeChunkSize = Number.isInteger(src.rangeChunkSize) && src.rangeChunkSize > 0 ? src.rangeChunkSize : 2 ** 16;
  let worker = src.worker instanceof PDFWorker ? src.worker : null;
  const verbosity = src.verbosity;
  const docBaseUrl = typeof src.docBaseUrl === "string" && !isDataScheme(src.docBaseUrl) ? src.docBaseUrl : null;
  const rawCMapUrl = typeof src.cMapUrl === "function" ? src.cMapUrl() : typeof src.cMapUrl === "string" ? src.cMapUrl : null;
  const cMapUrl = getFactoryUrlProp(rawCMapUrl);
  const cMapPacked = src.cMapPacked !== false;
  const CMapReaderFactory = src.CMapReaderFactory || (isNodeJS ? NodeCMapReaderFactory : DOMCMapReaderFactory);
  const iccUrl = getFactoryUrlProp(src.iccUrl);
  const rawStandardFontDataUrl = typeof src.standardFontDataUrl === "function" ? src.standardFontDataUrl() : typeof src.standardFontDataUrl === "string" ? src.standardFontDataUrl : null;
  const standardFontDataUrl = getFactoryUrlProp(rawStandardFontDataUrl);
  const StandardFontDataFactory = src.StandardFontDataFactory || (isNodeJS ? NodeStandardFontDataFactory : DOMStandardFontDataFactory);
  const wasmUrl = getFactoryUrlProp(src.wasmUrl);
  const WasmFactory = src.WasmFactory || (isNodeJS ? NodeWasmFactory : DOMWasmFactory);
  const ignoreErrors = src.stopAtErrors !== true;
  const maxImageSize = Number.isInteger(src.maxImageSize) && src.maxImageSize > -1 ? src.maxImageSize : -1;
  const isEvalSupported = src.isEvalSupported !== false;
  const isOffscreenCanvasSupported = typeof src.isOffscreenCanvasSupported === "boolean" ? src.isOffscreenCanvasSupported : !isNodeJS;
  const isImageDecoderSupported = typeof src.isImageDecoderSupported === "boolean" ? src.isImageDecoderSupported : !isNodeJS && (util_FeatureTest.platform.isFirefox || !globalThis.chrome);
  const canvasMaxAreaInBytes = Number.isInteger(src.canvasMaxAreaInBytes) ? src.canvasMaxAreaInBytes : -1;
  const disableFontFace = typeof src.disableFontFace === "boolean" ? src.disableFontFace : isNodeJS;
  const fontExtraProperties = src.fontExtraProperties === true;
  const enableXfa = src.enableXfa === true;
  const ownerDocument = src.ownerDocument || globalThis.document;
  const disableRange = src.disableRange === true;
  const disableStream = src.disableStream === true;
  const disableAutoFetch = src.disableAutoFetch === true;
  const pdfBug = src.pdfBug === true;
  const CanvasFactory = src.CanvasFactory || (isNodeJS ? NodeCanvasFactory : DOMCanvasFactory);
  const FilterFactory = src.FilterFactory || (isNodeJS ? NodeFilterFactory : DOMFilterFactory);
  const enableHWA = src.enableHWA === true;
  const useWasm = src.useWasm !== false;
  const length = rangeTransport ? rangeTransport.length : src.length ?? NaN;
  const useSystemFonts = typeof src.useSystemFonts === "boolean" ? src.useSystemFonts : !isNodeJS && !disableFontFace;
  const useWorkerFetch = typeof src.useWorkerFetch === "boolean" ? src.useWorkerFetch : !!(CMapReaderFactory === DOMCMapReaderFactory && StandardFontDataFactory === DOMStandardFontDataFactory && WasmFactory === DOMWasmFactory && cMapUrl && standardFontDataUrl && wasmUrl && isValidFetchUrl(cMapUrl, document.baseURI) && isValidFetchUrl(standardFontDataUrl, document.baseURI) && isValidFetchUrl(wasmUrl, document.baseURI));
  const styleElement = null;
  setVerbosityLevel(verbosity);
  const transportFactory = {
    canvasFactory: new CanvasFactory({
      ownerDocument,
      enableHWA
    }),
    filterFactory: new FilterFactory({
      docId,
      ownerDocument
    }),
    cMapReaderFactory: useWorkerFetch ? null : new CMapReaderFactory({
      baseUrl: cMapUrl,
      isCompressed: cMapPacked
    }),
    standardFontDataFactory: useWorkerFetch ? null : new StandardFontDataFactory({
      baseUrl: standardFontDataUrl
    }),
    wasmFactory: useWorkerFetch ? null : new WasmFactory({
      baseUrl: wasmUrl
    })
  };
  if (!worker) {
    const workerParams = {
      verbosity,
      port: GlobalWorkerOptions.workerPort,
      cspPolicyService: src.cspPolicyService
    };
    worker = PDFWorker.create(workerParams);
    task._worker = worker;
  }
  const docParams = {
    docId,
    apiVersion: "5.3.754",
    data,
    password,
    disableAutoFetch,
    rangeChunkSize,
    length,
    docBaseUrl,
    enableXfa,
    evaluatorOptions: {
      maxImageSize,
      disableFontFace,
      ignoreErrors,
      isEvalSupported,
      isOffscreenCanvasSupported,
      isImageDecoderSupported,
      canvasMaxAreaInBytes,
      fontExtraProperties,
      useSystemFonts,
      useWasm,
      useWorkerFetch,
      cMapUrl,
      iccUrl,
      standardFontDataUrl,
      wasmUrl
    }
  };
  const transportParams = {
    ownerDocument,
    pdfBug,
    styleElement,
    loadingParams: {
      disableAutoFetch,
      enableXfa
    }
  };
  worker.promise.then(function () {
    if (task.destroyed) {
      throw new Error("Loading aborted");
    }
    if (worker.destroyed) {
      throw new Error("Worker was destroyed");
    }
    const workerIdPromise = worker.messageHandler.sendWithPromise("GetDocRequest", docParams, data ? [data.buffer] : null);
    let networkStream;
    if (rangeTransport) {
      networkStream = new PDFDataTransportStream(rangeTransport, {
        disableRange,
        disableStream
      });
    } else if (!data) {
      if (!url) {
        throw new Error("getDocument - no `url` parameter provided.");
      }
      const NetworkStream = isValidFetchUrl(url) ? PDFFetchStream : isNodeJS ? PDFNodeStream : PDFNetworkStream;
      networkStream = new NetworkStream({
        url,
        length,
        httpHeaders,
        withCredentials,
        rangeChunkSize,
        disableRange,
        disableStream
      });
    }
    return workerIdPromise.then(workerId => {
      if (task.destroyed) {
        throw new Error("Loading aborted");
      }
      if (worker.destroyed) {
        throw new Error("Worker was destroyed");
      }
      const messageHandler = new MessageHandler(docId, workerId, worker.port);
      const transport = new WorkerTransport(messageHandler, task, networkStream, transportParams, transportFactory);
      task._transport = transport;
      messageHandler.send("Ready", null);
    });
  }).catch(task._capability.reject);
  return task;
}
class PDFDocumentLoadingTask {
  constructor() {
    api_defineProperty(this, "_capability", Promise.withResolvers());
    api_defineProperty(this, "_transport", null);
    api_defineProperty(this, "_worker", null);
    api_defineProperty(this, "docId", `d${api_docId._ = (_PDFDocumentLoadingTa = api_docId._, _PDFDocumentLoadingTa2 = _PDFDocumentLoadingTa++, _PDFDocumentLoadingTa), _PDFDocumentLoadingTa2}`);
    api_defineProperty(this, "destroyed", false);
    api_defineProperty(this, "onPassword", null);
    api_defineProperty(this, "onProgress", null);
  }
  get promise() {
    return this._capability.promise;
  }
  async destroy() {
    this.destroyed = true;
    try {
      if (this._worker?.port) {
        this._worker._pendingDestroy = true;
      }
      await this._transport?.destroy();
    } catch (ex) {
      if (this._worker?.port) {
        delete this._worker._pendingDestroy;
      }
      throw ex;
    }
    this._transport = null;
    this._worker?.destroy();
    this._worker = null;
  }
  async getData() {
    return this._transport.getData();
  }
}
var api_docId = {
  _: 0
};
var api_capability = /*#__PURE__*/new WeakMap();
var _progressiveDoneListeners = /*#__PURE__*/new WeakMap();
var _progressiveReadListeners = /*#__PURE__*/new WeakMap();
var _progressListeners = /*#__PURE__*/new WeakMap();
var _rangeListeners = /*#__PURE__*/new WeakMap();
class PDFDataRangeTransport {
  constructor(length, initialData) {
    let progressiveDone = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
    let contentDispositionFilename = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : null;
    api_classPrivateFieldInitSpec(this, api_capability, Promise.withResolvers());
    api_classPrivateFieldInitSpec(this, _progressiveDoneListeners, []);
    api_classPrivateFieldInitSpec(this, _progressiveReadListeners, []);
    api_classPrivateFieldInitSpec(this, _progressListeners, []);
    api_classPrivateFieldInitSpec(this, _rangeListeners, []);
    this.length = length;
    this.initialData = initialData;
    this.progressiveDone = progressiveDone;
    this.contentDispositionFilename = contentDispositionFilename;
  }
  addRangeListener(listener) {
    api_classPrivateFieldGet(_rangeListeners, this).push(listener);
  }
  addProgressListener(listener) {
    api_classPrivateFieldGet(_progressListeners, this).push(listener);
  }
  addProgressiveReadListener(listener) {
    api_classPrivateFieldGet(_progressiveReadListeners, this).push(listener);
  }
  addProgressiveDoneListener(listener) {
    api_classPrivateFieldGet(_progressiveDoneListeners, this).push(listener);
  }
  onDataRange(begin, chunk) {
    for (const listener of api_classPrivateFieldGet(_rangeListeners, this)) {
      listener(begin, chunk);
    }
  }
  onDataProgress(loaded, total) {
    api_classPrivateFieldGet(api_capability, this).promise.then(() => {
      for (const listener of api_classPrivateFieldGet(_progressListeners, this)) {
        listener(loaded, total);
      }
    });
  }
  onDataProgressiveRead(chunk) {
    api_classPrivateFieldGet(api_capability, this).promise.then(() => {
      for (const listener of api_classPrivateFieldGet(_progressiveReadListeners, this)) {
        listener(chunk);
      }
    });
  }
  onDataProgressiveDone() {
    api_classPrivateFieldGet(api_capability, this).promise.then(() => {
      for (const listener of api_classPrivateFieldGet(_progressiveDoneListeners, this)) {
        listener();
      }
    });
  }
  transportReady() {
    api_classPrivateFieldGet(api_capability, this).resolve();
  }
  requestDataRange(begin, end) {
    unreachable("Abstract method PDFDataRangeTransport.requestDataRange");
  }
  abort() {}
}
class PDFDocumentProxy {
  constructor(pdfInfo, transport) {
    this._pdfInfo = pdfInfo;
    this._transport = transport;
  }
  get annotationStorage() {
    return this._transport.annotationStorage;
  }
  get canvasFactory() {
    return this._transport.canvasFactory;
  }
  get filterFactory() {
    return this._transport.filterFactory;
  }
  get numPages() {
    return this._pdfInfo.numPages;
  }
  get fingerprints() {
    return this._pdfInfo.fingerprints;
  }
  get isPureXfa() {
    return shadow(this, "isPureXfa", !!this._transport._htmlForXfa);
  }
  get allXfaHtml() {
    return this._transport._htmlForXfa;
  }
  getPage(pageNumber) {
    return this._transport.getPage(pageNumber);
  }
  getPageIndex(ref) {
    return this._transport.getPageIndex(ref);
  }
  getDestinations() {
    return this._transport.getDestinations();
  }
  getDestination(id) {
    return this._transport.getDestination(id);
  }
  getPageLabels() {
    return this._transport.getPageLabels();
  }
  getPageLayout() {
    return this._transport.getPageLayout();
  }
  getPageMode() {
    return this._transport.getPageMode();
  }
  getViewerPreferences() {
    return this._transport.getViewerPreferences();
  }
  getOpenAction() {
    return this._transport.getOpenAction();
  }
  getAttachments() {
    return this._transport.getAttachments();
  }
  getJSActions() {
    return this._transport.getDocJSActions();
  }
  getOutline() {
    return this._transport.getOutline();
  }
  getOptionalContentConfig() {
    let {
      intent = "display"
    } = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    const {
      renderingIntent
    } = this._transport.getRenderingIntent(intent);
    return this._transport.getOptionalContentConfig(renderingIntent);
  }
  getPermissions() {
    return this._transport.getPermissions();
  }
  getMetadata() {
    return this._transport.getMetadata();
  }
  getMarkInfo() {
    return this._transport.getMarkInfo();
  }
  getData() {
    return this._transport.getData();
  }
  saveDocument() {
    let pageOrder = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
    return this._transport.saveDocument(pageOrder);
  }
  getDownloadInfo() {
    return this._transport.downloadInfoCapability.promise;
  }
  cleanup() {
    let keepLoadedFonts = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
    return this._transport.startCleanup(keepLoadedFonts || this.isPureXfa);
  }
  destroy() {
    return this.loadingTask.destroy();
  }
  cachedPageNumber(ref) {
    return this._transport.cachedPageNumber(ref);
  }
  get loadingParams() {
    return this._transport.loadingParams;
  }
  get loadingTask() {
    return this._transport.loadingTask;
  }
  getFieldObjects() {
    return this._transport.getFieldObjects();
  }
  hasJSActions() {
    return this._transport.hasJSActions();
  }
  getCalculationOrderIds() {
    return this._transport.getCalculationOrderIds();
  }
}
var _pendingCleanup = /*#__PURE__*/new WeakMap();
var _PDFPageProxy_brand = /*#__PURE__*/new WeakSet();
class PDFPageProxy {
  constructor(pageIndex, pageInfo, transport) {
    let pdfBug = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : false;
    api_classPrivateMethodInitSpec(this, _PDFPageProxy_brand);
    api_classPrivateFieldInitSpec(this, _pendingCleanup, false);
    this._pageIndex = pageIndex;
    this._pageInfo = pageInfo;
    this._transport = transport;
    this._stats = pdfBug ? new StatTimer() : null;
    this._pdfBug = pdfBug;
    this.commonObjs = transport.commonObjs;
    this.objs = new PDFObjects();
    this._intentStates = new Map();
    this.destroyed = false;
  }
  get pageNumber() {
    return this._pageIndex + 1;
  }
  get rotate() {
    return this._pageInfo.rotate;
  }
  get ref() {
    return this._pageInfo.ref;
  }
  get userUnit() {
    return this._pageInfo.userUnit;
  }
  get view() {
    return this._pageInfo.view;
  }
  getViewport() {
    let {
      scale,
      rotation = this.rotate,
      offsetX = 0,
      offsetY = 0,
      dontFlip = false
    } = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    return new PageViewport({
      viewBox: this.view,
      userUnit: this.userUnit,
      scale,
      rotation,
      offsetX,
      offsetY,
      dontFlip
    });
  }
  getAnnotations() {
    let {
      intent = "display"
    } = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    const {
      renderingIntent
    } = this._transport.getRenderingIntent(intent);
    return this._transport.getAnnotations(this._pageIndex, renderingIntent);
  }
  getJSActions() {
    return this._transport.getPageJSActions(this._pageIndex);
  }
  get filterFactory() {
    return this._transport.filterFactory;
  }
  get isPureXfa() {
    return shadow(this, "isPureXfa", !!this._transport._htmlForXfa);
  }
  async getXfa() {
    return this._transport._htmlForXfa?.children[this._pageIndex] || null;
  }
  render(_ref) {
    let {
      canvasContext,
      viewport,
      intent = "display",
      annotationMode = AnnotationMode.ENABLE,
      transform = null,
      background = null,
      optionalContentConfigPromise = null,
      annotationCanvasMap = null,
      pageColors = null,
      printAnnotationStorage = null,
      isEditing = false
    } = _ref;
    this._stats?.time("Overall");
    const intentArgs = this._transport.getRenderingIntent(intent, annotationMode, printAnnotationStorage, isEditing);
    const {
      renderingIntent,
      cacheKey
    } = intentArgs;
    api_classPrivateFieldSet(_pendingCleanup, this, false);
    optionalContentConfigPromise ||= this._transport.getOptionalContentConfig(renderingIntent);
    let intentState = this._intentStates.get(cacheKey);
    if (!intentState) {
      intentState = Object.create(null);
      this._intentStates.set(cacheKey, intentState);
    }
    if (intentState.streamReaderCancelTimeout) {
      clearTimeout(intentState.streamReaderCancelTimeout);
      intentState.streamReaderCancelTimeout = null;
    }
    const intentPrint = !!(renderingIntent & RenderingIntentFlag.PRINT);
    if (!intentState.displayReadyCapability) {
      intentState.displayReadyCapability = Promise.withResolvers();
      intentState.operatorList = {
        fnArray: [],
        argsArray: [],
        lastChunk: false,
        separateAnnots: null
      };
      this._stats?.time("Page Request");
      this._pumpOperatorList(intentArgs);
    }
    const complete = error => {
      intentState.renderTasks.delete(internalRenderTask);
      if (intentPrint) {
        api_classPrivateFieldSet(_pendingCleanup, this, true);
      }
      api_assertClassBrand(_PDFPageProxy_brand, this, _tryCleanup).call(this);
      if (error) {
        internalRenderTask.capability.reject(error);
        this._abortOperatorList({
          intentState,
          reason: error instanceof Error ? error : new Error(error)
        });
      } else {
        internalRenderTask.capability.resolve();
      }
      if (this._stats) {
        this._stats.timeEnd("Rendering");
        this._stats.timeEnd("Overall");
        if (globalThis.Stats?.enabled) {
          globalThis.Stats.add(this.pageNumber, this._stats);
        }
      }
    };
    const internalRenderTask = new InternalRenderTask({
      callback: complete,
      params: {
        canvasContext,
        viewport,
        transform,
        background
      },
      objs: this.objs,
      commonObjs: this.commonObjs,
      annotationCanvasMap,
      operatorList: intentState.operatorList,
      pageIndex: this._pageIndex,
      canvasFactory: this._transport.canvasFactory,
      filterFactory: this._transport.filterFactory,
      useRequestAnimationFrame: !intentPrint,
      pdfBug: this._pdfBug,
      pageColors
    });
    (intentState.renderTasks ||= new Set()).add(internalRenderTask);
    const renderTask = internalRenderTask.task;
    Promise.all([intentState.displayReadyCapability.promise, optionalContentConfigPromise]).then(_ref2 => {
      let [transparency, optionalContentConfig] = _ref2;
      if (this.destroyed) {
        complete();
        return;
      }
      this._stats?.time("Rendering");
      if (!(optionalContentConfig.renderingIntent & renderingIntent)) {
        throw new Error("Must use the same `intent`-argument when calling the `PDFPageProxy.render` " + "and `PDFDocumentProxy.getOptionalContentConfig` methods.");
      }
      internalRenderTask.initializeGraphics({
        transparency,
        optionalContentConfig
      });
      internalRenderTask.operatorListChanged();
    }).catch(complete);
    return renderTask;
  }
  getOperatorList() {
    let {
      intent = "display",
      annotationMode = AnnotationMode.ENABLE,
      printAnnotationStorage = null,
      isEditing = false
    } = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    function operatorListChanged() {
      if (intentState.operatorList.lastChunk) {
        intentState.opListReadCapability.resolve(intentState.operatorList);
        intentState.renderTasks.delete(opListTask);
      }
    }
    const intentArgs = this._transport.getRenderingIntent(intent, annotationMode, printAnnotationStorage, isEditing, true);
    let intentState = this._intentStates.get(intentArgs.cacheKey);
    if (!intentState) {
      intentState = Object.create(null);
      this._intentStates.set(intentArgs.cacheKey, intentState);
    }
    let opListTask;
    if (!intentState.opListReadCapability) {
      opListTask = Object.create(null);
      opListTask.operatorListChanged = operatorListChanged;
      intentState.opListReadCapability = Promise.withResolvers();
      (intentState.renderTasks ||= new Set()).add(opListTask);
      intentState.operatorList = {
        fnArray: [],
        argsArray: [],
        lastChunk: false,
        separateAnnots: null
      };
      this._stats?.time("Page Request");
      this._pumpOperatorList(intentArgs);
    }
    return intentState.opListReadCapability.promise;
  }
  streamTextContent() {
    let {
      includeMarkedContent = false,
      disableNormalization = false
    } = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    const TEXT_CONTENT_CHUNK_SIZE = 100;
    return this._transport.messageHandler.sendWithStream("GetTextContent", {
      pageIndex: this._pageIndex,
      includeMarkedContent: includeMarkedContent === true,
      disableNormalization: disableNormalization === true
    }, {
      highWaterMark: TEXT_CONTENT_CHUNK_SIZE,
      size(textContent) {
        return textContent.items.length;
      }
    });
  }
  getTextContent() {
    let params = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    if (this._transport._htmlForXfa) {
      return this.getXfa().then(xfa => XfaText.textContent(xfa));
    }
    const readableStream = this.streamTextContent(params);
    return new Promise(function (resolve, reject) {
      function pump() {
        reader.read().then(function (_ref3) {
          let {
            value,
            done
          } = _ref3;
          if (done) {
            resolve(textContent);
            return;
          }
          textContent.lang ??= value.lang;
          Object.assign(textContent.styles, value.styles);
          textContent.items.push(...value.items);
          pump();
        }, reject);
      }
      const reader = readableStream.getReader();
      const textContent = {
        items: [],
        styles: Object.create(null),
        lang: null
      };
      pump();
    });
  }
  getStructTree() {
    return this._transport.getStructTree(this._pageIndex);
  }
  _destroy() {
    this.destroyed = true;
    const waitOn = [];
    for (const intentState of this._intentStates.values()) {
      this._abortOperatorList({
        intentState,
        reason: new Error("Page was destroyed."),
        force: true
      });
      if (intentState.opListReadCapability) {
        continue;
      }
      for (const internalRenderTask of intentState.renderTasks) {
        waitOn.push(internalRenderTask.completed);
        internalRenderTask.cancel();
      }
    }
    this.objs.clear();
    api_classPrivateFieldSet(_pendingCleanup, this, false);
    return Promise.all(waitOn);
  }
  cleanup() {
    let resetStats = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
    api_classPrivateFieldSet(_pendingCleanup, this, true);
    const success = api_assertClassBrand(_PDFPageProxy_brand, this, _tryCleanup).call(this);
    if (resetStats && success) {
      this._stats &&= new StatTimer();
    }
    return success;
  }
  _startRenderPage(transparency, cacheKey) {
    const intentState = this._intentStates.get(cacheKey);
    if (!intentState) {
      return;
    }
    this._stats?.timeEnd("Page Request");
    intentState.displayReadyCapability?.resolve(transparency);
  }
  _renderPageChunk(operatorListChunk, intentState) {
    for (let i = 0, ii = operatorListChunk.length; i < ii; i++) {
      intentState.operatorList.fnArray.push(operatorListChunk.fnArray[i]);
      intentState.operatorList.argsArray.push(operatorListChunk.argsArray[i]);
    }
    intentState.operatorList.lastChunk = operatorListChunk.lastChunk;
    intentState.operatorList.separateAnnots = operatorListChunk.separateAnnots;
    for (const internalRenderTask of intentState.renderTasks) {
      internalRenderTask.operatorListChanged();
    }
    if (operatorListChunk.lastChunk) {
      api_assertClassBrand(_PDFPageProxy_brand, this, _tryCleanup).call(this);
    }
  }
  _pumpOperatorList(_ref4) {
    let {
      renderingIntent,
      cacheKey,
      annotationStorageSerializable,
      modifiedIds
    } = _ref4;
    const {
      map,
      transfer
    } = annotationStorageSerializable;
    const readableStream = this._transport.messageHandler.sendWithStream("GetOperatorList", {
      pageIndex: this._pageIndex,
      intent: renderingIntent,
      cacheKey,
      annotationStorage: map,
      modifiedIds
    }, transfer);
    const reader = readableStream.getReader();
    const intentState = this._intentStates.get(cacheKey);
    intentState.streamReader = reader;
    const pump = () => {
      reader.read().then(_ref5 => {
        let {
          value,
          done
        } = _ref5;
        if (done) {
          intentState.streamReader = null;
          return;
        }
        if (this._transport.destroyed) {
          return;
        }
        this._renderPageChunk(value, intentState);
        pump();
      }, reason => {
        intentState.streamReader = null;
        if (this._transport.destroyed) {
          return;
        }
        if (intentState.operatorList) {
          intentState.operatorList.lastChunk = true;
          for (const internalRenderTask of intentState.renderTasks) {
            internalRenderTask.operatorListChanged();
          }
          api_assertClassBrand(_PDFPageProxy_brand, this, _tryCleanup).call(this);
        }
        if (intentState.displayReadyCapability) {
          intentState.displayReadyCapability.reject(reason);
        } else if (intentState.opListReadCapability) {
          intentState.opListReadCapability.reject(reason);
        } else {
          throw reason;
        }
      });
    };
    pump();
  }
  _abortOperatorList(_ref6) {
    let {
      intentState,
      reason,
      force = false
    } = _ref6;
    if (!intentState.streamReader) {
      return;
    }
    if (intentState.streamReaderCancelTimeout) {
      clearTimeout(intentState.streamReaderCancelTimeout);
      intentState.streamReaderCancelTimeout = null;
    }
    if (!force) {
      if (intentState.renderTasks.size > 0) {
        return;
      }
      if (reason instanceof RenderingCancelledException) {
        let delay = RENDERING_CANCELLED_TIMEOUT;
        if (reason.extraDelay > 0 && reason.extraDelay < 1000) {
          delay += reason.extraDelay;
        }
        intentState.streamReaderCancelTimeout = setTimeout(() => {
          intentState.streamReaderCancelTimeout = null;
          this._abortOperatorList({
            intentState,
            reason,
            force: true
          });
        }, delay);
        return;
      }
    }
    intentState.streamReader.cancel(new AbortException(reason.message)).catch(() => {});
    intentState.streamReader = null;
    if (this._transport.destroyed) {
      return;
    }
    for (const [curCacheKey, curIntentState] of this._intentStates) {
      if (curIntentState === intentState) {
        this._intentStates.delete(curCacheKey);
        break;
      }
    }
    this.cleanup();
  }
  get stats() {
    return this._stats;
  }
}
function _tryCleanup() {
  if (!api_classPrivateFieldGet(_pendingCleanup, this) || this.destroyed) {
    return false;
  }
  for (const {
    renderTasks,
    operatorList
  } of this._intentStates.values()) {
    if (renderTasks.size > 0 || !operatorList.lastChunk) {
      return false;
    }
  }
  this._intentStates.clear();
  this.objs.clear();
  api_classPrivateFieldSet(_pendingCleanup, this, false);
  return true;
}
var _capability2 = /*#__PURE__*/new WeakMap();
var _messageHandler = /*#__PURE__*/new WeakMap();
var api_port = /*#__PURE__*/new WeakMap();
var _webWorker = /*#__PURE__*/new WeakMap();
var _PDFWorker_brand = /*#__PURE__*/new WeakSet();
class PDFWorker {
  constructor() {
    let {
      name = null,
      port: _port2 = null,
      verbosity = getVerbosityLevel(),
      cspPolicyService
    } = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    api_classPrivateMethodInitSpec(this, _PDFWorker_brand);
    api_classPrivateFieldInitSpec(this, _capability2, Promise.withResolvers());
    api_classPrivateFieldInitSpec(this, _messageHandler, null);
    api_classPrivateFieldInitSpec(this, api_port, null);
    api_classPrivateFieldInitSpec(this, _webWorker, null);
    this.name = name;
    this.destroyed = false;
    this.verbosity = verbosity;
    if (_port2) {
      if (_workerPorts._.has(_port2)) {
        throw new Error("Cannot use more than one PDFWorker per port.");
      }
      _workerPorts._.set(_port2, this);
      api_assertClassBrand(_PDFWorker_brand, this, _initializeFromPort).call(this, _port2);
    } else {
      this._initialize(cspPolicyService);
    }
  }
  get promise() {
    return api_classPrivateFieldGet(_capability2, this).promise;
  }
  get port() {
    return api_classPrivateFieldGet(api_port, this);
  }
  get messageHandler() {
    return api_classPrivateFieldGet(_messageHandler, this);
  }
  _initialize(cspPolicyService) {
    if (_isWorkerDisabled._ || _get_mainThreadWorkerMessageHandler(PDFWorker)) {
      api_assertClassBrand(_PDFWorker_brand, this, _setupFakeWorker).call(this);
      return;
    }
    let {
      workerSrc
    } = PDFWorker;
    try {
      if (!PDFWorker._isSameOrigin(window.location, workerSrc)) {
        workerSrc = PDFWorker._createCDNWrapper(new URL(workerSrc, window.location).href);
      }
      const worker = new Worker(cspPolicyService.generateTrustedURL(workerSrc), {
        type: "module"
      });
      const messageHandler = new MessageHandler("main", "worker", worker);
      const terminateEarly = () => {
        ac.abort();
        messageHandler.destroy();
        worker.terminate();
        if (this.destroyed) {
          api_classPrivateFieldGet(_capability2, this).reject(new Error("Worker was destroyed"));
        } else {
          api_assertClassBrand(_PDFWorker_brand, this, _setupFakeWorker).call(this);
        }
      };
      const ac = new AbortController();
      worker.addEventListener("error", () => {
        if (!api_classPrivateFieldGet(_webWorker, this)) {
          terminateEarly();
        }
      }, {
        signal: ac.signal
      });
      messageHandler.on("test", data => {
        ac.abort();
        if (this.destroyed || !data) {
          terminateEarly();
          return;
        }
        api_classPrivateFieldSet(_messageHandler, this, messageHandler);
        api_classPrivateFieldSet(api_port, this, worker);
        api_classPrivateFieldSet(_webWorker, this, worker);
        api_assertClassBrand(_PDFWorker_brand, this, _resolve).call(this);
      });
      messageHandler.on("ready", data => {
        ac.abort();
        if (this.destroyed) {
          terminateEarly();
          return;
        }
        try {
          sendTest();
        } catch {
          api_assertClassBrand(_PDFWorker_brand, this, _setupFakeWorker).call(this);
        }
      });
      const sendTest = () => {
        const testObj = new Uint8Array();
        messageHandler.send("test", testObj, [testObj.buffer]);
      };
      sendTest();
      return;
    } catch {
      info("The worker has been disabled.");
    }
    api_assertClassBrand(_PDFWorker_brand, this, _setupFakeWorker).call(this);
  }
  destroy() {
    this.destroyed = true;
    api_classPrivateFieldGet(_webWorker, this)?.terminate();
    api_classPrivateFieldSet(_webWorker, this, null);
    _workerPorts._.delete(api_classPrivateFieldGet(api_port, this));
    api_classPrivateFieldSet(api_port, this, null);
    api_classPrivateFieldGet(_messageHandler, this)?.destroy();
    api_classPrivateFieldSet(_messageHandler, this, null);
  }
  static create(params) {
    const cachedPort = api_assertClassBrand(PDFWorker, this, _workerPorts)._.get(params?.port);
    if (cachedPort) {
      if (cachedPort._pendingDestroy) {
        throw new Error("PDFWorker.create - the worker is being destroyed.\n" + "Please remember to await `PDFDocumentLoadingTask.destroy()`-calls.");
      }
      return cachedPort;
    }
    return new PDFWorker(params);
  }
  static get workerSrc() {
    if (GlobalWorkerOptions.workerSrc) {
      return GlobalWorkerOptions.workerSrc;
    }
    throw new Error('No "GlobalWorkerOptions.workerSrc" specified.');
  }
  static get _setupFakeWorkerGlobal() {
    const loader = async () => {
      if (api_classPrivateGetter(PDFWorker, this, _get_mainThreadWorkerMessageHandler)) {
        return api_classPrivateGetter(PDFWorker, this, _get_mainThreadWorkerMessageHandler);
      }
      const worker = await import(
      /*webpackIgnore: true*/
      /*@vite-ignore*/
      this.workerSrc);
      return worker.WorkerMessageHandler;
    };
    return shadow(this, "_setupFakeWorkerGlobal", loader());
  }
}
_PDFWorker = PDFWorker;
function _resolve() {
  api_classPrivateFieldGet(_capability2, this).resolve();
  api_classPrivateFieldGet(_messageHandler, this).send("configure", {
    verbosity: this.verbosity
  });
}
function _initializeFromPort(port) {
  api_classPrivateFieldSet(api_port, this, port);
  api_classPrivateFieldSet(_messageHandler, this, new MessageHandler("main", "worker", port));
  api_classPrivateFieldGet(_messageHandler, this).on("ready", () => {});
  api_assertClassBrand(_PDFWorker_brand, this, _resolve).call(this);
}
function _setupFakeWorker() {
  if (!_isWorkerDisabled._) {
    warn("Setting up fake worker.");
    _isWorkerDisabled._ = true;
  }
  _PDFWorker._setupFakeWorkerGlobal.then(WorkerMessageHandler => {
    var _PDFWorker$fakeWorker, _PDFWorker$fakeWorker2;
    if (this.destroyed) {
      api_classPrivateFieldGet(_capability2, this).reject(new Error("Worker was destroyed"));
      return;
    }
    const port = new LoopbackPort();
    api_classPrivateFieldSet(api_port, this, port);
    const id = `fake${_fakeWorkerId._ = (_PDFWorker$fakeWorker = _fakeWorkerId._, _PDFWorker$fakeWorker2 = _PDFWorker$fakeWorker++, _PDFWorker$fakeWorker), _PDFWorker$fakeWorker2}`;
    const workerHandler = new MessageHandler(id + "_worker", id, port);
    WorkerMessageHandler.setup(workerHandler, port);
    api_classPrivateFieldSet(_messageHandler, this, new MessageHandler(id, id + "_worker", port));
    api_assertClassBrand(_PDFWorker_brand, this, _resolve).call(this);
  }).catch(reason => {
    api_classPrivateFieldGet(_capability2, this).reject(new Error(`Setting up fake worker failed: "${reason.message}".`));
  });
}
function _get_mainThreadWorkerMessageHandler(_this) {
  try {
    return globalThis.pdfjsWorker?.WorkerMessageHandler || null;
  } catch {
    return null;
  }
}
var _fakeWorkerId = {
  _: 0
};
var _isWorkerDisabled = {
  _: false
};
var _workerPorts = {
  _: new WeakMap()
};
(() => {
  if (isNodeJS) {
    _isWorkerDisabled._ = api_assertClassBrand(_PDFWorker, _PDFWorker, true);
    GlobalWorkerOptions.workerSrc ||= "./pdf.worker.mjs";
  }
  _PDFWorker._isSameOrigin = (baseUrl, otherUrl) => {
    const base = URL.parse(baseUrl);
    if (!base?.origin || base.origin === "null") {
      return false;
    }
    const other = new URL(otherUrl, base);
    return base.origin === other.origin;
  };
  _PDFWorker._createCDNWrapper = url => {
    const wrapper = `await import("${url}");`;
    return URL.createObjectURL(new Blob([wrapper], {
      type: "text/javascript"
    }));
  };
  _PDFWorker.fromPort = params => {
    deprecated("`PDFWorker.fromPort` - please use `PDFWorker.create` instead.");
    if (!params?.port) {
      throw new Error("PDFWorker.fromPort - invalid method signature.");
    }
    return _PDFWorker.create(params);
  };
})();
var _methodPromises = /*#__PURE__*/new WeakMap();
var _pageCache = /*#__PURE__*/new WeakMap();
var _pagePromises = /*#__PURE__*/new WeakMap();
var _pageRefCache = /*#__PURE__*/new WeakMap();
var _passwordCapability = /*#__PURE__*/new WeakMap();
var _WorkerTransport_brand = /*#__PURE__*/new WeakSet();
class WorkerTransport {
  constructor(messageHandler, loadingTask, networkStream, params, factory) {
    api_classPrivateMethodInitSpec(this, _WorkerTransport_brand);
    api_classPrivateFieldInitSpec(this, _methodPromises, new Map());
    api_classPrivateFieldInitSpec(this, _pageCache, new Map());
    api_classPrivateFieldInitSpec(this, _pagePromises, new Map());
    api_classPrivateFieldInitSpec(this, _pageRefCache, new Map());
    api_classPrivateFieldInitSpec(this, _passwordCapability, null);
    this.messageHandler = messageHandler;
    this.loadingTask = loadingTask;
    this.commonObjs = new PDFObjects();
    this.fontLoader = new FontLoader({
      ownerDocument: params.ownerDocument,
      styleElement: params.styleElement
    });
    this.loadingParams = params.loadingParams;
    this._params = params;
    this.canvasFactory = factory.canvasFactory;
    this.filterFactory = factory.filterFactory;
    this.cMapReaderFactory = factory.cMapReaderFactory;
    this.standardFontDataFactory = factory.standardFontDataFactory;
    this.wasmFactory = factory.wasmFactory;
    this.destroyed = false;
    this.destroyCapability = null;
    this._networkStream = networkStream;
    this._fullReader = null;
    this._lastProgress = null;
    this.downloadInfoCapability = Promise.withResolvers();
    this.setupMessageHandler();
  }
  get annotationStorage() {
    return shadow(this, "annotationStorage", new AnnotationStorage());
  }
  getRenderingIntent(intent) {
    let annotationMode = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : AnnotationMode.ENABLE;
    let printAnnotationStorage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
    let isEditing = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : false;
    let isOpList = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : false;
    let renderingIntent = RenderingIntentFlag.DISPLAY;
    let annotationStorageSerializable = SerializableEmpty;
    switch (intent) {
      case "any":
        renderingIntent = RenderingIntentFlag.ANY;
        break;
      case "display":
        break;
      case "print":
        renderingIntent = RenderingIntentFlag.PRINT;
        break;
      default:
        warn(`getRenderingIntent - invalid intent: ${intent}`);
    }
    const annotationStorage = renderingIntent & RenderingIntentFlag.PRINT && printAnnotationStorage instanceof PrintAnnotationStorage ? printAnnotationStorage : this.annotationStorage;
    switch (annotationMode) {
      case AnnotationMode.DISABLE:
        renderingIntent += RenderingIntentFlag.ANNOTATIONS_DISABLE;
        break;
      case AnnotationMode.ENABLE:
        break;
      case AnnotationMode.ENABLE_FORMS:
        renderingIntent += RenderingIntentFlag.ANNOTATIONS_FORMS;
        break;
      case AnnotationMode.ENABLE_STORAGE:
        renderingIntent += RenderingIntentFlag.ANNOTATIONS_STORAGE;
        annotationStorageSerializable = annotationStorage.serializable;
        break;
      default:
        warn(`getRenderingIntent - invalid annotationMode: ${annotationMode}`);
    }
    if (isEditing) {
      renderingIntent += RenderingIntentFlag.IS_EDITING;
    }
    if (isOpList) {
      renderingIntent += RenderingIntentFlag.OPLIST;
    }
    const {
      ids: modifiedIds,
      hash: modifiedIdsHash
    } = annotationStorage.modifiedIds;
    const cacheKeyBuf = [renderingIntent, annotationStorageSerializable.hash, modifiedIdsHash];
    return {
      renderingIntent,
      cacheKey: cacheKeyBuf.join("_"),
      annotationStorageSerializable,
      modifiedIds
    };
  }
  destroy() {
    if (this.destroyCapability) {
      return this.destroyCapability.promise;
    }
    this.destroyed = true;
    this.destroyCapability = Promise.withResolvers();
    api_classPrivateFieldGet(_passwordCapability, this)?.reject(new Error("Worker was destroyed during onPassword callback"));
    const waitOn = [];
    for (const page of api_classPrivateFieldGet(_pageCache, this).values()) {
      waitOn.push(page._destroy());
    }
    api_classPrivateFieldGet(_pageCache, this).clear();
    api_classPrivateFieldGet(_pagePromises, this).clear();
    api_classPrivateFieldGet(_pageRefCache, this).clear();
    if (this.hasOwnProperty("annotationStorage")) {
      this.annotationStorage.resetModified();
    }
    const terminated = this.messageHandler.sendWithPromise("Terminate", null);
    waitOn.push(terminated);
    Promise.all(waitOn).then(() => {
      this.commonObjs.clear();
      this.fontLoader.clear();
      api_classPrivateFieldGet(_methodPromises, this).clear();
      this.filterFactory.destroy();
      TextLayer.cleanup();
      this._networkStream?.cancelAllRequests(new AbortException("Worker was terminated."));
      this.messageHandler?.destroy();
      this.messageHandler = null;
      this.destroyCapability.resolve();
    }, this.destroyCapability.reject);
    return this.destroyCapability.promise;
  }
  setupMessageHandler() {
    const {
      messageHandler,
      loadingTask
    } = this;
    messageHandler.on("GetReader", (data, sink) => {
      assert(this._networkStream, "GetReader - no `IPDFStream` instance available.");
      this._fullReader = this._networkStream.getFullReader();
      this._fullReader.onProgress = evt => {
        this._lastProgress = {
          loaded: evt.loaded,
          total: evt.total
        };
      };
      sink.onPull = () => {
        this._fullReader.read().then(function (_ref7) {
          let {
            value,
            done
          } = _ref7;
          if (done) {
            sink.close();
            return;
          }
          assert(value instanceof ArrayBuffer, "GetReader - expected an ArrayBuffer.");
          sink.enqueue(new Uint8Array(value), 1, [value]);
        }).catch(reason => {
          sink.error(reason);
        });
      };
      sink.onCancel = reason => {
        this._fullReader.cancel(reason);
        sink.ready.catch(readyReason => {
          if (this.destroyed) {
            return;
          }
          throw readyReason;
        });
      };
    });
    messageHandler.on("ReaderHeadersReady", async data => {
      await this._fullReader.headersReady;
      const {
        isStreamingSupported,
        isRangeSupported,
        contentLength
      } = this._fullReader;
      if (!isStreamingSupported || !isRangeSupported) {
        if (this._lastProgress) {
          loadingTask.onProgress?.(this._lastProgress);
        }
        this._fullReader.onProgress = evt => {
          loadingTask.onProgress?.({
            loaded: evt.loaded,
            total: evt.total
          });
        };
      }
      return {
        isStreamingSupported,
        isRangeSupported,
        contentLength
      };
    });
    messageHandler.on("GetRangeReader", (data, sink) => {
      assert(this._networkStream, "GetRangeReader - no `IPDFStream` instance available.");
      const rangeReader = this._networkStream.getRangeReader(data.begin, data.end);
      if (!rangeReader) {
        sink.close();
        return;
      }
      sink.onPull = () => {
        rangeReader.read().then(function (_ref8) {
          let {
            value,
            done
          } = _ref8;
          if (done) {
            sink.close();
            return;
          }
          assert(value instanceof ArrayBuffer, "GetRangeReader - expected an ArrayBuffer.");
          sink.enqueue(new Uint8Array(value), 1, [value]);
        }).catch(reason => {
          sink.error(reason);
        });
      };
      sink.onCancel = reason => {
        rangeReader.cancel(reason);
        sink.ready.catch(readyReason => {
          if (this.destroyed) {
            return;
          }
          throw readyReason;
        });
      };
    });
    messageHandler.on("GetDoc", _ref9 => {
      let {
        pdfInfo
      } = _ref9;
      this._numPages = pdfInfo.numPages;
      this._htmlForXfa = pdfInfo.htmlForXfa;
      delete pdfInfo.htmlForXfa;
      loadingTask._capability.resolve(new PDFDocumentProxy(pdfInfo, this));
    });
    messageHandler.on("DocException", ex => {
      loadingTask._capability.reject(wrapReason(ex));
    });
    messageHandler.on("PasswordRequest", ex => {
      api_classPrivateFieldSet(_passwordCapability, this, Promise.withResolvers());
      try {
        if (!loadingTask.onPassword) {
          throw wrapReason(ex);
        }
        const updatePassword = password => {
          if (password instanceof Error) {
            api_classPrivateFieldGet(_passwordCapability, this).reject(password);
          } else {
            api_classPrivateFieldGet(_passwordCapability, this).resolve({
              password
            });
          }
        };
        loadingTask.onPassword(updatePassword, ex.code);
      } catch (err) {
        api_classPrivateFieldGet(_passwordCapability, this).reject(err);
      }
      return api_classPrivateFieldGet(_passwordCapability, this).promise;
    });
    messageHandler.on("DataLoaded", data => {
      loadingTask.onProgress?.({
        loaded: data.length,
        total: data.length
      });
      this.downloadInfoCapability.resolve(data);
    });
    messageHandler.on("StartRenderPage", data => {
      if (this.destroyed) {
        return;
      }
      const page = api_classPrivateFieldGet(_pageCache, this).get(data.pageIndex);
      page._startRenderPage(data.transparency, data.cacheKey);
    });
    messageHandler.on("commonobj", _ref0 => {
      let [id, type, exportedData] = _ref0;
      if (this.destroyed) {
        return null;
      }
      if (this.commonObjs.has(id)) {
        return null;
      }
      switch (type) {
        case "Font":
          if ("error" in exportedData) {
            const exportedError = exportedData.error;
            warn(`Error during font loading: ${exportedError}`);
            this.commonObjs.resolve(id, exportedError);
            break;
          }
          const inspectFont = this._params.pdfBug && globalThis.FontInspector?.enabled ? (font, url) => globalThis.FontInspector.fontAdded(font, url) : null;
          const font = new FontFaceObject(exportedData, inspectFont);
          this.fontLoader.bind(font).catch(() => messageHandler.sendWithPromise("FontFallback", {
            id
          })).finally(() => {
            if (!font.fontExtraProperties && font.data) {
              font.data = null;
            }
            this.commonObjs.resolve(id, font);
          });
          break;
        case "CopyLocalImage":
          const {
            imageRef
          } = exportedData;
          assert(imageRef, "The imageRef must be defined.");
          for (const pageProxy of api_classPrivateFieldGet(_pageCache, this).values()) {
            for (const [, data] of pageProxy.objs) {
              if (data?.ref !== imageRef) {
                continue;
              }
              if (!data.dataLen) {
                return null;
              }
              this.commonObjs.resolve(id, structuredClone(data));
              return data.dataLen;
            }
          }
          break;
        case "FontPath":
        case "Image":
        case "Pattern":
          this.commonObjs.resolve(id, exportedData);
          break;
        default:
          throw new Error(`Got unknown common object type ${type}`);
      }
      return null;
    });
    messageHandler.on("obj", _ref1 => {
      let [id, pageIndex, type, imageData] = _ref1;
      if (this.destroyed) {
        return;
      }
      const pageProxy = api_classPrivateFieldGet(_pageCache, this).get(pageIndex);
      if (pageProxy.objs.has(id)) {
        return;
      }
      if (pageProxy._intentStates.size === 0) {
        imageData?.bitmap?.close();
        return;
      }
      switch (type) {
        case "Image":
        case "Pattern":
          pageProxy.objs.resolve(id, imageData);
          break;
        default:
          throw new Error(`Got unknown object type ${type}`);
      }
    });
    messageHandler.on("DocProgress", data => {
      if (this.destroyed) {
        return;
      }
      loadingTask.onProgress?.({
        loaded: data.loaded,
        total: data.total
      });
    });
    messageHandler.on("FetchBinaryData", async data => {
      if (this.destroyed) {
        throw new Error("Worker was destroyed.");
      }
      const factory = this[data.type];
      if (!factory) {
        throw new Error(`${data.type} not initialized, see the \`useWorkerFetch\` parameter.`);
      }
      return factory.fetch(data);
    });
  }
  getData() {
    return this.messageHandler.sendWithPromise("GetData", null);
  }
  saveDocument() {
    let pageOrder = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
    if (this.annotationStorage.size <= 0) {
      warn("saveDocument called while `annotationStorage` is empty, " + "please use the getData-method instead.");
    }
    const {
      map,
      transfer
    } = this.annotationStorage.serializable;
    return this.messageHandler.sendWithPromise("SaveDocument", {
      isPureXfa: !!this._htmlForXfa,
      numPages: this._numPages,
      annotationStorage: map,
      filename: this._fullReader?.filename ?? null,
      pageOrder: pageOrder
    }, transfer).finally(() => {
      this.annotationStorage.resetModified();
    });
  }
  getPage(pageNumber) {
    if (!Number.isInteger(pageNumber) || pageNumber <= 0 || pageNumber > this._numPages) {
      return Promise.reject(new Error("Invalid page request."));
    }
    const pageIndex = pageNumber - 1,
      cachedPromise = api_classPrivateFieldGet(_pagePromises, this).get(pageIndex);
    if (cachedPromise) {
      return cachedPromise;
    }
    const promise = this.messageHandler.sendWithPromise("GetPage", {
      pageIndex
    }).then(pageInfo => {
      if (this.destroyed) {
        throw new Error("Transport destroyed");
      }
      if (pageInfo.refStr) {
        api_classPrivateFieldGet(_pageRefCache, this).set(pageInfo.refStr, pageNumber);
      }
      const page = new PDFPageProxy(pageIndex, pageInfo, this, this._params.pdfBug);
      api_classPrivateFieldGet(_pageCache, this).set(pageIndex, page);
      return page;
    });
    api_classPrivateFieldGet(_pagePromises, this).set(pageIndex, promise);
    return promise;
  }
  getPageIndex(ref) {
    if (!isRefProxy(ref)) {
      return Promise.reject(new Error("Invalid pageIndex request."));
    }
    return this.messageHandler.sendWithPromise("GetPageIndex", {
      num: ref.num,
      gen: ref.gen
    });
  }
  getAnnotations(pageIndex, intent) {
    return this.messageHandler.sendWithPromise("GetAnnotations", {
      pageIndex,
      intent
    });
  }
  getFieldObjects() {
    return api_assertClassBrand(_WorkerTransport_brand, this, _cacheSimpleMethod).call(this, "GetFieldObjects");
  }
  hasJSActions() {
    return api_assertClassBrand(_WorkerTransport_brand, this, _cacheSimpleMethod).call(this, "HasJSActions");
  }
  getCalculationOrderIds() {
    return this.messageHandler.sendWithPromise("GetCalculationOrderIds", null);
  }
  getDestinations() {
    return this.messageHandler.sendWithPromise("GetDestinations", null);
  }
  getDestination(id) {
    if (typeof id !== "string") {
      return Promise.reject(new Error("Invalid destination request."));
    }
    return this.messageHandler.sendWithPromise("GetDestination", {
      id
    });
  }
  getPageLabels() {
    return this.messageHandler.sendWithPromise("GetPageLabels", null);
  }
  getPageLayout() {
    return this.messageHandler.sendWithPromise("GetPageLayout", null);
  }
  getPageMode() {
    return this.messageHandler.sendWithPromise("GetPageMode", null);
  }
  getViewerPreferences() {
    return this.messageHandler.sendWithPromise("GetViewerPreferences", null);
  }
  getOpenAction() {
    return this.messageHandler.sendWithPromise("GetOpenAction", null);
  }
  getAttachments() {
    return this.messageHandler.sendWithPromise("GetAttachments", null);
  }
  getDocJSActions() {
    return api_assertClassBrand(_WorkerTransport_brand, this, _cacheSimpleMethod).call(this, "GetDocJSActions");
  }
  getPageJSActions(pageIndex) {
    return this.messageHandler.sendWithPromise("GetPageJSActions", {
      pageIndex
    });
  }
  getStructTree(pageIndex) {
    return this.messageHandler.sendWithPromise("GetStructTree", {
      pageIndex
    });
  }
  getOutline() {
    return this.messageHandler.sendWithPromise("GetOutline", null);
  }
  getOptionalContentConfig(renderingIntent) {
    return api_assertClassBrand(_WorkerTransport_brand, this, _cacheSimpleMethod).call(this, "GetOptionalContentConfig").then(data => new OptionalContentConfig(data, renderingIntent));
  }
  getPermissions() {
    return this.messageHandler.sendWithPromise("GetPermissions", null);
  }
  getMetadata() {
    const name = "GetMetadata",
      cachedPromise = api_classPrivateFieldGet(_methodPromises, this).get(name);
    if (cachedPromise) {
      return cachedPromise;
    }
    const promise = this.messageHandler.sendWithPromise(name, null).then(results => ({
      info: results[0],
      metadata: results[1] ? new Metadata(results[1]) : null,
      contentDispositionFilename: this._fullReader?.filename ?? null,
      contentLength: this._fullReader?.contentLength ?? null
    }));
    api_classPrivateFieldGet(_methodPromises, this).set(name, promise);
    return promise;
  }
  getMarkInfo() {
    return this.messageHandler.sendWithPromise("GetMarkInfo", null);
  }
  async startCleanup() {
    let keepLoadedFonts = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
    if (this.destroyed) {
      return;
    }
    await this.messageHandler.sendWithPromise("Cleanup", null);
    for (const page of api_classPrivateFieldGet(_pageCache, this).values()) {
      const cleanupSuccessful = page.cleanup();
      if (!cleanupSuccessful) {
        throw new Error(`startCleanup: Page ${page.pageNumber} is currently rendering.`);
      }
    }
    this.commonObjs.clear();
    if (!keepLoadedFonts) {
      this.fontLoader.clear();
    }
    api_classPrivateFieldGet(_methodPromises, this).clear();
    this.filterFactory.destroy(true);
    TextLayer.cleanup();
  }
  cachedPageNumber(ref) {
    if (!isRefProxy(ref)) {
      return null;
    }
    const refStr = ref.gen === 0 ? `${ref.num}R` : `${ref.num}R${ref.gen}`;
    return api_classPrivateFieldGet(_pageRefCache, this).get(refStr) ?? null;
  }
}
function _cacheSimpleMethod(name) {
  let data = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
  const cachedPromise = api_classPrivateFieldGet(_methodPromises, this).get(name);
  if (cachedPromise) {
    return cachedPromise;
  }
  const promise = this.messageHandler.sendWithPromise(name, data);
  api_classPrivateFieldGet(_methodPromises, this).set(name, promise);
  return promise;
}
var _internalRenderTask = /*#__PURE__*/new WeakMap();
class RenderTask {
  constructor(internalRenderTask) {
    api_classPrivateFieldInitSpec(this, _internalRenderTask, null);
    api_defineProperty(this, "onContinue", null);
    api_defineProperty(this, "onError", null);
    api_classPrivateFieldSet(_internalRenderTask, this, internalRenderTask);
  }
  get promise() {
    return api_classPrivateFieldGet(_internalRenderTask, this).capability.promise;
  }
  cancel() {
    let extraDelay = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 0;
    api_classPrivateFieldGet(_internalRenderTask, this).cancel(null, extraDelay);
  }
  get separateAnnots() {
    const {
      separateAnnots
    } = api_classPrivateFieldGet(_internalRenderTask, this).operatorList;
    if (!separateAnnots) {
      return false;
    }
    const {
      annotationCanvasMap
    } = api_classPrivateFieldGet(_internalRenderTask, this);
    return separateAnnots.form || separateAnnots.canvas && annotationCanvasMap?.size > 0;
  }
}
var _rAF = /*#__PURE__*/new WeakMap();
class InternalRenderTask {
  constructor(_ref10) {
    let {
      callback,
      params,
      objs,
      commonObjs,
      annotationCanvasMap,
      operatorList,
      pageIndex,
      canvasFactory,
      filterFactory,
      useRequestAnimationFrame = false,
      pdfBug = false,
      pageColors = null
    } = _ref10;
    api_classPrivateFieldInitSpec(this, _rAF, null);
    this.callback = callback;
    this.params = params;
    this.objs = objs;
    this.commonObjs = commonObjs;
    this.annotationCanvasMap = annotationCanvasMap;
    this.operatorListIdx = null;
    this.operatorList = operatorList;
    this._pageIndex = pageIndex;
    this.canvasFactory = canvasFactory;
    this.filterFactory = filterFactory;
    this._pdfBug = pdfBug;
    this.pageColors = pageColors;
    this.running = false;
    this.graphicsReadyCallback = null;
    this.graphicsReady = false;
    this._useRequestAnimationFrame = useRequestAnimationFrame === true && typeof window !== "undefined";
    this.cancelled = false;
    this.capability = Promise.withResolvers();
    this.task = new RenderTask(this);
    this._cancelBound = this.cancel.bind(this);
    this._continueBound = this._continue.bind(this);
    this._scheduleNextBound = this._scheduleNext.bind(this);
    this._nextBound = this._next.bind(this);
    this._canvas = params.canvasContext.canvas;
  }
  get completed() {
    return this.capability.promise.catch(function () {});
  }
  initializeGraphics(_ref11) {
    let {
      transparency = false,
      optionalContentConfig
    } = _ref11;
    if (this.cancelled) {
      return;
    }
    if (this._canvas) {
      if (_canvasInUse._.has(this._canvas)) {
        throw new Error("Cannot use the same canvas during multiple render() operations. " + "Use different canvas or ensure previous operations were " + "cancelled or completed.");
      }
      _canvasInUse._.add(this._canvas);
    }
    if (this._pdfBug && globalThis.StepperManager?.enabled) {
      this.stepper = globalThis.StepperManager.create(this._pageIndex);
      this.stepper.init(this.operatorList);
      this.stepper.nextBreakPoint = this.stepper.getNextBreakPoint();
    }
    const {
      canvasContext,
      viewport,
      transform,
      background
    } = this.params;
    this.gfx = new CanvasGraphics(canvasContext, this.commonObjs, this.objs, this.canvasFactory, this.filterFactory, {
      optionalContentConfig
    }, this.annotationCanvasMap, this.pageColors);
    this.gfx.beginDrawing({
      transform,
      viewport,
      transparency,
      background
    });
    this.operatorListIdx = 0;
    this.graphicsReady = true;
    this.graphicsReadyCallback?.();
  }
  cancel() {
    let error = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
    let extraDelay = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
    this.running = false;
    this.cancelled = true;
    this.gfx?.endDrawing();
    if (api_classPrivateFieldGet(_rAF, this)) {
      window.cancelAnimationFrame(api_classPrivateFieldGet(_rAF, this));
      api_classPrivateFieldSet(_rAF, this, null);
    }
    _canvasInUse._.delete(this._canvas);
    error ||= new RenderingCancelledException(`Rendering cancelled, page ${this._pageIndex + 1}`, extraDelay);
    this.callback(error);
    this.task.onError?.(error);
  }
  operatorListChanged() {
    if (!this.graphicsReady) {
      this.graphicsReadyCallback ||= this._continueBound;
      return;
    }
    this.stepper?.updateOperatorList(this.operatorList);
    if (this.running) {
      return;
    }
    this._continue();
  }
  _continue() {
    this.running = true;
    if (this.cancelled) {
      return;
    }
    if (this.task.onContinue) {
      this.task.onContinue(this._scheduleNextBound);
    } else {
      this._scheduleNext();
    }
  }
  _scheduleNext() {
    if (this._useRequestAnimationFrame) {
      api_classPrivateFieldSet(_rAF, this, window.requestAnimationFrame(() => {
        api_classPrivateFieldSet(_rAF, this, null);
        this._nextBound().catch(this._cancelBound);
      }));
    } else {
      Promise.resolve().then(this._nextBound).catch(this._cancelBound);
    }
  }
  async _next() {
    if (this.cancelled) {
      return;
    }
    this.operatorListIdx = this.gfx.executeOperatorList(this.operatorList, this.operatorListIdx, this._continueBound, this.stepper);
    if (this.operatorListIdx === this.operatorList.argsArray.length) {
      this.running = false;
      if (this.operatorList.lastChunk) {
        this.gfx.endDrawing();
        _canvasInUse._.delete(this._canvas);
        this.callback();
      }
    }
  }
}
var _canvasInUse = {
  _: new WeakSet()
};
const version = "5.3.754";
const build = "b9bd95d13";

// EXTERNAL MODULE: ./node_modules/core-js/modules/es.iterator.flat-map.js
var es_iterator_flat_map = __webpack_require__(531);
;// ./src/shared/scripting_utils.js


function makeColorComp(n) {
  return Math.floor(Math.max(0, Math.min(1, n)) * 255).toString(16).padStart(2, "0");
}
function scaleAndClamp(x) {
  return Math.max(0, Math.min(255, 255 * x));
}
class ColorConverters {
  static CMYK_G(_ref) {
    let [c, y, m, k] = _ref;
    return ["G", 1 - Math.min(1, 0.3 * c + 0.59 * m + 0.11 * y + k)];
  }
  static G_CMYK(_ref2) {
    let [g] = _ref2;
    return ["CMYK", 0, 0, 0, 1 - g];
  }
  static G_RGB(_ref3) {
    let [g] = _ref3;
    return ["RGB", g, g, g];
  }
  static G_rgb(_ref4) {
    let [g] = _ref4;
    g = scaleAndClamp(g);
    return [g, g, g];
  }
  static G_HTML(_ref5) {
    let [g] = _ref5;
    const G = makeColorComp(g);
    return `#${G}${G}${G}`;
  }
  static RGB_G(_ref6) {
    let [r, g, b] = _ref6;
    return ["G", 0.3 * r + 0.59 * g + 0.11 * b];
  }
  static RGB_rgb(color) {
    return color.map(scaleAndClamp);
  }
  static RGB_HTML(color) {
    return `#${color.map(makeColorComp).join("")}`;
  }
  static T_HTML() {
    return "#00000000";
  }
  static T_rgb() {
    return [null];
  }
  static CMYK_RGB(_ref7) {
    let [c, y, m, k] = _ref7;
    return ["RGB", 1 - Math.min(1, c + k), 1 - Math.min(1, m + k), 1 - Math.min(1, y + k)];
  }
  static CMYK_rgb(_ref8) {
    let [c, y, m, k] = _ref8;
    return [scaleAndClamp(1 - Math.min(1, c + k)), scaleAndClamp(1 - Math.min(1, m + k)), scaleAndClamp(1 - Math.min(1, y + k))];
  }
  static CMYK_HTML(components) {
    const rgb = this.CMYK_RGB(components).slice(1);
    return this.RGB_HTML(rgb);
  }
  static RGB_CMYK(_ref9) {
    let [r, g, b] = _ref9;
    const c = 1 - r;
    const m = 1 - g;
    const y = 1 - b;
    const k = Math.min(c, m, y);
    return ["CMYK", c, m, y, k];
  }
}

;// ./src/display/svg_factory.js



class BaseSVGFactory {
  create(width, height) {
    let skipDimensions = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
    if (width <= 0 || height <= 0) {
      throw new Error("Invalid SVG dimensions");
    }
    const svg = this._createSVG("svg:svg");
    svg.setAttribute("version", "1.1");
    if (!skipDimensions) {
      svg.setAttribute("width", `${width}px`);
      svg.setAttribute("height", `${height}px`);
    }
    svg.setAttribute("preserveAspectRatio", "none");
    svg.setAttribute("viewBox", `0 0 ${width} ${height}`);
    return svg;
  }
  createElement(type) {
    if (typeof type !== "string") {
      throw new Error("Invalid SVG element type");
    }
    return this._createSVG(type);
  }
  _createSVG(type) {
    unreachable("Abstract method `_createSVG` called.");
  }
}
class DOMSVGFactory extends BaseSVGFactory {
  _createSVG(type) {
    return document.createElementNS(SVG_NS, type);
  }
}

;// ./src/display/xfa_layer.js



class XfaLayer {
  static setupStorage(html, id, element, storage, intent) {
    const angularData = window.getFormValueFromAngular(html);
    if (angularData.value) {
      storage.setValue(id, angularData);
    }
    const initialValue = storage.getValue(id, {
      value: null
    });
    const storedData = angularData.value ? angularData : initialValue;
    window.registerXFAField(html, storedData, initialValue);
    html.addEventListener("updateFromAngular", value => storage.setValue(id, {
      value: value.detail
    }));
    switch (element.name) {
      case "textarea":
        if (storedData.value !== null) {
          html.textContent = storedData.value;
        }
        if (intent === "print") {
          break;
        }
        html.addEventListener("input", event => {
          window.updateAngularFormValue(html, {
            value: event.target.value
          });
          storage.setValue(id, {
            value: event.target.value
          });
        });
        break;
      case "input":
        if (element.attributes.type === "radio" || element.attributes.type === "checkbox") {
          if (storedData.value === element.attributes.xfaOn) {
            html.setAttribute("checked", true);
          } else {
            html.removeAttribute("checked");
          }
          if (intent === "print") {
            break;
          }
          html.addEventListener("change", event => {
            window.updateAngularFormValue(html, {
              value: event.target.checked ? event.target.getAttribute("xfaOn") : event.target.getAttribute("xfaOff")
            });
            storage.setValue(id, {
              value: event.target.checked ? event.target.getAttribute("xfaOn") : event.target.getAttribute("xfaOff")
            });
          });
        } else {
          if (storedData.value !== null) {
            html.setAttribute("value", storedData.value);
          }
          if (intent === "print") {
            break;
          }
          html.addEventListener("input", event => {
            window.updateAngularFormValue(html, {
              value: event.target.value
            });
            storage.setValue(id, {
              value: event.target.value
            });
          });
        }
        break;
      case "select":
        if (storedData.value !== null) {
          html.setAttribute("value", storedData.value);
          for (const option of element.children) {
            if (option.attributes.value === storedData.value) {
              option.attributes.selected = true;
            } else if (option.attributes.hasOwnProperty("selected")) {
              delete option.attributes.selected;
            }
          }
        }
        html.addEventListener("input", event => {
          const options = event.target.options;
          const value = options.selectedIndex === -1 ? "" : options[options.selectedIndex].value;
          window.updateAngularFormValue(html, {
            value
          });
          storage.setValue(id, {
            value
          });
        });
        break;
    }
  }
  static setAttributes(_ref) {
    let {
      html,
      element,
      storage = null,
      intent,
      linkService
    } = _ref;
    const {
      attributes
    } = element;
    const isHTMLAnchorElement = html instanceof HTMLAnchorElement;
    if (attributes.type === "radio") {
      attributes.name = `${attributes.name}-${intent}`;
    }
    for (const [key, value] of Object.entries(attributes)) {
      if (value === null || value === undefined) {
        continue;
      }
      switch (key) {
        case "class":
          if (value.length) {
            html.setAttribute(key, value.join(" "));
          }
          break;
        case "dataId":
          break;
        case "id":
          html.setAttribute("data-element-id", value);
          break;
        case "style":
          Object.assign(html.style, value);
          break;
        case "textContent":
          html.textContent = value;
          break;
        default:
          if (!isHTMLAnchorElement || key !== "href" && key !== "newWindow") {
            html.setAttribute(key, value);
          }
      }
    }
    if (isHTMLAnchorElement) {
      linkService.addLinkAttributes(html, attributes.href, attributes.newWindow);
    }
    if (storage && attributes.dataId) {
      this.setupStorage(html, attributes.dataId, element, storage);
    }
  }
  static render(parameters) {
    const storage = parameters.annotationStorage;
    const linkService = parameters.linkService;
    const root = parameters.xfaHtml;
    const intent = parameters.intent || "display";
    const rootHtml = document.createElement(root.name);
    if (root.attributes) {
      this.setAttributes({
        html: rootHtml,
        element: root,
        intent,
        linkService
      });
    }
    const isNotForRichText = intent !== "richText";
    const rootDiv = parameters.div;
    rootDiv.append(rootHtml);
    if (parameters.viewport) {
      const transform = `matrix(${parameters.viewport.transform.join(",")})`;
      rootDiv.style.transform = transform;
    }
    if (isNotForRichText) {
      rootDiv.setAttribute("class", "xfaLayer xfaFont");
    }
    const textDivs = [];
    if (root.children.length === 0) {
      if (root.value) {
        const node = document.createTextNode(root.value);
        rootHtml.append(node);
        if (isNotForRichText && XfaText.shouldBuildText(root.name)) {
          textDivs.push(node);
        }
      }
      return {
        textDivs
      };
    }
    const stack = [[root, -1, rootHtml]];
    while (stack.length > 0) {
      const [parent, i, html] = stack.at(-1);
      if (i + 1 === parent.children.length) {
        stack.pop();
        continue;
      }
      const child = parent.children[++stack.at(-1)[1]];
      if (child === null) {
        continue;
      }
      const {
        name
      } = child;
      if (name === "#text") {
        const node = document.createTextNode(child.value);
        textDivs.push(node);
        html.append(node);
        continue;
      }
      const childHtml = child?.attributes?.xmlns ? document.createElementNS(child.attributes.xmlns, name) : document.createElement(name);
      html.append(childHtml);
      if (child.attributes) {
        this.setAttributes({
          html: childHtml,
          element: child,
          storage,
          intent,
          linkService
        });
      }
      if (child.children?.length > 0) {
        stack.push([child, -1, childHtml]);
      } else if (child.value) {
        const node = document.createTextNode(child.value);
        if (isNotForRichText && XfaText.shouldBuildText(name)) {
          textDivs.push(node);
        }
        childHtml.append(node);
      }
    }
    for (const el of rootDiv.querySelectorAll(".xfaNonInteractive input, .xfaNonInteractive textarea")) {
      el.setAttribute("readOnly", true);
    }
    return {
      textDivs
    };
  }
  static update(parameters) {
    const transform = `matrix(${parameters.viewport.transform.join(",")})`;
    parameters.div.style.transform = transform;
    parameters.div.hidden = false;
  }
}

;// ./src/display/annotation_layer.js
function _toSetter(t, e, n) { e || (e = []); var r = e.length++; return Object.defineProperty({}, "_", { set: function (o) { e[r] = o, t.apply(n, e); } }); }
function annotation_layer_classPrivateGetter(s, r, a) { return a(annotation_layer_assertClassBrand(s, r)); }












function annotation_layer_classPrivateMethodInitSpec(e, a) { annotation_layer_checkPrivateRedeclaration(e, a), a.add(e); }
function annotation_layer_classPrivateFieldInitSpec(e, t, a) { annotation_layer_checkPrivateRedeclaration(e, t), t.set(e, a); }
function annotation_layer_checkPrivateRedeclaration(e, t) { if (t.has(e)) throw new TypeError("Cannot initialize the same private elements twice on an object"); }
function annotation_layer_classPrivateFieldSet(s, a, r) { return s.set(annotation_layer_assertClassBrand(s, a), r), r; }
function annotation_layer_classPrivateFieldGet(s, a) { return s.get(annotation_layer_assertClassBrand(s, a)); }
function annotation_layer_assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); }






const DEFAULT_TAB_INDEX = 1000;
const annotation_layer_DEFAULT_FONT_SIZE = 9;
const GetElementsByNameSet = new WeakSet();
class AnnotationElementFactory {
  static create(parameters) {
    const subtype = parameters.data.annotationType;
    switch (subtype) {
      case AnnotationType.LINK:
        return new LinkAnnotationElement(parameters);
      case AnnotationType.TEXT:
        return new TextAnnotationElement(parameters);
      case AnnotationType.WIDGET:
        const fieldType = parameters.data.fieldType;
        switch (fieldType) {
          case "Tx":
            return new TextWidgetAnnotationElement(parameters);
          case "Btn":
            if (parameters.data.radioButton) {
              return new RadioButtonWidgetAnnotationElement(parameters);
            } else if (parameters.data.checkBox) {
              return new CheckboxWidgetAnnotationElement(parameters);
            }
            return new PushButtonWidgetAnnotationElement(parameters);
          case "Ch":
            return new ChoiceWidgetAnnotationElement(parameters);
          case "Sig":
            return new SignatureWidgetAnnotationElement(parameters);
        }
        return new WidgetAnnotationElement(parameters);
      case AnnotationType.POPUP:
        return new PopupAnnotationElement(parameters);
      case AnnotationType.FREETEXT:
        return new FreeTextAnnotationElement(parameters);
      case AnnotationType.LINE:
        return new LineAnnotationElement(parameters);
      case AnnotationType.SQUARE:
        return new SquareAnnotationElement(parameters);
      case AnnotationType.CIRCLE:
        return new CircleAnnotationElement(parameters);
      case AnnotationType.POLYLINE:
        return new PolylineAnnotationElement(parameters);
      case AnnotationType.CARET:
        return new CaretAnnotationElement(parameters);
      case AnnotationType.INK:
        return new InkAnnotationElement(parameters);
      case AnnotationType.POLYGON:
        return new PolygonAnnotationElement(parameters);
      case AnnotationType.HIGHLIGHT:
        return new HighlightAnnotationElement(parameters);
      case AnnotationType.UNDERLINE:
        return new UnderlineAnnotationElement(parameters);
      case AnnotationType.SQUIGGLY:
        return new SquigglyAnnotationElement(parameters);
      case AnnotationType.STRIKEOUT:
        return new StrikeOutAnnotationElement(parameters);
      case AnnotationType.STAMP:
        return new StampAnnotationElement(parameters);
      case AnnotationType.FILEATTACHMENT:
        return new FileAttachmentAnnotationElement(parameters);
      default:
        return new AnnotationElement(parameters);
    }
  }
}
var _updates = /*#__PURE__*/new WeakMap();
var _hasBorder = /*#__PURE__*/new WeakMap();
var _popupElement = /*#__PURE__*/new WeakMap();
var _AnnotationElement_brand = /*#__PURE__*/new WeakSet();
class AnnotationElement {
  constructor(parameters) {
    let {
      isRenderable = false,
      ignoreBorder = false,
      createQuadrilaterals = false
    } = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
    annotation_layer_classPrivateMethodInitSpec(this, _AnnotationElement_brand);
    annotation_layer_classPrivateFieldInitSpec(this, _updates, null);
    annotation_layer_classPrivateFieldInitSpec(this, _hasBorder, false);
    annotation_layer_classPrivateFieldInitSpec(this, _popupElement, null);
    this.isRenderable = isRenderable;
    this.data = parameters.data;
    this.layer = parameters.layer;
    this.linkService = parameters.linkService;
    this.downloadManager = parameters.downloadManager;
    this.imageResourcesPath = parameters.imageResourcesPath;
    this.renderForms = parameters.renderForms;
    this.svgFactory = parameters.svgFactory;
    this.annotationStorage = parameters.annotationStorage;
    this.enableScripting = parameters.enableScripting;
    this.hasJSActions = parameters.hasJSActions;
    this._fieldObjects = parameters.fieldObjects;
    this.parent = parameters.parent;
    if (isRenderable) {
      this.container = this._createContainer(ignoreBorder);
    }
    if (createQuadrilaterals) {
      this._createQuadrilaterals();
    }
  }
  static _hasPopupData(_ref) {
    let {
      titleObj,
      contentsObj,
      richText
    } = _ref;
    return !!(titleObj?.str || contentsObj?.str || richText?.str);
  }
  get _isEditable() {
    return this.data.isEditable;
  }
  get hasPopupData() {
    return AnnotationElement._hasPopupData(this.data);
  }
  updateEdited(params) {
    if (!this.container) {
      return;
    }
    annotation_layer_classPrivateFieldGet(_updates, this) || annotation_layer_classPrivateFieldSet(_updates, this, {
      rect: this.data.rect.slice(0)
    });
    const {
      rect
    } = params;
    if (rect) {
      annotation_layer_assertClassBrand(_AnnotationElement_brand, this, _setRectEdited).call(this, rect);
    }
    annotation_layer_classPrivateFieldGet(_popupElement, this)?.popup.updateEdited(params);
  }
  resetEdited() {
    if (!annotation_layer_classPrivateFieldGet(_updates, this)) {
      return;
    }
    annotation_layer_assertClassBrand(_AnnotationElement_brand, this, _setRectEdited).call(this, annotation_layer_classPrivateFieldGet(_updates, this).rect);
    annotation_layer_classPrivateFieldGet(_popupElement, this)?.popup.resetEdited();
    annotation_layer_classPrivateFieldSet(_updates, this, null);
  }
  _createContainer(ignoreBorder) {
    const {
      data,
      parent: {
        page,
        viewport
      }
    } = this;
    const container = document.createElement("section");
    container.setAttribute("data-annotation-id", data.id);
    if (!(this instanceof WidgetAnnotationElement)) {
      container.tabIndex = DEFAULT_TAB_INDEX;
    }
    const {
      style
    } = container;
    style.zIndex = this.parent.zIndex++;
    if (data.alternativeText) {
      container.title = data.alternativeText;
    }
    if (data.noRotate) {
      container.classList.add("norotate");
    }
    if (!data.rect || this instanceof PopupAnnotationElement) {
      const {
        rotation
      } = data;
      if (!data.hasOwnCanvas && rotation !== 0) {
        this.setRotation(rotation, container);
      }
      return container;
    }
    const {
      width,
      height
    } = this;
    if (!ignoreBorder && data.borderStyle.width > 0) {
      style.borderWidth = `${data.borderStyle.width}px`;
      const horizontalRadius = data.borderStyle.horizontalCornerRadius;
      const verticalRadius = data.borderStyle.verticalCornerRadius;
      if (horizontalRadius > 0 || verticalRadius > 0) {
        const radius = `calc(${horizontalRadius}px * var(--total-scale-factor)) / calc(${verticalRadius}px * var(--total-scale-factor))`;
        style.borderRadius = radius;
      } else if (this instanceof RadioButtonWidgetAnnotationElement) {
        const radius = `calc(${width}px * var(--total-scale-factor)) / calc(${height}px * var(--total-scale-factor))`;
        style.borderRadius = radius;
      }
      switch (data.borderStyle.style) {
        case AnnotationBorderStyleType.SOLID:
          style.borderStyle = "solid";
          break;
        case AnnotationBorderStyleType.DASHED:
          style.borderStyle = "dashed";
          break;
        case AnnotationBorderStyleType.BEVELED:
          warn("Unimplemented border style: beveled");
          break;
        case AnnotationBorderStyleType.INSET:
          warn("Unimplemented border style: inset");
          break;
        case AnnotationBorderStyleType.UNDERLINE:
          style.borderBottomStyle = "solid";
          break;
        default:
          break;
      }
      const borderColor = data.borderColor || null;
      if (borderColor) {
        annotation_layer_classPrivateFieldSet(_hasBorder, this, true);
        style.borderColor = Util.makeHexColor(borderColor[0] | 0, borderColor[1] | 0, borderColor[2] | 0);
      } else {
        style.borderWidth = 0;
      }
    }
    const rect = Util.normalizeRect([data.rect[0], page.view[3] - data.rect[1] + page.view[1], data.rect[2], page.view[3] - data.rect[3] + page.view[1]]);
    const {
      pageWidth,
      pageHeight,
      pageX,
      pageY
    } = viewport.rawDims;
    style.left = `${100 * (rect[0] - pageX) / pageWidth}%`;
    style.top = `${100 * (rect[1] - pageY) / pageHeight}%`;
    const {
      rotation
    } = data;
    if (data.hasOwnCanvas || rotation === 0) {
      style.width = `${100 * width / pageWidth}%`;
      style.height = `${100 * height / pageHeight}%`;
    } else {
      this.setRotation(rotation, container);
    }
    return container;
  }
  setRotation(angle) {
    let container = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : this.container;
    if (!this.data.rect) {
      return;
    }
    const {
      pageWidth,
      pageHeight
    } = this.parent.viewport.rawDims;
    let {
      width,
      height
    } = this;
    if (angle % 180 !== 0) {
      [width, height] = [height, width];
    }
    container.style.width = `${100 * width / pageWidth}%`;
    container.style.height = `${100 * height / pageHeight}%`;
    container.setAttribute("data-main-rotation", (360 - angle) % 360);
  }
  get _commonActions() {
    const setColor = (jsName, styleName, event) => {
      const color = event.detail[jsName];
      const colorType = color[0];
      const colorArray = color.slice(1);
      event.target.style[styleName] = ColorConverters[`${colorType}_HTML`](colorArray);
      this.annotationStorage.setValue(this.data.id, {
        [styleName]: ColorConverters[`${colorType}_rgb`](colorArray)
      });
    };
    return shadow(this, "_commonActions", {
      display: event => {
        const {
          display
        } = event.detail;
        const hidden = display % 2 === 1;
        this.container.style.visibility = hidden ? "hidden" : "visible";
        this.annotationStorage.setValue(this.data.id, {
          noView: hidden,
          noPrint: display === 1 || display === 2
        });
      },
      print: event => {
        this.annotationStorage.setValue(this.data.id, {
          noPrint: !event.detail.print
        });
      },
      hidden: event => {
        const {
          hidden
        } = event.detail;
        this.container.style.visibility = hidden ? "hidden" : "visible";
        this.annotationStorage.setValue(this.data.id, {
          noPrint: hidden,
          noView: hidden
        });
      },
      focus: event => {
        setTimeout(() => event.target.focus({
          preventScroll: false
        }), 0);
      },
      userName: event => {
        event.target.title = event.detail.userName;
      },
      readonly: event => {
        event.target.disabled = event.detail.readonly;
      },
      required: event => {
        this._setRequired(event.target, event.detail.required);
      },
      bgColor: event => {
        setColor("bgColor", "backgroundColor", event);
      },
      fillColor: event => {
        setColor("fillColor", "backgroundColor", event);
      },
      fgColor: event => {
        setColor("fgColor", "color", event);
      },
      textColor: event => {
        setColor("textColor", "color", event);
      },
      borderColor: event => {
        setColor("borderColor", "borderColor", event);
      },
      strokeColor: event => {
        setColor("strokeColor", "borderColor", event);
      },
      rotation: event => {
        const angle = event.detail.rotation;
        this.setRotation(angle);
        this.annotationStorage.setValue(this.data.id, {
          rotation: angle
        });
      }
    });
  }
  _dispatchEventFromSandbox(actions, jsEvent) {
    const commonActions = this._commonActions;
    for (const name of Object.keys(jsEvent.detail)) {
      const action = actions[name] || commonActions[name];
      action?.(jsEvent);
    }
  }
  _setDefaultPropertiesFromJS(element) {
    if (!this.enableScripting) {
      return;
    }
    const storedData = this.annotationStorage.getRawValue(this.data.id);
    if (!storedData) {
      return;
    }
    const commonActions = this._commonActions;
    for (const [actionName, detail] of Object.entries(storedData)) {
      const action = commonActions[actionName];
      if (action) {
        const eventProxy = {
          detail: {
            [actionName]: detail
          },
          target: element
        };
        action(eventProxy);
        delete storedData[actionName];
      }
    }
  }
  _createQuadrilaterals() {
    if (!this.container) {
      return;
    }
    const {
      quadPoints
    } = this.data;
    if (!quadPoints) {
      return;
    }
    const [rectBlX, rectBlY, rectTrX, rectTrY] = this.data.rect.map(x => Math.fround(x));
    if (quadPoints.length === 8) {
      const [trX, trY, blX, blY] = quadPoints.subarray(2, 6);
      if (rectTrX === trX && rectTrY === trY && rectBlX === blX && rectBlY === blY) {
        return;
      }
    }
    const {
      style
    } = this.container;
    let svgBuffer;
    if (annotation_layer_classPrivateFieldGet(_hasBorder, this)) {
      const {
        borderColor,
        borderWidth
      } = style;
      style.borderWidth = 0;
      svgBuffer = ["url('data:image/svg+xml;utf8,", `<svg xmlns="http://www.w3.org/2000/svg"`, ` preserveAspectRatio="none" viewBox="0 0 1 1">`, `<g fill="transparent" stroke="${borderColor}" stroke-width="${borderWidth}">`];
      this.container.classList.add("hasBorder");
    }
    const width = rectTrX - rectBlX;
    const height = rectTrY - rectBlY;
    const {
      svgFactory
    } = this;
    const svg = svgFactory.createElement("svg");
    svg.classList.add("quadrilateralsContainer");
    svg.setAttribute("width", 0);
    svg.setAttribute("height", 0);
    const defs = svgFactory.createElement("defs");
    svg.append(defs);
    const clipPath = svgFactory.createElement("clipPath");
    const id = `clippath_${this.data.id}`;
    clipPath.setAttribute("id", id);
    clipPath.setAttribute("clipPathUnits", "objectBoundingBox");
    defs.append(clipPath);
    for (let i = 2, ii = quadPoints.length; i < ii; i += 8) {
      const trX = quadPoints[i];
      const trY = quadPoints[i + 1];
      const blX = quadPoints[i + 2];
      const blY = quadPoints[i + 3];
      const rect = svgFactory.createElement("rect");
      const x = (blX - rectBlX) / width;
      const y = (rectTrY - trY) / height;
      const rectWidth = (trX - blX) / width;
      const rectHeight = (trY - blY) / height;
      rect.setAttribute("x", x);
      rect.setAttribute("y", y);
      rect.setAttribute("width", rectWidth);
      rect.setAttribute("height", rectHeight);
      clipPath.append(rect);
      svgBuffer?.push(`<rect vector-effect="non-scaling-stroke" x="${x}" y="${y}" width="${rectWidth}" height="${rectHeight}"/>`);
    }
    if (annotation_layer_classPrivateFieldGet(_hasBorder, this)) {
      svgBuffer.push(`</g></svg>')`);
      style.backgroundImage = svgBuffer.join("");
    }
    this.container.append(svg);
    this.container.style.clipPath = `url(#${id})`;
  }
  _createPopup() {
    const {
      data
    } = this;
    const popup = annotation_layer_classPrivateFieldSet(_popupElement, this, new PopupAnnotationElement({
      data: {
        color: data.color,
        titleObj: data.titleObj,
        modificationDate: data.modificationDate,
        contentsObj: data.contentsObj,
        richText: data.richText,
        parentRect: data.rect,
        borderStyle: 0,
        id: `popup_${data.id}`,
        rotation: data.rotation
      },
      parent: this.parent,
      elements: [this]
    }));
    this.parent.div.append(popup.render());
  }
  render() {
    unreachable("Abstract method `AnnotationElement.render` called");
  }
  _getElementsByName(name) {
    let skipId = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
    const fields = [];
    if (this._fieldObjects) {
      const fieldObj = this._fieldObjects[name];
      if (fieldObj) {
        for (const {
          page,
          id,
          exportValues
        } of fieldObj) {
          if (page === -1) {
            continue;
          }
          if (id === skipId) {
            continue;
          }
          const exportValue = typeof exportValues === "string" ? exportValues : null;
          const domElement = document.querySelector(`[data-element-id="${id}"]`);
          if (domElement && !GetElementsByNameSet.has(domElement)) {
            warn(`_getElementsByName - element not allowed: ${id}`);
            continue;
          }
          fields.push({
            id,
            exportValue,
            domElement
          });
        }
      }
      return fields;
    }
    for (const domElement of document.getElementsByName(name)) {
      const {
        exportValue
      } = domElement;
      const id = domElement.getAttribute("data-element-id");
      if (id === skipId) {
        continue;
      }
      if (!GetElementsByNameSet.has(domElement)) {
        continue;
      }
      fields.push({
        id,
        exportValue,
        domElement
      });
    }
    return fields;
  }
  show() {
    if (this.container) {
      this.container.hidden = false;
    }
    this.popup?.maybeShow();
  }
  hide() {
    if (this.container) {
      this.container.hidden = true;
    }
    this.popup?.forceHide();
  }
  getElementsToTriggerPopup() {
    return this.container;
  }
  addHighlightArea() {
    const triggers = this.getElementsToTriggerPopup();
    if (Array.isArray(triggers)) {
      for (const element of triggers) {
        element.classList.add("highlightArea");
      }
    } else {
      triggers.classList.add("highlightArea");
    }
  }
  _editOnDoubleClick() {
    if (!this._isEditable) {
      return;
    }
    const {
      annotationEditorType: mode,
      data: {
        id: editId
      }
    } = this;
    this.container.addEventListener("dblclick", () => {
      this.linkService.eventBus?.dispatch("switchannotationeditormode", {
        source: this,
        mode,
        editId
      });
    });
  }
  get width() {
    return this.data.rect[2] - this.data.rect[0];
  }
  get height() {
    return this.data.rect[3] - this.data.rect[1];
  }
}
function _setRectEdited(rect) {
  const {
    container: {
      style
    },
    data: {
      rect: currentRect,
      rotation
    },
    parent: {
      viewport: {
        rawDims: {
          pageWidth,
          pageHeight,
          pageX,
          pageY
        }
      }
    }
  } = this;
  currentRect?.splice(0, 4, ...rect);
  style.left = `${100 * (rect[0] - pageX) / pageWidth}%`;
  style.top = `${100 * (pageHeight - rect[3] + pageY) / pageHeight}%`;
  if (rotation === 0) {
    style.width = `${100 * (rect[2] - rect[0]) / pageWidth}%`;
    style.height = `${100 * (rect[3] - rect[1]) / pageHeight}%`;
  } else {
    this.setRotation(rotation);
  }
}
var _LinkAnnotationElement_brand = /*#__PURE__*/new WeakSet();
class LinkAnnotationElement extends AnnotationElement {
  constructor(parameters) {
    let options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
    super(parameters, {
      isRenderable: true,
      ignoreBorder: !!options?.ignoreBorder,
      createQuadrilaterals: true
    });
    annotation_layer_classPrivateMethodInitSpec(this, _LinkAnnotationElement_brand);
    this.isTooltipOnly = parameters.data.isTooltipOnly;
  }
  render() {
    const {
      data,
      linkService
    } = this;
    const link = document.createElement("a");
    link.setAttribute("data-element-id", data.id);
    let isBound = false;
    if (data.url) {
      linkService.addLinkAttributes(link, data.url, data.newWindow);
      isBound = true;
    } else if (data.action) {
      this._bindNamedAction(link, data.action);
      isBound = true;
    } else if (data.attachment) {
      annotation_layer_assertClassBrand(_LinkAnnotationElement_brand, this, _bindAttachment).call(this, link, data.attachment, data.attachmentDest);
      isBound = true;
    } else if (data.setOCGState) {
      annotation_layer_assertClassBrand(_LinkAnnotationElement_brand, this, _bindSetOCGState).call(this, link, data.setOCGState);
      isBound = true;
    } else if (data.dest) {
      this._bindLink(link, data.dest);
      isBound = true;
    } else {
      if (data.actions && (data.actions.Action || data.actions["Mouse Up"] || data.actions["Mouse Down"]) && this.enableScripting && this.hasJSActions) {
        this._bindJSAction(link, data);
        isBound = true;
      }
      if (data.resetForm) {
        this._bindResetFormAction(link, data.resetForm);
        isBound = true;
      } else if (this.isTooltipOnly && !isBound) {
        this._bindLink(link, "");
        isBound = true;
      }
    }
    this.container.classList.add("linkAnnotation");
    if (isBound) {
      this.container.append(link);
    }
    return this.container;
  }
  _bindLink(link, destination) {
    link.href = this.linkService.getDestinationHash(destination);
    link.onclick = () => {
      if (destination) {
        this.linkService.goToDestination(destination);
      }
      return false;
    };
    if (destination || destination === "") {
      annotation_layer_assertClassBrand(_LinkAnnotationElement_brand, this, _setInternalLink).call(this);
    }
  }
  _bindNamedAction(link, action) {
    link.href = this.linkService.getAnchorUrl("");
    link.onclick = () => {
      this.linkService.executeNamedAction(action);
      return false;
    };
    annotation_layer_assertClassBrand(_LinkAnnotationElement_brand, this, _setInternalLink).call(this);
  }
  _bindJSAction(link, data) {
    link.href = this.linkService.getAnchorUrl("");
    const map = new Map([["Action", "onclick"], ["Mouse Up", "onmouseup"], ["Mouse Down", "onmousedown"]]);
    for (const name of Object.keys(data.actions)) {
      const jsName = map.get(name);
      if (!jsName) {
        continue;
      }
      link[jsName] = () => {
        this.linkService.eventBus?.dispatch("dispatcheventinsandbox", {
          source: this,
          detail: {
            id: data.id,
            name
          }
        });
        return false;
      };
    }
    if (!link.onclick) {
      link.onclick = () => false;
    }
    annotation_layer_assertClassBrand(_LinkAnnotationElement_brand, this, _setInternalLink).call(this);
  }
  _bindResetFormAction(link, resetForm) {
    const otherClickAction = link.onclick;
    if (!otherClickAction) {
      link.href = this.linkService.getAnchorUrl("");
    }
    annotation_layer_assertClassBrand(_LinkAnnotationElement_brand, this, _setInternalLink).call(this);
    if (!this._fieldObjects) {
      warn(`_bindResetFormAction - "resetForm" action not supported, ` + "ensure that the `fieldObjects` parameter is provided.");
      if (!otherClickAction) {
        link.onclick = () => false;
      }
      return;
    }
    link.onclick = () => {
      otherClickAction?.();
      const {
        fields: resetFormFields,
        refs: resetFormRefs,
        include
      } = resetForm;
      const allFields = [];
      if (resetFormFields.length !== 0 || resetFormRefs.length !== 0) {
        const fieldIds = new Set(resetFormRefs);
        for (const fieldName of resetFormFields) {
          const fields = this._fieldObjects[fieldName] || [];
          for (const {
            id
          } of fields) {
            fieldIds.add(id);
          }
        }
        for (const fields of Object.values(this._fieldObjects)) {
          for (const field of fields) {
            if (fieldIds.has(field.id) === include) {
              allFields.push(field);
            }
          }
        }
      } else {
        for (const fields of Object.values(this._fieldObjects)) {
          allFields.push(...fields);
        }
      }
      const storage = this.annotationStorage;
      const allIds = [];
      for (const field of allFields) {
        const {
          id
        } = field;
        allIds.push(id);
        switch (field.type) {
          case "text":
            {
              const value = field.defaultValue || "";
              storage.setValue(id, {
                value
              });
              window.updateAngularFormValue(id, {
                value
              });
              break;
            }
          case "checkbox":
          case "radiobutton":
            {
              const value = field.defaultValue === field.exportValues;
              storage.setValue(id, {
                value
              });
              window.updateAngularFormValue(id, {
                value
              });
              break;
            }
          case "combobox":
          case "listbox":
            {
              const value = field.defaultValue || "";
              storage.setValue(id, {
                value
              });
              window.updateAngularFormValue(id, {
                value
              });
              break;
            }
          default:
            continue;
        }
        const domElement = document.querySelector(`[data-element-id="${id}"]`);
        if (!domElement) {
          continue;
        } else if (!GetElementsByNameSet.has(domElement)) {
          warn(`_bindResetFormAction - element not allowed: ${id}`);
          continue;
        }
        domElement.dispatchEvent(new Event("resetform"));
      }
      if (this.enableScripting) {
        this.linkService.eventBus?.dispatch("dispatcheventinsandbox", {
          source: this,
          detail: {
            id: "app",
            ids: allIds,
            name: "ResetForm"
          }
        });
      }
      return false;
    };
  }
}
function _setInternalLink() {
  this.container.setAttribute("data-internal-link", "");
}
function _bindAttachment(link, attachment) {
  let dest = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
  link.href = this.linkService.getAnchorUrl("");
  if (attachment.description) {
    link.title = attachment.description;
  }
  link.onclick = () => {
    this.downloadManager?.openOrDownloadData(attachment.content, attachment.filename, dest);
    return false;
  };
  annotation_layer_assertClassBrand(_LinkAnnotationElement_brand, this, _setInternalLink).call(this);
}
function _bindSetOCGState(link, action) {
  link.href = this.linkService.getAnchorUrl("");
  link.onclick = () => {
    this.linkService.executeSetOCGState(action);
    return false;
  };
  annotation_layer_assertClassBrand(_LinkAnnotationElement_brand, this, _setInternalLink).call(this);
}
class TextAnnotationElement extends AnnotationElement {
  constructor(parameters) {
    super(parameters, {
      isRenderable: true
    });
  }
  render() {
    this.container.classList.add("textAnnotation");
    const image = document.createElement("img");
    image.src = this.imageResourcesPath + "annotation-" + this.data.name.toLowerCase() + ".svg";
    image.setAttribute("data-l10n-id", "pdfjs-text-annotation-type");
    image.setAttribute("data-l10n-args", JSON.stringify({
      type: this.data.name
    }));
    if (!this.data.popupRef && this.hasPopupData) {
      this._createPopup();
    }
    this.container.append(image);
    return this.container;
  }
}
class WidgetAnnotationElement extends AnnotationElement {
  render() {
    return this.container;
  }
  showElementAndHideCanvas(element) {
    if (this.data.hasOwnCanvas) {
      if (element.previousSibling?.nodeName === "CANVAS") {
        element.previousSibling.hidden = true;
      }
      element.hidden = false;
    }
  }
  _getKeyModifier(event) {
    return util_FeatureTest.platform.isMac ? event.metaKey : event.ctrlKey;
  }
  _setEventListener(element, elementData, baseName, eventName, valueGetter) {
    if (baseName.includes("mouse")) {
      element.addEventListener(baseName, event => {
        this.linkService.eventBus?.dispatch("dispatcheventinsandbox", {
          source: this,
          detail: {
            id: this.data.id,
            name: eventName,
            value: valueGetter(event),
            shift: event.shiftKey,
            modifier: this._getKeyModifier(event)
          }
        });
      });
    } else {
      element.addEventListener(baseName, event => {
        if (baseName === "blur") {
          if (!elementData.focused) {
            return;
          }
          elementData.focused = false;
        } else if (baseName === "focus") {
          if (elementData.focused) {
            return;
          }
          elementData.focused = true;
        }
        if (!valueGetter) {
          return;
        }
        this.linkService.eventBus?.dispatch("dispatcheventinsandbox", {
          source: this,
          detail: {
            id: this.data.id,
            name: eventName,
            value: valueGetter(event)
          }
        });
      });
    }
  }
  _setEventListeners(element, elementData, names, getter) {
    for (const [baseName, eventName] of names) {
      if (eventName === "Action" || this.data.actions?.[eventName]) {
        if (eventName === "Focus" || eventName === "Blur") {
          elementData ||= {
            focused: false
          };
        }
        this._setEventListener(element, elementData, baseName, eventName, getter);
        if (eventName === "Focus" && !this.data.actions?.Blur) {
          this._setEventListener(element, elementData, "blur", "Blur", null);
        } else if (eventName === "Blur" && !this.data.actions?.Focus) {
          this._setEventListener(element, elementData, "focus", "Focus", null);
        }
      }
    }
  }
  _setBackgroundColor(element) {
    const color = this.data.backgroundColor || null;
    element.style.backgroundColor = color === null ? "transparent" : Util.makeHexColor(color[0], color[1], color[2]);
  }
  _setTextStyle(element) {
    const TEXT_ALIGNMENT = ["left", "center", "right"];
    const {
      fontColor
    } = this.data.defaultAppearanceData;
    const fontSize = this.data.defaultAppearanceData.fontSize || annotation_layer_DEFAULT_FONT_SIZE;
    const style = element.style;
    let computedFontSize;
    const BORDER_SIZE = 2;
    const roundToOneDecimal = x => Math.round(10 * x) / 10;
    if (this.data.multiLine) {
      const height = Math.abs(this.data.rect[3] - this.data.rect[1] - BORDER_SIZE);
      const numberOfLines = Math.round(height / (LINE_FACTOR * fontSize)) || 1;
      const lineHeight = height / numberOfLines;
      computedFontSize = Math.min(fontSize, roundToOneDecimal(lineHeight / LINE_FACTOR));
    } else {
      const height = Math.abs(this.data.rect[3] - this.data.rect[1] - BORDER_SIZE);
      computedFontSize = Math.min(fontSize, roundToOneDecimal(height / LINE_FACTOR));
    }
    style.fontSize = `calc(${computedFontSize}px * var(--total-scale-factor))`;
    style.color = Util.makeHexColor(fontColor[0], fontColor[1], fontColor[2]);
    if (this.data.textAlignment !== null) {
      style.textAlign = TEXT_ALIGNMENT[this.data.textAlignment];
    }
  }
  _setRequired(element, isRequired) {
    if (isRequired) {
      element.setAttribute("required", true);
    } else {
      element.removeAttribute("required");
    }
    element.setAttribute("aria-required", isRequired);
  }
}
class TextWidgetAnnotationElement extends WidgetAnnotationElement {
  constructor(parameters) {
    const isRenderable = parameters.renderForms || parameters.data.hasOwnCanvas || !parameters.data.hasAppearance && !!parameters.data.fieldValue;
    super(parameters, {
      isRenderable
    });
  }
  setPropertyOnSiblings(base, key, value, keyInStorage) {
    const storage = this.annotationStorage;
    for (const element of this._getElementsByName(base.name, base.id)) {
      if (element.domElement) {
        element.domElement[key] = value;
      }
      storage.setValue(element.id, {
        [keyInStorage]: value
      });
    }
  }
  render() {
    const storage = this.annotationStorage;
    const id = this.data.id;
    this.container.classList.add("textWidgetAnnotation");
    let element = null;
    if (this.renderForms) {
      const angularData = window.getFormValueFromAngular(this.data.fieldName);
      const formData = storage.getValue(id, {
        value: this.data.fieldValue
      });
      const storedData = angularData.value ? angularData : formData;
      if (angularData !== formData) {
        storage.setValue(id, {
          value: angularData.value
        });
        storedData.formattedValue = angularData.value;
      }
      let textContent = storedData.value || "";
      const maxLen = storage.getValue(id, {
        charLimit: this.data.maxLen
      }).charLimit;
      if (maxLen && textContent.length > maxLen) {
        textContent = textContent.slice(0, maxLen);
      }
      let fieldFormattedValues = storedData.formattedValue || this.data.textContent?.join("\n") || null;
      if (fieldFormattedValues && this.data.comb) {
        fieldFormattedValues = fieldFormattedValues.replaceAll(/\s+/g, "");
      }
      const elementData = {
        userValue: textContent,
        formattedValue: fieldFormattedValues,
        lastCommittedValue: null,
        commitKey: 1,
        focused: false
      };
      if (this.data.multiLine) {
        element = document.createElement("textarea");
        element.textContent = fieldFormattedValues ?? textContent;
        if (this.data.doNotScroll) {
          element.style.overflowY = "hidden";
        }
      } else {
        element = document.createElement("input");
        element.type = this.data.password ? "password" : "text";
        element.setAttribute("value", fieldFormattedValues ?? textContent);
        if (this.data.doNotScroll) {
          element.style.overflowX = "hidden";
        }
      }
      if (this.data.hasOwnCanvas) {
        element.hidden = true;
      }
      GetElementsByNameSet.add(element);
      element.setAttribute("data-element-id", id);
      element.disabled = this.data.readOnly;
      element.name = this.data.fieldName;
      element.tabIndex = DEFAULT_TAB_INDEX;
      this._setRequired(element, this.data.required);
      if (maxLen) {
        element.maxLength = maxLen;
      }
      element.addEventListener("input", event => {
        storage.setValue(id, {
          value: event.target.value
        });
        window.updateAngularFormValue(id, {
          value: event.target.value
        });
        this.setPropertyOnSiblings(element, "value", event.target.value, "value");
        elementData.formattedValue = null;
      });
      element.addEventListener("resetform", event => {
        const defaultValue = this.data.defaultFieldValue ?? "";
        element.value = elementData.userValue = defaultValue;
        elementData.formattedValue = null;
      });
      let blurListener = event => {
        const {
          formattedValue
        } = elementData;
        if (formattedValue !== null && formattedValue !== undefined) {
          event.target.value = formattedValue;
        }
        event.target.scrollLeft = 0;
      };
      window.registerAcroformField(id, element, storedData.value, undefined, this.data.fieldValue);
      element.addEventListener("updateFromAngular", newvalue => {
        elementData.formattedValue = null;
        storage.setValue(id, {
          value: newvalue.detail
        });
      });
      if (this.enableScripting && this.hasJSActions) {
        element.addEventListener("focus", event => {
          if (elementData.focused) {
            return;
          }
          const {
            target
          } = event;
          if (elementData.userValue) {
            target.value = elementData.userValue;
          }
          elementData.lastCommittedValue = target.value;
          elementData.commitKey = 1;
          if (!this.data.actions?.Focus) {
            elementData.focused = true;
          }
        });
        element.addEventListener("updatefromsandbox", jsEvent => {
          this.showElementAndHideCanvas(jsEvent.target);
          const actions = {
            value(event) {
              elementData.userValue = event.detail.value ?? "";
              storage.setValue(id, {
                value: elementData.userValue.toString()
              });
              window.updateAngularFormValue(id, {
                value: elementData.userValue.toString()
              });
              event.target.value = elementData.userValue;
            },
            formattedValue(event) {
              const {
                formattedValue
              } = event.detail;
              elementData.formattedValue = formattedValue;
              if (formattedValue !== null && formattedValue !== undefined && event.target !== document.activeElement) {
                event.target.value = formattedValue;
              }
              storage.setValue(id, {
                formattedValue
              });
              window.updateAngularFormValue(id, {
                formattedValue
              });
            },
            selRange(event) {
              event.target.setSelectionRange(...event.detail.selRange);
            },
            charLimit: event => {
              const {
                charLimit
              } = event.detail;
              const {
                target
              } = event;
              if (charLimit === 0) {
                target.removeAttribute("maxLength");
                return;
              }
              target.setAttribute("maxLength", charLimit);
              let value = elementData.userValue;
              if (!value || value.length <= charLimit) {
                return;
              }
              value = value.slice(0, charLimit);
              target.value = elementData.userValue = value;
              storage.setValue(id, {
                value
              });
              window.updateAngularFormValue(id, {
                value
              });
              this.linkService.eventBus?.dispatch("dispatcheventinsandbox", {
                source: this,
                detail: {
                  id,
                  name: "Keystroke",
                  value,
                  willCommit: true,
                  commitKey: 1,
                  selStart: target.selectionStart,
                  selEnd: target.selectionEnd
                }
              });
            }
          };
          this._dispatchEventFromSandbox(actions, jsEvent);
        });
        element.addEventListener("keydown", event => {
          elementData.commitKey = 1;
          let commitKey = -1;
          if (event.key === "Escape") {
            commitKey = 0;
          } else if (event.key === "Enter" && !this.data.multiLine) {
            commitKey = 2;
          } else if (event.key === "Tab") {
            elementData.commitKey = 3;
          }
          if (commitKey === -1) {
            return;
          }
          const {
            value
          } = event.target;
          if (elementData.lastCommittedValue === value) {
            return;
          }
          elementData.lastCommittedValue = value;
          elementData.userValue = value;
          this.linkService.eventBus?.dispatch("dispatcheventinsandbox", {
            source: this,
            detail: {
              id,
              name: "Keystroke",
              value,
              willCommit: true,
              commitKey,
              selStart: event.target.selectionStart,
              selEnd: event.target.selectionEnd
            }
          });
        });
        const _blurListener = blurListener;
        blurListener = null;
        element.addEventListener("blur", event => {
          if (!elementData.focused) {
            return;
          }
          if (!this.data.actions?.Blur) {
            elementData.focused = false;
          }
          const {
            value
          } = event.target;
          elementData.userValue = value;
          if (elementData.lastCommittedValue !== value) {
            this.linkService.eventBus?.dispatch("dispatcheventinsandbox", {
              source: this,
              detail: {
                id,
                name: "Keystroke",
                value,
                willCommit: true,
                commitKey: elementData.commitKey,
                selStart: event.target.selectionStart,
                selEnd: event.target.selectionEnd
              }
            });
          }
          _blurListener(event);
        });
        if (this.data.actions?.Keystroke) {
          element.addEventListener("beforeinput", event => {
            elementData.lastCommittedValue = null;
            const {
              data,
              target
            } = event;
            const {
              value,
              selectionStart,
              selectionEnd
            } = target;
            let selStart = selectionStart,
              selEnd = selectionEnd;
            switch (event.inputType) {
              case "deleteWordBackward":
                {
                  const match = value.substring(0, selectionStart).match(/\w*[^\w]*$/);
                  if (match) {
                    selStart -= match[0].length;
                  }
                  break;
                }
              case "deleteWordForward":
                {
                  const match = value.substring(selectionStart).match(/^[^\w]*\w*/);
                  if (match) {
                    selEnd += match[0].length;
                  }
                  break;
                }
              case "deleteContentBackward":
                if (selectionStart === selectionEnd) {
                  selStart -= 1;
                }
                break;
              case "deleteContentForward":
                if (selectionStart === selectionEnd) {
                  selEnd += 1;
                }
                break;
            }
            event.preventDefault();
            this.linkService.eventBus?.dispatch("dispatcheventinsandbox", {
              source: this,
              detail: {
                id,
                name: "Keystroke",
                value,
                change: data || "",
                willCommit: false,
                selStart,
                selEnd
              }
            });
          });
        }
        this._setEventListeners(element, elementData, [["focus", "Focus"], ["blur", "Blur"], ["mousedown", "Mouse Down"], ["mouseenter", "Mouse Enter"], ["mouseleave", "Mouse Exit"], ["mouseup", "Mouse Up"]], event => event.target.value);
      }
      if (blurListener) {
        element.addEventListener("blur", blurListener);
      }
      if (this.data.comb) {
        const fieldWidth = this.data.rect[2] - this.data.rect[0];
        const combWidth = fieldWidth / maxLen;
        element.classList.add("comb");
        element.style.letterSpacing = `calc(${combWidth}px * var(--total-scale-factor) - 1ch)`;
      }
    } else {
      element = document.createElement("div");
      element.textContent = this.data.fieldValue;
      element.style.verticalAlign = "middle";
      element.style.display = "table-cell";
      if (this.data.hasOwnCanvas) {
        element.hidden = true;
      }
    }
    this._setTextStyle(element);
    this._setBackgroundColor(element);
    this._setDefaultPropertiesFromJS(element);
    this.container.append(element);
    return this.container;
  }
}
class SignatureWidgetAnnotationElement extends WidgetAnnotationElement {
  constructor(parameters) {
    super(parameters, {
      isRenderable: !!parameters.data.hasOwnCanvas
    });
  }
}
class CheckboxWidgetAnnotationElement extends WidgetAnnotationElement {
  constructor(parameters) {
    super(parameters, {
      isRenderable: parameters.renderForms
    });
  }
  render() {
    const storage = this.annotationStorage;
    const data = this.data;
    const id = data.id;
    const angularData = window.getFormValueFromAngular(this.data.fieldName);
    const formValue = storage.getValue(id, {
      value: data.exportValue === data.fieldValue
    }).value;
    let angularValue = undefined;
    if (angularData.value) {
      angularValue = angularData.value === true || angularData.value === data.exportValue;
    }
    let value = angularValue !== undefined ? angularValue : formValue;
    let updateAngularValueNecessary = false;
    if (typeof value === "string") {
      value = value === data.exportValue;
      storage.setValue(id, {
        value
      });
      updateAngularValueNecessary = true;
    } else if (angularData?.value !== undefined && angularData.value !== formValue) {
      const isChecked = angularData.value === true || angularData.value === data.exportValue;
      value = isChecked ? data.exportValue : undefined;
      storage.setValue(id, {
        value
      });
    }
    this.container.classList.add("buttonWidgetAnnotation", "checkBox");
    const element = document.createElement("input");
    GetElementsByNameSet.add(element);
    element.setAttribute("data-element-id", id);
    element.disabled = data.readOnly;
    this._setRequired(element, this.data.required);
    element.type = "checkbox";
    element.name = data.fieldName;
    if (value) {
      element.setAttribute("checked", true);
    }
    element.setAttribute("exportValue", data.exportValue);
    element.tabIndex = DEFAULT_TAB_INDEX;
    element.addEventListener("change", event => {
      const {
        name,
        checked
      } = event.target;
      for (const checkbox of this._getElementsByName(name, id)) {
        const curChecked = checked && checkbox.exportValue === data.exportValue;
        if (checkbox.domElement) {
          checkbox.domElement.checked = curChecked;
        }
        storage.setValue(checkbox.id, {
          value: curChecked
        });
        window.updateAngularFormValue(id, {
          value: curChecked
        });
      }
      storage.setValue(id, {
        value: checked
      });
      window.updateAngularFormValue(id, {
        value: checked
      });
    });
    element.addEventListener("resetform", event => {
      const defaultValue = data.defaultFieldValue || "Off";
      event.target.checked = defaultValue === data.exportValue;
    });
    window.registerAcroformField(id, element, value ? data.exportValue : undefined, undefined, this.data.fieldValue);
    element.addEventListener("updateFromAngular", newvalue => storage.setValue(id, {
      value: newvalue.detail
    }));
    if (updateAngularValueNecessary) {
      window.updateAngularFormValue(id, {
        value
      });
    }
    if (this.enableScripting && this.hasJSActions) {
      element.addEventListener("updatefromsandbox", jsEvent => {
        const actions = {
          value(event) {
            event.target.checked = event.detail.value !== "Off";
            storage.setValue(id, {
              value: event.target.checked
            });
            window.updateAngularFormValue(id, {
              value: event.target.value
            });
          }
        };
        this._dispatchEventFromSandbox(actions, jsEvent);
      });
      this._setEventListeners(element, null, [["change", "Validate"], ["change", "Action"], ["focus", "Focus"], ["blur", "Blur"], ["mousedown", "Mouse Down"], ["mouseenter", "Mouse Enter"], ["mouseleave", "Mouse Exit"], ["mouseup", "Mouse Up"]], event => event.target.checked);
    }
    this._setBackgroundColor(element);
    this._setDefaultPropertiesFromJS(element);
    this.container.append(element);
    return this.container;
  }
}
class RadioButtonWidgetAnnotationElement extends WidgetAnnotationElement {
  constructor(parameters) {
    super(parameters, {
      isRenderable: parameters.renderForms
    });
  }
  render() {
    this.container.classList.add("buttonWidgetAnnotation", "radioButton");
    const storage = this.annotationStorage;
    const data = this.data;
    const id = data.id;
    const angularData = window.getFormValueFromAngular(this.data.fieldName);
    const defaultValue = data.fieldValue === data.buttonValue ? data.buttonValue : undefined;
    const formValue = storage.getValue(id, {
      value: defaultValue
    }).value;
    let value = angularData.value ?? formValue;
    if (typeof value === "string" || angularData !== formValue) {
      value = value === data.buttonValue;
      storage.setValue(id, {
        value
      });
    } else if (value) {
      window.updateAngularFormValue(id, {
        value: data.buttonValue
      });
    }
    if (value) {
      for (const radio of this._getElementsByName(data.fieldName, id)) {
        storage.setValue(radio.id, {
          value: false
        });
      }
    }
    const element = document.createElement("input");
    GetElementsByNameSet.add(element);
    element.setAttribute("data-element-id", id);
    element.disabled = data.readOnly;
    this._setRequired(element, this.data.required);
    element.type = "radio";
    element.name = data.fieldName;
    if (value) {
      element.setAttribute("checked", true);
    }
    element.tabIndex = DEFAULT_TAB_INDEX;
    element.addEventListener("change", event => {
      const {
        name,
        checked
      } = event.target;
      for (const radio of this._getElementsByName(name, id)) {
        storage.setValue(radio.id, {
          value: false
        });
        window.updateAngularFormValue(radio.id, {
          value: false
        });
      }
      storage.setValue(id, {
        value: checked
      });
      window.updateAngularFormValue(id, {
        value: checked
      });
    });
    element.addEventListener("resetform", event => {
      const defaultValue = data.defaultFieldValue;
      event.target.checked = defaultValue !== null && defaultValue !== undefined && defaultValue === data.buttonValue;
    });
    window.registerAcroformField(id, element, value ? data.buttonValue : undefined, data.buttonValue, this.data.fieldValue);
    element.addEventListener("updateFromAngular", newvalue => storage.setValue(id, {
      value: newvalue.detail
    }));
    if (this.enableScripting && this.hasJSActions) {
      const pdfButtonValue = data.buttonValue;
      element.addEventListener("updatefromsandbox", jsEvent => {
        const actions = {
          value: event => {
            const checked = pdfButtonValue === event.detail.value;
            for (const radio of this._getElementsByName(event.target.name)) {
              const curChecked = checked && radio.id === id;
              if (radio.domElement) {
                radio.domElement.checked = curChecked;
              }
              storage.setValue(radio.id, {
                value: curChecked
              });
              window.updateAngularFormValue(id, {
                value: curChecked
              });
            }
          }
        };
        this._dispatchEventFromSandbox(actions, jsEvent);
      });
      this._setEventListeners(element, null, [["change", "Validate"], ["change", "Action"], ["focus", "Focus"], ["blur", "Blur"], ["mousedown", "Mouse Down"], ["mouseenter", "Mouse Enter"], ["mouseleave", "Mouse Exit"], ["mouseup", "Mouse Up"]], event => event.target.checked);
    }
    this._setBackgroundColor(element);
    this._setDefaultPropertiesFromJS(element);
    this.container.append(element);
    return this.container;
  }
}
class PushButtonWidgetAnnotationElement extends LinkAnnotationElement {
  constructor(parameters) {
    super(parameters, {
      ignoreBorder: parameters.data.hasAppearance
    });
  }
  render() {
    const container = super.render();
    container.classList.add("buttonWidgetAnnotation", "pushButton");
    const linkElement = container.lastChild;
    if (this.enableScripting && this.hasJSActions && linkElement) {
      this._setDefaultPropertiesFromJS(linkElement);
      linkElement.addEventListener("updatefromsandbox", jsEvent => {
        this._dispatchEventFromSandbox({}, jsEvent);
      });
    }
    return container;
  }
}
class ChoiceWidgetAnnotationElement extends WidgetAnnotationElement {
  constructor(parameters) {
    super(parameters, {
      isRenderable: parameters.renderForms
    });
  }
  render() {
    this.container.classList.add("choiceWidgetAnnotation");
    const storage = this.annotationStorage;
    const id = this.data.id;
    const angularData = window.getFormValueFromAngular(this.data.fieldName);
    const formData = storage.getValue(id, {
      value: this.data.fieldValue
    });
    const storedData = angularData.value ? angularData : formData;
    if (angularData !== formData) {
      storage.setValue(id, {
        value: angularData.value
      });
    }
    const selectElement = document.createElement("select");
    GetElementsByNameSet.add(selectElement);
    selectElement.setAttribute("data-element-id", id);
    selectElement.disabled = this.data.readOnly;
    this._setRequired(selectElement, this.data.required);
    selectElement.name = this.data.fieldName;
    selectElement.tabIndex = DEFAULT_TAB_INDEX;
    let addAnEmptyEntry = this.data.combo && this.data.options.length > 0;
    if (!this.data.combo) {
      selectElement.size = this.data.options.length;
      if (this.data.multiSelect) {
        selectElement.multiple = true;
      }
    }
    selectElement.addEventListener("resetform", event => {
      const defaultValue = this.data.defaultFieldValue;
      for (const option of selectElement.options) {
        option.selected = option.value === defaultValue;
      }
    });
    for (const option of this.data.options) {
      const optionElement = document.createElement("option");
      optionElement.textContent = option.displayValue;
      optionElement.value = option.exportValue;
      if (storedData.value.includes(option.exportValue)) {
        optionElement.setAttribute("selected", true);
        addAnEmptyEntry = false;
      }
      selectElement.append(optionElement);
    }
    let removeEmptyEntry = null;
    if (addAnEmptyEntry) {
      const noneOptionElement = document.createElement("option");
      noneOptionElement.value = " ";
      noneOptionElement.setAttribute("hidden", true);
      noneOptionElement.setAttribute("selected", true);
      selectElement.prepend(noneOptionElement);
      removeEmptyEntry = () => {
        noneOptionElement.remove();
        selectElement.removeEventListener("input", removeEmptyEntry);
        removeEmptyEntry = null;
      };
      selectElement.addEventListener("input", removeEmptyEntry);
    }
    const getValue = isExport => {
      const name = isExport ? "value" : "textContent";
      const {
        options,
        multiple
      } = selectElement;
      if (!multiple) {
        return options.selectedIndex === -1 ? null : options[options.selectedIndex][name];
      }
      return Array.prototype.filter.call(options, option => option.selected).map(option => option[name]);
    };
    let selectedValues = getValue(false);
    const getItems = event => {
      const options = event.target.options;
      return Array.prototype.map.call(options, option => ({
        displayValue: option.textContent,
        exportValue: option.value
      }));
    };
    window.registerAcroformField(id, selectElement, selectedValues, undefined, this.data.fieldValue);
    selectElement.addEventListener("updateFromAngular", newvalue => storage.setValue(id, {
      value: newvalue.detail
    }));
    if (this.enableScripting && this.hasJSActions) {
      selectElement.addEventListener("updatefromsandbox", jsEvent => {
        const actions = {
          value(event) {
            removeEmptyEntry?.();
            const value = event.detail.value;
            const values = new Set(Array.isArray(value) ? value : [value]);
            for (const option of selectElement.options) {
              option.selected = values.has(option.value);
            }
            storage.setValue(id, {
              value: getValue(true)
            });
            selectedValues = getValue(false);
            window.updateAngularFormValue(id, {
              value: selectedValues
            });
          },
          multipleSelection(event) {
            selectElement.multiple = true;
          },
          remove(event) {
            const options = selectElement.options;
            const index = event.detail.remove;
            options[index].selected = false;
            selectElement.remove(index);
            if (options.length > 0) {
              const i = Array.prototype.findIndex.call(options, option => option.selected);
              if (i === -1) {
                options[0].selected = true;
              }
            }
            storage.setValue(id, {
              value: getValue(true),
              items: getItems(event)
            });
            selectedValues = getValue(false);
          },
          clear(event) {
            while (selectElement.length !== 0) {
              selectElement.remove(0);
            }
            storage.setValue(id, {
              value: null,
              items: []
            });
            selectedValues = getValue(false);
            window.updateAngularFormValue(id, {
              value: selectedValues
            });
          },
          insert(event) {
            const {
              index,
              displayValue,
              exportValue
            } = event.detail.insert;
            const selectChild = selectElement.children[index];
            const optionElement = document.createElement("option");
            optionElement.textContent = displayValue;
            optionElement.value = exportValue;
            if (selectChild) {
              selectChild.before(optionElement);
            } else {
              selectElement.append(optionElement);
            }
            storage.setValue(id, {
              value: getValue(true),
              items: getItems(event)
            });
            selectedValues = getValue(false);
            window.updateAngularFormValue(id, {
              value: selectedValues
            });
          },
          items(event) {
            const {
              items
            } = event.detail;
            while (selectElement.length !== 0) {
              selectElement.remove(0);
            }
            for (const item of items) {
              const {
                displayValue,
                exportValue
              } = item;
              const optionElement = document.createElement("option");
              optionElement.textContent = displayValue;
              optionElement.value = exportValue;
              selectElement.append(optionElement);
            }
            if (selectElement.options.length > 0) {
              selectElement.options[0].selected = true;
            }
            storage.setValue(id, {
              value: getValue(true),
              items: getItems(event)
            });
            selectedValues = getValue(false);
            window.updateAngularFormValue(id, {
              value: selectedValues
            });
          },
          indices(event) {
            const indices = new Set(event.detail.indices);
            for (const option of event.target.options) {
              option.selected = indices.has(option.index);
            }
            storage.setValue(id, {
              value: getValue(true)
            });
            selectedValues = getValue(false);
            window.updateAngularFormValue(id, {
              value: selectedValues
            });
          },
          editable(event) {
            event.target.disabled = !event.detail.editable;
          }
        };
        this._dispatchEventFromSandbox(actions, jsEvent);
      });
      selectElement.addEventListener("input", event => {
        const exportValue = getValue(true);
        const change = getValue(false);
        storage.setValue(id, {
          value: exportValue
        });
        window.updateAngularFormValue(id, {
          value: exportValue
        });
        event.preventDefault();
        this.linkService.eventBus?.dispatch("dispatcheventinsandbox", {
          source: this,
          detail: {
            id,
            name: "Keystroke",
            value: selectedValues,
            change,
            changeEx: exportValue,
            willCommit: false,
            commitKey: 1,
            keyDown: false
          }
        });
      });
      this._setEventListeners(selectElement, null, [["focus", "Focus"], ["blur", "Blur"], ["mousedown", "Mouse Down"], ["mouseenter", "Mouse Enter"], ["mouseleave", "Mouse Exit"], ["mouseup", "Mouse Up"], ["input", "Action"], ["input", "Validate"]], event => event.target.value);
    } else {
      selectElement.addEventListener("input", function (event) {
        storage.setValue(id, {
          value: getValue(true)
        });
        window.updateAngularFormValue(id, {
          value: getValue(true)
        });
      });
    }
    if (this.data.combo) {
      this._setTextStyle(selectElement);
    } else {}
    this._setBackgroundColor(selectElement);
    this._setDefaultPropertiesFromJS(selectElement);
    this.container.append(selectElement);
    return this.container;
  }
}
class PopupAnnotationElement extends AnnotationElement {
  constructor(parameters) {
    const {
      data,
      elements
    } = parameters;
    super(parameters, {
      isRenderable: AnnotationElement._hasPopupData(data)
    });
    this.elements = elements;
    this.popup = null;
  }
  render() {
    this.container.classList.add("popupAnnotation");
    const popup = this.popup = new PopupElement({
      container: this.container,
      color: this.data.color,
      titleObj: this.data.titleObj,
      modificationDate: this.data.modificationDate,
      contentsObj: this.data.contentsObj,
      richText: this.data.richText,
      rect: this.data.rect,
      parentRect: this.data.parentRect || null,
      parent: this.parent,
      elements: this.elements,
      open: this.data.open
    });
    const elementIds = [];
    for (const element of this.elements) {
      element.popup = popup;
      element.container.ariaHasPopup = "dialog";
      elementIds.push(element.data.id);
      element.addHighlightArea();
    }
    this.container.setAttribute("aria-controls", elementIds.map(id => `${AnnotationPrefix}${id}`).join(","));
    return this.container;
  }
}
var _boundKeyDown = /*#__PURE__*/new WeakMap();
var _boundHide = /*#__PURE__*/new WeakMap();
var _boundShow = /*#__PURE__*/new WeakMap();
var _boundToggle = /*#__PURE__*/new WeakMap();
var _color = /*#__PURE__*/new WeakMap();
var annotation_layer_container = /*#__PURE__*/new WeakMap();
var _contentsObj = /*#__PURE__*/new WeakMap();
var _dateObj = /*#__PURE__*/new WeakMap();
var _elements = /*#__PURE__*/new WeakMap();
var _parent = /*#__PURE__*/new WeakMap();
var _parentRect = /*#__PURE__*/new WeakMap();
var _pinned = /*#__PURE__*/new WeakMap();
var _popup = /*#__PURE__*/new WeakMap();
var annotation_layer_position = /*#__PURE__*/new WeakMap();
var _rect = /*#__PURE__*/new WeakMap();
var _richText = /*#__PURE__*/new WeakMap();
var _titleObj = /*#__PURE__*/new WeakMap();
var _updates2 = /*#__PURE__*/new WeakMap();
var _wasVisible = /*#__PURE__*/new WeakMap();
var _PopupElement_brand = /*#__PURE__*/new WeakSet();
class PopupElement {
  constructor(_ref2) {
    let {
      container,
      color,
      elements,
      titleObj,
      modificationDate,
      contentsObj: _contentsObj2,
      richText: _richText2,
      parent,
      rect: _rect2,
      parentRect,
      open
    } = _ref2;
    annotation_layer_classPrivateMethodInitSpec(this, _PopupElement_brand);
    annotation_layer_classPrivateFieldInitSpec(this, _boundKeyDown, annotation_layer_assertClassBrand(_PopupElement_brand, this, _keyDown).bind(this));
    annotation_layer_classPrivateFieldInitSpec(this, _boundHide, annotation_layer_assertClassBrand(_PopupElement_brand, this, _hide).bind(this));
    annotation_layer_classPrivateFieldInitSpec(this, _boundShow, annotation_layer_assertClassBrand(_PopupElement_brand, this, _show).bind(this));
    annotation_layer_classPrivateFieldInitSpec(this, _boundToggle, annotation_layer_assertClassBrand(_PopupElement_brand, this, _toggle).bind(this));
    annotation_layer_classPrivateFieldInitSpec(this, _color, null);
    annotation_layer_classPrivateFieldInitSpec(this, annotation_layer_container, null);
    annotation_layer_classPrivateFieldInitSpec(this, _contentsObj, null);
    annotation_layer_classPrivateFieldInitSpec(this, _dateObj, null);
    annotation_layer_classPrivateFieldInitSpec(this, _elements, null);
    annotation_layer_classPrivateFieldInitSpec(this, _parent, null);
    annotation_layer_classPrivateFieldInitSpec(this, _parentRect, null);
    annotation_layer_classPrivateFieldInitSpec(this, _pinned, false);
    annotation_layer_classPrivateFieldInitSpec(this, _popup, null);
    annotation_layer_classPrivateFieldInitSpec(this, annotation_layer_position, null);
    annotation_layer_classPrivateFieldInitSpec(this, _rect, null);
    annotation_layer_classPrivateFieldInitSpec(this, _richText, null);
    annotation_layer_classPrivateFieldInitSpec(this, _titleObj, null);
    annotation_layer_classPrivateFieldInitSpec(this, _updates2, null);
    annotation_layer_classPrivateFieldInitSpec(this, _wasVisible, false);
    annotation_layer_classPrivateFieldSet(annotation_layer_container, this, container);
    annotation_layer_classPrivateFieldSet(_titleObj, this, titleObj);
    annotation_layer_classPrivateFieldSet(_contentsObj, this, _contentsObj2);
    annotation_layer_classPrivateFieldSet(_richText, this, _richText2);
    annotation_layer_classPrivateFieldSet(_parent, this, parent);
    annotation_layer_classPrivateFieldSet(_color, this, color);
    annotation_layer_classPrivateFieldSet(_rect, this, _rect2);
    annotation_layer_classPrivateFieldSet(_parentRect, this, parentRect);
    annotation_layer_classPrivateFieldSet(_elements, this, elements);
    annotation_layer_classPrivateFieldSet(_dateObj, this, PDFDateString.toDateObject(modificationDate));
    this.trigger = elements.flatMap(e => e.getElementsToTriggerPopup());
    for (const element of this.trigger) {
      element.addEventListener("click", annotation_layer_classPrivateFieldGet(_boundToggle, this));
      element.addEventListener("mouseenter", annotation_layer_classPrivateFieldGet(_boundShow, this));
      element.addEventListener("mouseleave", annotation_layer_classPrivateFieldGet(_boundHide, this));
      element.classList.add("popupTriggerArea");
    }
    for (const element of elements) {
      element.container?.addEventListener("keydown", annotation_layer_classPrivateFieldGet(_boundKeyDown, this));
    }
    annotation_layer_classPrivateFieldGet(annotation_layer_container, this).hidden = true;
    if (open) {
      annotation_layer_assertClassBrand(_PopupElement_brand, this, _toggle).call(this);
    }
  }
  render() {
    if (annotation_layer_classPrivateFieldGet(_popup, this)) {
      return;
    }
    const popup = annotation_layer_classPrivateFieldSet(_popup, this, document.createElement("div"));
    popup.className = "popup";
    if (annotation_layer_classPrivateFieldGet(_color, this)) {
      const baseColor = popup.style.outlineColor = Util.makeHexColor(...annotation_layer_classPrivateFieldGet(_color, this));
      popup.style.backgroundColor = `color-mix(in srgb, ${baseColor} 30%, white)`;
    }
    const header = document.createElement("span");
    header.className = "header";
    const title = document.createElement("h1");
    header.append(title);
    ({
      dir: title.dir,
      str: title.textContent
    } = annotation_layer_classPrivateFieldGet(_titleObj, this));
    popup.append(header);
    if (annotation_layer_classPrivateFieldGet(_dateObj, this)) {
      const modificationDate = document.createElement("span");
      modificationDate.classList.add("popupDate");
      modificationDate.setAttribute("data-l10n-id", "pdfjs-annotation-date-time-string");
      modificationDate.setAttribute("data-l10n-args", JSON.stringify({
        dateObj: annotation_layer_classPrivateFieldGet(_dateObj, this).valueOf()
      }));
      header.append(modificationDate);
    }
    const html = annotation_layer_classPrivateGetter(_PopupElement_brand, this, _get_html);
    if (html) {
      XfaLayer.render({
        xfaHtml: html,
        intent: "richText",
        div: popup
      });
      popup.lastChild.classList.add("richText", "popupContent");
    } else {
      const contents = this._formatContents(annotation_layer_classPrivateFieldGet(_contentsObj, this));
      popup.append(contents);
    }
    annotation_layer_classPrivateFieldGet(annotation_layer_container, this).append(popup);
  }
  _formatContents(_ref3) {
    let {
      str,
      dir
    } = _ref3;
    const p = document.createElement("p");
    p.classList.add("popupContent");
    p.dir = dir;
    const lines = str.split(/(?:\r\n?|\n)/);
    for (let i = 0, ii = lines.length; i < ii; ++i) {
      const line = lines[i];
      p.append(document.createTextNode(line));
      if (i < ii - 1) {
        p.append(document.createElement("br"));
      }
    }
    return p;
  }
  updateEdited(_ref4) {
    let {
      rect,
      popupContent
    } = _ref4;
    annotation_layer_classPrivateFieldGet(_updates2, this) || annotation_layer_classPrivateFieldSet(_updates2, this, {
      contentsObj: annotation_layer_classPrivateFieldGet(_contentsObj, this),
      richText: annotation_layer_classPrivateFieldGet(_richText, this)
    });
    if (rect) {
      annotation_layer_classPrivateFieldSet(annotation_layer_position, this, null);
    }
    if (popupContent) {
      annotation_layer_classPrivateFieldSet(_richText, this, annotation_layer_assertClassBrand(_PopupElement_brand, this, _makePopupContent).call(this, popupContent));
      annotation_layer_classPrivateFieldSet(_contentsObj, this, null);
    }
    annotation_layer_classPrivateFieldGet(_popup, this)?.remove();
    annotation_layer_classPrivateFieldSet(_popup, this, null);
  }
  resetEdited() {
    if (!annotation_layer_classPrivateFieldGet(_updates2, this)) {
      return;
    }
    ({
      contentsObj: _toSetter(annotation_layer_classPrivateFieldSet, [_contentsObj, this])._,
      richText: _toSetter(annotation_layer_classPrivateFieldSet, [_richText, this])._
    } = annotation_layer_classPrivateFieldGet(_updates2, this));
    annotation_layer_classPrivateFieldSet(_updates2, this, null);
    annotation_layer_classPrivateFieldGet(_popup, this)?.remove();
    annotation_layer_classPrivateFieldSet(_popup, this, null);
    annotation_layer_classPrivateFieldSet(annotation_layer_position, this, null);
  }
  forceHide() {
    annotation_layer_classPrivateFieldSet(_wasVisible, this, this.isVisible);
    if (!annotation_layer_classPrivateFieldGet(_wasVisible, this)) {
      return;
    }
    annotation_layer_classPrivateFieldGet(annotation_layer_container, this).hidden = true;
  }
  maybeShow() {
    if (!annotation_layer_classPrivateFieldGet(_wasVisible, this)) {
      return;
    }
    if (!annotation_layer_classPrivateFieldGet(_popup, this)) {
      annotation_layer_assertClassBrand(_PopupElement_brand, this, _show).call(this);
    }
    annotation_layer_classPrivateFieldSet(_wasVisible, this, false);
    annotation_layer_classPrivateFieldGet(annotation_layer_container, this).hidden = false;
  }
  get isVisible() {
    return annotation_layer_classPrivateFieldGet(annotation_layer_container, this).hidden === false;
  }
}
function _get_html(_this) {
  const richText = annotation_layer_classPrivateFieldGet(_richText, _this);
  const contentsObj = annotation_layer_classPrivateFieldGet(_contentsObj, _this);
  if (richText?.str && (!contentsObj?.str || contentsObj.str === richText.str)) {
    return annotation_layer_classPrivateFieldGet(_richText, _this).html || null;
  }
  return null;
}
function _get_fontSize(_this2) {
  return annotation_layer_classPrivateGetter(_PopupElement_brand, _this2, _get_html)?.attributes?.style?.fontSize || 0;
}
function _get_fontColor(_this3) {
  return annotation_layer_classPrivateGetter(_PopupElement_brand, _this3, _get_html)?.attributes?.style?.color || null;
}
function _makePopupContent(text) {
  const popupLines = [];
  const popupContent = {
    str: text,
    html: {
      name: "div",
      attributes: {
        dir: "auto"
      },
      children: [{
        name: "p",
        children: popupLines
      }]
    }
  };
  const lineAttributes = {
    style: {
      color: annotation_layer_classPrivateGetter(_PopupElement_brand, this, _get_fontColor),
      fontSize: annotation_layer_classPrivateGetter(_PopupElement_brand, this, _get_fontSize) ? `calc(${annotation_layer_classPrivateGetter(_PopupElement_brand, this, _get_fontSize)}px * var(--total-scale-factor))` : ""
    }
  };
  for (const line of text.split("\n")) {
    popupLines.push({
      name: "span",
      value: line,
      attributes: lineAttributes
    });
  }
  return popupContent;
}
function _keyDown(event) {
  if (event.altKey || event.shiftKey || event.ctrlKey || event.metaKey) {
    return;
  }
  if (event.key === "Enter" || event.key === "Escape" && annotation_layer_classPrivateFieldGet(_pinned, this)) {
    annotation_layer_assertClassBrand(_PopupElement_brand, this, _toggle).call(this);
  }
}
function _setPosition() {
  if (annotation_layer_classPrivateFieldGet(annotation_layer_position, this) !== null) {
    return;
  }
  const {
    page: {
      view
    },
    viewport: {
      rawDims: {
        pageWidth,
        pageHeight,
        pageX,
        pageY
      }
    }
  } = annotation_layer_classPrivateFieldGet(_parent, this);
  let useParentRect = !!annotation_layer_classPrivateFieldGet(_parentRect, this);
  let rect = useParentRect ? annotation_layer_classPrivateFieldGet(_parentRect, this) : annotation_layer_classPrivateFieldGet(_rect, this);
  for (const element of annotation_layer_classPrivateFieldGet(_elements, this)) {
    if (!rect || Util.intersect(element.data.rect, rect) !== null) {
      rect = element.data.rect;
      useParentRect = true;
      break;
    }
  }
  const normalizedRect = Util.normalizeRect([rect[0], view[3] - rect[1] + view[1], rect[2], view[3] - rect[3] + view[1]]);
  const HORIZONTAL_SPACE_AFTER_ANNOTATION = 5;
  const parentWidth = useParentRect ? rect[2] - rect[0] + HORIZONTAL_SPACE_AFTER_ANNOTATION : 0;
  const popupLeft = normalizedRect[0] + parentWidth;
  const popupTop = normalizedRect[1];
  annotation_layer_classPrivateFieldSet(annotation_layer_position, this, [100 * (popupLeft - pageX) / pageWidth, 100 * (popupTop - pageY) / pageHeight]);
  const {
    style
  } = annotation_layer_classPrivateFieldGet(annotation_layer_container, this);
  style.left = `${annotation_layer_classPrivateFieldGet(annotation_layer_position, this)[0]}%`;
  style.top = `${annotation_layer_classPrivateFieldGet(annotation_layer_position, this)[1]}%`;
}
function _toggle() {
  annotation_layer_classPrivateFieldSet(_pinned, this, !annotation_layer_classPrivateFieldGet(_pinned, this));
  if (annotation_layer_classPrivateFieldGet(_pinned, this)) {
    annotation_layer_assertClassBrand(_PopupElement_brand, this, _show).call(this);
    annotation_layer_classPrivateFieldGet(annotation_layer_container, this).addEventListener("click", annotation_layer_classPrivateFieldGet(_boundToggle, this));
    annotation_layer_classPrivateFieldGet(annotation_layer_container, this).addEventListener("keydown", annotation_layer_classPrivateFieldGet(_boundKeyDown, this));
  } else {
    annotation_layer_assertClassBrand(_PopupElement_brand, this, _hide).call(this);
    annotation_layer_classPrivateFieldGet(annotation_layer_container, this).removeEventListener("click", annotation_layer_classPrivateFieldGet(_boundToggle, this));
    annotation_layer_classPrivateFieldGet(annotation_layer_container, this).removeEventListener("keydown", annotation_layer_classPrivateFieldGet(_boundKeyDown, this));
  }
}
function _show() {
  if (!annotation_layer_classPrivateFieldGet(_popup, this)) {
    this.render();
  }
  if (!this.isVisible) {
    annotation_layer_assertClassBrand(_PopupElement_brand, this, _setPosition).call(this);
    annotation_layer_classPrivateFieldGet(annotation_layer_container, this).hidden = false;
    annotation_layer_classPrivateFieldGet(annotation_layer_container, this).style.zIndex = parseInt(annotation_layer_classPrivateFieldGet(annotation_layer_container, this).style.zIndex) + 1000;
    const page = annotation_layer_classPrivateFieldGet(annotation_layer_container, this).closest(".page");
    if (page) {
      page.style.overflow = "visible";
    }
  } else if (annotation_layer_classPrivateFieldGet(_pinned, this)) {
    annotation_layer_classPrivateFieldGet(annotation_layer_container, this).classList.add("focused");
  }
}
function _hide() {
  annotation_layer_classPrivateFieldGet(annotation_layer_container, this).classList.remove("focused");
  if (annotation_layer_classPrivateFieldGet(_pinned, this) || !this.isVisible) {
    return;
  }
  annotation_layer_classPrivateFieldGet(annotation_layer_container, this).hidden = true;
  annotation_layer_classPrivateFieldGet(annotation_layer_container, this).style.zIndex = parseInt(annotation_layer_classPrivateFieldGet(annotation_layer_container, this).style.zIndex) - 1000;
  const page = annotation_layer_classPrivateFieldGet(annotation_layer_container, this).closest(".page");
  if (page) {
    page.style.overflow = "";
  }
}
class FreeTextAnnotationElement extends AnnotationElement {
  constructor(parameters) {
    super(parameters, {
      isRenderable: true,
      ignoreBorder: true
    });
    this.textContent = parameters.data.textContent;
    this.textPosition = parameters.data.textPosition;
    this.annotationEditorType = AnnotationEditorType.FREETEXT;
  }
  render() {
    this.container.classList.add("freeTextAnnotation");
    if (this.textContent) {
      const content = document.createElement("div");
      content.classList.add("annotationTextContent");
      content.setAttribute("role", "comment");
      for (const line of this.textContent) {
        const lineSpan = document.createElement("span");
        lineSpan.textContent = line;
        content.append(lineSpan);
      }
      this.container.append(content);
    }
    if (!this.data.popupRef && this.hasPopupData) {
      this._createPopup();
    }
    this._editOnDoubleClick();
    return this.container;
  }
}
var _line = /*#__PURE__*/new WeakMap();
class LineAnnotationElement extends AnnotationElement {
  constructor(parameters) {
    super(parameters, {
      isRenderable: true,
      ignoreBorder: true
    });
    annotation_layer_classPrivateFieldInitSpec(this, _line, null);
  }
  render() {
    this.container.classList.add("lineAnnotation");
    const {
      data,
      width,
      height
    } = this;
    const svg = this.svgFactory.create(width, height, true);
    const line = annotation_layer_classPrivateFieldSet(_line, this, this.svgFactory.createElement("svg:line"));
    line.setAttribute("x1", data.rect[2] - data.lineCoordinates[0]);
    line.setAttribute("y1", data.rect[3] - data.lineCoordinates[1]);
    line.setAttribute("x2", data.rect[2] - data.lineCoordinates[2]);
    line.setAttribute("y2", data.rect[3] - data.lineCoordinates[3]);
    line.setAttribute("stroke-width", data.borderStyle.width || 1);
    line.setAttribute("stroke", "transparent");
    line.setAttribute("fill", "transparent");
    svg.append(line);
    this.container.append(svg);
    if (!data.popupRef && this.hasPopupData) {
      this._createPopup();
    }
    return this.container;
  }
  getElementsToTriggerPopup() {
    return annotation_layer_classPrivateFieldGet(_line, this);
  }
  addHighlightArea() {
    this.container.classList.add("highlightArea");
  }
}
var _square = /*#__PURE__*/new WeakMap();
class SquareAnnotationElement extends AnnotationElement {
  constructor(parameters) {
    super(parameters, {
      isRenderable: true,
      ignoreBorder: true
    });
    annotation_layer_classPrivateFieldInitSpec(this, _square, null);
  }
  render() {
    this.container.classList.add("squareAnnotation");
    const {
      data,
      width,
      height
    } = this;
    const svg = this.svgFactory.create(width, height, true);
    const borderWidth = data.borderStyle.width;
    const square = annotation_layer_classPrivateFieldSet(_square, this, this.svgFactory.createElement("svg:rect"));
    square.setAttribute("x", borderWidth / 2);
    square.setAttribute("y", borderWidth / 2);
    square.setAttribute("width", width - borderWidth);
    square.setAttribute("height", height - borderWidth);
    square.setAttribute("stroke-width", borderWidth || 1);
    square.setAttribute("stroke", "transparent");
    square.setAttribute("fill", "transparent");
    svg.append(square);
    this.container.append(svg);
    if (!data.popupRef && this.hasPopupData) {
      this._createPopup();
    }
    return this.container;
  }
  getElementsToTriggerPopup() {
    return annotation_layer_classPrivateFieldGet(_square, this);
  }
  addHighlightArea() {
    this.container.classList.add("highlightArea");
  }
}
var _circle = /*#__PURE__*/new WeakMap();
class CircleAnnotationElement extends AnnotationElement {
  constructor(parameters) {
    super(parameters, {
      isRenderable: true,
      ignoreBorder: true
    });
    annotation_layer_classPrivateFieldInitSpec(this, _circle, null);
  }
  render() {
    this.container.classList.add("circleAnnotation");
    const {
      data,
      width,
      height
    } = this;
    const svg = this.svgFactory.create(width, height, true);
    const borderWidth = data.borderStyle.width;
    const circle = annotation_layer_classPrivateFieldSet(_circle, this, this.svgFactory.createElement("svg:ellipse"));
    circle.setAttribute("cx", width / 2);
    circle.setAttribute("cy", height / 2);
    circle.setAttribute("rx", width / 2 - borderWidth / 2);
    circle.setAttribute("ry", height / 2 - borderWidth / 2);
    circle.setAttribute("stroke-width", borderWidth || 1);
    circle.setAttribute("stroke", "transparent");
    circle.setAttribute("fill", "transparent");
    svg.append(circle);
    this.container.append(svg);
    if (!data.popupRef && this.hasPopupData) {
      this._createPopup();
    }
    return this.container;
  }
  getElementsToTriggerPopup() {
    return annotation_layer_classPrivateFieldGet(_circle, this);
  }
  addHighlightArea() {
    this.container.classList.add("highlightArea");
  }
}
var _polyline = /*#__PURE__*/new WeakMap();
class PolylineAnnotationElement extends AnnotationElement {
  constructor(parameters) {
    super(parameters, {
      isRenderable: true,
      ignoreBorder: true
    });
    annotation_layer_classPrivateFieldInitSpec(this, _polyline, null);
    this.containerClassName = "polylineAnnotation";
    this.svgElementName = "svg:polyline";
  }
  render() {
    this.container.classList.add(this.containerClassName);
    const {
      data: {
        rect,
        vertices,
        borderStyle,
        popupRef
      },
      width,
      height
    } = this;
    if (!vertices) {
      return this.container;
    }
    const svg = this.svgFactory.create(width, height, true);
    let points = [];
    for (let i = 0, ii = vertices.length; i < ii; i += 2) {
      const x = vertices[i] - rect[0];
      const y = rect[3] - vertices[i + 1];
      points.push(`${x},${y}`);
    }
    points = points.join(" ");
    const polyline = annotation_layer_classPrivateFieldSet(_polyline, this, this.svgFactory.createElement(this.svgElementName));
    polyline.setAttribute("points", points);
    polyline.setAttribute("stroke-width", borderStyle.width || 1);
    polyline.setAttribute("stroke", "transparent");
    polyline.setAttribute("fill", "transparent");
    svg.append(polyline);
    this.container.append(svg);
    if (!popupRef && this.hasPopupData) {
      this._createPopup();
    }
    return this.container;
  }
  getElementsToTriggerPopup() {
    return annotation_layer_classPrivateFieldGet(_polyline, this);
  }
  addHighlightArea() {
    this.container.classList.add("highlightArea");
  }
}
class PolygonAnnotationElement extends PolylineAnnotationElement {
  constructor(parameters) {
    super(parameters);
    this.containerClassName = "polygonAnnotation";
    this.svgElementName = "svg:polygon";
  }
}
class CaretAnnotationElement extends AnnotationElement {
  constructor(parameters) {
    super(parameters, {
      isRenderable: true,
      ignoreBorder: true
    });
  }
  render() {
    this.container.classList.add("caretAnnotation");
    if (!this.data.popupRef && this.hasPopupData) {
      this._createPopup();
    }
    return this.container;
  }
}
var _polylinesGroupElement = /*#__PURE__*/new WeakMap();
var _polylines = /*#__PURE__*/new WeakMap();
var _InkAnnotationElement_brand = /*#__PURE__*/new WeakSet();
class InkAnnotationElement extends AnnotationElement {
  constructor(parameters) {
    super(parameters, {
      isRenderable: true,
      ignoreBorder: true
    });
    annotation_layer_classPrivateMethodInitSpec(this, _InkAnnotationElement_brand);
    annotation_layer_classPrivateFieldInitSpec(this, _polylinesGroupElement, null);
    annotation_layer_classPrivateFieldInitSpec(this, _polylines, []);
    this.containerClassName = "inkAnnotation";
    this.svgElementName = "svg:polyline";
    this.annotationEditorType = this.data.it === "InkHighlight" ? AnnotationEditorType.HIGHLIGHT : AnnotationEditorType.INK;
  }
  render() {
    this.container.classList.add(this.containerClassName);
    const {
      data: {
        rect,
        rotation,
        inkLists,
        borderStyle,
        popupRef
      }
    } = this;
    const {
      transform,
      width,
      height
    } = annotation_layer_assertClassBrand(_InkAnnotationElement_brand, this, _getTransform).call(this, rotation, rect);
    const svg = this.svgFactory.create(width, height, true);
    const g = annotation_layer_classPrivateFieldSet(_polylinesGroupElement, this, this.svgFactory.createElement("svg:g"));
    svg.append(g);
    g.setAttribute("stroke-width", borderStyle.width || 1);
    g.setAttribute("stroke-linecap", "round");
    g.setAttribute("stroke-linejoin", "round");
    g.setAttribute("stroke-miterlimit", 10);
    g.setAttribute("stroke", "transparent");
    g.setAttribute("fill", "transparent");
    g.setAttribute("transform", transform);
    for (let i = 0, ii = inkLists.length; i < ii; i++) {
      const polyline = this.svgFactory.createElement(this.svgElementName);
      annotation_layer_classPrivateFieldGet(_polylines, this).push(polyline);
      polyline.setAttribute("points", inkLists[i].join(","));
      g.append(polyline);
    }
    if (!popupRef && this.hasPopupData) {
      this._createPopup();
    }
    this.container.append(svg);
    this._editOnDoubleClick();
    return this.container;
  }
  updateEdited(params) {
    super.updateEdited(params);
    const {
      thickness,
      points,
      rect
    } = params;
    const g = annotation_layer_classPrivateFieldGet(_polylinesGroupElement, this);
    if (thickness >= 0) {
      g.setAttribute("stroke-width", thickness || 1);
    }
    if (points) {
      for (let i = 0, ii = annotation_layer_classPrivateFieldGet(_polylines, this).length; i < ii; i++) {
        annotation_layer_classPrivateFieldGet(_polylines, this)[i].setAttribute("points", points[i].join(","));
      }
    }
    if (rect) {
      const {
        transform,
        width,
        height
      } = annotation_layer_assertClassBrand(_InkAnnotationElement_brand, this, _getTransform).call(this, this.data.rotation, rect);
      const root = g.parentElement;
      root.setAttribute("viewBox", `0 0 ${width} ${height}`);
      g.setAttribute("transform", transform);
    }
  }
  getElementsToTriggerPopup() {
    return annotation_layer_classPrivateFieldGet(_polylines, this);
  }
  addHighlightArea() {
    this.container.classList.add("highlightArea");
  }
}
function _getTransform(rotation, rect) {
  switch (rotation) {
    case 90:
      return {
        transform: `rotate(90) translate(${-rect[0]},${rect[1]}) scale(1,-1)`,
        width: rect[3] - rect[1],
        height: rect[2] - rect[0]
      };
    case 180:
      return {
        transform: `rotate(180) translate(${-rect[2]},${rect[1]}) scale(1,-1)`,
        width: rect[2] - rect[0],
        height: rect[3] - rect[1]
      };
    case 270:
      return {
        transform: `rotate(270) translate(${-rect[2]},${rect[3]}) scale(1,-1)`,
        width: rect[3] - rect[1],
        height: rect[2] - rect[0]
      };
    default:
      return {
        transform: `translate(${-rect[0]},${rect[3]}) scale(1,-1)`,
        width: rect[2] - rect[0],
        height: rect[3] - rect[1]
      };
  }
}
class HighlightAnnotationElement extends AnnotationElement {
  constructor(parameters) {
    super(parameters, {
      isRenderable: true,
      ignoreBorder: true,
      createQuadrilaterals: true
    });
    this.annotationEditorType = AnnotationEditorType.HIGHLIGHT;
  }
  render() {
    if (!this.data.popupRef && this.hasPopupData) {
      this._createPopup();
    }
    this.container.classList.add("highlightAnnotation");
    this._editOnDoubleClick();
    return this.container;
  }
}
class UnderlineAnnotationElement extends AnnotationElement {
  constructor(parameters) {
    super(parameters, {
      isRenderable: true,
      ignoreBorder: true,
      createQuadrilaterals: true
    });
  }
  render() {
    if (!this.data.popupRef && this.hasPopupData) {
      this._createPopup();
    }
    this.container.classList.add("underlineAnnotation");
    return this.container;
  }
}
class SquigglyAnnotationElement extends AnnotationElement {
  constructor(parameters) {
    super(parameters, {
      isRenderable: true,
      ignoreBorder: true,
      createQuadrilaterals: true
    });
  }
  render() {
    if (!this.data.popupRef && this.hasPopupData) {
      this._createPopup();
    }
    this.container.classList.add("squigglyAnnotation");
    return this.container;
  }
}
class StrikeOutAnnotationElement extends AnnotationElement {
  constructor(parameters) {
    super(parameters, {
      isRenderable: true,
      ignoreBorder: true,
      createQuadrilaterals: true
    });
  }
  render() {
    if (!this.data.popupRef && this.hasPopupData) {
      this._createPopup();
    }
    this.container.classList.add("strikeoutAnnotation");
    return this.container;
  }
}
class StampAnnotationElement extends AnnotationElement {
  constructor(parameters) {
    super(parameters, {
      isRenderable: true,
      ignoreBorder: true
    });
    this.annotationEditorType = AnnotationEditorType.STAMP;
  }
  render() {
    this.container.classList.add("stampAnnotation");
    this.container.setAttribute("role", "img");
    if (!this.data.popupRef && this.hasPopupData) {
      this._createPopup();
    }
    this._editOnDoubleClick();
    return this.container;
  }
}
var _trigger = /*#__PURE__*/new WeakMap();
var _FileAttachmentAnnotationElement_brand = /*#__PURE__*/new WeakSet();
class FileAttachmentAnnotationElement extends AnnotationElement {
  constructor(parameters) {
    super(parameters, {
      isRenderable: true
    });
    annotation_layer_classPrivateMethodInitSpec(this, _FileAttachmentAnnotationElement_brand);
    annotation_layer_classPrivateFieldInitSpec(this, _trigger, null);
    const {
      file
    } = this.data;
    this.filename = file.filename;
    this.content = file.content;
    this.linkService.eventBus?.dispatch("fileattachmentannotation", {
      source: this,
      ...file
    });
  }
  render() {
    this.container.classList.add("fileAttachmentAnnotation");
    const {
      container,
      data
    } = this;
    let trigger;
    if (data.hasAppearance || data.fillAlpha === 0) {
      trigger = document.createElement("div");
    } else {
      trigger = document.createElement("img");
      trigger.src = `${this.imageResourcesPath}annotation-${/paperclip/i.test(data.name) ? "paperclip" : "pushpin"}.svg`;
      if (data.fillAlpha && data.fillAlpha < 1) {
        trigger.style = `filter: opacity(${Math.round(data.fillAlpha * 100)}%);`;
      }
    }
    trigger.addEventListener("dblclick", annotation_layer_assertClassBrand(_FileAttachmentAnnotationElement_brand, this, _download).bind(this));
    annotation_layer_classPrivateFieldSet(_trigger, this, trigger);
    const {
      isMac
    } = util_FeatureTest.platform;
    container.addEventListener("keydown", evt => {
      if (evt.key === "Enter" && (isMac ? evt.metaKey : evt.ctrlKey)) {
        annotation_layer_assertClassBrand(_FileAttachmentAnnotationElement_brand, this, _download).call(this);
      }
    });
    if (!data.popupRef && this.hasPopupData) {
      this._createPopup();
    } else {
      trigger.classList.add("popupTriggerArea");
    }
    container.append(trigger);
    return container;
  }
  getElementsToTriggerPopup() {
    return annotation_layer_classPrivateFieldGet(_trigger, this);
  }
  addHighlightArea() {
    this.container.classList.add("highlightArea");
  }
}
function _download() {
  this.downloadManager?.openOrDownloadData(this.content, this.filename);
}
var _accessibilityManager = /*#__PURE__*/new WeakMap();
var _annotationCanvasMap = /*#__PURE__*/new WeakMap();
var _editableAnnotations = /*#__PURE__*/new WeakMap();
var _structTreeLayer = /*#__PURE__*/new WeakMap();
var _AnnotationLayer_brand = /*#__PURE__*/new WeakSet();
class AnnotationLayer {
  constructor(_ref5) {
    let {
      div,
      accessibilityManager,
      annotationCanvasMap,
      annotationEditorUIManager,
      page,
      viewport,
      structTreeLayer
    } = _ref5;
    annotation_layer_classPrivateMethodInitSpec(this, _AnnotationLayer_brand);
    annotation_layer_classPrivateFieldInitSpec(this, _accessibilityManager, null);
    annotation_layer_classPrivateFieldInitSpec(this, _annotationCanvasMap, null);
    annotation_layer_classPrivateFieldInitSpec(this, _editableAnnotations, new Map());
    annotation_layer_classPrivateFieldInitSpec(this, _structTreeLayer, null);
    this.div = div;
    annotation_layer_classPrivateFieldSet(_accessibilityManager, this, accessibilityManager);
    annotation_layer_classPrivateFieldSet(_annotationCanvasMap, this, annotationCanvasMap);
    annotation_layer_classPrivateFieldSet(_structTreeLayer, this, structTreeLayer || null);
    this.page = page;
    this.viewport = viewport;
    this.zIndex = 0;
    this._annotationEditorUIManager = annotationEditorUIManager;
  }
  hasEditableAnnotations() {
    return annotation_layer_classPrivateFieldGet(_editableAnnotations, this).size > 0;
  }
  async render(params) {
    const {
      annotations
    } = params;
    const layer = this.div;
    setLayerDimensions(layer, this.viewport);
    const popupToElements = new Map();
    const elementParams = {
      data: null,
      layer,
      linkService: params.linkService,
      downloadManager: params.downloadManager,
      imageResourcesPath: params.imageResourcesPath || "",
      renderForms: params.renderForms !== false,
      svgFactory: new DOMSVGFactory(),
      annotationStorage: params.annotationStorage || new AnnotationStorage(),
      enableScripting: params.enableScripting === true,
      hasJSActions: params.hasJSActions,
      fieldObjects: params.fieldObjects,
      parent: this,
      elements: null
    };
    for (const data of annotations) {
      if (data.noHTML) {
        continue;
      }
      const isPopupAnnotation = data.annotationType === AnnotationType.POPUP;
      if (!isPopupAnnotation) {
        if (data.rect[2] === data.rect[0] || data.rect[3] === data.rect[1]) {
          continue;
        }
      } else {
        const elements = popupToElements.get(data.id);
        if (!elements) {
          continue;
        }
        elementParams.elements = elements;
      }
      elementParams.data = data;
      const element = AnnotationElementFactory.create(elementParams);
      if (!element.isRenderable) {
        continue;
      }
      if (!isPopupAnnotation && data.popupRef) {
        const elements = popupToElements.get(data.popupRef);
        if (!elements) {
          popupToElements.set(data.popupRef, [element]);
        } else {
          elements.push(element);
        }
      }
      const rendered = element.render();
      if (data.hidden) {
        rendered.style.visibility = "hidden";
      }
      await annotation_layer_assertClassBrand(_AnnotationLayer_brand, this, _appendElement).call(this, rendered, data.id);
      if (element._isEditable) {
        annotation_layer_classPrivateFieldGet(_editableAnnotations, this).set(element.data.id, element);
        this._annotationEditorUIManager?.renderAnnotationElement(element);
      }
    }
    annotation_layer_assertClassBrand(_AnnotationLayer_brand, this, _setAnnotationCanvasMap).call(this);
  }
  async addLinkAnnotations(annotations, linkService) {
    const elementParams = {
      data: null,
      layer: this.div,
      linkService,
      svgFactory: new DOMSVGFactory(),
      parent: this
    };
    for (const data of annotations) {
      data.borderStyle ||= AnnotationLayer._defaultBorderStyle;
      elementParams.data = data;
      const element = AnnotationElementFactory.create(elementParams);
      if (!element.isRenderable) {
        continue;
      }
      const rendered = element.render();
      await annotation_layer_assertClassBrand(_AnnotationLayer_brand, this, _appendElement).call(this, rendered, data.id);
    }
  }
  update(_ref6) {
    let {
      viewport
    } = _ref6;
    const layer = this.div;
    this.viewport = viewport;
    setLayerDimensions(layer, {
      rotation: viewport.rotation
    });
    annotation_layer_assertClassBrand(_AnnotationLayer_brand, this, _setAnnotationCanvasMap).call(this);
    layer.hidden = false;
  }
  getEditableAnnotations() {
    return Array.from(annotation_layer_classPrivateFieldGet(_editableAnnotations, this).values());
  }
  getEditableAnnotation(id) {
    return annotation_layer_classPrivateFieldGet(_editableAnnotations, this).get(id);
  }
  static get _defaultBorderStyle() {
    return shadow(this, "_defaultBorderStyle", Object.freeze({
      width: 1,
      rawWidth: 1,
      style: AnnotationBorderStyleType.SOLID,
      dashArray: [3],
      horizontalCornerRadius: 0,
      verticalCornerRadius: 0
    }));
  }
}
async function _appendElement(element, id) {
  const contentElement = element.firstChild || element;
  const annotationId = contentElement.id = `${AnnotationPrefix}${id}`;
  const ariaAttributes = await annotation_layer_classPrivateFieldGet(_structTreeLayer, this)?.getAriaAttributes(annotationId);
  if (ariaAttributes) {
    for (const [key, value] of ariaAttributes) {
      contentElement.setAttribute(key, value);
    }
  }
  this.div.append(element);
  annotation_layer_classPrivateFieldGet(_accessibilityManager, this)?.moveElementInDOM(this.div, element, contentElement, false);
}
function _setAnnotationCanvasMap() {
  if (!annotation_layer_classPrivateFieldGet(_annotationCanvasMap, this)) {
    return;
  }
  const layer = this.div;
  for (const [id, canvas] of annotation_layer_classPrivateFieldGet(_annotationCanvasMap, this)) {
    const element = layer.querySelector(`[data-annotation-id="${id}"]`);
    if (!element) {
      continue;
    }
    canvas.className = "annotationContent";
    const {
      firstChild
    } = element;
    if (!firstChild) {
      element.append(canvas);
    } else if (firstChild.nodeName === "CANVAS") {
      firstChild.replaceWith(canvas);
    } else if (!firstChild.classList.contains("annotationContent")) {
      firstChild.before(canvas);
    } else {
      firstChild.after(canvas);
    }
    const editableAnnotation = annotation_layer_classPrivateFieldGet(_editableAnnotations, this).get(id);
    if (!editableAnnotation) {
      continue;
    }
    if (editableAnnotation._hasNoCanvas) {
      this._annotationEditorUIManager?.setMissingCanvas(id, element.id, canvas);
      editableAnnotation._hasNoCanvas = false;
    } else {
      editableAnnotation.canvas = canvas;
    }
  }
  annotation_layer_classPrivateFieldGet(_annotationCanvasMap, this).clear();
}

;// ./src/display/editor/freetext.js
var _FreeTextEditor;




function freetext_classPrivateMethodInitSpec(e, a) { freetext_checkPrivateRedeclaration(e, a), a.add(e); }
function freetext_defineProperty(e, r, t) { return (r = freetext_toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function freetext_toPropertyKey(t) { var i = freetext_toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function freetext_toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function freetext_classPrivateFieldInitSpec(e, t, a) { freetext_checkPrivateRedeclaration(e, t), t.set(e, a); }
function freetext_checkPrivateRedeclaration(e, t) { if (t.has(e)) throw new TypeError("Cannot initialize the same private elements twice on an object"); }
function freetext_classPrivateFieldGet(s, a) { return s.get(freetext_assertClassBrand(s, a)); }
function freetext_classPrivateFieldSet(s, a, r) { return s.set(freetext_assertClassBrand(s, a), r), r; }
function freetext_assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); }




const EOL_PATTERN = /\r\n?|\n/g;
var freetext_color = /*#__PURE__*/new WeakMap();
var _content = /*#__PURE__*/new WeakMap();
var _editorDivId = /*#__PURE__*/new WeakMap();
var _editModeAC = /*#__PURE__*/new WeakMap();
var _fontSize = /*#__PURE__*/new WeakMap();
var _FreeTextEditor_brand = /*#__PURE__*/new WeakSet();
class FreeTextEditor extends AnnotationEditor {
  static get _keyboardManager() {
    const proto = FreeTextEditor.prototype;
    const arrowChecker = self => self.isEmpty();
    const small = AnnotationEditorUIManager.TRANSLATE_SMALL;
    const big = AnnotationEditorUIManager.TRANSLATE_BIG;
    return shadow(this, "_keyboardManager", new KeyboardManager([[["ctrl+s", "mac+meta+s", "ctrl+p", "mac+meta+p"], proto.commitOrRemove, {
      bubbles: true
    }], [["ctrl+Enter", "mac+meta+Enter", "Escape", "mac+Escape"], proto.commitOrRemove], [["ArrowLeft", "mac+ArrowLeft"], proto._translateEmpty, {
      args: [-small, 0],
      checker: arrowChecker
    }], [["ctrl+ArrowLeft", "mac+shift+ArrowLeft"], proto._translateEmpty, {
      args: [-big, 0],
      checker: arrowChecker
    }], [["ArrowRight", "mac+ArrowRight"], proto._translateEmpty, {
      args: [small, 0],
      checker: arrowChecker
    }], [["ctrl+ArrowRight", "mac+shift+ArrowRight"], proto._translateEmpty, {
      args: [big, 0],
      checker: arrowChecker
    }], [["ArrowUp", "mac+ArrowUp"], proto._translateEmpty, {
      args: [0, -small],
      checker: arrowChecker
    }], [["ctrl+ArrowUp", "mac+shift+ArrowUp"], proto._translateEmpty, {
      args: [0, -big],
      checker: arrowChecker
    }], [["ArrowDown", "mac+ArrowDown"], proto._translateEmpty, {
      args: [0, small],
      checker: arrowChecker
    }], [["ctrl+ArrowDown", "mac+shift+ArrowDown"], proto._translateEmpty, {
      args: [0, big],
      checker: arrowChecker
    }]]));
  }
  constructor(params) {
    super({
      ...params,
      name: "freeTextEditor"
    });
    freetext_classPrivateMethodInitSpec(this, _FreeTextEditor_brand);
    freetext_classPrivateFieldInitSpec(this, freetext_color, void 0);
    freetext_classPrivateFieldInitSpec(this, _content, "");
    freetext_classPrivateFieldInitSpec(this, _editorDivId, `${this.id}-editor`);
    freetext_classPrivateFieldInitSpec(this, _editModeAC, null);
    freetext_classPrivateFieldInitSpec(this, _fontSize, void 0);
    freetext_classPrivateFieldSet(freetext_color, this, params.color || FreeTextEditor._defaultColor || AnnotationEditor._defaultLineColor);
    freetext_classPrivateFieldSet(_fontSize, this, params.fontSize || FreeTextEditor._defaultFontSize);
  }
  static initialize(l10n, uiManager) {
    AnnotationEditor.initialize(l10n, uiManager);
    const style = getComputedStyle(document.documentElement);
    this._internalPadding = parseFloat(style.getPropertyValue("--freetext-padding"));
  }
  static updateDefaultParams(type, value) {
    switch (type) {
      case AnnotationEditorParamsType.FREETEXT_SIZE:
        FreeTextEditor._defaultFontSize = value;
        break;
      case AnnotationEditorParamsType.FREETEXT_COLOR:
        FreeTextEditor._defaultColor = value;
        break;
    }
  }
  updateParams(type, value) {
    switch (type) {
      case AnnotationEditorParamsType.FREETEXT_SIZE:
        freetext_assertClassBrand(_FreeTextEditor_brand, this, _updateFontSize).call(this, value);
        break;
      case AnnotationEditorParamsType.FREETEXT_COLOR:
        freetext_assertClassBrand(_FreeTextEditor_brand, this, _updateColor).call(this, value);
        break;
    }
  }
  static get defaultPropertiesToUpdate() {
    return [[AnnotationEditorParamsType.FREETEXT_SIZE, FreeTextEditor._defaultFontSize], [AnnotationEditorParamsType.FREETEXT_COLOR, FreeTextEditor._defaultColor || AnnotationEditor._defaultLineColor]];
  }
  get propertiesToUpdate() {
    return [[AnnotationEditorParamsType.FREETEXT_SIZE, freetext_classPrivateFieldGet(_fontSize, this)], [AnnotationEditorParamsType.FREETEXT_COLOR, freetext_classPrivateFieldGet(freetext_color, this)]];
  }
  _translateEmpty(x, y) {
    this._uiManager.translateSelectedEditors(x, y, true);
  }
  getInitialTranslation() {
    const scale = this.parentScale;
    return [-FreeTextEditor._internalPadding * scale, -(FreeTextEditor._internalPadding + freetext_classPrivateFieldGet(_fontSize, this)) * scale];
  }
  rebuild() {
    if (!this.parent) {
      return;
    }
    super.rebuild();
    if (this.div === null) {
      return;
    }
    if (!this.isAttachedToDOM) {
      this.parent.add(this);
    }
  }
  enableEditMode() {
    if (!super.enableEditMode()) {
      return false;
    }
    this.overlayDiv.classList.remove("enabled");
    this.editorDiv.contentEditable = true;
    this._isDraggable = false;
    this.div.removeAttribute("aria-activedescendant");
    freetext_classPrivateFieldSet(_editModeAC, this, new AbortController());
    const signal = this._uiManager.combinedSignal(freetext_classPrivateFieldGet(_editModeAC, this));
    this.editorDiv.addEventListener("keydown", this.editorDivKeydown.bind(this), {
      signal
    });
    this.editorDiv.addEventListener("focus", this.editorDivFocus.bind(this), {
      signal
    });
    this.editorDiv.addEventListener("blur", this.editorDivBlur.bind(this), {
      signal
    });
    this.editorDiv.addEventListener("input", this.editorDivInput.bind(this), {
      signal
    });
    this.editorDiv.addEventListener("paste", this.editorDivPaste.bind(this), {
      signal
    });
    return true;
  }
  disableEditMode() {
    if (!super.disableEditMode()) {
      return false;
    }
    this.overlayDiv.classList.add("enabled");
    this.editorDiv.contentEditable = false;
    this.div.setAttribute("aria-activedescendant", freetext_classPrivateFieldGet(_editorDivId, this));
    this._isDraggable = true;
    freetext_classPrivateFieldGet(_editModeAC, this)?.abort();
    freetext_classPrivateFieldSet(_editModeAC, this, null);
    this.div.focus({
      preventScroll: true
    });
    this.isEditing = false;
    this.parent.div.classList.add("freetextEditing");
    return true;
  }
  focusin(event) {
    if (!this._focusEventsAllowed) {
      return;
    }
    super.focusin(event);
    if (event.target !== this.editorDiv) {
      this.editorDiv.focus();
    }
  }
  onceAdded(focus) {
    if (this.width) {
      return;
    }
    this.enableEditMode();
    if (focus) {
      this.editorDiv.focus();
    }
    if (this._initialOptions?.isCentered) {
      this.center();
    }
    this._initialOptions = null;
  }
  isEmpty() {
    return !this.editorDiv || this.editorDiv.innerText.trim() === "";
  }
  remove() {
    this.isEditing = false;
    if (this.parent) {
      this.parent.setEditingState(true);
      this.parent.div.classList.add("freetextEditing");
    }
    super.remove();
  }
  commit() {
    if (!this.isInEditMode()) {
      return;
    }
    super.commit();
    this.disableEditMode();
    const savedText = freetext_classPrivateFieldGet(_content, this);
    const newText = freetext_classPrivateFieldSet(_content, this, freetext_assertClassBrand(_FreeTextEditor_brand, this, _extractText).call(this).trimEnd());
    if (savedText === newText) {
      return;
    }
    const setText = text => {
      freetext_classPrivateFieldSet(_content, this, text);
      if (!text) {
        this.remove();
        return;
      }
      freetext_assertClassBrand(_FreeTextEditor_brand, this, _setContent).call(this);
      this._uiManager.rebuild(this);
      freetext_assertClassBrand(_FreeTextEditor_brand, this, _setEditorDimensions).call(this);
    };
    this.addCommands({
      cmd: () => {
        setText(newText);
      },
      undo: () => {
        setText(savedText);
      },
      mustExec: false
    });
    freetext_assertClassBrand(_FreeTextEditor_brand, this, _setEditorDimensions).call(this);
    this.eventBus?.dispatch("annotation-editor-event", {
      source: this,
      type: "commit",
      page: this.pageIndex + 1,
      value: newText,
      previousValue: savedText
    });
  }
  shouldGetKeyboardEvents() {
    return this.isInEditMode();
  }
  enterInEditMode() {
    this.enableEditMode();
    this.editorDiv.focus();
  }
  keydown(event) {
    if (event.target === this.div && event.key === "Enter") {
      this.enterInEditMode();
      event.preventDefault();
    }
  }
  editorDivKeydown(event) {
    FreeTextEditor._keyboardManager.exec(this, event);
  }
  editorDivFocus(event) {
    this.isEditing = true;
  }
  editorDivBlur(event) {
    this.isEditing = false;
  }
  editorDivInput(event) {
    this.parent.div.classList.toggle("freetextEditing", this.isEmpty());
  }
  disableEditing() {
    this.editorDiv.setAttribute("role", "comment");
    this.editorDiv.removeAttribute("aria-multiline");
  }
  enableEditing() {
    this.editorDiv.setAttribute("role", "textbox");
    this.editorDiv.setAttribute("aria-multiline", true);
  }
  get canChangeContent() {
    return true;
  }
  render() {
    if (this.div) {
      return this.div;
    }
    let baseX, baseY;
    if (this._isCopy || this.annotationElementId) {
      baseX = this.x;
      baseY = this.y;
    }
    super.render();
    this.editorDiv = document.createElement("div");
    this.editorDiv.className = "internal";
    this.editorDiv.setAttribute("id", freetext_classPrivateFieldGet(_editorDivId, this));
    this.editorDiv.setAttribute("data-l10n-id", "pdfjs-free-text2");
    this.editorDiv.setAttribute("data-l10n-attrs", "default-content");
    this.enableEditing();
    this.editorDiv.contentEditable = true;
    const {
      style
    } = this.editorDiv;
    style.fontSize = `calc(${freetext_classPrivateFieldGet(_fontSize, this)}px * var(--total-scale-factor))`;
    style.color = freetext_classPrivateFieldGet(freetext_color, this);
    this.div.append(this.editorDiv);
    this.overlayDiv = document.createElement("div");
    this.overlayDiv.classList.add("overlay", "enabled");
    this.div.append(this.overlayDiv);
    if (this._isCopy || this.annotationElementId) {
      const [parentWidth, parentHeight] = this.parentDimensions;
      if (this.annotationElementId) {
        const {
          position
        } = this._initialData;
        let [tx, ty] = this.getInitialTranslation();
        [tx, ty] = this.pageTranslationToScreen(tx, ty);
        const [pageWidth, pageHeight] = this.pageDimensions;
        const [pageX, pageY] = this.pageTranslation;
        let posX, posY;
        switch (this.rotation) {
          case 0:
            posX = baseX + (position[0] - pageX) / pageWidth;
            posY = baseY + this.height - (position[1] - pageY) / pageHeight;
            break;
          case 90:
            posX = baseX + (position[0] - pageX) / pageWidth;
            posY = baseY - (position[1] - pageY) / pageHeight;
            [tx, ty] = [ty, -tx];
            break;
          case 180:
            posX = baseX - this.width + (position[0] - pageX) / pageWidth;
            posY = baseY - (position[1] - pageY) / pageHeight;
            [tx, ty] = [-tx, -ty];
            break;
          case 270:
            posX = baseX + (position[0] - pageX - this.height * pageHeight) / pageWidth;
            posY = baseY + (position[1] - pageY - this.width * pageWidth) / pageHeight;
            [tx, ty] = [-ty, tx];
            break;
        }
        this.setAt(posX * parentWidth, posY * parentHeight, tx, ty);
      } else {
        this._moveAfterPaste(baseX, baseY);
      }
      freetext_assertClassBrand(_FreeTextEditor_brand, this, _setContent).call(this);
      this._isDraggable = true;
      this.editorDiv.contentEditable = false;
    } else {
      this._isDraggable = false;
      this.editorDiv.contentEditable = true;
    }
    return this.div;
  }
  editorDivPaste(event) {
    const clipboardData = event.clipboardData || window.clipboardData;
    const {
      types
    } = clipboardData;
    if (types.length === 1 && types[0] === "text/plain") {
      return;
    }
    event.preventDefault();
    const paste = _deserializeContent.call(FreeTextEditor, clipboardData.getData("text") || "").replaceAll(EOL_PATTERN, "\n");
    if (!paste) {
      return;
    }
    const selection = window.getSelection();
    if (!selection.rangeCount) {
      return;
    }
    this.editorDiv.normalize();
    selection.deleteFromDocument();
    const range = selection.getRangeAt(0);
    if (!paste.includes("\n")) {
      range.insertNode(document.createTextNode(paste));
      this.editorDiv.normalize();
      selection.collapseToStart();
      return;
    }
    const {
      startContainer,
      startOffset
    } = range;
    const bufferBefore = [];
    const bufferAfter = [];
    if (startContainer.nodeType === Node.TEXT_NODE) {
      const parent = startContainer.parentElement;
      bufferAfter.push(startContainer.nodeValue.slice(startOffset).replaceAll(EOL_PATTERN, ""));
      if (parent !== this.editorDiv) {
        let buffer = bufferBefore;
        for (const child of this.editorDiv.childNodes) {
          if (child === parent) {
            buffer = bufferAfter;
            continue;
          }
          buffer.push(_getNodeContent.call(FreeTextEditor, child));
        }
      }
      bufferBefore.push(startContainer.nodeValue.slice(0, startOffset).replaceAll(EOL_PATTERN, ""));
    } else if (startContainer === this.editorDiv) {
      let buffer = bufferBefore;
      let i = 0;
      for (const child of this.editorDiv.childNodes) {
        if (i++ === startOffset) {
          buffer = bufferAfter;
        }
        buffer.push(_getNodeContent.call(FreeTextEditor, child));
      }
    }
    freetext_classPrivateFieldSet(_content, this, `${bufferBefore.join("\n")}${paste}${bufferAfter.join("\n")}`);
    freetext_assertClassBrand(_FreeTextEditor_brand, this, _setContent).call(this);
    const newRange = new Range();
    let beforeLength = Math.sumPrecise(bufferBefore.map(line => line.length));
    for (const {
      firstChild
    } of this.editorDiv.childNodes) {
      if (firstChild.nodeType === Node.TEXT_NODE) {
        const length = firstChild.nodeValue.length;
        if (beforeLength <= length) {
          newRange.setStart(firstChild, beforeLength);
          newRange.setEnd(firstChild, beforeLength);
          break;
        }
        beforeLength -= length;
      }
    }
    selection.removeAllRanges();
    selection.addRange(newRange);
  }
  get contentDiv() {
    return this.editorDiv;
  }
  static async deserialize(data, parent, uiManager) {
    let initialData = null;
    if (data instanceof FreeTextAnnotationElement) {
      const {
        data: {
          defaultAppearanceData: {
            fontSize,
            fontColor
          },
          rect,
          rotation,
          id,
          popupRef
        },
        textContent,
        textPosition,
        parent: {
          page: {
            pageNumber
          }
        }
      } = data;
      if (!textContent || textContent.length === 0) {
        return null;
      }
      initialData = data = {
        annotationType: AnnotationEditorType.FREETEXT,
        color: Array.from(fontColor),
        fontSize,
        value: textContent.join("\n"),
        position: textPosition,
        pageIndex: pageNumber - 1,
        rect: rect.slice(0),
        rotation,
        id,
        deleted: false,
        popupRef
      };
    }
    const editor = await super.deserialize(data, parent, uiManager);
    freetext_classPrivateFieldSet(_fontSize, editor, data.fontSize);
    freetext_classPrivateFieldSet(freetext_color, editor, Util.makeHexColor(...data.color));
    freetext_classPrivateFieldSet(_content, editor, _deserializeContent.call(FreeTextEditor, data.value));
    editor.annotationElementId = data.id || null;
    editor._initialData = initialData;
    return editor;
  }
  serialize() {
    let isForCopying = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
    if (this.isEmpty()) {
      return null;
    }
    if (this.deleted) {
      return this.serializeDeleted();
    }
    const padding = FreeTextEditor._internalPadding * this.parentScale;
    const rect = this.getRect(padding, padding);
    const color = AnnotationEditor._colorManager.convert(this.isAttachedToDOM ? getComputedStyle(this.editorDiv).color : freetext_classPrivateFieldGet(freetext_color, this));
    const serialized = {
      annotationType: AnnotationEditorType.FREETEXT,
      color,
      fontSize: freetext_classPrivateFieldGet(_fontSize, this),
      value: freetext_assertClassBrand(_FreeTextEditor_brand, this, _serializeContent).call(this),
      pageIndex: this.pageIndex,
      rect,
      rotation: this.rotation,
      structTreeParentId: this._structTreeParentId
    };
    if (isForCopying) {
      serialized.isCopy = true;
      return serialized;
    }
    if (this.annotationElementId && !freetext_assertClassBrand(_FreeTextEditor_brand, this, _hasElementChanged).call(this, serialized)) {
      return null;
    }
    serialized.id = this.annotationElementId;
    return serialized;
  }
  renderAnnotationElement(annotation) {
    const content = super.renderAnnotationElement(annotation);
    if (this.deleted) {
      return content;
    }
    const {
      style
    } = content;
    style.fontSize = `calc(${freetext_classPrivateFieldGet(_fontSize, this)}px * var(--total-scale-factor))`;
    style.color = freetext_classPrivateFieldGet(freetext_color, this);
    content.replaceChildren();
    for (const line of freetext_classPrivateFieldGet(_content, this).split("\n")) {
      const div = document.createElement("div");
      div.append(line ? document.createTextNode(line) : document.createElement("br"));
      content.append(div);
    }
    const padding = FreeTextEditor._internalPadding * this.parentScale;
    annotation.updateEdited({
      rect: this.getRect(padding, padding),
      popupContent: freetext_classPrivateFieldGet(_content, this)
    });
    return content;
  }
  resetAnnotationElement(annotation) {
    super.resetAnnotationElement(annotation);
    annotation.resetEdited();
  }
}
_FreeTextEditor = FreeTextEditor;
function _updateFontSize(fontSize) {
  const setFontsize = size => {
    this.editorDiv.style.fontSize = `calc(${size}px * var(--total-scale-factor))`;
    this.translate(0, -(size - freetext_classPrivateFieldGet(_fontSize, this)) * this.parentScale);
    freetext_classPrivateFieldSet(_fontSize, this, size);
    freetext_assertClassBrand(_FreeTextEditor_brand, this, _setEditorDimensions).call(this);
  };
  const savedFontsize = freetext_classPrivateFieldGet(_fontSize, this);
  this.addCommands({
    cmd: setFontsize.bind(this, fontSize),
    undo: setFontsize.bind(this, savedFontsize),
    post: this._uiManager.updateUI.bind(this._uiManager, this),
    mustExec: true,
    type: AnnotationEditorParamsType.FREETEXT_SIZE,
    overwriteIfSameType: true,
    keepUndo: true
  });
  this.eventBus?.dispatch("annotation-editor-event", {
    source: this,
    type: "fontSizeChanged",
    page: this.pageIndex + 1,
    editorType: this.constructor.name,
    value: fontSize,
    previousValue: freetext_classPrivateFieldGet(_fontSize, this)
  });
}
function _updateColor(color) {
  const setColor = col => {
    freetext_classPrivateFieldSet(freetext_color, this, this.editorDiv.style.color = col);
  };
  const savedColor = freetext_classPrivateFieldGet(freetext_color, this);
  this.addCommands({
    cmd: setColor.bind(this, color),
    undo: setColor.bind(this, savedColor),
    post: this._uiManager.updateUI.bind(this._uiManager, this),
    mustExec: true,
    type: AnnotationEditorParamsType.FREETEXT_COLOR,
    overwriteIfSameType: true,
    keepUndo: true
  });
  this.eventBus?.dispatch("annotation-editor-event", {
    source: this,
    type: "colorChanged",
    page: this.pageIndex + 1,
    editorType: this.constructor.name,
    value: color,
    previousValue: freetext_classPrivateFieldGet(freetext_color, this)
  });
}
function _extractText() {
  const buffer = [];
  this.editorDiv.normalize();
  let prevChild = null;
  for (const child of this.editorDiv.childNodes) {
    if (prevChild?.nodeType === Node.TEXT_NODE && child.nodeName === "BR") {
      continue;
    }
    buffer.push(_getNodeContent.call(_FreeTextEditor, child));
    prevChild = child;
  }
  return buffer.join("\n");
}
function _setEditorDimensions() {
  const [parentWidth, parentHeight] = this.parentDimensions;
  let rect;
  if (this.isAttachedToDOM) {
    rect = this.div.getBoundingClientRect();
  } else {
    const {
      currentLayer,
      div
    } = this;
    const savedDisplay = div.style.display;
    const savedVisibility = div.classList.contains("hidden");
    div.classList.remove("hidden");
    div.style.display = "hidden";
    currentLayer.div.append(this.div);
    rect = div.getBoundingClientRect();
    div.remove();
    div.style.display = savedDisplay;
    div.classList.toggle("hidden", savedVisibility);
  }
  if (this.rotation % 180 === this.parentRotation % 180) {
    this.width = rect.width / parentWidth;
    this.height = rect.height / parentHeight;
  } else {
    this.width = rect.height / parentWidth;
    this.height = rect.width / parentHeight;
  }
  this.fixAndSetPosition();
}
function _getNodeContent(node) {
  return (node.nodeType === Node.TEXT_NODE ? node.nodeValue : node.innerText).replaceAll(EOL_PATTERN, "");
}
function _setContent() {
  this.editorDiv.replaceChildren();
  if (!freetext_classPrivateFieldGet(_content, this)) {
    return;
  }
  for (const line of freetext_classPrivateFieldGet(_content, this).split("\n")) {
    const div = document.createElement("div");
    div.append(line ? document.createTextNode(line) : document.createElement("br"));
    this.editorDiv.append(div);
  }
}
function _serializeContent() {
  return freetext_classPrivateFieldGet(_content, this).replaceAll("\xa0", " ");
}
function _deserializeContent(content) {
  return content.replaceAll(" ", "\xa0");
}
function _hasElementChanged(serialized) {
  const {
    value,
    fontSize,
    color,
    pageIndex
  } = this._initialData;
  return this._hasBeenMoved || serialized.value !== value || serialized.fontSize !== fontSize || serialized.color.some((c, i) => c !== color[i]) || serialized.pageIndex !== pageIndex;
}
freetext_defineProperty(FreeTextEditor, "_freeTextDefaultContent", "");
freetext_defineProperty(FreeTextEditor, "_internalPadding", 0);
freetext_defineProperty(FreeTextEditor, "_defaultColor", null);
freetext_defineProperty(FreeTextEditor, "_defaultFontSize", 10);
freetext_defineProperty(FreeTextEditor, "_type", "freetext");
freetext_defineProperty(FreeTextEditor, "_editorType", AnnotationEditorType.FREETEXT);

;// ./src/display/editor/drawers/outline.js













function outline_defineProperty(e, r, t) { return (r = outline_toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function outline_toPropertyKey(t) { var i = outline_toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function outline_toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }

class Outline {
  toSVGPath() {
    unreachable("Abstract method `toSVGPath` must be implemented.");
  }
  get box() {
    unreachable("Abstract getter `box` must be implemented.");
  }
  serialize(_bbox, _rotation) {
    unreachable("Abstract method `serialize` must be implemented.");
  }
  static _rescale(src, tx, ty, sx, sy, dest) {
    dest ||= new Float32Array(src.length);
    for (let i = 0, ii = src.length; i < ii; i += 2) {
      dest[i] = tx + src[i] * sx;
      dest[i + 1] = ty + src[i + 1] * sy;
    }
    return dest;
  }
  static _rescaleAndSwap(src, tx, ty, sx, sy, dest) {
    dest ||= new Float32Array(src.length);
    for (let i = 0, ii = src.length; i < ii; i += 2) {
      dest[i] = tx + src[i + 1] * sx;
      dest[i + 1] = ty + src[i] * sy;
    }
    return dest;
  }
  static _translate(src, tx, ty, dest) {
    dest ||= new Float32Array(src.length);
    for (let i = 0, ii = src.length; i < ii; i += 2) {
      dest[i] = tx + src[i];
      dest[i + 1] = ty + src[i + 1];
    }
    return dest;
  }
  static svgRound(x) {
    return Math.round(x * 10000);
  }
  static _normalizePoint(x, y, parentWidth, parentHeight, rotation) {
    switch (rotation) {
      case 90:
        return [1 - y / parentWidth, x / parentHeight];
      case 180:
        return [1 - x / parentWidth, 1 - y / parentHeight];
      case 270:
        return [y / parentWidth, 1 - x / parentHeight];
      default:
        return [x / parentWidth, y / parentHeight];
    }
  }
  static _normalizePagePoint(x, y, rotation) {
    switch (rotation) {
      case 90:
        return [1 - y, x];
      case 180:
        return [1 - x, 1 - y];
      case 270:
        return [y, 1 - x];
      default:
        return [x, y];
    }
  }
  static createBezierPoints(x1, y1, x2, y2, x3, y3) {
    return [(x1 + 5 * x2) / 6, (y1 + 5 * y2) / 6, (5 * x2 + x3) / 6, (5 * y2 + y3) / 6, (x2 + x3) / 2, (y2 + y3) / 2];
  }
}
outline_defineProperty(Outline, "PRECISION", 1e-4);

;// ./src/display/editor/drawers/freedraw.js














function freedraw_classPrivateMethodInitSpec(e, a) { freedraw_checkPrivateRedeclaration(e, a), a.add(e); }
function freedraw_classPrivateFieldInitSpec(e, t, a) { freedraw_checkPrivateRedeclaration(e, t), t.set(e, a); }
function freedraw_checkPrivateRedeclaration(e, t) { if (t.has(e)) throw new TypeError("Cannot initialize the same private elements twice on an object"); }
function freedraw_classPrivateFieldGet(s, a) { return s.get(freedraw_assertClassBrand(s, a)); }
function freedraw_classPrivateFieldSet(s, a, r) { return s.set(freedraw_assertClassBrand(s, a), r), r; }
function freedraw_assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); }


var _box = /*#__PURE__*/new WeakMap();
var _bottom = /*#__PURE__*/new WeakMap();
var _innerMargin = /*#__PURE__*/new WeakMap();
var _isLTR = /*#__PURE__*/new WeakMap();
var _top = /*#__PURE__*/new WeakMap();
var _last = /*#__PURE__*/new WeakMap();
var _lastX = /*#__PURE__*/new WeakMap();
var _lastY = /*#__PURE__*/new WeakMap();
var _min = /*#__PURE__*/new WeakMap();
var _min_dist = /*#__PURE__*/new WeakMap();
var _scaleFactor = /*#__PURE__*/new WeakMap();
var _thickness = /*#__PURE__*/new WeakMap();
var _points = /*#__PURE__*/new WeakMap();
var _FreeDrawOutliner_brand = /*#__PURE__*/new WeakSet();
class FreeDrawOutliner {
  constructor(_ref, box, scaleFactor, thickness, isLTR) {
    let {
      x: _x,
      y: _y
    } = _ref;
    let innerMargin = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : 0;
    freedraw_classPrivateMethodInitSpec(this, _FreeDrawOutliner_brand);
    freedraw_classPrivateFieldInitSpec(this, _box, void 0);
    freedraw_classPrivateFieldInitSpec(this, _bottom, []);
    freedraw_classPrivateFieldInitSpec(this, _innerMargin, void 0);
    freedraw_classPrivateFieldInitSpec(this, _isLTR, void 0);
    freedraw_classPrivateFieldInitSpec(this, _top, []);
    freedraw_classPrivateFieldInitSpec(this, _last, new Float32Array(18));
    freedraw_classPrivateFieldInitSpec(this, _lastX, void 0);
    freedraw_classPrivateFieldInitSpec(this, _lastY, void 0);
    freedraw_classPrivateFieldInitSpec(this, _min, void 0);
    freedraw_classPrivateFieldInitSpec(this, _min_dist, void 0);
    freedraw_classPrivateFieldInitSpec(this, _scaleFactor, void 0);
    freedraw_classPrivateFieldInitSpec(this, _thickness, void 0);
    freedraw_classPrivateFieldInitSpec(this, _points, []);
    freedraw_classPrivateFieldSet(_box, this, box);
    freedraw_classPrivateFieldSet(_thickness, this, thickness * scaleFactor);
    freedraw_classPrivateFieldSet(_isLTR, this, isLTR);
    freedraw_classPrivateFieldGet(_last, this).set([NaN, NaN, NaN, NaN, _x, _y], 6);
    freedraw_classPrivateFieldSet(_innerMargin, this, innerMargin);
    freedraw_classPrivateFieldSet(_min_dist, this, _MIN_DIST._ * scaleFactor);
    freedraw_classPrivateFieldSet(_min, this, _MIN._ * scaleFactor);
    freedraw_classPrivateFieldSet(_scaleFactor, this, scaleFactor);
    freedraw_classPrivateFieldGet(_points, this).push(_x, _y);
  }
  isEmpty() {
    return isNaN(freedraw_classPrivateFieldGet(_last, this)[8]);
  }
  add(_ref2) {
    let {
      x,
      y
    } = _ref2;
    freedraw_classPrivateFieldSet(_lastX, this, x);
    freedraw_classPrivateFieldSet(_lastY, this, y);
    const [layerX, layerY, layerWidth, layerHeight] = freedraw_classPrivateFieldGet(_box, this);
    let [x1, y1, x2, y2] = freedraw_classPrivateFieldGet(_last, this).subarray(8, 12);
    const diffX = x - x2;
    const diffY = y - y2;
    const d = Math.hypot(diffX, diffY);
    if (d < freedraw_classPrivateFieldGet(_min, this)) {
      return false;
    }
    const diffD = d - freedraw_classPrivateFieldGet(_min_dist, this);
    const K = diffD / d;
    const shiftX = K * diffX;
    const shiftY = K * diffY;
    let x0 = x1;
    let y0 = y1;
    x1 = x2;
    y1 = y2;
    x2 += shiftX;
    y2 += shiftY;
    freedraw_classPrivateFieldGet(_points, this)?.push(x, y);
    const nX = -shiftY / diffD;
    const nY = shiftX / diffD;
    const thX = nX * freedraw_classPrivateFieldGet(_thickness, this);
    const thY = nY * freedraw_classPrivateFieldGet(_thickness, this);
    freedraw_classPrivateFieldGet(_last, this).set(freedraw_classPrivateFieldGet(_last, this).subarray(2, 8), 0);
    freedraw_classPrivateFieldGet(_last, this).set([x2 + thX, y2 + thY], 4);
    freedraw_classPrivateFieldGet(_last, this).set(freedraw_classPrivateFieldGet(_last, this).subarray(14, 18), 12);
    freedraw_classPrivateFieldGet(_last, this).set([x2 - thX, y2 - thY], 16);
    if (isNaN(freedraw_classPrivateFieldGet(_last, this)[6])) {
      if (freedraw_classPrivateFieldGet(_top, this).length === 0) {
        freedraw_classPrivateFieldGet(_last, this).set([x1 + thX, y1 + thY], 2);
        freedraw_classPrivateFieldGet(_top, this).push(NaN, NaN, NaN, NaN, (x1 + thX - layerX) / layerWidth, (y1 + thY - layerY) / layerHeight);
        freedraw_classPrivateFieldGet(_last, this).set([x1 - thX, y1 - thY], 14);
        freedraw_classPrivateFieldGet(_bottom, this).push(NaN, NaN, NaN, NaN, (x1 - thX - layerX) / layerWidth, (y1 - thY - layerY) / layerHeight);
      }
      freedraw_classPrivateFieldGet(_last, this).set([x0, y0, x1, y1, x2, y2], 6);
      return !this.isEmpty();
    }
    freedraw_classPrivateFieldGet(_last, this).set([x0, y0, x1, y1, x2, y2], 6);
    const angle = Math.abs(Math.atan2(y0 - y1, x0 - x1) - Math.atan2(shiftY, shiftX));
    if (angle < Math.PI / 2) {
      [x1, y1, x2, y2] = freedraw_classPrivateFieldGet(_last, this).subarray(2, 6);
      freedraw_classPrivateFieldGet(_top, this).push(NaN, NaN, NaN, NaN, ((x1 + x2) / 2 - layerX) / layerWidth, ((y1 + y2) / 2 - layerY) / layerHeight);
      [x1, y1, x0, y0] = freedraw_classPrivateFieldGet(_last, this).subarray(14, 18);
      freedraw_classPrivateFieldGet(_bottom, this).push(NaN, NaN, NaN, NaN, ((x0 + x1) / 2 - layerX) / layerWidth, ((y0 + y1) / 2 - layerY) / layerHeight);
      return true;
    }
    [x0, y0, x1, y1, x2, y2] = freedraw_classPrivateFieldGet(_last, this).subarray(0, 6);
    freedraw_classPrivateFieldGet(_top, this).push(((x0 + 5 * x1) / 6 - layerX) / layerWidth, ((y0 + 5 * y1) / 6 - layerY) / layerHeight, ((5 * x1 + x2) / 6 - layerX) / layerWidth, ((5 * y1 + y2) / 6 - layerY) / layerHeight, ((x1 + x2) / 2 - layerX) / layerWidth, ((y1 + y2) / 2 - layerY) / layerHeight);
    [x2, y2, x1, y1, x0, y0] = freedraw_classPrivateFieldGet(_last, this).subarray(12, 18);
    freedraw_classPrivateFieldGet(_bottom, this).push(((x0 + 5 * x1) / 6 - layerX) / layerWidth, ((y0 + 5 * y1) / 6 - layerY) / layerHeight, ((5 * x1 + x2) / 6 - layerX) / layerWidth, ((5 * y1 + y2) / 6 - layerY) / layerHeight, ((x1 + x2) / 2 - layerX) / layerWidth, ((y1 + y2) / 2 - layerY) / layerHeight);
    return true;
  }
  toSVGPath() {
    if (this.isEmpty()) {
      return "";
    }
    const top = freedraw_classPrivateFieldGet(_top, this);
    const bottom = freedraw_classPrivateFieldGet(_bottom, this);
    if (isNaN(freedraw_classPrivateFieldGet(_last, this)[6]) && !this.isEmpty()) {
      return freedraw_assertClassBrand(_FreeDrawOutliner_brand, this, _toSVGPathTwoPoints).call(this);
    }
    const buffer = [];
    buffer.push(`M${top[4]} ${top[5]}`);
    for (let i = 6; i < top.length; i += 6) {
      if (isNaN(top[i])) {
        buffer.push(`L${top[i + 4]} ${top[i + 5]}`);
      } else {
        buffer.push(`C${top[i]} ${top[i + 1]} ${top[i + 2]} ${top[i + 3]} ${top[i + 4]} ${top[i + 5]}`);
      }
    }
    freedraw_assertClassBrand(_FreeDrawOutliner_brand, this, _toSVGPathEnd).call(this, buffer);
    for (let i = bottom.length - 6; i >= 6; i -= 6) {
      if (isNaN(bottom[i])) {
        buffer.push(`L${bottom[i + 4]} ${bottom[i + 5]}`);
      } else {
        buffer.push(`C${bottom[i]} ${bottom[i + 1]} ${bottom[i + 2]} ${bottom[i + 3]} ${bottom[i + 4]} ${bottom[i + 5]}`);
      }
    }
    freedraw_assertClassBrand(_FreeDrawOutliner_brand, this, _toSVGPathStart).call(this, buffer);
    return buffer.join(" ");
  }
  newFreeDrawOutline(outline, points, box, scaleFactor, innerMargin, isLTR) {
    return new FreeDrawOutline(outline, points, box, scaleFactor, innerMargin, isLTR);
  }
  getOutlines() {
    const top = freedraw_classPrivateFieldGet(_top, this);
    const bottom = freedraw_classPrivateFieldGet(_bottom, this);
    const last = freedraw_classPrivateFieldGet(_last, this);
    const [layerX, layerY, layerWidth, layerHeight] = freedraw_classPrivateFieldGet(_box, this);
    const points = new Float32Array((freedraw_classPrivateFieldGet(_points, this)?.length ?? 0) + 2);
    for (let i = 0, ii = points.length - 2; i < ii; i += 2) {
      points[i] = (freedraw_classPrivateFieldGet(_points, this)[i] - layerX) / layerWidth;
      points[i + 1] = (freedraw_classPrivateFieldGet(_points, this)[i + 1] - layerY) / layerHeight;
    }
    points[points.length - 2] = (freedraw_classPrivateFieldGet(_lastX, this) - layerX) / layerWidth;
    points[points.length - 1] = (freedraw_classPrivateFieldGet(_lastY, this) - layerY) / layerHeight;
    if (isNaN(last[6]) && !this.isEmpty()) {
      return freedraw_assertClassBrand(_FreeDrawOutliner_brand, this, _getOutlineTwoPoints).call(this, points);
    }
    const outline = new Float32Array(freedraw_classPrivateFieldGet(_top, this).length + 24 + freedraw_classPrivateFieldGet(_bottom, this).length);
    let N = top.length;
    for (let i = 0; i < N; i += 2) {
      if (isNaN(top[i])) {
        outline[i] = outline[i + 1] = NaN;
        continue;
      }
      outline[i] = top[i];
      outline[i + 1] = top[i + 1];
    }
    N = freedraw_assertClassBrand(_FreeDrawOutliner_brand, this, _getOutlineEnd).call(this, outline, N);
    for (let i = bottom.length - 6; i >= 6; i -= 6) {
      for (let j = 0; j < 6; j += 2) {
        if (isNaN(bottom[i + j])) {
          outline[N] = outline[N + 1] = NaN;
          N += 2;
          continue;
        }
        outline[N] = bottom[i + j];
        outline[N + 1] = bottom[i + j + 1];
        N += 2;
      }
    }
    freedraw_assertClassBrand(_FreeDrawOutliner_brand, this, _getOutlineStart).call(this, outline, N);
    return this.newFreeDrawOutline(outline, points, freedraw_classPrivateFieldGet(_box, this), freedraw_classPrivateFieldGet(_scaleFactor, this), freedraw_classPrivateFieldGet(_innerMargin, this), freedraw_classPrivateFieldGet(_isLTR, this));
  }
}
function _getLastCoords() {
  const lastTop = freedraw_classPrivateFieldGet(_last, this).subarray(4, 6);
  const lastBottom = freedraw_classPrivateFieldGet(_last, this).subarray(16, 18);
  const [x, y, width, height] = freedraw_classPrivateFieldGet(_box, this);
  return [(freedraw_classPrivateFieldGet(_lastX, this) + (lastTop[0] - lastBottom[0]) / 2 - x) / width, (freedraw_classPrivateFieldGet(_lastY, this) + (lastTop[1] - lastBottom[1]) / 2 - y) / height, (freedraw_classPrivateFieldGet(_lastX, this) + (lastBottom[0] - lastTop[0]) / 2 - x) / width, (freedraw_classPrivateFieldGet(_lastY, this) + (lastBottom[1] - lastTop[1]) / 2 - y) / height];
}
function _toSVGPathTwoPoints() {
  const [x, y, width, height] = freedraw_classPrivateFieldGet(_box, this);
  const [lastTopX, lastTopY, lastBottomX, lastBottomY] = freedraw_assertClassBrand(_FreeDrawOutliner_brand, this, _getLastCoords).call(this);
  return `M${(freedraw_classPrivateFieldGet(_last, this)[2] - x) / width} ${(freedraw_classPrivateFieldGet(_last, this)[3] - y) / height} L${(freedraw_classPrivateFieldGet(_last, this)[4] - x) / width} ${(freedraw_classPrivateFieldGet(_last, this)[5] - y) / height} L${lastTopX} ${lastTopY} L${lastBottomX} ${lastBottomY} L${(freedraw_classPrivateFieldGet(_last, this)[16] - x) / width} ${(freedraw_classPrivateFieldGet(_last, this)[17] - y) / height} L${(freedraw_classPrivateFieldGet(_last, this)[14] - x) / width} ${(freedraw_classPrivateFieldGet(_last, this)[15] - y) / height} Z`;
}
function _toSVGPathStart(buffer) {
  const bottom = freedraw_classPrivateFieldGet(_bottom, this);
  buffer.push(`L${bottom[4]} ${bottom[5]} Z`);
}
function _toSVGPathEnd(buffer) {
  const [x, y, width, height] = freedraw_classPrivateFieldGet(_box, this);
  const lastTop = freedraw_classPrivateFieldGet(_last, this).subarray(4, 6);
  const lastBottom = freedraw_classPrivateFieldGet(_last, this).subarray(16, 18);
  const [lastTopX, lastTopY, lastBottomX, lastBottomY] = freedraw_assertClassBrand(_FreeDrawOutliner_brand, this, _getLastCoords).call(this);
  buffer.push(`L${(lastTop[0] - x) / width} ${(lastTop[1] - y) / height} L${lastTopX} ${lastTopY} L${lastBottomX} ${lastBottomY} L${(lastBottom[0] - x) / width} ${(lastBottom[1] - y) / height}`);
}
function _getOutlineTwoPoints(points) {
  const last = freedraw_classPrivateFieldGet(_last, this);
  const [layerX, layerY, layerWidth, layerHeight] = freedraw_classPrivateFieldGet(_box, this);
  const [lastTopX, lastTopY, lastBottomX, lastBottomY] = freedraw_assertClassBrand(_FreeDrawOutliner_brand, this, _getLastCoords).call(this);
  const outline = new Float32Array(36);
  outline.set([NaN, NaN, NaN, NaN, (last[2] - layerX) / layerWidth, (last[3] - layerY) / layerHeight, NaN, NaN, NaN, NaN, (last[4] - layerX) / layerWidth, (last[5] - layerY) / layerHeight, NaN, NaN, NaN, NaN, lastTopX, lastTopY, NaN, NaN, NaN, NaN, lastBottomX, lastBottomY, NaN, NaN, NaN, NaN, (last[16] - layerX) / layerWidth, (last[17] - layerY) / layerHeight, NaN, NaN, NaN, NaN, (last[14] - layerX) / layerWidth, (last[15] - layerY) / layerHeight], 0);
  return this.newFreeDrawOutline(outline, points, freedraw_classPrivateFieldGet(_box, this), freedraw_classPrivateFieldGet(_scaleFactor, this), freedraw_classPrivateFieldGet(_innerMargin, this), freedraw_classPrivateFieldGet(_isLTR, this));
}
function _getOutlineStart(outline, pos) {
  const bottom = freedraw_classPrivateFieldGet(_bottom, this);
  outline.set([NaN, NaN, NaN, NaN, bottom[4], bottom[5]], pos);
  return pos += 6;
}
function _getOutlineEnd(outline, pos) {
  const lastTop = freedraw_classPrivateFieldGet(_last, this).subarray(4, 6);
  const lastBottom = freedraw_classPrivateFieldGet(_last, this).subarray(16, 18);
  const [layerX, layerY, layerWidth, layerHeight] = freedraw_classPrivateFieldGet(_box, this);
  const [lastTopX, lastTopY, lastBottomX, lastBottomY] = freedraw_assertClassBrand(_FreeDrawOutliner_brand, this, _getLastCoords).call(this);
  outline.set([NaN, NaN, NaN, NaN, (lastTop[0] - layerX) / layerWidth, (lastTop[1] - layerY) / layerHeight, NaN, NaN, NaN, NaN, lastTopX, lastTopY, NaN, NaN, NaN, NaN, lastBottomX, lastBottomY, NaN, NaN, NaN, NaN, (lastBottom[0] - layerX) / layerWidth, (lastBottom[1] - layerY) / layerHeight], pos);
  return pos += 24;
}
var _MIN_DIST = {
  _: 8
};
var _MIN_DIFF = {
  _: 2
};
var _MIN = {
  _: _MIN_DIST._ + _MIN_DIFF._
};
var _box2 = /*#__PURE__*/new WeakMap();
var _bbox = /*#__PURE__*/new WeakMap();
var _innerMargin2 = /*#__PURE__*/new WeakMap();
var _isLTR2 = /*#__PURE__*/new WeakMap();
var _points2 = /*#__PURE__*/new WeakMap();
var _scaleFactor2 = /*#__PURE__*/new WeakMap();
var _outline = /*#__PURE__*/new WeakMap();
var _FreeDrawOutline_brand = /*#__PURE__*/new WeakSet();
class FreeDrawOutline extends Outline {
  constructor(_outline2, points, box, scaleFactor, innerMargin, _isLTR3) {
    super();
    freedraw_classPrivateMethodInitSpec(this, _FreeDrawOutline_brand);
    freedraw_classPrivateFieldInitSpec(this, _box2, void 0);
    freedraw_classPrivateFieldInitSpec(this, _bbox, new Float32Array(4));
    freedraw_classPrivateFieldInitSpec(this, _innerMargin2, void 0);
    freedraw_classPrivateFieldInitSpec(this, _isLTR2, void 0);
    freedraw_classPrivateFieldInitSpec(this, _points2, void 0);
    freedraw_classPrivateFieldInitSpec(this, _scaleFactor2, void 0);
    freedraw_classPrivateFieldInitSpec(this, _outline, void 0);
    freedraw_classPrivateFieldSet(_outline, this, _outline2);
    freedraw_classPrivateFieldSet(_points2, this, points);
    freedraw_classPrivateFieldSet(_box2, this, box);
    freedraw_classPrivateFieldSet(_scaleFactor2, this, scaleFactor);
    freedraw_classPrivateFieldSet(_innerMargin2, this, innerMargin);
    freedraw_classPrivateFieldSet(_isLTR2, this, _isLTR3);
    this.lastPoint = [NaN, NaN];
    freedraw_assertClassBrand(_FreeDrawOutline_brand, this, _computeMinMax).call(this, _isLTR3);
    const [_x2, _y2, width, height] = freedraw_classPrivateFieldGet(_bbox, this);
    for (let i = 0, ii = _outline2.length; i < ii; i += 2) {
      _outline2[i] = (_outline2[i] - _x2) / width;
      _outline2[i + 1] = (_outline2[i + 1] - _y2) / height;
    }
    for (let i = 0, ii = points.length; i < ii; i += 2) {
      points[i] = (points[i] - _x2) / width;
      points[i + 1] = (points[i + 1] - _y2) / height;
    }
  }
  toSVGPath() {
    const buffer = [`M${freedraw_classPrivateFieldGet(_outline, this)[4]} ${freedraw_classPrivateFieldGet(_outline, this)[5]}`];
    for (let i = 6, ii = freedraw_classPrivateFieldGet(_outline, this).length; i < ii; i += 6) {
      if (isNaN(freedraw_classPrivateFieldGet(_outline, this)[i])) {
        buffer.push(`L${freedraw_classPrivateFieldGet(_outline, this)[i + 4]} ${freedraw_classPrivateFieldGet(_outline, this)[i + 5]}`);
        continue;
      }
      buffer.push(`C${freedraw_classPrivateFieldGet(_outline, this)[i]} ${freedraw_classPrivateFieldGet(_outline, this)[i + 1]} ${freedraw_classPrivateFieldGet(_outline, this)[i + 2]} ${freedraw_classPrivateFieldGet(_outline, this)[i + 3]} ${freedraw_classPrivateFieldGet(_outline, this)[i + 4]} ${freedraw_classPrivateFieldGet(_outline, this)[i + 5]}`);
    }
    buffer.push("Z");
    return buffer.join(" ");
  }
  serialize(_ref3, rotation) {
    let [blX, blY, trX, trY] = _ref3;
    const width = trX - blX;
    const height = trY - blY;
    let outline;
    let points;
    switch (rotation) {
      case 0:
        outline = Outline._rescale(freedraw_classPrivateFieldGet(_outline, this), blX, trY, width, -height);
        points = Outline._rescale(freedraw_classPrivateFieldGet(_points2, this), blX, trY, width, -height);
        break;
      case 90:
        outline = Outline._rescaleAndSwap(freedraw_classPrivateFieldGet(_outline, this), blX, blY, width, height);
        points = Outline._rescaleAndSwap(freedraw_classPrivateFieldGet(_points2, this), blX, blY, width, height);
        break;
      case 180:
        outline = Outline._rescale(freedraw_classPrivateFieldGet(_outline, this), trX, blY, -width, height);
        points = Outline._rescale(freedraw_classPrivateFieldGet(_points2, this), trX, blY, -width, height);
        break;
      case 270:
        outline = Outline._rescaleAndSwap(freedraw_classPrivateFieldGet(_outline, this), trX, trY, -width, -height);
        points = Outline._rescaleAndSwap(freedraw_classPrivateFieldGet(_points2, this), trX, trY, -width, -height);
        break;
    }
    return {
      outline: Array.from(outline),
      points: [Array.from(points)]
    };
  }
  get box() {
    return freedraw_classPrivateFieldGet(_bbox, this);
  }
  newOutliner(point, box, scaleFactor, thickness, isLTR) {
    let innerMargin = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : 0;
    return new FreeDrawOutliner(point, box, scaleFactor, thickness, isLTR, innerMargin);
  }
  getNewOutline(thickness, innerMargin) {
    const [x, y, width, height] = freedraw_classPrivateFieldGet(_bbox, this);
    const [layerX, layerY, layerWidth, layerHeight] = freedraw_classPrivateFieldGet(_box2, this);
    const sx = width * layerWidth;
    const sy = height * layerHeight;
    const tx = x * layerWidth + layerX;
    const ty = y * layerHeight + layerY;
    const outliner = this.newOutliner({
      x: freedraw_classPrivateFieldGet(_points2, this)[0] * sx + tx,
      y: freedraw_classPrivateFieldGet(_points2, this)[1] * sy + ty
    }, freedraw_classPrivateFieldGet(_box2, this), freedraw_classPrivateFieldGet(_scaleFactor2, this), thickness, freedraw_classPrivateFieldGet(_isLTR2, this), innerMargin ?? freedraw_classPrivateFieldGet(_innerMargin2, this));
    for (let i = 2; i < freedraw_classPrivateFieldGet(_points2, this).length; i += 2) {
      outliner.add({
        x: freedraw_classPrivateFieldGet(_points2, this)[i] * sx + tx,
        y: freedraw_classPrivateFieldGet(_points2, this)[i + 1] * sy + ty
      });
    }
    return outliner.getOutlines();
  }
}
function _computeMinMax(isLTR) {
  const outline = freedraw_classPrivateFieldGet(_outline, this);
  let lastX = outline[4];
  let lastY = outline[5];
  const minMax = [lastX, lastY, lastX, lastY];
  let lastPointX = lastX;
  let lastPointY = lastY;
  const ltrCallback = isLTR ? Math.max : Math.min;
  for (let i = 6, ii = outline.length; i < ii; i += 6) {
    const x = outline[i + 4],
      y = outline[i + 5];
    if (isNaN(outline[i])) {
      Util.pointBoundingBox(x, y, minMax);
      if (lastPointY < y) {
        lastPointX = x;
        lastPointY = y;
      } else if (lastPointY === y) {
        lastPointX = ltrCallback(lastPointX, x);
      }
    } else {
      const bbox = [Infinity, Infinity, -Infinity, -Infinity];
      Util.bezierBoundingBox(lastX, lastY, ...outline.slice(i, i + 6), bbox);
      Util.rectBoundingBox(...bbox, minMax);
      if (lastPointY < bbox[3]) {
        lastPointX = bbox[2];
        lastPointY = bbox[3];
      } else if (lastPointY === bbox[3]) {
        lastPointX = ltrCallback(lastPointX, bbox[2]);
      }
    }
    lastX = x;
    lastY = y;
  }
  const bbox = freedraw_classPrivateFieldGet(_bbox, this);
  bbox[0] = minMax[0] - freedraw_classPrivateFieldGet(_innerMargin2, this);
  bbox[1] = minMax[1] - freedraw_classPrivateFieldGet(_innerMargin2, this);
  bbox[2] = minMax[2] - minMax[0] + 2 * freedraw_classPrivateFieldGet(_innerMargin2, this);
  bbox[3] = minMax[3] - minMax[1] + 2 * freedraw_classPrivateFieldGet(_innerMargin2, this);
  this.lastPoint = [lastPointX, lastPointY];
}

;// ./src/display/editor/drawers/highlight.js























function highlight_classPrivateMethodInitSpec(e, a) { highlight_checkPrivateRedeclaration(e, a), a.add(e); }
function highlight_classPrivateFieldInitSpec(e, t, a) { highlight_checkPrivateRedeclaration(e, t), t.set(e, a); }
function highlight_checkPrivateRedeclaration(e, t) { if (t.has(e)) throw new TypeError("Cannot initialize the same private elements twice on an object"); }
function highlight_classPrivateFieldSet(s, a, r) { return s.set(highlight_assertClassBrand(s, a), r), r; }
function highlight_classPrivateFieldGet(s, a) { return s.get(highlight_assertClassBrand(s, a)); }
function highlight_assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); }



var highlight_box = /*#__PURE__*/new WeakMap();
var _lastPoint = /*#__PURE__*/new WeakMap();
var _verticalEdges = /*#__PURE__*/new WeakMap();
var _intervals = /*#__PURE__*/new WeakMap();
var _HighlightOutliner_brand = /*#__PURE__*/new WeakSet();
class HighlightOutliner {
  constructor(boxes) {
    let borderWidth = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
    let innerMargin = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;
    let isLTR = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : true;
    highlight_classPrivateMethodInitSpec(this, _HighlightOutliner_brand);
    highlight_classPrivateFieldInitSpec(this, highlight_box, void 0);
    highlight_classPrivateFieldInitSpec(this, _lastPoint, void 0);
    highlight_classPrivateFieldInitSpec(this, _verticalEdges, []);
    highlight_classPrivateFieldInitSpec(this, _intervals, []);
    const minMax = [Infinity, Infinity, -Infinity, -Infinity];
    const NUMBER_OF_DIGITS = 4;
    const EPSILON = 10 ** -NUMBER_OF_DIGITS;
    for (const {
      x,
      y,
      width,
      height
    } of boxes) {
      const x1 = Math.floor((x - borderWidth) / EPSILON) * EPSILON;
      const x2 = Math.ceil((x + width + borderWidth) / EPSILON) * EPSILON;
      const y1 = Math.floor((y - borderWidth) / EPSILON) * EPSILON;
      const y2 = Math.ceil((y + height + borderWidth) / EPSILON) * EPSILON;
      const left = [x1, y1, y2, true];
      const right = [x2, y1, y2, false];
      highlight_classPrivateFieldGet(_verticalEdges, this).push(left, right);
      Util.rectBoundingBox(x1, y1, x2, y2, minMax);
    }
    const bboxWidth = minMax[2] - minMax[0] + 2 * innerMargin;
    const bboxHeight = minMax[3] - minMax[1] + 2 * innerMargin;
    const shiftedMinX = minMax[0] - innerMargin;
    const shiftedMinY = minMax[1] - innerMargin;
    const lastEdge = highlight_classPrivateFieldGet(_verticalEdges, this).at(isLTR ? -1 : -2);
    const lastPoint = [lastEdge[0], lastEdge[2]];
    for (const edge of highlight_classPrivateFieldGet(_verticalEdges, this)) {
      const [x, y1, y2] = edge;
      edge[0] = (x - shiftedMinX) / bboxWidth;
      edge[1] = (y1 - shiftedMinY) / bboxHeight;
      edge[2] = (y2 - shiftedMinY) / bboxHeight;
    }
    highlight_classPrivateFieldSet(highlight_box, this, new Float32Array([shiftedMinX, shiftedMinY, bboxWidth, bboxHeight]));
    highlight_classPrivateFieldSet(_lastPoint, this, lastPoint);
  }
  getOutlines() {
    highlight_classPrivateFieldGet(_verticalEdges, this).sort((a, b) => a[0] - b[0] || a[1] - b[1] || a[2] - b[2]);
    const outlineVerticalEdges = [];
    for (const edge of highlight_classPrivateFieldGet(_verticalEdges, this)) {
      if (edge[3]) {
        outlineVerticalEdges.push(...highlight_assertClassBrand(_HighlightOutliner_brand, this, _breakEdge).call(this, edge));
        highlight_assertClassBrand(_HighlightOutliner_brand, this, _insert).call(this, edge);
      } else {
        highlight_assertClassBrand(_HighlightOutliner_brand, this, _remove).call(this, edge);
        outlineVerticalEdges.push(...highlight_assertClassBrand(_HighlightOutliner_brand, this, _breakEdge).call(this, edge));
      }
    }
    return highlight_assertClassBrand(_HighlightOutliner_brand, this, _getOutlines).call(this, outlineVerticalEdges);
  }
}
function _getOutlines(outlineVerticalEdges) {
  const edges = [];
  const allEdges = new Set();
  for (const edge of outlineVerticalEdges) {
    const [x, y1, y2] = edge;
    edges.push([x, y1, edge], [x, y2, edge]);
  }
  edges.sort((a, b) => a[1] - b[1] || a[0] - b[0]);
  for (let i = 0, ii = edges.length; i < ii; i += 2) {
    const edge1 = edges[i][2];
    const edge2 = edges[i + 1][2];
    edge1.push(edge2);
    edge2.push(edge1);
    allEdges.add(edge1);
    allEdges.add(edge2);
  }
  const outlines = [];
  let outline;
  while (allEdges.size > 0) {
    const edge = allEdges.values().next().value;
    let [x, y1, y2, edge1, edge2] = edge;
    allEdges.delete(edge);
    let lastPointX = x;
    let lastPointY = y1;
    outline = [x, y2];
    outlines.push(outline);
    while (true) {
      let e;
      if (allEdges.has(edge1)) {
        e = edge1;
      } else if (allEdges.has(edge2)) {
        e = edge2;
      } else {
        break;
      }
      allEdges.delete(e);
      [x, y1, y2, edge1, edge2] = e;
      if (lastPointX !== x) {
        outline.push(lastPointX, lastPointY, x, lastPointY === y1 ? y1 : y2);
        lastPointX = x;
      }
      lastPointY = lastPointY === y1 ? y2 : y1;
    }
    outline.push(lastPointX, lastPointY);
  }
  return new HighlightOutline(outlines, highlight_classPrivateFieldGet(highlight_box, this), highlight_classPrivateFieldGet(_lastPoint, this));
}
function _binarySearch(y) {
  const array = highlight_classPrivateFieldGet(_intervals, this);
  let start = 0;
  let end = array.length - 1;
  while (start <= end) {
    const middle = start + end >> 1;
    const y1 = array[middle][0];
    if (y1 === y) {
      return middle;
    }
    if (y1 < y) {
      start = middle + 1;
    } else {
      end = middle - 1;
    }
  }
  return end + 1;
}
function _insert(_ref2) {
  let [, y1, y2] = _ref2;
  const index = highlight_assertClassBrand(_HighlightOutliner_brand, this, _binarySearch).call(this, y1);
  highlight_classPrivateFieldGet(_intervals, this).splice(index, 0, [y1, y2]);
}
function _remove(_ref3) {
  let [, y1, y2] = _ref3;
  const index = highlight_assertClassBrand(_HighlightOutliner_brand, this, _binarySearch).call(this, y1);
  for (let i = index; i < highlight_classPrivateFieldGet(_intervals, this).length; i++) {
    const [start, end] = highlight_classPrivateFieldGet(_intervals, this)[i];
    if (start !== y1) {
      break;
    }
    if (start === y1 && end === y2) {
      highlight_classPrivateFieldGet(_intervals, this).splice(i, 1);
      return;
    }
  }
  for (let i = index - 1; i >= 0; i--) {
    const [start, end] = highlight_classPrivateFieldGet(_intervals, this)[i];
    if (start !== y1) {
      break;
    }
    if (start === y1 && end === y2) {
      highlight_classPrivateFieldGet(_intervals, this).splice(i, 1);
      return;
    }
  }
}
function _breakEdge(edge) {
  const [x, y1, y2] = edge;
  const results = [[x, y1, y2]];
  const index = highlight_assertClassBrand(_HighlightOutliner_brand, this, _binarySearch).call(this, y2);
  for (let i = 0; i < index; i++) {
    const [start, end] = highlight_classPrivateFieldGet(_intervals, this)[i];
    for (let j = 0, jj = results.length; j < jj; j++) {
      const [, y3, y4] = results[j];
      if (end <= y3 || y4 <= start) {
        continue;
      }
      if (y3 >= start) {
        if (y4 > end) {
          results[j][1] = end;
        } else {
          if (jj === 1) {
            return [];
          }
          results.splice(j, 1);
          j--;
          jj--;
        }
        continue;
      }
      results[j][2] = start;
      if (y4 > end) {
        results.push([x, end, y4]);
      }
    }
  }
  return results;
}
var highlight_box2 = /*#__PURE__*/new WeakMap();
var _outlines = /*#__PURE__*/new WeakMap();
class HighlightOutline extends Outline {
  constructor(outlines, box, lastPoint) {
    super();
    highlight_classPrivateFieldInitSpec(this, highlight_box2, void 0);
    highlight_classPrivateFieldInitSpec(this, _outlines, void 0);
    highlight_classPrivateFieldSet(_outlines, this, outlines);
    highlight_classPrivateFieldSet(highlight_box2, this, box);
    this.lastPoint = lastPoint;
  }
  toSVGPath() {
    const buffer = [];
    for (const polygon of highlight_classPrivateFieldGet(_outlines, this)) {
      let [prevX, prevY] = polygon;
      buffer.push(`M${prevX} ${prevY}`);
      for (let i = 2; i < polygon.length; i += 2) {
        const x = polygon[i];
        const y = polygon[i + 1];
        if (x === prevX) {
          buffer.push(`V${y}`);
          prevY = y;
        } else if (y === prevY) {
          buffer.push(`H${x}`);
          prevX = x;
        }
      }
      buffer.push("Z");
    }
    return buffer.join(" ");
  }
  serialize(_ref, _rotation) {
    let [blX, blY, trX, trY] = _ref;
    const outlines = [];
    const width = trX - blX;
    const height = trY - blY;
    for (const outline of highlight_classPrivateFieldGet(_outlines, this)) {
      const points = new Array(outline.length);
      for (let i = 0; i < outline.length; i += 2) {
        points[i] = blX + outline[i] * width;
        points[i + 1] = trY - outline[i + 1] * height;
      }
      outlines.push(points);
    }
    return outlines;
  }
  get box() {
    return highlight_classPrivateFieldGet(highlight_box2, this);
  }
  get classNamesForOutlining() {
    return ["highlightOutline"];
  }
}
class FreeHighlightOutliner extends FreeDrawOutliner {
  newFreeDrawOutline(outline, points, box, scaleFactor, innerMargin, isLTR) {
    return new FreeHighlightOutline(outline, points, box, scaleFactor, innerMargin, isLTR);
  }
}
class FreeHighlightOutline extends FreeDrawOutline {
  newOutliner(point, box, scaleFactor, thickness, isLTR) {
    let innerMargin = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : 0;
    return new FreeHighlightOutliner(point, box, scaleFactor, thickness, isLTR, innerMargin);
  }
}

;// ./src/display/editor/color_picker.js
var _ColorPicker;

function color_picker_classPrivateMethodInitSpec(e, a) { color_picker_checkPrivateRedeclaration(e, a), a.add(e); }
function color_picker_classPrivateFieldInitSpec(e, t, a) { color_picker_checkPrivateRedeclaration(e, t), t.set(e, a); }
function color_picker_checkPrivateRedeclaration(e, t) { if (t.has(e)) throw new TypeError("Cannot initialize the same private elements twice on an object"); }
function color_picker_classPrivateGetter(s, r, a) { return a(color_picker_assertClassBrand(s, r)); }
function color_picker_classPrivateFieldGet(s, a) { return s.get(color_picker_assertClassBrand(s, a)); }
function color_picker_classPrivateFieldSet(s, a, r) { return s.set(color_picker_assertClassBrand(s, a), r), r; }
function color_picker_assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); }



var _button = /*#__PURE__*/new WeakMap();
var _buttonSwatch = /*#__PURE__*/new WeakMap();
var _defaultColor = /*#__PURE__*/new WeakMap();
var _dropdown = /*#__PURE__*/new WeakMap();
var _dropdownWasFromKeyboard = /*#__PURE__*/new WeakMap();
var _isMainColorPicker = /*#__PURE__*/new WeakMap();
var color_picker_editor = /*#__PURE__*/new WeakMap();
var _eventBus = /*#__PURE__*/new WeakMap();
var _openDropdownAC = /*#__PURE__*/new WeakMap();
var _uiManager = /*#__PURE__*/new WeakMap();
var _type = /*#__PURE__*/new WeakMap();
var _ColorPicker_brand = /*#__PURE__*/new WeakSet();
class ColorPicker {
  static get _keyboardManager() {
    return shadow(this, "_keyboardManager", new KeyboardManager([[["Escape", "mac+Escape"], ColorPicker.prototype._hideDropdownFromKeyboard], [[" ", "mac+ "], ColorPicker.prototype._colorSelectFromKeyboard], [["ArrowDown", "ArrowRight", "mac+ArrowDown", "mac+ArrowRight"], ColorPicker.prototype._moveToNext], [["ArrowUp", "ArrowLeft", "mac+ArrowUp", "mac+ArrowLeft"], ColorPicker.prototype._moveToPrevious], [["Home", "mac+Home"], ColorPicker.prototype._moveToBeginning], [["End", "mac+End"], ColorPicker.prototype._moveToEnd]]));
  }
  constructor(_ref) {
    let {
      editor = null,
      uiManager = null
    } = _ref;
    color_picker_classPrivateMethodInitSpec(this, _ColorPicker_brand);
    color_picker_classPrivateFieldInitSpec(this, _button, null);
    color_picker_classPrivateFieldInitSpec(this, _buttonSwatch, null);
    color_picker_classPrivateFieldInitSpec(this, _defaultColor, void 0);
    color_picker_classPrivateFieldInitSpec(this, _dropdown, null);
    color_picker_classPrivateFieldInitSpec(this, _dropdownWasFromKeyboard, false);
    color_picker_classPrivateFieldInitSpec(this, _isMainColorPicker, false);
    color_picker_classPrivateFieldInitSpec(this, color_picker_editor, null);
    color_picker_classPrivateFieldInitSpec(this, _eventBus, void 0);
    color_picker_classPrivateFieldInitSpec(this, _openDropdownAC, null);
    color_picker_classPrivateFieldInitSpec(this, _uiManager, null);
    color_picker_classPrivateFieldInitSpec(this, _type, void 0);
    if (editor) {
      color_picker_classPrivateFieldSet(_isMainColorPicker, this, false);
      color_picker_classPrivateFieldSet(_type, this, AnnotationEditorParamsType.HIGHLIGHT_COLOR);
      color_picker_classPrivateFieldSet(color_picker_editor, this, editor);
    } else {
      color_picker_classPrivateFieldSet(_isMainColorPicker, this, true);
      color_picker_classPrivateFieldSet(_type, this, AnnotationEditorParamsType.HIGHLIGHT_DEFAULT_COLOR);
    }
    color_picker_classPrivateFieldSet(_uiManager, this, editor?._uiManager || uiManager);
    color_picker_classPrivateFieldSet(_eventBus, this, color_picker_classPrivateFieldGet(_uiManager, this)._eventBus);
    color_picker_classPrivateFieldSet(_defaultColor, this, editor?.color || color_picker_classPrivateFieldGet(_uiManager, this)?.highlightColors.values().next().value || "#FFFF98");
    _l10nColor._ || (_l10nColor._ = Object.freeze({
      blue: "pdfjs-editor-colorpicker-blue",
      green: "pdfjs-editor-colorpicker-green",
      pink: "pdfjs-editor-colorpicker-pink",
      red: "pdfjs-editor-colorpicker-red",
      yellow: "pdfjs-editor-colorpicker-yellow"
    }));
  }
  renderButton() {
    const button = color_picker_classPrivateFieldSet(_button, this, document.createElement("button"));
    button.className = "colorPicker";
    button.tabIndex = "0";
    button.setAttribute("data-l10n-id", "pdfjs-editor-colorpicker-button");
    button.setAttribute("aria-haspopup", true);
    const signal = color_picker_classPrivateFieldGet(_uiManager, this)._signal;
    button.addEventListener("click", color_picker_assertClassBrand(_ColorPicker_brand, this, _openDropdown).bind(this), {
      signal
    });
    button.addEventListener("keydown", color_picker_assertClassBrand(_ColorPicker_brand, this, color_picker_keyDown).bind(this), {
      signal
    });
    const swatch = color_picker_classPrivateFieldSet(_buttonSwatch, this, document.createElement("span"));
    swatch.className = "swatch";
    swatch.setAttribute("aria-hidden", true);
    swatch.style.backgroundColor = color_picker_classPrivateFieldGet(_defaultColor, this);
    button.append(swatch);
    return button;
  }
  renderMainDropdown() {
    const dropdown = color_picker_classPrivateFieldSet(_dropdown, this, color_picker_assertClassBrand(_ColorPicker_brand, this, _getDropdownRoot).call(this));
    dropdown.setAttribute("aria-orientation", "horizontal");
    dropdown.setAttribute("aria-labelledby", "highlightColorPickerLabel");
    return dropdown;
  }
  _colorSelectFromKeyboard(event) {
    if (event.target === color_picker_classPrivateFieldGet(_button, this)) {
      color_picker_assertClassBrand(_ColorPicker_brand, this, _openDropdown).call(this, event);
      return;
    }
    const color = event.target.getAttribute("data-color");
    if (!color) {
      return;
    }
    color_picker_assertClassBrand(_ColorPicker_brand, this, _colorSelect).call(this, color, event);
  }
  _moveToNext(event) {
    if (!color_picker_classPrivateGetter(_ColorPicker_brand, this, _get_isDropdownVisible)) {
      color_picker_assertClassBrand(_ColorPicker_brand, this, _openDropdown).call(this, event);
      return;
    }
    if (event.target === color_picker_classPrivateFieldGet(_button, this)) {
      color_picker_classPrivateFieldGet(_dropdown, this).firstChild?.focus();
      return;
    }
    event.target.nextSibling?.focus();
  }
  _moveToPrevious(event) {
    if (event.target === color_picker_classPrivateFieldGet(_dropdown, this)?.firstChild || event.target === color_picker_classPrivateFieldGet(_button, this)) {
      if (color_picker_classPrivateGetter(_ColorPicker_brand, this, _get_isDropdownVisible)) {
        this._hideDropdownFromKeyboard();
      }
      return;
    }
    if (!color_picker_classPrivateGetter(_ColorPicker_brand, this, _get_isDropdownVisible)) {
      color_picker_assertClassBrand(_ColorPicker_brand, this, _openDropdown).call(this, event);
    }
    event.target.previousSibling?.focus();
  }
  _moveToBeginning(event) {
    if (!color_picker_classPrivateGetter(_ColorPicker_brand, this, _get_isDropdownVisible)) {
      color_picker_assertClassBrand(_ColorPicker_brand, this, _openDropdown).call(this, event);
      return;
    }
    color_picker_classPrivateFieldGet(_dropdown, this).firstChild?.focus();
  }
  _moveToEnd(event) {
    if (!color_picker_classPrivateGetter(_ColorPicker_brand, this, _get_isDropdownVisible)) {
      color_picker_assertClassBrand(_ColorPicker_brand, this, _openDropdown).call(this, event);
      return;
    }
    color_picker_classPrivateFieldGet(_dropdown, this).lastChild?.focus();
  }
  hideDropdown() {
    color_picker_classPrivateFieldGet(_dropdown, this)?.classList.add("hidden");
    color_picker_classPrivateFieldGet(_openDropdownAC, this)?.abort();
    color_picker_classPrivateFieldSet(_openDropdownAC, this, null);
  }
  _hideDropdownFromKeyboard() {
    if (color_picker_classPrivateFieldGet(_isMainColorPicker, this)) {
      return;
    }
    if (!color_picker_classPrivateGetter(_ColorPicker_brand, this, _get_isDropdownVisible)) {
      color_picker_classPrivateFieldGet(color_picker_editor, this)?.unselect();
      return;
    }
    this.hideDropdown();
    color_picker_classPrivateFieldGet(_button, this).focus({
      preventScroll: true,
      focusVisible: color_picker_classPrivateFieldGet(_dropdownWasFromKeyboard, this)
    });
  }
  updateColor(color) {
    if (color_picker_classPrivateFieldGet(_buttonSwatch, this)) {
      color_picker_classPrivateFieldGet(_buttonSwatch, this).style.backgroundColor = color;
    }
    if (!color_picker_classPrivateFieldGet(_dropdown, this)) {
      return;
    }
    const i = color_picker_classPrivateFieldGet(_uiManager, this).highlightColors.values();
    for (const child of color_picker_classPrivateFieldGet(_dropdown, this).children) {
      child.setAttribute("aria-selected", i.next().value === color);
    }
  }
  destroy() {
    color_picker_classPrivateFieldGet(_button, this)?.remove();
    color_picker_classPrivateFieldSet(_button, this, null);
    color_picker_classPrivateFieldSet(_buttonSwatch, this, null);
    color_picker_classPrivateFieldGet(_dropdown, this)?.remove();
    color_picker_classPrivateFieldSet(_dropdown, this, null);
  }
}
_ColorPicker = ColorPicker;
function _getDropdownRoot() {
  const div = document.createElement("div");
  const signal = color_picker_classPrivateFieldGet(_uiManager, this)._signal;
  div.addEventListener("contextmenu", noContextMenu, {
    signal
  });
  div.className = "dropdown";
  div.role = "listbox";
  div.setAttribute("aria-multiselectable", false);
  div.setAttribute("aria-orientation", "vertical");
  div.setAttribute("data-l10n-id", "pdfjs-editor-colorpicker-dropdown");
  for (const [name, color] of color_picker_classPrivateFieldGet(_uiManager, this).highlightColors) {
    const button = document.createElement("button");
    button.tabIndex = "0";
    button.role = "option";
    button.setAttribute("data-color", color);
    button.title = name;
    button.setAttribute("data-l10n-id", _l10nColor._[name]);
    const swatch = document.createElement("span");
    button.append(swatch);
    swatch.className = "swatch";
    swatch.style.backgroundColor = color;
    button.setAttribute("aria-selected", color === color_picker_classPrivateFieldGet(_defaultColor, this));
    button.addEventListener("click", color_picker_assertClassBrand(_ColorPicker_brand, this, _colorSelect).bind(this, color), {
      signal
    });
    div.append(button);
  }
  div.addEventListener("keydown", color_picker_assertClassBrand(_ColorPicker_brand, this, color_picker_keyDown).bind(this), {
    signal
  });
  return div;
}
function _colorSelect(color, event) {
  event.stopPropagation();
  color_picker_classPrivateFieldGet(_eventBus, this).dispatch("switchannotationeditorparams", {
    source: this,
    type: color_picker_classPrivateFieldGet(_type, this),
    value: color
  });
}
function color_picker_keyDown(event) {
  _ColorPicker._keyboardManager.exec(this, event);
}
function _openDropdown(event) {
  if (color_picker_classPrivateGetter(_ColorPicker_brand, this, _get_isDropdownVisible)) {
    this.hideDropdown();
    return;
  }
  color_picker_classPrivateFieldSet(_dropdownWasFromKeyboard, this, event.detail === 0);
  if (!color_picker_classPrivateFieldGet(_openDropdownAC, this)) {
    color_picker_classPrivateFieldSet(_openDropdownAC, this, new AbortController());
    window.addEventListener("pointerdown", color_picker_assertClassBrand(_ColorPicker_brand, this, color_picker_pointerDown).bind(this), {
      signal: color_picker_classPrivateFieldGet(_uiManager, this).combinedSignal(color_picker_classPrivateFieldGet(_openDropdownAC, this))
    });
  }
  if (color_picker_classPrivateFieldGet(_dropdown, this)) {
    color_picker_classPrivateFieldGet(_dropdown, this).classList.remove("hidden");
    return;
  }
  const root = color_picker_classPrivateFieldSet(_dropdown, this, color_picker_assertClassBrand(_ColorPicker_brand, this, _getDropdownRoot).call(this));
  color_picker_classPrivateFieldGet(_button, this).append(root);
}
function color_picker_pointerDown(event) {
  if (color_picker_classPrivateFieldGet(_dropdown, this)?.contains(event.target)) {
    return;
  }
  this.hideDropdown();
}
function _get_isDropdownVisible(_this) {
  return color_picker_classPrivateFieldGet(_dropdown, _this) && !color_picker_classPrivateFieldGet(_dropdown, _this).classList.contains("hidden");
}
var _l10nColor = {
  _: null
};

;// ./src/display/editor/highlight.js
var _HighlightEditor;

















function editor_highlight_classPrivateMethodInitSpec(e, a) { editor_highlight_checkPrivateRedeclaration(e, a), a.add(e); }
function highlight_defineProperty(e, r, t) { return (r = highlight_toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function highlight_toPropertyKey(t) { var i = highlight_toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function highlight_toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function editor_highlight_classPrivateFieldInitSpec(e, t, a) { editor_highlight_checkPrivateRedeclaration(e, t), t.set(e, a); }
function editor_highlight_checkPrivateRedeclaration(e, t) { if (t.has(e)) throw new TypeError("Cannot initialize the same private elements twice on an object"); }
function highlight_toSetter(t, e, n) { e || (e = []); var r = e.length++; return Object.defineProperty({}, "_", { set: function (o) { e[r] = o, t.apply(n, e); } }); }
function editor_highlight_classPrivateFieldGet(s, a) { return s.get(editor_highlight_assertClassBrand(s, a)); }
function editor_highlight_classPrivateFieldSet(s, a, r) { return s.set(editor_highlight_assertClassBrand(s, a), r), r; }
function editor_highlight_assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); }







var _anchorNode = /*#__PURE__*/new WeakMap();
var _anchorOffset = /*#__PURE__*/new WeakMap();
var _boxes = /*#__PURE__*/new WeakMap();
var _clipPathId = /*#__PURE__*/new WeakMap();
var highlight_colorPicker = /*#__PURE__*/new WeakMap();
var _focusOutlines = /*#__PURE__*/new WeakMap();
var _focusNode = /*#__PURE__*/new WeakMap();
var _focusOffset = /*#__PURE__*/new WeakMap();
var _highlightDiv = /*#__PURE__*/new WeakMap();
var _highlightOutlines = /*#__PURE__*/new WeakMap();
var highlight_id = /*#__PURE__*/new WeakMap();
var _isFreeHighlight = /*#__PURE__*/new WeakMap();
var highlight_lastPoint = /*#__PURE__*/new WeakMap();
var _opacity = /*#__PURE__*/new WeakMap();
var _outlineId = /*#__PURE__*/new WeakMap();
var _text = /*#__PURE__*/new WeakMap();
var highlight_thickness = /*#__PURE__*/new WeakMap();
var _methodOfCreation = /*#__PURE__*/new WeakMap();
var _HighlightEditor_brand = /*#__PURE__*/new WeakSet();
class HighlightEditor extends AnnotationEditor {
  static get _keyboardManager() {
    const proto = HighlightEditor.prototype;
    return shadow(this, "_keyboardManager", new KeyboardManager([[["ArrowLeft", "mac+ArrowLeft"], proto._moveCaret, {
      args: [0]
    }], [["ArrowRight", "mac+ArrowRight"], proto._moveCaret, {
      args: [1]
    }], [["ArrowUp", "mac+ArrowUp"], proto._moveCaret, {
      args: [2]
    }], [["ArrowDown", "mac+ArrowDown"], proto._moveCaret, {
      args: [3]
    }]]));
  }
  constructor(params) {
    super({
      ...params,
      name: "highlightEditor"
    });
    editor_highlight_classPrivateMethodInitSpec(this, _HighlightEditor_brand);
    editor_highlight_classPrivateFieldInitSpec(this, _anchorNode, null);
    editor_highlight_classPrivateFieldInitSpec(this, _anchorOffset, 0);
    editor_highlight_classPrivateFieldInitSpec(this, _boxes, void 0);
    editor_highlight_classPrivateFieldInitSpec(this, _clipPathId, null);
    editor_highlight_classPrivateFieldInitSpec(this, highlight_colorPicker, null);
    editor_highlight_classPrivateFieldInitSpec(this, _focusOutlines, null);
    editor_highlight_classPrivateFieldInitSpec(this, _focusNode, null);
    editor_highlight_classPrivateFieldInitSpec(this, _focusOffset, 0);
    editor_highlight_classPrivateFieldInitSpec(this, _highlightDiv, null);
    editor_highlight_classPrivateFieldInitSpec(this, _highlightOutlines, null);
    editor_highlight_classPrivateFieldInitSpec(this, highlight_id, null);
    editor_highlight_classPrivateFieldInitSpec(this, _isFreeHighlight, false);
    editor_highlight_classPrivateFieldInitSpec(this, highlight_lastPoint, null);
    editor_highlight_classPrivateFieldInitSpec(this, _opacity, void 0);
    editor_highlight_classPrivateFieldInitSpec(this, _outlineId, null);
    editor_highlight_classPrivateFieldInitSpec(this, _text, "");
    editor_highlight_classPrivateFieldInitSpec(this, highlight_thickness, void 0);
    editor_highlight_classPrivateFieldInitSpec(this, _methodOfCreation, "");
    this.color = params.color || HighlightEditor._defaultColor;
    editor_highlight_classPrivateFieldSet(highlight_thickness, this, params.thickness || HighlightEditor._defaultThickness);
    editor_highlight_classPrivateFieldSet(_opacity, this, params.opacity || HighlightEditor._defaultOpacity);
    editor_highlight_classPrivateFieldSet(_boxes, this, params.boxes || null);
    editor_highlight_classPrivateFieldSet(_methodOfCreation, this, params.methodOfCreation || "");
    editor_highlight_classPrivateFieldSet(_text, this, params.text || "");
    this._isDraggable = false;
    this.defaultL10nId = "pdfjs-editor-highlight-editor";
    if (params.highlightId > -1) {
      editor_highlight_classPrivateFieldSet(_isFreeHighlight, this, true);
      editor_highlight_assertClassBrand(_HighlightEditor_brand, this, _createFreeOutlines).call(this, params);
      editor_highlight_assertClassBrand(_HighlightEditor_brand, this, _addToDrawLayer).call(this);
    } else if (editor_highlight_classPrivateFieldGet(_boxes, this)) {
      editor_highlight_classPrivateFieldSet(_anchorNode, this, params.anchorNode);
      editor_highlight_classPrivateFieldSet(_anchorOffset, this, params.anchorOffset);
      editor_highlight_classPrivateFieldSet(_focusNode, this, params.focusNode);
      editor_highlight_classPrivateFieldSet(_focusOffset, this, params.focusOffset);
      editor_highlight_assertClassBrand(_HighlightEditor_brand, this, _createOutlines).call(this);
      editor_highlight_assertClassBrand(_HighlightEditor_brand, this, _addToDrawLayer).call(this);
      this.rotate(this.rotation);
    }
    this.eventBus?.dispatch("annotation-editor-event", {
      source: this,
      type: "added",
      page: this.pageIndex + 1,
      editorType: this.constructor.name,
      value: {
        color: this.color,
        thickness: editor_highlight_classPrivateFieldGet(highlight_thickness, this),
        isFreeHighlight: editor_highlight_classPrivateFieldGet(_isFreeHighlight, this),
        text: editor_highlight_classPrivateFieldGet(_text, this)
      }
    });
  }
  get telemetryInitialData() {
    return {
      action: "added",
      type: editor_highlight_classPrivateFieldGet(_isFreeHighlight, this) ? "free_highlight" : "highlight",
      color: this._uiManager.highlightColorNames.get(this.color),
      thickness: editor_highlight_classPrivateFieldGet(highlight_thickness, this),
      methodOfCreation: editor_highlight_classPrivateFieldGet(_methodOfCreation, this)
    };
  }
  get telemetryFinalData() {
    return {
      type: "highlight",
      color: this._uiManager.highlightColorNames.get(this.color)
    };
  }
  static computeTelemetryFinalData(data) {
    return {
      numberOfColors: data.get("color").size
    };
  }
  static initialize(l10n, uiManager) {
    AnnotationEditor.initialize(l10n, uiManager);
    HighlightEditor._defaultColor ||= uiManager.highlightColors?.values().next().value || "#fff066";
  }
  static updateDefaultParams(type, value) {
    switch (type) {
      case AnnotationEditorParamsType.HIGHLIGHT_DEFAULT_COLOR:
        HighlightEditor._defaultColor = value;
        break;
      case AnnotationEditorParamsType.HIGHLIGHT_THICKNESS:
        HighlightEditor._defaultThickness = value;
        break;
    }
  }
  translateInPage(x, y) {}
  get toolbarPosition() {
    return editor_highlight_classPrivateFieldGet(highlight_lastPoint, this);
  }
  updateParams(type, value) {
    switch (type) {
      case AnnotationEditorParamsType.HIGHLIGHT_COLOR:
        editor_highlight_assertClassBrand(_HighlightEditor_brand, this, highlight_updateColor).call(this, value);
        break;
      case AnnotationEditorParamsType.HIGHLIGHT_THICKNESS:
        editor_highlight_assertClassBrand(_HighlightEditor_brand, this, _updateThickness).call(this, value);
        break;
    }
  }
  static get defaultPropertiesToUpdate() {
    return [[AnnotationEditorParamsType.HIGHLIGHT_DEFAULT_COLOR, HighlightEditor._defaultColor], [AnnotationEditorParamsType.HIGHLIGHT_THICKNESS, HighlightEditor._defaultThickness]];
  }
  get propertiesToUpdate() {
    return [[AnnotationEditorParamsType.HIGHLIGHT_COLOR, this.color || HighlightEditor._defaultColor], [AnnotationEditorParamsType.HIGHLIGHT_THICKNESS, editor_highlight_classPrivateFieldGet(highlight_thickness, this) || HighlightEditor._defaultThickness], [AnnotationEditorParamsType.HIGHLIGHT_FREE, editor_highlight_classPrivateFieldGet(_isFreeHighlight, this)]];
  }
  async addEditToolbar() {
    const toolbar = await super.addEditToolbar();
    if (!toolbar) {
      return null;
    }
    if (this._uiManager.highlightColors) {
      editor_highlight_classPrivateFieldSet(highlight_colorPicker, this, new ColorPicker({
        editor: this
      }));
      toolbar.addColorPicker(editor_highlight_classPrivateFieldGet(highlight_colorPicker, this));
    }
    return toolbar;
  }
  disableEditing() {
    super.disableEditing();
    this.div.classList.toggle("disabled", true);
  }
  enableEditing() {
    super.enableEditing();
    this.div.classList.toggle("disabled", false);
  }
  fixAndSetPosition() {
    return super.fixAndSetPosition(editor_highlight_assertClassBrand(_HighlightEditor_brand, this, _getRotation).call(this));
  }
  getBaseTranslation() {
    return [0, 0];
  }
  getRect(tx, ty) {
    return super.getRect(tx, ty, editor_highlight_assertClassBrand(_HighlightEditor_brand, this, _getRotation).call(this));
  }
  onceAdded(focus) {
    if (!this.annotationElementId) {
      this.parent.addUndoableEditor(this);
    }
    if (focus) {
      this.div.focus();
    }
  }
  remove() {
    editor_highlight_assertClassBrand(_HighlightEditor_brand, this, _cleanDrawLayer).call(this);
    this._reportTelemetry({
      action: "deleted"
    });
    super.remove();
  }
  rebuild() {
    if (!this.parent) {
      return;
    }
    super.rebuild();
    if (this.div === null) {
      return;
    }
    editor_highlight_assertClassBrand(_HighlightEditor_brand, this, _addToDrawLayer).call(this);
    if (!this.isAttachedToDOM) {
      this.parent.add(this);
    }
  }
  setParent(parent) {
    let mustBeSelected = false;
    if (this.parent && !parent) {
      editor_highlight_assertClassBrand(_HighlightEditor_brand, this, _cleanDrawLayer).call(this);
    } else if (parent) {
      editor_highlight_assertClassBrand(_HighlightEditor_brand, this, _addToDrawLayer).call(this, parent);
      mustBeSelected = !this.parent && this.div?.classList.contains("selectedEditor");
    }
    super.setParent(parent);
    this.show(this._isVisible);
    if (mustBeSelected) {
      this.select();
    }
  }
  rotate(angle) {
    const {
      drawLayer
    } = this.parent;
    let box;
    if (editor_highlight_classPrivateFieldGet(_isFreeHighlight, this)) {
      angle = (angle - this.rotation + 360) % 360;
      box = _rotateBbox.call(HighlightEditor, editor_highlight_classPrivateFieldGet(_highlightOutlines, this).box, angle);
    } else {
      box = _rotateBbox.call(HighlightEditor, [this.x, this.y, this.width, this.height], angle);
    }
    drawLayer.updateProperties(editor_highlight_classPrivateFieldGet(highlight_id, this), {
      bbox: box,
      root: {
        "data-main-rotation": angle
      }
    });
    drawLayer.updateProperties(editor_highlight_classPrivateFieldGet(_outlineId, this), {
      bbox: _rotateBbox.call(HighlightEditor, editor_highlight_classPrivateFieldGet(_focusOutlines, this).box, angle),
      root: {
        "data-main-rotation": angle
      }
    });
  }
  render() {
    if (this.div) {
      return this.div;
    }
    const div = super.render();
    if (editor_highlight_classPrivateFieldGet(_text, this)) {
      div.setAttribute("aria-label", editor_highlight_classPrivateFieldGet(_text, this));
      div.setAttribute("role", "mark");
    }
    if (editor_highlight_classPrivateFieldGet(_isFreeHighlight, this)) {
      div.classList.add("free");
    } else {
      this.div.addEventListener("keydown", editor_highlight_assertClassBrand(_HighlightEditor_brand, this, _keydown).bind(this), {
        signal: this._uiManager._signal
      });
    }
    const highlightDiv = editor_highlight_classPrivateFieldSet(_highlightDiv, this, document.createElement("div"));
    div.append(highlightDiv);
    highlightDiv.setAttribute("aria-hidden", "true");
    highlightDiv.className = "internal";
    highlightDiv.style.clipPath = editor_highlight_classPrivateFieldGet(_clipPathId, this);
    const [parentWidth, parentHeight] = this.parentDimensions;
    this.setDims(this.width * parentWidth, this.height * parentHeight);
    bindEvents(this, editor_highlight_classPrivateFieldGet(_highlightDiv, this), ["pointerover", "pointerleave"]);
    this.enableEditing();
    return div;
  }
  pointerover() {
    if (!this.isSelected) {
      this.parent?.drawLayer.updateProperties(editor_highlight_classPrivateFieldGet(_outlineId, this), {
        rootClass: {
          hovered: true
        }
      });
    }
  }
  pointerleave() {
    if (!this.isSelected) {
      this.parent?.drawLayer.updateProperties(editor_highlight_classPrivateFieldGet(_outlineId, this), {
        rootClass: {
          hovered: false
        }
      });
    }
  }
  _moveCaret(direction) {
    this.parent.unselect(this);
    switch (direction) {
      case 0:
      case 2:
        editor_highlight_assertClassBrand(_HighlightEditor_brand, this, _setCaret).call(this, true);
        break;
      case 1:
      case 3:
        editor_highlight_assertClassBrand(_HighlightEditor_brand, this, _setCaret).call(this, false);
        break;
    }
  }
  select() {
    super.select();
    if (!editor_highlight_classPrivateFieldGet(_outlineId, this)) {
      return;
    }
    this.parent?.drawLayer.updateProperties(editor_highlight_classPrivateFieldGet(_outlineId, this), {
      rootClass: {
        hovered: false,
        selected: true
      }
    });
  }
  unselect() {
    super.unselect();
    if (!editor_highlight_classPrivateFieldGet(_outlineId, this)) {
      return;
    }
    this.parent?.drawLayer.updateProperties(editor_highlight_classPrivateFieldGet(_outlineId, this), {
      rootClass: {
        selected: false
      }
    });
    if (!editor_highlight_classPrivateFieldGet(_isFreeHighlight, this)) {
      editor_highlight_assertClassBrand(_HighlightEditor_brand, this, _setCaret).call(this, false);
    }
  }
  get _mustFixPosition() {
    return !editor_highlight_classPrivateFieldGet(_isFreeHighlight, this);
  }
  show() {
    let visible = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : this._isVisible;
    super.show(visible);
    if (this.parent) {
      this.parent.drawLayer.updateProperties(editor_highlight_classPrivateFieldGet(highlight_id, this), {
        rootClass: {
          hidden: !visible
        }
      });
      this.parent.drawLayer.updateProperties(editor_highlight_classPrivateFieldGet(_outlineId, this), {
        rootClass: {
          hidden: !visible
        }
      });
    }
  }
  static startHighlighting(parent, isLTR, _ref) {
    let {
      target: textLayer,
      x,
      y
    } = _ref;
    const {
      x: layerX,
      y: layerY,
      width: parentWidth,
      height: parentHeight
    } = textLayer.getBoundingClientRect();
    const ac = new AbortController();
    const signal = parent.combinedSignal(ac);
    const pointerUpCallback = e => {
      ac.abort();
      editor_highlight_assertClassBrand(HighlightEditor, this, _endHighlight).call(this, parent, e);
    };
    window.addEventListener("blur", pointerUpCallback, {
      signal
    });
    window.addEventListener("pointerup", pointerUpCallback, {
      signal
    });
    window.addEventListener("pointerdown", stopEvent, {
      capture: true,
      passive: false,
      signal
    });
    window.addEventListener("contextmenu", noContextMenu, {
      signal
    });
    textLayer.addEventListener("pointermove", editor_highlight_assertClassBrand(HighlightEditor, this, _highlightMove).bind(this, parent), {
      signal
    });
    this._freeHighlight = new FreeHighlightOutliner({
      x,
      y
    }, [layerX, layerY, parentWidth, parentHeight], parent.scale, this._defaultThickness / 2, isLTR, 0.001);
    ({
      id: this._freeHighlightId,
      clipPathId: this._freeHighlightClipId
    } = parent.drawLayer.draw({
      bbox: [0, 0, 1, 1],
      root: {
        viewBox: "0 0 1 1",
        fill: this._defaultColor,
        "fill-opacity": this._defaultOpacity
      },
      rootClass: {
        highlight: true,
        free: true
      },
      path: {
        d: this._freeHighlight.toSVGPath()
      }
    }, true, true));
  }
  static async deserialize(data, parent, uiManager) {
    let initialData = null;
    if (data instanceof HighlightAnnotationElement) {
      const {
        data: {
          quadPoints,
          rect,
          rotation,
          id,
          color,
          opacity,
          popupRef
        },
        parent: {
          page: {
            pageNumber
          }
        }
      } = data;
      initialData = data = {
        annotationType: AnnotationEditorType.HIGHLIGHT,
        color: Array.from(color),
        opacity,
        quadPoints,
        boxes: null,
        pageIndex: pageNumber - 1,
        rect: rect.slice(0),
        rotation,
        id,
        deleted: false,
        popupRef
      };
    } else if (data.annotationType && data.annotationType === AnnotationEditorType.HIGHLIGHT) {
      let {
        quadPoints,
        outlines,
        rect,
        rotation,
        id,
        color,
        opacity,
        popupRef,
        pageIndex,
        thickness
      } = data;
      if (quadPoints) {
        if (!Array.isArray(quadPoints)) {
          quadPoints = Object.values(quadPoints);
        }
      }
      let inkLists;
      if (!quadPoints && outlines) {
        if (Array.isArray(outlines)) {
          inkLists = outlines.map(subArray => subArray);
        } else if (typeof outlines === "object" && outlines.points) {
          inkLists = [outlines.points.flat()];
        } else {
          console.error("Unexpected outlines format");
          return null;
        }
        thickness = thickness || data.thickness || 1;
      }
      initialData = data = {
        annotationType: AnnotationEditorType.HIGHLIGHT,
        color: Array.from(color),
        opacity,
        quadPoints,
        inkLists,
        thickness,
        boxes: null,
        pageIndex,
        rect: rect.slice(0),
        rotation,
        id,
        deleted: false,
        popupRef: popupRef || null
      };
    } else if (data instanceof InkAnnotationElement) {
      const {
        data: {
          inkLists,
          rect,
          rotation,
          id,
          color,
          borderStyle: {
            rawWidth: thickness
          },
          popupRef
        },
        parent: {
          page: {
            pageNumber
          }
        }
      } = data;
      initialData = data = {
        annotationType: AnnotationEditorType.HIGHLIGHT,
        color: Array.from(color),
        thickness,
        inkLists,
        boxes: null,
        pageIndex: pageNumber - 1,
        rect: rect.slice(0),
        rotation,
        id,
        deleted: false,
        popupRef
      };
    }
    const {
      color,
      quadPoints,
      inkLists,
      opacity
    } = data;
    const editor = await super.deserialize(data, parent, uiManager);
    editor.color = Util.makeHexColor(...color);
    editor_highlight_classPrivateFieldSet(_opacity, editor, opacity || 1);
    if (inkLists) {
      editor_highlight_classPrivateFieldSet(highlight_thickness, editor, data.thickness);
    }
    editor.annotationElementId = data.id || null;
    editor._initialData = initialData;
    const [pageWidth, pageHeight] = editor.pageDimensions;
    const [pageX, pageY] = editor.pageTranslation;
    if (quadPoints) {
      const boxes = editor_highlight_classPrivateFieldSet(_boxes, editor, []);
      for (let i = 0; i < quadPoints.length; i += 8) {
        boxes.push({
          x: (quadPoints[i] - pageX) / pageWidth,
          y: 1 - (quadPoints[i + 1] - pageY) / pageHeight,
          width: (quadPoints[i + 2] - quadPoints[i]) / pageWidth,
          height: (quadPoints[i + 1] - quadPoints[i + 5]) / pageHeight
        });
      }
      editor_highlight_assertClassBrand(_HighlightEditor_brand, editor, _createOutlines).call(editor);
      editor_highlight_assertClassBrand(_HighlightEditor_brand, editor, _addToDrawLayer).call(editor);
      editor.rotate(editor.rotation);
    } else if (inkLists) {
      editor_highlight_classPrivateFieldSet(_isFreeHighlight, editor, true);
      const points = inkLists[0];
      const point = {
        x: points[0] - pageX,
        y: pageHeight - (points[1] - pageY)
      };
      const outliner = new FreeHighlightOutliner(point, [0, 0, pageWidth, pageHeight], 1, editor_highlight_classPrivateFieldGet(highlight_thickness, editor) / 2, true, 0.001);
      for (let i = 0, ii = points.length; i < ii; i += 2) {
        point.x = points[i] - pageX;
        point.y = pageHeight - (points[i + 1] - pageY);
        outliner.add(point);
      }
      const {
        id,
        clipPathId
      } = parent.drawLayer.draw({
        bbox: [0, 0, 1, 1],
        root: {
          viewBox: "0 0 1 1",
          fill: editor.color,
          "fill-opacity": editor._defaultOpacity
        },
        rootClass: {
          highlight: true,
          free: true
        },
        path: {
          d: outliner.toSVGPath()
        }
      }, true, true);
      editor_highlight_assertClassBrand(_HighlightEditor_brand, editor, _createFreeOutlines).call(editor, {
        highlightOutlines: outliner.getOutlines(),
        highlightId: id,
        clipPathId
      });
      editor_highlight_assertClassBrand(_HighlightEditor_brand, editor, _addToDrawLayer).call(editor);
      editor.rotate(editor.parentRotation);
    }
    return editor;
  }
  serialize() {
    let isForCopying = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
    if (this.isEmpty() || isForCopying) {
      return null;
    }
    if (this.deleted) {
      return this.serializeDeleted();
    }
    const rect = this.getRect(0, 0);
    const color = AnnotationEditor._colorManager.convert(this.color);
    const serialized = {
      annotationType: AnnotationEditorType.HIGHLIGHT,
      color,
      opacity: editor_highlight_classPrivateFieldGet(_opacity, this),
      thickness: editor_highlight_classPrivateFieldGet(highlight_thickness, this),
      quadPoints: editor_highlight_assertClassBrand(_HighlightEditor_brand, this, _serializeBoxes).call(this),
      outlines: editor_highlight_assertClassBrand(_HighlightEditor_brand, this, _serializeOutlines).call(this, rect),
      pageIndex: this.pageIndex,
      rect,
      rotation: editor_highlight_assertClassBrand(_HighlightEditor_brand, this, _getRotation).call(this),
      structTreeParentId: this._structTreeParentId
    };
    if (this.annotationElementId && !editor_highlight_assertClassBrand(_HighlightEditor_brand, this, highlight_hasElementChanged).call(this, serialized)) {
      return null;
    }
    serialized.id = this.annotationElementId;
    return serialized;
  }
  renderAnnotationElement(annotation) {
    annotation.updateEdited({
      rect: this.getRect(0, 0)
    });
    return null;
  }
  static canCreateNewEmptyEditor() {
    return false;
  }
}
_HighlightEditor = HighlightEditor;
function _createOutlines() {
  const outliner = new HighlightOutliner(editor_highlight_classPrivateFieldGet(_boxes, this), 0.001);
  editor_highlight_classPrivateFieldSet(_highlightOutlines, this, outliner.getOutlines());
  [this.x, this.y, this.width, this.height] = editor_highlight_classPrivateFieldGet(_highlightOutlines, this).box;
  const outlinerForOutline = new HighlightOutliner(editor_highlight_classPrivateFieldGet(_boxes, this), 0.0025, 0.001, this._uiManager.direction === "ltr");
  editor_highlight_classPrivateFieldSet(_focusOutlines, this, outlinerForOutline.getOutlines());
  const {
    lastPoint
  } = editor_highlight_classPrivateFieldGet(_focusOutlines, this);
  editor_highlight_classPrivateFieldSet(highlight_lastPoint, this, [(lastPoint[0] - this.x) / this.width, (lastPoint[1] - this.y) / this.height]);
}
function _createFreeOutlines(_ref2) {
  let {
    highlightOutlines,
    highlightId,
    clipPathId
  } = _ref2;
  editor_highlight_classPrivateFieldSet(_highlightOutlines, this, highlightOutlines);
  const extraThickness = 1.5;
  editor_highlight_classPrivateFieldSet(_focusOutlines, this, highlightOutlines.getNewOutline(editor_highlight_classPrivateFieldGet(highlight_thickness, this) / 2 + extraThickness, 0.0025));
  if (highlightId >= 0) {
    editor_highlight_classPrivateFieldSet(highlight_id, this, highlightId);
    editor_highlight_classPrivateFieldSet(_clipPathId, this, clipPathId);
    this.parent.drawLayer.finalizeDraw(highlightId, {
      bbox: highlightOutlines.box,
      path: {
        d: highlightOutlines.toSVGPath()
      }
    });
    editor_highlight_classPrivateFieldSet(_outlineId, this, this.parent.drawLayer.drawOutline({
      rootClass: {
        highlightOutline: true,
        free: true
      },
      bbox: editor_highlight_classPrivateFieldGet(_focusOutlines, this).box,
      path: {
        d: editor_highlight_classPrivateFieldGet(_focusOutlines, this).toSVGPath()
      }
    }, true));
  } else if (this.parent) {
    const angle = this.parent.viewport.rotation;
    this.parent.drawLayer.updateProperties(editor_highlight_classPrivateFieldGet(highlight_id, this), {
      bbox: _rotateBbox.call(_HighlightEditor, editor_highlight_classPrivateFieldGet(_highlightOutlines, this).box, (angle - this.rotation + 360) % 360),
      path: {
        d: highlightOutlines.toSVGPath()
      }
    });
    this.parent.drawLayer.updateProperties(editor_highlight_classPrivateFieldGet(_outlineId, this), {
      bbox: _rotateBbox.call(_HighlightEditor, editor_highlight_classPrivateFieldGet(_focusOutlines, this).box, angle),
      path: {
        d: editor_highlight_classPrivateFieldGet(_focusOutlines, this).toSVGPath()
      }
    });
  }
  const [x, y, width, height] = highlightOutlines.box;
  switch (this.rotation) {
    case 0:
      this.x = x;
      this.y = y;
      this.width = width;
      this.height = height;
      break;
    case 90:
      {
        const [pageWidth, pageHeight] = this.parentDimensions;
        this.x = y;
        this.y = 1 - x;
        this.width = width * pageHeight / pageWidth;
        this.height = height * pageWidth / pageHeight;
        break;
      }
    case 180:
      this.x = 1 - x;
      this.y = 1 - y;
      this.width = width;
      this.height = height;
      break;
    case 270:
      {
        const [pageWidth, pageHeight] = this.parentDimensions;
        this.x = 1 - y;
        this.y = x;
        this.width = width * pageHeight / pageWidth;
        this.height = height * pageWidth / pageHeight;
        break;
      }
  }
  const {
    lastPoint
  } = editor_highlight_classPrivateFieldGet(_focusOutlines, this);
  editor_highlight_classPrivateFieldSet(highlight_lastPoint, this, [(lastPoint[0] - x) / width, (lastPoint[1] - y) / height]);
}
function highlight_updateColor(color) {
  const setColorAndOpacity = (col, opa) => {
    this.color = col;
    editor_highlight_classPrivateFieldSet(_opacity, this, opa);
    this.parent?.drawLayer.updateProperties(editor_highlight_classPrivateFieldGet(highlight_id, this), {
      root: {
        fill: col,
        "fill-opacity": opa
      }
    });
    editor_highlight_classPrivateFieldGet(highlight_colorPicker, this)?.updateColor(col);
  };
  const savedColor = this.color;
  const savedOpacity = editor_highlight_classPrivateFieldGet(_opacity, this);
  this.addCommands({
    cmd: setColorAndOpacity.bind(this, color, _HighlightEditor._defaultOpacity),
    undo: setColorAndOpacity.bind(this, savedColor, savedOpacity),
    post: this._uiManager.updateUI.bind(this._uiManager, this),
    mustExec: true,
    type: AnnotationEditorParamsType.HIGHLIGHT_COLOR,
    overwriteIfSameType: true,
    keepUndo: true
  });
  this._reportTelemetry({
    action: "color_changed",
    color: this._uiManager.highlightColorNames.get(color)
  }, true);
  this.eventBus?.dispatch("annotation-editor-event", {
    source: this,
    type: "colorChanged",
    page: this.pageIndex + 1,
    editorType: this.constructor.name,
    value: color,
    previousValue: savedColor
  });
}
function _updateThickness(thickness) {
  const savedThickness = editor_highlight_classPrivateFieldGet(highlight_thickness, this);
  const setThickness = th => {
    editor_highlight_classPrivateFieldSet(highlight_thickness, this, th);
    editor_highlight_assertClassBrand(_HighlightEditor_brand, this, _changeThickness).call(this, th);
  };
  this.addCommands({
    cmd: setThickness.bind(this, thickness),
    undo: setThickness.bind(this, savedThickness),
    post: this._uiManager.updateUI.bind(this._uiManager, this),
    mustExec: true,
    type: AnnotationEditorParamsType.INK_THICKNESS,
    overwriteIfSameType: true,
    keepUndo: true
  });
  this._reportTelemetry({
    action: "thickness_changed",
    thickness
  }, true);
  this.eventBus?.dispatch("annotation-editor-event", {
    source: this,
    type: "thicknessChanged",
    page: this.pageIndex + 1,
    editorType: this.constructor.name,
    value: thickness,
    previousValue: savedThickness
  });
}
function _changeThickness(thickness) {
  if (!editor_highlight_classPrivateFieldGet(_isFreeHighlight, this)) {
    return;
  }
  editor_highlight_assertClassBrand(_HighlightEditor_brand, this, _createFreeOutlines).call(this, {
    highlightOutlines: editor_highlight_classPrivateFieldGet(_highlightOutlines, this).getNewOutline(thickness / 2)
  });
  this.fixAndSetPosition();
  const [parentWidth, parentHeight] = this.parentDimensions;
  this.setDims(this.width * parentWidth, this.height * parentHeight);
}
function _cleanDrawLayer() {
  if (editor_highlight_classPrivateFieldGet(highlight_id, this) === null || !this.parent) {
    return;
  }
  this.parent.drawLayer.remove(editor_highlight_classPrivateFieldGet(highlight_id, this));
  editor_highlight_classPrivateFieldSet(highlight_id, this, null);
  this.parent.drawLayer.remove(editor_highlight_classPrivateFieldGet(_outlineId, this));
  editor_highlight_classPrivateFieldSet(_outlineId, this, null);
}
function _addToDrawLayer() {
  let parent = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : this.parent;
  if (editor_highlight_classPrivateFieldGet(highlight_id, this) !== null) {
    return;
  }
  ({
    id: highlight_toSetter(editor_highlight_classPrivateFieldSet, [highlight_id, this])._,
    clipPathId: highlight_toSetter(editor_highlight_classPrivateFieldSet, [_clipPathId, this])._
  } = parent.drawLayer.draw({
    bbox: editor_highlight_classPrivateFieldGet(_highlightOutlines, this).box,
    root: {
      viewBox: "0 0 1 1",
      fill: this.color,
      "fill-opacity": editor_highlight_classPrivateFieldGet(_opacity, this)
    },
    rootClass: {
      highlight: true,
      free: editor_highlight_classPrivateFieldGet(_isFreeHighlight, this)
    },
    path: {
      d: editor_highlight_classPrivateFieldGet(_highlightOutlines, this).toSVGPath()
    }
  }, false, true));
  editor_highlight_classPrivateFieldSet(_outlineId, this, parent.drawLayer.drawOutline({
    rootClass: {
      highlightOutline: true,
      free: editor_highlight_classPrivateFieldGet(_isFreeHighlight, this)
    },
    bbox: editor_highlight_classPrivateFieldGet(_focusOutlines, this).box,
    path: {
      d: editor_highlight_classPrivateFieldGet(_focusOutlines, this).toSVGPath()
    }
  }, editor_highlight_classPrivateFieldGet(_isFreeHighlight, this)));
  if (editor_highlight_classPrivateFieldGet(_highlightDiv, this)) {
    editor_highlight_classPrivateFieldGet(_highlightDiv, this).style.clipPath = editor_highlight_classPrivateFieldGet(_clipPathId, this);
  }
}
function _rotateBbox(_ref3, angle) {
  let [x, y, width, height] = _ref3;
  switch (angle) {
    case 90:
      return [1 - y - height, x, height, width];
    case 180:
      return [1 - x - width, 1 - y - height, width, height];
    case 270:
      return [y, 1 - x - width, height, width];
  }
  return [x, y, width, height];
}
function _keydown(event) {
  _HighlightEditor._keyboardManager.exec(this, event);
}
function _setCaret(start) {
  if (!editor_highlight_classPrivateFieldGet(_anchorNode, this)) {
    return;
  }
  const selection = window.getSelection();
  if (start) {
    selection.setPosition(editor_highlight_classPrivateFieldGet(_anchorNode, this), editor_highlight_classPrivateFieldGet(_anchorOffset, this));
  } else {
    selection.setPosition(editor_highlight_classPrivateFieldGet(_focusNode, this), editor_highlight_classPrivateFieldGet(_focusOffset, this));
  }
}
function _getRotation() {
  return editor_highlight_classPrivateFieldGet(_isFreeHighlight, this) ? this.rotation : 0;
}
function _serializeBoxes() {
  if (editor_highlight_classPrivateFieldGet(_isFreeHighlight, this)) {
    return null;
  }
  const [pageWidth, pageHeight] = this.pageDimensions;
  const [pageX, pageY] = this.pageTranslation;
  const boxes = editor_highlight_classPrivateFieldGet(_boxes, this);
  const quadPoints = new Float32Array(boxes.length * 8);
  let i = 0;
  for (const {
    x,
    y,
    width,
    height
  } of boxes) {
    const sx = x * pageWidth + pageX;
    const sy = (1 - y) * pageHeight + pageY;
    quadPoints[i] = quadPoints[i + 4] = sx;
    quadPoints[i + 1] = quadPoints[i + 3] = sy;
    quadPoints[i + 2] = quadPoints[i + 6] = sx + width * pageWidth;
    quadPoints[i + 5] = quadPoints[i + 7] = sy - height * pageHeight;
    i += 8;
  }
  return quadPoints;
}
function _serializeOutlines(rect) {
  return editor_highlight_classPrivateFieldGet(_highlightOutlines, this).serialize(rect, editor_highlight_assertClassBrand(_HighlightEditor_brand, this, _getRotation).call(this));
}
function _highlightMove(parent, event) {
  if (this._freeHighlight.add(event)) {
    parent.drawLayer.updateProperties(this._freeHighlightId, {
      path: {
        d: this._freeHighlight.toSVGPath()
      }
    });
  }
}
function _endHighlight(parent, event) {
  if (!this._freeHighlight.isEmpty()) {
    parent.createAndAddNewEditor(event, false, {
      highlightId: this._freeHighlightId,
      highlightOutlines: this._freeHighlight.getOutlines(),
      clipPathId: this._freeHighlightClipId,
      methodOfCreation: "main_toolbar"
    });
  } else {
    parent.drawLayer.remove(this._freeHighlightId);
  }
  this._freeHighlightId = -1;
  this._freeHighlight = null;
  this._freeHighlightClipId = "";
}
function highlight_hasElementChanged(serialized) {
  const {
    color
  } = this._initialData;
  return serialized.color.some((c, i) => c !== color[i]);
}
highlight_defineProperty(HighlightEditor, "_defaultColor", null);
highlight_defineProperty(HighlightEditor, "_defaultOpacity", 1);
highlight_defineProperty(HighlightEditor, "_defaultThickness", 12);
highlight_defineProperty(HighlightEditor, "_type", "highlight");
highlight_defineProperty(HighlightEditor, "_editorType", AnnotationEditorType.HIGHLIGHT);
highlight_defineProperty(HighlightEditor, "_freeHighlightId", -1);
highlight_defineProperty(HighlightEditor, "_freeHighlight", null);
highlight_defineProperty(HighlightEditor, "_freeHighlightClipId", "");

;// ./src/display/editor/draw.js
var _DrawingEditor;









function draw_classPrivateMethodInitSpec(e, a) { draw_checkPrivateRedeclaration(e, a), a.add(e); }
function draw_defineProperty(e, r, t) { return (r = draw_toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function draw_toPropertyKey(t) { var i = draw_toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function draw_toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function draw_classPrivateFieldInitSpec(e, t, a) { draw_checkPrivateRedeclaration(e, t), t.set(e, a); }
function draw_checkPrivateRedeclaration(e, t) { if (t.has(e)) throw new TypeError("Cannot initialize the same private elements twice on an object"); }
function draw_classPrivateFieldSet(s, a, r) { return s.set(draw_assertClassBrand(s, a), r), r; }
function draw_classPrivateFieldGet(s, a) { return s.get(draw_assertClassBrand(s, a)); }
function draw_assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); }



var _svgProperties = /*#__PURE__*/new WeakMap();
class DrawingOptions {
  constructor() {
    draw_classPrivateFieldInitSpec(this, _svgProperties, Object.create(null));
  }
  updateProperty(name, value) {
    this[name] = value;
    this.updateSVGProperty(name, value);
  }
  updateProperties(properties) {
    if (!properties) {
      return;
    }
    for (const [name, value] of Object.entries(properties)) {
      if (!name.startsWith("_")) {
        this.updateProperty(name, value);
      }
    }
  }
  updateSVGProperty(name, value) {
    draw_classPrivateFieldGet(_svgProperties, this)[name] = value;
  }
  toSVGProperties() {
    const root = draw_classPrivateFieldGet(_svgProperties, this);
    draw_classPrivateFieldSet(_svgProperties, this, Object.create(null));
    return {
      root
    };
  }
  reset() {
    draw_classPrivateFieldSet(_svgProperties, this, Object.create(null));
  }
  updateAll() {
    let options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : this;
    this.updateProperties(options);
  }
  clone() {
    unreachable("Not implemented");
  }
}
var _drawOutlines = /*#__PURE__*/new WeakMap();
var _mustBeCommitted = /*#__PURE__*/new WeakMap();
var _DrawingEditor_brand = /*#__PURE__*/new WeakSet();
class DrawingEditor extends AnnotationEditor {
  constructor(params) {
    super(params);
    draw_classPrivateMethodInitSpec(this, _DrawingEditor_brand);
    draw_classPrivateFieldInitSpec(this, _drawOutlines, null);
    draw_classPrivateFieldInitSpec(this, _mustBeCommitted, void 0);
    draw_defineProperty(this, "_drawId", null);
    draw_classPrivateFieldSet(_mustBeCommitted, this, params.mustBeCommitted || false);
    this._addOutlines(params);
  }
  _addOutlines(params) {
    if (params.drawOutlines) {
      draw_assertClassBrand(_DrawingEditor_brand, this, _createDrawOutlines).call(this, params);
      draw_assertClassBrand(_DrawingEditor_brand, this, draw_addToDrawLayer).call(this);
    }
  }
  static _mergeSVGProperties(p1, p2) {
    const p1Keys = new Set(Object.keys(p1));
    for (const [key, value] of Object.entries(p2)) {
      if (p1Keys.has(key)) {
        Object.assign(p1[key], value);
      } else {
        p1[key] = value;
      }
    }
    return p1;
  }
  static getDefaultDrawingOptions(_options) {
    unreachable("Not implemented");
  }
  static get typesMap() {
    unreachable("Not implemented");
  }
  static get isDrawer() {
    return true;
  }
  static get supportMultipleDrawings() {
    return false;
  }
  static updateDefaultParams(type, value) {
    const propertyName = this.typesMap.get(type);
    if (propertyName) {
      this._defaultDrawingOptions.updateProperty(propertyName, value);
    }
    if (this._currentParent) {
      _currentDraw._.updateProperty(propertyName, value);
      this._currentParent.drawLayer.updateProperties(this._currentDrawId, this._defaultDrawingOptions.toSVGProperties());
    }
  }
  updateParams(type, value) {
    const propertyName = this.constructor.typesMap.get(type);
    if (propertyName) {
      this._updateProperty(type, propertyName, value);
    }
  }
  static get defaultPropertiesToUpdate() {
    const properties = [];
    const options = this._defaultDrawingOptions;
    for (const [type, name] of this.typesMap) {
      properties.push([type, options[name]]);
    }
    return properties;
  }
  get propertiesToUpdate() {
    const properties = [];
    const {
      _drawingOptions
    } = this;
    for (const [type, name] of this.constructor.typesMap) {
      properties.push([type, _drawingOptions[name]]);
    }
    return properties;
  }
  _updateProperty(type, name, value) {
    const options = this._drawingOptions;
    const savedValue = options[name];
    const setter = val => {
      options.updateProperty(name, val);
      const bbox = draw_classPrivateFieldGet(_drawOutlines, this).updateProperty(name, val);
      if (bbox) {
        draw_assertClassBrand(_DrawingEditor_brand, this, _updateBbox).call(this, bbox);
      }
      this.parent?.drawLayer.updateProperties(this._drawId, options.toSVGProperties());
      if (name === "stroke") {
        this.eventBus?.dispatch("annotation-editor-event", {
          source: this,
          type: "colorChanged",
          page: this.pageIndex + 1,
          editorType: this.constructor.name,
          value
        });
      } else if (name === "stroke-width") {
        this.eventBus?.dispatch("annotation-editor-event", {
          source: this,
          type: "thicknessChanged",
          page: this.pageIndex + 1,
          editorType: this.constructor.name,
          value
        });
      } else if (name === "stroke-opacity") {
        this.eventBus?.dispatch("annotation-editor-event", {
          source: this,
          type: "opacityChanged",
          page: this.pageIndex + 1,
          editorType: this.constructor.name,
          value
        });
      }
    };
    this.addCommands({
      cmd: setter.bind(this, value),
      undo: setter.bind(this, savedValue),
      post: this._uiManager.updateUI.bind(this._uiManager, this),
      mustExec: true,
      type,
      overwriteIfSameType: true,
      keepUndo: true
    });
  }
  _onResizing() {
    this.parent?.drawLayer.updateProperties(this._drawId, DrawingEditor._mergeSVGProperties(draw_classPrivateFieldGet(_drawOutlines, this).getPathResizingSVGProperties(draw_assertClassBrand(_DrawingEditor_brand, this, _convertToDrawSpace).call(this)), {
      bbox: draw_assertClassBrand(_DrawingEditor_brand, this, _rotateBox).call(this)
    }));
  }
  _onResized() {
    this.parent?.drawLayer.updateProperties(this._drawId, DrawingEditor._mergeSVGProperties(draw_classPrivateFieldGet(_drawOutlines, this).getPathResizedSVGProperties(draw_assertClassBrand(_DrawingEditor_brand, this, _convertToDrawSpace).call(this)), {
      bbox: draw_assertClassBrand(_DrawingEditor_brand, this, _rotateBox).call(this)
    }));
  }
  _onTranslating(_x, _y) {
    this.parent?.drawLayer.updateProperties(this._drawId, {
      bbox: draw_assertClassBrand(_DrawingEditor_brand, this, _rotateBox).call(this)
    });
  }
  _onTranslated() {
    this.parent?.drawLayer.updateProperties(this._drawId, DrawingEditor._mergeSVGProperties(draw_classPrivateFieldGet(_drawOutlines, this).getPathTranslatedSVGProperties(draw_assertClassBrand(_DrawingEditor_brand, this, _convertToDrawSpace).call(this), this.parentDimensions), {
      bbox: draw_assertClassBrand(_DrawingEditor_brand, this, _rotateBox).call(this)
    }));
  }
  _onStartDragging() {
    this.parent?.drawLayer.updateProperties(this._drawId, {
      rootClass: {
        moving: true
      }
    });
  }
  _onStopDragging() {
    this.parent?.drawLayer.updateProperties(this._drawId, {
      rootClass: {
        moving: false
      }
    });
  }
  commit() {
    super.commit();
    this.disableEditMode();
    this.disableEditing();
  }
  disableEditing() {
    super.disableEditing();
    this.div.classList.toggle("disabled", true);
  }
  enableEditing() {
    super.enableEditing();
    this.div.classList.toggle("disabled", false);
  }
  getBaseTranslation() {
    return [0, 0];
  }
  get isResizable() {
    return true;
  }
  onceAdded(focus) {
    if (!this.annotationElementId) {
      this.parent.addUndoableEditor(this);
    }
    this._isDraggable = true;
    if (draw_classPrivateFieldGet(_mustBeCommitted, this)) {
      draw_classPrivateFieldSet(_mustBeCommitted, this, false);
      this.commit();
      this.parent.setSelected(this);
      if (focus && this.isOnScreen) {
        this.div.focus();
      }
    }
  }
  remove() {
    draw_assertClassBrand(_DrawingEditor_brand, this, draw_cleanDrawLayer).call(this);
    super.remove();
  }
  rebuild() {
    if (!this.parent) {
      return;
    }
    super.rebuild();
    if (this.div === null) {
      return;
    }
    draw_assertClassBrand(_DrawingEditor_brand, this, draw_addToDrawLayer).call(this);
    draw_assertClassBrand(_DrawingEditor_brand, this, _updateBbox).call(this, draw_classPrivateFieldGet(_drawOutlines, this).box);
    if (!this.isAttachedToDOM) {
      this.parent.add(this);
    }
  }
  setParent(parent) {
    let mustBeSelected = false;
    if (this.parent && !parent) {
      this._uiManager.removeShouldRescale(this);
      draw_assertClassBrand(_DrawingEditor_brand, this, draw_cleanDrawLayer).call(this);
    } else if (parent) {
      this._uiManager.addShouldRescale(this);
      draw_assertClassBrand(_DrawingEditor_brand, this, draw_addToDrawLayer).call(this, parent);
      mustBeSelected = !this.parent && this.div?.classList.contains("selectedEditor");
    }
    super.setParent(parent);
    if (mustBeSelected) {
      this.select();
    }
  }
  rotate() {
    if (!this.parent) {
      return;
    }
    this.parent.drawLayer.updateProperties(this._drawId, DrawingEditor._mergeSVGProperties({
      bbox: draw_assertClassBrand(_DrawingEditor_brand, this, _rotateBox).call(this)
    }, draw_classPrivateFieldGet(_drawOutlines, this).updateRotation((this.parentRotation - this.rotation + 360) % 360)));
  }
  onScaleChanging() {
    if (!this.parent) {
      return;
    }
    draw_assertClassBrand(_DrawingEditor_brand, this, _updateBbox).call(this, draw_classPrivateFieldGet(_drawOutlines, this).updateParentDimensions(this.parentDimensions, this.parent.scale));
  }
  static onScaleChangingWhenDrawing() {}
  render() {
    if (this.div) {
      return this.div;
    }
    let baseX, baseY;
    if (this._isCopy) {
      baseX = this.x;
      baseY = this.y;
    }
    const div = super.render();
    div.classList.add("draw");
    const drawDiv = document.createElement("div");
    div.append(drawDiv);
    drawDiv.setAttribute("aria-hidden", "true");
    drawDiv.className = "internal";
    const [parentWidth, parentHeight] = this.parentDimensions;
    this.setDims(this.width * parentWidth, this.height * parentHeight);
    this._uiManager.addShouldRescale(this);
    this.disableEditing();
    if (this._isCopy) {
      this._moveAfterPaste(baseX, baseY);
    }
    return div;
  }
  static createDrawerInstance(_x, _y, _parentWidth, _parentHeight, _rotation) {
    unreachable("Not implemented");
  }
  static startDrawing(parent, uiManager, _isLTR, event) {
    const {
      target,
      offsetX: x,
      offsetY: y,
      pointerId,
      pointerType
    } = event;
    if (_currentPointerType._ && _currentPointerType._ !== pointerType) {
      return;
    }
    const {
      viewport: {
        rotation
      }
    } = parent;
    const {
      width: parentWidth,
      height: parentHeight
    } = target.getBoundingClientRect();
    const ac = _currentDrawingAC._ = new AbortController();
    const signal = parent.combinedSignal(ac);
    _currentPointerId._ || (_currentPointerId._ = pointerId);
    _currentPointerType._ ?? (_currentPointerType._ = pointerType);
    window.addEventListener("pointerup", e => {
      if (_currentPointerId._ === e.pointerId) {
        this._endDraw(e);
      } else {
        _currentPointerIds._?.delete(e.pointerId);
      }
    }, {
      signal
    });
    window.addEventListener("pointercancel", e => {
      if (_currentPointerId._ === e.pointerId) {
        this._currentParent.endDrawingSession();
      } else {
        _currentPointerIds._?.delete(e.pointerId);
      }
    }, {
      signal
    });
    window.addEventListener("pointerdown", e => {
      if (_currentPointerType._ !== e.pointerType) {
        return;
      }
      (_currentPointerIds._ || (_currentPointerIds._ = new Set())).add(e.pointerId);
      if (_currentDraw._.isCancellable()) {
        _currentDraw._.removeLastElement();
        if (_currentDraw._.isEmpty()) {
          this._currentParent.endDrawingSession(true);
        } else {
          this._endDraw(null);
        }
      }
    }, {
      capture: true,
      passive: false,
      signal
    });
    window.addEventListener("contextmenu", noContextMenu, {
      signal
    });
    target.addEventListener("pointermove", this._drawMove.bind(this), {
      signal
    });
    target.addEventListener("touchmove", e => {
      if (e.timeStamp === _currentMoveTimestamp._) {
        stopEvent(e);
      }
    }, {
      signal
    });
    parent.toggleDrawing();
    uiManager._editorUndoBar?.hide();
    if (_currentDraw._) {
      parent.drawLayer.updateProperties(this._currentDrawId, _currentDraw._.startNew(x, y, parentWidth, parentHeight, rotation));
      return;
    }
    uiManager.updateUIForDefaultProperties(this);
    _currentDraw._ = this.createDrawerInstance(x, y, parentWidth, parentHeight, rotation);
    _currentDrawingOptions._ = this.getDefaultDrawingOptions();
    this._currentParent = parent;
    ({
      id: this._currentDrawId
    } = parent.drawLayer.draw(this._mergeSVGProperties(_currentDrawingOptions._.toSVGProperties(), _currentDraw._.defaultSVGProperties), true, false));
  }
  static _drawMove(event) {
    _currentMoveTimestamp._ = -1;
    if (!_currentDraw._) {
      return;
    }
    const {
      offsetX,
      offsetY,
      pointerId
    } = event;
    if (_currentPointerId._ !== pointerId) {
      return;
    }
    if (_currentPointerIds._?.size >= 1) {
      this._endDraw(event);
      return;
    }
    this._currentParent.drawLayer.updateProperties(this._currentDrawId, _currentDraw._.add(offsetX, offsetY));
    _currentMoveTimestamp._ = event.timeStamp;
    stopEvent(event);
  }
  static _cleanup(all) {
    if (all) {
      this._currentDrawId = -1;
      this._currentParent = null;
      _currentDraw._ = null;
      _currentDrawingOptions._ = null;
      _currentPointerType._ = null;
      _currentMoveTimestamp._ = NaN;
    }
    if (_currentDrawingAC._) {
      _currentDrawingAC._.abort();
      _currentDrawingAC._ = null;
      _currentPointerId._ = NaN;
      _currentPointerIds._ = null;
    }
  }
  static _endDraw(event) {
    const parent = this._currentParent;
    if (!parent) {
      return;
    }
    parent.toggleDrawing(true);
    this._cleanup(false);
    if (event?.target === parent.div) {
      parent.drawLayer.updateProperties(this._currentDrawId, _currentDraw._.end(event.offsetX, event.offsetY));
    }
    this.eventBus?.dispatch("annotation-editor-event", {
      source: this,
      type: "bezierPathChanged",
      page: this._currentParent ? this._currentParent.pageIndex + 1 : NaN,
      editorType: this.name
    });
    if (this.supportMultipleDrawings) {
      const draw = _currentDraw._;
      const drawId = this._currentDrawId;
      const lastElement = draw.getLastElement();
      parent.addCommands({
        cmd: () => {
          parent.drawLayer.updateProperties(drawId, draw.setLastElement(lastElement));
        },
        undo: () => {
          parent.drawLayer.updateProperties(drawId, draw.removeLastElement());
        },
        mustExec: false,
        type: AnnotationEditorParamsType.DRAW_STEP
      });
      return;
    }
    this.endDrawing(false);
  }
  static endDrawing(isAborted) {
    const parent = this._currentParent;
    if (!parent) {
      return null;
    }
    parent.toggleDrawing(true);
    parent.cleanUndoStack(AnnotationEditorParamsType.DRAW_STEP);
    if (!_currentDraw._.isEmpty()) {
      const {
        pageDimensions: [pageWidth, pageHeight],
        scale
      } = parent;
      const editor = parent.createAndAddNewEditor({
        offsetX: 0,
        offsetY: 0
      }, false, {
        drawId: this._currentDrawId,
        drawOutlines: _currentDraw._.getOutlines(pageWidth * scale, pageHeight * scale, scale, this._INNER_MARGIN),
        drawingOptions: _currentDrawingOptions._,
        mustBeCommitted: !isAborted
      });
      this._cleanup(true);
      return editor;
    }
    parent.drawLayer.remove(this._currentDrawId);
    this._cleanup(true);
    return null;
  }
  createDrawingOptions(_data) {}
  static deserializeDraw(_pageX, _pageY, _pageWidth, _pageHeight, _innerWidth, _data) {
    unreachable("Not implemented");
  }
  static async deserialize(data, parent, uiManager) {
    const {
      rawDims: {
        pageWidth,
        pageHeight,
        pageX,
        pageY
      }
    } = parent.viewport;
    const drawOutlines = this.deserializeDraw(pageX, pageY, pageWidth, pageHeight, this._INNER_MARGIN, data);
    const editor = await super.deserialize(data, parent, uiManager);
    editor.createDrawingOptions(data);
    draw_assertClassBrand(_DrawingEditor_brand, editor, _createDrawOutlines).call(editor, {
      drawOutlines
    });
    draw_assertClassBrand(_DrawingEditor_brand, editor, draw_addToDrawLayer).call(editor);
    editor.onScaleChanging();
    editor.rotate();
    return editor;
  }
  serializeDraw(isForCopying) {
    const [pageX, pageY] = this.pageTranslation;
    const [pageWidth, pageHeight] = this.pageDimensions;
    return draw_classPrivateFieldGet(_drawOutlines, this).serialize([pageX, pageY, pageWidth, pageHeight], isForCopying);
  }
  renderAnnotationElement(annotation) {
    annotation.updateEdited({
      rect: this.getRect(0, 0)
    });
    return null;
  }
  static canCreateNewEmptyEditor() {
    return false;
  }
}
_DrawingEditor = DrawingEditor;
function _createDrawOutlines(_ref) {
  let {
    drawOutlines,
    drawId,
    drawingOptions
  } = _ref;
  draw_classPrivateFieldSet(_drawOutlines, this, drawOutlines);
  this._drawingOptions ||= drawingOptions;
  if (drawId >= 0) {
    this._drawId = drawId;
    this.parent.drawLayer.finalizeDraw(drawId, drawOutlines.defaultProperties);
  } else {
    this._drawId = draw_assertClassBrand(_DrawingEditor_brand, this, _createDrawing).call(this, drawOutlines, this.parent);
  }
  draw_assertClassBrand(_DrawingEditor_brand, this, _updateBbox).call(this, drawOutlines.box);
}
function _createDrawing(drawOutlines, parent) {
  const {
    id
  } = parent.drawLayer.draw(_DrawingEditor._mergeSVGProperties(this._drawingOptions.toSVGProperties(), drawOutlines.defaultSVGProperties), false, false);
  return id;
}
function draw_cleanDrawLayer() {
  if (this._drawId === null || !this.parent) {
    return;
  }
  this.parent.drawLayer.remove(this._drawId);
  this._drawId = null;
  this._drawingOptions.reset();
}
function draw_addToDrawLayer() {
  let parent = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : this.parent;
  if (this._drawId !== null && this.parent === parent) {
    return;
  }
  if (this._drawId !== null) {
    this.parent.drawLayer.updateParent(this._drawId, parent.drawLayer);
    return;
  }
  this._drawingOptions.updateAll();
  this._drawId = draw_assertClassBrand(_DrawingEditor_brand, this, _createDrawing).call(this, draw_classPrivateFieldGet(_drawOutlines, this), parent);
}
function _convertToParentSpace(_ref2) {
  let [x, y, width, height] = _ref2;
  const {
    parentDimensions: [pW, pH],
    rotation
  } = this;
  switch (rotation) {
    case 90:
      return [y, 1 - x, width * (pH / pW), height * (pW / pH)];
    case 180:
      return [1 - x, 1 - y, width, height];
    case 270:
      return [1 - y, x, width * (pH / pW), height * (pW / pH)];
    default:
      return [x, y, width, height];
  }
}
function _convertToDrawSpace() {
  const {
    x,
    y,
    width,
    height,
    parentDimensions: [pW, pH],
    rotation
  } = this;
  switch (rotation) {
    case 90:
      return [1 - y, x, width * (pW / pH), height * (pH / pW)];
    case 180:
      return [1 - x, 1 - y, width, height];
    case 270:
      return [y, 1 - x, width * (pW / pH), height * (pH / pW)];
    default:
      return [x, y, width, height];
  }
}
function _updateBbox(bbox) {
  [this.x, this.y, this.width, this.height] = draw_assertClassBrand(_DrawingEditor_brand, this, _convertToParentSpace).call(this, bbox);
  if (this.div) {
    this.fixAndSetPosition();
    const [parentWidth, parentHeight] = this.parentDimensions;
    this.setDims(this.width * parentWidth, this.height * parentHeight);
  }
  this._onResized();
}
function _rotateBox() {
  const {
    x,
    y,
    width,
    height,
    rotation,
    parentRotation,
    parentDimensions: [pW, pH]
  } = this;
  switch ((rotation * 4 + parentRotation) / 90) {
    case 1:
      return [1 - y - height, x, height, width];
    case 2:
      return [1 - x - width, 1 - y - height, width, height];
    case 3:
      return [y, 1 - x - width, height, width];
    case 4:
      return [x, y - width * (pW / pH), height * (pH / pW), width * (pW / pH)];
    case 5:
      return [1 - y, x, width * (pW / pH), height * (pH / pW)];
    case 6:
      return [1 - x - height * (pH / pW), 1 - y, height * (pH / pW), width * (pW / pH)];
    case 7:
      return [y - width * (pW / pH), 1 - x - height * (pH / pW), width * (pW / pH), height * (pH / pW)];
    case 8:
      return [x - width, y - height, width, height];
    case 9:
      return [1 - y, x - width, height, width];
    case 10:
      return [1 - x, 1 - y, width, height];
    case 11:
      return [y - height, 1 - x, height, width];
    case 12:
      return [x - height * (pH / pW), y, height * (pH / pW), width * (pW / pH)];
    case 13:
      return [1 - y - width * (pW / pH), x - height * (pH / pW), width * (pW / pH), height * (pH / pW)];
    case 14:
      return [1 - x, 1 - y - width * (pW / pH), height * (pH / pW), width * (pW / pH)];
    case 15:
      return [y, 1 - x, width * (pW / pH), height * (pH / pW)];
    default:
      return [x, y, width, height];
  }
}
draw_defineProperty(DrawingEditor, "_currentDrawId", -1);
draw_defineProperty(DrawingEditor, "_currentParent", null);
var _currentDraw = {
  _: null
};
var _currentDrawingAC = {
  _: null
};
var _currentDrawingOptions = {
  _: null
};
var _currentPointerId = {
  _: NaN
};
var _currentPointerType = {
  _: null
};
var _currentPointerIds = {
  _: null
};
var _currentMoveTimestamp = {
  _: NaN
};
draw_defineProperty(DrawingEditor, "_INNER_MARGIN", 3);

;// ./src/display/editor/drawers/inkdraw.js


















function inkdraw_classPrivateMethodInitSpec(e, a) { inkdraw_checkPrivateRedeclaration(e, a), a.add(e); }
function inkdraw_classPrivateFieldInitSpec(e, t, a) { inkdraw_checkPrivateRedeclaration(e, t), t.set(e, a); }
function inkdraw_checkPrivateRedeclaration(e, t) { if (t.has(e)) throw new TypeError("Cannot initialize the same private elements twice on an object"); }
function inkdraw_classPrivateFieldGet(s, a) { return s.get(inkdraw_assertClassBrand(s, a)); }
function inkdraw_classPrivateFieldSet(s, a, r) { return s.set(inkdraw_assertClassBrand(s, a), r), r; }
function inkdraw_assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); }


var inkdraw_last = /*#__PURE__*/new WeakMap();
var inkdraw_line = /*#__PURE__*/new WeakMap();
var _lines = /*#__PURE__*/new WeakMap();
var inkdraw_rotation = /*#__PURE__*/new WeakMap();
var inkdraw_thickness = /*#__PURE__*/new WeakMap();
var inkdraw_points = /*#__PURE__*/new WeakMap();
var _lastSVGPath = /*#__PURE__*/new WeakMap();
var _lastIndex = /*#__PURE__*/new WeakMap();
var inkdraw_outlines = /*#__PURE__*/new WeakMap();
var _parentWidth = /*#__PURE__*/new WeakMap();
var _parentHeight = /*#__PURE__*/new WeakMap();
var _InkDrawOutliner_brand = /*#__PURE__*/new WeakSet();
class InkDrawOutliner {
  constructor(_x, _y, parentWidth, parentHeight, rotation, thickness) {
    inkdraw_classPrivateMethodInitSpec(this, _InkDrawOutliner_brand);
    inkdraw_classPrivateFieldInitSpec(this, inkdraw_last, new Float64Array(6));
    inkdraw_classPrivateFieldInitSpec(this, inkdraw_line, void 0);
    inkdraw_classPrivateFieldInitSpec(this, _lines, void 0);
    inkdraw_classPrivateFieldInitSpec(this, inkdraw_rotation, void 0);
    inkdraw_classPrivateFieldInitSpec(this, inkdraw_thickness, void 0);
    inkdraw_classPrivateFieldInitSpec(this, inkdraw_points, void 0);
    inkdraw_classPrivateFieldInitSpec(this, _lastSVGPath, "");
    inkdraw_classPrivateFieldInitSpec(this, _lastIndex, 0);
    inkdraw_classPrivateFieldInitSpec(this, inkdraw_outlines, new InkDrawOutline());
    inkdraw_classPrivateFieldInitSpec(this, _parentWidth, void 0);
    inkdraw_classPrivateFieldInitSpec(this, _parentHeight, void 0);
    inkdraw_classPrivateFieldSet(_parentWidth, this, parentWidth);
    inkdraw_classPrivateFieldSet(_parentHeight, this, parentHeight);
    inkdraw_classPrivateFieldSet(inkdraw_rotation, this, rotation);
    inkdraw_classPrivateFieldSet(inkdraw_thickness, this, thickness);
    [_x, _y] = inkdraw_assertClassBrand(_InkDrawOutliner_brand, this, _normalizePoint).call(this, _x, _y);
    const line = inkdraw_classPrivateFieldSet(inkdraw_line, this, [NaN, NaN, NaN, NaN, _x, _y]);
    inkdraw_classPrivateFieldSet(inkdraw_points, this, [_x, _y]);
    inkdraw_classPrivateFieldSet(_lines, this, [{
      line,
      points: inkdraw_classPrivateFieldGet(inkdraw_points, this)
    }]);
    inkdraw_classPrivateFieldGet(inkdraw_last, this).set(line, 0);
  }
  updateProperty(name, value) {
    if (name === "stroke-width") {
      inkdraw_classPrivateFieldSet(inkdraw_thickness, this, value);
    }
  }
  isEmpty() {
    return !inkdraw_classPrivateFieldGet(_lines, this) || inkdraw_classPrivateFieldGet(_lines, this).length === 0;
  }
  isCancellable() {
    return inkdraw_classPrivateFieldGet(inkdraw_points, this).length <= 10;
  }
  add(x, y) {
    [x, y] = inkdraw_assertClassBrand(_InkDrawOutliner_brand, this, _normalizePoint).call(this, x, y);
    const [x1, y1, x2, y2] = inkdraw_classPrivateFieldGet(inkdraw_last, this).subarray(2, 6);
    const diffX = x - x2;
    const diffY = y - y2;
    const d = Math.hypot(inkdraw_classPrivateFieldGet(_parentWidth, this) * diffX, inkdraw_classPrivateFieldGet(_parentHeight, this) * diffY);
    if (d <= 2) {
      return null;
    }
    inkdraw_classPrivateFieldGet(inkdraw_points, this).push(x, y);
    if (isNaN(x1)) {
      inkdraw_classPrivateFieldGet(inkdraw_last, this).set([x2, y2, x, y], 2);
      inkdraw_classPrivateFieldGet(inkdraw_line, this).push(NaN, NaN, NaN, NaN, x, y);
      return {
        path: {
          d: this.toSVGPath()
        }
      };
    }
    if (isNaN(inkdraw_classPrivateFieldGet(inkdraw_last, this)[0])) {
      inkdraw_classPrivateFieldGet(inkdraw_line, this).splice(6, 6);
    }
    inkdraw_classPrivateFieldGet(inkdraw_last, this).set([x1, y1, x2, y2, x, y], 0);
    inkdraw_classPrivateFieldGet(inkdraw_line, this).push(...Outline.createBezierPoints(x1, y1, x2, y2, x, y));
    return {
      path: {
        d: this.toSVGPath()
      }
    };
  }
  end(x, y) {
    const change = this.add(x, y);
    if (change) {
      return change;
    }
    if (inkdraw_classPrivateFieldGet(inkdraw_points, this).length === 2) {
      return {
        path: {
          d: this.toSVGPath()
        }
      };
    }
    return null;
  }
  startNew(x, y, parentWidth, parentHeight, rotation) {
    inkdraw_classPrivateFieldSet(_parentWidth, this, parentWidth);
    inkdraw_classPrivateFieldSet(_parentHeight, this, parentHeight);
    inkdraw_classPrivateFieldSet(inkdraw_rotation, this, rotation);
    [x, y] = inkdraw_assertClassBrand(_InkDrawOutliner_brand, this, _normalizePoint).call(this, x, y);
    const line = inkdraw_classPrivateFieldSet(inkdraw_line, this, [NaN, NaN, NaN, NaN, x, y]);
    inkdraw_classPrivateFieldSet(inkdraw_points, this, [x, y]);
    const last = inkdraw_classPrivateFieldGet(_lines, this).at(-1);
    if (last) {
      last.line = new Float32Array(last.line);
      last.points = new Float32Array(last.points);
    }
    inkdraw_classPrivateFieldGet(_lines, this).push({
      line,
      points: inkdraw_classPrivateFieldGet(inkdraw_points, this)
    });
    inkdraw_classPrivateFieldGet(inkdraw_last, this).set(line, 0);
    inkdraw_classPrivateFieldSet(_lastIndex, this, 0);
    this.toSVGPath();
    return null;
  }
  getLastElement() {
    return inkdraw_classPrivateFieldGet(_lines, this).at(-1);
  }
  setLastElement(element) {
    if (!inkdraw_classPrivateFieldGet(_lines, this)) {
      return inkdraw_classPrivateFieldGet(inkdraw_outlines, this).setLastElement(element);
    }
    inkdraw_classPrivateFieldGet(_lines, this).push(element);
    inkdraw_classPrivateFieldSet(inkdraw_line, this, element.line);
    inkdraw_classPrivateFieldSet(inkdraw_points, this, element.points);
    inkdraw_classPrivateFieldSet(_lastIndex, this, 0);
    return {
      path: {
        d: this.toSVGPath()
      }
    };
  }
  removeLastElement() {
    if (!inkdraw_classPrivateFieldGet(_lines, this)) {
      return inkdraw_classPrivateFieldGet(inkdraw_outlines, this).removeLastElement();
    }
    inkdraw_classPrivateFieldGet(_lines, this).pop();
    inkdraw_classPrivateFieldSet(_lastSVGPath, this, "");
    for (let i = 0, ii = inkdraw_classPrivateFieldGet(_lines, this).length; i < ii; i++) {
      const {
        line,
        points
      } = inkdraw_classPrivateFieldGet(_lines, this)[i];
      inkdraw_classPrivateFieldSet(inkdraw_line, this, line);
      inkdraw_classPrivateFieldSet(inkdraw_points, this, points);
      inkdraw_classPrivateFieldSet(_lastIndex, this, 0);
      this.toSVGPath();
    }
    return {
      path: {
        d: inkdraw_classPrivateFieldGet(_lastSVGPath, this)
      }
    };
  }
  toSVGPath() {
    const firstX = Outline.svgRound(inkdraw_classPrivateFieldGet(inkdraw_line, this)[4]);
    const firstY = Outline.svgRound(inkdraw_classPrivateFieldGet(inkdraw_line, this)[5]);
    if (inkdraw_classPrivateFieldGet(inkdraw_points, this).length === 2) {
      inkdraw_classPrivateFieldSet(_lastSVGPath, this, `${inkdraw_classPrivateFieldGet(_lastSVGPath, this)} M ${firstX} ${firstY} Z`);
      return inkdraw_classPrivateFieldGet(_lastSVGPath, this);
    }
    if (inkdraw_classPrivateFieldGet(inkdraw_points, this).length <= 6) {
      const i = inkdraw_classPrivateFieldGet(_lastSVGPath, this).lastIndexOf("M");
      inkdraw_classPrivateFieldSet(_lastSVGPath, this, `${inkdraw_classPrivateFieldGet(_lastSVGPath, this).slice(0, i)} M ${firstX} ${firstY}`);
      inkdraw_classPrivateFieldSet(_lastIndex, this, 6);
    }
    if (inkdraw_classPrivateFieldGet(inkdraw_points, this).length === 4) {
      const secondX = Outline.svgRound(inkdraw_classPrivateFieldGet(inkdraw_line, this)[10]);
      const secondY = Outline.svgRound(inkdraw_classPrivateFieldGet(inkdraw_line, this)[11]);
      inkdraw_classPrivateFieldSet(_lastSVGPath, this, `${inkdraw_classPrivateFieldGet(_lastSVGPath, this)} L ${secondX} ${secondY}`);
      inkdraw_classPrivateFieldSet(_lastIndex, this, 12);
      return inkdraw_classPrivateFieldGet(_lastSVGPath, this);
    }
    const buffer = [];
    if (inkdraw_classPrivateFieldGet(_lastIndex, this) === 0) {
      buffer.push(`M ${firstX} ${firstY}`);
      inkdraw_classPrivateFieldSet(_lastIndex, this, 6);
    }
    for (let i = inkdraw_classPrivateFieldGet(_lastIndex, this), ii = inkdraw_classPrivateFieldGet(inkdraw_line, this).length; i < ii; i += 6) {
      const [c1x, c1y, c2x, c2y, x, y] = inkdraw_classPrivateFieldGet(inkdraw_line, this).slice(i, i + 6).map(Outline.svgRound);
      buffer.push(`C${c1x} ${c1y} ${c2x} ${c2y} ${x} ${y}`);
    }
    inkdraw_classPrivateFieldSet(_lastSVGPath, this, inkdraw_classPrivateFieldGet(_lastSVGPath, this) + buffer.join(" "));
    inkdraw_classPrivateFieldSet(_lastIndex, this, inkdraw_classPrivateFieldGet(inkdraw_line, this).length);
    return inkdraw_classPrivateFieldGet(_lastSVGPath, this);
  }
  getOutlines(parentWidth, parentHeight, scale, innerMargin) {
    const last = inkdraw_classPrivateFieldGet(_lines, this).at(-1);
    last.line = new Float32Array(last.line);
    last.points = new Float32Array(last.points);
    inkdraw_classPrivateFieldGet(inkdraw_outlines, this).build(inkdraw_classPrivateFieldGet(_lines, this), parentWidth, parentHeight, scale, inkdraw_classPrivateFieldGet(inkdraw_rotation, this), inkdraw_classPrivateFieldGet(inkdraw_thickness, this), innerMargin);
    inkdraw_classPrivateFieldSet(inkdraw_last, this, null);
    inkdraw_classPrivateFieldSet(inkdraw_line, this, null);
    inkdraw_classPrivateFieldSet(_lines, this, null);
    inkdraw_classPrivateFieldSet(_lastSVGPath, this, null);
    return inkdraw_classPrivateFieldGet(inkdraw_outlines, this);
  }
  get defaultSVGProperties() {
    return {
      root: {
        viewBox: "0 0 10000 10000"
      },
      rootClass: {
        draw: true
      },
      bbox: [0, 0, 1, 1]
    };
  }
}
function _normalizePoint(x, y) {
  return Outline._normalizePoint(x, y, inkdraw_classPrivateFieldGet(_parentWidth, this), inkdraw_classPrivateFieldGet(_parentHeight, this), inkdraw_classPrivateFieldGet(inkdraw_rotation, this));
}
var inkdraw_bbox = /*#__PURE__*/new WeakMap();
var _currentRotation = /*#__PURE__*/new WeakMap();
var inkdraw_innerMargin = /*#__PURE__*/new WeakMap();
var _lines2 = /*#__PURE__*/new WeakMap();
var _parentWidth2 = /*#__PURE__*/new WeakMap();
var _parentHeight2 = /*#__PURE__*/new WeakMap();
var _parentScale = /*#__PURE__*/new WeakMap();
var _rotation2 = /*#__PURE__*/new WeakMap();
var _thickness2 = /*#__PURE__*/new WeakMap();
var _InkDrawOutline_brand = /*#__PURE__*/new WeakSet();
class InkDrawOutline extends Outline {
  constructor() {
    super(...arguments);
    inkdraw_classPrivateMethodInitSpec(this, _InkDrawOutline_brand);
    inkdraw_classPrivateFieldInitSpec(this, inkdraw_bbox, void 0);
    inkdraw_classPrivateFieldInitSpec(this, _currentRotation, 0);
    inkdraw_classPrivateFieldInitSpec(this, inkdraw_innerMargin, void 0);
    inkdraw_classPrivateFieldInitSpec(this, _lines2, void 0);
    inkdraw_classPrivateFieldInitSpec(this, _parentWidth2, void 0);
    inkdraw_classPrivateFieldInitSpec(this, _parentHeight2, void 0);
    inkdraw_classPrivateFieldInitSpec(this, _parentScale, void 0);
    inkdraw_classPrivateFieldInitSpec(this, _rotation2, void 0);
    inkdraw_classPrivateFieldInitSpec(this, _thickness2, void 0);
  }
  build(lines, parentWidth, parentHeight, parentScale, rotation, thickness, innerMargin) {
    inkdraw_classPrivateFieldSet(_parentWidth2, this, parentWidth);
    inkdraw_classPrivateFieldSet(_parentHeight2, this, parentHeight);
    inkdraw_classPrivateFieldSet(_parentScale, this, parentScale);
    inkdraw_classPrivateFieldSet(_rotation2, this, rotation);
    inkdraw_classPrivateFieldSet(_thickness2, this, thickness);
    inkdraw_classPrivateFieldSet(inkdraw_innerMargin, this, innerMargin ?? 0);
    inkdraw_classPrivateFieldSet(_lines2, this, lines);
    inkdraw_assertClassBrand(_InkDrawOutline_brand, this, _computeBbox).call(this);
  }
  get thickness() {
    return inkdraw_classPrivateFieldGet(_thickness2, this);
  }
  setLastElement(element) {
    inkdraw_classPrivateFieldGet(_lines2, this).push(element);
    return {
      path: {
        d: this.toSVGPath()
      }
    };
  }
  removeLastElement() {
    inkdraw_classPrivateFieldGet(_lines2, this).pop();
    return {
      path: {
        d: this.toSVGPath()
      }
    };
  }
  toSVGPath() {
    const buffer = [];
    for (const {
      line
    } of inkdraw_classPrivateFieldGet(_lines2, this)) {
      buffer.push(`M${Outline.svgRound(line[4])} ${Outline.svgRound(line[5])}`);
      if (line.length === 6) {
        buffer.push("Z");
        continue;
      }
      if (line.length === 12 && isNaN(line[6])) {
        buffer.push(`L${Outline.svgRound(line[10])} ${Outline.svgRound(line[11])}`);
        continue;
      }
      for (let i = 6, ii = line.length; i < ii; i += 6) {
        const [c1x, c1y, c2x, c2y, x, y] = line.subarray(i, i + 6).map(Outline.svgRound);
        buffer.push(`C${c1x} ${c1y} ${c2x} ${c2y} ${x} ${y}`);
      }
    }
    return buffer.join("");
  }
  serialize(_ref, isForCopying) {
    let [pageX, pageY, pageWidth, pageHeight] = _ref;
    const serializedLines = [];
    const serializedPoints = [];
    const [x, y, width, height] = inkdraw_assertClassBrand(_InkDrawOutline_brand, this, _getBBoxWithNoMargin).call(this);
    let tx, ty, sx, sy, x1, y1, x2, y2, rescaleFn;
    switch (inkdraw_classPrivateFieldGet(_rotation2, this)) {
      case 0:
        rescaleFn = Outline._rescale;
        tx = pageX;
        ty = pageY + pageHeight;
        sx = pageWidth;
        sy = -pageHeight;
        x1 = pageX + x * pageWidth;
        y1 = pageY + (1 - y - height) * pageHeight;
        x2 = pageX + (x + width) * pageWidth;
        y2 = pageY + (1 - y) * pageHeight;
        break;
      case 90:
        rescaleFn = Outline._rescaleAndSwap;
        tx = pageX;
        ty = pageY;
        sx = pageWidth;
        sy = pageHeight;
        x1 = pageX + y * pageWidth;
        y1 = pageY + x * pageHeight;
        x2 = pageX + (y + height) * pageWidth;
        y2 = pageY + (x + width) * pageHeight;
        break;
      case 180:
        rescaleFn = Outline._rescale;
        tx = pageX + pageWidth;
        ty = pageY;
        sx = -pageWidth;
        sy = pageHeight;
        x1 = pageX + (1 - x - width) * pageWidth;
        y1 = pageY + y * pageHeight;
        x2 = pageX + (1 - x) * pageWidth;
        y2 = pageY + (y + height) * pageHeight;
        break;
      case 270:
        rescaleFn = Outline._rescaleAndSwap;
        tx = pageX + pageWidth;
        ty = pageY + pageHeight;
        sx = -pageWidth;
        sy = -pageHeight;
        x1 = pageX + (1 - y - height) * pageWidth;
        y1 = pageY + (1 - x - width) * pageHeight;
        x2 = pageX + (1 - y) * pageWidth;
        y2 = pageY + (1 - x) * pageHeight;
        break;
    }
    for (const {
      line,
      points
    } of inkdraw_classPrivateFieldGet(_lines2, this)) {
      serializedLines.push(rescaleFn(line, tx, ty, sx, sy, isForCopying ? new Array(line.length) : null));
      serializedPoints.push(rescaleFn(points, tx, ty, sx, sy, isForCopying ? new Array(points.length) : null));
    }
    return {
      lines: serializedLines,
      points: serializedPoints,
      rect: [x1, y1, x2, y2]
    };
  }
  static deserialize(pageX, pageY, pageWidth, pageHeight, innerMargin, _ref2) {
    let {
      paths: {
        lines,
        points
      },
      rotation,
      thickness
    } = _ref2;
    const newLines = [];
    let tx, ty, sx, sy, rescaleFn;
    switch (rotation) {
      case 0:
        rescaleFn = Outline._rescale;
        tx = -pageX / pageWidth;
        ty = pageY / pageHeight + 1;
        sx = 1 / pageWidth;
        sy = -1 / pageHeight;
        break;
      case 90:
        rescaleFn = Outline._rescaleAndSwap;
        tx = -pageY / pageHeight;
        ty = -pageX / pageWidth;
        sx = 1 / pageHeight;
        sy = 1 / pageWidth;
        break;
      case 180:
        rescaleFn = Outline._rescale;
        tx = pageX / pageWidth + 1;
        ty = -pageY / pageHeight;
        sx = -1 / pageWidth;
        sy = 1 / pageHeight;
        break;
      case 270:
        rescaleFn = Outline._rescaleAndSwap;
        tx = pageY / pageHeight + 1;
        ty = pageX / pageWidth + 1;
        sx = -1 / pageHeight;
        sy = -1 / pageWidth;
        break;
    }
    if (!lines) {
      lines = [];
      for (const point of points) {
        const len = point.length;
        if (len === 2) {
          lines.push(new Float32Array([NaN, NaN, NaN, NaN, point[0], point[1]]));
          continue;
        }
        if (len === 4) {
          lines.push(new Float32Array([NaN, NaN, NaN, NaN, point[0], point[1], NaN, NaN, NaN, NaN, point[2], point[3]]));
          continue;
        }
        const line = new Float32Array(3 * (len - 2));
        lines.push(line);
        let [x1, y1, x2, y2] = point.subarray(0, 4);
        line.set([NaN, NaN, NaN, NaN, x1, y1], 0);
        for (let i = 4; i < len; i += 2) {
          const x = point[i];
          const y = point[i + 1];
          line.set(Outline.createBezierPoints(x1, y1, x2, y2, x, y), (i - 2) * 3);
          [x1, y1, x2, y2] = [x2, y2, x, y];
        }
      }
    }
    for (let i = 0, ii = lines.length; i < ii; i++) {
      newLines.push({
        line: rescaleFn(lines[i].map(x => x ?? NaN), tx, ty, sx, sy),
        points: rescaleFn(points[i].map(x => x ?? NaN), tx, ty, sx, sy)
      });
    }
    const outlines = new this.prototype.constructor();
    outlines.build(newLines, pageWidth, pageHeight, 1, rotation, thickness, innerMargin);
    return outlines;
  }
  get box() {
    return inkdraw_classPrivateFieldGet(inkdraw_bbox, this);
  }
  updateProperty(name, value) {
    if (name === "stroke-width") {
      return inkdraw_assertClassBrand(_InkDrawOutline_brand, this, inkdraw_updateThickness).call(this, value);
    }
    return null;
  }
  updateParentDimensions(_ref3, scale) {
    let [width, height] = _ref3;
    const [oldMarginX, oldMarginY] = inkdraw_assertClassBrand(_InkDrawOutline_brand, this, _getMarginComponents).call(this);
    inkdraw_classPrivateFieldSet(_parentWidth2, this, width);
    inkdraw_classPrivateFieldSet(_parentHeight2, this, height);
    inkdraw_classPrivateFieldSet(_parentScale, this, scale);
    const [newMarginX, newMarginY] = inkdraw_assertClassBrand(_InkDrawOutline_brand, this, _getMarginComponents).call(this);
    const diffMarginX = newMarginX - oldMarginX;
    const diffMarginY = newMarginY - oldMarginY;
    const bbox = inkdraw_classPrivateFieldGet(inkdraw_bbox, this);
    bbox[0] -= diffMarginX;
    bbox[1] -= diffMarginY;
    bbox[2] += 2 * diffMarginX;
    bbox[3] += 2 * diffMarginY;
    return bbox;
  }
  updateRotation(rotation) {
    inkdraw_classPrivateFieldSet(_currentRotation, this, rotation);
    return {
      path: {
        transform: this.rotationTransform
      }
    };
  }
  get viewBox() {
    return inkdraw_classPrivateFieldGet(inkdraw_bbox, this).map(Outline.svgRound).join(" ");
  }
  get defaultProperties() {
    const [x, y] = inkdraw_classPrivateFieldGet(inkdraw_bbox, this);
    return {
      root: {
        viewBox: this.viewBox
      },
      path: {
        "transform-origin": `${Outline.svgRound(x)} ${Outline.svgRound(y)}`
      }
    };
  }
  get rotationTransform() {
    const [,, width, height] = inkdraw_classPrivateFieldGet(inkdraw_bbox, this);
    let a = 0,
      b = 0,
      c = 0,
      d = 0,
      e = 0,
      f = 0;
    switch (inkdraw_classPrivateFieldGet(_currentRotation, this)) {
      case 90:
        b = height / width;
        c = -width / height;
        e = width;
        break;
      case 180:
        a = -1;
        d = -1;
        e = width;
        f = height;
        break;
      case 270:
        b = -height / width;
        c = width / height;
        f = height;
        break;
      default:
        return "";
    }
    return `matrix(${a} ${b} ${c} ${d} ${Outline.svgRound(e)} ${Outline.svgRound(f)})`;
  }
  getPathResizingSVGProperties(_ref4) {
    let [newX, newY, newWidth, newHeight] = _ref4;
    const [marginX, marginY] = inkdraw_assertClassBrand(_InkDrawOutline_brand, this, _getMarginComponents).call(this);
    const [x, y, width, height] = inkdraw_classPrivateFieldGet(inkdraw_bbox, this);
    if (Math.abs(width - marginX) <= Outline.PRECISION || Math.abs(height - marginY) <= Outline.PRECISION) {
      const tx = newX + newWidth / 2 - (x + width / 2);
      const ty = newY + newHeight / 2 - (y + height / 2);
      return {
        path: {
          "transform-origin": `${Outline.svgRound(newX)} ${Outline.svgRound(newY)}`,
          transform: `${this.rotationTransform} translate(${tx} ${ty})`
        }
      };
    }
    const s1x = (newWidth - 2 * marginX) / (width - 2 * marginX);
    const s1y = (newHeight - 2 * marginY) / (height - 2 * marginY);
    const s2x = width / newWidth;
    const s2y = height / newHeight;
    return {
      path: {
        "transform-origin": `${Outline.svgRound(x)} ${Outline.svgRound(y)}`,
        transform: `${this.rotationTransform} scale(${s2x} ${s2y}) ` + `translate(${Outline.svgRound(marginX)} ${Outline.svgRound(marginY)}) scale(${s1x} ${s1y}) ` + `translate(${Outline.svgRound(-marginX)} ${Outline.svgRound(-marginY)})`
      }
    };
  }
  getPathResizedSVGProperties(_ref5) {
    let [newX, newY, newWidth, newHeight] = _ref5;
    const [marginX, marginY] = inkdraw_assertClassBrand(_InkDrawOutline_brand, this, _getMarginComponents).call(this);
    const bbox = inkdraw_classPrivateFieldGet(inkdraw_bbox, this);
    const [x, y, width, height] = bbox;
    bbox[0] = newX;
    bbox[1] = newY;
    bbox[2] = newWidth;
    bbox[3] = newHeight;
    if (Math.abs(width - marginX) <= Outline.PRECISION || Math.abs(height - marginY) <= Outline.PRECISION) {
      const tx = newX + newWidth / 2 - (x + width / 2);
      const ty = newY + newHeight / 2 - (y + height / 2);
      for (const {
        line,
        points
      } of inkdraw_classPrivateFieldGet(_lines2, this)) {
        Outline._translate(line, tx, ty, line);
        Outline._translate(points, tx, ty, points);
      }
      return {
        root: {
          viewBox: this.viewBox
        },
        path: {
          "transform-origin": `${Outline.svgRound(newX)} ${Outline.svgRound(newY)}`,
          transform: this.rotationTransform || null,
          d: this.toSVGPath()
        }
      };
    }
    const s1x = (newWidth - 2 * marginX) / (width - 2 * marginX);
    const s1y = (newHeight - 2 * marginY) / (height - 2 * marginY);
    const tx = -s1x * (x + marginX) + newX + marginX;
    const ty = -s1y * (y + marginY) + newY + marginY;
    if (s1x !== 1 || s1y !== 1 || tx !== 0 || ty !== 0) {
      for (const {
        line,
        points
      } of inkdraw_classPrivateFieldGet(_lines2, this)) {
        Outline._rescale(line, tx, ty, s1x, s1y, line);
        Outline._rescale(points, tx, ty, s1x, s1y, points);
      }
    }
    return {
      root: {
        viewBox: this.viewBox
      },
      path: {
        "transform-origin": `${Outline.svgRound(newX)} ${Outline.svgRound(newY)}`,
        transform: this.rotationTransform || null,
        d: this.toSVGPath()
      }
    };
  }
  getPathTranslatedSVGProperties(_ref6, parentDimensions) {
    let [newX, newY] = _ref6;
    const [newParentWidth, newParentHeight] = parentDimensions;
    const bbox = inkdraw_classPrivateFieldGet(inkdraw_bbox, this);
    const tx = newX - bbox[0];
    const ty = newY - bbox[1];
    if (inkdraw_classPrivateFieldGet(_parentWidth2, this) === newParentWidth && inkdraw_classPrivateFieldGet(_parentHeight2, this) === newParentHeight) {
      for (const {
        line,
        points
      } of inkdraw_classPrivateFieldGet(_lines2, this)) {
        Outline._translate(line, tx, ty, line);
        Outline._translate(points, tx, ty, points);
      }
    } else {
      const sx = inkdraw_classPrivateFieldGet(_parentWidth2, this) / newParentWidth;
      const sy = inkdraw_classPrivateFieldGet(_parentHeight2, this) / newParentHeight;
      inkdraw_classPrivateFieldSet(_parentWidth2, this, newParentWidth);
      inkdraw_classPrivateFieldSet(_parentHeight2, this, newParentHeight);
      for (const {
        line,
        points
      } of inkdraw_classPrivateFieldGet(_lines2, this)) {
        Outline._rescale(line, tx, ty, sx, sy, line);
        Outline._rescale(points, tx, ty, sx, sy, points);
      }
      bbox[2] *= sx;
      bbox[3] *= sy;
    }
    bbox[0] = newX;
    bbox[1] = newY;
    return {
      root: {
        viewBox: this.viewBox
      },
      path: {
        d: this.toSVGPath(),
        "transform-origin": `${Outline.svgRound(newX)} ${Outline.svgRound(newY)}`
      }
    };
  }
  get defaultSVGProperties() {
    const bbox = inkdraw_classPrivateFieldGet(inkdraw_bbox, this);
    return {
      root: {
        viewBox: this.viewBox
      },
      rootClass: {
        draw: true
      },
      path: {
        d: this.toSVGPath(),
        "transform-origin": `${Outline.svgRound(bbox[0])} ${Outline.svgRound(bbox[1])}`,
        transform: this.rotationTransform || null
      },
      bbox
    };
  }
}
function _getMarginComponents() {
  let thickness = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : inkdraw_classPrivateFieldGet(_thickness2, this);
  const margin = inkdraw_classPrivateFieldGet(inkdraw_innerMargin, this) + thickness / 2 * inkdraw_classPrivateFieldGet(_parentScale, this);
  return inkdraw_classPrivateFieldGet(_rotation2, this) % 180 === 0 ? [margin / inkdraw_classPrivateFieldGet(_parentWidth2, this), margin / inkdraw_classPrivateFieldGet(_parentHeight2, this)] : [margin / inkdraw_classPrivateFieldGet(_parentHeight2, this), margin / inkdraw_classPrivateFieldGet(_parentWidth2, this)];
}
function _getBBoxWithNoMargin() {
  const [x, y, width, height] = inkdraw_classPrivateFieldGet(inkdraw_bbox, this);
  const [marginX, marginY] = inkdraw_assertClassBrand(_InkDrawOutline_brand, this, _getMarginComponents).call(this, 0);
  return [x + marginX, y + marginY, width - 2 * marginX, height - 2 * marginY];
}
function _computeBbox() {
  const bbox = inkdraw_classPrivateFieldSet(inkdraw_bbox, this, new Float32Array([Infinity, Infinity, -Infinity, -Infinity]));
  for (const {
    line
  } of inkdraw_classPrivateFieldGet(_lines2, this)) {
    if (line.length <= 12) {
      for (let i = 4, ii = line.length; i < ii; i += 6) {
        Util.pointBoundingBox(line[i], line[i + 1], bbox);
      }
      continue;
    }
    let lastX = line[4],
      lastY = line[5];
    for (let i = 6, ii = line.length; i < ii; i += 6) {
      const [c1x, c1y, c2x, c2y, x, y] = line.subarray(i, i + 6);
      Util.bezierBoundingBox(lastX, lastY, c1x, c1y, c2x, c2y, x, y, bbox);
      lastX = x;
      lastY = y;
    }
  }
  const [marginX, marginY] = inkdraw_assertClassBrand(_InkDrawOutline_brand, this, _getMarginComponents).call(this);
  bbox[0] = MathClamp(bbox[0] - marginX, 0, 1);
  bbox[1] = MathClamp(bbox[1] - marginY, 0, 1);
  bbox[2] = MathClamp(bbox[2] + marginX, 0, 1);
  bbox[3] = MathClamp(bbox[3] + marginY, 0, 1);
  bbox[2] -= bbox[0];
  bbox[3] -= bbox[1];
}
function inkdraw_updateThickness(thickness) {
  const [oldMarginX, oldMarginY] = inkdraw_assertClassBrand(_InkDrawOutline_brand, this, _getMarginComponents).call(this);
  inkdraw_classPrivateFieldSet(_thickness2, this, thickness);
  const [newMarginX, newMarginY] = inkdraw_assertClassBrand(_InkDrawOutline_brand, this, _getMarginComponents).call(this);
  const [diffMarginX, diffMarginY] = [newMarginX - oldMarginX, newMarginY - oldMarginY];
  const bbox = inkdraw_classPrivateFieldGet(inkdraw_bbox, this);
  bbox[0] -= diffMarginX;
  bbox[1] -= diffMarginY;
  bbox[2] += 2 * diffMarginX;
  bbox[3] += 2 * diffMarginY;
  return bbox;
}

;// ./src/display/editor/ink.js



function ink_classPrivateMethodInitSpec(e, a) { ink_checkPrivateRedeclaration(e, a), a.add(e); }
function ink_checkPrivateRedeclaration(e, t) { if (t.has(e)) throw new TypeError("Cannot initialize the same private elements twice on an object"); }
function ink_defineProperty(e, r, t) { return (r = ink_toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function ink_toPropertyKey(t) { var i = ink_toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function ink_toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function ink_assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); }





class InkDrawingOptions extends DrawingOptions {
  constructor(viewerParameters) {
    super();
    this._viewParameters = viewerParameters;
    super.updateProperties({
      fill: "none",
      stroke: AnnotationEditor._defaultLineColor,
      "stroke-opacity": 1,
      "stroke-width": 1,
      "stroke-linecap": "round",
      "stroke-linejoin": "round",
      "stroke-miterlimit": 10
    });
  }
  updateSVGProperty(name, value) {
    if (name === "stroke-width") {
      value ??= this["stroke-width"];
      value *= this._viewParameters.realScale;
    }
    super.updateSVGProperty(name, value);
  }
  clone() {
    const clone = new InkDrawingOptions(this._viewParameters);
    clone.updateAll(this);
    return clone;
  }
}
var _InkEditor_brand = /*#__PURE__*/new WeakSet();
class InkEditor extends DrawingEditor {
  constructor(params) {
    super({
      ...params,
      name: "inkEditor"
    });
    ink_classPrivateMethodInitSpec(this, _InkEditor_brand);
    this._willKeepAspectRatio = true;
    this.defaultL10nId = "pdfjs-editor-ink-editor";
  }
  static initialize(l10n, uiManager) {
    AnnotationEditor.initialize(l10n, uiManager);
    this._defaultDrawingOptions = new InkDrawingOptions(uiManager.viewParameters);
  }
  static getDefaultDrawingOptions(options) {
    const clone = this._defaultDrawingOptions.clone();
    clone.updateProperties(options);
    return clone;
  }
  static get supportMultipleDrawings() {
    return true;
  }
  static get typesMap() {
    return shadow(this, "typesMap", new Map([[AnnotationEditorParamsType.INK_THICKNESS, "stroke-width"], [AnnotationEditorParamsType.INK_COLOR, "stroke"], [AnnotationEditorParamsType.INK_OPACITY, "stroke-opacity"]]));
  }
  static createDrawerInstance(x, y, parentWidth, parentHeight, rotation) {
    return new InkDrawOutliner(x, y, parentWidth, parentHeight, rotation, this._defaultDrawingOptions["stroke-width"]);
  }
  static deserializeDraw(pageX, pageY, pageWidth, pageHeight, innerMargin, data) {
    return InkDrawOutline.deserialize(pageX, pageY, pageWidth, pageHeight, innerMargin, data);
  }
  static async deserialize(data, parent, uiManager) {
    let initialData = null;
    if (data instanceof InkAnnotationElement) {
      const {
        data: {
          inkLists,
          rect,
          rotation,
          id,
          color,
          opacity,
          borderStyle: {
            rawWidth: thickness
          },
          popupRef
        },
        parent: {
          page: {
            pageNumber
          }
        }
      } = data;
      initialData = data = {
        annotationType: AnnotationEditorType.INK,
        color: Array.from(color),
        thickness,
        opacity,
        paths: {
          points: inkLists
        },
        boxes: null,
        pageIndex: pageNumber - 1,
        rect: rect.slice(0),
        rotation,
        id,
        deleted: false,
        popupRef
      };
    }
    const editor = await super.deserialize(data, parent, uiManager);
    editor.annotationElementId = data.id || null;
    editor._initialData = initialData;
    return editor;
  }
  onScaleChanging() {
    if (!this.parent) {
      return;
    }
    super.onScaleChanging();
    const {
      _drawId,
      _drawingOptions,
      parent
    } = this;
    _drawingOptions.updateSVGProperty("stroke-width");
    parent.drawLayer.updateProperties(_drawId, _drawingOptions.toSVGProperties());
  }
  static onScaleChangingWhenDrawing() {
    const parent = this._currentParent;
    if (!parent) {
      return;
    }
    super.onScaleChangingWhenDrawing();
    this._defaultDrawingOptions.updateSVGProperty("stroke-width");
    parent.drawLayer.updateProperties(this._currentDrawId, this._defaultDrawingOptions.toSVGProperties());
  }
  createDrawingOptions(_ref) {
    let {
      color,
      thickness,
      opacity
    } = _ref;
    this._drawingOptions = InkEditor.getDefaultDrawingOptions({
      stroke: Util.makeHexColor(...color),
      "stroke-width": thickness,
      "stroke-opacity": opacity
    });
  }
  serialize() {
    let isForCopying = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
    if (this.isEmpty()) {
      return null;
    }
    if (this.deleted) {
      return this.serializeDeleted();
    }
    const {
      lines,
      points,
      rect
    } = this.serializeDraw(isForCopying);
    const {
      _drawingOptions: {
        stroke,
        "stroke-opacity": opacity,
        "stroke-width": thickness
      }
    } = this;
    const serialized = {
      annotationType: AnnotationEditorType.INK,
      color: AnnotationEditor._colorManager.convert(stroke),
      opacity,
      thickness,
      paths: {
        lines,
        points
      },
      pageIndex: this.pageIndex,
      rect,
      rotation: this.rotation,
      structTreeParentId: this._structTreeParentId
    };
    if (isForCopying) {
      serialized.isCopy = true;
      return serialized;
    }
    if (this.annotationElementId && !ink_assertClassBrand(_InkEditor_brand, this, ink_hasElementChanged).call(this, serialized)) {
      return null;
    }
    serialized.id = this.annotationElementId;
    return serialized;
  }
  renderAnnotationElement(annotation) {
    const {
      points,
      rect
    } = this.serializeDraw(false);
    annotation.updateEdited({
      rect,
      thickness: this._drawingOptions["stroke-width"],
      points
    });
    return null;
  }
}
function ink_hasElementChanged(serialized) {
  const {
    color,
    thickness,
    opacity,
    pageIndex
  } = this._initialData;
  return this._hasBeenMoved || this._hasBeenResized || serialized.color.some((c, i) => c !== color[i]) || serialized.thickness !== thickness || serialized.opacity !== opacity || serialized.pageIndex !== pageIndex;
}
ink_defineProperty(InkEditor, "_type", "ink");
ink_defineProperty(InkEditor, "_editorType", AnnotationEditorType.INK);
ink_defineProperty(InkEditor, "_defaultDrawingOptions", null);

;// ./src/display/editor/drawers/contour.js

class ContourDrawOutline extends InkDrawOutline {
  toSVGPath() {
    let path = super.toSVGPath();
    if (!path.endsWith("Z")) {
      path += "Z";
    }
    return path;
  }
}

;// ./src/display/editor/drawers/signaturedraw.js
var _SignatureExtractor;




















function signaturedraw_assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); }




const BASE_HEADER_LENGTH = 8;
const POINTS_PROPERTIES_NUMBER = 3;
class SignatureExtractor {
  static extractContoursFromText(text, _ref, pageWidth, pageHeight, rotation, innerMargin) {
    let {
      fontFamily,
      fontStyle,
      fontWeight
    } = _ref;
    let canvas = new OffscreenCanvas(1, 1);
    let ctx = canvas.getContext("2d", {
      alpha: false
    });
    const fontSize = 200;
    const font = ctx.font = `${fontStyle} ${fontWeight} ${fontSize}px ${fontFamily}`;
    const {
      actualBoundingBoxLeft,
      actualBoundingBoxRight,
      actualBoundingBoxAscent,
      actualBoundingBoxDescent,
      fontBoundingBoxAscent,
      fontBoundingBoxDescent,
      width
    } = ctx.measureText(text);
    const SCALE = 1.5;
    const canvasWidth = Math.ceil(Math.max(Math.abs(actualBoundingBoxLeft) + Math.abs(actualBoundingBoxRight) || 0, width) * SCALE);
    const canvasHeight = Math.ceil(Math.max(Math.abs(actualBoundingBoxAscent) + Math.abs(actualBoundingBoxDescent) || fontSize, Math.abs(fontBoundingBoxAscent) + Math.abs(fontBoundingBoxDescent) || fontSize) * SCALE);
    canvas = new OffscreenCanvas(canvasWidth, canvasHeight);
    ctx = canvas.getContext("2d", {
      alpha: true,
      willReadFrequently: true
    });
    ctx.font = font;
    ctx.filter = "grayscale(1)";
    ctx.fillStyle = "white";
    ctx.fillRect(0, 0, canvasWidth, canvasHeight);
    ctx.fillStyle = "black";
    ctx.fillText(text, canvasWidth * (SCALE - 1) / 2, canvasHeight * (3 - SCALE) / 2);
    const uint8Buf = signaturedraw_assertClassBrand(SignatureExtractor, this, _toUint).call(this, ctx.getImageData(0, 0, canvasWidth, canvasHeight).data);
    const histogram = signaturedraw_assertClassBrand(SignatureExtractor, this, _getHistogram).call(this, uint8Buf);
    const threshold = signaturedraw_assertClassBrand(SignatureExtractor, this, _guessThreshold).call(this, histogram);
    const contourList = signaturedraw_assertClassBrand(SignatureExtractor, this, _findContours).call(this, uint8Buf, canvasWidth, canvasHeight, threshold);
    return this.processDrawnLines({
      lines: {
        curves: contourList,
        width: canvasWidth,
        height: canvasHeight
      },
      pageWidth,
      pageHeight,
      rotation,
      innerMargin,
      mustSmooth: true,
      areContours: true
    });
  }
  static process(bitmap, pageWidth, pageHeight, rotation, innerMargin) {
    const [uint8Buf, width, height] = signaturedraw_assertClassBrand(SignatureExtractor, this, _getGrayPixels).call(this, bitmap);
    const [buffer, histogram] = signaturedraw_assertClassBrand(SignatureExtractor, this, _bilateralFilter).call(this, uint8Buf, width, height, Math.hypot(width, height) * signaturedraw_assertClassBrand(SignatureExtractor, this, _PARAMETERS)._.sigmaSFactor, signaturedraw_assertClassBrand(SignatureExtractor, this, _PARAMETERS)._.sigmaR, signaturedraw_assertClassBrand(SignatureExtractor, this, _PARAMETERS)._.kernelSize);
    const threshold = signaturedraw_assertClassBrand(SignatureExtractor, this, _guessThreshold).call(this, histogram);
    const contourList = signaturedraw_assertClassBrand(SignatureExtractor, this, _findContours).call(this, buffer, width, height, threshold);
    return this.processDrawnLines({
      lines: {
        curves: contourList,
        width,
        height
      },
      pageWidth,
      pageHeight,
      rotation,
      innerMargin,
      mustSmooth: true,
      areContours: true
    });
  }
  static processDrawnLines(_ref2) {
    let {
      lines,
      pageWidth,
      pageHeight,
      rotation,
      innerMargin,
      mustSmooth,
      areContours
    } = _ref2;
    if (rotation % 180 !== 0) {
      [pageWidth, pageHeight] = [pageHeight, pageWidth];
    }
    const {
      curves,
      width,
      height
    } = lines;
    const thickness = lines.thickness ?? 0;
    const linesAndPoints = [];
    const ratio = Math.min(pageWidth / width, pageHeight / height);
    const xScale = ratio / pageWidth;
    const yScale = ratio / pageHeight;
    const newCurves = [];
    for (const {
      points
    } of curves) {
      const reducedPoints = mustSmooth ? signaturedraw_assertClassBrand(SignatureExtractor, this, _douglasPeucker).call(this, points) : points;
      if (!reducedPoints) {
        continue;
      }
      newCurves.push(reducedPoints);
      const len = reducedPoints.length;
      const newPoints = new Float32Array(len);
      const line = new Float32Array(3 * (len === 2 ? 2 : len - 2));
      linesAndPoints.push({
        line,
        points: newPoints
      });
      if (len === 2) {
        newPoints[0] = reducedPoints[0] * xScale;
        newPoints[1] = reducedPoints[1] * yScale;
        line.set([NaN, NaN, NaN, NaN, newPoints[0], newPoints[1]], 0);
        continue;
      }
      let [x1, y1, x2, y2] = reducedPoints;
      x1 *= xScale;
      y1 *= yScale;
      x2 *= xScale;
      y2 *= yScale;
      newPoints.set([x1, y1, x2, y2], 0);
      line.set([NaN, NaN, NaN, NaN, x1, y1], 0);
      for (let i = 4; i < len; i += 2) {
        const x = newPoints[i] = reducedPoints[i] * xScale;
        const y = newPoints[i + 1] = reducedPoints[i + 1] * yScale;
        line.set(Outline.createBezierPoints(x1, y1, x2, y2, x, y), (i - 2) * 3);
        [x1, y1, x2, y2] = [x2, y2, x, y];
      }
    }
    if (linesAndPoints.length === 0) {
      return null;
    }
    const outline = areContours ? new ContourDrawOutline() : new InkDrawOutline();
    outline.build(linesAndPoints, pageWidth, pageHeight, 1, rotation, areContours ? 0 : thickness, innerMargin);
    return {
      outline,
      newCurves,
      areContours,
      thickness,
      width,
      height
    };
  }
  static async compressSignature(_ref3) {
    let {
      outlines,
      areContours,
      thickness,
      width,
      height
    } = _ref3;
    let minDiff = Infinity;
    let maxDiff = -Infinity;
    let outlinesLength = 0;
    for (const points of outlines) {
      outlinesLength += points.length;
      for (let i = 2, ii = points.length; i < ii; i++) {
        const dx = points[i] - points[i - 2];
        minDiff = Math.min(minDiff, dx);
        maxDiff = Math.max(maxDiff, dx);
      }
    }
    let bufferType;
    if (minDiff >= -128 && maxDiff <= 127) {
      bufferType = Int8Array;
    } else if (minDiff >= -32768 && maxDiff <= 32767) {
      bufferType = Int16Array;
    } else {
      bufferType = Int32Array;
    }
    const len = outlines.length;
    const headerLength = BASE_HEADER_LENGTH + POINTS_PROPERTIES_NUMBER * len;
    const header = new Uint32Array(headerLength);
    let offset = 0;
    header[offset++] = headerLength * Uint32Array.BYTES_PER_ELEMENT + (outlinesLength - 2 * len) * bufferType.BYTES_PER_ELEMENT;
    header[offset++] = 0;
    header[offset++] = width;
    header[offset++] = height;
    header[offset++] = areContours ? 0 : 1;
    header[offset++] = Math.max(0, Math.floor(thickness ?? 0));
    header[offset++] = len;
    header[offset++] = bufferType.BYTES_PER_ELEMENT;
    for (const points of outlines) {
      header[offset++] = points.length - 2;
      header[offset++] = points[0];
      header[offset++] = points[1];
    }
    const cs = new CompressionStream("deflate-raw");
    const writer = cs.writable.getWriter();
    await writer.ready;
    writer.write(header);
    const BufferCtor = bufferType.prototype.constructor;
    for (const points of outlines) {
      const diffs = new BufferCtor(points.length - 2);
      for (let i = 2, ii = points.length; i < ii; i++) {
        diffs[i - 2] = points[i] - points[i - 2];
      }
      writer.write(diffs);
    }
    writer.close();
    const buf = await new Response(cs.readable).arrayBuffer();
    const bytes = new Uint8Array(buf);
    return toBase64Util(bytes);
  }
  static async decompressSignature(signatureData) {
    try {
      const bytes = fromBase64Util(signatureData);
      const {
        readable,
        writable
      } = new DecompressionStream("deflate-raw");
      const writer = writable.getWriter();
      await writer.ready;
      writer.write(bytes).then(async () => {
        await writer.ready;
        await writer.close();
      }).catch(() => {});
      let data = null;
      let offset = 0;
      for await (const chunk of readable) {
        data ||= new Uint8Array(new Uint32Array(chunk.buffer, 0, 4)[0]);
        data.set(chunk, offset);
        offset += chunk.length;
      }
      const header = new Uint32Array(data.buffer, 0, data.length >> 2);
      const version = header[1];
      if (version !== 0) {
        throw new Error(`Invalid version: ${version}`);
      }
      const width = header[2];
      const height = header[3];
      const areContours = header[4] === 0;
      const thickness = header[5];
      const numberOfDrawings = header[6];
      const bufferType = header[7];
      const outlines = [];
      const diffsOffset = (BASE_HEADER_LENGTH + POINTS_PROPERTIES_NUMBER * numberOfDrawings) * Uint32Array.BYTES_PER_ELEMENT;
      let diffs;
      switch (bufferType) {
        case Int8Array.BYTES_PER_ELEMENT:
          diffs = new Int8Array(data.buffer, diffsOffset);
          break;
        case Int16Array.BYTES_PER_ELEMENT:
          diffs = new Int16Array(data.buffer, diffsOffset);
          break;
        case Int32Array.BYTES_PER_ELEMENT:
          diffs = new Int32Array(data.buffer, diffsOffset);
          break;
      }
      offset = 0;
      for (let i = 0; i < numberOfDrawings; i++) {
        const len = header[POINTS_PROPERTIES_NUMBER * i + BASE_HEADER_LENGTH];
        const points = new Float32Array(len + 2);
        outlines.push(points);
        for (let j = 0; j < POINTS_PROPERTIES_NUMBER - 1; j++) {
          points[j] = header[POINTS_PROPERTIES_NUMBER * i + BASE_HEADER_LENGTH + j + 1];
        }
        for (let j = 0; j < len; j++) {
          points[j + 2] = points[j] + diffs[offset++];
        }
      }
      return {
        areContours,
        thickness,
        outlines,
        width,
        height
      };
    } catch (e) {
      warn(`decompressSignature: ${e}`);
      return null;
    }
  }
}
_SignatureExtractor = SignatureExtractor;
function _neighborIndexToId(i0, j0, i, j) {
  i -= i0;
  j -= j0;
  if (i === 0) {
    return j > 0 ? 0 : 4;
  }
  if (i === 1) {
    return j + 6;
  }
  return 2 - j;
}
function _clockwiseNonZero(buf, width, i0, j0, i, j, offset) {
  const id = signaturedraw_assertClassBrand(_SignatureExtractor, this, _neighborIndexToId).call(this, i0, j0, i, j);
  for (let k = 0; k < 8; k++) {
    const kk = (-k + id - offset + 16) % 8;
    const shiftI = signaturedraw_assertClassBrand(_SignatureExtractor, this, _neighborIdToIndex)._[2 * kk];
    const shiftJ = signaturedraw_assertClassBrand(_SignatureExtractor, this, _neighborIdToIndex)._[2 * kk + 1];
    if (buf[(i0 + shiftI) * width + (j0 + shiftJ)] !== 0) {
      return kk;
    }
  }
  return -1;
}
function _counterClockwiseNonZero(buf, width, i0, j0, i, j, offset) {
  const id = signaturedraw_assertClassBrand(_SignatureExtractor, this, _neighborIndexToId).call(this, i0, j0, i, j);
  for (let k = 0; k < 8; k++) {
    const kk = (k + id + offset + 16) % 8;
    const shiftI = signaturedraw_assertClassBrand(_SignatureExtractor, this, _neighborIdToIndex)._[2 * kk];
    const shiftJ = signaturedraw_assertClassBrand(_SignatureExtractor, this, _neighborIdToIndex)._[2 * kk + 1];
    if (buf[(i0 + shiftI) * width + (j0 + shiftJ)] !== 0) {
      return kk;
    }
  }
  return -1;
}
function _findContours(buf, width, height, threshold) {
  const N = buf.length;
  const types = new Int32Array(N);
  for (let i = 0; i < N; i++) {
    types[i] = buf[i] <= threshold ? 1 : 0;
  }
  for (let i = 1; i < height - 1; i++) {
    types[i * width] = types[i * width + width - 1] = 0;
  }
  for (let i = 0; i < width; i++) {
    types[i] = types[width * height - 1 - i] = 0;
  }
  let nbd = 1;
  let lnbd;
  const contours = [];
  for (let i = 1; i < height - 1; i++) {
    lnbd = 1;
    for (let j = 1; j < width - 1; j++) {
      const ij = i * width + j;
      const pix = types[ij];
      if (pix === 0) {
        continue;
      }
      let i2 = i;
      let j2 = j;
      if (pix === 1 && types[ij - 1] === 0) {
        nbd += 1;
        j2 -= 1;
      } else if (pix >= 1 && types[ij + 1] === 0) {
        nbd += 1;
        j2 += 1;
        if (pix > 1) {
          lnbd = pix;
        }
      } else {
        if (pix !== 1) {
          lnbd = Math.abs(pix);
        }
        continue;
      }
      const points = [j, i];
      const isHole = j2 === j + 1;
      const contour = {
        isHole,
        points,
        id: nbd,
        parent: 0
      };
      contours.push(contour);
      let contour0;
      for (const c of contours) {
        if (c.id === lnbd) {
          contour0 = c;
          break;
        }
      }
      if (!contour0) {
        contour.parent = isHole ? lnbd : 0;
      } else if (contour0.isHole) {
        contour.parent = isHole ? contour0.parent : lnbd;
      } else {
        contour.parent = isHole ? lnbd : contour0.parent;
      }
      const k = signaturedraw_assertClassBrand(_SignatureExtractor, this, _clockwiseNonZero).call(this, types, width, i, j, i2, j2, 0);
      if (k === -1) {
        types[ij] = -nbd;
        if (types[ij] !== 1) {
          lnbd = Math.abs(types[ij]);
        }
        continue;
      }
      let shiftI = signaturedraw_assertClassBrand(_SignatureExtractor, this, _neighborIdToIndex)._[2 * k];
      let shiftJ = signaturedraw_assertClassBrand(_SignatureExtractor, this, _neighborIdToIndex)._[2 * k + 1];
      const i1 = i + shiftI;
      const j1 = j + shiftJ;
      i2 = i1;
      j2 = j1;
      let i3 = i;
      let j3 = j;
      while (true) {
        const kk = signaturedraw_assertClassBrand(_SignatureExtractor, this, _counterClockwiseNonZero).call(this, types, width, i3, j3, i2, j2, 1);
        shiftI = signaturedraw_assertClassBrand(_SignatureExtractor, this, _neighborIdToIndex)._[2 * kk];
        shiftJ = signaturedraw_assertClassBrand(_SignatureExtractor, this, _neighborIdToIndex)._[2 * kk + 1];
        const i4 = i3 + shiftI;
        const j4 = j3 + shiftJ;
        points.push(j4, i4);
        const ij3 = i3 * width + j3;
        if (types[ij3 + 1] === 0) {
          types[ij3] = -nbd;
        } else if (types[ij3] === 1) {
          types[ij3] = nbd;
        }
        if (i4 === i && j4 === j && i3 === i1 && j3 === j1) {
          if (types[ij] !== 1) {
            lnbd = Math.abs(types[ij]);
          }
          break;
        } else {
          i2 = i3;
          j2 = j3;
          i3 = i4;
          j3 = j4;
        }
      }
    }
  }
  return contours;
}
function _douglasPeuckerHelper(points, start, end, output) {
  if (end - start <= 4) {
    for (let i = start; i < end - 2; i += 2) {
      output.push(points[i], points[i + 1]);
    }
    return;
  }
  const ax = points[start];
  const ay = points[start + 1];
  const abx = points[end - 4] - ax;
  const aby = points[end - 3] - ay;
  const dist = Math.hypot(abx, aby);
  const nabx = abx / dist;
  const naby = aby / dist;
  const aa = nabx * ay - naby * ax;
  const m = aby / abx;
  const invS = 1 / dist;
  const phi = Math.atan(m);
  const cosPhi = Math.cos(phi);
  const sinPhi = Math.sin(phi);
  const tmax = invS * (Math.abs(cosPhi) + Math.abs(sinPhi));
  const poly = invS * (1 - tmax + tmax ** 2);
  const partialPhi = Math.max(Math.atan(Math.abs(sinPhi + cosPhi) * poly), Math.atan(Math.abs(sinPhi - cosPhi) * poly));
  let dmax = 0;
  let index = start;
  for (let i = start + 2; i < end - 2; i += 2) {
    const d = Math.abs(aa - nabx * points[i + 1] + naby * points[i]);
    if (d > dmax) {
      index = i;
      dmax = d;
    }
  }
  if (dmax > (dist * partialPhi) ** 2) {
    signaturedraw_assertClassBrand(_SignatureExtractor, this, _douglasPeuckerHelper).call(this, points, start, index + 2, output);
    signaturedraw_assertClassBrand(_SignatureExtractor, this, _douglasPeuckerHelper).call(this, points, index, end, output);
  } else {
    output.push(ax, ay);
  }
}
function _douglasPeucker(points) {
  const output = [];
  const len = points.length;
  signaturedraw_assertClassBrand(_SignatureExtractor, this, _douglasPeuckerHelper).call(this, points, 0, len, output);
  output.push(points[len - 2], points[len - 1]);
  return output.length <= 4 ? null : output;
}
function _bilateralFilter(buf, width, height, sigmaS, sigmaR, kernelSize) {
  const kernel = new Float32Array(kernelSize ** 2);
  const sigmaS2 = -2 * sigmaS ** 2;
  const halfSize = kernelSize >> 1;
  for (let i = 0; i < kernelSize; i++) {
    const x = (i - halfSize) ** 2;
    for (let j = 0; j < kernelSize; j++) {
      kernel[i * kernelSize + j] = Math.exp((x + (j - halfSize) ** 2) / sigmaS2);
    }
  }
  const rangeValues = new Float32Array(256);
  const sigmaR2 = -2 * sigmaR ** 2;
  for (let i = 0; i < 256; i++) {
    rangeValues[i] = Math.exp(i ** 2 / sigmaR2);
  }
  const N = buf.length;
  const out = new Uint8Array(N);
  const histogram = new Uint32Array(256);
  for (let i = 0; i < height; i++) {
    for (let j = 0; j < width; j++) {
      const ij = i * width + j;
      const center = buf[ij];
      let sum = 0;
      let norm = 0;
      for (let k = 0; k < kernelSize; k++) {
        const y = i + k - halfSize;
        if (y < 0 || y >= height) {
          continue;
        }
        for (let l = 0; l < kernelSize; l++) {
          const x = j + l - halfSize;
          if (x < 0 || x >= width) {
            continue;
          }
          const neighbour = buf[y * width + x];
          const w = kernel[k * kernelSize + l] * rangeValues[Math.abs(neighbour - center)];
          sum += neighbour * w;
          norm += w;
        }
      }
      const pix = out[ij] = Math.round(sum / norm);
      histogram[pix]++;
    }
  }
  return [out, histogram];
}
function _getHistogram(buf) {
  const histogram = new Uint32Array(256);
  for (const g of buf) {
    histogram[g]++;
  }
  return histogram;
}
function _toUint(buf) {
  const N = buf.length;
  const out = new Uint8ClampedArray(N >> 2);
  let max = -Infinity;
  let min = Infinity;
  for (let i = 0, ii = out.length; i < ii; i++) {
    const A = buf[(i << 2) + 3];
    if (A === 0) {
      max = out[i] = 0xff;
      continue;
    }
    const pix = out[i] = buf[i << 2];
    if (pix > max) {
      max = pix;
    }
    if (pix < min) {
      min = pix;
    }
  }
  const ratio = 255 / (max - min);
  for (let i = 0; i < N; i++) {
    out[i] = (out[i] - min) * ratio;
  }
  return out;
}
function _guessThreshold(histogram) {
  let i;
  let M = -Infinity;
  let L = -Infinity;
  const min = histogram.findIndex(v => v !== 0);
  let pos = min;
  let spos = min;
  for (i = min; i < 256; i++) {
    const v = histogram[i];
    if (v > M) {
      if (i - pos > L) {
        L = i - pos;
        spos = i - 1;
      }
      M = v;
      pos = i;
    }
  }
  for (i = spos - 1; i >= 0; i--) {
    if (histogram[i] > histogram[i + 1]) {
      break;
    }
  }
  return i;
}
function _getGrayPixels(bitmap) {
  const originalBitmap = bitmap;
  const {
    width,
    height
  } = bitmap;
  const {
    maxDim
  } = signaturedraw_assertClassBrand(_SignatureExtractor, this, _PARAMETERS)._;
  let newWidth = width;
  let newHeight = height;
  if (width > maxDim || height > maxDim) {
    let prevWidth = width;
    let prevHeight = height;
    let steps = Math.log2(Math.max(width, height) / maxDim);
    const isteps = Math.floor(steps);
    steps = steps === isteps ? isteps - 1 : isteps;
    for (let i = 0; i < steps; i++) {
      newWidth = Math.ceil(prevWidth / 2);
      newHeight = Math.ceil(prevHeight / 2);
      const offscreen = new OffscreenCanvas(newWidth, newHeight);
      const ctx = offscreen.getContext("2d");
      ctx.drawImage(bitmap, 0, 0, prevWidth, prevHeight, 0, 0, newWidth, newHeight);
      prevWidth = newWidth;
      prevHeight = newHeight;
      if (bitmap !== originalBitmap) {
        bitmap.close();
      }
      bitmap = offscreen.transferToImageBitmap();
    }
    const ratio = Math.min(maxDim / newWidth, maxDim / newHeight);
    newWidth = Math.round(newWidth * ratio);
    newHeight = Math.round(newHeight * ratio);
  }
  const offscreen = new OffscreenCanvas(newWidth, newHeight);
  const ctx = offscreen.getContext("2d", {
    willReadFrequently: true
  });
  ctx.filter = "grayscale(1)";
  ctx.drawImage(bitmap, 0, 0, bitmap.width, bitmap.height, 0, 0, newWidth, newHeight);
  const grayImage = ctx.getImageData(0, 0, newWidth, newHeight).data;
  const uint8Buf = signaturedraw_assertClassBrand(_SignatureExtractor, this, _toUint).call(this, grayImage);
  return [uint8Buf, newWidth, newHeight];
}
var _PARAMETERS = {
  _: {
    maxDim: 512,
    sigmaSFactor: 0.02,
    sigmaR: 25,
    kernelSize: 16
  }
};
var _neighborIdToIndex = {
  _: new Int32Array([0, 1, -1, 1, -1, 0, -1, -1, 0, -1, 1, -1, 1, 0, 1, 1])
};

;// ./src/display/editor/signature.js



function signature_defineProperty(e, r, t) { return (r = signature_toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function signature_toPropertyKey(t) { var i = signature_toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function signature_toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function signature_classPrivateFieldInitSpec(e, t, a) { signature_checkPrivateRedeclaration(e, t), t.set(e, a); }
function signature_checkPrivateRedeclaration(e, t) { if (t.has(e)) throw new TypeError("Cannot initialize the same private elements twice on an object"); }
function signature_classPrivateFieldGet(s, a) { return s.get(signature_assertClassBrand(s, a)); }
function signature_classPrivateFieldSet(s, a, r) { return s.set(signature_assertClassBrand(s, a), r), r; }
function signature_assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); }







class SignatureOptions extends DrawingOptions {
  constructor() {
    super();
    super.updateProperties({
      fill: AnnotationEditor._defaultLineColor,
      "stroke-width": 0
    });
  }
  clone() {
    const clone = new SignatureOptions();
    clone.updateAll(this);
    return clone;
  }
}
class DrawnSignatureOptions extends InkDrawingOptions {
  constructor(viewerParameters) {
    super(viewerParameters);
    super.updateProperties({
      stroke: AnnotationEditor._defaultLineColor,
      "stroke-width": 1
    });
  }
  clone() {
    const clone = new DrawnSignatureOptions(this._viewParameters);
    clone.updateAll(this);
    return clone;
  }
}
var _isExtracted = /*#__PURE__*/new WeakMap();
var _description = /*#__PURE__*/new WeakMap();
var _signatureData = /*#__PURE__*/new WeakMap();
var _signatureUUID = /*#__PURE__*/new WeakMap();
class SignatureEditor extends DrawingEditor {
  constructor(params) {
    super({
      ...params,
      mustBeCommitted: true,
      name: "signatureEditor"
    });
    signature_classPrivateFieldInitSpec(this, _isExtracted, false);
    signature_classPrivateFieldInitSpec(this, _description, null);
    signature_classPrivateFieldInitSpec(this, _signatureData, null);
    signature_classPrivateFieldInitSpec(this, _signatureUUID, null);
    this._willKeepAspectRatio = true;
    signature_classPrivateFieldSet(_signatureData, this, params.signatureData || null);
    signature_classPrivateFieldSet(_description, this, null);
    this.defaultL10nId = "pdfjs-editor-signature-editor1";
  }
  static initialize(l10n, uiManager) {
    AnnotationEditor.initialize(l10n, uiManager);
    this._defaultDrawingOptions = new SignatureOptions();
    this._defaultDrawnSignatureOptions = new DrawnSignatureOptions(uiManager.viewParameters);
  }
  static getDefaultDrawingOptions(options) {
    const clone = this._defaultDrawingOptions.clone();
    clone.updateProperties(options);
    return clone;
  }
  static get supportMultipleDrawings() {
    return false;
  }
  static get typesMap() {
    return shadow(this, "typesMap", new Map());
  }
  static get isDrawer() {
    return false;
  }
  get telemetryFinalData() {
    return {
      type: "signature",
      hasDescription: !!signature_classPrivateFieldGet(_description, this)
    };
  }
  static computeTelemetryFinalData(data) {
    const hasDescriptionStats = data.get("hasDescription");
    return {
      hasAltText: hasDescriptionStats.get(true) ?? 0,
      hasNoAltText: hasDescriptionStats.get(false) ?? 0
    };
  }
  get isResizable() {
    return true;
  }
  onScaleChanging() {
    if (this._drawId === null) {
      return;
    }
    super.onScaleChanging();
  }
  render() {
    if (this.div) {
      return this.div;
    }
    let baseX, baseY;
    const {
      _isCopy
    } = this;
    if (_isCopy) {
      this._isCopy = false;
      baseX = this.x;
      baseY = this.y;
    }
    super.render();
    if (this._drawId === null) {
      if (signature_classPrivateFieldGet(_signatureData, this)) {
        const {
          lines,
          mustSmooth,
          areContours,
          description,
          uuid,
          heightInPage
        } = signature_classPrivateFieldGet(_signatureData, this);
        const {
          rawDims: {
            pageWidth,
            pageHeight
          },
          rotation
        } = this.parent.viewport;
        const outline = SignatureExtractor.processDrawnLines({
          lines,
          pageWidth,
          pageHeight,
          rotation,
          innerMargin: SignatureEditor._INNER_MARGIN,
          mustSmooth,
          areContours
        });
        this.addSignature(outline, heightInPage, description, uuid);
      } else {
        this.div.setAttribute("data-l10n-args", JSON.stringify({
          description: ""
        }));
        this.div.hidden = true;
        this._uiManager.getSignature(this);
      }
    }
    if (_isCopy) {
      this._isCopy = true;
      this._moveAfterPaste(baseX, baseY);
    }
    return this.div;
  }
  setUuid(uuid) {
    signature_classPrivateFieldSet(_signatureUUID, this, uuid);
    this.addEditToolbar();
  }
  getUuid() {
    return signature_classPrivateFieldGet(_signatureUUID, this);
  }
  get description() {
    return signature_classPrivateFieldGet(_description, this);
  }
  set description(description) {
    signature_classPrivateFieldSet(_description, this, description);
    super.addEditToolbar().then(toolbar => {
      toolbar?.updateEditSignatureButton(description);
    });
  }
  getSignaturePreview() {
    const {
      newCurves,
      areContours,
      thickness,
      width,
      height
    } = signature_classPrivateFieldGet(_signatureData, this);
    const maxDim = Math.max(width, height);
    const outlineData = SignatureExtractor.processDrawnLines({
      lines: {
        curves: newCurves.map(points => ({
          points
        })),
        thickness,
        width,
        height
      },
      pageWidth: maxDim,
      pageHeight: maxDim,
      rotation: 0,
      innerMargin: 0,
      mustSmooth: false,
      areContours
    });
    return {
      areContours,
      outline: outlineData.outline
    };
  }
  async addEditToolbar() {
    const toolbar = await super.addEditToolbar();
    if (!toolbar) {
      return null;
    }
    if (this._uiManager.signatureManager && signature_classPrivateFieldGet(_description, this) !== null) {
      await toolbar.addEditSignatureButton(this._uiManager.signatureManager, signature_classPrivateFieldGet(_signatureUUID, this), signature_classPrivateFieldGet(_description, this));
      toolbar.show();
    }
    return toolbar;
  }
  addSignature(data, heightInPage, description, uuid) {
    const {
      x: savedX,
      y: savedY
    } = this;
    const {
      outline
    } = signature_classPrivateFieldSet(_signatureData, this, data);
    signature_classPrivateFieldSet(_isExtracted, this, outline instanceof ContourDrawOutline);
    signature_classPrivateFieldSet(_description, this, description);
    this.div.setAttribute("data-l10n-args", JSON.stringify({
      description
    }));
    let drawingOptions;
    if (signature_classPrivateFieldGet(_isExtracted, this)) {
      drawingOptions = SignatureEditor.getDefaultDrawingOptions();
    } else {
      drawingOptions = SignatureEditor._defaultDrawnSignatureOptions.clone();
      drawingOptions.updateProperties({
        "stroke-width": outline.thickness
      });
    }
    this._addOutlines({
      drawOutlines: outline,
      drawingOptions
    });
    const [parentWidth, parentHeight] = this.parentDimensions;
    const [, pageHeight] = this.pageDimensions;
    let newHeight = heightInPage / pageHeight;
    newHeight = newHeight >= 1 ? 0.5 : newHeight;
    this.width *= newHeight / this.height;
    if (this.width >= 1) {
      newHeight *= 0.9 / this.width;
      this.width = 0.9;
    }
    this.height = newHeight;
    this.setDims(parentWidth * this.width, parentHeight * this.height);
    this.x = savedX;
    this.y = savedY;
    this.center();
    this._onResized();
    this.onScaleChanging();
    this.rotate();
    this._uiManager.addToAnnotationStorage(this);
    this.setUuid(uuid);
    this._reportTelemetry({
      action: "pdfjs.signature.inserted",
      data: {
        hasBeenSaved: !!uuid,
        hasDescription: !!description
      }
    });
    this.div.hidden = false;
  }
  getFromImage(bitmap) {
    const {
      rawDims: {
        pageWidth,
        pageHeight
      },
      rotation
    } = this.parent.viewport;
    return SignatureExtractor.process(bitmap, pageWidth, pageHeight, rotation, SignatureEditor._INNER_MARGIN);
  }
  getFromText(text, fontInfo) {
    const {
      rawDims: {
        pageWidth,
        pageHeight
      },
      rotation
    } = this.parent.viewport;
    return