﻿using System;
using System.Collections.Generic;
using System.Threading.Tasks;
using MediatR;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Mvc;
using QualityManagement.Data.Dto;
using QualityManagement.MediatR;

namespace QualityManagement.API.Controllers;

/// <summary>
/// Action
/// </summary>
[Route("api")]
[ApiController]
[Authorize]
public class ActionController(IMediator _mediator) : BaseController
{
    /// <summary>
    /// Get Action By Id
    /// </summary>
    /// <param name="pageId"></param>
    /// <returns></returns>

    [HttpGet("Action/{pageId}", Name = "GetAction")]
    [Produces("application/json", "application/xml", Type = typeof(List<ActionDto>))]
    //[ClaimCheck("action_list")]
    public async Task<IActionResult> GetAction(Guid pageId)
    {
        var getActionQuery = new GetActionsByPageQuery { PageId = pageId };
        var result = await _mediator.Send(getActionQuery);
        return Ok(result);
    }
    /// <summary>
    /// Get All Actions
    /// </summary>
    /// <returns></returns>
    [HttpGet("Actions")]
    //[ClaimCheck("action_list", "role_add", "role_edit", "page_action_edit", "user_permission_edit")]
    [Produces("application/json", "application/xml", Type = typeof(List<ActionDto>))]
    public async Task<IActionResult> GetActions()
    {
        var getAllActionQuery = new GetAllActionQuery { };
        var result = await _mediator.Send(getAllActionQuery);
        return GenerateResponse(result);
    }
    /// <summary>
    /// Create A Action
    /// </summary>
    /// <param name="addActionCommand"></param>
    /// <returns></returns>
    [HttpPost("Action")]
    //[ClaimCheck("action_add")]
    [Produces("application/json", "application/xml", Type = typeof(ActionDto))]
    public async Task<IActionResult> AddAction(AddActionCommand addActionCommand)
    {
        var response = await _mediator.Send(addActionCommand);
        return GenerateResponse(response);
    }
    /// <summary>
    /// Update Exist Action By Id
    /// </summary>
    /// <param name="Id"></param>
    /// <param name="updateActionCommand"></param>
    /// <returns></returns>
    [HttpPut("Action/{Id}")]
    //[ClaimCheck("action_edit")]
    [Produces("application/json", "application/xml", Type = typeof(ActionDto))]
    public async Task<IActionResult> UpdateAction(Guid Id, UpdateActionCommand updateActionCommand)
    {
        updateActionCommand.Id = Id;
        var result = await _mediator.Send(updateActionCommand);
        return GenerateResponse(result);

    }
    /// <summary>
    /// Delete Action By Id
    /// </summary>
    /// <param name="Id"></param>
    /// <returns></returns>
    [HttpDelete("Action/{Id}")]
    //[ClaimCheck("action_delete")]
    public async Task<IActionResult> DeleteAction(Guid Id)
    {
        var deleteActionCommand = new DeleteActionCommand { Id = Id };
        var result = await _mediator.Send(deleteActionCommand);
        return GenerateResponse(result);
    }
}
