﻿using MediatR;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Mvc;
using QualityManagement.MediatR;
using System.Threading.Tasks;

namespace QualityManagement.API.Controllers.Audit;
/// <summary>
/// Controller for AuditReview
/// </summary>
[Route("api/[controller]")]
[ApiController]
[Authorize]
public class AuditReviewController(IMediator _mediator) : BaseController
{
    /// <summary>
    /// Add AuditReview
    /// </summary>
    /// <param name="command"></param>
    /// <returns></returns>
    [HttpPost]
    public async Task<IActionResult> AddAuditReview(AddAuditReviewCommand command)
    {
        var result = await _mediator.Send(command);
        return GenerateResponse(result);
    }
}
