﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text.Json;
using System.Threading.Tasks;
using AuthChecker;
using MediatR;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using QualityManagement.Data.Dto;
using QualityManagement.Data.Resources;
using QualityManagement.MediatR;

namespace QualityManagement.API.Controllers.Audit;

/// <summary>
/// Controller for AuditTemplate
/// </summary>
[Route("api/[controller]")]
[ApiController]
[Authorize]
public class AuditTemplateController(IMediator _mediator) : BaseController
{
    /// <summary>
    /// Add AuditTemplate
    /// </summary>
    /// <param name="command"></param>
    /// <returns></returns>
    [HttpPost]
    [ClaimCheck("ADD_AUDIT_TEMPLATE")]
    public async Task<IActionResult> AddAuditTemplate(AddAuditTemplateCommand command)
    {
        var result = await _mediator.Send(command);
        return GenerateResponse(result);
    }
    /// <summary>
    /// Update AuditTemplate By id 
    /// </summary>
    /// <param name="id"></param>
    /// <param name="command"></param>
    /// <returns></returns>
    [HttpPut("{id}")]
    public async Task<IActionResult> UpdateAuditTemplate(Guid id, UpdateAuditTemplateCommand command)
    {
        command.Id = id;
        var result = await _mediator.Send(command);
        return GenerateResponse(result);

    }
    /// <summary>
    /// Delete AuditTemplate By Id
    /// </summary>
    /// <param name="id"></param>
    /// <returns></returns>
    [HttpDelete("{id}")]
    public async Task<IActionResult> DeleteAuditTemplate(Guid id)
    {
        var result = await _mediator.Send(new DeleteAuditTemplateCommand { Id = id });
        return GenerateResponse(result);
    }


    /// <summary>
    /// Get all AuditTemplate 
    /// </summary>
    /// <returns></returns>
    [HttpGet]
    [Produces("application/json", "application/xml", Type = typeof(List<AuditTemplateDto>))]
    public async Task<IActionResult> GetAllAuditTemplate([FromQuery] AuditTemplateResource auditTemplateResource)
    {
        var query = new GetAllAuditTemplateCommand
        {
            auditTemplateResource = auditTemplateResource
        };
        var result = await _mediator.Send(query);
        var paginationMetadata = new
        {
            totalCount = result.TotalCount,
            pageSize = result.PageSize,
            skip = result.Skip,
            totalPages = result.TotalPages
        };

        Response.Headers.Append("X-Pagination",
            JsonSerializer.Serialize(paginationMetadata));

        return Ok(result);
    }


    /// <summary>
    /// Get AuditTemplate By Id
    /// </summary>
    /// <param name="id"></param>
    /// <returns></returns>
    [HttpGet("{id}")]
    public async Task<IActionResult> GetAuditTemplate(Guid id)
    {
        var result = await _mediator.Send(new GetAuditTemplateCommand() { Id = id });
        return GenerateResponse(result);
    }
}
