﻿using System;
using System.Threading.Tasks;
using AuthChecker;
using MediatR;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Mvc;
using QualityManagement.MediatR;

namespace QualityManagement.API.Controllers.Capa
{
    /// <summary>
    /// Controller for CapaAction
    /// </summary>
    [Route("api/[controller]")]
    [ApiController]
    [Authorize]
    public class CapaActionController(IMediator _mediator) : BaseController
    {
        /// <summary>
        /// Create a CapaAction
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        [HttpPost]
        [ClaimCheck("ADD_CAPA_ACTION")]
        public async Task<IActionResult> CreateCapaAction(AddCapaActionCommand command)
        {
            var result = await _mediator.Send(command);
            return GenerateResponse(result);
        }

        /// <summary>
        /// Delete CapaAction by id
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        [HttpDelete("{id}")]
        [ClaimCheck("DELETE_CAPA_ACTION")]
        public async Task<IActionResult> DeleteCapaAction(Guid id)
        {
            var result = await _mediator.Send(new DeleteCapaActionCommand() { Id = id });
            return GenerateResponse(result);
        }

        /// <summary>
        /// get all CapaAction by CapaRequest id
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        [HttpGet("{id}")]
        public async Task<IActionResult> GetAllCapaAction(Guid id)
        {
            var result = await _mediator.Send(new GetAllCapaActionCommand() { CapaRequestId = id });
            return GenerateResponse(result);
        }

        /// <summary>
        /// Update CapaAction by id
        /// </summary>
        /// <param name="id"></param>
        /// <param name="command"></param>
        /// <returns></returns>
        [HttpPut("{id}")]
        [ClaimCheck("MANAGE_CAPA_ACTION")]
        public async Task<IActionResult> UpdateCapaAction(Guid id, UpdateCapaActionCommand command)
        {
            command.Id = id;
            var result = await _mediator.Send(command);
            return GenerateResponse(result);
        }

        /// <summary>
        /// get all Asign CapaAction 
        /// </summary>
        /// <returns></returns>
        [HttpGet("asigned/actions")]
        [ClaimCheck("VIEW_CAPA_ACTIONS")]
        public async Task<IActionResult> GetAllAsignCapaAction()
        {
            var result = await _mediator.Send(new GetAllAsignCapaActionsCommand());
            return GenerateResponse(result);
        }
    }
}
