﻿using System;
using System.Threading.Tasks;
using AuthChecker;
using MediatR;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Mvc;
using QualityManagement.MediatR;

namespace QualityManagement.API.Controllers.Capa;

/// <summary>
/// Controller For a CapaRootCauseMethodology
/// </summary>
/// <returns></returns>
[Route("api/[controller]")]
[ApiController]
[Authorize]
public class CapaRootCauseMethodologyController(IMediator _mediator) : BaseController
{
    /// <summary>
    /// Creates the CapaRootCauseMethodology
    /// </summary>
    /// <param name="command">The command.</param>
    /// <returns></returns>
    [HttpPost]
    [ClaimCheck("ADD_CAPA_ROOT_CAUSE_METHODOLOGY")]
    public async Task<IActionResult> AddCapaRootCauseMethodology(AddCapaRootCauseMethodologyCommand command)
    {
        var result = await _mediator.Send(command);
        return GenerateResponse(result);
    }

    /// <summary>
    /// Update the CapaRootCauseMethodology
    /// </summary>
    /// <param name="command">The command.</param>
    /// <param name="id"></param>
    /// <returns></returns>
    [HttpPut("{id}")]
    [ClaimCheck("EDIT_CAPA_ROOT_CAUSE_METHODOLOGY")]
    public async Task<IActionResult> UpdateCapaRootCauseMethodology(Guid id, UpdateCapaRootCauseMethodologyCommand command)
    {
        command.Id = id;
        var result = await _mediator.Send(command);
        return GenerateResponse(result);
    }

    /// <summary>
    /// get the CapaRootCauseMethodology by Id
    /// </summary>
    /// <param name="id"></param>
    /// <returns></returns>
    [HttpGet("{id}")]
    public async Task<IActionResult> GetCapaRootCauseMethodology(Guid id)
    {
        var command = new GetCapaRootCauseMethodologyCommand() { Id = id };
        var result = await _mediator.Send(command);
        return GenerateResponse(result);
    }
    /// <summary>
    /// get All the CapaRootCauseMethodology 
    /// </summary>
    /// <returns></returns>
    [HttpGet]
    [ClaimCheck("VIEW_CAPA_ROOT_CAUSE_METHODOLOGY")]
    public async Task<IActionResult> GetAllCapaRootCauseMethodology()
    {
        var command = new GetAllCapaRootCauseMethodologyCommand();
        var result = await _mediator.Send(command);
        return GenerateResponse(result);
    }

    /// <summary>
    ///Delete the CapaRootCauseMethodology by Id
    /// </summary>
    /// <param name="id"></param>
    /// <returns></returns>
    [HttpDelete("{id}")]
    [ClaimCheck("DELETE_CAPA_ROOT_CAUSE_METHODOLOGY")]
    public async Task<IActionResult> DeleteCapaRootCauseMethodology(Guid id)
    {
        var command = new DeleteCapaRootCauseMethodologyCommand() { Id = id };
        var result = await _mediator.Send(command);
        return GenerateResponse(result);
    }
}