﻿using MediatR;
using Microsoft.AspNetCore.Mvc;
using QualityManagement.Data.Dto;
using QualityManagement.MediatR;
using System;
using System.Threading.Tasks;

namespace QualityManagement.API.Controllers.CategoryPermission.User
{
    /// <summary>
    /// Controller For a CategoryUserPermission
    /// </summary>
    /// <returns></returns>
    [Route("api/[controller]")]
    [ApiController]
    public class CategoryUserPermissionController(IMediator _mediator) : ControllerBase
    {
        /// <summary>
        /// Create a Category UserPermission
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        [Produces("application/json", "application/xml", Type = typeof(CategoryUserPermissionDto))]
        public async Task<IActionResult> AddCategoryUserPermission(AddCategoryUserPermissionCommand addCategoryUserPermissionCommand)
        {
            var result = await _mediator.Send(addCategoryUserPermissionCommand);
            return StatusCode(result.StatusCode, result);
        }
        /// <summary>
        /// Delete Document User Permission By Id
        /// </summary>
        /// <param name="Id"></param>
        /// <returns></returns>
        [HttpDelete("{Id}")]
        public async Task<IActionResult> DeleteCategoryUserPermission(Guid Id)
        {
            var deleteCategoryUserPermissionCommand = new DeleteCategoryUserPermissionCommand
            {
                Id = Id
            };
            var result = await _mediator.Send(deleteCategoryUserPermissionCommand);
            return StatusCode(result.StatusCode, result);
        }

        /// <summary>
        /// Gets the reminder by documentId.
        /// </summary>
        /// <param name="categoryId">The identifier.</param>
        /// <returns></returns>
        [HttpGet("{categoryId}/check")]
        [Produces("application/json", "application/xml")]
        public async Task<IActionResult> CheckShareUserByCategoryId(Guid categoryId)
        {
            var command = new CheckShareUserByCategoryCommand()
            {
                CategoryId = categoryId
            };

            var result = await _mediator.Send(command);
            return Ok(result);
        }
    }
}
