﻿using System;
using System.Threading.Tasks;
using AuthChecker;
using MediatR;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Mvc;
using QualityManagement.MediatR;

namespace QualityManagement.API.Controllers
{
    /// <summary>
    /// Controller For ComplainInvetigation
    /// </summary>
    /// <param name="_mediator"></param>
    [Route("api/[controller]")]
    [ApiController]
    [Authorize]
    public class ComplaintInvestigationController(IMediator _mediator) : BaseController
    {

        /// <summary>
        /// Create A ComplaintInvetigation
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        [HttpPost]
        [ClaimCheck("ADD_COMPLAINT_INVESTIGATION")]
        public async Task<IActionResult> CreateComplaintComment(AddComplaintInvestigationCommand command)
        {
            var result = await _mediator.Send(command);
            return GenerateResponse(result);
        }

        /// <summary>
        /// Get All complaint Comment by Complaint id
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        [HttpGet("{id}")]
        [ClaimCheck("VIEW_COMPLAINT_INVESTIGATION")]
        public async Task<IActionResult> GetAllComplaintComent(Guid id)
        {
            var result = await _mediator.Send(new GetAllComplaintInvetigationCommand() { ComplaintId = id });
            return GenerateResponse(result);
        }

        /// <summary>
        ///Delete the DeleteComplaintInvestigation by compla
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        [HttpDelete("{id}")]
        [ClaimCheck("DELETE_COMPLAINT_INVESTIGATION")]
        public async Task<IActionResult> DeleteComplaintInvestigation(Guid id)
        {
            var command = new DeleteComplaintInvestigationCommand() { Id = id };
            var result = await _mediator.Send(command);
            return GenerateResponse(result);
        }

        /// <summary>
        ///Update DeleteComplaintInvestigation by Id
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        [HttpPut("{id}")]
        public async Task<IActionResult> UpdateComplaintInvestigation(Guid id, UpdateComplaintInvestigationCommand command)
        {
            command.Id = id;
            var result = await _mediator.Send(command);
            return GenerateResponse(result);
        }
    }
}
