﻿using System;
using System.Threading.Tasks;
using AuthChecker;
using MediatR;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Mvc;
using QualityManagement.MediatR;

namespace QualityManagement.API.Controllers
{
    /// <summary>
    /// Controller for ComplaintRootCause
    /// </summary>
    [Route("api/[controller]")]
    [ApiController]
    [Authorize]
    public class ComplaintRootCauseController(IMediator _mediator) : BaseController
    {
        /// <summary>
        /// Create A ComplaintRootCause
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        [HttpPost]
        [ClaimCheck("ADD_COMPLAINT_ROOT_CAUSE")]
        public async Task<IActionResult> CreateComplaintRootCause(AddComplaintRootCauseCommand command)
        {
            var result = await _mediator.Send(command);
            return GenerateResponse(result);
        }


        /// <summary>
        /// Get All Complaint Root Cause by Complaint id
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        [HttpGet("{id}")]
        [ClaimCheck("VIEW_COMPLAINT_ROOT_CAUSE")]
        public async Task<IActionResult> GetAllComplaintComent(Guid id)
        {
            var result = await _mediator.Send(new GetAllComplaintRootCauseCommand() { ComplaintId = id });
            return GenerateResponse(result);
        }
    }
}
