﻿using MediatR;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Mvc;
using QualityManagement.Data.Dto;
using QualityManagement.MediatR;
using System;
using System.Collections.Generic;
using System.Threading.Tasks;

namespace QualityManagement.API.Controllers.Course;
/// <summary>
/// Controller For CourseSession
/// </summary>
/// <returns></returns>
[Route("api/[controller]")]
[ApiController]
[Authorize]
public class CourseSessionController(IMediator mediator) : BaseController
{
    /// <summary>
    /// Create A Course session
    /// </summary>
    /// <param name="addCourseSessionCommand"></param>
    /// <returns></returns>
    [HttpPost]
    [Produces("application/json", "application/xml", Type = typeof(CourseSessionDto))]
    public async Task<IActionResult> CreateCourseSession(AddCourseSessionCommand addCourseSessionCommand)
    {
        var result = await mediator.Send(addCourseSessionCommand);
        return GenerateResponse(result);
    }

    /// <summary>
    /// Update Course session.
    /// </summary>
    /// <param name="id"></param>
    /// <param name="updateCourseSessionCommand"></param>
    /// <returns></returns>

    [HttpPut("{id}")]
    [Produces("application/json", "application/xml", Type = typeof(CourseSessionDto))]
    public async Task<IActionResult> UpdateCourseSession(Guid id, UpdateCourseSessionCommand updateCourseSessionCommand)
    {
        updateCourseSessionCommand.Id = id;
        var result = await mediator.Send(updateCourseSessionCommand);
        return GenerateResponse(result);
    }

    /// <summary>
    /// Get Course session By id.
    /// </summary>
    /// <param name="id"></param>
    /// <returns></returns>

    [HttpGet("{id}")]
    [Produces("application/json", "application/xml", Type = typeof(CourseSessionDto))]
    public async Task<IActionResult> GetCourseSession(Guid id)
    {
        var getCourseSessionCommand = new GetCourseSessionCommand { Id = id };
        var result = await mediator.Send(getCourseSessionCommand);
        return GenerateResponse(result);
    }

    /// <summary>
    /// Get All Course sessions by Course Id
    /// </summary>
    /// <param name="id"></param>
    /// <returns></returns>
    [HttpGet("{id}/sessions")]
    [Produces("application/json", "application/xml", Type = typeof(List<CourseSessionDto>))]
    public async Task<IActionResult> GetCourseSessionByCourseId(Guid id)
    {
        var command = new GetCourseSessionByCourseCommand { CourseId = id };
        var result = await mediator.Send(command);
        return Ok(result);
    }


    /// <summary>
    /// Delete Course session by Id
    /// </summary>
    /// <param name="Id"></param>
    /// <returns></returns>
    [HttpDelete("{Id}")]
    public async Task<IActionResult> DeleteCourseSession(Guid Id)
    {
        var deleteCourseSessionCommand = new DeleteCourseSessionCommand { Id = Id };
        var result = await mediator.Send(deleteCourseSessionCommand);
        return GenerateResponse(result);
    }
}
