﻿using MediatR;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Mvc;
using QualityManagement.Data.Dto;
using QualityManagement.MediatR;
using System;
using System.Threading.Tasks;

namespace QualityManagement.API.Controllers.Course;
/// <summary>
///Controller For CourseSessionQuiz
/// </summary>
/// <returns></returns>
[Route("api/[controller]")]
[ApiController]
[Authorize]
public class CourseSessionQuizController(IMediator mediator) : BaseController
{
    /// <summary>
    /// Get Course session Quiz by session id.
    /// </summary>
    /// <param name="id"></param>
    /// <returns></returns>

    [HttpGet("{id}")]
    [Produces("application/json", "application/xml", Type = typeof(CourseSessionQuizDto))]
    public async Task<IActionResult> GetCourseSessionQuiz(Guid id)
    {
        GetCourseSessionQuizCommand getCourseSessionQuizCommand = new GetCourseSessionQuizCommand { CourseSessionId = id };
        var result = await mediator.Send(getCourseSessionQuizCommand);
        return GenerateResponse(result);
    }
    /// <summary>
    /// Save Course Session Quiz
    /// </summary>
    /// <param name="id"></param>
    /// <param name="saveCourseSessionQuizCommand"></param>
    /// <returns></returns>
    [HttpPut("{id}")]
    [Produces("application/json", "application/xml", Type = typeof(bool))]
    public async Task<IActionResult> SaveCourseSessionQuiz(Guid id, SaveCourseSessionQuizCommand saveCourseSessionQuizCommand)
    {
        saveCourseSessionQuizCommand.CourseSessionId = id;
        var result = await mediator.Send(saveCourseSessionQuizCommand);
        return GenerateResponse(result);
    }
}
