﻿using MediatR;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Mvc;
using QualityManagement.Data.Dto;
using QualityManagement.MediatR;
using System;
using System.Threading.Tasks;

namespace QualityManagement.API.Controllers.Course;
/// <summary>
/// Controller For Create
/// </summary>
/// <returns></returns>
[Route("api/[controller]")]
[ApiController]
[Authorize]
public class CourseSessionQuizQuestionController(IMediator mediator) : BaseController
{
    /// <summary>
    /// Create A Course session quiz question
    /// </summary>
    /// <param name="createQuizQuestionCommand"></param>
    /// <returns></returns>
    [HttpPost]
    [Produces("application/json", "application/xml", Type = typeof(QuizQuestionDto))]
    public async Task<IActionResult> CreateQuizQuestion(CreateQuizQuestionCommand createQuizQuestionCommand)
    {
        var result = await mediator.Send(createQuizQuestionCommand);
        return GenerateResponse(result);
    }

    /// <summary>
    /// Update Course session quiz question.
    /// </summary>
    /// <param name="id"></param>
    /// <param name="updateQuizeQuestionCommand"></param>
    /// <returns></returns>

    [HttpPut("{id}")]
    [Produces("application/json", "application/xml", Type = typeof(QuizQuestionDto))]
    public async Task<IActionResult> UpdateQuizeQuestion(Guid id, UpdateQuizeQuestionCommand updateQuizeQuestionCommand)
    {
        updateQuizeQuestionCommand.Id = id;
        var result = await mediator.Send(updateQuizeQuestionCommand);
        return GenerateResponse(result);
    }

    /// <summary>
    /// Delete Course session question by Id
    /// </summary>
    /// <param name="Id"></param>
    /// <returns></returns>
    [HttpDelete("{Id}")]
    public async Task<IActionResult> DeleteQuizQuestion(Guid Id)
    {
        var deleteQuizQuestionCommand = new DeleteQuizQuestionCommand { Id = Id };
        var result = await mediator.Send(deleteQuizQuestionCommand);
        return GenerateResponse(result);
    }
}
