﻿using System;
using System.Collections.Generic;
using System.Threading.Tasks;
using AuthChecker;
using MediatR;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Mvc;
using QualityManagement.Data.Dto;
using QualityManagement.MediatR;

namespace QualityManagement.API.Controllers.DocumentComment;

/// <summary>
/// Document
/// </summary>
[Route("api/[controller]")]
[ApiController]
[Authorize]
public class DocumentCommentController(IMediator _mediator) : BaseController
{
    /// <summary>
    /// Gets the Inquiry Notes .
    /// </summary>
    /// <returns></returns>
    [HttpGet("{id}")]
    [Produces("application/json", "application/xml", Type = typeof(List<DocumentCommentDto>))]
    public async Task<IActionResult> GetDocumentComment(Guid id)
    {
        var query = new GetDocumentCommentByIdQuery { DocumentId = id };
        var result = await _mediator.Send(query);
        return Ok(result);
    }
    /// <summary>
    /// Inserts the Document Comment
    /// </summary>
    /// <param name="addDocumentCommentCommand">The add Document Comment command.</param>
    /// <returns></returns>
    [HttpPost]
    [Produces("application/json", "application/xml", Type = typeof(DocumentCommentDto))]
    [ClaimCheck("ALL_ADD_COMMENT", "ASSIGNED_ADD_COMMENT")]
    public async Task<IActionResult> AddDocumentComment([FromBody] AddDocumentCommentCommand addDocumentCommentCommand)
    {
        var result = await _mediator.Send(addDocumentCommentCommand);
        return Ok(result);
    }

    /// <summary>
    /// Deletes the Document Comment By Id.
    /// </summary>
    /// <param name="id">The identifier.</param>
    /// <returns></returns>
    [HttpDelete("{id}")]
    [ClaimCheck("ALL_DELETE_COMMENT", "ASSIGNED_DELETE_COMMENT")]
    public async Task<IActionResult> DeleteDocumentComment(Guid id)
    {
        var command = new DeleteDocumentCommentCommand() { Id = id };
        var result = await _mediator.Send(command);
        return Ok(result);
    }
}
