﻿using MediatR;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using QualityManagement.Data.Resources;
using QualityManagement.MediatR;
using QualityManagement.Repository;
using System.Text.Json;
using System.Threading.Tasks;

namespace QualityManagement.API.Controllers.DocumentLibrary
{
    /// <summary>
    /// DocumentLibrary
    /// </summary>
    [Route("api")]
    [ApiController]
    [Authorize]
    public class DocumentLibraryController(IMediator _mediator) : BaseController
    {
        /// <summary>
        /// Get Document list which user allow to view
        /// </summary>
        /// <param name="documentResource"></param>
        /// <returns></returns>
        [HttpGet("DocumentLibraries")]
        [Produces("application/json", "application/xml", Type = typeof(DocumentList))]

        public async Task<IActionResult> GetDocumentLibraries([FromQuery] DocumentResource documentResource)
        {
            var getDocumentLibraryQuery = new GetDocumentLibraryQuery
            {
                DocumentResource = documentResource
            };

            if (string.IsNullOrWhiteSpace(Email))
            {
                return Unauthorized();
            }

            getDocumentLibraryQuery.Email = Email;
            var result = await _mediator.Send(getDocumentLibraryQuery);
            var paginationMetadata = new
            {
                totalCount = result.TotalCount,
                pageSize = result.PageSize,
                skip = result.Skip,
                totalPages = result.TotalPages
            };

            Response.Headers.Append("X-Pagination",
                JsonSerializer.Serialize(paginationMetadata));

            return Ok(result);
        }
    }
}
