﻿using System.Linq;
using System.Text.Json;
using System.Threading.Tasks;
using AuthChecker;
using MediatR;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using QualityManagement.Data.Resources;
using QualityManagement.MediatR;
using QualityManagement.Repository;

namespace QualityManagement.API.Controllers.LoginAudit;

/// <summary>
/// Controller For LoginAudit
/// </summary>
/// <returns></returns>
[Route("api/[controller]")]
[ApiController]
[Authorize]
public class LoginAuditController(IMediator _mediator) : ControllerBase
{
    /// <summary>
    /// Get All Login Audit detail
    /// </summary>
    /// <param name="loginAuditResource"></param>
    /// <returns></returns>
    [HttpGet]
    [Produces("application/json", "application/xml", Type = typeof(LoginAuditList))]
    [ClaimCheck("VIEW_LOGIN_AUDIT_LOGS")]
    public async Task<IActionResult> GetLoginAudit([FromQuery] LoginAuditResource loginAuditResource)
    {
        var getAllLoginAuditQuery = new GetAllLoginAuditQuery
        {
            LoginAuditResource = loginAuditResource
        };
        var result = await _mediator.Send(getAllLoginAuditQuery);

        var paginationMetadata = new
        {
            totalCount = result.TotalCount,
            pageSize = result.PageSize,
            skip = result.Skip,
            totalPages = result.TotalPages
        };
        Response.Headers.Append("X-Pagination",
            JsonSerializer.Serialize(paginationMetadata));
        return Ok(result);
    }
}
