﻿using MediatR;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Mvc;
using QualityManagement.MediatR;
using System.Threading.Tasks;

namespace QualityManagement.API.Controllers.Migration
{
    /// <summary>
    /// Controller For DbMigration
    /// </summary>
    /// <returns></returns>
    [Route("api/[controller]")]
    [ApiController]
    [AllowAnonymous]
    public class DbMigrationController(IMediator _mediator) : ControllerBase
    {
        /// <summary>
        /// MigrateDb
        /// </summary>
        /// <returns></returns>
        [HttpGet]
        public async Task<IActionResult> MigrateDb()
        {
            var getCategoryQuery = new DbMigrationCommand();
            await _mediator.Send(getCategoryQuery);
            return Ok("Database Updated Successfully.");
        }
    }
}
