﻿using MediatR;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using QualityManagement.Data.Resources;
using QualityManagement.MediatR;
using QualityManagement.Repository;
using System.Linq;
using System.Text.Json;
using System.Threading.Tasks;

namespace QualityManagement.API.Controllers.RecentDocument;

/// <summary>
/// RecentDocument
/// </summary>
[Route("api/[controller]")]
[ApiController]
[Authorize]
public class RecentDocumentController(IMediator _mediator) : ControllerBase
{
    /// <summary>
    /// Get All Recent Documents
    /// </summary>
    /// <param name="documentResource"></param>
    /// <returns></returns>
    [HttpGet]
    [Produces("application/json", "application/xml", Type = typeof(RecentDocumentList))]
    public async Task<IActionResult> GetRecentDocuments([FromQuery] DocumentResource documentResource)
    {
        var getAllRecentDocumentQuery = new GetAllRecentDocumentQuery
        {
            DocumentResource = documentResource
        };
        var result = await _mediator.Send(getAllRecentDocumentQuery);

        var paginationMetadata = new
        {
            totalCount = result.TotalCount,
            pageSize = result.PageSize,
            skip = result.Skip,
            totalPages = result.TotalPages
        };
        Response.Headers.Append("X-Pagination",
            JsonSerializer.Serialize(paginationMetadata));
        return Ok(result);
    }
}
