﻿using System;
using System.Threading.Tasks;
using AuthChecker;
using MediatR;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Mvc;
using QualityManagement.Data.Dto;
using QualityManagement.MediatR;

namespace QualityManagement.API.Controllers;
/// <summary>
/// Controller for SupplierContact
/// </summary>
/// <returns></returns>
[Route("api/[controller]")]
[ApiController]
[Authorize]

public class SupplierContactController(IMediator mediator) : BaseController
{
    /// <summary>
    /// Create A SupplierContact
    /// </summary>
    /// <param name="addSupplierContactCommand"></param>
    /// <returns></returns>
    [HttpPost]
    [Produces("application/json", "application/xml", Type = typeof(SupplierContactDto))]
    [ClaimCheck("ADD_SUPPLIER_CONTACT")]
    public async Task<IActionResult> CreateSupplierContact(AddSupplierContactCommand addSupplierContactCommand)
    {
        var result = await mediator.Send(addSupplierContactCommand);
        return GenerateResponse(result);
    }

    /// <summary>
    /// Get SupplierContact By id.
    /// </summary>
    /// <param name="id"></param>
    /// <returns></returns>

    [HttpGet("{id}")]
    [Produces("application/json", "application/xml", Type = typeof(SupplierContactDto))]
    [ClaimCheck("VIEW_SUPPLIER_CONTACT")]
    public async Task<IActionResult> GetSupplierContact(Guid id)
    {
        var getSupplierContactCommand = new GetSupplierContactCommand { Id = id };
        var result = await mediator.Send(getSupplierContactCommand);
        return GenerateResponse(result);
    }

    /// <summary>
    /// Delete SupplierContact By Id
    /// </summary>
    /// <param name="Id"></param>
    /// <returns></returns>
    [HttpDelete("{Id}")]
    [ClaimCheck("DELETE_SUPPLIER_CONTACT")]
    public async Task<IActionResult> DeleteSupplierContact(Guid Id)
    {
        var deleteSupplierContactCommand = new DeleteSupplierContactCommand { Id = Id };
        var result = await mediator.Send(deleteSupplierContactCommand);
        return GenerateResponse(result);
    }
}