﻿using System;
using System.Threading.Tasks;
using AuthChecker;
using MediatR;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Mvc;
using QualityManagement.Data.Dto;
using QualityManagement.MediatR;

namespace QualityManagement.API.Controllers;
/// <summary>
/// Controller for SupplierPerformance
/// </summary>
/// <returns></returns>
[Route("api/[controller]")]
[ApiController]
[Authorize]
public class SupplierPerformanceController(IMediator mediator) : BaseController
{
    /// <summary>
    /// Create A SupplierPerformance
    /// </summary>
    /// <param name="addSupplierPerformanceCommand"></param>
    /// <returns></returns>
    [HttpPost]
    [Produces("application/json", "application/xml", Type = typeof(SupplierPerformanceDto))]
    [ClaimCheck("ADD_SUPPLIER_PERFORMANCE")]
    public async Task<IActionResult> CreateSupplierPerformance(AddSupplierPerformanceCommand addSupplierPerformanceCommand)
    {
        var result = await mediator.Send(addSupplierPerformanceCommand);
        return GenerateResponse(result);
    }

    /// <summary>
    /// Get SupplierPerformance By id.
    /// </summary>
    /// <param name="id"></param>
    /// <returns></returns>

    [HttpGet("{id}")]
    [Produces("application/json", "application/xml", Type = typeof(SupplierPerformanceDto))]
    [ClaimCheck("VIEW_SUPPLIER_PERFORMANCE")]
    public async Task<IActionResult> GetSupplierPerformance(Guid id)
    {
        var getSupplierPerformanceCommand = new GetSupplierPerformanceCommand { Id = id };
        var result = await mediator.Send(getSupplierPerformanceCommand);
        return GenerateResponse(result);
    }
}
