﻿using MediatR;
using Microsoft.AspNetCore.Mvc;
using QualityManagement.MediatR;
using System.Threading.Tasks;

namespace QualityManagement.API.Controllers.TableSettings
{
    /// <summary>
    /// Controller For TableSetting
    /// </summary>
    /// <returns></returns>
    [Route("api/[controller]")]
    [ApiController]
    public class TableSettingsController(IMediator _mediator) : ControllerBase
    {
        /// <summary>
        /// Get Table Settings
        /// </summary>
        /// <param name="screenName"></param>
        /// <returns></returns>
        [HttpGet("{screenName}")]
        public async Task<IActionResult> GetTableSettings(string screenName)
        {
            var query = new GetTableSettingsQuery { ScreenName = screenName };
            var result = await _mediator.Send(query);
            return Ok(result);
        }

        /// <summary>
        ///  Save Table Setting
        /// </summary>
        /// <param name="addOrUpdateTableSettingCommand">The command.</param>
        /// <returns></returns>
        [HttpPost]
        public async Task<IActionResult> SaveTableSettings(AddOrUpdateTableSettingCommand addOrUpdateTableSettingCommand)
        {

            var result = await _mediator.Send(addOrUpdateTableSettingCommand);
            if (result.StatusCode != 200)
            {
                return StatusCode(result.StatusCode, result);
            }
            return StatusCode(result.StatusCode, result.Data);
        }
    }
}
