﻿using System.Linq;
using AutoMapper;
using QualityManagement.Data.Dto;
using QualityManagement.Data.Entities;
using QualityManagement.MediatR;

namespace QualityManagement.API.Helpers.Mapping;

/// <summary>  
/// AuditProfile is a mapping profile for AutoMapper that defines the mappings between  
/// </summary>  
public class AuditProfile : Profile
{
    /// <summary>  
    /// Audit related entities and DTOs.  
    /// </summary>  
    public AuditProfile()
    {
        CreateMap<AddAuditCommand, Audit>();
        CreateMap<Audit, AuditDto>()
            .ForMember(dest => dest.DepartmentName, opt => opt.MapFrom(src => src.AuditTemplate.Department != null ? src.AuditTemplate.Department.Name.ToString() : null))
            .ForMember(dest => dest.AuditorName, opt => opt.MapFrom(src => src.Auditor == null ? "" : src.Auditor.FirstName + " " + src.Auditor.LastName));
        CreateMap<AuditResponseAttachment, AuditResponseAttachmentDto>().ReverseMap();
        CreateMap<Audit, AuditReportDetailsDto>()
            .ForMember(dest => dest.DepartmentName, opt => opt.MapFrom(src => src.AuditTemplate.Department != null ? src.AuditTemplate.Department.Name.ToString() : null))
            .ForMember(dest => dest.AuditorName, opt => opt.MapFrom(src => src.Auditor == null ? "" : src.Auditor.FirstName + " " + src.Auditor.LastName))
           .ForPath(dest => dest.AuditTemplate.Questions,
               opt => opt.MapFrom(src => src.AuditTemplate.Questions.OrderByDescending(q => q.CreatedDate)))
           .ForMember(dest => dest.NonConformances,
                opt => opt.MapFrom(src => src.NonConformances
                    .OrderByDescending(nc => nc.CreatedDate)))
            .ForMember(dest => dest.CapaRequests,
                opt => opt.MapFrom(src => src.CapaRequests
                    .OrderByDescending(c => c.CreatedDate)))
            .ForMember(dest => dest.AuditReviewers,
                opt => opt.MapFrom(src => src.AuditReviewers
                    .OrderByDescending(c => c.ReviewedOn)));
        CreateMap<Audit, AuditResponseLog>()
           .ForMember(dest => dest.AuditId, opt => opt.MapFrom(src => src.Id));
    }
}
