﻿using AutoMapper;
using QualityManagement.Data.Dto;
using QualityManagement.Data.Entities;
using QualityManagement.MediatR;

namespace QualityManagement.API.Helpers.Mapping;

public class AuditReviewerProfile : Profile
{
    public AuditReviewerProfile()
    {
        CreateMap<AddAuditReviewerCommand, AuditReviewer>();
        CreateMap<AuditReviewer, AuditReviewerDto>()
             .ForMember(dest => dest.ReviewerName, opt => opt.MapFrom(src => src.Reviewer == null ? "" : src.Reviewer.FirstName + " " + src.Reviewer.LastName))
             .ForMember(dest => dest.SubmitterName, opt => opt.MapFrom(src => src.Submitter == null ? "" : src.Submitter.FirstName + " " + src.Submitter.LastName));
        CreateMap<AuditReviewerDto, AuditReviewer>();
    }
}
