﻿using AutoMapper;
using QualityManagement.Data.Dto;
using QualityManagement.Data.Entities;
using QualityManagement.MediatR;

namespace QualityManagement.API.Helpers.Mapping;

/// <summary>
///  CapaRequestProfile is a mapping profile for AutoMapper that defines the mappings between
/// </summary>
public class CapaRequestProfile : Profile
{
    /// <summary>
    ///  CapaRequest related entities and DTOs.
    /// </summary>
    public CapaRequestProfile()
    {
        CreateMap<AddCapaRequestCommand, CapaRequest>();
        CreateMap<UpdateCapaRequestCommand, CapaRequest>();
        CreateMap<CapaRequest, CapaRequestDto>()
            .ForMember(dest => dest.AuditName, opt => opt.MapFrom(src => src.Audit.Title))
            .ForMember(dest => dest.RaisedByName, opt => opt.MapFrom(src => src.RaisedBY == null ? "" : src.RaisedBY.FirstName + " " + src.RaisedBY.LastName));
        CreateMap<CapaRequest, CapaRequestLog>()
            .ForMember(dest => dest.CapaRequestId, opt => opt.MapFrom(src => src.Id));
    }
}
