﻿using AutoMapper;
using QualityManagement.Data.Dto;
using QualityManagement.Data.Entities;
using QualityManagement.MediatR;

namespace QualityManagement.API.Helpers.Mapping
{
    /// <summary>
    /// CapaReviewProfile is a mapping profile for AutoMapper that defines the mappings between
    /// </summary>
    public class CapaReviewProfile : Profile
    {
        /// <summary>
        /// CapaReview related entities and DTOs
        /// </summary>
        public CapaReviewProfile()
        {
            CreateMap<AddCapaReviewCommand, CapaReview>();
            CreateMap<UpdateCapaReviewCommand, CapaReview>();
            CreateMap<CapaReview, CapaReviewDto>()
                 .ForMember(dest => dest.reviewByName, opt => opt.MapFrom(src => src.ReviewedBy == null ? "" : src.ReviewedBy.FirstName + " " + src.ReviewedBy.LastName));

        }
    }
}
