﻿using AutoMapper;
using QualityManagement.Data.Dto;
using QualityManagement.Data.Entities;
using QualityManagement.MediatR;

namespace QualityManagement.API.Helpers.Mapping;

/// <summary>
/// client profile is a mapping profile for AutoMapper that defines the mappings between
/// </summary>
public class ClientProfile : Profile
{
    /// <summary>
    /// client related entities and DTOs.
    /// </summary>
    public ClientProfile()
    {
        CreateMap<Client, ClientDto>().ReverseMap();
        CreateMap<AddClientCommand, Client>().ReverseMap();
        CreateMap<UpdateClientCommand, Client>().ReverseMap();
    }
}