﻿using AutoMapper;
using QualityManagement.Data.Dto;
using QualityManagement.Data.Entities;
using QualityManagement.MediatR;

namespace QualityManagement.API.Helpers.Mapping
{
    public class ComplaintActionProfile:Profile
    {
        public ComplaintActionProfile()
        {
            CreateMap<AddComplaintActionCommand, ComplaintAction>();
            CreateMap<UpdateComplaintActionCommand, ComplaintAction>();
            CreateMap<ComplaintAction, ComplaintActionDto>()
                   .ForMember(dest => dest.ResponsibleName, opt => opt
                .MapFrom(src => src.Responsible != null ? src.Responsible.FirstName + " " + src.Responsible.LastName : " "));
        }
    }
}
