﻿using AutoMapper;
using QualityManagement.Data.Dto;
using QualityManagement.Data.Entities;
using QualityManagement.MediatR;

namespace QualityManagement.API.Helpers.Mapping
{
    public class ComplaintInvestigationprofile:Profile
    {
        public ComplaintInvestigationprofile()
        {
            CreateMap<AddComplaintInvestigationCommand, ComplaintInvestigation>();
            CreateMap<UpdateComplaintInvestigationCommand, ComplaintInvestigation>();
            CreateMap<ComplaintInvestigation, ComplaintInvestigationDto>()
                   .ForMember(dest => dest.InvestigatorName, opt => opt.MapFrom(src => src.Investigator != null ? src.Investigator.FirstName + " " + src.Investigator.LastName : " "));
        }
    }
}
