﻿using AutoMapper;
using QualityManagement.Data.Dto;
using QualityManagement.Data.Entities;
using QualityManagement.MediatR;
using System;

namespace QualityManagement.API.Helpers.Mapping
{
    public class ComplaintProfile:Profile
    {
        public ComplaintProfile()
        {
            CreateMap<AddComplaintCommand,Complaint>();
            CreateMap<Complaint, ComplaintDto>()
                .ForMember(c=>c.AsignToName,opt=>opt.MapFrom(src=>src.AssignedTo != null ? src.AssignedTo.FirstName + " " + src.AssignedTo.LastName : " "))
                .ForMember(c=>c.ComplaintTypeName,opt=>opt.MapFrom(src=>src.ComplaintType != null ? src.ComplaintType.Name  : " "));
            CreateMap<UpdateComplaintCommand, Complaint>();
            CreateMap<Complaint, ComplaintLog>()
                .ForMember(c=>c.ComplaintId,opt=>opt.MapFrom(src => src.Id));
        }
    }
}
