﻿using AutoMapper;
using QualityManagement.Data.Dto;
using QualityManagement.Data.Entities;
using QualityManagement.MediatR;

namespace QualityManagement.API.Helpers.Mapping
{
    public class ComplaintRootCauseProfile:Profile
    {
        public ComplaintRootCauseProfile()
        {
            CreateMap<AddComplaintRootCauseCommand, ComplaintRootCause>();
            CreateMap<ComplaintRootCause,ComplaintRootCauseDto>()
                   .ForMember(dest => dest.CreatedByName, opt => opt
                   .MapFrom(src => src.CreatedBy != null ? src.CreatedBy.FirstName + " " + src.CreatedBy.LastName : " "));
        }
    }
}
