﻿using AutoMapper;
using QualityManagement.Data;
using QualityManagement.Data.Dto;
using QualityManagement.MediatR;

namespace QualityManagement.API.Helpers.Mapping;
/// <summary>
/// CourseSessionMediaProfile is a mapping profile for AutoMapper that defines the mappings between
/// </summary>
public class CourseSessionMediaProfile : Profile
{
    /// <summary>
    /// course session media related entities and DTOs.
    /// </summary>
    public CourseSessionMediaProfile()
    {
        CreateMap<CourseSessionMedia, CourseSessionMediaDto>().ReverseMap();
        CreateMap<CourseSessionMediaChunk, CourseSessionMediaChunkDto>().ReverseMap();
        CreateMap<AddSessionMediaChunkCommand, CourseSessionMedia>();
        CreateMap<AddSessionMediaCommand, CourseSessionMedia>();
    }
}