﻿using AutoMapper;
using QualityManagement.Data;
using QualityManagement.Data.Dto;
using QualityManagement.MediatR;

namespace QualityManagement.API.Helpers.Mapping;

/// <summary>
/// DepartmentProfile is a mapping profile for AutoMapper that defines the mappings between
/// </summary>
public class DepartmentProfile : Profile
{
    /// <summary>
    /// Department related entities and DTOs.
    /// </summary>
    public DepartmentProfile()
    {
        CreateMap<AddDepartmentCommand, Department>();
        CreateMap<DeleteDepartmentCommand, Department>();
        CreateMap<UpdateDepartmentCommand, Department>();
        CreateMap<DepartmentDto, Department>().ReverseMap();
    }
}
