﻿using AutoMapper;
using QualityManagement.Data;
using QualityManagement.Data.Dto;
using QualityManagement.MediatR;

namespace QualityManagement.API.Helpers.Mapping;
/// <summary>
/// DocumentMetaTagProfile is a mapping profile for AutoMapper that defines the mappings between
/// </summary>
public class DocumentMetaTagProfile : Profile
{
    /// <summary>
    /// DocumentMetaTag related entities and DTOs.
    /// </summary>
    public DocumentMetaTagProfile()
    {
        CreateMap<DocumentMetaTag, DocumentMetaTagDto>().ReverseMap();
        CreateMap<AddDocumentMetaTagCommand, DocumentMetaTag>().ReverseMap();
        CreateMap<UpdateDocumentMetaTagCommand, DocumentMetaTag>().ReverseMap();
    }
}
