﻿using AutoMapper;
using QualityManagement.Data;
using QualityManagement.Data.Dto;
using QualityManagement.MediatR;

namespace QualityManagement.API.Helpers.Mapping;

/// <summary>
/// DocumentSignatureProfile is a mapping profile for AutoMapper that defines the mappings between
/// </summary>
public class DocumentSignatureProfile : Profile
{
    /// <summary>
    /// DocumentSignature related entities and DTOs.
    /// </summary>
    public DocumentSignatureProfile()
    {
        CreateMap<DocumentSignature, DocumentSignatureDto>().ReverseMap();
        CreateMap<AddDocumentSignatureCommand, DocumentSignature>();
        CreateMap<AddDocumentSignatureWithPositionCommand, DocumentSignature>();

    }
}
