﻿using AutoMapper;
using QualityManagement.Data.Dto;
using QualityManagement.Data.Entities;
using QualityManagement.MediatR;

namespace QualityManagement.API.Helpers.Mapping;

/// <summary>
/// DocumentStatusProfile is a mapping profile for AutoMapper that defines the mappings between
/// </summary>
public class DocumentStatusProfile : Profile
{
    /// <summary>
    /// DocumentStatus related entities and DTOs.
    /// </summary>
    public DocumentStatusProfile()
    {
        CreateMap<DocumentStatus, DocumentStatusDto>().ReverseMap();
        CreateMap<AddDocumentStatusCommand, DocumentStatus>();
        CreateMap<UpdateDocumentStatusCommand, DocumentStatus>();
    }
}
