﻿using AutoMapper;
using QualityManagement.Data;
using QualityManagement.Data.Dto;
using QualityManagement.MediatR;
namespace QualityManagement.API.Helpers.Mapping;

/// <summary>
/// EmailSMTPSettingProfile is a mapping profile for AutoMapper that defines the mappings between
/// </summary>
public class EmailSMTPSettingProfile : Profile
{
    /// <summary>
    /// EmailSMTPSetting related entities and DTOs.
    /// </summary>
    public EmailSMTPSettingProfile()
    {
        CreateMap<AddEmailSMTPSettingCommand, EmailSMTPSetting>();

        CreateMap<EmailSMTPSettingDto, EmailSMTPSetting>().ReverseMap();

        CreateMap<SendEmailCommand, SendEmail>();
        CreateMap<UpdateEmailSMTPSettingCommand, EmailSMTPSetting>();
    }
}
