﻿using AutoMapper;
using QualityManagement.Data;
using QualityManagement.Data.Dto;
using QualityManagement.MediatR;

namespace QualityManagement.API.Helpers;
/// <summary>
/// EmailTemplateProfile is a mapping profile for AutoMapper that defines the mappings between
/// </summary>
public class EmailTemplateProfile : Profile
{
    /// <summary>
    /// EmailTemplate related entities and DTOs.
    /// </summary>
    public EmailTemplateProfile()
    {
        CreateMap<EmailTemplateDto, EmailTemplate>().ReverseMap();
        CreateMap<AddEmailTemplateCommand, EmailTemplate>();
        CreateMap<UpdateEmailTemplateCommand, EmailTemplate>().ReverseMap();
    }
}
