﻿using AutoMapper;
using QualityManagement.Data;
using QualityManagement.Data.Dto;

namespace QualityManagement.API.Helpers.Mapping
{
    public class EmployeeCourceProfile:Profile
    {
        public EmployeeCourceProfile()
        {
            CreateMap<EmployeeCourse, EmployeeCourseDto>()
                 .ForMember(dest => dest.AssignedDate, opt => opt.MapFrom(src => src.CreatedDate));
        }
    }
}
