﻿using AutoMapper;
using QualityManagement.Data;
using QualityManagement.Data.Dto;
using QualityManagement.MediatR;

namespace QualityManagement.API.Helpers.Mapping;
/// <summary>
/// EmployeeCourseSessionQuizAnswerProfile is a mapping profile for AutoMapper that defines the mappings between
/// </summary>
public class EmployeeCourseSessionQuizAnswerProfile : Profile
{
    /// <summary>
    /// EmployeeCourseSessionQuizAnswerProfile related entities and DTOs.
    /// </summary>
    public EmployeeCourseSessionQuizAnswerProfile()
    {
        CreateMap<EmployeeCourseSessionQuizAnswer, EmployeeCourseSessionQuizAnswerDto>().ReverseMap();
        CreateMap<CreateEmployeeCourseSessionQuizAnswerCommand, EmployeeCourseSessionQuizAnswer>();
        CreateMap<EmployeeCourseSessionQuiz, EmployeeCourseSessionQuizDto>().ReverseMap();
        CreateMap<EmployeeCourseSessionDto, EmployeeCourseSession>().ReverseMap();
    }
}
