﻿using AutoMapper;
using QualityManagement.Data;
using QualityManagement.Data.Dto;
using QualityManagement.MediatR;

namespace QualityManagement.API.Helpers.Mapping;

/// <summary>
/// FileRequestDocumentProfile is a mapping profile for AutoMapper that defines the mappings between
/// </summary>
public class FileRequestDocumentProfile : Profile
{
    /// <summary>
    /// FileRequestDocumentProfile related entities and DTOs.
    /// </summary>
    public FileRequestDocumentProfile()
    {
        CreateMap<FileRequestDocument, FileRequestDocumentDto>().ReverseMap();
        CreateMap<AddFileRequestDocumentCommand, FileRequestDocument>();
    }
}
