﻿using AutoMapper;

namespace QualityManagement.API.Helpers.Mapping;
/// <summary>
/// MapperConfig class for configuring AutoMapper profiles.
/// </summary>
public static class MapperConfig
{
    /// <summary>
    /// Method to get the AutoMapper configuration.
    /// </summary>
    /// <returns></returns>
    public static IMapper GetMapperConfigs()
    {
        var mappingConfig = new MapperConfiguration(mc =>
        {
            mc.AddProfile(new RoleProfile());
            mc.AddProfile(new UserProfile());
            mc.AddProfile(new CategoryProfile());
            mc.AddProfile(new DocumentProfile());
            mc.AddProfile(new DocumentPermission());
            mc.AddProfile(new DocumentAuditTrailProfile());
            mc.AddProfile(new UserNotificationProfile());
            mc.AddProfile(new ReminderProfile());
            mc.AddProfile(new EmailSMTPSettingProfile());
            mc.AddProfile(new StorageSettingProfile());
            mc.AddProfile(new DocumentStatusProfile());
            mc.AddProfile(new CompanyProfileProfile());
            mc.AddProfile(new PageHelperProfile());
            mc.AddProfile(new NLogProfile());
            mc.AddProfile(new WorkflowTransitionProfile());
            mc.AddProfile(new WorkflowInstanceProfile());
            mc.AddProfile(new WorkflowProfile());
            mc.AddProfile(new WorkflowStepProfile());
            mc.AddProfile(new WorkflowStepInstanceProfile());
            //mc.AddProfile(new WorkflowStepRoleProfile());
            //mc.AddProfile(new WorkflowStepUserProfile());
            mc.AddProfile(new AllowFileExtensionProfile());
            mc.AddProfile(new DocumentSignatureProfile());
            mc.AddProfile(new FileRequestProfile());
            mc.AddProfile(new FileRequestDocumentProfile());
            mc.AddProfile(new ClientProfile());
            mc.AddProfile(new MatTableSettingProfile());
            mc.AddProfile(new CategoryPermission());
            mc.AddProfile(new DocumentMetaTagProfile());
            mc.AddProfile(new UserOpenaiMsgProfile());

            //QualityManagement
            mc.AddProfile(new ActionProfile());
            mc.AddProfile(new PageProfile());
            mc.AddProfile(new EmailTemplateProfile());
            mc.AddProfile(new EmailProfile());
            mc.AddProfile(new CourseProfile());
            mc.AddProfile(new CourseSessionProfile());
            mc.AddProfile(new CourseSessionQuizProfile());
            mc.AddProfile(new CourseSessionMediaProfile());
            mc.AddProfile(new EmployeeCourseSessionQuizAnswerProfile());

            mc.AddProfile(new DepartmentProfile());
            mc.AddProfile(new NonConformanceResponseTypeProfile());
            mc.AddProfile(new AuditTemplateProfile());
            mc.AddProfile(new AuditProfile());
            mc.AddProfile(new NonConformanceProfile());
            mc.AddProfile(new NonConformanceResponseProfile());

            mc.AddProfile(new CapaRequestProfile());
            mc.AddProfile(new CapaRootCauseMethodologyProfile());
            mc.AddProfile(new CapaReviewProfile());
            mc.AddProfile(new AuditResponseProfile());
            mc.AddProfile(new CapaRootCauseProfile());
            mc.AddProfile(new CapaActionProfile());
            mc.AddProfile(new CapaAttachmentProfile());

            mc.AddProfile(new RiskCategoryProfile());
            mc.AddProfile(new RiskProfile());
            mc.AddProfile(new RiskReviewProfile());
            mc.AddProfile(new RiskControlProfile());
            mc.AddProfile(new RiskAttachmentProfile());

            mc.AddProfile(new SupplierProfile());
            mc.AddProfile(new SupplierAuditProfile());
            mc.AddProfile(new SupplierContactProfile());
            mc.AddProfile(new SupplierPerformanceProfile());
            mc.AddProfile(new SupplierQualificationProfile());
            mc.AddProfile(new SupplierCertificationProfile());

            mc.AddProfile(new ComplaintTypeProfile());
            mc.AddProfile(new ComplaintProfile());
            mc.AddProfile(new ComplaintCommentProfile());
            mc.AddProfile(new ComplaintRootCauseProfile());
            mc.AddProfile(new ComplaintActionProfile());
            mc.AddProfile(new ComplaintInvestigationprofile());
            mc.AddProfile(new ComplaintAttachmentProfile());

            mc.AddProfile(new AuditReviewerProfile());
            mc.AddProfile(new AuditReviewCommentProfile());
            mc.AddProfile(new EmployeeCourceProfile());
            mc.AddProfile(new ModuleProfile());
        });
        return mappingConfig.CreateMapper();
    }
}
