﻿using AutoMapper;
using QualityManagement.Data.Dto;
using QualityManagement.Data.Entities;
using QualityManagement.MediatR;

namespace QualityManagement.API.Helpers.Mapping;

/// <summary>
/// NonConformanceResponseProfile is a mapping profile for AutoMapper that defines the mappings between
/// </summary>
public class NonConformanceResponseProfile : Profile
{
    /// <summary>
    /// NonConformanceResponse related entities and DTOs.
    /// </summary>
    public NonConformanceResponseProfile()
    {
        CreateMap<AddNonConformanceResponseCommand, NonConformanceResponse>();
        CreateMap<NonConformanceResponse, NonConformanceResponseDto>()
        .ForMember(ncr => ncr.NonConformanceResponseTypeName, opt => opt.MapFrom(src => src.ResponseType.Name))
        .ForMember(ncr => ncr.VerifiedName, opt => opt.MapFrom(src => src.VerifiedBy.FirstName + " " + src.VerifiedBy.LastName))
        .ForMember(ncr => ncr.ResponsiblePersonName, opt => opt.MapFrom(src => src.ResponsiblePerson.FirstName + " " + src.ResponsiblePerson.LastName));
        CreateMap<AddNonConformanceRespAttachmentCommand, NonConformanceRespAttachment>();
        CreateMap<NonConformanceRespAttachment, NonConformanceRespAttachmentDto>();
        CreateMap<NonConformanceRespAttachmentChunk, NonConformanceRespAttachmentChunkDto>();
        CreateMap<UpdateNonConformanceResponseCommand, NonConformanceResponse>();
    }
}
