﻿using AutoMapper;
using QualityManagement.Data.Dto;
using QualityManagement.Data.Entities;
using QualityManagement.MediatR;

namespace QualityManagement.API.Helpers.Mapping;

/// <summary>
/// NonConformanceResponseTypeProfile is a mapping profile for AutoMapper that defines the mappings between
/// </summary>
public class NonConformanceResponseTypeProfile : Profile
{
    /// <summary>
    /// NonConformanceResponseType related entities and DTOs.
    /// </summary>
    public NonConformanceResponseTypeProfile()
    {
        CreateMap<AddNonConformanceResponseTypeCommand, NonConformanceResponseType>();
        CreateMap<UpdateNonConformanceResponseTypeCommand, NonConformanceResponseType>();
        CreateMap<NonConformanceResponseType, NonConformanceResponseTypeDto>().ReverseMap();
    }
}
