﻿using AutoMapper;
using QualityManagement.Data;
using QualityManagement.Data.Dto;
using QualityManagement.MediatR;

namespace QualityManagement.API.Helpers.Mapping;

/// <summary>
/// PageHelperProfile is a mapping profile for AutoMapper that defines the mappings between
/// </summary>
public class PageHelperProfile : Profile
{
    /// <summary>
    /// PageHelperProfile constructor for initializing the mapping configuration.
    /// </summary>
    public PageHelperProfile()
    {
        CreateMap<PageHelperDto, PageHelper>().ReverseMap();
        CreateMap<CreatePageHelperCommand, PageHelper>();
        CreateMap<UpdatePageHelperCommand, PageHelper>();
    }
}
