﻿using AutoMapper;
using QualityManagement.Data;
using QualityManagement.Data.Dto;
using QualityManagement.MediatR;

namespace QualityManagement.API.Helpers.Mapping;

/// <summary>
/// ReminderProfile is a mapping profile for AutoMapper that defines the mappings between
/// </summary>
public class ReminderProfile : Profile
{
    /// <summary>
    /// ReminderProfile constructor for initializing the mapping configuration.
    /// </summary>
    public ReminderProfile()
    {
        CreateMap<Reminder, ReminderDto>().ReverseMap();
        CreateMap<AddReminderCommand, Reminder>();
        CreateMap<UpdateReminderCommand, Reminder>();
        CreateMap<ReminderNotification, ReminderNotificationDto>().ReverseMap();
        CreateMap<ReminderUser, ReminderUserDto>().ReverseMap();
        CreateMap<DailyReminder, DailyReminderDto>().ReverseMap();
        CreateMap<QuarterlyReminder, QuarterlyReminderDto>().ReverseMap();
        CreateMap<HalfYearlyReminder, HalfYearlyReminderDto>().ReverseMap();
        CreateMap<ReminderScheduler, ReminderSchedulerDto>().ReverseMap();
    }
}
