﻿using AutoMapper;
using QualityManagement.Data.Dto.RiskManagement;
using QualityManagement.Data.Entities;
using QualityManagement.MediatR;
using QualityManagement.MediatR.RiskManagement;

namespace QualityManagement.API.Helpers.Mapping
{
    public class RiskReviewProfile:Profile
    {
        public RiskReviewProfile()
        {
            CreateMap<AddRiskReviewCommand, RiskReview>();
            CreateMap<UpdateRiskReviewCommand, RiskReview>();
            CreateMap<RiskReview, RiskReviewDto>()
                .ForMember(dest=>dest.ReviewerName,opt=>opt
                .MapFrom(src=>src.Reviewer==null ? "" :src.Reviewer.FirstName + " " + src.Reviewer.LastName));
       
        
        }
    }
}
