﻿using Microsoft.AspNetCore.Builder;
using Microsoft.Extensions.DependencyInjection;

namespace QualityManagement.API;

internal class SpaStartup
{
    internal static void Configure(IApplicationBuilder app)
    {
        app.UseStaticFiles();
        app.UseSpaStaticFiles();
        app.UseSpa(spa =>
        {
            spa.Options.SourcePath = "ClientApp";
        });


        // here you can see we make sure it doesn't start with /api, if it does, it'll 404 within .NET if it can't be found
        app.MapWhen(x => !x.Request.Path.Value.StartsWith("/api"), builder =>
        {
            builder.UseRouting();
        });
    }

    internal static void ConfigureServices(IServiceCollection services)
    {
        services.AddSpaStaticFiles(configuration =>
        {
            configuration.RootPath = "ClientApp";
        });
    }
}
