﻿using QualityManagement.Data.Entities;
using System;
using System.Collections.Generic;

namespace QualityManagement.Data.Dto;

public class AuditDto
{
    public Guid Id { get; set; }
    public string Title { get; set; }
    public string AuditNumber { get; set; }
    public Guid AuditTemplateId { get; set; }
    public string DepartmentName { get; set; }
    public AuditTemplateDto AuditTemplate { get; set; }
    public Guid AuditorId { get; set; }
    public string AuditorName { get; set; }
    public AUDIT_STATUS Status { get; set; }
    public decimal EffectiveScore { get; set; }
    public decimal TotalScore { get; set; }
    public DateTime CreatedDate { get; set; }
    public ICollection<NonConformanceDto> NonConformances { get; set; } = new List<NonConformanceDto>();
    public ICollection<CapaRequestDto> CapaRequests { get; set; } = new List<CapaRequestDto>();
    public ICollection<AuditResponseDto> AuditResponses { get; set; } = new List<AuditResponseDto>();
    public ICollection<AuditReviewerDto> AuditReviewers { get; set; } = new List<AuditReviewerDto>();
    public ICollection<AuditReviewCommentDto> AuditReviewComments { get; set; } = new List<AuditReviewCommentDto>();
}