﻿using System;
using System.Collections.Generic;
using QualityManagement.Data.Entities;

namespace QualityManagement.Data.Dto;
public class AuditReportDetailsDto
{
    public Guid Id { get; set; }
    public string Title { get; set; }
    public string AuditNumber { get; set; }
    public Guid AuditTemplateId { get; set; }
    public string DepartmentName { get; set; }
    public AuditTemplateDto AuditTemplate { get; set; }
    public Guid AuditorId { get; set; }
    public string AuditorName { get; set; }
    public AUDIT_STATUS Status { get; set; }
    public decimal EffectiveScore { get; set; }
    public decimal TotalScore { get; set; }
    public DateTime CreatedDate { get; set; }
    public ICollection<NonConformanceDto> NonConformances { get; set; } = new List<NonConformanceDto>();
    public ICollection<CapaRequestDto> CapaRequests { get; set; } = new List<CapaRequestDto>();
    public ICollection<AuditQuestionResponseDto> AuditQuestionResponses { get; set; } = new List<AuditQuestionResponseDto>();
    public ICollection<AuditReviewerDto> AuditReviewers { get; set; } = new List<AuditReviewerDto>();
}
