﻿using System;
using System.Collections.Generic;
using QualityManagement.Data.Entities;

namespace QualityManagement.Data.Dto;
public class CapaRequestDto
{
    public Guid Id { get; set; }
    public string ReferenceNo { get; set; }
    public string Title { get; set; }
    public string Description { get; set; }
    public Guid? RaisedById { get; set; }
    public Guid? NonConformanceId { get; set; }
    public Guid? AuditId { get; set; }
    public Guid? AuditResponseId { get; set; }
    public string AuditName { get; set; }
    public string RaisedByName { get; set; }
    public CapaRequestStatus CapaRequestStatus { get; set; }
    public CapaRequestPriority Priority { get; set; }
    public DateTime? DueDate { get; set; }
    public string NcNumber { get; set; }
    public ICollection<CapaActionDto> CapaActions { get; set; } = new List<CapaActionDto>();
    public ICollection<CapaRootCauseDto> CapaRootCauses { get; set; } = new List<CapaRootCauseDto>();
    public ICollection<CapaAttachmentDto> CapaAttachments { get; set; } = new List<CapaAttachmentDto>();
    public ICollection<CapaReviewDto> CapaReviews { get; set; } = new List<CapaReviewDto>();
    public ICollection<AuditResponse> AuditResponses { get; set; } = new List<AuditResponse>();

}
