﻿using QualityManagement.Data.Entities;
using QualityManagement.Data.Entities.RiskManagment;
using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations.Schema;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace QualityManagement.Data.Dto.RiskManagement
{
    public class RiskDto
    {
        public Guid Id { get; set; }
        public string Title { get; set; }
        public string Description { get; set; }
        public Guid RiskCategoryId { get; set; }
        public string RiskCategoryName { get; set; }
        public int Likelihood { get; set; }
        public int Severity { get; set; } 
        public int RiskScore { get; set; }
        public string RiskLevel { get; set; }
        public RiskStatusEnum Status { get; set; }
        public Guid AssignedToId { get; set; }
        public string AssignedToName { get; set; }
        public Guid CreatedBy {  get; set; }
        public DateTime CreatedDate {  get; set; }
        public string CreatedByName { get; set; }
      
        public ICollection<RiskReviewDto> RiskReviews { get; set; }= new List<RiskReviewDto>();
        public ICollection<RiskControlDto> RiskControls { get; set; }=new List<RiskControlDto>();
        public ICollection<RiskAttachmentDto> RiskAttachments { get; set; } = new List<RiskAttachmentDto>();
    }
}
